/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class GameWindow
extends Canvas
implements PlatformIO {
    private Image _buffer;
    private Graphics _graphics;
    private static final int STATUS = 0;
    private static final int MAIN = 1;
    private static final int INPUT = 2;
    private static final int NUM_FONTS = 3;
    private Font[] _fonts = new Font[3];
    private FontMetrics[] _font_metrics = new FontMetrics[3];
    private Color[] _bg_colors = new Color[3];
    private Color[] _fg_colors = new Color[3];
    private String[] _font_names = new String[]{"Monospaced", "SansSerif", "Monospaced"};
    private int[] _font_sizes = new int[]{12, 12, 14};
    private String[] _fg_color_names = new String[]{"white", "black", "black"};
    private String[] _bg_color_names = new String[]{"blue", "white", "black"};
    private int _status_width = 0;
    private int _status_height = 0;
    private int _main_width = 0;
    private int _main_height = 0;
    private ScrollPane _scrollbar = null;
    private String _status_left = "";
    private String _status_right = "";
    private StatusLine _status_line = new StatusLine();
    private static final int EDGE_OFFSET = 5;
    private static final int SCROLLBACK_PAGES = 1;
    private boolean _loaded = false;
    private OutputFormatter _out = null;
    private int _cursor = 5;
    private int _print_line = 0;
    private static final int NONE = 0;
    private static final int LINE = 1;
    private static final int KEY = 2;
    private int _read_mode = 0;
    private Data _data = new Data();
    private StringBuffer _cur_command = new StringBuffer(80);
    private static final int HISTORY_SIZE = 10;
    private Vector _command_history = new Vector(11);
    private int _history_index = -1;
    private String _partial_command = null;
    String _load_error = null;

    public GameWindow(String[] stringArray, int[] nArray, String[] stringArray2, String[] stringArray3) {
        for (int i = 0; i < 3; ++i) {
            if (stringArray[i] != null) {
                this._font_names[i] = stringArray[i];
            }
            if (nArray[i] != 0) {
                this._font_sizes[i] = nArray[i];
            }
            if (stringArray2[i] != null) {
                this._fg_color_names[i] = stringArray2[i];
            }
            if (stringArray3[i] == null) continue;
            this._bg_color_names[i] = stringArray3[i];
        }
    }

    public void init_size(int n, int n2, int n3, ScrollPane scrollPane) {
        this._status_width = n;
        this._main_width = n2;
        this.setSize(n2, n3 * 1);
        this._scrollbar = scrollPane;
    }

    public void set_out(OutputFormatter outputFormatter) {
        this._out = outputFormatter;
    }

    public synchronized int size_text(String string) {
        return this._font_metrics[1].stringWidth(string);
    }

    public synchronized int size_text(char c) {
        return this._font_metrics[1].charWidth(c);
    }

    public synchronized void print_text(String string) {
        this._graphics.setFont(this._fonts[1]);
        this._graphics.setColor(this._fg_colors[1]);
        this._graphics.drawString(string, this._cursor, this._print_line);
        this._cursor += this._font_metrics[1].stringWidth(string);
    }

    public synchronized void print_error(String string) {
        this._load_error = string = "[" + string + "]";
        this._graphics.setFont(this._fonts[1]);
        this._graphics.setColor(this._fg_colors[1]);
        this.scroll_window();
        this._graphics.drawString(string, this._cursor, this._print_line);
        this._cursor += this._font_metrics[1].stringWidth(string);
        this.scroll_window();
        this.repaint();
    }

    public synchronized void scroll_window() {
        this.scroll_window(this._font_metrics[1].getHeight());
    }

    private synchronized void scroll_window(int n) {
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        this._graphics.copyArea(0, n, n2, n3 - n, 0, -n);
        this._graphics.setColor(this._bg_colors[1]);
        this._graphics.fillRect(0, n3 - n, n2, n);
        this._cursor = 5;
        this._scrollbar.setScrollPosition(0, this.getSize().height);
        this.repaint();
    }

    public synchronized void set_status_string(String string, boolean bl) {
        if (bl) {
            this._status_left = string;
        } else {
            this._status_right = string;
        }
        this._status_line.repaint();
    }

    public String read_key() {
        this.repaint();
        this.requestFocus();
        this._data.set(null);
        this._read_mode = 2;
        String string = this._data.get();
        this._read_mode = 0;
        return string;
    }

    public String read_line() {
        this.draw_cursor(true);
        this.repaint();
        this.requestFocus();
        this._data.set(null);
        this._read_mode = 1;
        String string = this._data.get();
        this._read_mode = 0;
        this.scroll_window();
        return string;
    }

    public boolean more_prompt(String string) {
        this.print_text(string);
        this.repaint();
        this.requestFocus();
        this._data.set(null);
        this._read_mode = 2;
        String string2 = null;
        while (string2 == null) {
            string2 = this._data.get();
            if (string2.equals(" ") || string2.equals("\\n")) continue;
            string2 = null;
        }
        this._read_mode = 0;
        this._cursor = 5;
        this._graphics.setColor(this._bg_colors[1]);
        int n = this._print_line - this._font_metrics[1].getAscent();
        int n2 = this._font_metrics[1].getHeight();
        this._graphics.fillRect(0, n, this.getSize().width, n2);
        return string2.equals(" ");
    }

    public void clear_screen() {
        this.scroll_window(this._main_height);
    }

    public void set_style(int n, boolean bl) {
        int n2 = this._fonts[1].getStyle();
        if (n == 0) {
            n2 = bl ? n2 | 1 : n2 & 0xFFFFFFFE;
        } else if (n == 1) {
            n2 = bl ? n2 | 2 : n2 & 0xFFFFFFFD;
        }
        this._fonts[1] = new Font(this._fonts[1].getName(), n2, this._fonts[1].getSize());
        this._font_metrics[1] = this._graphics.getFontMetrics(this._fonts[1]);
    }

    public void loaded(boolean bl) {
        this._loaded = bl;
    }

    public Component get_status_line() {
        return this._status_line;
    }

    protected synchronized void processKeyEvent(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getID() == 402) {
            return;
        }
        if (this._read_mode == 1) {
            if (keyEvent.getKeyCode() == 10) {
                this.draw_cursor(false);
                String string = this._cur_command.toString();
                this._data.set(string);
                this._cur_command.setLength(0);
                this._history_index = -1;
                if (string.length() > 0) {
                    if (this._command_history.size() == 0 || !this._command_history.elementAt(0).equals(string)) {
                        this._command_history.insertElementAt(string, 0);
                    }
                    if (this._command_history.size() > 10) {
                        this._command_history.removeElementAt(this._command_history.size() - 1);
                    }
                }
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                if (keyEvent.getKeyCode() == 38 && (this._history_index < -1 || this._history_index >= this._command_history.size() - 1) || keyEvent.getKeyCode() == 40 && (this._history_index < 0 || this._history_index >= this._command_history.size())) {
                    return;
                }
                this.draw_cursor(false);
                this._graphics.setFont(this._fonts[2]);
                this._graphics.setColor(this._bg_colors[1]);
                String string = this._history_index == -1 ? this._cur_command.toString() : (String)this._command_history.elementAt(this._history_index);
                this._cursor -= this._font_metrics[2].stringWidth(string);
                this._graphics.drawString(string, this._cursor, this._print_line);
                if (this._history_index == -1) {
                    this._partial_command = string;
                }
                this._history_index = keyEvent.getKeyCode() == 38 ? ++this._history_index : --this._history_index;
                string = this._history_index == -1 ? this._partial_command : (String)this._command_history.elementAt(this._history_index);
                this._graphics.setColor(this._fg_colors[2]);
                this._graphics.drawString(string, this._cursor, this._print_line);
                this._cursor += this._font_metrics[2].stringWidth(string);
                this.draw_cursor(true);
                this._cur_command.setLength(0);
                this._cur_command.append(string);
            } else if (keyEvent.getKeyCode() == 8 && this._cur_command.length() > 0) {
                this.draw_cursor(false);
                char c = this._cur_command.charAt(this._cur_command.length() - 1);
                n = this._font_metrics[2].charWidth(c);
                int n2 = this._print_line - this._font_metrics[2].getAscent();
                this._cursor -= n;
                this._graphics.setColor(this._bg_colors[1]);
                this._graphics.fillRect(this._cursor, n2, n, this._font_metrics[2].getHeight());
                this.draw_cursor(true);
                this._cur_command.setLength(this._cur_command.length() - 1);
                this._history_index = -1;
            } else if (keyEvent.getID() == 400 && !Character.isISOControl(keyEvent.getKeyChar())) {
                this.draw_cursor(false);
                this._graphics.setFont(this._fonts[2]);
                this._graphics.setColor(this._fg_colors[2]);
                String string = "" + keyEvent.getKeyChar();
                this._graphics.drawString(string, this._cursor, this._print_line);
                this._cursor += this._font_metrics[2].stringWidth(string);
                this.draw_cursor(true);
                this._history_index = -1;
                this._cur_command.append(keyEvent.getKeyChar());
            }
        } else if (this._read_mode == 2) {
            if (keyEvent.getKeyCode() == 8) {
                this._data.set("[bksp]");
            } else if (keyEvent.getKeyCode() == 127) {
                this._data.set("[del]");
            } else if (keyEvent.getKeyCode() == 40) {
                this._data.set("[down]");
            } else if (keyEvent.getKeyCode() == 35) {
                this._data.set("[end]");
            } else if (keyEvent.getKeyCode() == 10) {
                this._data.set("\\n");
            } else if (keyEvent.getKeyCode() == 27) {
                this._data.set("[esc]");
            } else if (keyEvent.getKeyCode() == 112) {
                this._data.set("[f1]");
            } else if (keyEvent.getKeyCode() == 113) {
                this._data.set("[f2]");
            } else if (keyEvent.getKeyCode() == 114) {
                this._data.set("[f3]");
            } else if (keyEvent.getKeyCode() == 115) {
                this._data.set("[f4]");
            } else if (keyEvent.getKeyCode() == 116) {
                this._data.set("[f5]");
            } else if (keyEvent.getKeyCode() == 117) {
                this._data.set("[f6]");
            } else if (keyEvent.getKeyCode() == 118) {
                this._data.set("[f7]");
            } else if (keyEvent.getKeyCode() == 119) {
                this._data.set("[f8]");
            } else if (keyEvent.getKeyCode() == 120) {
                this._data.set("[f9]");
            } else if (keyEvent.getKeyCode() == 121) {
                this._data.set("[f10]");
            } else if (keyEvent.getKeyCode() == 36) {
                this._data.set("[home]");
            } else if (keyEvent.getKeyCode() == 155) {
                this._data.set("[ins]");
            } else if (keyEvent.getKeyCode() == 37) {
                this._data.set("[left]");
            } else if (keyEvent.getKeyCode() == 34) {
                this._data.set("[page down]");
            } else if (keyEvent.getKeyCode() == 33) {
                this._data.set("[page up]");
            } else if (keyEvent.getKeyCode() == 39) {
                this._data.set("[right]");
            } else if (keyEvent.getKeyCode() == 9) {
                this._data.set("\\t");
            } else if (keyEvent.getKeyCode() == 38) {
                this._data.set("[up]");
            } else {
                char c = keyEvent.getKeyChar();
                if (c != '\uffff' && !Character.isISOControl(keyEvent.getKeyChar())) {
                    if (keyEvent.isAltDown()) {
                        this._data.set("[alt-" + Character.toLowerCase(c) + "]");
                    } else if (keyEvent.isControlDown()) {
                        if (c >= '\u0001' && c <= '\u001a') {
                            this._data.set("[ctrl-" + (char)(c - '\u0001' + 97) + "]");
                        }
                    } else {
                        this._data.set(new Character(c).toString());
                    }
                }
            }
        } else {
            return;
        }
        int n3 = this._font_metrics[2].getHeight();
        n = this._print_line - this._font_metrics[2].getAscent();
        this.repaint(0, n, this.getSize().width, n3);
    }

    protected synchronized void processMouseEvent(MouseEvent mouseEvent) {
        this.requestFocus();
        super.processMouseEvent(mouseEvent);
    }

    private void draw_cursor(boolean bl) {
        int n = this._print_line - this._font_metrics[2].getAscent();
        int n2 = this._font_metrics[2].stringWidth(" ");
        int n3 = this._font_metrics[2].getAscent() + this._font_metrics[2].getDescent();
        if (bl) {
            this._graphics.setColor(this._bg_colors[2]);
            this._graphics.fillRect(this._cursor, n, n2, n3);
            this._cursor += n2;
        } else {
            this._graphics.setColor(this._bg_colors[1]);
            this._cursor -= n2;
            this._graphics.fillRect(this._cursor, n, n2, n3);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this._buffer == null || this._buffer.getWidth(this) != this.getSize().width || this._buffer.getHeight(this) != this.getSize().height) {
            this.reset();
        }
        if (this._buffer == null) {
            return;
        }
        if (!this._loaded) {
            graphics.setColor(this._bg_colors[1]);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(this._fg_colors[1]);
            String string = "Loading game, please be patient";
            if (this._load_error != null) {
                string = this._load_error;
                graphics.setFont(new Font("Courier", 0, 12));
            } else {
                graphics.setFont(new Font("Courier", 0, 24));
            }
            graphics.drawString(string, 5, this.getSize().height - this._main_height / 2);
            this._scrollbar.setScrollPosition(0, this.getSize().height);
            return;
        }
        graphics.drawImage(this._buffer, 0, 0, this);
    }

    public synchronized void reset() {
        int n;
        this.disableEvents(24L);
        this._buffer = this.createImage(this.getSize().width, this.getSize().height);
        this._graphics = this._buffer.getGraphics();
        for (n = 0; n < 3; ++n) {
            Object object;
            String[] stringArray;
            try {
                stringArray = this.getToolkit().getFontList();
            }
            catch (NullPointerException nullPointerException) {
                object = new String[]{"Monospaced", "SansSerif"};
                stringArray = new String[((String[])object).length];
                System.arraycopy(object, 0, stringArray, 0, ((String[])object).length);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this._font_names[n], ";,");
            block3: while (stringTokenizer.hasMoreTokens() && this._fonts[n] == null) {
                object = stringTokenizer.nextToken().trim();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(object)) continue;
                    this._fonts[n] = new Font((String)object, 0, this._font_sizes[n]);
                    break block3;
                }
            }
            if (this._fonts[n] == null) {
                this._fonts[n] = new Font("not found", 0, this._font_sizes[n]);
                System.err.println("Can't find a font, making up one");
            }
            this._font_metrics[n] = this._graphics.getFontMetrics(this._fonts[n]);
            this._bg_colors[n] = this.lookup_color(this._bg_color_names[n]);
            this._fg_colors[n] = this.lookup_color(this._fg_color_names[n]);
        }
        this._print_line = this.getSize().height - 5 - Math.max(this._font_metrics[1].getMaxDescent(), this._font_metrics[2].getMaxDescent());
        this._graphics.setColor(this._bg_colors[1]);
        this._graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this._main_width = this.getSize().width - (this._status_width - this._main_width);
        this._status_width = this.getSize().width;
        this._main_height = this.getSize().height / 1;
        this._status_height = this._font_metrics[0].getHeight();
        if (this._out != null) {
            n = this._main_height / this._font_metrics[1].getHeight();
            this._out.resize(this._main_width - 10, n);
        }
        this.enableEvents(24L);
        this.invalidate();
        this._status_line.invalidate();
    }

    private Color lookup_color(String string) {
        if ((string = string.toLowerCase()).startsWith("#")) {
            return Color.decode(string);
        }
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("darkgray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("lightgray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        System.err.println("Unknown color: '" + string + "'");
        return Color.black;
    }

    private static class Data {
        private String txt = null;

        private Data() {
        }

        public synchronized String get() {
            while (this.txt == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.txt;
        }

        public synchronized void set(String string) {
            this.txt = string;
            this.notify();
        }
    }

    class StatusLine
    extends Canvas {
        StatusLine() {
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (GameWindow.this._font_metrics[0] == null) {
                return new Dimension(0, 0);
            }
            int n = Integer.MAX_VALUE;
            int n2 = GameWindow.this._font_metrics[0].getHeight();
            return new Dimension(n, n2);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (GameWindow.this._font_metrics[0] == null) {
                graphics.setColor(GameWindow.this._bg_colors[1]);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                return;
            }
            graphics.setColor(GameWindow.this._bg_colors[0]);
            int n = GameWindow.this._font_metrics[0].getHeight();
            graphics.fillRect(0, 0, this.getSize().width, n);
            graphics.setFont(GameWindow.this._fonts[0]);
            graphics.setColor(GameWindow.this._fg_colors[0]);
            graphics.drawString(GameWindow.this._status_left, 5, GameWindow.this._font_metrics[0].getAscent());
            int n2 = this.getSize().width - 5 - GameWindow.this._font_metrics[0].stringWidth(GameWindow.this._status_right);
            graphics.drawString(GameWindow.this._status_right, n2, GameWindow.this._font_metrics[0].getAscent());
        }
    }
}

