"A Roiling Original" by Andrew Schultz

volume browsing and building notes

[This initial section is to try and organize the source code. Of course, with a 2 million+ byte file, it's sort of tough to figure where to start. I can't promise that my code is super-readable, but I hope you find it interesting. It's been vetted all the way through, once.

To search for your favorite goofy random tables, use ^blurb with a regular-expression search for editors that allow them, such as notepad++ in Windows, which is well worth a download. You can also search for (bracket) then xx(first letter) with g = general (for example, blank command/wait responses) or m=manor (for example, comedians Gunter mentions) or v = gritty dialogue, and so forth. XX alone is a (poorly-named) variable in some places, but searching with the bracket and then XX will cover everything.

The new Inform IDE may allow you to search this way, too. For A Roiling Original, I stuck with 6G60. I had enough changes to deal with.

You can place a bracket before any of the other text chunks below to search. They're ordered in approximate priority I used and how often I searched for them.
TOA = the table of big point scoring changes, table of anagrams
TOH = table of hint logic
TON = nudge for good guesses
TSH = specific help for specific items you have the right anagram for
TMC = mega-chatter, which logs all the tables I search lists for
TAF = after-texts, which logs everything said after scanning stuff. Used to help clue the player if something is confusing, whether it's a question mark or vowels/consonants not lining up
TOR = reflexive blather, asking people about themselves (this is often a default)table of reflexive-blather      [ask x about x] [tor]
TOD = default gen blather, about general nonsense e.g. a misunderstood request
DSB = default subject blather, about a specific topic. If an NPC has no entry, it goes to TOD.
TOB = read ALL the book titles!
TOSB = subj-blather, about a specific subject
TNW = messages for "you can't go that way"
TSX  = differences between sexes
TSH = table of spechelp, so you can see the specialized help for an item
TSR = table of specreject, which gives specialized responses for if you try to flip something that doesn't need it any more
DMT = dome tables, text from Demo Dome section

VRT = VOLUME RANDOM TEXT BLURB TABLES has the random text.

Volumes are divided by region for the most part.
]

[you may need special versions of certain modules. They can be found at

http://code.google.com/p/shuffling-around/downloads/list

Glulx Text Effects.i7x
Flexible Windows.i7x

Are the two modified, and there may be a problem with naming Flexible Windows.i7x / Glulx Text Effects.i7x and a 'new' version. So if Inform says there are 2 of one table, you may be reading Glulx Text Effects.i7x and Glulx Text Effects - New.i7x. This is mostly my laziness. But until then I want this caveat in.

]

volume globals

include Reactable Quips by Michael Martin.

include Quip-based Conversation by Michael Martin. [his extensions must be listed in this order]

include Basic Screen Effects by Emily Short.

include Glimmr Drawing Commands by Erik Temple.

include Glimmr Bitmap Font by Erik Temple.

include undo output control by Erik Temple.

include conditional undo by Jesse McGrew.

include Bypass Disambiguation by Climbing Stars.

include Large Game Speedup by Andrew Plotkin.

the story headline is "(or ailing) Squeeal! A Sequel!"

the story description is "Dear, Lo! Ordeal reload!"

release along with cover art.

the release number is 3.

a region has a number called max-score. a region has a number called min-score.

a region has a number called poss-score. a region has a number called cur-score.

a region can be solved, unsolved, needed, shortcircuited, bypassed or frivolous. a region is usually needed.

a region has a room called last-loc.

a region has a number called turns-spent. a region has a number called last-hint-turns. last-hint-turns of a region is usually 10.

a region can be unspoiled or spoiled. a region is usually unspoiled.

a region can be parsewrned. a region is usually not parsewrned.

a region has a list of things called item-list.

a person has a person called the chum. [a chum is someone whom they imitate in dialogue. For instance, Rand's chum is Leo. All warriors' chums are Andres. And so on.]

to rulesOn:
	(- RulesOnSub(); -)

when play begins (this is the table scramble and index rule) :
	let mycount be 0;
	repeat through table of megachatter:
		now done-once entry is false;
		if there is a mytab entry:
			sort mytab entry in random order;
		unless there is a reps entry:
			now reps entry is 1;
		if there is no curidx entry:
			now curidx entry is 0;
		if there is no maxidx entry or maxidx entry is 0:
			if there is a mytab entry:
				now maxidx entry is number of rows in mytab entry;
		if there is no maxbeforepause entry:
			now maxbeforepause entry is 40;
		increment mycount;
		now init-order entry is mycount;
		if there is a mytab entry:
			now table-size entry is number of rows in mytab entry;
	prio-sort table of random books: [this puts certain books in front, which may give various clues. It was probably more a thought experiment than anything.]

to prio-sort (ta - table name):
	let temp be 0;
	repeat through ta:
		if there is a prio entry:
			now prio entry is a random number from 1 to prio entry;
		else:
			increment temp;
			now prio entry is temp;
	sort ta in prio order;

chat-rand is a truth state that varies.

every turn (this is the process random dialogue rule) :
	if current action is hinting:
		do nothing instead;
	if current action is fliptoing:
		do nothing instead;
	now chat-rand is true;
	consider the find-blather rule;
	now chat-rand is false;

[find-blather is what is used for random dialogue. It relies on the table of megachatter.]

this is the find-blather rule:
	let zz be 0;
	repeat through table of megachatter:
		if eturn entry is chat-rand:
			if there is a go-ahead entry:
				consider the go-ahead entry;
				if the rule succeeded:
					if chat-rand is true and talk-quiet is true and done-once entry is true:
						the rule succeeds;
					now done-once entry is true;
					increment curidx entry;
					if curidx entry > maxidx entry:
						if there is a lasties entry:
							say "[lasties entry]";
							now curidx entry is 0;
							the rule succeeds;
						else:
							say "You feel a sense of deja vu.[paragraph break]";
							now curidx entry is 1;
					if there is a prefix entry:
						say "[prefix entry]";
					let whrow be curidx entry;
					let posties be suffix entry;
					choose row whrow in mytab entry;
					say "[blurb entry][posties][line break]";
					if chat-rand is true:
						if talk-quiet is true:
							say "[line break]";
							ital-say "the above was random dialogue that won't be repeated since you have HUSH on. You can undo this with UHHS.";
						if quiet-warn is false:
							ital-say "the above was random dialogue that can be turned off with HUSH or on with UHHS. If you forget this, it's in your notepad. Also, if you want all the dialogue, no need to hit Z a ton. You can read the source or, to see it formatted a bit better, solve the game.";
							pad-rec-q "random dialogue";
							now quiet-warn is true;
					the rule succeeds;

[randbla is used for stuff you examine.]

wrap-note is a truth state that varies.

wrap-note-ver is a truth state that varies.

to say randbla:
	say "[run paragraph on]";
	let booknote be false;
	let adnote be false;
	repeat through table of megachatter:
		if eturn entry is chat-rand:
			if there is a go-ahead entry:
				consider the go-ahead entry;
				if the rule succeeded:
					increment curidx entry;
					if curidx entry > maxidx entry:
						if there is a lasties entry:
							say "[lasties entry]";
							now curidx entry is 0;
							the rule succeeds;
						else:
							[say "(generic note that random text is cycling)[paragraph break]";]
							now curidx entry is 1;
					if there is a prefix entry:
						say "[prefix entry]";
					let whrow be curidx entry;
					let posties be suffix entry;
					if mytab entry is table of random books:
						now booknote is true;
					if mytab entry is table of ad slogans:
						now adnote is true;
					if reps entry is 1 or reps entry is 0:
						choose row whrow in mytab entry;
						say "[blurb entry][posties]";
					else:
						let repnum be maxidx entry - curidx entry + 1;
						if repnum > reps entry:
							now repnum is reps entry;
							increase curidx entry by repnum - 1; [this is sloppy code but I can't think of another way to take care of this special case]
						else:
							now curidx entry is 0;
						d "[curidx entry] vs [maxidx entry]. Repnum is [repnum].";
						let thistab be mytab entry;
						repeat with county running from 1 to repnum:
							choose row whrow in thistab;
							say "[blurb entry] ";
							increment whrow;
					if wrap-note is false and whrow > 5: [this is a magic number, to see if the person is really examining something.]
						now wrap-note is true;
					the rule succeeds;

every turn when wrap-note is true and wrap-note-ver is false (this is the alert you don't have to gawk rule) :
	ital-say "you've been repeating looking up something with random text a lot--something with at least ten entries and possibly much more. If you solve the game, you can see it all. Thanks for your (apparent) interest! Oh, you can browse the source code for a chunk of text, too, and it shouldn't spoil the game, since it's all in a table. Just remember single apostrophes have a bracket on each side.";
	now wrap-note-ver is true;

to ital-say (x - indexed text):
	say "[italic type][bracket]NOTE: [x][close bracket][roman type][line break]";

to ital-say-n (x - indexed text):
	say "[italic type][bracket]NOTE: [x][close bracket][roman type]";

to say c-c-u:
	say " [if circle is visited]in the Cleric Circle[else](Routes)[end if]";

to say indic of (reg - a region):
	if last-loc of reg is unvisited:
		say " ([reg])"

to say lby: [stupid and awkward looking, but needed to make line breaks only when necessary. Basically, at the end of game, always break. Some megachatter doesn't need a break at the end. All lasties entries have LBY or LBN.]
	say "[if current action is liliing][paragraph break][else][line break][end if]";

to say lbn:
	if current action is liliing:
		say "[paragraph break]";

die-trigger is a number that varies.
die-to-us is a truth state that varies.

to say ted-die:
	if die-trigger > 0:
		decrement die-trigger;
		say "[if die-trigger is 0]'Die to us!' the lecturer yells, as he points at someone who may or may not be using drugs. 'To use...I'd...' the poor soul mumbles as he is slapped up and carted off. You see red at what must be either harsh injustice or appalling acting[else]Man, it's all so [i]tedious[r][end if]";
	else if a random chance of 1 in 4 succeeds:
		say "After that ... incident, everything is back to [i]tedious[r]";

table of megachatter [tmc] [may not be alphabetized since some rules must come before others]
mytab	eturn	curidx	maxidx	go-ahead	whichreg	descr	prefix	suffix	lasties	maxbeforepause	done-once	init-order	table-size	reps
table of undo rejects	false	0	0	undo-rej rule	lll	"Undo rejects"	--	""	"'Do-over overdo.'"
table of undo allows	false	0	0	undo-ok rule	lll	"Successful undo responses"	--	""	"'Do? Er, re-do.' (Last one. Stale? NO.)"
table of random books	false	0	0	read-books rule	manor	"All the books in your bookshelf"	"[i]"	"[r]"	"our own aborted autobiography. You're embarrassed by what's there and how little is there. It was buried at the back.[paragraph break]Whew, that's everything. The only thing less exciting than re-reading all the titles would be to stare at a computer screen for a few hours."	--	--	--	--	1
table of ad slogans	true	0	0	blurby rule	manor	"All the ads in the Dope Op-Ed"	--	""	"HANKER! HARKEN! you read. With that general ad, it's back to the start."
table of mob chants	false	0	0	mob-chanting rule	manor	"Mob chants (LISTEN post-Gunter in manor)"	"[one of]Shouty youths. Long-[a-word] slogans. [or]Bam-o! A mob! [stopping]"	"[line break]"	"They finish fishin[']."
table of idiotic lecture points	true	0	0	lecture-point rule	stores	"Cruelest Lectures advice[if tokers are off-stage or nestor is off-stage] (STORE N/STORE K mini-puzzle)[else if lectures is unvisited] (way high highway in Strip of Profits)[end if]"	"The lecturer "	" [ted-die]."	"The lecturer flips back to the start of his keystone keynotes, resuming his ol['] mongo monolog.[lby]"	20
table of overdone movies	true	0	0	name-movie rule	stores	"Cruelest Lectures movies[if tokers are off-stage or nestor is off-stage] (STORE N/STORE K mini-puzzle)[else if lectures is unvisited] (way high highway in Strip of Profits)[end if]"	"The lecturer alludes to "	""	--	20
table of sicko movies	false	0	0	movie-over-ad rule	stores	"Store C videos (parental advisory)"	"You peruse the movies: "	""	--	--	false	0	0	5
table of store c competitors	false	0	0	compet-over-ad rule	stores	"Store C competitors"	"You're promised better prices and service than "	"."	"Finally, there's a put-down of Twisted Twit Ed's."
table of store c ads	false	0	0	read-c rule	stores	"Store C advertisements (parental advisory)"	--	""	"'Wanker? Ew, rank!' someone hisses at you. Yup, you've been reading a while."
table of tokers nonsense	true	0	0	ohai-tokers rule	stores	"The tokers['] chat[if tokers are off-stage and nestor is off-stage] (flip STORE K and STORE N in Strip of Profits)[end if]"	--	""	"'No weed? We done!' but they find some more, ready to repeat. You may wish to HUSH them to zone them out as they zone out."
table of moralizers	false	0	0	read-pious-1 rule	routes	"Moralizers[c-c-u]"	--	""	--
table of rev ali advice	false	0	0	read-pious-2 rule	routes	"Rev. Ali's musings[c-c-u]"	--	"!"	"an epilogue hand-written in: [i]sad, rash [if censor-minor is true](mean name)[else]hardass[end if][r], which is refreshing."
table of horbert musings	true	0	0	horby rule	routes	"Brother Horbert's musings[c-c-u]"	"Brother Horbert mumbles something to himself... [i]"	"[r]"	"Brother Horbert mumbles [i]Ah, even heaven...[r] A pause. His thoughts may loop again--like people's wanderings in the mesa."	40
table of horbert farewells	false	0	0	horb-bye rule	routes	"Brother Horbert's blessings[c-c-u]"	"Brother Horbert speaks as you leave: [i]"	"[r][line break]"	"Brother Horbert's face shows neat, epic patience as you leave, again."	40
table of missing deli foods	false	0	0	ask-deli rule	routes	"Non-foods at the Idle Deli[indic of routes]"	--	""
table of checklist items	false	0	0	read-tec rule	troves	"SlickTech Checklist to-dos[indic of troves]"	--	""	"Wow! That's a lot to do. You need to sit and think and build up to believing you can do it all. And quickly."
table of DIVORCES articles	false	0	0	read-divorces rule	troves	"'Fascinating' DIVORCES articles[indic of troves]"	--	""	"an interview with an influential mayor who knows what's what: Ah, Mr. Harm![paragraph break]Well, they saved the worst for last. You could reread if you want."
table of ethics advice	false	0	0	read-eths rule	troves	"Advice from Pa, Egg, Pea[eisiping]"	"[one of]There is some blurb about how REAL CHANGE COMES FROM WITHIN and how you shouldn't look to change a clover into Velcro or any such nonsense. Also how this book is better than [i][twiddle of table of self-help bestsellers and 3][r].[paragraph break][or][stopping]One random  'thought-improving' passagefrom Peg A. Page reads: "	""	"You've reached the end, filled with crappiest tips recap. Rereading may or may not be less painful the second time through."
table of gritty dialogue	true	0	0	say-gritty rule	troves	"Gritty Spoiloplis dialogue[indic of troves]"	"Gritty sounds come, then go, from [one of]your testers, the tersest[or]the[stopping] streets: "	""	"Tense silence replaces the gritty sounds, which will probably return and cycle. People making the same mistakes they did before. But you are bound for better things--or, with that book, you'd better be."
table of non-checklists	false	0	0	desk-look rule	troves	"Slick-Tech Checklist alternatives[if fiefco is unvisited] (Troves)[end if]"	--	""
table of posh dialogue	true	0	0	say-posh rule	troves	"Posh Spoiloplis dialogue[indic of troves]"	"Upper-class concerns: "	""	"A low, snide 'Old is new, wild ones.' Cue repetition."
table of posse bosses	false	0	0	in-bvd rule	troves	"Rusin['] Used Lot. bad guys[indic of troves]"	"maybe "	""	"not Mean Roy Maroney, anymore--he's the last of them"
table of real estate ads	false	0	0	read-brochure rule	troves	"Rotunda brochure locations[indic of troves]"	"It's for real estate by Sir Dee. One page header blares [i]Home's so Meh? "	".[r][paragraph break]The page-end reads RESIDE! RESIDE! RESIDE!"	"Secretcester! OWN NOW! is the final entry."
table of Leo and Rand chitchat	true	0	0	Leo-Rand-cry rule	presto	"Leo and Rand's chatter[if rand is fightin] (STORE P)[end if]"	--	""	"'Heya.' / 'Yeah?' An awkward silence follows.[paragraph break]They've run out of conversation, but fortunately (for them,) they forgot it all, so they can just restart."
table of catechism pages	false	0	0	catechism-over-research rule	presto	"Hacks['] shack catechism entries[indic of presto]"	--	""	"After the final 'Ok, worn? Work on or know,' only a nixed-pap Appendix is left. But for reading this, appoint you a rarest raster starer. Have an, er, star."
table of research topics	false	0	0	read-text rule	presto	"[one of]Some[or]More[stopping] explanation of Arch Ree's research:[indic of presto]"	"Arch Ree's[one of][or] further[stopping] research on "	"."
table of bar dialogue	true	0	0	bar-over-comp rule	oyster	"Posh Hops Shop action[indic of oyster]"	"[one of]Whew. Rough talk and action here. [or]More rough talk and action. [or][stopping]" 	""	"You've seen it all. Time to take decisive action(s) of your own."
table of competing bars	true	0	0	in-bar rule	oyster	"Posh Hops Shop competitors[indic of oyster]"	"Someone says the Posh Hops Shop [one of]has nothing on[or]sure beats[at random] "	"."
table of Casper mumbles	false	0	0	casper-talk rule	oyster	"Casper's mumblings[indic of oyster]"	""	""
table of fish fries	true	0	0	insult-over-girls rule	oyster	"Carps/pikes trout-bullying [if anger range is visited]in anger range[else](STORE Y)[end if]"	--	""	"The bullies call him 'A soft fatso so fat.' They're out of ideas and claim it's the trout's fault for not being interesting enough. The ratters restart samer smear-reams."
table of unpopular girls	true	0	0	ohai-bullies rule	oyster	"Unpopular girls carps/pikes mention[indic of oyster]"	"The bullies insinuate the trout [one of]likes[or]isn't good enough for[cycling] "	"."	"Zina is the last, and wrongest, girl they accuse the trout of liking."
table of tuna gossip	true	0	0	gossip-over-chatter rule	oyster	"Aunt Tuna's gossip[indic of oyster]"	"Aunt Tuna gossips: "	""	"'Edda Dade. Dead. Cleo's Close. Dorithy--Thyroid. Halle's a shell. All she... Heather's Heart. She... diabetes, die, beast!' Aunt Tuna pauses, head in hands. That was the final thing she'd been repressing."
table of aunt tuna chatter	true	0	0	ohai-tuna rule	oyster	"Aunt Tuna's complaints[indic of oyster]"	"[one of]'Oh, dear! Do hear!' / 'D'oh...are...' Aunt Tuna cuts you off and[or]Aunt Tuna[stopping] "	""	"Aunt Tuna, as her nags snag, restarts her prattle platter of how she is BEYOND done-by..."
table of theses	false	0	0	screed-read rule	oyster	"Theses Sheets notes[indic of oyster]"	""	""	"Life Conks Nice Folks![paragraph break]Well, that's probably enough proof you're dealing with bad guys, here."
table of rodney bluster	true	0	0	rodney-here rule	towers	"Rodney's bluster[indic of towers]"	"Rodney [if number of visible warriors is 7]informs his gang[else if number of visible warriors > 3]yells at his remaining troops[else if number of visible warriors is 2]yells to his remaining companion[else]mutters to himself[end if] about "	"."	"repeating, then inept rage and a petering."
table of gizmo parts	false	0	0	gizmo-x rule	towers	"Parts of the I ZOMG GIZMO[indic of towers]"	--	""	"Ulti-Util, the most powerful, confusing and hidden of all the gizmo parts"
table of Elmer and Merle squabbles	true	0	0	alcove-talk rule	otters	"Elmer and Merle's chat"	--	""	"Since they're kinda evil, or at least serving someone evil, they give a greedy look as they restart their complaint routines."
table of Elvira battle cries	false	0	0	last-battle rule	otters	"Elvira's battle cries"	--	""	""
table of Elvira machines	false	0	0	bzzt rule	otters	"Elvira's machines"	--	""	""
table of Elvira taunts	false	0	0	Elvira-taunt rule	otters	"Elvira's taunts"	--	""	"'Stellar staller!'  Dang, the simplest ones hurt the most."
table of animal friends	false	0	0	bzzt rule	otters	"Your animal friends"	--	""
table of political slogans	false	0	0	sloganing rule	others	"Political slogans"	--	""
table of selly yells	false	0	0	clearing-listen rule	others	"Selly Yells[indic of others]"	""	""	"A big errant inert brag pauses the bartering for a minute."
table of singing rejects	false	0	0	is-singing rule	lll	"Rejects for singing"	--	""	"Sing-ings! Sing-ings!"
table of empty command rejects	false	0	0	ibyp rule	lll	"Responses to an empty command"	--	""	"Go for it or I GTFO! (this is the last blank response and an empty threat to boot.)"	--	false	0	0	1
table of wait responses	false	0	0	i-wait rule	lll	"Wait/Z messages"	--	""	"A lag gala.[no line break]"
table of cussing rejects	false	0	0	amcuss rule	lll	"How the game blocks profanity, mild or obscene"	--	""	"Screed on, [bracket]CENSORED[close bracket].[no line break]"
table of nonviolence messages	false	0	0	amatt rule	lll	"How the game blocks ATTACK"	--	""	"Ill touch? Chill out till...ouch!"
table of death messages	false	0	0	bzzt rule	lll	"Death notices"	--	""
table of help companies	false	0	0	bzzt rule	lll	"Hint guy t-shirt writing[if have-objhinted is false] (occurs first time you request hints)[end if]"	--	""
table of elmo emo	false	0	0	bzzt rule	manor	"Elmo's romantic complaints[if girls-quip is not mowered] (off-topic Elmo chat)[end if]"	""	""
table of sports chatter	false	0	0	bzzt rule	manor	"Elmo's sports banter[if sports-quip is not mowered] (off-topic Elmo chat)[end if]"	""	""
table of biopics	false	0	0	bzzt rule	manor	"Biopics, good and bad[if media-quip-2 is not mowered] (off-topic Elmo chat)[end if]"	""	""
table of bad rappers	false	0	0	bzzt rule	manor	"Bad rap music[elv-art]"	--	""
table of lame computer games	false	0	0	bzzt rule	manor	"Computer games[elv-art]"	--	""
table of comedians	false	0	0	bzzt rule	manor	"Comedians of Yorpwald[unless pun-quip is mowered] (with Gunter, lighten the mood with a joke)[end if]"	""	""
table of laughhouses	false	0	0	bzzt rule	manor	"Comedy joints[unless pun-quip is mowered] (with Gunter, lighten the mood with a joke)[end if]"	""	""
table of lame talk shows	false	0	0	bzzt rule	manor	"Bad talk shows[unless media-quip-2 is mowered] (complain about the media some more to Elmo)[end if]"	--	""
table of lame movies	false	0	0	bzzt rule	manor	"Bad movies[elv-art]"	""	""
table of lame tv shows	false	0	0	bzzt rule	manor	"Bad TV shows[elv-art]"	""	""
table of oldies singers	false	0	0	bzzt rule	manor	"Initial oldies singers[elv-art]"	""	""
table of lousy hit songs	false	0	0	bzzt rule	manor	"Bad songs[elv-art]"	--	""
table of self-help bestsellers	false	0	0	bzzt rule	troves	"Self-help bestsellers[eisiping]"	--	""
table of songs you could write	false	0	0	bzzt rule	troves	"Songs you write on solving Troves"	--	""
table of sleep rejects	false	0	0	am-sleeping rule	lll	"Sleeping rejects"	--	""
[tmc]

this is the am-sleeping rule:
	if current action is sleeping:
		the rule succeeds;
	the rule fails;

this is the sloganing rule:
	if player is in gates stage and current action is going north:
		the rule succeeds;
	the rule fails;

this is the undo-ok rule:
	if currently-undoing is true:
		the rule succeeds;
	the rule fails;

this is the undo-rej rule:
	if currently-rejecting is true:
		the rule succeeds;
	the rule fails;

this is the clearing-listen rule:
	if player is in clearing and current action is listening:
		the rule succeeds;
	the rule fails.

this is the is-singing rule:
	if current action is singing:
		the rule succeeds;
	the rule fails.

this is the last-battle rule:
	if current action is playing whistle and player is in Inclosure:
		the rule succeeds;
	the rule fails.

this is the mob-chanting rule:
	if current action is listening and player is in study and gunter is in lll:
		the rule succeeds;
	the rule fails;

this is the desk-look rule:
	if current action is examining the big important desk:
		the rule succeeds;
	the rule fails;

this is the catechism-over-research rule:
	if player is not in shack:
		the rule fails;
	if go-with-first of table of catechism pages and table of research topics:
		the rule succeeds;
	the rule fails;

this is the bar-over-comp rule:
	if player is not in hops shop:
		the rule fails;
	if go-with-first of table of bar dialogue and table of competing bars:
		the rule succeeds;
	the rule fails;

this is the gizmo-x rule:
	if current action is examining the gizmo:
		the rule succeeds;
	the rule fails;

this is the ask-deli rule:
	if pat-whine is true:
		the rule succeeds;
	the rule fails;

this is the casper-talk rule:
	if casper-mumble is true:
		the rule succeeds;
	the rule fails;

to say eisiping:
	say "[if rathole is unvisited] (Troves)[else if Pa Egg Pea is unexamined] (examine Pa Egg Pea)[end if]"

to say elv-art:
	unless dope-read is true:
		say " (read [if player is male]I Trash His Art[else]Her Arts Er Trash[end if])"

this is the rodney-here rule:
	if player is in trefoil and rodney is in trefoil:
		the rule succeeds;
	the rule fails;

this is the Elvira-taunt rule:
	if current action is going east and player is in Reclusion Inclosure:
		the rule succeeds;
	the rule fails;

this is the screed-read rule:
	if current action is examining the theses sheets:
		the rule succeeds;
	the rule fails.

this is the pun-quip rule:
	if current quip is pun-quip:
		the rule succeeds;
	the rule fails.

this is the bzzt rule:
	the rule fails.

this is the i-wait rule:
	if current action is waiting:
		the rule succeeds;
	the rule fails;

this is the horb-bye rule:
	if current action is exiting in Cleric Circle:
		the rule succeeds;
	the rule fails;

this is the amcuss rule:
	if current action is swearing obscenely:
		the rule succeeds;
	the rule fails;

this is the amatt rule:
	if current action is attacking:
		the rule succeeds;
	the rule fails;

this is the ibyp rule:
	if pardons is true:
		the rule succeeds;
	the rule fails;

this is the in-bvd rule:
	if player is in Used Lot:
		the rule succeeds;
	the rule fails;

this is the read-brochure rule:
	if current action is examining the brochure:
		the rule succeeds;
	the rule fails;

this is the read-books rule:
	if current action is examining the bookshelf:
		the rule succeeds;
	the rule fails.

this is the read-eths rule:
	if current action is examining Pa Egg Pea:
		the rule succeeds;
	the rule fails.

this is the read-tec rule:
	if current action is examining checklist:
		the rule succeeds;
	the rule fails.

this is the read-text rule:
	if current action is examining the catechism:
		the rule succeeds;
	the rule fails.

this is the read-pious-1 rule:
	if current action is examining the pious rev:
		if pious-state is true:
			the rule succeeds;
	the rule fails.

this is the read-pious-2 rule:
	if current action is examining the pious rev:
		if pious-state is false:
			the rule succeeds;
	the rule fails.

this is the read-divorces rule:
	if current action is examining DIVORCES:
		the rule succeeds;
	the rule fails.

this is the movie-over-ad rule:
	if current action is not examining store c:
		the rule fails;
	if go-with-first of table of sicko movies and table of store c ads:
		the rule succeeds;
	the rule fails;

this is the compet-over-ad rule:
	if current action is not examining store c:
		the rule fails;
	if go-with-first of table of store c competitors and table of store c ads:
		the rule succeeds;
	the rule fails;

this is the insult-over-girls rule:
	if player is not in anger range or pikes are not in anger range:
		the rule fails;
	if go-with-first of table of fish fries and table of unpopular girls:
		the rule succeeds;
	the rule fails;

this is the gossip-over-chatter rule:
	if location of player is not handsome sand home:
		the rule fails;
	d "In sand home.";
	if go-with-first of table of tuna gossip and table of aunt tuna chatter:
		the rule succeeds;
	the rule fails;

to decide whether go-with-first of (t1 - a table name) and (t2 - a table name):
	choose row with mytab of t1 in table of megachatter;
	let n1 be curidx entry;
	let n2 be maxidx entry;
	choose row with mytab of t2 in table of megachatter;
	let m1 be curidx entry;
	let m2 be maxidx entry;
	if n1 is 0 or n1 is 1:
		if m1 > 1: [this is not perfect but basically the larger tables come first]
			decide no; [this lets the 2nd bit cycle]
	d "[t1] vs [t2] is [n1] vs [m1] and [n1] * [m2] = [n1 * m2] vs [m1] * [n2] = [n2 * m1].";
	if n1 * m2 <= n2 * m1:
		decide yes;
	d "[n1 * m2] > [n2 * m1].";
	decide no;

this is the read-c rule:
	if current action is examining store c:
		the rule succeeds;
	the rule fails.

this is the blurby rule:
	the rule fails;

this is the in-bar rule:
	if player is in hops shop:
		the rule succeeds;
	the rule fails;

this is the horby rule:
	if player is in cleric circle and Brother Horbert is in cleric circle:
		the rule succeeds;
	the rule fails;

this is the Leo-Rand-cry rule:
	if Rand is washed up and player is in ridge:
		the rule succeeds;
	the rule fails;

this is the ohai-bullies rule:
	if carps are in anger range and player is in anger range:
		the rule succeeds;
	the rule fails;

this is the ohai-tokers rule:
	if player is in strip and tokers are in strip and nestor is in strip:
		the rule succeeds;
	the rule fails;

this is the ohai-tuna rule:
	if player is in sand home:
		the rule succeeds;
	the rule fails;

this is the say-gritty rule:
	if player is in Used Lot or player is in Loather Rathole:
		the rule succeeds;
	the rule fails;

this is the say-posh rule:
	if player is in Econ Cone or player is in Dour Tan Rotunda:
		the rule succeeds;
	the rule fails;

this is the em-sez rule:
	if player is in alcoves and Merle is in alcoves:
		if Merle is reflexed:
			the rule succeeds;
	the rule fails;

this is the alcove-talk rule:
	if player is in alcoves:
		if Elmer is in alcoves:
			if Merle is reflexed:
				the rule succeeds;
			else:
				say "Merle and Elmer [one of]begin[or]continue[stopping] concern trolling with the whole good-is-evil-and-evil-is-good routine, [one of]exclaiming HOLY NETS![or]all, 'Sly, eh? NOT.' discussing you.[or]lamenting Elvira's no-ethyls policy.[or]dissing Shy Elton.[or]so obviously on-the-sly, but what can you do?[in random order]";
	the rule fails;

this is the lecture-point rule:
	if player is in cruelest:
		if go-with-first of table of idiotic lecture points and table of overdone movies:
			the rule succeeds;
	the rule fails;

this is the name-movie rule:
	if player is in cruelest:
		the rule succeeds;
	the rule fails;

twiddle-warn is a truth state that varies.

to say twiddle of (tn - a table name) and (nums - a number):
	if nums is 1: [this simply forces one name out]
		choose row with mytab of tn in table of megachatter;
		increment curidx entry;
		if curidx entry > maxidx entry:
			now curidx entry is 1;
		let wh-row be curidx entry;
		choose row wh-row in mytab entry;
		say "[blurb entry]";
		continue the action;
	let tr be maxidx corresponding to mytab of tn in table of megachatter;
	let cholet be 0;
	let currow be curidx corresponding to mytab of tn in table of megachatter;
	let thisgrp be nums;
	let ors be false;
	if thisgrp < 0:
		now thisgrp is 0 - thisgrp;
		now ors is true;
	let skip-past be false;
	let curcount be 0;
	if currow > tr:
		say "(a bunch of stuff already read)[line break]";
		continue the action;
	while skip-past is false:
		if thisgrp >= tr - currow:
			now thisgrp is tr - currow;
			now skip-past is true;
		repeat with counter running from 1 to thisgrp:
			increment currow;
			choose row currow in tn;
			if counter is thisgrp and counter > 1:
				say " [if ors is true]or[else]and[end if] ";
			else if counter > 1:
				say ", ";
			say "[blurb entry]";
		if currow < tr and debug-state is false:
			say "... [i][bracket]M for more examples, any other key to move on[close bracket][r]";
			let cholet be the chosen letter;
			if cholet is not 77 and cholet is not 109:
				now skip-past is true;
			say "[line break]";
			increment curcount;
			if curcount is 5 and twiddle-warn is false:
				now twiddle-warn is true;
				ital-say "you can see all this at the end, so no need to page through all [tr] entries.";
		else:
			if debug-state is false:
				say " [bracket]That's all![close bracket][line break]";
			now skip-past is true;
	choose row with mytab of tn in table of megachatter; [reset to what's after]
	if currow is tr:
		now currow is 0;
	now curidx entry is currow;

every turn when strip of profits is visited (this is the region-hint on no score rule):
	if mrlp is manor and Gunter is in lalaland:
		increment turns-spent of mrlp;
	else if mrlp is unspoiled:
		increment turns-spent of mrlp;
	if cur-score of mrlp is 0 and mrlp is unspoiled:
		if turns-spent of mrlp > last-hint-turns of mrlp:
			if the remainder after dividing turns-spent of mrlp by 10 is 0:
				say "It seems you're stuck a bit here. Would you like a hint as to what this region is about?";
				if the player consents:
					now mrlp is spoiled;
					choose row with hint-reg of mrlp in table of region-spoilers;
					say "This region focuses on [spoil-expl entry].";
					now block-north is true;
				otherwise:
					say "Ok--I'll ask again in a few moves.";
					now last-hint-turns of mrlp is turns-spent of mrlp;
[				reject the player's command;]

before going north when block-north is true:
	do nothing instead; [?! hack to get rid of z.z.z.z. and answer n]

table of region-spoilers
hint-reg	spoil-expl
otters	"adverbs[if inhib is true](weakest, due to lost powers)[else](but powers back now)[end if]"
presto	"interjections"
routes	"prepositions"
troves	"passive verbs"
towers	"adjectives"
oyster	"active verbs"
others	"not nouns any more--a different part of speech in each location"

[this table gives clues after you scan, although sometimes it may be approrpriate to give hints only in cheat mode.]

table of aftertexts [taf]
xtradesc	b-only	clue-only-once	clued-yet	bothscan	xtratext
tables	false	false	false	true	"You fiddle with the cheat button and note that nothing happens to the R's and Y's." [manor]
niche	false	false	false	true	"You fiddle with the cheat button and note that nothing happens to the R's and Y's."
t-b	false	false	false	true	"You fiddle with the cheat button and note that nothing happens to the R's and Y's." [end manor]
bench	false	true	false	false	"Hm, bench is only five letters, but nothing was highlighted until you scanned the bit reading A GIANT'S." [routes]
controls	false	false	false	false	"This is odd--all these question marks. Surely you'll find by accident where Ben hid the hit win button? Or you can just pick and choose, focusing on Ben, or the win."
ltb	true	true	false	false	"Man! Only one stable red at the end. Those two co-authors muck things up. Maybe you can switch to teach mode, or maybe you can have a think on your own, realize there're only so many possibilities, and, oh, what's the word?"
Pa Egg Pea	true	true	false	false	"Man! It's making the settler go crazy. Between the title and the author's name, there's a lot to consider. Maybe it will shake out."
brochure	true	false	false	false	"You imagine a voice saying OBSTACLES LIKE THOSE QUESTION MARKS MAY BE OPPORTUNITIES. A [if brochure is examined]re[end if]reading of the brochure may help see what it's about."
rivets	false	false	false	true		"[rivet-help]."
song	false	true	false	false	"You'd guess it's Eddie's song and not Eddie, since when the instrumentals kick in, the settler's reading stays."
alert letters	true	false	false	false	"Hmm. The settler is giving a weird result, but the sheer number of question marks indicates ALERT/ALTER has a lot right between them." [presto]
USB	true	true	false	false	"Hm, USB seems pretty straightforward. Maybe there are two solutions, each equally good."
pale plea	false	true	false	true	"[if cheat-on is false]You check both ways, and it's still RYYR[else]Well, five letters is easier than four[end if]."
general gleaner	true	false	false	false	"The pattern blinks green-red and yellow-purple."
Ray Eck	false	true	false	false	"Ray Eck begins babbling about how interesting the settler looks, almost as interesting as his keycar. Maybe you could ASK him about the settler, if he's still stumping you." [towers]
nameless salesmen	false	true	false	true	"Hm. Salesmen is eight letters, but your settler registers seven. Seven letters in Nerd-Aid. It's--well, they're certainly dressed unusually."
alarming grailman	true	false	false	false	"The one letter blinks between green and yellow."
sweatier wait-seer	true	false	false	false	"The letters blink from red/yellow to purple/green and back."
iPrune	true	true	false	false	"Hm. That one blinky letter is pretty weird. Maybe you can start there, or try to annoy the iPrune."
raves saver	true	false	false	false	"Man! Four of the six entries (and you'd expect five) are blinky. That doesn't seem to mean anything...OR DOES IT."
deacons	false	true	false	false	"Well, this is tricky. They could be just plain deacons, or they could be the hostile ol['] heist. You may need to observe a bit more to clear this up."
man covered in inapt paint	false	true	false	false	"Hmm, painted and covered have three vowels--so it's probably the FLEMISH in inapt paint across his chest."
old ice	true	true	false	false	"Hm, it's certainly docile old ice, so the confusing letter may not be so confusing."
doc-y	false	true	false	false	"[if doc-y has not been rowdy and doc-y has been wordy][else]The settler showed two sets of RYRRO for a moment, there. Perhaps it represents a range of Dr. Yow's emotions.[else if doc-y has been rowdy or doc-y has been wordy]Hm, maybe Dr. Yow has more emotion than what you already brought out of him.[else]That leaves four possibilities, cheat or no, and none of the others make sense.[end if]"
ropins	false	true	false	false	"Now this is odd. The ropins have six letters, but they register eight. Maybe if you find something with eight letters, you can find out how to unlock them."
serpent	true	true	false	false	"That is a lot of blinks, but those blinks have to be almost as good as a purple or green."
cinders	true	true	false	false	"Hm, that's weird. Perhaps there are two things you can do with the cinders." [otters]
atmo-moat	false	true	false	true	"You feel sheepish having used the settler, but it's been a long journey."
Merle	false	false	false	true	"Some of the entries seem to flip bluish briefly as you flip the settler, as if the changing conversation may change settings."
sly imp	false	false	false	false	"The settler then gets garbled a bit. The imp is maybe too active for even the settler to pin down."
whiners	false	false	false	false	"The settler then garbles and changes. The men have ways of staying loud." [end otters]
coins	false	false	false	false	"Even the reds and yellows seem to be blinking here. It's as though the coins need to be changed twice." [others]
pugnacious	false	false	false	false	"Wow, seven letters, odd. Maybe you need to talk to the plant or attack it or something to see what kind it might be."
caution	false	false	false	false	"Hm, that certainly cuts things down a ton[if caution is unexamined], or should, once you read that sign[end if]. Just [if cheat-on is true]one possibility[else]three possibilities[end if]."
an-a	false	false	false	false	"You think you hear a taunting na-naa-b after you scan the letters."
natives	true	true	false	false	"That's weird. They're just natives, but the blinky bit suggests there may be two possible solutions."
curst palace	true	false	false	false	"[if palace-let < 5]Wow, lots of blank data. You may want to get closer to have any hope of figuring how to restore the palace[else if palace-let is 11 and cheat-on is true]The final letter clue blinks alternately with the fifth--neither is purple at the same time[else if cheat-on is true]Hm, maybe you can figure what the fifth letter is if you know more about the later ones[else]Just the reds and yellows still leave a lot of possibilities. But maybe you'll have clues along the way[end if]."

check scaning a prefigured thing:
	if noun is not dialer:
		say "Before running the scanner, you remember you've already figured what to do, just not when. The information's in your pedanto-notepad." instead;

to say rivet-help:
	if rivets are reflexed and prai is reflexed:
		say "Well, there's probably not much else hidden in the rivets";
		continue the action;
	if rivets are reflexed:
		say "You maybe could focus on what the rivets say";
		continue the action;
	if prai is reflexed:
		say "Hmm, the message could've been painted on, but Trevis Vister commissioned rivets";
		continue the action;
	say "[if cheat-on is true]The greens and yellows in the last two characters blink in unison[else]A little messy, but that may just mean there are two ways to look at this problem[end if]";

a thing can be ssok, ssno, ssblur or ssclear. a thing is usually ssok.

a thing can be attempted. a thing is usually not attempted.

a thing can be unscannable. a thing is usually not unscannable.

a thing can be prefigured or unfigured. a thing is usually unfigured.

a thing has text called a-text. a thing has text called b-text.

a thing can be warpable. a thing is usually not warpable.

a thing can be LLPish. a thing is usually not LLPish.

a thing can be universal, useless, cluey, amusing, abstract or practical. a thing is usually practical.

a thing can be flippable, auxiliary or uncluing. a thing is usually uncluing.

a thing can be super-easy, semi-easy, or not-easy. a thing is usually not-easy. [this is subjective, but super-easy is trivially solvable with settler non-cheat. Semi-easy is trivially solvable with settler cheat. Not-easy takes some more brainwork.]

a thing can be rayed. a thing is usually not rayed.

a thing can be examined or unexamined. a thing is usually unexamined.

a room can be stairy. a room is usually not stairy.

a room can be outie or innie. a room is usually outie. [innie has WALL/WALLS for anagrams]

a room can be shunned. a room is usually not shunned. [GO TO ROOM won't work]

a room has a number called progval. [again for GO TO ROOM, from progval of 2 to 1 is not valid]

a thing can be ghostly. a thing is usually not ghostly.

a person can be superchatty, subject-talking or terse. a person is usually subject-talking. [terse = they ignore general defaults like asking about Elvira, subject-talking = ignore silly details.]

a person can be terse-warned. a person is usually not terse-warned.

the player is terse.

an animal is usually terse.

a hintpastry is a kind of thing. a hintpastry can be heated. a hintpastry is usually not heated. a hintpastry is usually edible.

a hintpastry has a number called deliciousness.

after taking a hintpastry:
	increase deliciousness of noun by 10;
	continue the action;

when play begins (this is the disambig-pastry rule) :
	let tastee be 1;
	repeat with HP running through hintpastries:
		now deliciousness of HP is tastee;
		increment tastee;

understand "pastry" as a hintpastry.

check objasking about a hintpastry when mrlp is towers:
	if noun is doc-y or noun is smart kid:
		say "You might get a lecture about all the gross chemicals in there." instead;
	say "You offer the hint-pastry as a gift, instead.";
	try giving the second noun to the noun;

the specification of a hintpastry is "A hintpastry, when heated, lets you see how a thing/item should be described."

a fruit is a kind of thing. description of a fruit is "[if the item described is plural-named]They're[else]It's[end if] not heinously bruised or rotting, or anything, so Curtis probably won't mind it."

the specification of fruit is "Something that Curtis will take from you, and you may or may not get a coin back."

the can't take scenery rule is not listed in any rulebook.

The describe what's on scenery supporters in room descriptions rule is not listed in any rulebook.

to say email:
	say "blurglecruncheon@gmail.com";

check taking a fruit (this is the probably archaic debug fruitflips in case rule) :
	say "Oops! You should've taken this fruit when you flipped it. [bug-report]" instead;

instead of waking:
	say "Weak!" instead;

Instead of saying no:
	if block-north is true:
		do nothing;
	if old giant is visible:
		say "That would be unwise to disagree with the giant. You need to find the right way to ride out the conversation." instead;
	if Elvira is visible:
		say "Elvira smiles and shakes her head." instead;
	if Gunter is visible:
		say "You can't out-argue Gunter or change his mind." instead;
	say "Nope, I opine your grimace doesn't make you feel magic-er[one of]. (Rhetorical questions can be safely ignored.)[or]Another rote 'Nah.'[or]'Wilcos? I scowl.'[stopping]";

Instead of saying yes:
	if block-north is true:
		do nothing;
	if old giant is visible:
		say "You can't do much but agree with him. You need to find the right way to ride out the conversation." instead;
	if Elvira is visible:
		say "Don't give in like that!" instead;
	say "[one of]Languid lauding! [or]Yes, eh? Yeesh! [or]Attuning nutating? [or]Simpers impress no-one. [or]Say ays? [stopping][one of](Rhetorical questions can be safely ignored.)[or][line break][stopping]";

throw-warn is a truth state that varies.

instead of eating a fruit:
	if noun is lemons or noun is melons:
		say "A [if noun is lemons]lemon[else]melon[end if]? No meal!" instead;
	say "[one of]You shouldn't eat into Curtis's profits.[one of][paragraph break][italic type][bracket]NOTE: if you try again, you'll get a bad anagram pun.[close bracket][roman type][line break][or][stopping][or]You decide to ruf it without fruit. ([one of]Told you so[or]Yup. Still here[stopping].)[cycling]";

an undesc is a kind of thing. description of undesc is "[bug-report]";

bean-smell is a truth state that varies.

do-i-chat is a truth state that varies.

inhib is a truth state that varies.

every-turn-hint is a truth state that varies. every-turn-hint is false.

Procedural rule: ignore the print final score rule.

check examining player when mrlp is demo dome:
	say "You look just fine. You don't need to be dressed too fancy for this." instead;

description of player is "As every[if player is female]wo[end if]mannish as ever[if player wears star], and wearing a spiffy star, too[end if]. [one of]You'll never be a [if player is female]Fine Nefi Fein[else]Hunk Kuhn or Icon Nico[end if], and you don't want to be. Because i[or]I[stopping]t's the power inside you that's important[if mrlp is otters and inhib is true]. Well, the power you may need to regain[end if]."

does the player mean examining the player when mrlp is troves: it is very likely.

check examining the player when mrlp is troves:
	say "[one of]You look into your thoughts, feelings and beliefs. You realize they cannot possibly be as pertinent as whatever Peg A. Page has to say. So you defer to her knowledge[or]Your thoughts lead back to the good book[stopping].[line break]";
	try examining Pa Egg Pea instead;

the file of roilhints is called "roilhints".

the file of debuggery is called "debug".

figure graflogo-1 is the file "letters-settler-1.png"

figure graflogo-2 is the file "letters-settler-2.png"

figure yorpwald-1 is the file "yorpwald-1.png"

section glulxy adjustments

use DICT_WORD_SIZE of 12

[for SPECTACULAR so SPECTACULRA doesn't work. Oh, some of the adverbs, too get to 11. But BLACKBERRIES is 12.]

section or inform goes foom

[edit this if I get a compiler error not due to syntax.]

use MAX_DICT_ENTRIES of 3000.

use MAX_OBJECTS of 900.

use SYMBOLS_CHUNK_SIZE of 9500

use MAX_SYMBOLS of 90000.

use MAX_VERBSPACE of 10240.

use MAX_ACTIONS of 615.

use MAX_VERBS of 615.

Use MAX_INDIV_PROP_TABLE_SIZE of 100000.

use MAX_NUM_STATIC_STRINGS of 55000.

use MAX_PROP_TABLE_SIZE of 540000. [note: this is the main one that breaks with code 10 and no warnings. Which sucks, but I'll document it here in case things happen again. Maybe it'll help you, too.]

use MAX_STATIC_DATA of 660000.

Use MAX_LABELS of 16000.

section debug on - not for release

[needs to be near the top--well, could place it before all other when play begins rules]

when play begins (this is the debug by default when debugging rule) :
	now bugsquash is true; [be harsh to myself in programmer testing. Sniff out any bugs and kill walkthrough tests.]
	now debug-state is true;

[every turn when player is in dusty study and Gunter is off-stage and debug-state is true:
	say "Found: [stuff-found].";]

section test extensions - not for release

Include Direction Response Testing by Andrew Schultz.

include Property Checking by Emily Short.

include Object Response Tests by Juhana Leinonen.

section screenreading and censoring

screenread is a truth state that varies.

when play begins (this is the screenread gender swears and precursor rule) :
	if debug-state is false:
		say "A Roiling Original has some features that can be adjusted for screen readers. Are you using a screen reader?";
		if the player consents:
			say "Accessibility is turned on. It is something I had trouble meaningfully planning and testing, so please let me know at [email] if you feel it could be improved. Thank you!";
			now screenread is true;
			now setspace is true;
		say "You can alternate accessibility mode with the ACCESS command.[paragraph break]Also, A Roiling Original contains some minor profanity. Unfortunately, it can't wipe out some implied profanity that results, but nothing is intended to be malicious. Disable profanity?";
		if the player consents:
			now censor-minor is true;
		say "Also, this is not critical to game mechanics and only gives minor differences, but you can play as a male (M) or female (F) -- case insensitive. Which will it be?";
		let cholet be 0;
		while cholet is irrelevant:
			let cholet be the chosen letter;
			if cholet is irrelevant:
				say "M or F, please.";
		if cholet is 70 or cholet is 102:
			now the player is female;
			now the admirer is male;
		else:
			now the player is male;
			now the admirer is female;
		if the player is male:
			now i trash his art is part of the dope op-ed;
		else:
			now er trash is part of the dope op-ed;
		say "And one final thing: A Roiling Original is a sequel to Shuffling Around. It's strongly recommended you play Shuffling Around first, as it is shorter and provides back story to ARO, but it's not critical. If, in any case, you'd like a recap--which also immediately spoils ARO's mechanic--say yes now.";
		if the player consents:
			say "Shuffling Around was about changing...things...to other things. Your tagged gadget helped you with the tougher ones, like the drainage that became a gardenia, and you remember the magenta nametag that became the gateman who introduced you to Yorpwald. After solving the Forest, Sortie and Metros in the stores in the Trips Strip, you tackled Red Bull Burdell and earned your Roman Manor as thanks.[paragraph break]You remember the things you did, but do you need to remember the word?";
			if the player consents:
				say "Things were, well, anagrams. Store F became the forest. Store I, the sortie. Store M, the metros. You were particularly proud of changing the liches to a chisel and the drapes to a spread.";
			else:
				say "OK, let's get to it!";
		else:
			say "OK, let's get to it!";
	else: [force certain values]
		now i trash his art is part of the dope op-ed;
		now the player is male;
		now the admirer is female;

to decide whether (cho - a number) is irrelevant:
	if cho is 70 or cho is 102, decide no;
	if cho is 77 or cho is 109, decide no;
	decide yes;

section gender specific silliness

to say a-b:
	say "[if player is male]Abe[else]Bea[end if]"

to say d-t:
	say "[if player is male]Tod[else]Dot[end if]"

to say fs:
	say "[if player is female]s[end if]";

to say i-n:
	say "[if player is male]Ian[else]Nia[end if]"

to say sim:
	say "[if player is male]Simeon[else]Simone[end if]"

to say toti:
	say "[if player is male]Tino[else]Toni[end if]"

to say tt:
	say "[if player is male]Tio[else]Toi[end if]"

to say ta:
	say "[if player is male]Tai[else]Tia[end if]"

section redact cussing

censor-minor is a truth state that varies.

to say a-word:
	say "[if censor-minor is true]---[else]ass[end if]";

to say a-word-u:
	say "[if censor-minor is true]---[else]Ass[end if]";

to say crap:
	say "[if censor-minor is true]----[else]crap[end if]";

to say crap-u:
	say "[if censor-minor is true]----[else]Crap[end if]";

to say d-word:
	say "[if censor-minor is true]----[else]damn[end if]";

to say d-word-u:
	say "[if censor-minor is true]----[else]Damn[end if]";

to say dick:
	say "[if censor-minor is true]----[else]dick[end if]";

to say dick-u:
	say "[if censor-minor is true]----[else]Dick[end if]";

chapter testing stuff I can't quite NFR

section scos

section sss

sss is a truth state that varies.

every turn when sss is true (this is the show blues rule):
	if player has settler and sss is true:
		append ">[the player's command]: [no line break]" to the file of debuggery;
		show-bluable;
	continue the action;

section silly variables

hint-to-file is a truth state that varies.

hint-to-display is a truth state that varies.

scams is a truth state that varies.

ff is a truth state that varies. [flip freeze disabled in release mode]

section scam rule [referred to while scoring]

every turn when scams is true (this is the scam rule):
	if mrlp is routes:
		now player has snoop spoon;
		try examining snoop spoon;
	else if mrlp is troves:
		now player has truffle;
		try eating truffle;
		[now player has truffle;]
	else if mrlp is otters:
		now player has cinders;
		try discerning cinders;
	else if mrlp is presto:
		now player has crust;
		try eating crust;
	else if mrlp is oyster:
		now player has pills;
		try spilling pills;

section long form of verbs

Include (-
Replace LanguageVerb;
-) after "Definitions.i6t".

Include (-
[ LanguageVerb i;
	switch (i) {
	  'i//','inv','inventory':
			   print "take inventory";
	  'a//':   print "ask about";
	  'l//':   print "look";
	  'x//':   print "examine";
	  'gt//':   print "go to";
	  'r//':   print "read";
	  'z//':   print "wait";
	  default: rfalse;
	}
	rtrue;
];
-) after "Language.i6t".

section subverting undos and tracking your death

Include (-

	Array have_died_flag --> 1;
	Global cur_undo = 1;

-) after "Definitions.i6t".

To protect the have-died flag from undo: (- @protect have_died_flag 4; @protect cur_undo 4; -).

To decide whether the have-died flag is (T - a truth state): (- (have_died_flag-->0 == {T}) -).

To --/-- now the have-died flag is (T - a truth state): (- have_died_flag-->0 = {T}; -).

section versioning modification

Include (-

[ ANNOUNCE_STORY_FILE_VERSION_R ix;
	if (actor ~= player) rfalse;
	Banner();
	IFID();
	@gestalt 1 0 ix;
	print "Interpreter version ", ix / $10000, ".", (ix & $FF00) / $100,
	".", ix & $FF, " / ";
	@gestalt 0 0 ix;
	print "VM ", ix / $10000, ".", (ix & $FF00) / $100, ".", ix & $FF, " / ";
	print "Library serial number ", (string) LibSerial, "^";
	#Ifdef LanguageVersion;
	print (string) LanguageVersion, "^";
	#Endif; ! LanguageVersion
];

-) instead of "Announce Story File Version Rule" in "Glulx.i6t".

The IFID Header is a text that varies. The IFID Header is "Game identification number".

Include (-

[ RAW ix;
	for (ix=6: ix <= UUID_ARRAY->0: ix++) print (char) UUID_ARRAY->ix;
];

-).

Include (-

[ IFID;
	PrintText((+ IFID Header +));
	print ": ";
	RAW();
	print "^";
];

-).

To say ifid: (- IFID(); -).

Report requesting the story file version (this is the manual extra listings rule):
	say "Extensions used listed by author:[line break]";
	say "[b]Andrew Plotkin: [r]Large Game Speedup[line break]";
	say "[b]Emily Short:[r] Basic Screen Effects and, for testing, the very handy Property Checking[line break]";
	say "[b]Erik Temple:[r] Glimmr Drawing Commands (modified) [line break]";
	say "[b]Jon Ingold:[r] Flexible Windows 12/110611[line break]";
	say "[b]Juhana Leinonen:[r] for testing, the very handy Object Response Tests[line break]";
	say "[b]Michael Martin:[r] Quip-Based Conversation and Reactable Quips [line break]";
	say "[b]Andrew Schultz:[r] for testing, Direction Response Testing[line break]";
	say "Other coding listed by author:[line break]";
	say "[b]Andrew Plotkin[r] (misc cool I6 stuff), [b]Climbing Stars[r] (banner code), [b] Eu (death tracking), [b]Wade Clarke[r] (this listings rule) [line break]".

chapter allow me to trace

Include (-

[ testcommandnoun obj o2;
	switch (scope_stage) {
		1: rtrue; ! allow multiple objects
		2: objectloop (obj)
			if ((obj ofclass Object) && (obj provides KD_Count))
				PlaceInScope(obj, true);
		3: print "There seems to be no such object anywhere in the model world.^";
	}
];

{-testing-command:abstract}
	* scope=testcommandnoun 'to' scope=testcommandnoun -> XAbstract;
{-testing-command:actions}
	*                                           -> ActionsOn
	* 'on'                                      -> ActionsOn
	* 'off'                                     -> ActionsOff;
{-testing-command:gonear}
	* scope=testcommandnoun                     -> Gonear;
{-testing-command:purloin}
	* scope=testcommandnoun                     -> XPurloin;
{-testing-command:random}
	*                                           -> Predictable;
{-testing-command:relations}
	*                                           -> ShowRelations;
{-testing-command:rules}
	*                                           -> RulesOn
	* 'all'                                     -> RulesAll
	* 'on'                                      -> RulesOn
	* 'off'                                     -> RulesOff;
{-testing-command:scenes}
	*                                           -> ScenesOn
	* 'on'                                      -> ScenesOn
	* 'off'                                     -> ScenesOff;
{-testing-command:scope}
	*                                           -> Scope
	* scope=testcommandnoun                     -> Scope;
{-testing-command:showheap}
	*                                           -> ShowHeap;
{-testing-command:showme}
	*                                           -> ShowMe
	* scope=testcommandnoun                     -> ShowMe;
{-testing-command:showverb}
	* special                                   -> Showverb;
{-testing-command:test}
	*                                           -> TestScript
	* special                                   -> TestScript;
{-testing-command:tree}
	*                                           -> XTree
	* scope=testcommandnoun                     -> XTree;

-) instead of "Grammar" in "Tests.i6t".

chapter charnum

to say character number (N - a number): (- print (char) {N}; -)

chapter save-present

to save-present-input: (-
	if (verb_word ~= AGAIN1__WD)
		for (i=0 : i<INPUT_BUFFER_LEN : i++) buffer3->i = buffer->i;

	if (usual_grammar_after == 0) {
		j = verb_wordnum;
		i = RunRoutines(actor, grammar);
		#Ifdef DEBUG;
		if (parser_trace >= 2 && actor.grammar ~= 0 or NULL)
			print " [Grammar property returned ", i, "]^";
		#Endif; ! DEBUG

		if ((i ~= 0 or 1) && (VM_InvalidDictionaryAddress(i))) {
			usual_grammar_after = verb_wordnum; i=-i;
		}

		if (i == 1) {
			parser_results-->ACTION_PRES = action;
			parser_results-->NO_INPS_PRES = 0;
			parser_results-->INP1_PRES = noun;
			parser_results-->INP2_PRES = second;
			if (noun) parser_results-->NO_INPS_PRES = 1;
			if (second) parser_results-->NO_INPS_PRES = 2;
			rtrue;
		}
		if (i ~= 0) { verb_word = i; wn--; verb_wordnum--; }
		else { wn = verb_wordnum; verb_word = NextWord(); }
	}
	else usual_grammar_after = 0;
-)


chapter pronoun setting

[This allows us to refer to a plural noun as it/them. Thanks to Climbingstars!]

To set the/-- pronoun it to (O - an object): (- LanguagePronouns-->3 = {O}; -).
To set the/-- pronoun him to (O - an object): (- LanguagePronouns-->6 = {O}; -).
To set the/-- pronoun her to (O - an object): (- LanguagePronouns-->9 = {O}; -).
To set the/-- pronoun them to (O - an object): (- LanguagePronouns-->12 = {O}; -).

chapter rules-switch

to force-rules:
	(- debug_Rules = 1; -)

to force-all-rules:
	(- debug_Rules = 2; -)

chapter glulx header

when play begins:
	open up the graphics-window;
	change the current graphics window to the graphics-window;
	change the current background-color to (R 0 G 0 B 0);
	change the current foreground-color to (R 255 G 0 B 0);

The graphics-window is a graphics g-window spawned by the main-window. the position is g-placeabove. The scale method of the graphics-window is g-proportional. The measurement of the graphics-window is 10.

chapter full-monty

questions-not-flagged is a truth state that varies.

space-warned is a truth state that varies;

to say full-monty of (myobj - a thing):
	let A be indexed text;
	let C be indexed text;
	let D be 13;
	let qnf be questions-not-flagged;
	let sw be space-warned;
	if cheat-on is true:
		let A be "[b-text of myobj]";
	otherwise:
		let A be "[a-text of myobj]";
	if number of characters in A > 15:
		say "Something went wrong. [myobj] had a [number of characters in A]-letter scan. Let me know what you were doing. [bug-report]";
		continue the action;
	repeat with CC running from 1 to the number of characters in A:
		let C be character number CC in A;
		change current foreground-color to (R 128 G 128 B 128);
		if C is "?": [ambiguous due to conflicts in description]
			change current foreground-color to (R 192 G 192 B 192);
			if questions-not-flagged is false:
				now qnf is true;
		if C is "*": [word spaces]
			change current foreground-color to (R 0 G 0 B 0);
			if space-warned is false:
				now sw is true;
		if C is "R" or C is "r": [consonant no match]
			change current foreground-color to (R 210 G 0 B 0);
		if C is "Y" or C is "y":
			change current foreground-color to (R 210 G 210 B 0);
		if C is "O" or C is "o": [y no match]
			change current foreground-color to (R 210 G 105 B 0);
		if C is "P" or C is "p": [consonant match]
			change current foreground-color to (R 210 G 0 B 210);
		if C is "G" or C is "g": [vowel match]
			change current foreground-color to (R 0 G 210 B 0);
		if C is "B" or C is "b": [y match]
			change current foreground-color to (R 168 G 42 B 42);
		draw a rectangle (current foreground-color) in current graphics window at D by 12 with size 12 by 12;
		increase D by 13;
	repeat with CC running from 1 + the number of characters in A to 13:
		change current foreground-color to (R 128 G 128 B 128);
		draw a rectangle (current foreground-color) in current graphics window at D by 12 with size 12 by 12;
		increase D by 13;
	draw a rectangle (R 255 G 255 B 255) in current graphics window at 13 by 30 with size 220 by 20;
	paint bitmap text (color g-Black) of "[myobj]: cheat [if cheat-on is true]on[else]off[end if]" in current graphics window at 13 by 30 using Glimmr C&C with size 1;
	say "[spacies of A][if qnf is true and questions-not-flagged is false]--hmm. Some of the spaces are blinking as if the settler couldn't tell what letters should be used. Maybe there are two ways to wangle things, or maybe the ambiguity is an extra clue. You could try re-scanning in non-cheat mode[end if][if sw is true and space-warned is false and myobj is not curst palace]. The black cells would indicate spaces, you guess[end if]";
	if qnf is true:
		if questions-not-flagged is false:
			pad-rec-q "question mark";
	if myobj is curst palace:
		pad-rec-q "curst palace";
		continue the action;
	now space-warned is sw;
	now questions-not-flagged is qnf;

the question mark is a thing. the question mark is undesc. [question mark is for hinting ONLY]

to say spacies of (INTE - indexed text):
	if setspace is false:
		say "[INTE]";
		continue the action;
	let chrs be the number of characters in INTE;
	repeat with chtemp running from 1 to chrs:
		let THISCHAR be character number chtemp in INTE;
		if THISCHAR is "R":
			say "Red";
		else if THISCHAR is "Y":
			say "Yellow";
		else if THISCHAR is "G":
			say "Green";
		else if THISCHAR is "P":
			say "Purple";
		else if THISCHAR is "O":
			say "Orange";
		else if THISCHAR is "B":
			say "Brown";
		else if THISCHAR is "*":
			say "Asterisk";
		else if THISCHAR is "?":
			say "Question mark";
		if chtemp < chrs:
			say " ";

chapter hint-every-turn

hint-to-file is a truth state that varies. hint-to-file is false.

hint-to-display is a truth state that varies. hint-to-display is false.

every turn (this is the hint flags checkoff rule):
	if hint-to-file is true or hint-to-display is true:
		d "[hint-to-file] to file [hint-to-display] to display.";
		now auto-hint-proc is true;
		try hinting;
		now auto-hint-proc is false;

auto-hint-proc is a truth state that varies.

chapter transcripting

Include (-
[ CheckTranscriptStatus;
#ifdef TARGET_ZCODE;
return ((0-->8) & 1);
#ifnot;
return (gg_scriptstr ~= 0);
#endif;
];
-).

To decide whether currently transcripting: (- CheckTranscriptStatus() -)

[thanks to Zarf for the above code. It helps a tester make sure they're testing after their first comment.]

report switching the story transcript on:
	if currently transcripting:
		say "Thanks for doing this! Email can go to [email].";

check quitting the game when currently transcripting:
	say "Thanks for taking a transcript. Please send it to [email] and I'll be grateful. Thanks!";

chapter hashing

[the hashes are set so that each word/anagram should have a unique value based on its letters. They do, mostly.]

Table of Hashcodes
Letter(indexed text)	Code
"a"	2187818
"b"	18418905
"c"	19005585
"d"	21029089
"e"	127806109
"f"	26514896
"g"	32599702
"h"	37282299
"i"	44992846
"j"	48960525
"k"	52933178
"l"	53813839
"m"	64075153
"n"	68907508
"o"	74352577
"p"	81465959
"q"	84405617
"r"	85323803
"s"	96273966
"t"	103110018
"u"	105105807
"v"	107164820
"w"	107934773
"x"	112768081
"y"	122359252
"z"	122969618

to decide what indexed text is the filtered name of (t - a value of kind K):
	let s be t in lower case;
	replace the regular expression "<^abcdefghijklmnopqrstuvwxyz>" in s with "";	[ a-z would include accented characters]
	decide on s;

to decide what number is the hash of (t - a value of kind K):
	let s be the filtered name of t;
	let hash be 0;
	repeat with c running from 1 to the number of characters in s:
		increase hash by the Code corresponding to a Letter of character number c in s in the Table of Hashcodes;
	decide on hash;

when play begins (this is the intro-hashes rule):
	let wnum be 0;
	repeat through the table of anagrams:
		if there is no hashkey entry or hashkey entry is 0:
			now hashkey entry is the hash of the printed name of the-from entry;
			d "full name [the printed name of the-from entry] ~ [the-to entry]. Hash = [hashkey entry].[line break]";

Undo-code is a number variable. Undo-code is 0.

redo-alert is a truth state that varies.

currently-undoing is a truth state that varies.

report undoing an action:
	if mrlp is towers and can-see-map:
		draw-my-loc;
	now currently-undoing is true;
	say "[randbla][line break]";
	now currently-undoing is false;

to say eh-eh:
	now currently-rejecting is true;
	say "A booming voice yells '[randbla]!' ";
	now currently-rejecting is false;

currently-rejecting is a truth state that varies.

rule for deciding whether to allow undo:
	if hint-to-file is true:
		append "UNDO: (no hint)[line break]" to the file of roilhints;
	if undo is prevented and scams is false:
		if undo-code is -1:
			say "Don't worry. There's no wrong way through dialogues, nothing disappears, and important stuff is recorded in your pedanto-notepad.";
		if undo-code is 1:
			say "[eh-eh]Ucky, yuck, you think at the biology behind the crust coming back up your throat. For your own health, see. That's something not even a tree eater could re-eat.";
		if undo-code is 2:
			say "[eh-eh]I can't let that un-see ensue.";
		if undo-code is 3:
			say "[eh-eh]The sugared sea-drug has you. You think you can use its insights, but it will subtly decrease the pleasure you could've gotten figuring things out on your own.";
		if undo-code is 4:
			say "[eh-eh]You can't undo learning such knowledge.";
		if undo-code is 5:
			say "[eh-eh]You probably don't need to revisit that headache anyway.";
		if undo-code is 6:
			say "[eh-eh]No ops can bring that spoon back.";
		if undo-code is 7:
			say "[eh-eh]You think, I'd reuse residue, then seem to hear 'Sure! Die!'";
		ital-say "undo is only denied if you've used a cheat item, so don't worry. You can undo any death, and the game should not become unwinnable.";
		deny undo;
	else:
		if undo-code is 8:
			say "You could've sworn you heard the trolls mumble something about how they could probably kick your butt at computer games, too, and save states and do-overs were for wimps.";
		else if undo-code is 9:
			now the have-died flag is true;
		else if undo-code is 10:
			ital-say "the 'you died' message is random--but there are [number of rows in table of death messages]. So if you're hunting them, it may be more efficient to win to see them all.";

chapter look under

check looking under:
	ital-say "looking under is equivalent to SEARCHing unless the game is explicit. That way you can look inside, around and under in just one move. Let's do that now.";
	try searching noun instead;

chapter retry/terry

retrying is an action applying to nothing.

understand the command "retry/terry" as something new.

understand "retry" and "terry" as retrying.

retried is a truth state that varies. retried is usually false.

carry out retrying:
	if location of player is Strip of Profits:
		if retried is true:
			say "This is the place you go after retrying--as you probably know. So nothing happens." instead;
		say "Nothing happens. Perhaps this is where you'd be sent back to[if Loather Rathole is visited or Posh Hops Shop is visited or Danger Garden is visited or Same Mesa is visited or Danger Garden is visited]after going somewhere like you've been[otherwise]once you're able to look around[end if]." instead;
	if Strip of Profits is unvisited:
		say "You haven't been to the Strip of Profits yet, whatever that is, and you suspect you can't just jump ahead. Besides, you don't want to risk retrying your manor." instead;
	if mrlp is otters:
		say "You shouldn't need to go anywhere else[if number of bypassed regions > 0]. While you destroyed some regions with the patcher, you can't revisit them without restarting[end if]. Are you sure?";
		if the player consents:
			say "Okay, back to the Strip of Profits.";
		otherwise:
			say "Okay, back to the endgame." instead;
	repeat with MI running through held things:
		if MI is not warpable:
			d "warping [MI].";
			now MI is in lalaland;
			add MI to item-list of mrlp;
			now lreg of MI is mrlp;
	now retried is true;
	if mrlp is towers and can-see-map:
		wipe-towers-map;
	now player is in Strip of Profits;
	if nestor is in strip of profits or tokers are in strip of profits:
		say "Fortunately, [if tokers are not in strip]Nestor didn't see[else]none of the tokers saw[end if] you zap back, or you'd probably be forced to explain things, which would take a while.";
	the rule succeeds;

to say rs-left:
	say "[7 - number of solved regions in words] region[if number of solved regions is 5]s[end if] left";

a thing can be warpable. a thing is usually not warpable.

table of warps [this gives the text for which portal leads to which area, and what starting location]
por	reg	lloc	go-text
routes-x	Routes	Same Mesa	"[one of]The route turns a bit, then begins branching. You are no longer sure what direction you are going in, and you always vaguely tried to take the center one, but it's no use. You wind up crossing a red line, and you find there is no way back. 'No curse cure, son!' booms a voice[if player is female] sadly ignorant of your gender[end if].[paragraph break]After walking on for a bit, you find yourself somewhere that might be populated. Well, there are buildings around[or][if Sun-Spared Underpass is visited]Somehow, the routes lead you underground[otherwise]It's easier to get lost the way you need to the second time[end if][stopping].[line break]"
troves-x	Troves	Loather Rathole	"[one of][if tokers are in Strip of Profits]'Materialism is like a TRAP, MAN! Wait, no, man, it's LITERALLY...'[paragraph break][end if]A protean neo-trap! A blingo-goblin sargent grabs you as you reach for the argents and garnets! Of course the trove was too overt. You shake him off and run. The sarge rages and gears--you hit the, er, gas. When you look up, you are in a girdled griddle of a city. And not any city. That most successful of cities: Spoiloplis! Where people go from poverty--to the very top. Cars--outrageous rogue autos--scar arcs, spraying water on you and knocking you from the curb as you reach for a demi-dime.[wfak][paragraph break]'Insurer Inurers! Darn you and your...' you hear someone yell from the back seat. They get out. 'Dawdler! Waddler!' You cringe, waiting for a lecture, but instead you only feel a slight thud on your chest. 'Toughen up! Enough put.' They re-enter the car, which speeds off.[paragraph break]You look down to a copy of [i]Pa, Egg, Pea[r] by Peg A. Page--a success manual of parsable parables.[or]You think positively as you walk back through the troves, and what do you know, you wind up where you used to be.[stopping][line break]"
e-s	Presto	Grey Gyre	"[one of]Shoof! Foosh! Your trip through the, er, spot visits Old Warpy itself, the center of the Yorpwald teleportation network! Poof! Foop! Danglin['], then landing. With a plomf, maybe a flomp.[or]You hurtle through again, managing to land on your feet this time.[stopping]"
oyster-x	Oyster	Posh Hops Shop	"[one of]You walk into a bar full of seafood people. Err, sea people. Everyone seems worried about a seaside disease[or]You return to the sea people's area[stopping]."
towers-x	Towers	Loftier Trefoil	"[one of]As you attempt to enter the towers, they seem to move away will stop when you try to go closer, they move even further away. But you keep walking, eventually walking somewhere barren--the Bland Sad Badlands! There's not much there, but you've heard people guard the silliest things, just because. So when you find a tavern, you stop in for some help.[wfak][paragraph break]Someone is willing to talk to you: a marauding sort named Rodney who already has held the tavern hostage! And you stumbled in just as he'd got everyone scared and ready to let him loot the place![wfak][paragraph break][or]You warp back to the Badlands again.[stopping]"
otters-x	Otters	Bleary Barley	"[if b-b is reflexed]You turn around when you pass through the otters, but the Strip of Profits is gone.[else if Bleary Barley is visited]You stumble back into the barley and when you turn around, you can't see the otters anywhere.[otherwise]As you walk through, you feel a tingling, like giant wasp paws. You know you are not as powerful as before. A voice says 'This area is not to be braved lightly. Really.'[end if][paragraph break]"
hoster	others	rustic citrus	"After the darkest, sad trek, a frazzled beady-eyed man runs up to you and mutters about the Postage Gestapo and Tubers Brutes and so forth. Then he looks up. 'Curtis. Turf is fruits. CEO of TruSci.[paragraph break]'Yeah, you. You, um, that dude[if player is female], uh, dude-ess[end if]? With those powers? Listen, I need help with my business. Elvira grew all kinds of un-nutritious stuff. It'd help Yorpwald, and maybe it's help you. I bet it'd be real easy for you...and I'll give you something cool for every four fruits. Until I'm out of cool stuff. What do you say?'[wfak][paragraph break]'Great! You do your thing, then I'll do mine. It's weird technical biotech stuff, increase yields--a step past your...not that you're...um, never mind, get on it.'[paragraph break]He's a bit brusque, but that's the legacy of bad leaders like Elvira--the people opposed to them the loudest can get annoying before anyone notices."

after taking inventory when mrlp is others:
	eval-fruits;
	continue the action;

to eval-fruits:
	if moss cap is off-stage:
		continue the action;
	if player has droll dollar:
		say "You can't expect anything more from Curtis.";
		continue the action;
	let next-goal be (curtis-level + 2) * 4;
	let fruits-got be number of fruits in lalaland + number of held fruits;
	if fruits-got >= next-goal:
		say "You may want to go see Curtis for a new reward. Or you can keep getting new fruits.";
	else:
		say "You need [next-goal - fruits-got] more fruit[if next-goal - fruits-got > 1]s[end if] to get something new from Curtis.";

wfak-yet is a truth state that varies.

to say wfak: [this is so I can skip through PRESS ANY KEY while testing]
	if debug-state is false:
		if wfak-yet is false:
			ital-say "when the game pauses without a cursor, it means you need to press any key to continue. This warning will not appear again.";
			now wfak-yet is true;
		wait for any key;

when play begins (this is the region initialization rule):
	repeat through table of warps:
		now go-region of por entry is reg entry;
		now last-loc of reg entry is lloc entry;
	repeat with REG running through regions:
		now poss-score of REG is max-score of REG;
	reset-regions;

to reset-regions:
	repeat through table of warps:
		now the item-list of reg entry is {};

to item-warp:
	let A be the map region of the location of the player;
	d "So far you have [cur-score of A] of [max-score of A] points.[line break]";
	now last-loc of A is location of the player;
	if number of carried not warpable things > 0 or number of worn not warpable things > 0:
		if A is solved:
			if A is Roman Manor or A is others:
				say "This game just removed an item it should not have. [bug-report]! => ([list of carried not warpable things]) ([list of worn not warpable things]).";
			otherwise:
				say "[one of]An acuter curate relieves you of the items you won't need any more. He points at himself. 'Rod Hare, Hoarder.' He [if player is female]mumbles pensively, 'Her road...[run paragraph on][else]points at you. 'Rad, hero.[run paragraph on][end if]' He points away. 'I scour curios.'[or]The hoarder takes your surplus stuff again.[stopping]";
		now all carried not warpable things are in lalaland;
		now all worn not warpable things are in lalaland;

chapter going to

understand the command "go to" as something new.
understand the command "goto" as something new.
understand the command "gt" as something new.

gotoing is an action applying to one thing.

understand "goto [any room]" as gotoing.
understand "go to [any room]" as gotoing.
understand "gt [any room]" as gotoing.

carry out gotoing:
	d "Trying location [noun].";
	if noun is not a room:
		say "You need to specify a room or a thing." instead;
	let noureg be map region of location of noun;
	if noun is location of player:
		say "You're already here." instead;
	if noun is strip and strip is visited:
		say "The command you may be looking for is RETRY. Do that now instead?";
		if the player consents:
			try retrying instead;
		else:
			say "OK." instead;
	if noureg is lalaland:
		say "You have disposed of what you're trying to get to." instead;
	if last-loc of noureg is unvisited:
		say "You haven't made it to that region, yet." instead;
	if noun is strip and mrlp is not stores:
		say "This is equivalent to the RETRY command, so that's what I'll do.";
		try retrying instead;
	if mrlp is routes:
		if player is in mesa:
			if the-b is in mesa:
				say "You can't go anywhere with the bean and the crowd around!" instead;
			if thing form above is in mesa:
				say "The thing form above is too big to ignore or walk out on." instead;
	if mrlp is troves:
		say "[if noun is visited]Going back would be a dereliction of your destiny[else]You must work to make your dreams of going there become reality[end if]." instead;
	if noun is unvisited and mrlp is noureg:
		say "You've never been there yet, so you can't go back." instead;
	if mrlp is not noureg:
		say "[if last-loc of noureg is unvisited]You haven't made it to that region, yet[else]That's in the wrong region[end if]." instead;
	if progval of noun > progval of location of player:
		say "You seem to be getting ahead of yourself. You shouldn't know about that, yet." instead;
	if noun is dirge ridge and mrlp is presto:
		if Leo is dismissed:
			post-wall-brunt;
			do nothing instead;
	if player is in shack:
		consider the shack-south rule;
		unless the rule succeeded:
			do nothing instead;
	d "From [progval of location of player] to [progval of noun].";
	if progval of noun < progval of location of player:
		repeat through table of progvals:
			if there is a rm entry and rm entry is noun:
				say "[why-not entry]" instead;
			if there is a regs entry and regs entry is mrlp:
				if rmprog entry is progval of noun:
					say "[why-not entry]" instead;
		say "There's no way back. You deserve a reason why, so this is a minor bug." instead;
	if noun is shunned:
		if noun is Lean Lane:
			say "Now you've visited the much-nicer Handsome Sand Home, you can't find your way back to Lean Lane, and there really wasn't anything there." instead;
		if noun is Scum Ant Sanctum:
			say "You got rid of the ant. Nothing more to do there." instead;
		if noun is lectures:
			say "You have better things to do than think of going back there." instead;
		say "That's off-limits." instead;
	if duck is in location of player and duck is friendly:
		say "(The duck follows, with quick-nag quacking, though you're walking pretty fast.)";
		move duck to noun;
	if Leo is in location of player and Leo is eager:
		say "(Leo and Rand following.)";
		move Leo to noun;
		move Rand to noun;
	move player to noun;
	if mrlp is towers and can-see-map:
		draw-my-loc;

understand "go to [any thing]" as gotothinging.
understand "gt [any thing]" as gotothinging.

gotothinging is an action applying to one visible thing.

does the player mean gotothinging a deregioned thing: it is unlikely.

carry out gotothinging:
	let newrm be location of noun;
	d "Trying person/thing [newrm].";
	if noun is a guardian:
		ital-say "this could be a bit vague, since each guardian can be seen from two rooms.";
	try gotoing newrm instead;

when play begins (this is the seed room progress for GO TO rule) :
	repeat through table of progvals:
		if there is a regs entry:
			repeat with myrm running through rooms in regs entry:
				now progval of myrm is rmprog entry;
		else:
			now progval of rm entry is rmprog entry;

Rule for supplying a missing noun while gotothinging:
	say "You're referring to something that isn't in the game or isn't available yet.";
	reject the player's command;

table of progvals [this determines which rooms are definitively ahead of others, so GO TO can't go backwards. Also, if a room is shunned, you can't go there any more.]
rm	rmprog	regs	why-not
--	0	manor	"Your manor was surrounded, and you escaped. Bad idea to turn back."
carven cavern	1	--	[manor]
--	0	routes	"[if progval of location of player is 3]Not from the boat, you aren't. You're much closer to your goal right now[else]The crowd would be sad to see you return, unsuccessful[end if]."
underpass	1	--	"You already muddled your way out of there. [if progval of location of player is 2]There's gotta be a way to get through da mist[else]And onto the boat, which must go somewhere[end if]!"
ripe pier	2	--	"You have no idea how to turn the cripple clipper around, and you don't want to."
cripple clipper	3	-- [routes]
posh hops shop	0	--	"The trolls would not welcome you back[if progval of location of player is 3], and it'd take too long to get there[end if]."
olde lode	1	--	"You don't want to go near that urn[if progval of location of player is 3], and it'd be hard, being on the other side of the shore[end if]."
Hero's shore	2	--	"No sense crossing back. There's more on this side of the shore."
--	3	oyster	[oyster]
loftier trefoil	0	--	"[if progval of location of player is 1]You had your fun in there[else]That's way in the past[end if]."
--	1	towers	"You don't want to cross Leak Lake again."
rawest waters	2	--	"Leak Lake wasn't fun the first time."
solo den	3
mislit limits	3	[towers]

chapter persuasions

[this is basically just to catch tries to order people instead of asking them. It offers some alternate commands.]

a person can be unemotional, fightin, washed up, eager, dismissed, henchy, deadish or nasty. a person is usually unemotional.

[most of this is for Leo/Rand but Elmer/Merle are that way too]

everpers is a truth state that varies.

persuasion rule for asking a person to try doing something when everpers is false (this is the persuasion disclaimer rule):
	ital-say "you don't need to ask anyone to do anything to complete the game, and in fact it's almost never useful, though I tried some humorous rejects. You are better off ASKing people about things.";
	now everpers is true;
	continue the action;

persuasion rule for asking a person to try doing something (this is the default persuasion rule):
	say "You mumble awkwardly, but then you think maybe you can try doing something for yourself, instead.";
	continue the action;

[general]

persuasion rule for asking pedanto-notepad to try doing something:
	say "CONSULT it instead.";
	persuasion fails;

persuasion rule for asking the parrot to try giving:
	say "[if player has whistle]Already got it[else]The parrot shakes its head. You'll have to earn that[end if]." instead;

persuasion rule for asking an animal to try doing something:
	if noun is dead flea:
		say "It's dead.";
		persuasion fails;
	if noun is raptor:
		say "You'd be better off changing it.";
		persuasion fails;
	if noun is yak:
		say "It's far too apathetic.";
		persuasion fails;
	if noun is parrot:
		if player is in alcoves:
			say "You aren't sure you want to alert the coevals to the parrot, helpless as it is right now.";
			persuasion fails;
		say "The parrot flies around, cocking its head vaguely west.";
		persuasion fails;
	if noun is eels:
		say "You need to use just one word at the right time.";
		persuasion fails;
	if noun is lamb:
		say "The lamb doesn't understand orders, or full sentences.";
		persuasion fails;
	if player is in wickeder wire deck:
		say "[if noun is reflexive]You don't have its trust[else]It perks up as if looking for something to attack but settles down again[end if].";
		persuasion fails;
	if player is in perverse preserve:
		say "The animal cannot understand your words.";
		persuasion fails;
	persuasion fails;

[routes]

persuasion rule for asking Pat to try doing something:
	say "If it could speak, it'd probably tell you you need to look inside yourself, anyway.";
	persuasion fails;

persuasion rule for asking Oscar to try doing something:
	say "He's too grouchy to be asked what to do.";
	persuasion fails;

persuasion rule for asking Brother Horbert to try doing something:
	say "Brother Horbert mutters absent-mindedly, maybe hoping YOU can do something for HIM, but too polite to say it.";
	persuasion fails;

persuasion rule for asking old giant to try doing something:
	say "He's much bigger and louder than you, so, no.";
	persuasion fails;

[troves]

persuasion rule for asking Pa Egg Pea to try doing something:
	say "If it could speak, it'd probably tell you you need to look inside yourself, anyway.";
	persuasion fails;

persuasion rule for asking astute statue to try doing something:
	say "Trevis Vister would like the thought of someone asking him to do something. Problem is, his answer would be negative.";
	persuasion fails;

[presto]

persuasion rule for asking the plebe to try doing something:
	say "The plebe stiffens further to attention. You are probably asking too nicely, and he's not used to that.";
	persuasion fails;

persuasion rule for asking a person to try doing something when player is in r24:
	say "[random visible person that is not the player] shrugs. He's just there to help, by being himself.";
	persuasion fails;

[oyster]

persuasion rule for asking Casper to try doing something:
	say "Casper doesn't even take orders from his editor sometimes.";
	persuasion fails;

persuasion rule for asking patrons to try doing something:
	say "They're here to NOT be ordered around.";
	persuasion fails;

persuasion rule for asking trolls to try doing something:
	say "The trolls snicker. You're not going to tell them what to do.";
	persuasion fails;

persuasion rule for asking carps to try doing something:
	say "Ordering them around won't help. Take action!";
	persuasion fails;

persuasion rule for asking pikes to try doing something:
	say "Ordering them around won't help. Take action!";
	persuasion fails;

persuasion rule for asking Aunt Tuna to try doing something:
	say "Hard to tell her what to do.";
	persuasion fails;

persuasion rule for asking Trout to try doing something:
	say "[if trout is reflexed]You've helped him enough--he needs time to absorb your lessons[else if trout is in range]He doesn't need orders--he needs help[else]You may need to show, not tell, him what to do[end if].";
	persuasion fails;

persuasion rule for asking walleyes to try doing something:
	say "They begin unglibly bullying. You're not in a bargaining position here.";
	persuasion fails;

persuasion rule for asking yapper to try doing something:
	say "He scratches his palm absent-mindedly. Or maybe deliberately.";
	persuasion fails;

persuasion rule for asking ant to try doing something:
	say "It understands only action. Violent action.";
	persuasion fails;

persuasion rule for asking a nasty person to try doing something:
	say "You need action, not words. Well, you sort of need [b]A[r] word..";
	persuasion fails;

[towers]

persuasion rule for asking pester'n serpent to try doing something:
	say "The serpent needs a change of attitude, and speaking won't do it.";
	persuasion fails;

persuasion rule for asking Ed Yerg to try doing something:
	if ed yerg is reflexive:
		say "Ed Yerg motions for money--money you don't have.";
		persuasion fails;
	say "Ed seems to want to sit and babble on.";
	try asking Ed Yerg about "xyzzy" instead;
	persuasion fails;

persuasion rule for asking a guardian to try doing something:
	say "If only it were that easy, to ask someone or something to move. You'll have to change them to get by.";
	persuasion fails;

persuasion rule for asking a warrior to try doing something:
	say "Rodney is the one giving the orders, here[if noun is rodney], and he doesn't want to take them from you[end if].";
	persuasion fails;

persuasion rule for asking trolls to try doing something:
	say "'You know what we'd like YOU to do?' the trolls chuckle.";
	persuasion fails;

persuasion rule for asking Casper to try doing something:
	say "You're not Casper's publicist or his editor, so, no chance of ordering him around[if recaps are reflexed], especially after that scraping[end if].";
	persuasion fails;

persuasion rule for asking doc-y to try doing something:
	say "Dr. Yow [if ropins is reflexive]mopes silently. He's already in prison--no need to order him[else]still looks exhausted from his ordeal. Maybe you should just let him be himself[end if].";
	persuasion fails;

[otters]

persuasion rule for asking Ed Riley to try doing something:
	say "He wags his finger. You need to find a way to dent his confidence.";
	persuasion fails;

persuasion rule for asking Elvira to try doing something:
	say "You've got the word power but not the conversation power.";
	persuasion fails;

persuasion rule for asking a person to try doing something:
	if noun is Elmer or noun is Merle:
		say "Elmer and Merle both blow you off.";
		persuasion fails;

persuasion rule for asking Le Mer to try doing something:
	say "You need to communicate less forcefully.";
		persuasion fails;

persuasion rule for asking macks to try doing something:
	say "The macks, like any good alpha males, blow you off and show Gretta Garett-Tatger SHE is most important.";
	persuasion fails;

persuasion rule for asking mr-l to try doing something:
	say "[if p-2 is reflexed]Mr. Lee can't do any more for you[else]Mr. Lee doesn't trust you enough to do anything for you[end if].";
	persuasion fails;

persuasion rule for asking whiners to try doing something:
	say "The whiners raise their voices and drown your request out. Maybe you can drain their energy, somehow.";
	persuasion fails;

persuasion rule for asking sly imp to try doing something:
	say "The imp gives a definite maybe you [one of][or]once again [stopping]believe. If only you could make him less subtle!";
	persuasion fails;

persuasion rule for asking a henchy person to try doing something:
	say "[noun] makes a huge display of only answering to--HER.";
	persuasion fails;

persuasion rule for asking macks to try doing something:
	say "The macks say 'You're not the boss of us!' and go on about breaking free from repression and mind control and so forth, and how if the maiden goes with them, they'll help her not be repressed by you.";
	persuasion fails;

persuasion rule for asking Gretta to try doing something:
	say "She's already beset by the macks. Best to help her out with your powers.";
	persuasion fails;

[others]

persuasion rule for asking Curtis to try doing something:
	say "[if dollar is not off-stage]Curtis can't do any more for you[else]Curtis gestures surprise that YOU are ordering HIM around[end if].";
	persuasion fails;

persuasion rule for asking Art Erd to try doing something:
	say "He's too slick to be ordered around.";
	persuasion fails;

persuasion rule for asking Len Craig to try doing something:
	say "Len's a businessman, and you're not his boss. Try haggling.";
	persuasion fails;

the persuasion disclaimer rule is listed first in the persuasion rulebook.

chapter telling about

chapter asking about

section generically

asking generically is an action applying to one topic.

Understand "tell about [text]" or "ask about [text]" or "talk about [text]" or "a [text]" as asking generically.

objasking generically is an action applying to one visible thing.

Understand "tell about [any thing]" or "ask about [any thing]" or "talk about [any thing]" or "a [any thing]" as objasking generically.

check objasking generically (This is the check for only one sensible object converser rule):
	if the number of persons enclosed by the location is one: [?? talkable vs ...]
		repeat with X running through visible scenery:
			repeat through table of default-gen-blather:
				if X is the default-talker entry:
					say "[gen-blah entry][line break]" instead;
		say "You inquire into your own thoughts. You gain no illumination." instead;
	if the number of persons enclosed by the location is two:
		repeat with candidate running through visible people:
			if the candidate is not the player:
				try objasking candidate about the noun instead;
	if player is in hops shop:
		try asking casper about the topic understood instead;
	say "Ambiguous--more than one other person here." instead;

does the player mean objasking about something hintrelevant: it is very likely.
does the player mean objasking generically a hintrelevant thing: it is likely.

objasking it about is an action applying to one thing and one visible thing.

rule for supplying a missing second noun when objasking about:
	now second noun is the noun;

understand the command "ask [thing] about [any thing]" as something new.
understand the command "tell [thing] about [any thing]" as something new.
understand "ask [thing] about [any thing]" as objasking it about.
understand "tell [thing] about [any thing]" as objasking it about.

understand the command "ask [thing] about [text]" as something new.
understand "ask [thing] about [text]" as asking it about.
understand the command "tell [thing] about [text]" as something new.
understand "tell [thing] about [text]" as asking it about.

[does the player mean asking generically casper: it is very likely.
does the player mean objasking generically casper: it is very likely.
?? we should put relative importance on a person, or last-asking]

Check asking generically (This is the check for only one sensible converser rule):
	if the number of persons enclosed by the location is one:
		repeat with X running through visible scenery:
			repeat through table of default-gen-blather:
				if X is the default-talker entry:
					say "[gen-blah entry][line break]" instead;
		say "You inquire into your own thoughts. You gain no illumination." instead;
	if the number of persons enclosed by the location is two:
		repeat with candidate running through visible people:
			if the candidate is not the player:
				try asking the candidate about the topic understood instead;
	if player is in hops shop:
		try asking casper about the topic understood instead;
	say "Ambiguous--more than one other person here." instead;

the can only talk to talkables rule is not listed in any rulebook.

check talking to (this is the hint looking not talking rule):
	if the noun provides the property litany and the noun provides the property greeting, do nothing;
	otherwise say "You may be better off examining non-living things, not talking to them." instead.

section chatstubs

to say i:
	say "[italic type]";

to say b:
	say "[bold type]";

to say r:
	say "[roman type]";

to washup-clue:
	say "[one of]'Us? Whaps?'[no line break][or]'Pah, wuss,'[or]'Haw, puss,'[or]'You'd place last in a saw push,'[or]'I like dat TV show the Upshaws,'[or]'Don't push aws on me,'[or]'Ssh! Up...aw,'[cycling] [noun] says, red-faced. He's not in the mood for deep discussion. But maybe a nice word would help.";

to reason-clue:
	say "It has NO EARS! Yet it buzzes its name...Sorena A. Norse. The noise makes you see red but lets up when you deduce the bee is a senora.";

section specifically

Rand-first is a truth state that varies.

check objasking it about (This is the check for object information rule):
	if noun is what-a-bee:
		reason-clue instead;
	if noun is pedanto-notepad:
		try consulting pedanto-notepad about "[second noun]" instead;
	if noun is duck:
		say "Quack, quack. It seems like it wants to hear a voice--but not yours." instead;
	if noun is not a person:
		try talking to noun instead;
	if noun is washed up:
		washup-clue instead;
	if noun is haunter and second noun is ruby:
		if haunter is reflexive:
			say "You need to get the haunter to trust you, first." instead;
		say "You describe the path to take to get to the ruby, neglecting why you know--fortunately, the haunter doesn't seem to care.";
		try going west;
		consider the track haunter rule;
		try going north;
		consider the track haunter rule;
		try going west;
		consider the track haunter rule;
		the rule succeeds;
	if noun is Leo or noun is Rand:
		if noun is fightin:
			if noun is Rand and Rand-first is false:
				now Rand-first is true;
				say "'ME RAND!' Rand points at you. 'AM NERD!' Er, [d-word]." instead;
			say "He's in a fighting mood, not a talking mood, right now." instead;
	if second noun is the player:
		say "Nobody in the game can tell you anything new about yourself. Well, anything new and helpful." instead;
	repeat through table of subject-blather:
		if second noun is the person-subj entry:
			if noun is the him-who entry:
				say "[him-say entry][line break]" instead;
	if the chum of the noun is not yourself:
		repeat through table of subject-blather:
			if second noun is the person-subj entry:
				if the chum of the noun is the him-who entry:
					say "[him-say entry][line break]" instead;
	repeat through table of default-sub-blather:
		if noun is him-who entry:
			say "[him-say entry][line break]" instead;
	if the noun is the second noun:
		repeat through table of reflexive-blather:
			if noun is him-asked entry and there is a him-told entry:
				say "[him-told entry][line break]" instead;
	if the second noun is a person-subj listed in the table of object-blather:
		if there is a right-region entry:
			if right-region entry is not mrlp:
				say "This is the wrong region to ask about that." instead;
		say "[him-say entry][line break]" instead;
	repeat through table of default-gen-blather:
		if noun is default-talker entry:
			say "[gen-blah entry][line break]";
			if noun is terse and noun is not terse-warned:
				now noun is terse-warned;
				say "Hm, that wasn't very revealing. They don't seem to have a lot else to say. You note this in your notepad.";
				pad-rec "talking";
			do nothing instead;
	if noun is not a person:
		say "You can only ask people about things." instead;
	say "There is an awkward silence due to--err, my forgetting this case.[paragraph break][bug-report]" instead;

check asking about (This is the check for specific topics rule):
	if noun is what-a-bee:
		reason-clue instead;
	if noun is pedanto-notepad:
		try consulting pedanto-notepad about "[second noun]" instead;
	if noun is duck:
		say "Quack, quack." instead;
	if noun is not a person:
		try talking to noun instead;
	if noun is washed up:
		washup-clue instead;
	if noun is haunter:
		if the topic understood matches the text "ruby":
			try objasking haunter about ruby instead;
	if noun is Leo or noun is Rand:
		if noun is fightin:
			if noun is Rand and Rand-first is false:
				now Rand-first is true;
				say "'ME RAND!' Rand points at you. 'AM NERD!' Er, [d-word]." instead;
			say "He's in a fighting mood, not a talking mood, right now." instead;
	if the topic understood is a topic listed in the table of general-blather:
		if noun is a person and noun is superchatty:
			if him-who entry is the noun:
				say "[him-say entry][line break]" instead;
				[would like to pad-rec "[what-pad-gen entry]" instead; but inform is confused with 2 tables??]
	if the topic understood is a topic listed in the table of popular-blather:
		if there is a right-region entry:
			if right-region entry is not mrlp:
				say "This is the wrong region to ask about that." instead;
		say "[him-say entry][line break]" instead;
	repeat through table of default-gen-blather:
		if the noun is default-talker entry:
			say "[gen-blah entry][line break]";
			if noun is terse and noun is not terse-warned:
				now noun is terse-warned;
				say "Hm, that wasn't very revealing. They don't seem to have a lot else to say. You note this in your notepad.";
				pad-rec "talking";
			do nothing instead;
	if noun is not a person:
		say "You can only ask people about things." instead;
	say "There is an awkward silence due to--err, my forgetting this case.[paragraph break][bug-report]" instead;

the can only talk to people with things to say rule is not listed in any rulebook.

section talk tables

[talktab]

to say uf:
	say "Any attempt at conversation would be banefully unflyable.[no line break]"

table of reflexive-blather	[ask x about x] [tor]
him-asked	him-told
Gunter	"His views would be biased."
Elmo	"You already know about his mission and what he's done to help you. No time for small talk."
nestor	"[if store k is visible]'Want...friends...man!'[else]You can't think of a way to ask that without saying WHAT DO YOU THINK YOU'RE DOING, buy you get the impression there's not much to ask.[end if]"
tokers	"[if store n is visible]'Missing our friend, man!'[else]You can't think of a way to ask that without saying WHAT DO YOU THINK YOU'RE DOING, buy you get the impression there's not much to ask.[end if]"
lecturer	--
idg	"'I'm nothing without Max P. Lee's help.' He goes on a bit. How tedious."
Brother Horbert	"He mentions he cannot do much--the Same Mesa needs magic to undo the curse, but the list-o-toils is on the wall[if list o toils is examined], as you've seen[end if]." [reflex ROUTES]
old giant	"He is already talking about himself, his complaints, and so forth."
Oscar	"'I'm just this guy, in this house, with that ashtray [if pipe soot is in adobe]full of nice smelling pipe soot[else]some self-appointed do-gooder cleaned out. Well, I can make more[end if].' Nope, he doesn't seem to have much to say."
Pat	"'[one of]No dine. Done in[or]Not much to munch[or]Food? Us? Doofus[cycling]. No [pat-rant][randbla] or [randbla][pat-rant]. [if mushrooms are off-stage]Can't even make it to the seed pit[else]Don't have your guts to explore the seed pit, either[end if].'"
armada	"They'll have nothing sensible to say in unison."
statue	"Oh, if it were the real version, you'd regret that."
plebe	 "You figure you should grill him about how worthless he thinks he is, but you lack the right word or words." [reflex PRESTO]
Rand	"He gives a whole new dimension to small talk. But not for long, thankfully."
Leo	"He gives a whole new dimension to small talk. But not for long, thankfully."
hogs	"The whole 'Who do you think you are' won't go well with these hogs. They're here to guard you, and that wall is helping."
l-m	"'I'm here to help, just by being me, apparently.'"
m-l	"'I'm here to help, just by being me, apparently.'"
Tom Alvez	"'I'm here to help, just by being me, apparently.'"
casper spacer	"Casper Spacer has a lot to say about himself...so much, it'd get in the way of your quest." [reflex OYSTER]
trolls	"They'd affirm their right to privacy before asking YOU personal questions. Trolls, sheesh."
patrons	--
clam	"Asking the clam about its feelings is a start."
boats	"They're too far away for proper conversation. Maybe you can do something bold to show them you're worth having aboard."
carps	"Asking these punks who they think they are won't stop them."
pikes	"Asking these punks who they think they are won't stop them."
trout	"[if trout is in anger range]You don't need to ask if he's being picked on,[else]'Well, I try my best and stuff.'[end if]"
aunt tuna	"She's talking about herself every move, pretty much[if trout is reflexive]. You can probably help Tortu instead[end if]."
sardine	"[one of]The sardine spends time babbling about his sensitive hearing, saying you couldn't possibly understand. But you sort of do[or]You don't want to hear the sardine on himself again[stopping]."
walleyes	"Now's not the time to upbraid baddies for being bad. Sneak past them instead."
yapper	"'I'm a dedicated public servant. I'm not paid to chat. But I'm not paid enough to keep you out, no matter what.' He winks."
smart kid	"'I like gadgets and building things! [if jetskis are not off-stage]I just need one more cool tool[else]I'd love you to try the jetskis, here[end if]!'" [reflex TOWERS]
pester'n serpent	"The serpent ."
inapt paint	--
muscly hulk	--
deacons	--
natives	--
snider diners	"'We are EATING,' they exclaim, drily. You'd like to rain on their parade, even a little."
sweatier wait-seer	--
salesmen	--
rewired robot	--
unripe iPrune	--
pirates	--
Ray Eck	--
grailman	--
costume man	--
bonker	--
ingrates	--
iPrune	--
organised	--
admirer	"'But enough about me! What about you?' You need a way to make them less interested in you."
doc-y	"Dr. Yow is too modest--and focused on his science--to bang on about his achievements or his imprisonment."
Atheists	--
Ed Yerg	"Ed Yerg mentions [if flowerpot is in lalaland]how happy he is you helped him. So happy, if you go out and come in, he might give you help with that palace[else if ed yerg is reflexive]his advice isn't cheap[else]he needs something to cheer him up[end if]."
Ed Riley	"[one of]Ed Riley blathers how he can stand up to WHO DO YOU THINK YOU ARE and all that sort of thing. You claim you were just trying to get to know him, then he says THEN YOU'LL KNOW I NEED TO GUARD THE WAY WEST, HERE. He speaks very authoritatively[or]You don't need another verbal smackdown, at least not in Ed's current tone of voice[stopping]."
whiners	--
macks	"Their opinion would be slightly biased. You can probably learn more about them by observing them."
Gretta	"She's got enough people asking about her right now."
Elmer	"'Slightly more interesting than my friend.'"
Merle	"'Slightly more interesting than my friend.'"
mr-l	--
le mer	--
eels	--
snail	--
hornets	--
racoon	--
ocelots	"[if ocelots are reflexed]They seem too shy to talk[else]They point to themselves and give a thumbs up[end if]."
satyr	--
leopard	--
badger	"[if badger is reflexive]It covers its exposed parts and turns away[else]It fumbles happily with its now-clothed chest[end if]."
sly imp	"He nods his head as if to say he's all right and he knew you'd ask."
haunter	"It makes ghostly noises and talks about how it wants its jewel back."
Elvira	"She sniffs haughtily. As if you have to ask! As if you're NOT too biased to believe the good things about her!"
Curtis	"'Just trying to rustle up fruit and biotech business. Need to be growing more than iPrunes or those discussing yorpberries.'"
Len Craig	"'I'm a businessman. What you got?'"
Art Erd	"'Traded a dead rat...' he mumbles."
passport	--

check asking Curtis about:
	if second noun is a fruit:
		say "[if second noun is in lalaland]'Yes, thanks for that.'[else]'That might be a good one to have.'[end if]" instead;

to say mon-men:
	say "'We're Elvira's monster mentors. Making REAL animals. You don't need Eden.' They [if Merle is reflexive][one of]babble a bit about the philosophies of Lhen Yost[or]prissily swear Elsy Noth is ruining kids['] morals[or]pay sycophantic respects to St. Hoylen[or]get all, ETHYLS, NO and make a drinking gesture and wag their fingers[or]discuss how they have to talk shy to Len[or]wonder if they should pull out the ole synth[or]discuss the philosophies of Lytheson[in random order], which leaves you seeing red[else]continue semi-squabbling[end if]."

to say war-duh: say "Rodney silences him from answering."

to say tho-eels:
	if inhib is false:
		say ", though you wonder if you need a double-charge after talking to the eels"

to say tho-need:
	if inhib is false:
		say ", though I feel you may not need the eels['] energy"

to say left-here:
	say "'I was told I was left here to help someone who needed it and might need a clue and---well, they didn't tell me what the clue would be.'"

to say doc-in-prison:
	say "He gestures to the ropins and then shakes an invisible fence of his own. As if he is too exhausted to talk any more[if doc-y has been rowdy or doc-y has been wordy]. You figured two ways to get him to talk[else if doc-y has been rowdy].";

before asking doc-y about:
	if doc-y is wordy or doc-y is rowdy:
		say "Interrupting is rude. He'll quiet down." instead;

before objasking doc-y about:
	if doc-y is wordy or doc-y is rowdy:
		say "Interrupting is rude. He'll quiet down." instead;

the basic RQ out of range rule is not listed in any rulebook.

An RQ out of range rule for a number (called max) (this is the modified RQ out of range rule):
	say "[one of]You murmur 'Umm...urr.' [or][stopping][if Gunter is visible]Gunter yells, 'Flounder, foul nerd!'[else if Elmo is visible]'Evil days.' / 'Ay, devils.' [else if Elvira is visible]You think 'Her slams, harmless. She can't chasten...' then she hits you with the phrase-phaser. You must respond. [end if][bracket][if max is 1]The only response right now is 1[else]Valid responses range from 1-[max][end if]. Type REPEAT to [if max is 1]see it again[else]re-list the options[end if].[close bracket][paragraph break]".

to say lrduh:
	say "'I dunno much about that. I like do stuff not think stuff.'";

pat-whine is a truth state that varies.

to say pat-rant:
	if pat-whine is false:
		now pat-whine is true;
	else:
		now pat-whine is false;

table of default-gen-blather	[ask x about nonsense] [tod]
default-talker	gen-blah
yourself	"You give an elfish 'Hi, self.' You discuss how maybe the game needs better developed NPCs, or maybe they just need to give more hints."
tokers	"The yawners aren't very answery, and you probably don't need a THC chat. They like you and all, but despite your adventuring, you'd never, like, invent a drug or do nothing as well as they do." [begin stores]
idg	"He nods at you and the lecturer. It's remarkably effective psychological warfare, to repress you and all."
lecturer	"If he actually heard you, he'd yell a stunning rebuke to whatever he could pretend you'd say, then chalk your confusion up to drugs. You just want to get away from all this TEDIOUS stuff."
urgent Gunter	"[bug-report]"
Mole Elmo	"[bug-report]"
Brother Horbert	"[one of]'Saint Tina's Nun of No Fun left a list-o-toils for possible curse cures. Check thou it before proceeding, if you haven't.'[or]After a fret, he says, 'The list-o-toils!'[stopping] He seems pretty focused on that." [begin routes]
Pat	"'[one of]No dine. Done in[or]Not much to munch[or]Food? Us? Doofus[cycling]. No [pat-rant][randbla] or [randbla][pat-rant]. Can't even make it to the seed pit.'"
Oscar	"He's too grouchy to give much help here. He mutters on about slotted dottles--which, well, you [if player has pipe soot]already have pipe soot[else if read-list is true]don't think will help you get any pipe soot[else]don't know or care much about, now, yet[end if]."
drama armada	"They stare blankly at you, fearful yet confident you know what to do next. They won't be much help."
old giant	"The giant is sort of controlling the conversation, and he's bigger than you. You probably just need to sympathize and avoid getting hit and so forth."
nestor	"'Whuh, whuut? Try asking me about, like, stuff instead. Not, you know, stuff.'"
what-a-bee	"The bee just buzzes. That's what bees do."
spider	"Talking to animals? This isn't the way to get to the top!"
lamb	"It's a baaaaad conversationalist." [begin presto]
l-m	"[left-here]"
m-l	"[left-here]"
Tom Alvez	"[left-here]"
hogs	"They snort and laugh as if you are beneath speaking to or even wasting harsh words at."
bored yak	"The yak, not being very yakety, does not talk back."
giant dead flea	"It's sort of dead. Not that it was great conversation when it was alive."
Leo	"[lrduh]"
Rand	"[lrduh]"
computer screen	"[if screen is on labs slab]Yelling at a computer never works. If you need to say something, just say it[else]The screen isn't even plugged in[end if]."
patrons	"The patrons would probably think YOU were drunk if you told them why you were here or asked questions." [begin OYSTER]
trolls	"Talking wouldn't distract them from [if silly-acts is 3]eventually beating you up[else]keeping you in the Posh Hops Shop[end if]. They'd just win the argument. They're trolls, after all."
Casper	"[if casper-talk is false]Before you can pull a bar seat abreast... 'Here's a hint, mac. GO HUNT A HANGOUT. Write that in your pedanto-notepad. I'm busy. Shoo.' He does, however, explain to you about the Horned Hedron and the Absolute Lout Base. And the ghost that may be haunting the area. You congratulate him on his storytelling, but he says 'Pff, nothing on this new novel of mine.'[add-hangout][else]'[ohai-casper][randbla][ohai-casper][run paragraph on]' he mutters to nobody in particular.[end if]"
clam	"It snaps back at you. Physically, not verbally. Words--okay, conversation--won't help it relax, so you clam up."
scary crays	"They chuckle a bit. You're not going to be able to talk your way out of this."
trout	"[if trout is reflexive]He needs a pep talk. Guidance. Even if it's not 100% correct[else]A pep talk won't do much good now[end if]."
carps	"They snot nots. Tons. Brusque, queer BS. You need to take action, instead."
pikes	"They snot nots. Tons. Brusque, queer BS. You need to take action, instead."
aunt tuna	"'There is not much to say, with the haunter lurking under Anger Range, and the Horned Hedron assailing innocent people!' Looks like you won't nyet-a-yenta."
sandier sardine	"He flashes a snider look as he reads in to your talk. 'Ear dins. Wish I worked at Adrien's.'"
weaselly walleyes	"They snicker menacingly and whisper loudly that you're probably scared of lots of things like ghosts. They aren't. Not even the haunter!"
haunter	"It does that whoo-whoo thing. WHERE IS MY JEWEL. You think you know which jewel."
yapper	"The yapper does not shut up about how he cannot be bribed, but he's kind of winking at the same time, and coughing. It seems you may need to do things the right way."
ant	"The ant twitches silently but menacingly."
dialer	"Your voice would be recognized as not evil enough, even if you got through."
intercom	"Your voice would be recognized as not evil enough, even if you got through."
spec-o-scope	"Try looking in it instead."
smart kid	"[if duck is not returned]'Hey! Do you know anything about making stuff? I read in the Turbine Tribune about making stuff that could cross the water! I wonder what's beyond there!'[paragraph break]'IDK, kid.'[paragraph break]'Oh, wait, you're just an adventurer, not someone who knows anything technical. Gosh, I didn't mean it like that. I just...don't have any information for you.'[else if gizmo is not in lalaland]'Boy! If only I had a tool to create jetskis!'[else]'Man! If I [jetskis-work], that'd be awesome! I wouldn't even care if they got lost. Just making stuff.'[end if]" [begin TOWERS]
doc-y	"[if ropins is reflexive][doc-in-prison].[else]'Ah yes! My rescuer! Thanks again! Are you interested in detailed technological phenomena? No?' He begins calculating on his fingers and working on an abstruse problem. He's probably not going to help you much, but he could help someone technical help you.[end if]"
drama armada	"The drama armada doesn't seem to respond to conversation. Maybe if you just boom out one word, they'll go along with it."
plebe	"Plebes aren't much for small talk. In fact, they get yelled at for that sort of thing. Hmm, maybe you could yell at him the right way to make him move."
muscly hulk	"He kind of stumbles with dialogue. Maybe you can make him stumble physically."
iPrune	"[one of]'I?! Prune?!' it cries, turning red at a perceived slight[or]'I may be UNRIPE, but I'm bigger than you!' it cries. 'If I was the same size, maybe you could use words to get me to let you by. But we aren't, so I'm not.' Hmph[cycling]."
robot	"'I have been REWIRED to let you by!'"
snider diners	"They talk about Dr. Enis until they're red."
organised ego drains	"The ego drains just aren't to be argued with. When you try to, you're that much more convinced you don't need to go [if player is in campsite]north[else]south[end if][if campsite is visited and shoreline is visited], especially since you walked around before[end if]."
pirates	"[one of]Harsh arrhs and the sound of shook hooks follow your attempt to converse.[or]'Yarrh, Harry,' they shout, and one of them makes fun of your skin tone. You feel like a spiter, hoping they get skin cancer.[in random order]"
reed's ale	"'He seems to want to talk, really, and at the same time, he doesn't. He keeps mumbling a sales pitch under his breath, and maybe if you listen a bit, you can remember it."
admirer	"They claim they never thought they'd love someone the way they love you! [one of]Off-guard, red-faced, you mumble, 'I? Rad? Erm...' Maybe you can stomach another compliment[or]You blush red hearing nonsense you two could be as good together as the popular society couple Red Irma and Ed Mirra[cycling]."
once-sad deacons	"'Deacons! A second!'[paragraph break][one of]'We hate you, but we won't tell you lies, tho['].' You blush and thank the coldest old sect. They seem to have more nastiness in reserve[or]They ignore you and disparage St. Helio--you turn red when they ask if you know who that is[or]Apropos of nothing, a deacon in red discusses [one of]the soil[or]the oils[in random order] here[or]One deacon gets a little too folksy with a 'This ole...' The others glare at him, turning red[or]The deacons huddle together for a bit, then agree. 'I.e. SLOTH!' They...they aren't very NICE deacons. Maybe you can change that[cycling]."
man covered in inapt paint	"He ignores your conversation. '[one of]They done wrong to ol['] Mel Fish. That's me.[or]They were all [']Shelf [']im!['] and on the paint went.[or]SMH. Life.[or]Eh. Films.[in random order]' he mumbles as his eyes go red[one of]. Maybe he has other things to mumble about[or][stopping]."
natives	"You seem unable to convince the natives they are too good to stand here, or to find a way to sucker them into moving. However, they do babble on about [one of]ST. EAVIN, the local church[or]the local SETI-NAV[or]TIN EVA'S bar[or]where to avoid AI VENTS[or]the local INVEST-A stock broker[or]a local celebrity named SVETINA[or]the TIN-SAVE recycling center[in random order], which makes you see red[one of]. Maybe there's more of that, if you can hack it[or][stopping]."
sweatier wait-seer	"'Trees! [one of]Aw, I[or]I, aw[in random order]...' he says, making you see red. 'I'm obviously [i]sweatier[r] than you, yet I am far less tired!'"
Ray Eck	"'Hmm? That's not as interesting as my bright red keycar, here.'"
duck	"It quacks."
ingrates	"[one of]They swat imaginary red ire-gnats as they brush you off[or]You're shocked by the [i]angriest[r] interruption imaginable[cycling]."
pester'n serpent	"It remains coiled."
alarming grailman	"'You do find me alarming, don't you? I always give 110%. No-one passes Liam Garn!'"
bonker	"You try to chat but feel like a, er, knob."
Atheists	"They start logic-bashing, when one of the junior atheists tries to make a point. [one of]'[one of]Eh...I[or]I...eh[in random order]...stats why God can't exist.' [or]'Is theta's...'[or]'This tea's...'[or]'Ah, test is...' [or]He says they should sell atheist gear like ties, hats. [or]St. Tiesha was, apparently, very nasty. [in random order]The atheist turns red, wondering if they had a right to speak up."
Andres	"[war-duh]"
Andrew	"[war-duh]"
Archie	"[war-duh]"
Barney	"[war-duh]"
Blake	"[war-duh]"
Bredo	"[war-duh]"
Cedrick	"[war-duh]"
Daryl	"[war-duh]"
Demitri	"[war-duh]"
Dewey	"[war-duh]"
Edwin	"[war-duh]"
Eldon	"[war-duh]"
Ernest	"[war-duh]"
Geno	"[war-duh]"
Goldy	"[war-duh]"
Leander	"[war-duh]"
Marcel	"[war-duh]"
Marlon	"[war-duh]"
Preston	"[war-duh]"
Reggie	"[war-duh]"
Royce	"[war-duh]"
Shane	"[war-duh]"
Terrance	"[war-duh]"
Tyson	"[war-duh]"
Wade	"[war-duh]"
Sir Rodney	"This standoff won't be resolved with diplomacy."
Ed Yerg	"[if ed yerg is reflexive]Ed Yerg babbles about how he's not GREEDY (and here he sees red) like Reg Edy, but if you're looking to restore the palace, he would like an assistant's fee. Or if you want to buy his land, it will cost a bit. Not that you seem to have anything valuable enough in your inventory[else if crocus is reflexed]Ed laments the fall of the curst palace--as lifeless as that succor crocus you're carrying[else if player has crocus]Ed looks at the crocus while wondering if you might be The One[else]'Old clues, eh?' He colludes--babbles, spectacled, avuncular, a polite ole tip about the palace. Make it [3-random] 'No closure, counselor,' you lament, but his general tone and how he says it seem to do something for you. Maybe it'll help something pop in your head[new-yerg-thing][end if]."
Ed Riley	"'Stay there in the rye, idle! Yielder!' he booms[ed-nonsense]. Be nice to quiet him down, somehow."	[start otters]
cinders	"You need to find the right way to ask them. One without speaking."
Le Mer	"[one of]It's kind of single-minded, but it's impressive the moat talks at all[or]Again, ethereal babbling[stopping]. '[if sea cube is visible]You must convince me to unlock the sea cube[tho-need].[else if eels are visible]The eels still distrust you[tho-need].[else]Your powers are regained. Go to your destiny![end if]'"
atmo-moat	"The moat has nothing to say. If it did, it'd probably just say 'KEEP OUT.'"
mr-l	"[if p-2 is in lalaland]'You have gained my trust and your powers. Go on!'[else if ghoul hat is in lalaland]You try to convince him you're the good guy, but--bad start. Rev. Howe glares at you[tho-eels].[else]You fail to get anywhere. Between the ghoul hat and Rev. Howe's gaze, Mr. Lee seems half-possessed[tho-eels].[end if]"
Gretta	"[if player is female]The macks block you from talking to her. They redouble their conversation, expecting her to be flattered she's getting more attention than you[else]The macks manage to small-talk you down[end if]. Perhaps you need to get rid of them."
macks	"'Talking's stalking,' they yell at you before continuing to hit on the maiden."
eels	"'Eels...' / 'Fib-beliefs?' Their attention span seems short, and they have little to say. You need one word, useless on its own yet powerful."
Elmer	"[mon-men]"
Merle	"[mon-men][no line break]"
sly imp	"He could talk circles around you as-is. You won't convince him to let you pass."
whiners	"Rational conversation won't make the whiners budge. You probably need to make them quieter."
hardy hydra	"Roooooooar."
ocelots	"[if ocelots are reflexive]Flimsy I'm-flys[else]'You're cool.'[paragraph break]'You? Cooler!' You feel [one of]encouraged by this exchange, impressed they got away with that[or]awkward about this repeat, but they don't--there's just nothing else to say around them[stopping][end if]."
badger	"[uf]"
leopard	"[uf]"
racoon	"[uf]"
satyr	"[uf]"
hornets	"[uf]"
snipe	"[uf]"
snail	"[uf]"
owls	"They're too busy swooping at you to talk."
raptor	"'Roooooooar.'"
parrot	"[if Merle is visible]Don't blow his cover![else]'Fear the feather! A bird, rabid!' He's got revenge fantasies, but not in his current state--or here."
Elvira	"'I watch a witch,' you mutter. 'Nice try. Tiny rec. Y'cretin.' You're not going to out-debate the vexin['] vixen."
Curtis	"'I'm a busy man!' yells Curtis. 'I have confidence in you, dealing with fruit. I mean, you saved the whole COUNTRY already. This can't take too long." [begin others]
Len Craig	"[one of]Len proceeds to tell you how he was known as Icy Len til he started doing things nicely and even suggests you use nonverbal cues as a way to get an edge[or]Your magic powers do not, alas, expand to straightforward bargaining[stopping]."
Art Erd	"He mumbles 'er, drat' and something about how money is very, very nice."
salesmen	"They utterly ignore your inquiry and instead talk about anything and talk about how they can talk about anything. They talk about how just one word has the power to change things. And finally, they get around to how great Nerd-Aid is, and you shouldn't be ashamed if you need a little Nerd-Aid."
passport	"Try using its features instead."

to say jetskis-work:
	say "[if kid has gizmo]could make some jetskis here[else]could see if these jetskis work[end if]";

casper-talk is a truth state that varies.

to say add-hangout:
	now casper-talk is true;
	pad-rec "hangout";

Leo-traveled is a truth state that varies.

after going north in burnt brunt when Leo is eager:
	now Leo-traveled is true;
	continue the action;

to say pal-yak:
	if yak is visible:
		say "'Dat thing looks sleepy but it'll bite your hand off.'";
	else if Leo-traveled is true:
		say "'Dat yak we saw is too heavy for us! But I bet even you could push it around yourself. No offense.'";
	else:
		say "'My mouf? Oh, a yak, not a yap.'";

to say doc-on-lake:
	if kid is in subsector:
		say "The kid almost seems to interrupt you with an idea how to get across.";
		continue the action;
	if kid is reflexive:
		say "'It's treacherous to get across the lake. I am too physically tired to make anything[if doc-y is in ropins] even if I escaped[end if]. I could use an apprentice. Maybe you. Or you can find me one.'";
		continue the action;
	say "'My student will help you--there may be some risk. The carelessness of youth. You may be surprised what he can overlook.'"

check objasking kid about jetskis:
	try taking jetskis instead;

table of default-sub-blather	[dsb] [ask x about Gunter]
him-who	him-say
yourself	"Oh, dear. Is this a hint the game needs better developed NPCs?"
aunt tuna	"'Oh, that is not relevant with the haunter lurking below and the Absolute Lout Base terrorizing everyone here! My concern is my nephew Tortu.'"
nestor	"Nestor mumbles about how his father is disappointed he didn't become a senator, just...he wants [if tokers are visible]to just hang with his pals, if that's okay[else]to find his pals, who were in a nearby store[end if]."
astute statue	"Trevis would love to be prayed to, and he probably thinks he deserves it."
Len Craig	"'No small talk. Just the language of business. Let's haggle.'"
Curtis	"Curtis is curt. 'Yeah, great job saving Yorpwald and all, what about here?'"
lamb	"It's a baaaaad conversationalist."
Leo	"[lrduh]"
Rand	"[lrduh]"
yak	"You yack, it's all C-ya, K? Nevertheless, it seems to have some rudimentary grasp of speech and words and meaning."
[Logan	"'No mo' rig mooring.'"]

casper-mumble is a truth state that varies.

to say ohai-casper:
	if casper-mumble is true:
		now casper-mumble is false;
	else:
		now casper-mumble is true;

table of subject-blather	[ask x about thing he knows about] [tosb]
him-who	person-subj	him-say
Elmo	settler	"This shouldn't be available."
nestor	Store N	"'Man, it was actually kind of sort of like fun in there. Until it wasn't.'"
nestor	tokers	"[if tokers are visible]Nestor gives them a thumbs-up, they cheer drippily, and he cheers back[else]'Dude! Could you magic them back somehow?' he pleads[end if]."
tokers	Store K	"'Man, it was actually kind of sort of like fun in there. Until it wasn't.'"
tokers	nestor	"[if nestor is visible]They thank you for finding him[else]They weep at hearing the name of a lost friend[end if]."
tokers	smoke cloud	"[if cruelest lectures is visited]You know more about it than they do[else]'Er, free reefer!' they say. You'd probably have SOME sort of experience going through those fumes[end if]."
lecturer	Elvira	"You probably know he's in favor of her."
idg	lecturer	"A great man. Listen to him, not me."
idg	Elvira	"She didn't get to her position of power by using DRUGS."
Brother Horbert	spoon	"'[if spoon is in lalaland]I hope you used it wisely[else]It may help you figure where to go[end if].'"
Brother Horbert	rev	"[one of]Brother Horbert shudders a bit[or]Best not to press him[stopping]."
Brother Horbert	list o toils	"[if l-o-p is unexamined]Why not examine the list yourself?[else if mushrooms are off-stage]You've gotten everything.[else if number of held quest-items is 0]You tell Brother Horbert you haven't found any items on the list. He says he has faith in you.[else]You show Brother Horbert your progress. He nods and smiles.[end if]"	[horbert tells about quest items elsewhere]
Brother Horbert	form	"[if form is off-stage]Brother Horbert mutters something about the gift of second sight.[else]Brother Horbert says, 'If you found the reagents, surely dealing with that form will be easier!'[end if]"
Brother Horbert	Pat	"[lost-faith]"
Brother Horbert	Oscar	"[lost-faith]"
Brother Horbert	old giant	"'Well-meaning, but his wrath is misplaced. I can hear him from here. You [if giant is in lalaland]did well to listen to him[else]may learn from listening to him, but there is nothing to fear[end if].'"
old giant	bench	"There's not much dispute over the ownership. And the giant isn't trying to shoo you away. Maybe you should listen to the giant in general."
oscar	ashtray	"[if player has pipe soot]Best not to call attention to your thievery.[else]'It's not pretty, but it's mine.'[end if]"
oscar	pipe soot	"[if player has pipe soot]You don't need to mention you have it.[else]'Potpourri. Don't think you can just take it with me looking.'[end if]"
oscar	pat	"'I wouldn't go in that deli unless I needed something besides a meal.'"
oscar	giant	"'Keeps my home less quiet, I'm sure!'"
oscar	Brother Horbert	"'He means well, but he can't really HELP us.'"
pat	seed pit	"[if pit is reflexive]'IT'S DEEP,' yells Pat.[else]'Well, it didn't scare YOU, but it'll still scare customers.'[end if]" [end routes]
pat	oscar	"'Him and his filthy pipe. Not welcome here.'"
pat	giant	"'Probably not good for business.'"
pat	Brother Horbert	"'He means well, but he can't really HELP us.'"
plebe	Elvira	"[one of]The plebe looks distinctly uncomfortable but nods. Perhaps they don't agree with Elvira, but their job is to serve and protect, blah blah, especially when intimidated by authority. Hey. Maybe you could be that authority[or]You don't need to ask them again. They, like any good plebe, are intimidated by authority[stopping]."
plebe	Leo	"You tell the plebe Leo might push him aside, but no dice. Maybe a brutish word, not brute force."
plebe	Rand	"You tell the plebe Leo might push him aside, but no dice. Maybe a brutish word, not brute force."
Rand	yak	"[pal-yak]" [chum=Leo]
Rand	plebe	"[no-plebe]"
Leo	hogs	"[if phat path is unvisited]You haven't seen any hogs yet.[else if lawl wall is in lalaland]'Dat was fun. You was clever.'[else]'If only you was our size, we could just take [']em. But you ain't. No offense. Maybe you can out-clever [']em like you did us.'[end if]"
Rand	Leo	"[if Rand is washed up and Leo is washed up]We're washed up, boss. We could use a nice word.[else if Rand is fightin]This is no time for conversation![else]He flashes a thumbs-up at his friend.[end if]"
Leo	Rand	"[if Rand is washed up and Leo is washed up]We're washed up, boss. We could use a nice word.[else if Leo is fightin]This is no time for conversation![else]He flashes a thumbs-up at his friend.[end if]"
hogs	Rand	"'They size him up and give a thumbs-down. Then they give you a double thumbs-down. Ouch! No respect.'"
hogs	Leo	"'They size him up and give a thumbs-down. Then they give you a double thumbs-down. Ouch! No respect.'"
l-m	volt maze	"[maze-end-clue]."
m-l	volt maze	"[maze-end-clue]."
Tom Alvez	volt maze	"[maze-end-clue]."
l-m	m-l	"[maze-later]."
l-m	Tom Alvez	"[maze-later]."
m-l	l-m	"[maze-before]."
m-l	Tom Alvez	"[maze-later]."
Tom Alvez	l-m	"[maze-before]."
Tom Alvez	m-l	"[maze-before]."
hogs	popgun	"They snicker at the memory."
hogs	keys	"They snicker at the thought of you being clever or strong enough to get the keys."
hogs	Leo	"The hogs smirk and flex a bit, to show they're bigger and stronger."
hogs	Rand	"The hogs smirk and flex a bit, to show they're bigger and stronger."
hogs	yourself	"The hogs smirk and flex a bit, to show they're bigger and stronger." [end presto]
trolls	Casper	"[one of]'A great man! We're sure his books are great, if you have nothing better to do than read. But he LIVED his books.'[or]'Wanna know about him, ask HIM.'[stopping]"	 [oyster]
trolls	capers	"[if stein is in lalaland][yeah-cute][else]'Hard-hitting stuff, we're sure. He's told us what's in there. Poke at it wrong, you'll upset the man himself.'[end if]"
trolls	stein	"[if stein is in lalaland][yeah-cute][else]'Don't go putting it somewhere stupid and breaking it.'[end if]"
trolls	tunes	"[if song is in reflexed][yeah-cute][else]'Don't be messing with the tunes or the amper on the jukebox. Annoy a lot of people.'[end if]"
trolls	gins sign	"[if sign is reflexed][yeah-cute][else]'Lots of people think they're really cute, like they've got something special can make them disobey that sign.'[end if]"
trolls	stumbler tumblers	"[if sign is reflexed][yeah-cute][else]'Best to cough up some tips in there. For the wait staff.'[end if]"
trolls	haunter	"[one of]'Hasn't bugged us yet. What, you scared of it? Aww.'[or]Asking again would just make them snicker more.[stopping]"
patrons	Casper	"'Weirdo. With his books. Even if they're books where people drink a lot."
patrons	trolls	"'They rather keep us in and make us spend more than kick us out.'"
Casper	haunter	"'I heard it's buried on the other side of the shore. Need to bring it something lost."
Casper	trolls	"'They are rough and ready types. I will include some of their gritty dialogue in Capers Recaps. With their permission, of course.'"
Casper	capers recaps	"Casper wants you to acknowledge he's writing it, but he's not going to hand out spoilers."
Casper	Elvira	"'She certainly knows how to seek out power. She showed that anagram chump what's what.c [if player is female]She's no woman[else]He's no man[end if] of action.'"
carps	trout	"[mean-fish]!" [chum=pikes]
carps	Aunt Tuna	"[mean-fish]!"
carps	Casper	"They probably like books more violent than Casper Spacer's. If they read at all.'"
carps	haunter	"They are probably too coo-ool for ghost stories."
carps	pikes	"You could maybe set them against each other, but really, you're the strongest...life form here."
pikes	carps	"You could maybe set them against each other, but really, you're the strongest...life form here."
trout	carps	"[if player is in range]You can ask about them later. They're pretty clearly picking on him here[else if trout is reflexive]He gives a blank look of fear[else]He feels like he can handle them and their taunts now[end if]."
trout	pikes	"[if player is in range]You can ask about them later. They're pretty clearly picking on him here[else if trout is reflexive]He gives a blank look of fear[else]He feels like he can handle them and their taunts now[end if]."
trout	aunt tuna	"[if carps are visible]The carps are already asking mean questions.[else]She sure is grateful you rescued me.[end if]"
trout	haunter	"'S-s-s-cary[if trout is reflexive], even after you helped me[end if]!'"
trout	Casper	"'I don't like his books. Too violent. But Aunt Tuna thinks I read the dirty bits, anyway.'"
aunt tuna	tea	"'[if tea is in lalaland]It's much better than[else]The stuff you drink? or[end if]...'"
aunt tuna	tea	"'[if tea is in lalaland]Goodness! I cannot share the recipe[else]Try it! You'll like it[end if].'"
aunt tuna	pikes	"[bbbullies]."
aunt tuna	carps	"[bbbullies]."
aunt tuna	haunter	"'It is searching for a stolen treasure. They say it will wreak terrible havoc on the possessor.'"
aunt tuna	walleyes	"[fish-these-days]."
aunt tuna	sardine	"[fish-these-days]."
aunt tuna	yapper	"[fish-these-days]."
aunt tuna	Horned Hedron	"'It is a terrible place full of horrible people! But we cannot organize to drive them out.'"
aunt tuna	trout	"'He is a good boy despite no fine uncle influence, [if trout is reflexed]and you have helped him to ward off those weirdos so wired in the future[else]but those weirdos so wired may still pick on him[end if].' Tortu blushes at being treated like he might be eavesdropping."
aunt tuna	ruby	"Aunt Tuna wouldn't believe you knew anything about the jewel[if player has ruby], and seeing it might cause her heart failure[end if]."
aunt tuna	Casper Spacer	"'A vile man, I'm sure! And those BOOKS of his! Or so I've heard!'"
sardine	haunter	"'I'd be scared of it, if it existed. And if I was the one stole its jewel. We all would. Well, weak-os are, anyway.'"
sardine	Elvira	"'I wouldn't have this job if it weren't for her.'"
haunter	ruby	"It acts all ghostly and asks you to take it where the ruby might be."
walleyes	haunter	"'Anything to keep the sheeple scared.'"
walleyes	ruby	"'Bet we could sell it to raise funds for the Base! But we'd keep a nice cut.'"
walleyes	sardine	"'We'll have fun narcing him out for letting you in. What? He's already gone? Eh.'"
walleyes	Casper	"'Nice books, love the violence, but too many big words.'"
yapper	dialer	"'Very complex machinery! Shouldn't be used without proper certification."
yapper	gleaner	"'Very pretty! I--well, I know a friend who could be bribed by it.' The yapper winks."
yapper	Casper	"'That one book. About how beating people up was more fun than riches? Rubbish.'"
yapper	ruby	"'The ruby would've been a good gift, but it's gone, now.'"
yapper	haunter	"'I'm sure I'm safe from it here. Unless--that pearl's not its jewel? No? Good.'"
yapper	sardine	"'Pft, foot soldiers, working for mere salary.'"
yapper	walleyes	"'Pft, foot soldiers, working for mere salary.'"
yapper	Casper	"'Too much violence in his books, not enough money making.'"
yapper	Elvira	"'She's called on the dialer a few times.'"
salesmen	Nerd-Aid	"The salesmen [one of]are more than happy to talk about Nerd-Aid. They're not nerdy themselves, but they just want to HELP people, because yay tolerance. They [or][stopping]mention [one of]it's much better than that red Rind-Ade, and if you ask again, they'll tell you who endorses Nerd-Aid[or][endorse-aid][cycling]."
kid	doc-y	"[if kid is lonely and doc-y is in ropins]'I heard he was imprisoned. But I'd love to learn from him.'[else if kid is lonely][one of]'Wow! You rescued him? You're almost as awesome as he is!' [kid-fol][or]'Tell me something I don't know. Or get Dr. Yow to.'[stopping][else if kid is following]'Just lead me to him, already.'[else]He's zoned you out, what with Dr. Yow [around-gone].[end if]"
kid	jetskis	"'Man, I'm learning to build stuff! [if jetskis are off-stage]Like jetskis! [end if]But I need someone to try them.'"
kid	keycar	"'I'd love to make one of them! But that man said I wasn't grown up enough.'"
kid	Atheists	"'Boy! Tell them religion has a point, and they get huffy. Thanks for deep-sixin['] [']em!'"
kid	deacons	"'Boy! Ask one question about their religion, they get huffy. Thanks for deep-sixin['] [']em!'"
kid	settler	"'Wow! I'm real impressed with who built this! Whatever it is. [if jetskis are visible]All I can build is mechanical stuff[else]I'd like to build something, too[end if].'"
kid	gizmo	"[if gizmo is off-stage]'I could use a weird tool to build things.'[else if player has gizmo]'Wow! Maybe if I knew how to build something, I could have it?' You could probably GIVE it to the kid, once he's inspired to build something.[else]It's be kind of rude to ask for it back. The kid'll use it better anyway."
kid	duck	"'I'm not real big on biology. But I guess ducks are cute.'"
kid	toaster	"[if toaster is in coastlines]'Gee, thanks for it! I'll do something cool with, I mean to, it!''[else if toaster is in Danger Garden]You think back to the toaster in the garden. It might be worth giving the kid, as a nice gift, if you ever leave.[else]You show the toaster to the kid, who's very interested, but he says he'd feel guilty taking it before he actually helped you.[end if]"
doc-y	duck	"[if ravages is unvisited]'I miss my duck! When they captured me, I was clear in a west waste.'[else if duck is not in subsector]'I--I'm too exhausted to get my duck. If you could bring it back--it just needs to hear my voice.'[else]'Very loyal to me. It might ignore you now, but...thank you.'[end if]"
doc-y	gizmo	"[if doc-y is in ropins]'Not enough sharp edges. It's for making things...crafting.'[else]I'm too tired to make anything, but maybe an eager apprentice...it's a newfangled device for younguns anyway.'[end if]"
doc-y	bonker	"[one of]Dr. Yow facepalms a bit. You can imagine listening to that bonker was even worse if you were imprisoned, too[or]No need to dredge that up, again[stopping]."
doc-y	lake	"[doc-on-lake]"
doc-y	kid	"[if kid is reflexed]'A sharp learner! He can help you now.'[else if kid is in subsector]'He is smart enough, but he's not ready to learn. For some kids, they just need that switch to go on.'[else]'I could use a young apprentice. You--well, you probably have other prisoners to rescue, or something.'[end if]"
salesmen	curst palace	"They mention their homes are dandier than that curst palace."
ray eck	settler	"Ray Eck just won't shut up about what the settler could be for, and why it doesn't do anything. You notice its colors don't change even when you switch it to and from cheat mode, which--well, that's a pretty big help."
Ed Yerg	curst palace	"'It can be something super special. [3-random]! If only...' You got no concrete clues, but Ed's pep talk was a help[new-yerg-thing]. Maybe you can come back for another, later, if you still have no luck outside."
Ed Yerg	crocus	"[if ed yerg is reflexive]'I don't think much of unprofitable things like flowers. Used to, but not now.'[else if crocus is in lalaland]Don't push-poll him about your generosity.[else if crocus is in flowerpot]Just give him the crocus. Don't tease him.[else]'I haven't enjoyed flowers for a long time.'[end if]"
Ed Yerg	flowerpot	"[if ed yerg is reflexive]'Worthless, with or without a flower in it.'[else]'From Daltho, eh? Very nice.'[end if]"
Ed Yerg	Old Hat Daltho	"[if ed yerg is reflexive]'Hmph. Never did cash in on his talents as much as he should have.'[else if flowerpot is reflexive]'Thank you for passing his wonderful gift on to me.'[else]'I miss him. I'd like any sign from him.'[end if]" [end TOWERS]
Ed Riley	Elvira	"'She got me this job here! She's gotten lots of people jobs, telling others what they can't do.'" [start OTTERS]
macks	Elvira	"'She would be too good for us.'"
eels	Elvira	"'The eels crackle and light up menacingly at the sound of her name.'"
Le Mer	Elvira	"'She must be defeated[if eels are reflexed]. You can lead the troops to do so[end if].'"
mr-l	Elvira	"'She must be defeated[if p-2 is reflexed]. You must be the one to lead us[else]. If you are not with her, show me a sign[end if].'"
Elmer	Merle	"'Almost as interesting as me.'"
Merle	Elmer	"'Almost as interesting as me.'"
Elmer	Elvira	"'She is up to something interesting to the west, you'll have to admit. And you'll have to trust us.'"
Elvira	Gretta	"'Not as unselfish as she thought she was.'"
Elvira	mr-l	"'Hopeless. Paranoid.'"
Elvira	eels	"'Their electric shocks would be useful--but they didn't let me harness them.'"
Elvira	Le Mer	"'Not dangerous.'"
Elvira	Merle	"'He will get his reward. Even if he hadn't let you by.'"
Elvira	Elmer	"'He will get his reward. Even if he hadn't let you by.'"
Elvira	Ed Riley	"'I didn't expect much from him.'"
Elvira	whiners	"[if whiners are in Anteroom]She's not going to HELP you with them[else]You explain you got past them, and she shrugs[end if]. Henchmen these days. That's why they're henchmen and not leaders."
Elvira	sly imp	"[if imp is in Anteroom]She's not going to HELP you with the imp[else]You explain you got past it, and she shrugs[end if]. Henchmen these days. That's why they're henchmen and not leaders."
sly imp	Elvira	"'Oh, you know her too? Of course you don't! If you did, you'd know you couldn't go beyond here.'"
whiners	Elvira	"They bang on about how Elvira would be furious if they let someone see the animals to the south."
Elmer	Elvira	"'She is a great leader. You do not deserve to visit her to the west.'"
Gretta	Elvira	"[if macks are visible]Gretta cringes even more at hearing Elvira's name, but she can't do much with those macks around, and neither can you[else]You are already talking about Elvira[end if]."
Merle	Elvira	"'She is a great leader. You do not deserve to visit her to the west.'" [end otters]
curtis	rampage note	"'[if rampage note is off-stage]What note? You can't pin that on me.[else]None of your business.[end if]'"
curtis	mopeage rant	"'[if rampage note is off-stage]What note? You can't pin that on me.[else]None of your business.[end if]'"
curtis	Art Erd	"[one of]Curtis breathes deeply and gives a look of contempt and shakes his head[or]No point asking again[stopping]. Just don't tell him any fruit you [gave-give-curt] him is from Art Erd."
Art Erd	curtis	"'There's people with silly science ideas like him, then there's businessmen like ME. Pfft.'"
Art Erd	storage box	"'[if storage box is in scape space]It's...umm...worth something.[else]You bought it[end if].'"
Art Erd	len craig	"'Nicely? Len? Icy!' he mutters. 'Cut Len's cluster...'"
len craig	curtis	"[one of]'Nice fella, lots of ideas about agriculture, but no business sense. Just sits looking for someone to do his dirty work for him. You don't...'[or]You don't want to admit Curtis has you gofering. Though, really, it's been not too bad, with your powers.[stopping]"
len craig	tekno-token	"[if tekno-token is off-stage]'We accept tekno-tokens, yes.'[else][one of]He inspects the token and says it's valid[or]If you ask again, Len might question its validity[stopping].[end if]"
len craig	Art Erd	"Len snorts and shakes his head. 'What a weasel.'"

to say endorse-aid:
	say "[one of]it's endorsed by Red Dina, among others[or]endorsed by Ned Radi, among others[or]endorsed by Ed Nardi, among others[or]endorsed by Ed Darin, among others[or]endorsed by Adi Dern[or]endorsed by Nerd Ida, of course[or]you can Add Erin, Reid, Dan to the list of endorsers[cycling]--they see red when you ask who THAT is"

check objasking Elvira about an animal:
	if second noun is in wire deck or second noun is in perverse preserve:
		say "'Elvira scrunches her face up. 'Oh! I love animals! They help me in many...WAYS. Even if they're just...wimpy.'" instead;

to say mean-fish:
	say "They'd have nothing nice to say, and you don't need to encourage them. Take action instead";

to say fish-these-days:
	say "Aunt Tuna probably has a lecture prepared about fish these days. One that won't help you go hunt a hangout";

kid-cheat is a truth state that varies. kid-cheat is false.
kid-guar is a person that varies. [kid-guar is usually nothing.]

check objasking kid about a guardian:
	if second noun is in lalaland:
		if second noun is not ray eck and second noun is not deacons:
			say "That's out of the way." instead;
		else:
			say "The kid doesn't want to be reminded, probably." instead;
	else:
		if kid-cheat is false:
			if second noun is curst palace:
				say "The kid puts his hand to his face, then mumbles 'Sorry, eleven letters is too much. Maybe something shorter.'" instead;
			choose row with the-from of second noun in the table of anagrams;
			now kid-guar is the-from entry;
			now kid-cheat is true;
			say "The kid sits and thinks a few seconds after you tell him where you were stuck. 'Yeah, you just say [right-word entry in upper case]. That'll do it.' He looks kind of bored, though. Probably not nice to push him.";
			preef the-from entry instead;
		else:
			if kid-guar is not noun:
				say "The kid mumbles he's bored with word games." instead;
			if kid-guar is in lalaland:
				say "You thank the kid for helping you out." instead;

doc-cheat is a truth state that varies. doc-cheat is false.
doc-guar is a person that varies. [doc-guar is usually nothing.]

check objasking doc-y about a guardian:
	if doc-y is in ropins:
		say "He doesn't need the added pressure, but maybe he can give a bit of help once he's out." instead;
	if second noun is in lalaland:
		if second noun is not bonker:
			say "You don't need to worry about that, now." instead;
	else:
		if doc-cheat is false:
			if second noun is curst palace:
				say "Dr. Yow scrunches his head a bit, then shrugs. 'Ouch. Eleven letters. Maybe if it was shorter.'" instead;
			choose row with the-from of second noun in the table of anagrams;
			now doc-guar is the-from entry;
			now doc-cheat is true;
			say "Dr. Yow sits and thinks a minute after you tell him where you were stuck. 'Mm, yes. Of course, of course. I'd think Yeah, you just say [right-word entry in upper case] should work.'";
			preef the-from entry instead;
		else:
			if doc-guar is not noun:
				say "Dr. Yow rubs his temples. He's probably up to more technical stuff, now." instead;
			if doc-guar is in lalaland:
				say "You thank Dr. Yow for helping you out." instead;

check objasking len craig about a fruit:
	if player has second noun:
		if second noun is raspberry or second noun is pineapple or second noun is grapefruit or second noun is blackberries or second noun is strawberries:
			say "'A nice fruit, and it's fresh, but I'm selling today.'";
	else if second noun is visible:
		say "You are about to haggle, but Len looks at you just SO. You need to go about things the right way.";
	else if second noun is in lalaland:
		say "You don't need to get Curtis any more of that.";
	else if second noun is kumquat or second noun is papayas:
		say "Len looks at you askance, not sure how you know about those fruits.";
	else if second noun is mango:
		say "Someone else has [']em, if you look around, or about, a-ways.";
	else:
		say "'A fine fruit, but I don't deal in that. Maybe someone else does.'";
	the rule succeeds;

check objasking curtis about a fruit:
	if second noun is in lalaland:
		say "'Yes, thanks, it'll be useful.'" instead;
	say "'Hm, yes, I could use one of those.'" instead;

to say no-plebe:
	say "'I respect da military too much to push him outta da way. Plus I can't yell clever neither.'"

to say bbbullies:
	say "She seems more worked up about them than Tortu was[if trout is reflexed], even after your lesson[end if]. But she means well."

to say yeah-cute:
	say "[if silly-acts is 1]The trolls patronize you not to try any more funny stuff.[else if silly-acts is 2]The trolls mention they can still take a little more of your destructive nonsense. They've seen worse. And dealt with it, too.[else]The trolls shoot you a look that says both stay here and get lost at once. Best not to bait them any more.[end if]";

to say lost-faith:
	say "'One of many of my flock who have lost faith.'";

to say maze-end-clue:
	say "'I was told not to congratulate myself if I made it to the start, from point Z to point A. Not that I was told the way through.'";

to say maze-before:
	say "'Oh! You met him? I hope he helped you a bit. He told me about the weird scanner you have.'"

to say maze-later:
	say "'Oh! He'll drop by later. I hope you don't need his help too much.'"

to say gave-give-curt:
	if banana is in lalaland or orange is in lalaland or guava is in lalaland or rhubarb is in lalaland:
		say "gave";
	else:
		say "give";

check objasking a warrior about a warrior:
	if noun is rodney:
		if second noun is in lalaland:
			say "No gloating, now" instead;
		if second noun is off-stage:
			say "I don't think you want Rodney to call up reinforcements." instead;
		say "[if second noun is rodney]You probably know what he thinks of himself[else]You doubt Rodney would tell you [second noun]'s weakness[end if]." instead;
	if second noun is rodney:
		say "You wouldn't expect to hear any secrets. Rodney's got [noun] scared." instead;
	say "[if second noun is not visible]Who?[else]You probably won't be able to start dissent that way. Better to [pick-keep]." instead;

check objasking a warrior about curst palace:
	say "He only knows he's supposed to defend it from you. He probably wasn't given any secrets to divulge." instead;

to say pick-keep:
	if number of warriors in lalaland > 0:
		say "keep picking";
	else:
		say "pick";
	say " off Rodney's gang ";
	say "[if number of warriors in lalaland < 3]one by one[else] though you probably don't need to[end if]";

to say around-gone:
	say "[if doc-y is visible]around[else]gone"

table of general-blather	[ask x about any old unusual subject]
him-who	topic	him-say
nestor	"life"	"'Life is, like, the time of your life!'"
nestor	"father" or "his father"	"You have a country to save. Don't waste time shaming recreational drug users."
Gunter	"old/ man/ almond"	"He and you are up to no good, I'm sure."
doc-y	"key"	"Dr. Yow shrugs. If he knew where a key was, he'd find it."

table of object-blather [this gives people default things to say about stuff, if they are not terse.]
person-subj	right-region	him-say
Elvira	--	"Everyone has an opinion about her, that's for sure. But many people are afraid to say the wrong thing. Or say it the wrong way."
settler	--	"You don't think anyone can help you [if Elmo is in lalaland]more than Elmo did [end if]with that."
pedanto-notepad	--	"The pedanto-notepad is yours and private. Nobody can help you decipher it--hopefully it is clear enough."
curst palace	towers	"'[if limits is visited]Maybe you can restore it[else]You'll never get there[end if]!'"
haunter	oyster	"'It was looking for its lost jewel! We thought it was buried, but it appeared somewhere.'"

table of popular-blather	[ask anyone about specific topic. Yeah, this fizzled.]
topic	right-region	him-say
"yorpwald"	--	"That might suck you into a boring discussion about politics. Or, worse, an exciting one."
"old/ man/ almond"	--	"Asking about him might blow your cover."

to decide which number is kid-moves: [hacky but simple and easy to prove. Inapt/swarm = force you 2W. SWSE or WSSE are only possible 4-movers. 2 + how many squares east you must go.]
	if ego drains are in lalaland:
		decide on 2;
	if inapt is not in lalaland:
		decide on 6;
	if grailman is in lalaland or reed's ale is in lalaland:
		decide on 4;
	decide on 6;

to say kid-fol: [h]
	if kid-moves is 2:
		say "It's a quick walk back to the subsector with the deacons and ego-drains gone.";
	else if kid-moves is 4:
		say "You loop around a bit past guardians you haven't cleared.";
	else if kid-moves is 6:
		say "You regret not clearing more guardians--the kid is nice, but he sure can TALK, and he sure likes to kibitz about what  you didn't clear, and why, and he even figures a few out, but you are a bit too exhausted to show him HOW you work your magic. And a little embarrassed. You mumble something about being practical. Plus the long walk may help the kid sit and listen. You hope.";
	now kid is found;
	move kid to subsector;
	move player to subsector;

chapter basic nonos

check going (this is the odd direction cue rule):
	if noun is up or noun is down or noun is inside or noun is outside:
		if the room noun of location of player is nowhere:
			say "The game should tell you when you are able to go [noun]. You'll mostly need to use the four cardinal directions here." instead;

the odd direction cue rule is listed before the can't go that way rule in the check going rulebook.

section diagonal moves

a direction can be diagonal. a direction is usually not diagonal.

northeast,southeast,northwest,southwest are diagonal.

before going (this is the reject diagonals rule):
	if noun is a diagonal:
		if player is in coastlines and noun is northeast:
			try going north instead; [crossing leak lake]
		say "[one of]Intermediate? Terminate! Die![or]Diagonals?! A sad lingo.[or]Diagonals?! So anal. Dig?[in random order][one of][line break][italic type][bracket]Note: this game's confusing enough without diagonal directions. If you can't find a way to go, type EXITS.[close bracket][roman type][or][stopping][line break]" instead;

check going:
	if the noun is up or noun is down:
		if the room noun of the location of player is nowhere:
			say "if there is a way [noun], it should be clear in the description. Hopefully. If not, try EXITS." instead;

book the air

the air is a proper-named backdrop. the air is everywhere. description is "Yup. Still breathable."

does the player mean scaning air: it is very likely.

rule for supplying a missing noun when scaning: now the noun is the air.

book quips

section artistic

section quip-text

a quip can be mowered, artistic or dormant. a quip is usually dormant.

to say satchel-extra:
	if satchel is bscanned:
		continue the action;
	if satchel is not in Basement:
		say "quickly go back to the study for the satchel, ";
	say "scan the satchel [if satchel is not escanned]both ways[else]the way you didn't[end if] and ";

to say mo-data:
	say "[one of]More data[or]Even more data[or]Ok, lots of stuff to look at[stopping]";

last-yays is a number that varies.

to say current-known:
	let yays be 0;
	say "Red: ";
	repeat through table of known-letters:
		if v-c-y entry is 1:
			consider the my-rule entry;
			if the rule succeeded:
				increment yays;
				say "[my-let entry]";
	say "[line break]Yellow: ";
	repeat through table of known-letters:
		if v-c-y entry is 2:
			consider the my-rule entry;
			if the rule succeeded:
				increment yays;
				say "[my-let entry]";
	consider the got-y rule;
	if the rule succeeded:
		increment yays;
		say "[line break]Orange: Y.";
	if yays is last-yays:
		say "[line break]Hmm, nothing new from that...";
	now last-yays is yays;

this is the got-a rule:
	if scale-quip is mowered or basement-quip is mowered:
		the rule succeeds;
	if stable-quip is mowered:
		the rule succeeds;
	if ramp-quip is mowered:
		the rule succeeds;
	if painting-quip is mowered:
		the rule succeeds;
	if stair-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-b rule:
	if stable-quip is mowered:
		the rule succeeds;
	if basement-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-c rule:
	if scale-quip is mowered:
		the rule succeeds;
	if chimney-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-d rule:
	the rule fails.

this is the got-e rule:
	the rule succeeds.

this is the got-f rule:
	the rule succeeds.

this is the got-g rule:
	if gulp-quip is mowered:
		the rule succeeds;
	if painting-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-h rule:
	if chimney-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-i rule:
	the rule succeeds.

this is the got-j rule:
	the rule fails.

this is the got-k rule:
	the rule fails.

this is the got-l rule:
	if gulp-quip is mowered:
		the rule succeeds;
	if elmomole-quip is mowered:
		the rule succeeds;
	if scale-quip is mowered:
		the rule succeeds;
	the rule succeeds.

this is the got-m rule:
	if elmomole-quip is mowered:
		the rule succeeds;
	if basement-quip is mowered:
		the rule succeeds;
	if chimney-quip is mowered:
		the rule succeeds;
	if ramp-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-n rule:
	if basement-quip is mowered:
		the rule succeeds;
	if chimney-quip is mowered:
		the rule succeeds;
	if painting-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-o rule:
	if elmomole-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-p rule:
	if gulp-quip is mowered:
		the rule succeeds;
	if chimney-quip is mowered:
		the rule succeeds;
	if ramp-quip is mowered:
		the rule succeeds;
	if painting-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-q rule:
	the rule fails.

this is the got-r rule:
	the rule succeeds.

this is the got-s rule:
	if scale-quip is mowered:
		the rule succeeds;
	if stable-quip is mowered:
		the rule succeeds;
	if stair-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-t rule:
	if stable-quip is mowered:
		the rule succeeds;
	if basement-quip is mowered:
		the rule succeeds;
	if painting-quip is mowered:
		the rule succeeds;
	if stair-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-u rule:
	if gulp-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-v rule:
	the rule fails.

this is the got-w rule:
	the rule fails.

this is the got-x rule:
	the rule fails.

this is the got-y rule:
	if chimney-quip is mowered:
		the rule succeeds;
	the rule fails.

this is the got-z rule:
	the rule fails.

table of known-letters
my-let	my-rule	v-c-y
" A"	got-a rule	2
" B"	got-b rule	1
" C"	got-c rule	1
" D"	got-d rule	1
" E"	got-e rule	2
" F"	got-f rule	1
" G"	got-g rule	1
" H"	got-h rule	1
" I"	got-i rule	2
" J"	got-j rule	1
" K"	got-k rule	1
" L"	got-l rule	1
" M"	got-m rule	1
" N"	got-n rule	1
" O"	got-o rule	2
" P"	got-p rule	1
" Q"	got-q rule	1
" R"	got-r rule	1
" S"	got-s rule	1
" T"	got-t rule	1
" U"	got-u rule	2
" V"	got-v rule	1
" W"	got-w rule	1
" X"	got-x rule	1
" Y"	got-y rule	3
" Z"	got-z rule	1

[??canit-quip	"'That BS idea abides, biased! Blue Frog Urbfogel. Bugler of Foulberg? So long ago! And what did he do? Beat up monsters that came back anyway til he could beat her up? Talked to people who knew where hidden items like the horn-o-honor and gavel of Fogvale were? Lucky they were there! He'd never have, on his own! And they'd have killed her off if she was that bad! But she's built herself back up, with only common sense and charisma! Her tact-chatter is nothing to YOUR word power! She was detest-tested over Blue Frog Urbfogel! She even led education reforms to force kids to--well, see how you did things! It's not HER fault kids find you a pro-rote trooper! But Yorpwald will be REMADE! With the help of her GOOD DEEDS!'" Reamed? Remade!]

y-orange is a truth state that varies.

to say y-know:
	now y-orange is true;

[the part-list takes from 5x+1 to 5x+(fi-1)%5 + 1 & is useful for when I want to display a few things at once. The 5 is for when I need 2 short lists.]

to say part-list of (tt - a table-name) and (fi - a number):
	let lonum be fi - (the remainder after dividing fi - 1 by 5);
	repeat with idx running from lonum to fi:
		choose row idx in tt;
		say "[if idx is fi and idx > lonum]and [end if][blurb entry][if idx < fi - 1], [end if]";

to say note-gretta:
	unless gretta-quip is mowered:
		say "'Oh, you should know--Gretta Garett-Tatger, the journalist, has become a target--sorry about that--for looking into Elvira's operations. Gretta may've left a hint in the Strip of Profits, and she may have something for you, if you find her. So, um, yeah, good idea, write that down.'[paragraph break]";
		pad-rec-q "Gretta";

to say biop of (ts - a truth state):
	repeat through table of biopics:
		if fave entry is ts:
			say "[blurb entry]";
			continue the action;
	say "BUG no biopic found";

to say check-started-yet:
	let prefigs be 0;
	let southfigs be 0;
	if p-2 is prefigured:
		increment prefigs;
		increment southfigs;
	if ghoul hat is prefigured:
		increment prefigs;
		increment southfigs;
	if eels is prefigured:
		increment prefigs;
	if sea cube is prefigured:
		increment prefigs;
	if prefigs is 4:
		say ". Everything you tried will probably work now";
		continue the action;
	if prefigs is 3:
		say ". You may be able to do a lot in the [if southfigs is 1]pool[else]barn[end if], now";
		continue the action;
	if prefigs is 2:
		say ". You made [if southfigs is 1]some progress to the north and south[else if southfigs is 2]progress to the south[else]progress to the north[end if]";
		continue the action;
	if prefigs is 1:
		say ". Maybe you can go back to the [if p-2 is prefigured or ghoul hat is prefigured]barn[else]pool[end if] and do some work now";
		continue the action;
	

table of quip texts (continued)
quip	quiptext
null-quip	"This shouldn't be part of the conversation."
summary-quip	"'Must I sum it? It's, um...' / 'Condense it.' / 'So indecent.'[paragraph break]Gunter glosses over your successes in the forest (store F,) the sortie (store I,) and the metros (store M) and how anyone with a little dorky thinkery could've done it, but whatever. Then he gets to Elvira. How before she arrived, Yorpwald was a bit boring, but now it has more reality shows, advertisers and loud opinions than ever.[paragraph break]And how--well, she pointed out it was nice of you to save Yorpwald the first time, but a bunch of pedants looked through dictionaries to ensure there wasn't much left TO change. And how your choosing not to be A Personality was suspicious for sure. And how SHATTER-THREATS would check the anagrammability of stuff so Red Bull Burdell wouldn't happen again. Plus you never helped create cool new slang. But you, of all people, are most likely to form a polit-i-plot. He ends with a yawny anyway, mentioning how liking Elvira is what makes us different from animals, and you should totally write that in your pedanto-notepad.[paragraph break]You already sort of knew this, but Elvira seems to want you out of the way, seriously. As to Gunter, you'll probably annoy him equally by turning him out (if you want to get on with things) or failing to agree with all he has to say."
powers-quip	"'Humble-brag, bumbler? Agh! Snake oil. So like an aloneski! You could ply a word! Change Yorpwald from untied to united! Change clover to Velcro! Noughts to a shotgun! Words, no sword! Aarg. Man. With whatsits.'"
necro-quip	"'No rec!' Gunter goes from dynamic to [d-word] icy, flashing an off-grace frog face. A pouty payout![paragraph break]'You irk, heel. You LIKE her? I can't can it! What she did...shaded with...'[paragraph break]'No, glib goblin! The slob lobs BS, lo! Poisonin['] Opinions! That BS idea abides, biased!' Gunter glosses over Blue Frog Urbfogel, Bugler of Foulberg, and how he beat up monsters that came back anyway til he could beat her up? Talked to people who knew where hidden items like the horn-o-honor and gavel of Fogvale were. It was rigged! Now, with her dynamite, tidy name, oh, the soaring signora! Her vast harvest, her mystic chemistry-, her tact-chatter. Her lean elan's made Yorpwald go real galore--be aliver--a praised paradise--with her ReaLiv initiative for the Sunnier Unrisen Inner Us! From arsey years to so sane season! Had us voting her overnight the roving virgo then! Became a rowdy pal! Yorpwald was old, warpy, but now it's more wordy, pal! A Yapworld and Payworld! Oh, her good deeds!'"
clown-quip	"Scathing sigh. 'Can't.'[paragraph break]Yet she's an a-lister realist. To suggest such a reform-former is a viler...it was censor-crones who tried to quiet HER, the defamed made def! You're probably upset she pointed out anyone with your powers would've figured what to do...eventually...unless they got bored. But she is a wonder. You're a downer.'"
sit-quip	"'Going personal? Sore plan! No gig!' She's not perfect but that helps us see... 'Mr. Quasi-Marquis...you have to admit, not even a reruns nurser thinks you could save Yorpwald turning stuff into stuff again. Pedants did research! So one do-rite editor rioted.'"
gustave-quip	"'Once you came along, it was clear Gustave was the vaguest. A denser sender. Very idle delivery. But, well MY initiative kept me Optimal Top Mail. So well I have time for my pouter troupe.'"	[option 4-1, fork of 4]
pouter-quip	"'Why, they came around about the time Elvira did! I didn't believe them at first! But then they became spouter troupes. No offense, you deserve your no-spine pension and all, but ... there's not much of a story behind what you did. Nothing award-winning. Why, it gives me headaches to think about some things you did and saw! No offense. Anyone with a calculator or whatever could've done it. They just...spoke the truth. And were more interesting about it! Now Elvira is more interesting. I mean, you're not funny, or anything.'"
pun-quip	"'Eh, punt the pun,' you think. The paunchy, achy pun--a painful pun-fail--hardly cleans up on the pun scale. You picture a generic cringee at [twiddle of table of laughhouses and -3]. 'Rad irony? Ordinary.'"
ahem-quip	"Gunter intones tension. Refusal earfuls. 'Cad, no can do. [d-word-u], uh, DUH, man.' Refusal earfuls."	[end option 4-4] [??]
trips-quip	"'No shame,' he moans. 'Some? Nah.' ... he makes the money gesture with his hands but notes you won't get ID'd unless you visit during rush hour."
media-quip	"Somehow, the media aimed you for trying to do way too much and way too little. You chart the flattery, the backhanded compliments, the first rifts, the outright disrespect. 'His charisma is archaism.' / 'Cagiest toil made him egotistical.' / 'He will make this realm lamer to save it again.' How the only things you [i]did[r] were saving your skin against Red Bull Burdell--and exist at the end."
media-quip-2	"You recall Walt Koh's and Kath Low's howl-task host-walk, among other 'informational' shows...[twiddle of table of lame talk shows and 4]Folks co-spit topics, you're mashed, shamed. '[if player is male]He's [else]She... [end if]mad! Trashed, [if player is female]she'd...rat[else]he darts[end if]!' And the rubbish biopics, good ([biop of true]). or bad ([biop of false]). You did nothing to prepare Yorpwald against technically sophisticated attacks like the exciting ones Elvira warns about, the ones that helped her gain a role of Save/Rid Adviser. Many a tearful faulter did not want to blame you--but they had to."
social-quip	"You complain about social forces in general. More downers than wonders. How you're no longer a secure cursee."
girls-quip	"You listen about [twiddle of table of elmo emo and 3]. No friend finder or lovers solver found the woman for Elmo. He looks happier for having complained, though."
weather-quip	"That's always a safe one. You say 'How [']bout that weather, geez,' not realizing you haven't gotten out enough to know if it's been too hot, cold, rainy or dry. But fortunately, you haven't gotten out enough to remember those details don't matter.[paragraph break]Elmo seems ready to listen to deeper concerns, even if they probably aren't germane to what you need to do."
sports-quip	"Sports banter follows.[paragraph break][twiddle of table of sports chatter and 2]'Chokers.' / 'Shocker.'"
artsy-quip	"'Where do I look?'[paragraph break]'Spry prys say end of the alphabet. The start's tourist traps. Especially the sortie and forest and metros you solved. The tour guides are a bit, uh, revisionist.'[paragraph break]'What's the bare mi...uh, most efficient way through?'[paragraph break]'Well, stores U and V at the Strip seem the most easy. P is not too bad. Y--well, lots to do but it's simple. W is--I can't quite describe it. T--you might be weak when you get there.'"
leave-quip	"'Travel, varlet!'[paragraph break]Magnetic-acting, he blabs about the seriousness of it all, despite your 'Hastas, [bracket]redacted[close bracket].' Somehow, you are to blame for the awful state of TV, music, games, and the arts in general, but Elvira is always there to bemoan things and assure Yorpwald she can make it better. It sort of blends in for a while, until he yells at you for wasting his time.[paragraph break]As he leaves, he looks in your mailbox, all '[if player is male]N[else]Ow, n[end if]o fan mail? Fail on, [if player is female]wo[end if]man! Ego hurt? Er, tough!'[paragraph break]Gunter pulls out something labeled 'Points to Spin,' then another labeled 'A Folder re: Adolf.'[paragraph break]'Godwin? Win, dog!'[paragraph break]'Snidest dissent! Gob it, bigot!' he yells as he pulls out a paper labeled 'Dope Op-Ed' and throws it at you. It's thick enough, you feel something when it hits. You lie down in your chair, annoyed and stunned. You realize you'll need an evac-cave...they'll be surrounding your manor.[paragraph break]'Told, dolt!' you hear after locking the door. His ugliest lies tug as you fall asleep[if latches are off-stage], which you notice is quite lumpy[end if]. You wake up hours later from a right mean nightmare where people yell 'Zero Day, Ya Dozer!' and '[if player is female]She will hew ills[else]Sir, Echo Heroics[end if]!' then 'Brave a verb! No sun, nouns!'"
curb-quip	"'It's not your fault you didn't have a super perfect story when you rescued Yorpwald. That's the fault of -- someone above -- if they even exist. Maybe if you fix what's wrong here, it'll be a more compelling story and pontificators won't turn against you. Or get bored.' Elmo turns to the fourth wall. 'Or have an excuse to pretend they're bored.'"
interr-quip	"'Information on the Strip of Profits. It's thriving now. People buy stuff from the stores! They're so occupied, they won't notice YOU! But I think you've got a trial trail ahead. Elvira's got her toy theory started. About you being bad for Yorpwald.'"
toy-theory-quip	"You've sort of heard it, and you've sort of thought it, but yeah. She really did backhand-compliment you (big deal, boring mathy stuff, not a SHRED of excitement, but you did the job, she guessed) while saying people needed someone more exciting to mythologize about.[wfak][paragraph break]Like, gosh, HER! 'Her united con continued unnoticed. But it's too perfect. Tough to--ugh. Something messes up, she denounces it right away. SHATTER-THREATS is so specific to you, too. That's why I don't like it.[paragraph break]'She at the very least SEEMS to think you're behind the influx of annoying anagrams. But then, she might be trolling us by framing you. That's an...other-y theory, eh, tyro?'"
strip-quip	"'Yeah, lots to explore. But I bet observing and talking to people will help. Even if they don't want to help. There also may be some--illegal types around stores K and N. You don't need them, but they can't hurt.'"
clues-quip	"'Examine everything. People and things blocking you. Try to get by them. Just plain listen, or smell. Dialogues also guide. Oh, and if you can find Gretta Garett-Tatger, bonus.'"
gretta-quip	"'She's a good investigative reporter, the best. She's dug further into Elvira's doings than anyone else. But she's become a bit of a--target.' You both cringe. 'No, it's not your fault. Just, she may have found something, even left a cue in the Strip of Profits.' Elmo shows you a picture of her."
trial-trail-quip	"'More trouble, more stores. Six of [']em. But you can't just switch stuff to other stuff. That'd be more hokey and homeworky. You'll have to infer finer things to upset the setup.' You ask what's ahead.[paragraph break]'You probably remember tackling F, I and M. Now it's P, T, U, V, W and Y. Oh, and H, if you get by Elvira.'[paragraph break]That's a lot. You probably don't need to grill him about all the stores. But some general hints could be nice."
shortcut-quip	"'Hm, maybe a covert vector after you solve two...[paragraph break]'Oh, hey, if you want to complain about random stuff, go ahead. It might not give any practical help, but I don't mind listening. I've thrown a lot at you.'"
p-quip	"Elmo stammers a bit. 'I know I asked you to ask about it. But I can't think of what to say about it in polite company. This is a hint that's not a hint, though. Or vice-versa. Honest. I hear ProcCorp is behind it. Or is it PorcCorp or CropCorp? Or all of them? There's a hacks['] shack immune to shatter-threats somewhere there.'"
t-quip	"'Store T, well, I've never seen anyone even try to buy stuff. People walk away. Like there's an Or-Not-O-Tron near it. I'd wait on it. But it might have hints about the other stores.'"
u-quip	"'Store U used to hold all sorts of road maps, telling people where to go without directions. I hear it's hooked up to some place where people can't think or walk straight. More have been popping up over Yorpwald. But the worst is the Same Mesa. A poison stripe around it.'[paragraph break]'Who? How?'[paragraph break]'Rev. Ali and his go-mad dogma about St. Rich, the god of lie, the good life has left people without directions.'"
v-quip	"'Store V used to hold a bunch of self-help books that taught you how to think wrong. But the proprietor moved on to lectures. More lucrative. Self-help industries have overrun Yorpwald. Spoiloplis is the big hub. Mayor's Irv Lea. But you may not even need to meet him.'"
w-quip	"'Store W, well, everyone seems to have a different word to describe what's going on there in the Bland Sad Badlands. People protecting their territory just because. Castle Apcur, the Curst Palace, lies there, at the other side of Leak Lake. They say it's being torn down to make a new MoneyCo office. Tax-free and all. Oh, and luxury condos endorsed by Avrile, that lifestyle maven. But if you could restore the palace somehow...'"
y-quip	"'Store Y, well, it connects to the sea somehow. A seashore seahorse told me about seaside dis-ease you need freaky fakery to avoid. Something about a hideout, and a gang called DIE THOU.'"
flier-quip	"'Hmm.' You and Elmo scan the flier, which is [if setspace is true]R Y R R Y[else]RYRRY[end if] with cheat or teach mode. 'I saw your settler was [if setspace is true]R R Y Y R[else]RRYYR[end if] when I had the rifle.' Elmo speed-reads your treatise. 'So the colors tell you what stuff should become. That gives us five letters.'[paragraph break]'I and E are yellow for the rifle AND the flier, and R and F and L are red. Hm. Dunno if that's enough. I have some other supplies Old Man Almond gave me.' You note a PLUG of nutrients, laces, and an ELMO nametag." [check what's scanned]
scale-quip	"You experiment with changing the laces to a scale and back. Laces to scale is [if setspace is true]R Y R R Y[else]RYRRY[end if], scale to laces is [if setspace is true]R Y R Y R[else]RYRYR[end if].  [mo-data]."
gulp-quip	"The plug becomes a gulp, then back to a plug, no more unappetizing than before. You note plug to gulp is [if setspace is true]R Y R R[else]RYRR[end if], gulp to plug is [if setspace is true]R R Y R[else]RRYR[end if], and cheat mode changes nothing. [mo-data]."
elmomole-quip	"You flip the nametag to MOLE and back, tracking the scanner. Elmo to Mole is [if setspace is true]R Y R Y[else]RYRY[end if], Mole to Elmo is [if setspace is true]Y R R Y[else]YRRY[end if]. [mo-data]."
got-red-yellow-quip	"'Yyupp. Vowels. But we haven't found anything where the cheat button actually does anything.' You try and think of something where it might."
still-busted-quip	"You shake your head. 'Duh, I'm humid.'[paragraph break]'A, e, i, o, u,' Elmo points out. 'Vowels.'[paragraph break]'Maybe other letters too...nah, too many consonants go to red. Yeah. Vowels and consonants.' You figure the cheat button might be a good idea to learn for the future. Might be a good idea to start small. Like--with the lamp."
showset-quip	"'Hint agent thing! NEAT!' You show him what the red and yellow mean, then the green and purple. He asks if there are any other colors, like orange."
lamp-quip	"'Yeah, sorry about the lamp.' You say no worries--you're trying to figure what it means. Elmo doesn't judge. 'Yeah, you been under stress, I bet, let's work it out.' The settler vaguely goes Red, yellow/green, red and red near the fragments. 'Hm, cheat mode changes A from yellow to green. That must mean something.'"
gp-quip	"'Awesome! Yeah, cheating turns the reds and yellows blue.'"
settler-quip	"'LETTERS SETTLER. Hm, the E-T-T change color when you switch cheat mode on. Maybe that's because they are in the right places. Yellow e to green, red t to purple. Not clear if it's e and t specifically that change, though.'"
yorp-quip	"'Hm, [if chimney-quip is mowered]more orange letters to Y[else]the D in Yorpwald and W in Wordplay are orange. Or maybe it's what the letters can become. Orange, we haven't seen much of that[end if]. Also, interesting, the O-R change colors when you go cheat mode. Looks like they're already in the right place.'[paragraph break]'Gotcha, doc. Good catch.'"
stable-quip	"You remember cheat mode did not change the tables when you scanned them before entering the stable--there was lots of red writing, too, which your pedanto-notepad says was wrong letters. But there were some yellows, too. They were probably wrong, but a different sort of wrong."
basement-quip	"You remember cheat mode did not change the ten beams when you scanned them before entering the basement--there was lots of red writing, too, which your pedanto-notepad says was wrong letters. But there were some yellows, too. They were probably wrong, but a different sort of wrong."
chimney-quip	"You remember cheat mode did not change the 'my niche' text when you scanned it before entering the chimney--there was lots of red writing, too, which your pedanto-notepad says was wrong letters. But there were some yellows, too. And an orange. You suddenly realize the orange mapped to Y[y-know]."
ramp-quip	"You recall red, yellow, red, red for the ramp, cheat or no."
painting-quip	"You recall R Y Y R R Y R R for non-cheat mode, with the center two going purple."
stair-quip	"You recall R R Y Y R with one tile changing color with cheat mode. But it is probably best to focus on non-cheat mode."
dio-quip	"Elmo looks at your diorama notes for the [list of hinthelpy escanned things].[paragraph break][dior-scan][if crabgrass is cscanned or brass crag is cscanned or steel pad is cscanned or pedestal is cscanned]You and Elmo notice a few entries changed color when and where letters were the same. You decide to isolate what they mean[else]Hmm, all reds and yellows[end if][unless its-all-scanned]. You realize you could get more data, so maybe you could sneak up to the study and try again[end if]."
dio-all-quip	"You backtrack to scan everything remaining: the [list of hinthelpy not escanned things]."
dio-elm-quip	"You backtrack to scan everything remaining: the [list of hinthelpy not escanned things]."
dio-elm-2-quip	"With everything scanned now, you take a closer look.[paragraph break][dior-scan][paragraph break]You focus on the rare greens and purples. Elmo coughs, as if cuing you to something--how the greens and purples are in the same position between flipped diorama parts."
dio-2-quip	"You hash the purples and greens out some more.[paragraph break]You focus on the rare greens and purples. Crabgrass and brass crag, letters two and three. Pedestal and steel pad, letters four and seven. You think on what is special about these, in both words."
satchel-quip	"'Ach, let's...' you say. You [satchel-extra]notice the two end characters are red, but the rest switch from red and yellow to purple and green on cheat mode. That's the most purple and green you've seen yet."
still-no-gp-quip	"Elmo notes that individual letters can be either red-or-purple or yellow-or-green. All green letters in cheat mode were yellow in non-cheat, and the same for purple to red. Then the ones that are purple/green--are in the right place.[paragraph break]Elmo thinks a minute and notes red plus blue is purple, and yellow plus blue is green."
got-it-quip	"'Excellent! So, yeah, the settler adds blues when you're in cheat mode and the letters are right. Purple consonants, green vowels.'[if y-orange is false] Elmo looks over your settler once more. 'Hmm. What's the orange for? On Yorpwald/wordplay?'[else] You and Elmo note orange is for Y's, and you suspect correct oranges become brown or something.[end if]"
orange-know-quip	"You've got this one--Yorpwald, wordplay, the orange D at the end goes to Y, the orange W at the start to Y, too[y-know]."
orange-dunno-quip	"You [if backside is examined]re-[end if]examine the backside of settler and note how Yorpwald lines up with Wordplay--those two orange letters MEAN something. Then you both realize both orange letters go to a Y that's not in the right place[y-know]."
bye-Elmo-quip	"[if hold-it-up is false][note-gretta]A pause. 'Go, you doer. You're good. Un-retire, reuniter. Re-shift it fresh. Disable bad lies. There's an evac-cave over thataway. You'll know what to do. I think. Forsake fears, ok?'[paragraph break]You leave, feeling less resave-averse, but run as you hear 'Get Elmo!' / 'Get ol['] me? Let me go!' 'Sympathy?' / 'My hat, spy!' ... 'A spy yaps, pays...'[paragraph break]You crawl through the evac-cave, which exits to writing behind a dune, man. UNNAMED: MUNDANE, but you look closer and see RETRAIN TERRAIN. Behind is a carven cavern. It looks as good a place as any to visit.[end if]"
gre-macks-quip	"She introduces herself as Gretta. 'I was just trying to explain what Elvira's about, why to fight her. They started telling me they were all socially conscious--then they started hitting on me.' It's true--Elvira's brand of 'magic without magic,' which places excitement over boring honesty, has been captured in the horrid [i]OK, Be Hot: The Book[r], by Beth Koo and Theo Bok. It mentions anyone can learn its techniques--sadly, that's the truest part of the book by far.[paragraph break]You let slip it's the sort of word twisting that you can't and won't do. She pauses, then realizes how you managed to disrupt the macks without doing anything. You're that Shuffling Around person, with those powers. 'Hmm, I guess Elvira hates you even more than she hates me. I mean, she actually said I was almost as bad as you, to my face.'"
gre-elv-quip	"'Elvira backstabbed me. [']A nice gal? An ICE gal!['] Being called a gal was bad enough. But she used to rent the bulwark from me. Then SHATTER-THREATS somehow let her not pay rent in the name of national security. Then own it. It's hard to get ONE person to go up there, much less many. I found out she's--well, [italic type]augmenting[roman type] animals.'"
gre-what-quip	"'You can't rely on people coming together. They're either too scared to resist, or too eager to kiss up. But animals might be willing to help. She's still training the ones she made.' Gretta looks nervously around."
gre-north-quip	"'Maybe you will figure how to help the eels to the north and their spirit, Le Mer. They're suspicious of people, though, after Elvira failed to recruit them.'"
gre-south-quip	"'Mr. Lee is ready to blame his failed crops on anyone. Elvira's got him convinced it's not her, but if you help him, he could be swayed back. Plus, he's a farmer, so, more animals.'"
gre-east-quip	"'There are animal pens back east.' [if Anteroom is visited and Tapering Anger Pit is visited]You nod your head[else if Anteroom is unvisited and Tapering Anger Pit is unvisited]You cough a bit, realizing you didn't look there[else]You make a note to check the other pen[end if]. 'Perhaps animals can succeed where people failed, because Elvira won't be able to charm them with words. Well, not all of them. She captured and changed some, but you'd win their gratitude--and their friends[']--if you changed them back. Even, or especially, the ones guarding the pens.'"
gre-animals-quip	"'The animals aren't just imprisoned but reduced to mockeries of their real selves--whether they know it or not. Maybe one reason she wanted to discredit you was, you might be able to change them back.'"
gre-go-quip	"[if hold-it-up is false]'Here. Take these. They are ancient emblems of magic and power--damsel medals--from long before people cringed at words like damsel.' She removes her medals and hands them to you. '[gre-other].' She nods and walks off[check-started-yet].[end if]"
logical-quip	"'Pick a nit? Pack it in! Drone-o-nerd!' she laughs, hypnotic, pythonic. 'I? Spoon Poison? Overbearing, raving bore!' Your reply is undone in innuendo."
wtf-quip	"WTF is swift. 'Rugged Grudge. Reactions so certain. A sincerest resistance! Dayum, Y U MAD?' / 'Say, fits satisfy?' She gives a plain man's mansplain of her main plans and gets to clamp into a compliant calm point about your complaint. Manic plot? Progress! She also points out that it's probably for the best. You were feeling useless, weren't you? And if you just attack her and get it over with, you can die feeling heroic. She's sure you worked hard to get here."
hollow-quip	"An ol['] howl. 'Me? Rocky mockery! Petulant late punt! [if player is male]Ach, Mr. Charm[else]Ms. Arch-Charms[end if]!' She laughs with mindless mildness. 'Uber-Rube! Delicate, elite cad! Deny it's destiny? Evasion! So naive!' You cork a croak."
abhor-quip	"'Recoil, O Relic!' / 'Nuh-unh, hun! Solicit colitis!' Wow. Oww."
strong-quip	"'So pure? Poseur! Soppy psy-op!' Dang, your spoonerism got double-trumped, there."
sneer-quip	"'Obliged old gibe. Bilge OD!' Coughs co-gush, chug so. 'Be a god? Bad ego!' you try back, but she's a serener sneerer. 'How silly! Why so ill?'"
bald-quip	"'Ow, sloth. Low shot.' She laughs. You probably shouldn't be worrying about looks, now."
sinister-quip	"'Sinister RESISTIN[']. Loutier Outlier!' she calls back. There's a brief scuffle over whose insult was less creative, but you kind of shuffled a lower percentage of letters, there. So she wins.[paragraph break]But don't worry. You're still the good guy. You just lost a style point."
final-quip	"'Eugh. No. Enough! No mercy, my crone!' She flinches at your pure re-up, responding 'Oh, cute. Touché.' A truce, acuter. 'Ha, using anguish?'"

to say gre-other:
	say "[if gre-what-quip is mowered]Remember[else]I didn't tell you[end if] her army can't leave the bulwark...yet. And she won't. [if gre-east-quip is mowered]You may need help from other than people[else]The animals I told you about--they could do something[end if]";

table of Gunter comments
prompt	response	enabled
"Say, Mr., um... summary?"	summary-quip	1
"Elvira...necro-crone recon?"	necro-quip	0
"Shil-lish. Sit on it, son."	sit-quip	0
"Powers? Me? Spew more!"	powers-quip	0
"Why so showy? Calm down, mad clown!"	clown-quip	0
"Ask Gunter how business is"	gustave-quip	0
"Pouter troupe?"	pouter-quip	0
"Lighten the mood with a joke"	pun-quip	0
"Er, ahem, hear me"	ahem-quip	0
"One Beg: begone!"	leave-quip	0

table of Elmo comments
prompt	response	enabled
"Ask Elmo about how to use your Settler, because you're not sure yet"	flier-quip	1
"Show Elmo the sweet Settler you know how to use"	showset-quip	1
"Check the scale that can flip to laces and back."	scale-quip	0
"Check the ELMO nametag that could show him up as a mole."	elmomole-quip	0
"Check the PLUG of nutrients that could become a GULP bottle."	gulp-quip	0
"Recall the tables/stable flip."	stable-quip	0
"Recall the my niche/chimney flip."	chimney-quip	0
"Recall the ten beams/basement flip."	basement-quip	0
"Recall the pram/ramp flip."	ramp-quip	0
"Recall the giant pin/painting flip."	painting-quip	0
"Recall the stair flip."	stair-quip	0
"Recall what you tried with the diorama."	dio-quip	0
"See about all you could try with the diorama."	dio-all-quip	0
"Look through all the diorama data."	dio-2-quip	0
"Oh, cool, I know what the reds and yellows are for, now."	got-red-yellow-quip	0
"Geez. I'm still busted. Kinda shaken by...well, the excitement."	still-busted-quip	0
"Ask Elmo about the lamp"	lamp-quip	0
"Explain you know what the colors besides red and yellow mean"	gp-quip	0
"Ask Elmo about the 'Letters Settler' text"	settler-quip	0
"Ask Elmo about the 'Yorpwald-Wordplay' text on the laced decal"	yorp-quip	0
"Ask Elmo about what you remember from the diorama."	dio-elm-quip	0
"Scan everything about the diorama."	dio-elm-2-quip	0
"Yeah, I see what orange means."	orange-know-quip	0
"Hmm, I don't see what orange means."	orange-dunno-quip	0
"Oh, hey. The satchel. [unless satchel is escanned]Maybe I could scan it[else if satchel is bscanned]I scanned it with cheat on and off[else]I could scan it some more[end if]!"	satchel-quip	0
"Hm, still not clear on the green/purple."	still-no-gp-quip	0
"Tell Elmo you got what the cheat button does, thanks!"	got-it-quip	0
"[unless y-orange is true]Hm, I even see what orange is for. [end if]Got some reinvestigator interrogatives, hustle-sleuth."	interr-quip	0
"Ask Elmo about her toy theory"	toy-theory-quip	0
"Ask Elmo about your trial trail"	trial-trail-quip	0
"Strip of Profits? Was that the Trips Strip? What's at the...?"	trips-quip	0
"Ask Elmo how he'd get artsy with strategy"	artsy-quip	0
"Poss. Clue? Closeups?"	clues-quip	0
"Gretta Garett-Tatger?"	gretta-quip	0
"Jumbo, um, job. Six of [']em? Some fix!"	shortcut-quip	0
"Ask Elmo about Store P"	p-quip	0
"Ask Elmo about Store T"	t-quip	0
"Ask Elmo about Store U"	u-quip	0
"Ask Elmo about Store V"	v-quip	0
"Ask Elmo about Store W"	w-quip	0
"Ask Elmo about Store Y"	y-quip	0
"Ask Elmo about the Strip of Profits"	strip-quip	0
"Complain about the weather [bracket]NOTE: complaining, or listening to Elmo complain, is possibly therapeutic, but utterly unproductive[close bracket]"	weather-quip	0
"Complain about your favorite sports team"	sports-quip	0
"Complain about the media"	media-quip	0
"Complain about the media some more"	media-quip-2	0
"Complain about how more exciting people and stories pushed you to the curb"	curb-quip	0
"Complain about social forces in general"	social-quip	0
"Let Elmo complain about his lack of success with women"	girls-quip	0
"Finish Fishin[']."	bye-Elmo-quip	1

table of Elvira comments
prompt	response	enabled
"Fool us? So foul! (Lay things out logically, hopefully without getting overemotional or boring)"	logical-quip	1
"WTF FTW"	wtf-quip	1
"LOL, how hollow!"	hollow-quip	1
"Play God? Dopy gal!"	sneer-quip	1
"Abhorsive Behaviors!"	abhor-quip	1
"Strong will? Still wrong. At bay, ya bat."	strong-quip	1
"Go bald, old bag!"	bald-quip	0
"Sinister Insister. Hypno-phony."	sinister-quip	0
"Scourge-curse, go! (yeah, yeah, get on with it)"	final-quip	1

to lawnmower (mytab - a table-name) :
	if debug-state is false:
		continue the action;
	let mower be true;
	repeat through mytab:
		if response entry is not mowered:
			say "DEBUG: Did not touch [response entry]: [prompt entry][line break]";
			now mower is false;
	if mower is true:
		say "DEBUG: Lawnmowering worked.";

gre-go-warn is a truth state that varies.

before QBC responding with (this is the warn you before bailing from a convo rule):
	let cur-act be a number; [this is kind of cutesy code. Basically, it checks to see if Player Choice is equal to the # of available choices. If so, it warns you.]
	now cur-act is 0;
	if debug-state is true and number understood is 0:
		if Elmo is visible:
			deliver the bye-Elmo-quip quip instead;
		if Gunter is visible:
			deliver the leave-quip quip instead;
		if Elvira is visible:
			deliver the final-quip quip instead;
	if current quip is leave-quip:
		if Elmo is visible:
			repeat through table of Elmo comments:
				increase cur-act by enabled entry;
			if number understood is cur-act:
				say "Conversation conservation, eh...spells less help.";
	if current quip is quip_null:
		if Elvira is visible:
			say "She talks softly, oft-sly.[line break]";
		if Gunter is visible:
			repeat through table of Gunter comments:
				increase cur-act by enabled entry;
			if the number understood is cur-act - 1:
				say "'So rude!' says Gunter, roused, soured.";

before quipping when player is in fro (this is the Gretta checks rule):
	let missed-one be false;
	if current quip is gre-go-quip:
		if gre-go-warn is false:
			now gre-go-warn is true;
			repeat through table of Gretta comments:
				if response entry is not mowered and response entry is not gre-go-quip:
					d "[response entry].";
					now missed-one is true;
			if missed-one is true:
				say "'Oh--um, yeah, don't feel you're holding me back. I sort of want to get away, but I know a few things that could help you,' Gretta says. Stay and ask a bit more?";
				unless the player consents:
					say "OK.";
					continue the action;
				say "A bit of awkward silence follows, but it's nowhere near as awkward as the macks['] conversation.[no line break]";
				now hold-it-up is true;
				reject the player's command;

instead of abouting or creditsing or xyzzying or requesting the score when rq is active:
	say "[convoforce]." instead;

to say convoforce:
	if Gunter is visible:
		say "'Rebuts, buster? Respond! No derps!'[paragraph break]You can't get away, here. But you can RECAP to see your options";
	else if rifle is visible:
		say "Elmo doesn't seem to want to fire the gun. He doesn't even want to use it. Maybe you can help him get rid of it";
	else if Elmo is visible:
		say "No need to poke around when you have someone willing to help you--especially since it means less time for him to escape afterwards.[paragraph break]You can RECAP to see your options";
	else if Elvira is visible:
		say "'Egad. An Agenda.' Elvira can negotiate awkward silence better than you can.[paragraph break]You can RECAP to see your options";
	else if Gretta is visible:
		say "She looks in a rush to get away. So you should probably listen up, or you can RECAP to see your options";

to decide whether the action is blathery:
	if asking about, yes;
	if asking generically, yes;
	if objasking generically, yes;
	if objasking about, yes;
	no.

before doing something when Gunter is visible:
	if current action is examining:
		if noun is not Gunter:
			say "You feel a little guilty not keeping eye contact and all that jazz, but you're still hearing Gunter okay, you guess.";
		continue the action;
	if current action is attacking:
		say "That'd just give the Penal Panel one more excuse." instead;
	if action is blathery:
		say "Gunter's kind of leading the conversation, here." instead;
	if current action is not talking to urgent Gunter and current action is not QBC responding with:
		say "[convoforce].";
		reject the player's command;
	continue the action.

before doing something when Elmo is visible:
	if current action is scaning Elmo or current action is examining Elmo:
		say "[if rifle is visible]You worry about making any quick movements, even though he doesn't look...enthusiastic about this situation, almost gazing at his rifle with disgust. Maybe you could get rid of the rifle[else]Talk with him, instead[end if]." instead;
	if rifle is visible:
		if action is procedural:
			continue the action;
		if current action is singing:
			say "That's not what the high sign is for." instead;
		if current action is waiting:
			continue the action;
		if current action is going:
			say "Back in the manor won't help, and Elmo won't let you by." instead;
		if word number 1 in the player's command is "talk" or word number 1 in the player's command is "ask" or word number 1 in the player's command is "say" or word number 1 in the player's command is "tell":
			say "You aren't brave enough to say 'Disarm, mad sir!'" instead;
		say "You can't do much with Elmo around." instead;
	if action is blathery:
		say "You don't want to go off on any tangents, here." instead;
	if current action is not talking to Elmo and current action is not QBC responding with:
		say "[convoforce].";
		reject the player's command;

before doing something when player is in Reclusion Inclosure and current quip is not final-quip:
	if current action is fliptoing medals:
		say "You'll never out-talk Elvira." instead;
	if current action is fliptoing whistle:
		say "You'd feel rude playing that whistle during a conversation, even one with Elvira." instead;
	if current action is fliptoing:
		say "You'll have to finish this chat first." instead;
	if action is procedural:
		continue the action;
	if action is blathery:
		say "Elvira's not going to give you any useful information." instead;
	if current action is not talking to Elvira and current action is not QBC responding with:
		say "[convoforce]." instead;

check fliptoing whistle:
	if player is in Inclosure:
		if whistle is reflexed:
			try playing whistle instead;
		say "Elvira looks amused as you practice, and when you look up, you can but mouth 'Cor! Orc! Roc! A tiger? I...great...'[paragraph break]Maybe you could and should have practiced beforehand. Maybe you could still sneak out.";
		get-dead;
		follow the shutdown rules instead;

chiefed is a truth state that varies.

complaint-num is a number that varies.

to check-complaints:
	increment complaint-num;
	if complaint-num is 3:
		say "You get the sense Gunter would listen to your complaints all day, but then, information is probably more valuable.[paragraph break]";
	if complaint-num is 6:
		say "Gunter glances briefly at the door he entered.[paragraph break]";
	if complaint-num is 9:
		say "Man! You haven't complained to anyone for a while, and it feels good. You hope Gunter understands. He's not [i]scowling or fleeing[r] yet. Or even dropping hints.[paragraph break]";

talked-to-Elmo is a truth state that varies.

one-Elvira is a truth state that varies.

to enact (myq - a quip):
	if myq is mowered:
		d "[myq] already tried.[line break]";
		continue the action;
	[d "[myq] enabled.[line break]";]
	enable the myq quip;

hold-it-up is a truth state that varies.

before quipping when current quip is bye-Elmo-quip (this is the Elmo pulls you back for hints rule):
	if got-it-quip is not mowered and showset-quip is not mowered and still-no-gp-quip is not mowered:
		say "Elmo checks you for a second. 'You sure you know how to use the settler?'";
		if the player consents:
			say "You nod. 'No clues counsel.'";
			continue the action;
		say "You shake your head and go back to thinking why the settler might flicker yellow/green on the lamp and so forth.[no line break]";
		now hold-it-up is true instead;
	if interr-quip is not mowered:
		say "Hm, maybe Elmo has something useful to say. Start the conversation?";
		if the player consents:
			now current quip is interr-quip;

to decide whether its-all-scanned:
	repeat with rb running through ramabits:
		if rb is not bscanned, decide no;
	decide yes;

to decide whether nothing-scanned:
	repeat with rb running through ramabits:
		if rb is escanned, decide no;
	decide yes;

definition: a quip (called myq) is doable:
	choose row with response of myq in the table of Elmo comments; [?! bad if other conditional]
	if enabled entry is 1:
		decide yes;
	decide no;

a quip can be Elmo-av. a quip is usually not Elmo-av.

definition: a quip (called myq) is clue-acc:
	unless myq is Elmo-av, decide no;
	if myq is mowered, decide no;
	decide yes;

to another-Elmo-hint:
	if number of clue-acc quips is 0:
		continue the action;
	let myq2 be a random clue-acc quip;
	enact myq2;

after quipping: [qa]
	if hold-it-up is true:
		if player is in fro:
			choose row with response of gre-go-quip in the table of Gretta comments;
			now enabled entry is 1;
		else:
			choose row with response of bye-Elmo-quip in the table of Elmo comments;
			now enabled entry is 1;
		now hold-it-up is false instead;
	d "[current quip].";
	if current quip is showset-quip:
		ital-say "if you didn't mean to do this, you can UNDO to get Elmo's tutorial.";
	else:
		if debug-state is false:
			prevent undo;
		now undo-code is -1;
	now current quip is mowered;
	if current quip is summary-quip:
		pad-rec-lump "Elvira";
		pad-rec "SHATTER-THREATS";
		enact the necro-quip;
		enact the powers-quip;
		enact the gustave-quip;
		enact the clown-quip;
		enact the leave-quip;
	else if current quip is gustave-quip:
		enact the pouter-quip;
	else if current quip is pouter-quip:
		enact the pun-quip;
	else if current quip is pun-quip:
		enact the ahem-quip;
	else if current quip is necro-quip:
		enact the sit-quip;
	else if current quip is leave-quip:
		lawnmower the table of Gunter comments;
		terminate the conversation;
		move Gunter to lalaland;
		now dusty study is dark;
		if do-i-chat is true:
			move Elmo to Basement;
			move player to Basement;
			now rifle is in lalaland;
			now qbc_litany is litany of Mole Elmo; [may be delete-able] [end Gunter's dialogue]
	else if current quip is sit-quip or current quip is powers-quip or current quip is clown-quip or current quip is ahem-quip:
		do nothing;
	else if current quip is interr-quip:	[Elmo's dialogue below here]
		enact toy-theory-quip;
		enact the trial-trail-quip;
		now talked-to-Elmo is true;
		disable the orange-dunno-quip quip;
	else if current quip is trial-trail-quip:
		enact the strip-quip;
		enact the artsy-quip;
		enact the clues-quip;
		enact the trips-quip;
		enact the p-quip;
		enact the t-quip;
		enact the u-quip;
		enact the v-quip;
		enact the w-quip;
		enact the y-quip;
	else if current quip is clues-quip:
		enact the gretta-quip;
		pad-rec-p "clues";
	else if current quip is gretta-quip:
		pad-rec-p "Gretta";
	else if current quip is artsy-quip:
		enact the shortcut-quip;
	else if current quip is shortcut-quip:
		enact weather-quip;
	else if current quip is weather-quip:
		enact sports-quip;
		enact girls-quip;
		enact media-quip;
		enact curb-quip;
		enact social-quip;
	else if current quip is media-quip:
		enact media-quip-2;
	else if current quip is flier-quip:
		say "Here's what you know.[line break][current-known][line break]";
		disable the showset-quip quip;
		now showset-quip is mowered;
		enact scale-quip;
		enact gulp-quip;
		enact elmomole-quip;
		enact got-red-yellow-quip;
		if t-b is escanned and t-b is in lalaland:
			now basement-quip is Elmo-av;
		if tables are escanned and tables are in lalaland:
			now stable-quip is Elmo-av;
		if pram is escanned and pram is in lalaland:
			now ramp-quip is Elmo-av;
		if giant pin is escanned and giant pin is in lalaland:
			now painting-quip is Elmo-av;
		if sitar is escanned or stria is escanned:
			if sitar is in lalaland or stria is in lalaland:
				now stair-quip is Elmo-av;
		choose row with short of "diorama" in table of pad-stuff;
		if known entry is true:
			enact dio-quip;
		if niche is escanned and niche is in lalaland:
			enact chimney-quip;
			now chimney-quip is Elmo-av;
		else:
			another-Elmo-hint;
		continue the action;
		enact gp-quip;
	else if current quip is scale-quip or current quip is gulp-quip or current quip is elmomole-quip or current quip is stable-quip or current quip is basement-quip or current quip is ramp-quip or current quip is painting-quip or current quip is chimney-quip or current quip is stair-quip:
		say "You now know...[line break][current-known][line break]";
		enact got-red-yellow-quip;
		another-Elmo-hint;
		if scale-quip is mowered and gulp-quip is mowered and elmomole-quip is mowered:
			enact still-busted-quip;
	else if current quip is still-busted-quip or current quip is got-red-yellow-quip:
		if chimney-quip is mowered:
			say "You also note the Y is orange. Red + yellow = orange, and Y can be either a consonant or a vowel.";
		disable the settler-quip quip;
		disable the yorp-quip quip;
		enact gp-quip;
		enact lamp-quip;
		enact got-it-quip;
		disable the scale-quip quip;
		disable the elmomole-quip quip;
		disable the gulp-quip quip;
		disable the flier-quip quip;
		disable the still-busted-quip quip;
		disable the painting-quip quip;
		disable the ramp-quip quip;
		disable the chimney-quip quip;
		disable the stable-quip quip;
		disable the stair-quip quip;
		disable the dio-quip quip;
		disable the dio-all-quip quip;
		disable the got-red-yellow-quip quip;
		disable the got-it-quip quip;
	else if current quip is lamp-quip:
		enact settler-quip;
		disable the gp-quip quip;
		enact got-it-quip;
	else if current quip is gp-quip:
		disable the lamp-quip quip;
	else if current quip is settler-quip:
		if y-orange is false:
			enact yorp-quip;
		if its-all-scanned or nothing-scanned:
			enact dio-elm-2-quip;
		else:
			enact dio-elm-quip;
	else if current quip is yorp-quip:
		if chimney-quip is not mowered:
			enact orange-know-quip;
			enact orange-dunno-quip;
		enact satchel-quip;
	else if current quip is satchel-quip or current quip is dio-elm-2-quip:
		enact still-no-gp-quip;
		if current quip is dio-elm-2-quip:
			enact dio-2-quip;
	else if current quip is dio-elm-quip:
		enact dio-elm-2-quip;
		repeat with rb running through ramabits:
			oscan rb;
[		unless settler-quip is doable or yorp-quip is doable or niche-quip is doable or tables-quip is doable or basement-quip is doable or dio-quip is doable or dio-2-quip is doable:
			enact satchel-quip;]
	else if current quip is still-no-gp-quip or current quip is got-it-quip:
		disable the got-it-quip quip;
		disable the still-no-gp-quip quip;
		disable the satchel-quip quip;
		disable the dio-elm-quip quip;
		disable the dio-elm-2-quip quip;
		disable the dio-2-quip quip;
		disable the dio-quip quip;
		enact interr-quip;
	else if current quip is showset-quip:
		disable the flier-quip quip;
		enact orange-dunno-quip;
		enact interr-quip;
	else if current quip is orange-know-quip or current quip is orange-dunno-quip:
		disable the orange-know-quip quip;
		disable the orange-dunno-quip quip;
	else if current quip is dio-quip or current quip is trips-quip or current quip is dio-all-quip or current quip is dio-2-quip or current quip is satchel-quip or current quip is yorp-quip or current quip is settler-quip or current quip is strip-quip or current quip is weather-quip or current quip is girls-quip or current quip is sports-quip or current quip is curb-quip or current quip is social-quip or current quip is media-quip-2 or current quip is clues-quip:
		do nothing;
	else if current quip is p-quip:
		pad-rec-p "store p";
	else if current quip is t-quip:
		pad-rec-p "store t";
	else if current quip is u-quip:
		pad-rec-p "store u";
	else if current quip is v-quip:
		pad-rec-p "store v";
	else if current quip is w-quip:
		pad-rec-p "store w";
	else if current quip is y-quip:
		pad-rec-p "store y";
	else if current quip is toy-theory-quip:
		do nothing;
	else if current quip is bye-Elmo-quip:
		lawnmower table of Elmo comments;
		terminate the conversation;
		now Elmo is in lalaland;
		now satchel is in lalaland;
		if do-i-chat is true:
			now hydra is in lalaland;
			move player to Inclosure;
		else:
			now poss-score of manor is cur-score of manor + 3;
			move the player to Carven Cavern;	[end Elmo's dialogue]
	else if current quip is gre-macks-quip:
		enact gre-elv-quip;
		enact gre-what-quip;
		enact gre-go-quip;
	else if current quip is gre-elv-quip or current quip is gre-what-quip:
		if gre-elv-quip is mowered and gre-what-quip is mowered:
			say "'Not everyone here loves Elvira. Some are willing to help, if they're just treated right. I can tell you who, or what's, where.' Gretta looks around, worried the macks will narc her out to Elvira, even though none of them headed west to the bulwark, but you can probably grill her for quick information.[paragraph break]";
			enact gre-north-quip;
			enact gre-east-quip;
			enact gre-south-quip;
	else if current quip is gre-east-quip:
		enact gre-animals-quip;
	else if current quip is gre-animals-quip:
		do nothing;
	else if current quip is gre-go-quip:
		now Gretta is in lalaland;
		terminate the conversation;
	else if current quip is gre-north-quip or current quip is gre-south-quip or current quip is gre-elv-quip:
		do nothing;
	else if current quip is hollow-quip or current quip is sinister-quip: [Elvira's dialogue below here]
		do nothing;
	else if current quip is logical-quip or current quip is wtf-quip or current quip is hollow-quip or current quip is sneer-quip or current quip is abhor-quip or current quip is strong-quip:
		if one-Elvira is false:
			now one-Elvira is true;
			enact the sinister-quip;
	else if current quip is final-quip:
		lawnmower table of Elvira comments;
		terminate the conversation;
	else:
		if debug-state is true:
			say "FALLTHROUGH BUG in after-quipping code. Put [current quip] somewhere in the after quipping rule.";
		else:
			do nothing;

chapter quip-rule-mod

the reject asking for talking rule is not listed in any rulebook.
the reject telling for talking rule is not listed in any rulebook.
the reject answering for talking rule is not listed in any rulebook.
the reject commanding for talking rule is not listed in any rulebook.

chapter pause-and-wait

[this is not used, since it clears the screen, but just in case...]

to ptg:
	if debug-state is false:
		pause the game;

chapter taking person

check taking old giant:
	say "You'll have to take his babble, but not him." instead;

chapter taking fixed in place

check taking a sto:
	say "You can't take that, [if noun is flippable]but you can maybe change it and enter it[else]and you can't do much else, either." instead;

check taking disamb-store:
	say "You can't take one store, much less all." instead;

chapter taking scenery

section general

check taking a sto:
		say "[if noun is flippable]You can change that into something else[else]That store is useless for your purposes[end if]." instead;

check taking scenery:
	if noun is forest or noun is sortie or noun is metros:
		say "You took that area (out) last game." instead;
	if location of player is same mesa:
		say "Scenery is only here to tell you where to go." instead;
	if location of player is cleric circle:
		say "That'd be kind of sinful and disruptive." instead;
	if location of player is idle deli:
		say "The [noun] is part of the scenery." instead;
	if location of player is bedroom:
		say "That can't be valuable enough." instead;
	if location of player is Econ Cone:
		say "Oh, you'll TAKE Spoilopolis, all of it. But you can't lug THAT around." instead;
	if location of player is fiefco:
		say "You don't need to take that. Just take inspiration from it." instead;
	say "You don't need to take any of the scenery here." instead;

section manor

check taking:
	if noun is part of the Letters Settler:
		say "You don't want to go deconstructing the Letters Settler. It was hard enough to create for Old Man Almond! (And me, too. But enough about coding.)" instead;

check taking stria:
	say "Too high up." instead;

check taking air:
	say "You do so every move, even without thinking." instead;

check taking bench:
	say "The bench is too big." instead;

check taking worst ad:
	say "You'd need to get closer." instead;

check taking passage:
	say "EXAMINE it, instead." instead;

check taking chimney:
	say "To take the chimney in the going somewhere sense, go UP." instead;

check taking plaster:
	say "Peeling the plaster would be more painful and pedantic than, well, figuring a seven-word anagram." instead;

section routes

check taking narrow cracks:
	say "Take a hint from them, where they may lead you." instead;

check taking stripey pyrites:
	say "Take a hint from them, where they may lead you." instead;

check taking tables:
	say "The tables are written on the wall." instead;

check taking ramp:
	say "To take the ramp in the going somewhere sense, go DOWN." instead;

check taking pier sign:
	say "Take its advice instead." instead;

check taking controls:
	say "You need a more thematic way to, err, take control." instead;

section troves

check taking cold:
	say "You have as much cold as you can take." instead;

check taking stop post:
	say "The post is firmly in place." instead;

check taking babblings:
	say "You have as much cold as you can take." instead;

section presto

check taking hump:
	say "You can take it if you believe in yourself and motivate yourself the right way!" instead;

check taking plebe:
	say "That plebe won't be pushed aside." instead;

check taking dumpster:
	say "Way too heavy." instead;

check taking dam:
	say "You take in the dam's beauty for a moment." instead;

check taking um-not:
	say "Stronger adventurers than you couldn't take Mount Um-Not." instead;

check taking Harm's Marsh:
	say "The marsh is more likely to take YOU." instead;

check taking lawl wall:
	say "You'll need to take the keys, somehow." instead;

check taking hogs:
	say "You and Rand and Leo can take [']em. But not literally." instead;

check taking lamb:
	say "It's not a bit lamb, but it wouldn't fit in your super purse." instead;

check taking a fightin person:
	say "You can 'take' them by trickery." instead;

check taking smart people sign:
	say "Removing the warning won't make the warning any less valid." instead;

check taking clock sap:
	say "The sap is too sticky." instead;

section oyster

check taking tines:
	say "[if stein is in lalaland]You destroyed them already[else]Wrong way to vandalize things, here[end if]." instead;

check taking tunes:
	say "They're the sort of tunes you really can't take." instead;

check taking canoe:
	try entering canoe instead;

check taking river:
	say "The river drips through your fingers." instead;

check taking pikes:
	say "That's the wrong way to 'take' them.'" instead;

check taking carps:
	say "That's the wrong way to 'take' them.'" instead;

check taking trout:
	say "You can't just take him and run. You need to fight back." instead;

check taking arches:
	say "[if arches-search is true]You got enough from the arches[else]You might find something in there. How to do that without taking them[end if]." instead;

check taking thin hint:
	say "You don't need to take a hint you yourself dropped." instead;

check taking shut huts:
	try entering shut huts instead;

check taking h-h:
	say "Better to enter the hedron." instead;

check taking o-t:
	say "That'd be a good way to spring it." instead;

check taking haunter:
	say "It's incorporeal. But maybe you can take it somewhere." instead;

check taking ant:
	say "Dealing with the ant is even easier than TAKE." instead;

check taking intercom:
	say "You'd probably get a nasty shock and set off an alarm." instead;

section towers

check taking a warrior:
	say "You'll have to deal with him indirectly." instead;

check taking:
	if player is in Danger Garden and serpent is in Danger Garden:
		say "[one of]The serpent hisses as you reach down to grab that. You may need a way to calm it. The serpent, not the [noun].[or]Deal with the serpent first.[stopping]" instead;

check taking sled rut:
	say "[if strudel is in Danger Garden]Maybe take the strudel instead[else]The sled rut is nothing and holds nothing[end if]." instead;

check taking yurts:
	say "They're too strongly built to even flake a piece off." instead;

check taking a guardian:
	say "Sadly, you can't just move anyone or anything out of the way in the Badlands." instead;

check taking old ice:
	say "You'd get your hands stuck. And I won't double dog dare you." instead;

check taking neural pulses:
	say "You don't need or want to--they just flow through either way." instead;

check taking denim:
	say "You can't get a good grip on the denim to pull it." instead;

check taking ropins:
	say "WAY too heavy and big." instead;

check taking doc-y:
	say "[if doc-y is in ropins]You'll need to open the gaol first[else]Dr. Yow doesn't need that, after his spell in gaol[end if]." instead;

section otters

check taking ed riley:
	say "Ed Riley raises up on his toes and booms 'I'm no yielder!'" instead;

check taking imp:
	say "Simply much too fast." instead;

section others

check taking gs:
	say "No way you could move the gates." instead;

check taking drinks stand:
	say "The drinks stand is too big to take[if slime is off-stage], but maybe it's worth examining[else], and you sort of ransacked it anyway[end if]." instead;

check taking reserved sign:
	say "Art Erd yells at you to be a little more subtle trying to steal stuff." instead;

check taking b-r:
	say "It's stuck in there. Maybe you can make it something smaller." instead;

chapter drinking

the block drinking rule is not listed in the check drinking rulebook.

check drinking:
	say "You don't need to drink anything in this game. Well, there's one place where you sort of need to drink something, but [if compiled code is reflexive]this game skips that[else]you already got through there[end if]." instead;

chapter climbing

The block climbing rule is not listed in the check climbing rulebook.

check climbing:
	if noun is gaol:
		say "Too tall. Anyway, if it were climbable, the subsector wouldn't be the obscurest, now." instead;
	if noun is prison:
		say "It's actually a decent jungle gym, but you're not here to putz around." instead;
	if noun is huts:
		say "They're too tall. No good handholds. The rude door is the only way in." instead;
	if noun is ramp:
		try going down instead;
	if noun is skyscraper:
		say "Your thought and efforts may lead you to the top, not a physical feat." instead;
	if noun is bulwark:
		say "Elvira is in the bulwark, not on top of it." instead;
	if noun is stair:
		if player is in basement:
			move player to stable instead;
		else:
			move player to basement instead;
	if noun is the-b:
		say "It's too slippery and round." instead;
	say "You don't need to climb over much of anything in this game. Though in some spots, you may go up or down, or possibly IN." instead;

chapter push-pull

the can't push what's fixed in place rule is not listed in any rulebook.
the can't push people rule is not listed in any rulebook.
the can't push scenery rule is not listed in any rulebook.

the can't pull what's fixed in place rule is not listed in any rulebook.
the can't pull people rule is not listed in any rulebook.
the can't pull scenery rule is not listed in any rulebook.

check pushing (this is the new can't push rule) :
	if noun is t-key:
		say "[if noun is reflexive]You don't know what it does[else]You'll push it once you're ready to program[end if]." instead;
	if noun is caps lock:
		if noun is not part of keyboard:
			say "On its own, you can't push a caps lock." instead;
		say "You'll push it once you're ready to program." instead;
	if noun is a person:
		say "Pushing live things is probably even less effective than attacking." instead;
	if noun is skid:
		say "You need to specify a direction to push the skid." instead;
	if noun is church sign:
		push-church-sign instead;
	if noun is fixed in place or noun is scenery:
		say "You give a few hups but fail to push." instead;

report pushing:
	say "You give a few hups but fail to push.";
	the rule succeeds;

check pulling (this is the new can't pull rule) :
	if noun is a person:
		say "You don't need to corral people." instead;
	if noun is skid:
		say "You need to specify a direction to pull the skid." instead;
	if noun is church sign:
		say "(push, pull, same thing...)[line break]";
		push-church-sign instead;
	if noun is fixed in place:
		say "Ullp! You can't pull..." instead;

to push-church-sign:
	say "You push the sign, and it flips around. You see a different message is on the other side[one of][or], one you're familiar with[stopping], as [dssd] becomes [flipsine][dssd][if circle is visited], though you don't really need to see it, any more[end if]."

report pulling:
	say "Ullp! You can't pull...";
	the rule succeeds;

chapter d

debug-state is a truth state that varies. debug-state is false.

to d (a - indexed text):
	if debug-state is true:
		say "DEBUG INFO: [a][line break]"

to dn (a - indexed text):
	if debug-state is true:
		say "DEBUG INFO: [a]"

chapter portals

a portal is a kind of thing. a portal is usually fixed in place. a portal has a number called diffic.

the specification of portal is "A thing that allows you access to vulnerable areas of Yorpwald."

a portal can be fake-enterable. a portal is usually fake-enterable.

a portal can be maingame. a portal is usually maingame.

a portal can be lumpable. a portal is usually lumpable.

a portal can be checkedoff or available. a portal is usually available.

a portal can be enter-clued. a portal is usually not enter-clued.

a portal has a region called a go-region.

instead of taking a portal:
	say "Try entering, instead.";

chapter regions

you-used-pills is a truth state that varies.

to solve-region (sre - a region):
	let tokers-home be false;
	consider the notify score changes rule;
	now sre is solved;
	now last-solved-region is sre;
	if sre is manor:
		now all prefigured things are unfigured;
	repeat through table of pres:
		if there is a thereg entry and thereg entry is sre:
			now preflip entry is unfigured;[wipe stuff from flips]
	say "Congratulations! [sre] node: done![paragraph break]";
	if sre is otters and debug-state is true:
		append "Test passed for Otters." to the file of debuggery;
	if sre is stores or sre is roman manor:
		continue the action;
	repeat with po running through portals in Strip of Profits:
		if go-region of po is sre:
			move po to lalaland;
	if sre is oyster and pills are in lalaland:
		now you-used-pills is true;
	item-warp;
	let wiped-any-out be false;
	repeat through table of pad-stuff:
		if there is a fixed-region entry:
			if fixed-region entry is sre:
				now known entry is false;
				now wiped-any-out is true;
	if wiped-any-out is true:
		say "(You wipe out writing in your notepad that probably only applied to this region.)";
	if lecturer is reflexed: [have to get rid of them before moving the player, but we want to print a note AFTER going. So, tap dance with code a bit.]
		if smoke cloud is in profits:
			now tokers-home is true;
			now nestor is in lalaland;
			now tokers are in lalaland;
			now smoke cloud is in lalaland;
	if player is not in Strip of Profits:
		d "player not currently in Strip of Profits. Player moved from [location of player].";
		move player to Strip of Profits;
	if sre is not spoiled and otters-x are examined:
		now note-progress is true;
	see-about-patcher;
	if engravings are examined and eng-change is false:
		say "The engraving by [if store t is visible]store t[else]the otters[end if] seems to have changed since last you looked.";
		now eng-change is true;
	if tokers-home is true:
		say "The tokers packed up and went home. Just as well. You'd hate to have had to explain your journeys to them.";

eng-change is a truth state that varies.

to see-about-patcher:
	if number of kayoed regions >= 2 and chapter patcher is off-stage:
		say "You think, with a gay woot, 'Yow, got a way to go.' But then a voice -- 'Goal's a slog? Covert vector!' You look over and notice something behind the megaton magneto-montage. Something that wasn't there before.";
		now chapter patcher is in Strip of Profits;

definition: a region (called reg) is kayoed:
	if reg is spoiled or reg is bypassed or reg is shortcircuited:
		decide yes;
	decide no.

section check-for-solve

this is the check final region action rule:
	d "Checking [noun].";
	repeat through table of end-flips:
		if noun is thisflip entry or noun is thatflip entry:
			if warned-yet entry is false:
				consider the my-prog entry;
				if the rule succeeded:
					now warned-yet entry is true;
					ital-say-n "[pointwarn entry]";
					say " Continue anyway?";
					if the player consents:
						the rule succeeds;
					else:
						say "OK, this won't appear again for this section.";
						make no decision;
			the rule succeeds;
	make no decision;

table of end-flips
thisflip	thatflip	warned-yet	my-prog	pointwarn
USB	USB	false	shack-left rule	"That will win, but there's still a bit you could do in the shack."
thor	new beet	false	degen-false rule	"You should never see this."
troend1	troend2	false	office-left rule	"You tidied your office up pretty well, but you could do a bit more."
d2	d2	false	oyster-left rule	"This is the winning command, but you may be able to backtrack to see some other bits."
curst palace	curst palace	false	palace-left rule	"This will knock down the palace, but you still have that flowerpot you got from Daltho."
Elvira	Elvira	false	any-otters rule	"You could've cleaned up business with [to-clean-otters]."

to say to-clean-otters: [hells bells this is ugly]
	if p-2 is reflexive or eels are reflexive:
		say "[if eels are reflexive]the Bran Barn[else]the Loop Pool[end if]";
		if cinders are not in lalaland or elmer is reflexive:
			say ", as well as ";
		else:
			continue the action;
	if elmer is reflexive:
		say "Elmer and Merle's annoying blather";
		if cinders are not in lalaland:
			say " and ";
		else:
			continue the action;
	say "the cinders";

[here, the rules succeed if there's still stuff left to do]

this is the any-otters rule:
	if p-2 is reflexive or eels are reflexive:
		the rule succeeds;
	if elmer is reflexive:
		the rule succeeds;
	if cinders are not in lalaland:
		the rule succeeds;
	the rule fails.

this is the palace-left rule:
	if flowerpot is not in lalaland:
		the rule succeeds;
	the rule fails;

this is the oyster-left rule:
	if lever is reflexive:
		the rule succeeds;
	if aunt-tuna-cross is false and lance is not in lalaland:
		the rule succeeds;
	if splained is false:
		the rule succeeds;
	the rule fails;

this is the shack-left rule:
	if usb is off-stage: [note 2 things flip to USB, the code and the USB, so this gives 'debug' a pass]
		the rule fails;
	if trim socks are in shack:
		the rule succeeds;
	if escaroles are in shack:
		the rule succeeds;
	the rule fails;

this is the office-left rule:
	if Pa Egg Pea is reflexive:
		the rule succeeds;
	if lobster is reflexive or stream is reflexive:
		the rule succeeds;
	if divorces is not in lalaland:
		the rule succeeds;
	the rule fails;

chapter zaping

zaping is an action applying to one thing.

understand the command "zap [something]" as something new.

understand "zap [something]" as zaping.

carry out zaping:
	if player is not in strip of profits:
		say "[reject]" instead;
	if chapter patcher is not in strip of profits:
		say "You don't have anything that can zap anything." instead;
	if noun is not a sto and noun is not a portal:
		say "The patcher can only zap stores or portals." instead;
	if noun is store h:
		if otters is solved:
			say "You sense that, with Elvira defeated, the patcher wouldn't work to wipe out Store H. Perhaps there isn't enough evil to defeat, so the patcher won't work." instead;
		say "Store H isn't critical. Yet. Plus there are too many people around. You should maybe look elsewhere." instead;
	if noun is Store K or noun is Store N:
		say "As you point the patcher at [noun], you hear cries of 'No, man! Don't harsh [if noun is Store K]our[else]my[end if] buzz!'[paragraph break]There are people in there. The stores may not be where it's at, according to Gunter, so that's even less reason to disintegrate others." instead;
	if noun is tokers or noun is nestor:
		say "You're a text adventurer, not a drug enforcement agent." instead;
	if noun is a portal:
		say "The patcher obliterates the [noun]. Wow!";
		now go-region of noun is bypassed;
		now noun is in lalaland;
	if noun is Store T:
		say "The energy you felt from the patcher seems to bounce off Store T and zap you back. You'll have to be a tough customer to enter Store T." instead;
	if noun is otters-x:
		say "The energy beam that emits from the patcher fizzles as it hits the otters. Whatever's behind the otters is likely no joke." instead;
	if noun is Store U:
		now routes is bypassed;
	if noun is Store V:
		now troves is bypassed;
	if noun is Store W:
		now towers is bypassed;
	if noun is Store U:
		now oyster is bypassed;
	if noun is Store P:
		now presto is bypassed;
	now noun is in lalaland;
	say "You point the patcher at [noun], which disintegrates. Well, maybe you'll get someone to help you take care of things once you're finished here." instead;
	the rule succeeds;

the chapter patcher is a warpable thing. description is "[if number of needed regions > 1]I bet if you switched it, something cool might happen[otherwise]It's probably useless to warp past the final area[end if].". "A chapter patcher lies here next to the megaton magneto-montage."

Check taking the chapter patcher:
	say "It'd be kind of hazardous to carry around[if number of needed regions > 1]. You can just ZAP whatever's left[else]. You're done with it, anyway[end if]." instead;

check switching on the chapter patcher:
	if otters is solved:
		say "You don't need to do anything drastic now that you beat Elvira." instead;
	if number of needed regions is 0:
		say "It's jammed. Probably because you solved most all you need to. Guess you'll have to figure [if Store T is in Strip of Profits]what's behind Store T[otherwise]how to deal with the otters and what's behind them[end if]." instead;
	say "The patcher shatters in a shower of fourth-wall quantum physics as you switch it. [no line break]";
	now patcher is in lalaland;
	repeat with ZT running through needed regions:
		now ZT is bypassed;
	say "[if number of things that are patchable is 1]You point your patcher at [random patchable thing] and it goes poof[else]You point your patcher at, in turn, [list of patchable things][end if]. Well, you should be able to see what's [if Store T is visible]really behind Store T[else]behind the otters[end if] now.";
	repeat with ZT running through patchable things:
		if ZT is a sto and ZT is in Strip of Profits:
			poss-d;
		now ZT is in lalaland;
	do nothing instead;

definition: a thing (called xx) is patchable:
	if xx is not visible, no;
	if xx is Store K or xx is Store N or xx is tokers or xx is store C or xx is store B, no;
	if xx is Store H or xx is Store O or xx is Store T or xx is otters-x, no;
	if xx is a sto and xx is flippable, yes;
	if xx is a portal, yes;
	no.

chapter region definition

Roman Manor is an unsolved region. max-score of Roman Manor is 13. min-score of Roman Manor is 8. [giant pin, stable/stair, chimney/ramp, basement] [non-anagram = staple wall]

Others is an unsolved region. max-score of Others is 38. min-score of others is 25. [only need 20 fruits, compass, icons, sonic, passport x 2. Best score is # of fruits + compass + icons/sonic + passport x 2. FRUI checks what fruit is where.]

Routes is a region. max-score of Routes is 18. min-score of Routes is 17. [worst ad]

Troves is a region. max-score of Troves is 21. min-score of Troves is 15. [Pa Egg Pea, lager, lobster/stream, bee, astute statue, DIVORCES]

Oyster is a region. max-score of oyster is 39. min-score of oyster is 27. [scan cans = 1, revel/lever=1, fart/soar=1, shape heaps, waste/lance/wipes/ant subquest=5, SPLAIN in the plains, 2 at start if use pills ASAP. Non-anagram is chasing bad guys with haunter and pulling lever]

cheated-guy is an object that varies. cheated-guy is nothing.

Presto is a region. max-score of presto is 33. min-score of presto is 28. [rom stick, lamb, tab, casserole, +1 point for Phooey]

Towers is a region. max-score of towers is 44. min-score of towers is 24.
[4 for regular warriors
1 for Ray Eck
1 for rewired
1 for admirer
1 for bonker
7 for basic stuff
1 for weeds
2 for Dr Yow
1 for lone duck
1 for tentative
2 for jetskis
1 for the palace] [1 non-anagram for rapier repair]
[3 for the extra warriors
1 for strudel
1 for the yurts
5 for the H/I beyond needing to clear the coastlines
2 for the ingrates/natives
3 for the denim, neural pulses and old ice
1 for the replay player
1 for giving Ed the flowerpot NON-ANAGRAM
3 for dying crocus/serpent/ed yerg]

Otters is an unsolved region. max-score of otters is 29. min-score of otters is 23. [2 for a conjunction pair, 1 for dissing Elmer/Merle, 2 for N and S animal regions, 1 for cinders]

Stores is an unsolved spoiled region. max-score of stores is 11. min-score of Stores is 3. [k/n/tokers=3, 3 stores you don't need, sorbet also optional]

a thing has a region called lreg. lreg of a thing is usually manor.

section portal-entry

towers-warn is a truth state that varies.

oyster-warn is a truth state that varies.

check entering a portal:
	let grn be go-region of noun;
	if grn is solved: [this shouldn't happen, but yeah.]
		if grn is otters:
			say "Elvira is defeated. You don't need to go back." instead;
		say "You've already solved that area." instead;
	if noun is towers-x:
		if number of kayoed regions < 5:
			if towers-warn is false:
				now towers-warn is true;
				if patcher is visible:
					say "The towers are imposing enough that you look back at the patcher and feel relieved you can just RETRY and zap your way through in case you get stuck.";
				else:
					say "Man, those towers are imposing! They are easily bigger than the other stores, maybe as big as any two [if number of visible portals is 1]stores[else if number of visible flippable stores is 0]portals[else]stores or portals[end if] combined. You may want to chip away at [if number of solved regions is 1]a couple easier places[else]another easier place[end if] first[if oyster is solved]--the towers look way more re-enforced than even the oyster[end if]. Proceed anyway?";
					unless the player consents:
						say "You decide to look around a bit more." instead;
	if noun is oyster-x:
		if number of solved regions < 2:
			if oyster-warn is false:
				now oyster-warn is true;
				if patcher is visible:
					say "The oyster is wide enough that you look back at the patcher and feel relieved you can just RETRY and zap your way through in case you run out of gas.";
				else:
					say "The oyster looks very wide but not tall--it's quite possible there's a ton to do. It's not particularly magical or scary--not as much as [if store w is visible]store W[else]the towers[end if], but you may want to warm up your skills somewhere else first. Proceed anyway?";
					unless the player consents:
						say "You decide to look around a bit more." instead;
	let try-recover be false;
	if last-loc of grn is visited:
		now try-recover is true;
	choose row with por of noun in table of warps;
	say "[go-text entry]";
	if noun is otters-x and bleary barley is unvisited:
		say "Hmm, Elvira may be behind whatever drained you. But you don't know what she's up to. It might be a good idea to ask about her, if people are around.";
		pad-rec "asking";
	if last-loc of grn is unvisited:
		add-errs grn;
		if grn is others:
			if epilogue rule is a final response rule listed in the Table of Final Question Options:
				choose row with final response rule of epilogue rule in the Table of Final Question Options;
				blank out the whole row;	[blank out EPILOGUE when you are playing the epilogue]
	else:
		recover-items;
	if grn is towers and last-loc of grn is not trefoil: [it's possible but not likely you can cheat your way past with constant retries otherwise]
		d "REPO!";
		move player to last-loc of grn, without printing a room description;
		if can-see-map:
			draw-towers-map;
		reposition-guardians;
		try looking instead;
	else:
		move player to last-loc of grn;
	if try-recover is true:
		recover-items;
	the rule succeeds;

to add-errs (reg - a region):
	repeat through the table of nudges:
		if there is no this-reg entry or this-reg entry is a region:
			if there is no hashval entry or hashval entry is 0:
				let XYZ be the hash of this-cmd entry;
				now hashval entry is XYZ;
				d "Making hashval entry [XYZ] for [this-cmd entry].[line break]";
			otherwise:
				continue the action;
				d "[this-cmd entry] has a hashval entry of [hashval entry].[line break]";

understand "walkthrough" or "walkthru" as a mistake ("You can HINT an individual thing or ask for a general HINT. There is also a walkthrough.txt that should've come with the game. It should be linked to at IFDB or somewhere.");

understand "use [text]" as a mistake ("The verb USE is a bit too nonspecific for the parser. You can SWITCH things, or OPEN doors[if player has settler], or SCAN with the settler[end if][if player has whistle], or PLAY the whistle[end if]. You should also be able to EXAMINE something you want to use, and the game should hint a verb.")

understand "clod" as a mistake ("Hey! No beating yourself up. You'll do it wrong.") when player is in Loather Rathole.

to say poor-animal:
	say "You don't need to snap the poor animal back to...whatever, wherever it was before"

to say to-dig:
	say "[if player has digger]? You have the tools[else], without even anything that could dig[end if]";

to say no-cand:
	say "Nothing happens. You'd think that store would be a good candidate to change, but it isn't"

to say no-way:
	say "Nothing happens. The store remains impassive and dark. It doesn't look worth meddling with, anyway"

to say knob-skis:
	say " of the door. More [if knob is flippable and skis are in plains]the knob and skis are impeding you[else if skis are in plains]the skis are blocking the door[else if knob is flippable]that knob is stuck[else]you managed to navigate the knob and skis[end if]";

to say ei2pg:
	say "It's good to be on anagramming terms with the book's title, but [if Pa Egg Pea is reflexive]maybe you would be better off feeling in tune with the author, because the author does seem to have a personal anecdote for every general principle[else]your session soaking in the book's 'knowledge' was 'useful' enough[end if]"

to say j-no:
	say "It's too late to muck with the general design of the jetskis, ";
	if turbos are reflexed and blaster is reflexed:
		say "and they're probably stable enough to take, so you can get across the water.";
		continue the action;
	say "but maybe you could tune up the [if turbos are reflexive and blaster is reflexive]blaster or the turbos[else if turbos are reflexive]turbos[else]blaster[end if]"

to say if-no-pad:
	if player does not have pedanto-notepad:
		now player has pedanto-notepad;
		say ". But to do that, you need to take it, first";

table of nudges [ton]
this-cmd	hashval	this-reg	this-room	this-item	this-rule (rule)	this-clue
"basement"	608585586	manor	Basement	--	--	"[locname]."
"rove"	394647309	manor	--	--	gunter-onstage rule	"That's not a way to sneak around and avoid the knock at the door."
"meet"	422797389	manor	--	--	is-unbent rule	"[locname-part]."
"bans"	185788197	manor	--	--	is-unbent rule	"[locname-part]."
"bent"	318242540	manor	--	--	is-bent rule	"[locname-part]."
"same"	290343046	manor	--	--	is-bent rule	"[locname-part]."
"study"	447878132	manor	dusty study	--	--	"[locname]."
"blest"	399422837	manor	stable	--	--	"[locname]."
"stable"	401610655	manor	stable	--	--	"[locname]."
"highest"	479347239	manor	highest heights	--	--	"[locname]."
"height"	383073273	manor	highest heights	--	--	"[locname]."
"cavern"	410395643	manor	carven cavern	--	--	"[locname]."
"pin"	195366313	manor	--	giant pin	--	"It's one big giant pin."
"giant"	251797892	manor	--	giant pin	--	"It's one big giant pin."
"abstract"	429617931	manor	--	abstract painting	--	"That is probably overthinking the painting's abstract-ness. It's really just good for examining."
"peephole"	711798960	manor	dusty study	--	--	"You don't need to change it. It was tough enough to create."
"door"	255058046	manor	--	side door	--	"No. The door's all that protects you from the outside world."
"latch"	215399559	manor	--	latches	--	"Not one latch. All of them."
"table"	305336689	manor	dusty study	--	--	"A bleat: 'tableS!'"
"ceiling"	392118435	manor	dusty study	--	--	"[if niche is visible]You wouldn't want to collapse the whole ceiling, but maybe the MY NICHE words could be changed[else]You already built the chimney. If the ceiling caved, yo'd be buried[end if]."
"subpoena"	574518649	manor	--	--	Gunter-left rule	"Subpoenas are subpoenas. The law is the law. You don't know any lawyers good enough to wiggle out with THEIR form of word-twisting."
"lamp"	201542769	manor	--	lamp	--	"If you mess with the lamp, at least you wouldn't see those idiots outside once they got in. But you couldn't run from them, either."
"palm"	201542769	manor	--	--	is-study-dark rule	"You think you feel the palm shake a but, but nothing terribly magical happens."
"gape"	244059588	manor	--	op-ed	--	"You feel like you physically want to crumple up the page, but you just stare blankly at it."
"nitro"	376686752	manor	--	op-ed	--	"[vs-oped]."
"questin"	630601871	manor	--	op-ed	--	"[vs-oped]."
"moneyco"	550858761	manor	--	op-ed	--	"[vs-oped]."
"shatter"	555094031	manor	--	op-ed	--	"[vs-oped]."
"itrash"	369170750	manor	--	op-ed	--	"[vs-oped]."
"herarts"	537307816	manor	--	op-ed	--	"[vs-oped]."
"billy"	293398681	manor	--	op-ed	--	"[vs-oped]."
"beams"	308761951	manor	--	t-b	--	"Not even one of the beams rattles. You count them up again--there are ten."
"ten"	299823635	manor	--	t-b	--	"You change neither the number nor the makeup of the ten beams."
"notice"	438174643	manor	--	notice	--	"You can flip everything on the diorama except the notice."
"diorama"	294149104	manor	--	diorama	--	"Old Man Almond assured you you couldn't change it by accident when he gave it to you. The stuff hanging from it, though..."
"bookshelf"	561748346	manor	--	bookshelf	--	"The bookshelf is too massively immovable. If you could magick it, all those books would probably create an avalanche, anyway."
"books"	316331203	manor	study	--	--	"[the-books]."
"book"	220057237	manor	study	--	--	"[the-books]."
"shelf"	341691109	manor	study	--	--	"[the-books]."
"reading"	382846875	manor	study	--	--	"You don't have time for literary criticism."
"dark"	161473888	manor	--	--	dark-study rule	"[dark-palm]."
"darkness"	550735437	manor	--	--	dark-study rule	"[dark-palm]."
"bowling"	401020150	manor	--	giant pin	--	"[g-pin]."
"bowlingpin"	596386463	manor	--	giant pin	--	"[g-pin]."
"oped"	304653734	manor	--	op-ed	--	"You're not going to change Elvira's opinion. Better to change Yorpwald."
"opedoped"	609307468	manor	--	op-ed	--	"You're not going to change this--deed. Or Elvira's opinion. Better to change Yorpwald."
"niche"	297994347	manor	--	niche	--	"It's not any old niche. It's your niche. And by your niche, I mean you see it as 'my niche.'"
"closets"	570636060	manor	--	closets	--	"The closets are there to warp space a bit. You don't need to mess with them."
"closet"	474362094	manor	--	closets	--	"The closets are there to warp space a bit. You don't need to mess with them."
"plates"	464657709	manor	--	staple	--	"Those plates were a mess, and now they're a tidy staple. It's better that way."
"plate"	368383743	manor	--	plates	--	"You have no idea which plate to focus on, so maybe you should focus on the plates."
"plaster"	549981512	manor	--	stapler	--	"The plaster was cracking anyway, before you made it a shiny stapler. You don't need to change it again."
"painting"	447164205	manor	--	painting	--	"The painting really goes better with the study than the giant pin."
"abstract"	429617931	manor	--	painting	--	"The painting is abstract enough. Don't mess it further."
"ten beams"	608585586	manor	--	--	basement-visible rule	"You probably just want to go DOWN to the basement."
"chimney"	484428752	manor	--	--	chimney-visible rule	"You probably just want to go UP the chimney."
"stable"	401610655	manor	--	--	stable-visible rule	"You probably just want to go IN to the stable."
"satchel"	439479634	manor	--	satchel	--	"You don't need to do anything more to the satchel--and if it became latches or something else, the settler would probably get messed up, too."
"satchel"	439479634	manor	--	latches	--	"Hm, that's not it, but it must be something relatively simple. Maybe rereading the treatise would help things fall out."
"terrain"	517651905	manor	--	plaster	--	"Hm...it probably isn't that easy. The plaster and [if plates are visible]plates[else]staple[end if] are probably part of your training."
"paperwall"	595999917	manor	--	paperwall	--	"[papwall]."
"paper"	378249648	manor	--	paperwall	--	"[papwall]."
"wall"	217750269	manor	--	paperwall	--	"[papwall]."
"high"	152157146	manor	--	high sign	--	"[hisin]."
"highsign"	394931168	manor	--	high sign	--	"[hisin]."
"sign"	242774022	manor	--	high sign	--	"[hisin]."
"arifle"	340639311	manor	--	rifle	--	"Just the rifle, well, not THE rifle, or JUST, rifle, but RIFLE."
"hostage"	473612489	manor	--	rifle	--	"It's not you that needs changing but the rifle."
"gun"	206613017	manor	--	rifle	--	"It's not a gun but a rifle. And a gnu would be a gnu-sance anyway."
"elmo"	320047678	manor	--	Elmo	--	"Changing Elmo won't work. It's his rifle[if rifle in lalaland] that needed changing[end if]."
"chair"	188792351	manor	--	rich chair	--	"The chair is built too sturdily to be changed into anything else. You made sure of that when you bought it, for practical reasons. You can't make it more or less hi-arc, either. But it's still soft enough to be relaxing."
"rich"	186604533	manor	--	rich chair	--	"The chair may be an unnecessary luxury, but you shouldn't feel bad about that."
"sad"	119490873	manor	--	sad ads	--	"[w-twi]."
"sadsad"	238981746	manor	--	sad ads	--	"[w-twi]."
"evac"	256164332	manor	Basement	--	--	"The evac-cave is your way out. It'd be a bad idea to change it."
"manor"	294846859	manor	--	--	degen-true rule	"[not-the-reg]."
"others"	524148772	stores	--	store h	--	"No--it's a weird place you need to get to, sort of--the rest."
"window"	425151566	stores	--	windows	--	"Sadly, trying to change the windows wouldn't actually change the stores enough to find somewhere new."
"windows"	521425532	stores	--	windows	--	"Sadly, trying to change the windows wouldn't actually change the stores enough to find somewhere new."
"storea"	489054291	stores	--	store-a	--	"[no-cand]."
"storec"	505872058	stores	--	store c	--	"[no-cand]."
"stored"	507895562	stores	--	store d	--	"[no-cand]."
"storee"	614672582	stores	--	store e	--	"[no-cand]."
"storef"	513381369	stores	--	forest	--	"[so-last]!"
"storeg"	519466175	stores	--	store g	--	"[no-cand]."
"storei"	531859319	stores	--	sortie	--	"[so-last]!"
"storej"	535826998	stores	--	store j	--	"[no-way]."
"storel"	540680312	stores	--	store l	--	"You search for a magic word but feel, er, lost."
"storem"	550941626	stores	--	metros	--	"[so-last]!"
"storeo"	561219050	stores	--	store o	--	"Nothing happens. You consider going through the other 358 possibilities, but that'd be so rote."
"storeq"	571272090	stores	--	store q	--	"Nothing happens. You didn't really expect it to since, hey, no u with the q."
"storer"	572190276	stores	--	store r	--	"Store R led back to your manor last game. It won't go anywhere new, and you don't need or want to go back, right now[if roved is false]. You wouldn't be safe there[end if]."
"stores"	583140439	stores	--	store s	--	"[no-cand]."
"storex"	599634554	stores	--	store x	--	"[no-way]."
"shells"	465264018	stores	--	store y	--	"The shells don't move. Perhaps they are just a clue."
"storez"	609836091	stores	--	store z	--	"[no-way]."
"store"	486866473	stores	--	store-a	--	"You'll want to focus on a specific store."
"montage"	473038885	stores	--	magneto montage	--	"It's probably counterproductive to change--it's more an information booth."
"toker"	443525685	stores	--	tokers	--	"They already lost one of their collective, man. It'd be a bummer if [if nestor is off-stage]they lost another[else]someone replaced Nestor[end if]."
"someone"	633573999	stores	--	engravings	--	"[engs]."
"nouned"	466108598	stores	--	engravings	--	"[engs]."
"route"	495698314	stores	--	routes-x	--	"You don't need to do anything with an individual route. Just go in."
"trove"	497757327	stores	--	troves-x	--	"No need to focus on a specific trove. Just enter or take the troves."
"ivy"	274516918	stores	--	towers-x	--	"[towers-made]."
"ivory"	434193298	stores	--	towers-x	--	"[towers-made]."
"ivytower"	773044198	stores	--	towers-x	--	"[towers-made]."
"ivorytower"	932720578	stores	--	towers-x	--	"[towers-made]."
"tower"	498527280	stores	--	towers-x	--	"[towers-made]."
"darin"	222441064	stores	--	otters-x	--	"Darin and Randi, the otters, don't move. You feel a nadir, a drain, even trying to manipulate them."
"otter"	493702525	stores	--	otters-x	--	"You can't divide and conquer, and the otters won't let you by unless you're, well, ready."
"spot"	355202520	stores	--	e-s	--	"You can't, er, stop the, er, spot. Best to go in."
"engraving"	570489816	stores	--	engravings	--	"The engraving is meant to be read. You can modify it with other actions."
"engravings"	666763782	stores	--	engravings	--	"You can only change the enrgavings by working through the other stores."
"patcher"	456181591	stores	--	patcher	--	"The patcher doesn't need to be changed. It does the changing if you point it."
"field"	274156779	stores	--	f-o-b	--	"[not-at-barley]."
"barley"	409909726	stores	--	f-o-b	--	"[not-at-barley].[barley-check]"
"smoke"	415440983	stores	--	smoke cloud	--	"[just-smoke]."
"cloud"	273306897	stores	--	smoke cloud	--	"[just-smoke]."
"smokecloud"	688747880	stores	--	smoke cloud	--	"[just-smoke]."
"seats"	425651877	stores	lectures	--	--	"That might cause a bit too much commotion. Maybe you can just get rid of the lecturer, pay attention to your feelings, and maybe even Ian."
"example"	569923068	stores	--	lecturer	--	"[lec-un]."
"lecture"	621971270	stores	--	lecturer	--	"[lec-un]."
"lectures"	718245236	stores	--	lecturer	--	"[lec-un]."
"ian"	116088172	stores	--	idg	--	"[ian-un]."
"guardian"	362334391	stores	--	idg	--	"[ian-un]."
"heartfelt"	666954909	stores	cruelest	--	--	"[hfre]."
"reflections"	827907256	stores	cruelest	--	--	"[hfre]."
"strip"	411166592	stores	profits	--	--	"[locname]."
"profits"	512034065	stores	strip of profits	--	--	"[locname]."
"profit"	415760099	stores	strip of profits	--	--	"[locname]."
"orcas"	277143749	routes	same mesa	--	--	"[if adobe is visited]No further secrets[else]Hm, it's Oscar'S[end if]."
"mark"	204519952	routes	same mesa	--	--	"[name-worry]."
"dilapidated"	523644520	routes	same mesa	--	--	"[name-worry]."
"dingy"	289888397	routes	same mesa	--	--	"[name-worry]."
"dwelling"	510897705	routes	same mesa	--	--	"[name-worry]."
"worst"	466995137	routes	--	worst ad	--	"If you change the ad from the worst, maybe you won't make it better. Maybe you'll make something else even worse. So, focus on the whole."
"list"	298190669	routes	cleric circle	--	--	"[follow-the-list]."
"toils"	372543246	routes	cleric circle	--	--	"[follow-the-list]."
"reagent"	547741067	routes	--	--	has-reag rule	"[fol-reag]."
"reagents"	644015033	routes	--	--	has-reag rule	"[fol-reag]."
"giantold"	400993397	routes	--	old giant	--	"[cant-giant]."
"giant"	251797892	routes	--	old giant	--	"[cant-giant]."
"grouchy"	476029025	routes	--	old giant	--	"[cant-giant]."
"bench"	271420406	routes	--	bench	--	"The bench is too sturdy. You can't do anything with it, but you may be able to do something with or around it."
"inside"	404002364	routes	mesa	--	--	"[if circle is visited]The sign has no further hidden meaning[else]The sign wavers, as if you're grokking it wrong[end if]."
"die"	193828044	routes	mesa	--	--	"[die-sin]."
"sin"	210174320	routes	mesa	--	--	"[die-sin]."
"church"	303005378	routes	same mesa	--	--	"[mb-sign]."
"churchsign"	545779400	routes	same mesa	--	--	"[mb-sign]."
"sign"	242774022	routes	same mesa	--	--	"[mb-sign]."
"poison"	440345433	routes	same mesa	--	--	"[not-stripe]."
"stripe"	538972701	routes	same mesa	--	--	"[not-stripe]."
"poisonstripe"	979318134	routes	same mesa	--	--	"[not-stripe]."
"pat"	186763795	routes	same mesa	--	--	"[if deli is visited]No, you already went PAST to Pat's[else]That's not how to get into Pat'S, you reflect[end if]."
"past"	283037761	routes	same mesa	--	--	"[if deli is unvisited]Pat's seems slightly less forbidding for a moment[else]You don't need to do any more trickery with Pat's[end if]." [?! create vanishing scenery in the mesa that kicks you to Pat's]
"elbows"	478600169	routes	--	giant's elbow	--	"Thankfully, the giant's only really swinging one elbow, so--less to deal with, yay?"
"oscars"	373417715	routes	same mesa	--	--	"[if adobe is visited]Oscar's seems slightly less forbidding for a moment[else]You don't need to do more[end if]." [?! create vanishing scenery in the mesa that kicks you to Oscar's]
"marquee"	596710416	routes	mesa	--	--	"[name-worry]."
"grubby"	382226374	routes	mesa	--	--	"[name-worry]."
"restaurant"	779336668	routes	same mesa	--	--	"[name-worry]."
"seed"	372915273	routes	idle deli	--	--	"[pit-full]."
"pit"	229568823	routes	idle deli	--	--	"[pit-full]."
"portrait"	579866842	routes	Cleric Circle	--	--	"The portrait remains unchanged."
"pews"	413480807	routes	Cleric Circle	--	--	"No vandalizing church property."
"chants"	326767194	routes	circle	--	--	"[chanty]."
"chant"	230493228	routes	circle	--	--	"[chanty]."
"litany"	395371281	routes	circle	--	--	"[chanty]."
"summary"	539400952	routes	--	summary	--	"[rev-sum]."
"mum"	233256113	routes	--	summary	--	"[rev-sum]."
"rays"	306144839	routes	--	summary	--	"[rev-sum]."
"ray"	209870873	routes	--	summary	--	"[rev-sum]."
"poison"	440345433	routes	--	--	first-two rule	"[no-poi]."
"stripe"	538972701	routes	--	--	first-two rule	"[no-poi]."
"pat"	186763795	routes	idle deli	--	--	"You don't need to do anything with Pat[if mushrooms are off-stage], but maybe you can get by him to that seed pit[else], especially now you got the mushrooms[end if]."
"oscar"	277143749	routes	adobe abode	--	--	"You don't need to do anything with Oscar[if pipe soot is in adobe abode and list o toils is examined], but maybe you can sneak the pipe soot away[else if pipe soot is not in abode], and you already got the pipe soot[end if]."
"ashtray"	448724974	routes	--	ashtray	--	"[ash-soot]."
"trashy"	446537156	routes	--	ashtray	--	"[ash-soot]."
"rebroth"	531617514	routes	--	brother horbert	--	"It's not Brother Horbert who needs changing but the Same Mesa."
"spoon"	395352587	routes	--	snoop spoon	--	"Instead of bending the spoon, use it to help your magic powers."
"armada"	176991499	routes	--	drama armada	--	"They're too unruly and confused, and you probably need to get away from them, anyway."
"mushroom"	600841335	routes	--	mushrooms	--	"[horb-magic of mushrooms]."
"mushrooms"	697115301	routes	--	mushrooms	--	"[horb-magic of mushrooms]."
"rude"	339264808	routes	--	nuder	--	"That's not quite the book's whole title."
"book"	220057237	routes	--	runed book	--	"[horb-magic of runed book]."
"runedbook"	628229553	runed book	--	runed book	--	"[horb-magic of runed book]."
"pipe"	335730873	routes	--	pipe soot	--	"[horb-magic of pipe soot]."
"soot"	348089138	routes	--	pipe soot	--	"[horb-magic of pipe soot]."
"pipesoot"	683820011	routes	--	pipe soot	--	"[horb-magic of pipe soot]."
"along"	231861444	routes	--	--	am-along rule	"You think of No-Gal Logan, wondering how to find a way to him."
"huge"	302793917	routes	--	huge thing	--	"The thing remains motionless."
"thing"	286892373	routes	--	huge thing	--	"The thing remains motionless."
"above"	329930229	routes	--	huge thing	--	"The thing remains motionless."
"hangs"	237251293	routes	--	huge thing	--	"It won't help to gnash your teeth about it. It's just--as a form, it doesn't make much sense, and maybe you can change that."
"darkness"	550735437	routes	--	darkness	--	"[dark-been]."
"dark"	161473888	routes	--	darkness	--	"[dark-been]."
"cracks"	274729935	routes	--	narrow cracks	--	"[no-logan]."
"narrow"	424030282	routes	--	narrow cracks	--	"[no-logan]."
"narrowcracks"	698760217	routes	--	narrow cracks	--	"[no-logan]."
"mist"	308451983	routes	--	mist	--	"Nothing happens. Then you [if pier sign is examined]re-[end if]read the sign and, oh, it's DA MIST. You remember thinking of it that way helps someone feel more familiar with it and get less lost."
"reef"	367450917	routes	clipper	--	--	"The reef is not changed. Perhaps you can deal with what's on it."
"betrothe"	677209838	routes	--	thor	--	"Hm! If you managed to bethrothe the two, maybe you could make them past. But that would be an unholy union."
"beet"	377141141	routes	--	thor	--	"The beet shines a bit extra, as if to say, it's a NEW beet, darn it."
"previous"	722485887	routes	--	previous	--	"[prevrev]."
"rev"	320294732	routes	--	previous	--	"[prevrev]."
"pious"	402191155	routes	--	previous	--	"[prevrev]."
"piersign"	582362739	routes	ripe pier	--	--	"[pier-sign]."
"sign"	242774022	routes	ripe pier	--	--	"[pier-sign]."
"cleric"	349947767	routes	cleric circle	--	--	"[locname]."
"mesa"	290343046	routes	same mesa	--	--	"[locname]."
"idle"	247641883	routes	idle deli	--	--	"[locname]."
"adobe"	243794498	routes	adobe abode	--	--	"[locname]."
"underpass"	684374025	routes	underpass	--	--	"[locname]."
"sun"	270287281	routes	underpass	--	--	"[locname-part]."
"spared"	414086744	routes	underpass	--	--	"[locname-part]."
"pyrites"	661331953	routes	--	pyrites	--	"The pyrites seem to glow, momentarily forming an arrow as if to say, get on with it and stop worrying about treasure. You do still need to nag ol['] No-Gal Logan."
"pier"	339588717	routes	ripe pier	--	--	"[locname]."
"clipper"	493874100	routes	cripple clipper	--	--	"[locname]."
"storeu"	591972280	routes	--	--	degen-true rule	"[not-the-reg]."
"route"	495698314	routes	--	--	degen-true rule	"[not-the-reg]."
"spoil"	350899187	troves	--	--	degen-true rule	"[no-spoil]."
"spoiloplis"	701798374	troves	--	--	degen-true rule	"[no-spoil]."
"pothole"	552183378	troves	rathole	--	--	"[p-hole]."
"potholes"	648457344	troves	rathole	--	--	"[p-hole]."
"pagepage"	488119176	troves	--	Pa Egg	--	"[ei2pg]."
"egg"	193005513	troves	--	Pa Egg	--	"[ei2pg]."
"pea"	211459886	troves	--	Pa Egg	--	"[ei2pg]."
"peg"	241871770	troves	--	Pa Egg	--	"You pause, then note the author's middle initial, which seems annoyingly important."
"truffle"	528189368	troves	--	truffle	--	"You can't change the truffle. It can help you change things, though. Or how you see things."
"fern"	308552316	troves	--	nerf fern	--	"The fern is mentally, if not physically, unmalleable."
"cold"	168201090	troves	--	cold	--	"Negative thinking! You don't need to focus on the cold but how to get rid of it. To generate heat."
"care"	234323315	troves	--	heat	--	"That's not the best way to give a darn so you can race."
"messhole"	677684018	troves	Used Lot	--	--	"A messhole is a messhole. You need to concentrate on thinking your way out."
"babbling"	257758428	troves	--	babblings	--	"[bab-v]."
"babblings"	354032394	troves	--	babblings	--	"[bab-v]."
"stop"	355202520	troves	--	stop post	--	"[if stop post is reflexive]You're not seeing[else]You already saw[end if] the right way to see the stop post, here."
"live"	333777614	troves	--	what-a-bee	--	"The bee's description isn't important. It's how you see the bee that matters."
"bee"	274031123	troves	--	what-a-bee	--	"But it's not just any bee. It's a[if bee's head is reflexive and what-a-bee is reflexive]n[end if] [what-a-bee][if bee's head is reflexed and what-a-bee is reflexed]! Though, really, you've already given it the business.[else]![end if]"
"spider"	456891772	troves	--	diapers	--	"The diapers, the sad pier--the spider only fits in as *a* spider."
"picture"	566810127	troves	bedroom	--	--	"It's not just any old picture. It's of a sad pier."
"brochure"	552618888	troves	--	brochure	--	"It's more the blurb at the end than the brochure."
"cone"	290071779	troves	Econ Cone	--	--	"[cone-rec]."
"recent"	531959132	troves	Econ Cone	--	--	"[cone-rec]."
"skyline"	567086698	troves	Econ Cone	--	--	"You don't want to mess with the skyline. You want to get in the skyscraper!"
"strive"	564671562	troves	--	astute statue	--	"Trevis Vister's statue seems to looks down on you as if to say he wouldn't waste time on word games[if rivets are reflexed], even relaxing after a success[else], and if he did, he'd go in for the right ones[end if]."
"praise"	438050501	troves	--	astute statue	--	"Trevis Vister's statue seems to looks down on you as if to say[if prai is reflexed], once you've got it right, don't mess it up[else], he wouldn't waste time on word games, but if he did, he'd get them right[end if]."
"statue"	537593736	troves	--	astute statue	--	"The statue can and should be changed for aesthetic purposes, but Trevis Vister's lawyers would be on you for sure. [if prai is reflexed and rivets are reflexed] You did what you could, anyway[else if prai is reflexive and rivets are reflexive]Maybe grok the writing on the statue[else]You could find another way to follow the statue's message, but it's not necessary[end if]."
"bottle"	480611466	troves	--	pernod	--	"It's not just any bottle, but a bottle of [unless label is in lalaland]Pernod[else]N-E-Prod[end if]."
"label"	256040510	troves	--	label	--	"It's not the label but what's on it."
"noise"	412333006	troves	--	noise	--	"Hmm, no, focusing so directly on the noise to block it out is counterproductive."
"divorce"	479674829	troves	--	DIVORCES	--	"If it was just one divorce, you could blow it off. Or there would not be enough to learn from. But there is so much drivel."
"magazine"	465726572	troves	--	DIVORCES	--	"It's not just any magazine. It's DIVORCES!"
"vanity"	448722262	troves	--	tan ivy vanity	--	"[if noise is in lalaland]You really don't need to rearrange the vanity[else if vanity is unexamined]You don't need to deal with it as much as the person outside--but maybe examining will give you a clue[else]You may want to deal with the person outside, instead of this, but examining it may've helped a bit[end if]."
"lamps"	297816735	troves	--	plasm lamps	--	"You need that light for late-night work sessions."
"picture"	566810127	troves	--	stream	--	"It's not just any old picture. There's a stream."
"song"	272133753	troves	--	song	--	"It's the song name--[i]I'd cede[r]."
"eddie"	342663242	troves	--	song	--	"It's the song name--[i]I'd cede[r]."
"shaker"	401807173	troves	--	shaker	--	"The shaker itself's been around a while and can't be changed easily. Plus, what if it was a pepper shaker? Can't do much with that."
"sked"	298042342	troves	fiefco	--	--	"[list-stable]."
"minder"	412134508	troves	fiefco	--	--	"[list-stable]."
"stencil"	513909871	troves	fiefco	--	--	"[list-stable]."
"slick"	267019414	troves	fiefco	--	--	"[list-stable]."
"tech"	287204011	troves	fiefco	--	--	"[list-stable]."
"checklist"	554223425	troves	--	checklist	--	"[list-stable]."
"midwest"	565221954	troves	--	vanity	--	"No, he's yesterday's news. Or he should be. Concentrate on the [if noise is in lalaland]task ahead[else]region[end if], not him."
"playbill"	430866297	troves	--	playbill	--	"You fold and look at the playbill many different ways before figuring it's probably the writing on it that matters."
"bedroom"	465358213	troves	bedroom	--	--	"[locname]."
"rathole"	483876463	troves	rathole	--	--	"[locname]."
"loudest"	581491405	troves	--	Used Lot	--	"some text"
"dues"	350214971	troves	Used Lot	--	--	"[locname-part]"
"lot"	231276434	troves	Used Lot	--	--	"[locname-part]"
"rustin"	503713948	troves	--	Used Lot	--	"[locname]."
"ruin"	304329964	troves	--	Used Lot	--	"[locname-part]."
"ruts"	389813594	troves	--	Used Lot	--	"[locname-part]."
"boor"	252447862	troves	--	Used Lot	--	"[boor-grub]."
"grub"	241448217	troves	--	Used Lot	--	"[boor-grub]."
"boorboro"	504895724	troves	--	Used Lot	--	"[boor-grub]."
"grubburg"	482896434	troves	--	Used Lot	--	"[boor-grub]."
"asidewalk"	509159436	troves	--	Used Lot	--	"[locname]."
"askew"	387135844	troves	--	Used Lot	--	"[locname]."
"sidewalk"	506971618	troves	--	Used Lot	--	"[locname-part]."
"laid"	122023592	troves	--	Used Lot	--	"[locname-part]."
"office"	319186909	troves	fiefco	--	--	"[locname]."
"fief"	225828747	troves	--	fiefco	--	"[locname-part]."
"skyscraper"	768953439	troves	Econ Cone	--	--	"[locname]."
"perky"	469888301	troves	Econ Cone	--	--	"[locname-part]."
"crass"	299065138	troves	Econ Cone	--	--	"[locname-part]."
"rotunda"	460016620	troves	rotunda	--	--	"[locname]."
"dour"	285811276	troves	rotunda	--	--	"[locname-part]."
"tan"	174205344	troves	rotunda	--	--	"[locname-part]."
"rotund"	457828802	troves	rotunda	--	--	"[locname-part]."
"poverty"	701582538	troves	--	--	degen-true rule	"There's no shortcut from poverty to the very top, but there's no definable state in between, due to the shrinking Yorpwald middle class. I'll spare the details."
"trove"	497757327	troves	--	--	degen-true rule	"[not-the-reg]."
"storev"	594031293	troves	--	--	degen-true rule	"[not-the-reg]."
"crust"	408819179	presto	--	curst crust	--	"You should eat your food, not play with it. Yes, even if it's only MARGINALLY food."
"plaque"	454785149	presto	--	plaque	--	"It's the maze you need to change, not the plaque."
"entry"	507506690	presto	--	plaque	--	"It's the maze you need to change, not the plaque."
"mazeentry"	824545388	presto	--	plaque	--	"It's the maze you need to change, not the plaque."
"mazeentry"	824545388	presto	maze entry	--	--	"It's the maze you need to change, not the plaque."
"bigl"	149825292	presto	maze entry	--	--	"The big L may be some sort of clue, but you can't do anything with it."
"mazeroom"	615142808	presto	--	--	in-mazeroom rule	"You can't think of any way to tackle the one room. Perhaps it is the whole maze you need to tackle."
"dreidl"	353994775	presto	r24	--	--	"You won't be able to do anything to the dreidl to see it, but it'll be so horrifying once you do, you won't be able to focus. Catch-22."
"decorative"	712778774	presto	--	decorative star	--	"[if player wears star]The star's snazzy enough as-is[else]You consider some over-long epithet to get the star, but no, it's gotta be something quick. Visceral. Not necessarily rude[end if]."
"live"	333777614	presto	dirge ridge	--	--	"The vile veil is impassive."
"camo"	159621133	presto	marines seminar	--	--	"[ca-co]."
"force"	333002970	presto	marines seminar	--	--	"[ca-co]."
"forcefield"	607159749	presto	marines seminar	--	--	"[ca-co]."
"field"	274156779	presto	marines seminar	--	--	"[ca-co]."
"serial"	410398381	presto	--	popgun	--	"[is-boing]."
"number"	469637285	presto	--	popgun	--	"[is-boing]."
"stump"	450030903	presto	--	stump	--	"[if star is reflexed]The stump just sits there, stumpy[else]The stump doesn't move, but the star seems to rattle a bit[end if]."
"mad"	87292060	presto	brunt	--	--	"[no-scen]."
"maddam"	174584120	presto	brunt	--	--	"[no-scen]."
"amaddam"	176771938	presto	brunt	--	--	"[no-scen]."
"amad"	89479878	presto	brunt	--	--	"[no-scen]."
"themad"	355490486	presto	brunt	--	--	"[no-scen]."
"gasp"	212527445	presto	burnt brunt	--	--	"You try, but fail, to make something out of nothing."
"adumpster"	686377722	presto	burnt brunt	--	--	"Not even you can make that icky stuff in the dumpster worthwhile[if dart is not in dumpster], and besides, you got the dart anyway[else if dumpster is unexamined], but maybe there's something useful inside[else], but maybe you could reach for the dart[end if]."
"dumpster"	684189904	presto	burnt brunt	--	--	"The dumpster and red stump are both pretty sturdy[if dart is in dumpster and star is in brunt], but maybe you could pull out what's in them[else if dart is in dumpster], but you might be able to get what's in the dumpster[else if star is in brunt], but maybe you could pull the star from the stump[else], but you got something from both of them, anyway[end if]."
"bigm"	160086606	presto	r10	--	--	"[just-letter]."
"bign"	164918961	presto	r00	--	--	"[just-letter]."
"bigo"	170364030	presto	r01	--	--	"[just-letter]."
"bigp"	177477412	presto	r02	--	--	"[just-letter]."
"bigq"	180417070	presto	r12	--	--	"[just-letter]."
"bigr"	181335256	presto	r22	--	--	"[just-letter]."
"bigs"	192285419	presto	r32	--	--	"[just-letter]."
"bigt"	199121471	presto	r33	--	--	"[just-letter]."
"bigu"	201117260	presto	r23	--	--	"[just-letter]."
"bigv"	203176273	presto	r24	--	--	"[just-letter]."
"whasup"	430250622	presto	--	--	Leo-sad rule	"Maybe something like that'd work with just one washup. But there are two."
"leonard"	433420743	presto	--	--	Leo-sad rule	"They want to be together, but that's a bit much. Try fixing what they're complaining about, calming their fears."
"popgun"	443897512	presto	--	popgun	--	"[if boing is reflexive]Hmm. It's not the popgun itself that's cracked but the boing mechanism inside[else]The popgun is just fine[end if]."
"leonard"	433420743	presto	--	Rand	--	"[if lawl wall is in lalaland]You've probably faced the greatest physical threat you need. You need to take leave of them, now[else if Rand is eager]You don't need to combine them physically, but their physical strengths combined could be a help[else if Rand is washed up]You need to concentrate on them being washups[else]You don't need to face double the strength[end if]."
"rebuff"	389684416	presto	shack	--	--	"The rebuff-buffer is too technical for you, but even if it weren't, removing its protection would be unwise."
"magnetic"	462684739	presto	shack	--	--	"The magnetic magic-net is too technical for you, but even if it weren't, removing its protection would be unwise."
"computer"	660245011	presto	shack	--	--	"You need to fix the program in the computer[if number of things on labs slab < 4], well, once you get it running[end if]."
"button"	473004833	presto	shack	--	--	"[shackbut]."
"buttons"	569278799	presto	shack	--	--	"[shackbut]."
"escarole"	586569806	presto	--	escaroles	--	"All the escaroles."
"caffeine"	443735767	presto	--	dirty looking cola	--	"[caffeine-no]."
"fine"	268221359	presto	--	dirty looking cola	--	"[caffeine-no]."
"cafe"	175514408	presto	--	dirty looking cola	--	"[caffeine-no]."
"rope"	368948448	presto	--	skid	--	"You don't need to do anything with the skid's rope."
"coal"	149359819	presto	--	--	my-cola rule	"No need to go technologically backwards."
"soda"	193843450	presto	--	--	my-cola rule	"[cola-is-cola]."
"pop"	237284495	presto	--	--	my-cola rule	"[cola-is-cola]."
"gum"	201780662	presto	--	mug	--	"[if fizzy cola is visible]You'd get cola all over you if you tried anything with the mug[else]The mug is no longer manipulable[end if]."
"flea"	210322662	presto	--	leaf	--	"You can't bring the flea back to life--or do anything else to the leaf."
"trim"	297501820	presto	--	trim socks	--	"[trimsox]."
"sock"	242565306	presto	--	trim socks	--	"[trimsox]."
"socks"	338839272	presto	--	trim socks	--	"[trimsox]."
"sticks"	412589559	presto	--	rom sticks	--	"[romstix]."
"rom"	223751533	presto	--	rom sticks	--	"[romstix]."
"stick"	316315593	presto	--	rom sticks	--	"[romstix]."
"compiled"	486541157	presto	--	compiled code	--	"The code won't BUDGE."
"code"	242193360	presto	--	compiled code	--	"The code won't BUDGE."
"dongle"	378508824	presto	--	dongle	--	"It's built to be sturdy. You don't want to mess with it."
"bored yak"	504410731	presto	--	--	bookvis rule	"The book is unchangably bad. Sure, there are probably good parodies to be written, but that's not your area of wordsmithing. [kboard-det]"
"bored yak"	504410731	presto	--	keyboard	--	"You don't need to resummon the yak. And this programming exercise is enough of a yoke."
"fount"	377990806	presto	--	futon	--	"The futon could be a little less lumpy, sure, but that's beyond your magic powers."
"sleep"	487165982	presto	--	--	wise-to-sleep rule	"Your mind is a tired jumble right now, yes."
"onyx"	378387418	presto	--	onyx censer	--	"You consider the odd letters in such a short word, then  think 'X, Y, ... no.' Maybe the censer is just a censer, and the coloring is a clue to what it can be."
"censer"	525123080	presto	--	computer screen	--	"That screen is the best you'll get."
"onyxcenser"	903510498	presto	--	onyx censer	--	"You let out a string of something that feels good to say, but it doesn't mean anything. Maybe you're overthinking, and the color doesn't matter."
"trim socks"	636341092	presto	--	rom sticks	--	"The ROM sticks can probably make your computer go faster. Why fiddle further?"
"clock sap"	399038507	presto	--	caps lock	--	"YOU HAVE WHAT YOU NEED."
"floor"	314357692	presto	--	big-let	--	"You think about doing something to the floor. But making it disappear would probably be fatal. Best find another angle."
"yak"	177480248	presto	--	yak	--	"The yak doesn't seem to react to three plain letters thrown around like that. His look indicates not only that he is bored, but that he wants to let people know he's bored, but he's too bored to do that actively. The drab yoke he is wearing probably does not help."
"yoke"	377451116	presto	--	drab yoke	--	"It's not just any yoke. It's a drab yoke. I mean, a particularly drab yoke. On the bored yak."
"drab"	126959615	presto	--	drab yoke	--	"It's not just drab. It's a drab yoke. On the bored yak."
"scratchings"	604963096	presto	--	drab yoke	--	"You may wish to decipher the scratchings, instead."
"umph"	287929218	presto	--	hump	--	"Wrong sort of grunt to get over the hump."
"mazeltov"	655479952	presto	--	--	volt-maze-visible rule	"Oy vey! This one's a bit tricky, but I hope it's not too meshugennah."
"volt"	338441254	presto	--	--	volt-maze-visible rule	"That can't be it. It's a volt MAZE."
"maze"	317038698	presto	--	--	volt-maze-visible rule	"That can't be it. It's a VOLT maze."
"drat"	211650728	presto	--	dart	--	"[if dart is in marines]Some 4-letter word or other will get the dart.[else]Don't need to do anything else.[end if]"
"bingo"	239271538	presto	--	--	gun-broken rule	"Not quite. You're close to an a-ha moment, though."
"rats"	286895605	presto	--	star	--	"[if player has star]No need for additional arts.[else]The star doesn't budge.[end if]"
"spa"	179927743	presto	--	clock sap	--	"C'est [i]pas[r] sap. C'est du CLOCK SAP."
"fountain"	494078978	presto	--	fount	--	"It's too small to be a fountain--really, just a fount."
"ole"	255972525	presto	--	--	Leo-mad rule	"There are only six possibilities. Leo's not too bright, and he can figure it out."
"darn"	177448218	presto	--	--	Rand-mad rule	"Use the settler. This is a, err, regional word."
"leorand"	433420743	presto	--	Rand	--	"[if Rand is fightin]You don't need to create a monster[else]Leo and Rand look similar, but combining them would mean they couldn't have a friend[end if]."
"whassup"	526524588	presto	--	--	washup rule	"That's not the slangiest way to greet washups or make them feel better."
"bleep"	409310921	presto	--	plebe	--	"You're mangling it a bit. Louder, more authoritative, and more general."
"there"	481328338	presto	--	--	enemy-lines rule	"You point towards the ether, but you aren't focused on any one place enough."
"what"	250514908	presto	--	lawl wall	--	"Ehh? Whazzat?"
"lawl"	217750269	presto	--	lawl wall	--	"It's too expansive for you to use any mental energy on."
"saps"	276201709	presto	phat	--	--	"You pass through all ten reshufflings of Saps['] Pass, then feel like a bit of a sap, yourself. You pretty clearly need to go [if shack is visited]back [end if]north, here."
"mount"	415551063	presto	phat	--	--	"Mount Um, Not silently disposes of your attempts to manipulate it."
"harms"	285143039	presto	phat	--	--	"Despite being dangerous to walk into, Harm's Marsh serves an important ecological purpose I can't explain here. So, best not to meddle."
"key"	303098539	presto	--	keys	--	"You aren't sure which key would work, so you need a plan to get them all."
"entry"	507506690	presto	phat path	--	--	"[if leo is visible]No way you'll be able to meddle with the Entry from outside[else]the Entry doesn't need disabling, since you're the only person that can enter[end if]."
"letters"	697243862	presto	smart people sign	--	--	"You may want to focus on the highlighted letters."
"algorithm"	497738055	presto	shack	--	--	"[algo-no]."
"algorithms"	594012021	presto	shack	--	--	"[algo-no]."
"labs"	170694528	presto	--	labs slab	--	"The labs slab remains sturdy. Technology [slab-score], Wordplay Magic 0."
"alb"	74420562	presto	--	labs slab	--	"The labs slab remains sturdy. Technology [slab-score], Wordplay Magic 0."
"dead"	172052105	presto	--	flea	--	"There must be a more eco-friendly way to reincarnate the flea."
"clock"	219110764	presto	--	clock sap	--	"You can't make much out of a clock, but clock sap, maybe."
"reboot"	483363989	presto	--	--	time-to-reboot rule	"You need to give that computer another (figurative) kick."
"nottobe"	570057712	presto	shack	--	--	"Even more nothing happens than you expected. The blue button really is too broken. [if rebooted is true]You got the orange button to work, anyway[else]But the orange is not[end if]."
"compile"	465512068	presto	--	--	time-to-compile rule	"You've assembled the letters incorrectly."
"debug"	304959612	presto	--	--	time-to-debug rule	"You need to budge the letters about."
"blam"	138495715	presto	--	lamb	--	"That doesn't quite scare the lamb back home."
"shack"	207682846	presto	--	priv-shack	--	"You'll need to [if shack is visited]re-[end if]enter the shack to take care of things here."
"caps"	198933328	presto	--	caps lock	--	"[caps-no]."
"lock"	200105179	presto	--	caps lock	--	"[caps-no]."
"scratch"	362189074	presto	--	scratch paper	--	"[scrapap]."
"paper"	378249648	presto	--	scratch paper	--	"[scrapap]."
"tbakey"	426815280	presto	--	t-key	--	"[if t-key is reflexive]Nothing happens. It's probably just the TBA you need to work with, which certainly cuts things down[else]You already did enough with the TAB key[end if]."
"pile"	308078753	presto	--	coal	--	"It's not just any pile--it's a pile of coal."
"stick"	316315593	presto	--	gum	--	"It's just gum."
"stickofgum"	618963728	presto	--	gum	--	"It's just gum."
"catechism"	513739379	presto	shack	--	--	"[no-txtbk]."
"textbook"	666851463	presto	shack	--	--	"[no-txtbk]."
"book"	220057237	presto	shack	--	--	"[no-txtbk]."
"hard"	145823009	presto	shack	--	--	"[no-dsk]."
"drive"	386316667	presto	shack	--	--	"[no-dsk]."
"harddrive"	532139676	presto	shack	--	--	"[no-dsk]."
"grey"	368088866	presto	grey gyre	--	--	"[locname]."
"brunt"	380866041	presto	burnt brunt	--	--	"[locname]."
"dirge"	311751549	presto	dirge ridge	--	--	"[locname]."
"marines"	489567203	presto	marines seminar	--	--	"[locname]."
"marine"	393293237	presto	marines seminar	--	--	"[locname]."
"austerer"	732937433	presto	austerer	--	--	"[locname]."
"phat"	224046094	presto	phat path	--	--	"[locname]."
"shack"	207682846	presto	shack	--	--	"[locname]."
"hack"	111408880	presto	shack	--	--	"[locname]."
"storep"	568332432	presto	--	--	degen-true rule	"[not-the-reg]."
"tine"	344816481	oyster	--	stein	--	"Just one tine doesn't seem up to much."
"troll"	370414076	oyster	hops shop	--	--	"Dealing with just one troll would cause the rest to call you a bully and beat you up. Gotta take [']em all, somehow."
"recap"	315789274	oyster	hops shop	--	--	"Casper glares at you, as if he knows you're thinking all his recaps are the same. No. You [if recaps are reflexive]need to deal[else]already dealt[end if] with them all."
"patrons"	511621649	oyster	hops shop	--	--	"[patron]."
"patron"	415347683	oyster	hops shop	--	--	"[patron]."
"customer"	675053018	oyster	hops shop	--	--	"[patron]."
"customers"	771326984	oyster	hops shop	--	--	"[patron]."
"tune"	404929442	oyster	--	tunes	--	"Eh, you know how jukeboxes are. One tune quashed, another pops up. Get rid of [']em all."
"jar"	136472146	oyster	--	pills	--	"You suspect it's what's in the jar that's important."
"spill"	330360449	oyster	--	pills	--	"You seem to be fumbling what to do with the pills."
"scrawl"	364539784	oyster	--	scrawl	--	"It's probably not just any scrawl. What the scrawl says may be important."
"sing"	242774022	oyster	--	gins sign	--	"Hm, the sign doesn't strictly disallow THAT."
"tumbler"	557653634	oyster	--	tumblers	--	"You can't pick out which tumbler to do something to. But you're annoyed by their tips."
"stumbler"	653927600	oyster	--	tumblers	--	"Someone looks at you funny. 'What are you muttering?' [if tumblers are reflexed]You already spit, anyway[else]Maybe it's the writing on the tumblers, instead[end if]."
"jukebox"	540345182	oyster	--	jukebox	--	"You can't change the jukebox. The bad music has seeped into it[if tunes are reflexive]. But maybe you can put it out of commission[else]. It's already out of commission for now[end if]."
"remap"	360858842	oyster	--	jukebox	--	"You can't change the bad music selection[if tunes are reflexive]. But you can neutralize it--the jukebox has instructions[else]. You already got a temporary escape, and that should be good enough[end if]."
"unset"	501203408	oyster	--	jukebox	--	"You can't change the bad music selection[if tunes are reflexive]. But you can neutralize it--the jukebox has instructions[else]. You already got a temporary escape, and that should be good enough[end if]."
"canoe"	292259597	oyster	--	canoe	--	"The canoe sways alarmingly. Maybe it isn't the best vessel for crossing the river."
"fish"	205064007	oyster	Hero's shore	--	--	"T'fish won't shift nowt."
"herring"	482236070	oyster	Hero's shore	--	--	"Nothing doing. It is, after all, a RED herring. Ba dum bum."
"sculpture"	777010893	oyster	Hero's shore	--	--	"[sculpt]."
"cult"	281035249	oyster	Hero's shore	--	--	"[sculpt]."
"super"	495975644	oyster	Hero's shore	--	--	"[sculpt]."
"river"	450611381	oyster	Hero's shore	--	--	"[river-no]."
"rivera"	452799199	oyster	Hero's shore	--	--	"[river-no]."
"oar"	161864198	oyster	Hero's shore	--	--	"If you looked at just one oar, the raft would do no better than go in circles."
"boat"	198069318	oyster	Hero's shore	--	--	"No one boat seems better than the others. Maybe you should widen your focus to all the boats."
"pike"	307198092	oyster	--	pikes	--	"[all-fish]."
"carp"	187983165	oyster	--	carps	--	"[all-fish]."
"scrap"	284257131	oyster	--	carps	--	"Hm, yeah, you could probably tackle the carps or the pikes."
"spike"	403472058	oyster	--	pikes	--	"Hm, you could probably tackle the pikes or the carps."
"crays"	325150424	oyster	freight	--	--	"[no-cray]."
"cray"	228876458	oyster	freight	--	--	"[no-cray]."
"tutor"	471002223	oyster	--	reward drawer	--	"[if player is in range]Deal with the attackers, not the trout[else if wrap is off-stage]You try to describe how to fight, but that's not it[else]You can't find any other way to describe fighting[end if]."
"can"	90100911	oyster	--	cans	--	"Getting rid of one can would still leave a mess. Maybe you can deal with them all."
"cans"	186374877	oyster	--	cans	--	"You glance at your settler, wondering what to do with the cans. Maybe you've overlooked something obvious."
"eek"	308545396	oyster	--	eeks	--	"You try to eke out an eek, but you only have one data point, and that's not enough."
"reward"	429605395	oyster	--	drawer	--	"[if wrap is off-stage]Aunt Tuna would probably open the drawer if you helped poor Tortu the Trout[else]There's nothing else in the drawer and no way to get in by yourself[end if]."
"bubble"	341982470	oyster	--	bubble wrap	--	"It's just wrap, really."
"bubblewrap"	618894823	oyster	--	bubble wrap	--	"It's just wrap, really."
"sweat"	437312684	oyster	--	heaps	--	"The heaps are still technically waste, but you [if heaps are reflexive]may want to deal with them more delicately[else]beautified them enough[end if]."
"dent"	320852724	oyster	--	aunt tuna	--	"[if dent is in lalaland]You already fixed the dent. It's gone[else]That's not the way to futz with the dent, though it felt good to grunt while saying it. Or thinking it[end if]."
"tuna"	279311151	oyster	--	tuna	--	"She is a bit fussy, but she is more than okay as she is."
"eat"	233103945	oyster	--	tea tray	--	"Quit playing with your food, already."
"tray"	312980891	oyster	--	tea tray	--	"[just-tea]."
"teatray"	546084836	oyster	--	tea tray	--	"[just-tea]."
"trace"	337433333	oyster	--	--	crates-menace rule	"[if traced is true]Yes, one more thing to do with the crate--you know where they're from, and you know what to do. Instinctively[else]That won't quite help you figure where the crate is coming from[end if]."
"plain"	251367970	oyster	--	--	plains rule	"[if splained is true]You had your say.[else]'I...plan,' you think, then in a fit of confidence, 'I...PLANS!'[end if]"
"splain"	347641936	oyster	--	--	plains rule	"[if splained is true]You had your say[else]You feel like making a big speech about what you've done and what you plan to do, but not quite like that[end if]."
"rude"	339264808	oyster	--	rude door	--	"It's not the rudeness[knob-skis]."
"door"	255058046	oyster	--	rude door	--	"It's not the doorness[knob-skis]."
"rudedoor"	594322854	oyster	--	rude door	--	"It's not the whole[knob-skis]."
"brief"	303056559	oyster	--	rude door	--	"[prob-ov]."
"message"	547022823	oyster	--	rude door	--	"[prob-ov]."
"inthere"	595228692	oyster	--	rude door	--	"The words on the door don't change. They are just a generic taunt."
"open"	352532153	oyster	plains	--	--	"[if door-sux is true]You already opened the door[else]The words 'Nope, peon!' sear into your brain. Perhaps it's a bit more complicated[end if]."
"pearl"	350597528	oyster	--	paler pearl	--	"The pearl is too jagged to change easily, but it seems like it was roughly cut in half. Maybe if you find the other bit..."
"digger"	344351251	oyster	--	rigged digger	--	"It's what it needs to be, you imagine."
"doorknob"	469670214	oyster	--	knob	--	"It's just a knob. Which thankfully cuts down the possibilities."
"acters"	433707299	oyster	--	--	crates-menace rule	"Hmm, no, it's only one crate at a time..."
"reachs"	367879580	oyster	achers' arches	--	--	"[if arches-search is true]You did enough with the arches[else]That's not quite what to do with the arches[end if]."
"hedron"	414701385	oyster	achers' arches	--	--	"You'll probably need to destroy the hedron from within."
"hint"	254292671	oyster	--	thin hint	--	"The thin hint doesn't reveal anything else."
"intercom"	587573599	oyster	--	intercom	--	"[i-com]."
"not"	246370103	oyster	--	intercom	--	"Changing the intercom to a ton-crime intercom would be the opposite of what you want to do."
"crime"	341203496	oyster	--	intercom	--	"[i-com]."
"debris"	393844718	oyster	--	crate	--	"You can't learn much from the debris. You're pretty sure it's from a crate."
"fragments"	606798973	oyster	--	fragments	--	"[if reacted is true and traced is true]Not worth messing with the fragments[else]They're fragments of a crate--this may or may not help[end if]."
"shut"	341772090	oyster	--	plains	--	"[if uaah is visited]You found the hut you needed to[else]The huts are too secure, but maybe you can go by the door[end if]."
"inthere"	595228692	oyster	--	plains	--	"You don't need to mess with the message on the rude door."
"sardine"	446521139	oyster	--	sardine	--	"The sardine gives you a weird look, as if you need to stop mumbling. You're not sure you can do anything to him directly."
"wipe"	362199687	oyster	--	wipes	--	"It'd be easier to [if player has wipes]use them all[else]steal all the wipes[end if] at once. Pulling them out and so forth--tiring."
"swipe"	458473653	oyster	wipes	--	--	"[if player has wipes]You better not fiddle with the wipes wrong, or they'll tear and disintegrate[else]You try to take the wipes, but you worry you're not fast enough[end if]."
"kiss"	290473956	oyster	--	skis	--	"Hmm, what can you do to the skis, though?"
"isk"	194199990	oyster	--	skis	--	"But you need to remove both skis."
"ubt"	226634730	oyster	--	tubs	--	"Clear ALL the tubs!"
"bust"	322908696	oyster	--	tubs	--	"That didn't make anything go boom."
"drop"	262171428	oyster	--	prod	--	"You're juggling what to do with the prod, here."
"lance"	271720859	oyster	--	lance	--	"The lance is still itself[if lance is cleaned]--and you probably did enough cleaning it[else if player has wipes]--you can't figure how to apply the wipes[else]--but how to make it neater, now[end if]."
"haunter"	529723362	oyster	--	--	is-hauntable rule	"[if haunter is off-stage]Hmm, but how to dig up the haunter[to-dig].[else]The haunter needs to be dealt with otherwise.[end if]"
"assuage"	462435186	oyster	--	--	h-assuaged rule	"Don't oversell it! Just take the haunter to where it was probably the walleyes who buried the ruby."
"bury"	331207767	oyster	--	ruby	--	"That's not quite it. You file that idea six feet under."
"bonk"	214612168	oyster	--	knob	--	"That isn't quite the right way to hit the knob."
"howler"	486513400	oyster	--	haunter	--	"Anything can howl, but this is a haunter--and, in fact, it's not just a haunter but a SAUSAGE."
"tarp"	272087598	oyster	--	o-t	--	"You think of changing the trap--maybe even a tarp! But maybe the trap IS a tarp that enfolds you. Scary. No, thinking of it as an ol['] trap would make it less intimidating."
"walleye"	595721739	oyster	--	walleyes	--	"Just tacking one walleye won't change the crowd. They're past redemption, anyway."
"walleyes"	691995705	oyster	--	walleyes	--	"The walleyes are a bad crowd, past redemption."
"theses"	588552467	oyster	--	theses sheets	--	"The hedron's spirit will remain intact even if you meddle there. You must go into its heart."
"these"	492278501	oyster	--	theses	--	"It'd be fun to rip up even one, but it'd be worse if you got caught. Take down the hedron, instead."
"papery"	500608900	oyster	--	yapper	--	"'Quit yer mumblin, ya perp!' the yapper yells, turning red. 'You here to do business or not?'"
"redial"	335153504	oyster	--	yapper	--	"The yapper might alert his cronies if you try anything. Even something not quite right, like that."
"stupid"	451977685	oyster	--	yapper	--	"[its-msg]."
"paper"	378249648	oyster	--	yapper	--	"[its-msg]."
"necklace"	471465731	oyster	--	yapper	--	"[its-msg]."
"jumble"	418180338	oyster	Den Loft	--	--	"It's the words on the jumble you need to mess with. With which you need to mess[if yapper is in den loft]. Well, once the yapper's out of the way[end if]."
"posh"	289374801	oyster	hops shop	--	--	"[locname]."
"lode"	277001614	oyster	olde lode	--	--	"[locname]."
"hoser"	421038754	oyster	hero's shore	--	--	"You give a few Er-ohs, oh-ers, Or Ehs. You'll probably need to say something entirely different to cross the river. There's the raft--those boats."
"hero"	324764788	oyster	hero's shore	--	--	"You give a few Er-ohs, oh-ers, Or Ehs. You'll probably need to say something entirely different to cross the river. There's the raft--those boats."
"anger"	316824940	oyster	anger range	--	--	"[locname]."
"handsome"	491914519	oyster	handsome sand home	--	--	"[locname]."
"home"	303516138	oyster	sand home	--	--	"[locname-part]."
"sand"	188398381	oyster	sand home	--	--	"[locname-part]."
"hedron"	414701385	oyster	hedron	--	--	"[locname]."
"collapsed"	529748781	oyster	old places	--	--	"[locname]."
"old"	149195505	oyster	collapsed	--	--	"[locname-part]."
"places"	380553276	oyster	collapsed	--	--	"[locname-part]."
"end"	217742706	oyster	end den	--	--	"[locname]."
"scumant"	458665855	oyster	scum ant sanctum	--	--	"[locname]."
"scum"	284460511	oyster	scum ant sanctum	--	--	"The ant may be scum, but you need to deal with what it IS."
"tenfold"	475534036	oyster	tenfold	--	--	"[locname]."
"loft"	257791330	oyster	tenfold	--	--	"[locname-part]."
"den"	217742706	oyster	tenfold	--	--	"[locname-part]."
"freight"	457629673	oyster	freight	--	--	"[locname]."
"lean"	252715274	oyster	lean lane	--	--	"[locname]."
"ahut"	247685942	oyster	uaah	--	--	"[locname]."
"hut"	245498124	oyster	uaah	--	--	"[locname-part]."
"storey"	609225725	oyster	--	--	degen-true rule	"[not-the-reg]."
"badlands"	283848032	towers	--	--	degen-true rule	"[bland-sad]."
"sad"	119490873	towers	--	--	degen-true rule	"[bland-sad]."
"bland"	164357159	towers	--	--	degen-true rule	"[bland-sad]."
"curst"	408819179	towers	--	--	degen-true rule	"It's not just that it's curst, it's a PALACE, too."
"palace"	286467128	towers	--	--	degen-true rule	"It's not just that it's a palace, it's CURST, too."
"castle"	402197335	towers	--	--	degen-true rule	"Not just any castle. Castle Apcur."
"apcur"	293088972	towers	--	--	degen-true rule	"Not, like, swamp Apcur or hut Apcur. Castle Apcur."
"lake"	236740944	towers	--	--	degen-true rule	"[if player is in rawest waters]Nothing you think of could get you out of this mess, and even if it could, you'd totally have upset the ecosystem.[else if leak lake is visible]You can't drain the lake. It would probably upset the ecosystem anyway. People would be without water![else if trefoil is visited]You're beyond the lake now.[else]You can't see Leak Lake yet.[end if]"
"warrior"	485439423	towers	--	trefoil	--	"[war-one]."
"warriors"	581713389	towers	--	trefoil	--	"[war-one]."
"toaster"	592164309	towers	--	toaster	--	"It's a pretty sturdy toaster, a useful appliance as-is. Nothing you do or think seems to change it."
"pastry"	490720816	towers	--	--	pas-vis rule	"You need to be specific about which pastry--or you would, if any could be changed. As is, you can just eat one once it's warmed."
"start"	390005623	towers	--	start tarts	--	"[eat-pastry]."
"scalier"	429403966	towers	--	Éclairs	--	"[eat-pastry]."
"strudel"	592462631	towers	--	--	strood rule	"[eat-pastry]."
"solve"	459411311	towers	--	solve-a-loaves	--	"[eat-pastry]."
"loaves"	461599129	towers	--	solve-a-loaves	--	"[eat-pastry]."
"brownies"	624010487	towers	--	brownies	--	"[eat-pastry]."
"owers"	491691228	towers	--	brownies	--	"[eat-pastry]."
"bin"	132319259	towers	--	brownies	--	"[eat-pastry]."
"brownie"	527736521	towers	--	solve-a-loaves	--	"[not-singular-hp]."
"tart"	293731657	towers	--	start tarts	--	"[not-singular-hp]."
"eclair"	333130000	towers	--	Éclairs	--	"[not-singular-hp]."
"loaf"	156869130	towers	--	solve-a-loaves	--	"[not-singular-hp]."
"copse"	398904196	towers	--	spec-o-scope	--	"[cop-sco]."
"spec"	324551619	towers	--	spec-o-scope	--	"[cop-sco]."
"camp"	166734515	towers	campsite	--	--	"[gosh-camp]!"
"site"	372182939	towers	campsite	--	--	"[gosh-camp]!"
"campiest"	538917454	towers	campiest	--	--	"[gosh-camp]!"
"pirate"	444886553	towers	--	pirates	--	"[plutry of pirates]Changing just one pirate would not, you sense, do much. It might even ostracize him among his peers. Perhaps there's a way to deal with the lot of them. By adding an s."
"oddly"	292583846	towers	--	rewired robot	--	"[odd-rob]."
"robot"	355557880	towers	--	rewired robot	--	"[odd-rob]."
"wait"	258225455	towers	--	wait-seer	--	"[wait-see]."
"seer"	437209987	towers	--	wait-seer	--	"[wait-see]."
"save"	322482550	towers	--	raves saver	--	"[no-fril]."
"saver"	418756516	towers	--	raves saver	--	"[no-fril]."
"recorder"	625970878	towers	--	raves saver	--	"[no-fril]."
"tape"	314569904	towers	--	raves saver	--	"[no-fril]."
"player"	472956780	towers	--	raves saver	--	"[if raves saver is reflexed]It's as bright as it'll get[else]Hm, the 'replay player' letters whiten a bit, but nothing definitive[end if]."
"denim"	326810705	towers	--	denim	--	"You scrape at the denim fragments and wonder if there is any magic in dem. Well, not the way you thought it, apparently."
"reeds"	458239076	towers	--	reed's ale	--	"[reed-ale]."
"reed"	361965110	towers	--	reed's ale	--	"[reed-ale]."
"ale"	183807766	towers	--	reed's ale	--	"[reed-ale]."
"reedale"	545772876	towers	--	reed's ale	--	"[reed-ale]."
"pester"	621785964	towers	--	serpent	--	"The serpent doesn't just pester, it's pester'n."
"nameless"	637144468	towers	--	salesmen	--	"The salesmen laugh at the sheer [i]lameness[r] of what you're saying, or trying to say, or whatever. Compared to you, their maleness, talk--and clothes--are clearly [i]dandier[r].[paragraph break]Or maybe they're just too unimaginative to be affected by any of your nonsense powers. Well, directly."
"salesman"	511526177	towers	--	salesmen	--	"Picking off one salesman would just make the others work harder for their commission. And it's not doable, anyway. If you got rid of their product, they might stop pestering you."
"fissure"	582291393	towers	--	fissure	--	"Bizarre animal noises continue to emanate from the fissure. It is beyond your control[if doc-y is not in ropins], but the duck's already figured it[else if duck is visible], but the duck seems to be poking at it[else], and you wonder who or what could tinker with it[end if]."
"dagger"	301546223	towers	--	dagger	--	"You feel no energy from the dagger. Perhaps it needs to be repaired mechanically."
"shirts"	463256898	towers	--	salesmen	--	"The shirts were built to resist the most direct of manipulations. Perhaps you can work on the salesmen themselves. Because the shirts do make them look dandier."
"prune"	468609186	towers	--	iPrune	--	"It's officially an iPrune, not a prune."
"hulk"	249135123	towers	--	muscly hulk	--	"You make some helpless-sounding noises, trying to form a sensible word. The hulk looks slightly annoyed, but completely--and rightfully--unworried. As Daltho said, four letters would be too simple."
"musclyhulk"	709768725	towers	--	muscly hulk	--	"You wrack your brain but quickly get the sense you're over-thinking how to ju-jitsu the hulk's strength."
"tapin"	300664149	towers	--	man covered in	--	"It won't be such a tap-in to nip at, sadly. Daltho's advice comes back: nobody will be easier than Rodney."
"organized"	580169070	towers	--	organised	--	"Nothing seems to happen. Then you remember organized can be spelled with an s and not a z."
"ego"	234758388	towers	--	ego drains	--	"[ego-dr]."
"drains"	318715030	towers	--	ego drains	--	"[ego-dr]. Plus, if they were boring old drains, you could just step around them."
"egodrain"	222441064	towers	--	ego drains	--	"[ego-dr]."
"drain"	457199452	towers	--	ego drains	--	"[ego-dr]. Plus, if it was a boring old drain, you could just step around."
"deacons"	409562652	towers	--	deacons	--	"The deacons mumble to themselves, and you catch 'Lo! Is the...?' / 'Toils, eh.' and your calling upon supernatural powers that clearly don't exist. You feel devoid of can-does after your latest attempt, mumbling 'Eh, I lost.'[paragraph break]You get the sense the deacons have given you the run-around. They're not going to discuss their hostile ol['] heist around you[if deacons are ncscanned]--but maybe you can muddle through the odd readings from the settler[end if]."
"shrine"	460586531	towers	--	o-s	--	"The shrine is kind of sacred, and regardless of what you think of the deacons['] religion, messing with it would be a mean move."
"costume"	589729215	towers	--	reed's ale	--	"You fail to cut some from the costume. Maybe it's more what the costume advertises--REED'S ALE."
"leaves"	515052661	towers	campsite	--	--	"[fun-leaves]."
"deadleaves"	687104766	towers	campsite	--	--	"[fun-leaves]."
"dead"	172052105	towers	campsite	--	--	"[fun-leaves]."
"unlocked"	522953692	towers	--	--	duck-cant rule	"The lone duck looks around for something to do but can't find anything. Well, not here. And not like that."
"weed"	384576080	towers	--	weeds	--	"Gumming up one weed wouldn't get the others."
"buttons"	569278799	towers	--	raves saver	--	"The raves saver's minimal capabilities are enough...just..."
"button"	473004833	towers	--	raves saver	--	"The raves saver's minimal capabilities are enough...just..."
"lone"	324880033	towers	--	lone duck	--	"It's not just any lone animal. It's a lone DUCK."
"cliff"	170842062	towers	--	cliff	--	"The cliff remains motionless. Perhaps it's useful, after all, to block off some ways to go. This area looks big enough."
"gol"	160766118	towers	subsector	--	--	"[if fissure is visible]The gaol is too sturdy to defeated by a three-word combination. Or a four-word one[else]You opened the gaol, and there's not much else to do with it[end if]."
"gaol"	162953936	towers	subsector	--	--	"The gaol is too much. It's built to resist you, and unlike the curst palace far away, it was never built to be something nicer."
"loggaol"	323720054	towers	subsector	--	--	"Nah, you're pretty sure you're overthinking things now. You [if duck is returned]opened[else]may want to open[end if] the prison."
"jail"	149955028	towers	subsector	--	--	"It's not just any jail--but prison ropins."
"ropin"	355042693	towers	subsector	--	--	"[no-ropin]."
"ropins"	451316659	towers	subsector	--	--	"[no-ropin]."
"duck"	198073659	towers	--	lone duck	--	"It's not just any duck. [if duck is returned]But it's served its purpose[else]It's a LONE duck[end if]."
"ray"	209870873	towers	--	ray eck	--	"[ray-part]."
"eck"	199744872	towers	--	ray eck	--	"[ray-part]."
"diner"	348059355	towers	--	diners	--	"[plutry of diners]There's more than one diner blocking you."
"ingrate"	464927804	towers	--	ingrates	--	"[plutry of ingrates]There's more than one ingrate blocking you."
"deacon"	313288686	towers	--	deacons	--	"[plutry of deacons]There's more than one deacon blocking you."
"yurt"	415898880	towers	--	yurts	--	"There's more than one yurt there."
"dirt"	254455756	towers	Outer Route	--	--	"[out-rou]."
"trail"	289428324	towers	Outer Route	--	--	"[out-rou]."
"shoals"	360184465	towers	--	shoals	--	"[shoaly]."
"shoal"	263910499	towers	--	shoals	--	"[shoaly]."
"cans"	186374877	towers	--	Nerd-Aid	--	"[nerd-a]."
"nerd"	303066509	towers	--	Nerd-Aid	--	"[nerd-a]."
"aid"	68209753	towers	--	Nerd-Aid	--	"[nerd-a]."
"wears"	419526469	towers	--	Nerd-Aid	--	"You suppress a swear as the sales pitch wears on you."
"bottles"	576885432	towers	--	Nerd-Aid	--	"They're not just bottles! They're bottles of NERD-AID!"
"liam"	165069656	towers	--	grailman	--	"[grail-name]."
"garn"	189018831	towers	--	grailman	--	"[grail-name]."
"native"	454169119	towers	--	natives	--	"[plutry of natives]You'll need to deal with more than one native to make your way south."
"neuralpulses"	1003884530	towers	--	neural pulses	--	"Man, biochemistry's way complex. Complex isomers and such are worse than anagrams! You may be more successful breaking the neural pulses down into components."
"geese"	512291995	towers	--	--	bonker-gone rule	"The geese are fine as they are. They're just there for scenery, and stuff."
"atheist"	514763074	towers	--	atheists	--	"Changing only one atheist would only help you so long. The rest would restore their companion's (lack of) faith shortly."
"yow"	304646602	towers	--	doc-y	--	"He's a doctor! Have some respect when you try to scramble him up."
"doctor"	377173649	towers	--	doc-y	--	"That is too formal. Plus, Dr. Yow worked hard for a Ph.D., and changing that would be kind of mean."
"locked"	348940377	towers	--	subsector	--	"Nothing needs to be locked here, certainly not the gaol which [if doc-y is in ropins]already is[else]you unlocked[end if]."
"idtag"	203919473	towers	--	ID Tag	--	"ID tag: dig at it? Gad."
"retape"	527699816	towers	--	raves saver	--	"The raves saver has limited functionality, alas."
"wordy"	410999494	towers	--	doc-y	--	"Dr. Yow seems to ponder something for a second but then shakes his head[if doc-y has been rowdy and doc-y has been wordy]--he's probably shown his full range of emotions[else if doc-y has not been rowdy and doc-y has not been wordy]--but he can't break out of his shell[else]--maybe there's one more way for him to be, to talk[end if]."
"tentative"	788195264	towers	--	--	kid-not-learnt rule	"The kid fidgets a bit but can't keep focused, though he wants to."
"dirk stam"	469925871	towers	--	smart kid	--	"The kid looks at you curiously. You probably don't need to change his name or his intelligence."
"smart"	350970758	towers	--	smart kid	--	"[dirk-no]."
"kid"	118955113	towers	--	smart kid	--	"[dirk-no]."
"dirk"	204278916	towers	--	smart kid	--	"[dirk-no]."
"stam"	265646955	towers	--	smart kid	--	"[dirk-no]."
"gizmo"	338989896	towers	--	gizmo	--	"[giz-tex]."
"zomg"	293997050	towers	--	gizmo	--	"[giz-tex]."
"turbo"	386311110	towers	--	turbos	--	"You [if turbos are reflexed]already dealt[else]need to deal[end if] with both turbos."
"jetski"	474076642	towers	--	jetskis	--	"[j-no]."
"jetskis"	570350608	towers	--	jetskis	--	"[j-no]."
"skis"	290473956	towers	--	jetskis	--	"[j-no]."
"ski"	194199990	towers	--	jetskis	--	"[j-no]."
"waster"	522636487	towers	--	eastern shore	--	"Ew. Rats. You do feel like a waster, doing something with the waters. Perhaps the northern--or eastern--shore can work better."
"spray"	387610798	towers	rawest waters	--	--	"The spray will still drown you if you don't figure a way to move somewhere."
"water"	426362521	towers	rawest waters	--	--	"The water is too elemental and generic to change. Plus the badlands are dry enough. How to get closer to a shore?"
"occurs"	399067323	towers	--	crocus	--	"[if flowerpot is reflexive]You realize you can't change the crocus to something, but you can change its condition--it's dying[else]The crocus is OK as-is. In fact, it could make a nice gift for someone who could appreciate it[end if]."
"flowerpot"	734674551	towers	--	flowerpot	--	"[flow-fine]."
"flower"	475745997	towers	--	flowerpot	--	"[flow-fine]."
"pot"	258928554	towers	--	flowerpot	--	"[flow-fine]."
"proof"	342009812	towers	--	flowerpot	--	"[flow-fine]."
"welt"	392664739	towers	--	flowerpot	--	"[flow-fine]."
"oldhat"	291775640	towers	--	flowerpot	--	"You don't have time to think about, or change, Old Hat Daltho. [if crocus is in lalaland]You got his present to his friend[else if ed yerg is reflexed]. You've found his friend and made him happy[else if solo den is visited]His friend is still unreceptive, though[else]You haven't yet found his friend he sent the gift to, anyway[end if]."
"gander"	337854029	towers	Danger Garden	--	--	"[towersloc]."
"shaven"	439622520	towers	shaven havens	--	--	"[towersloc]."
"haven"	343348554	towers	shaven havens	--	--	"[towersloc]."
"repair"	427100338	towers	--	rapier repair	--	"[rapier-mach]."
"machine"	364257318	towers	--	rapier repair	--	"[rapier-mach]."
"shiny"	369815871	towers	--	rapier repair	--	"[rapier-mach]."
"unblest"	573436152	towers	sunbelt	--	--	"[towersloc]."
"baldest"	422639744	towers	saltbed	--	--	"[towersloc]."
"actionless"	686724232	towers	coastlines	--	--	"[towersloc]."
"coastline"	590450266	towers	coastlines	--	--	"[towersloc]."
"shoreline"	716559056	towers	shoreline	--	--	"[towersloc]."
"lost"	327550400	towers	lost lots	--	--	"[towersloc]."
"lot"	231276434	towers	lost lots	--	--	"[towersloc]."
"obscurest"	725670736	towers	subsector	--	--	"[towersloc]."
"salted"	404220839	towers	deltas	--	--	"[towersloc]."
"delta"	307946873	towers	deltas	--	--	"[towersloc]."
"cinema"	326975019	towers	anemic cinema	--	--	"[towersloc]."
"theater"	586626174	towers	anemic	--	--	"You don't need to go looking for screens to stare at right now. You have a world to save."
"outre"	495698314	towers	outer route	--	--	"[towersloc]."
"ravages"	453544036	towers	ravages	--	--	"This is a weird place, being at the crossroads, but better to [if number of visible guardians is 0 and weeds are in lalaland and denim is in lalaland]mess around elsewhere[else if weeds are visible]get rid of the weeds[else if number of visible guardians > 0]tackle a guardian[else if denim is visible]see if you can get rid of the denim[end if]."
"ravage"	357270070	towers	ravages	--	--	"[towersloc]"
"deposit"	549030564	towers	deposit	--	--	"[towersloc]."
"northern"	651013625	towers	--	eastern shore	--	"The northern shore does not waver. Maybe try the eastern shore."
"shore"	421038754	towers	--	eastern shore	--	"You need to focus on one specific shore."
"shores"	517312720	towers	--	eastern shore	--	"You need to focus on one shore."
"north"	368976205	towers	--	eastern shore	--	"Hmm. Concentrate on a shore--northern or eastern--not a direction."
"east"	329377911	towers	--	eastern shore	--	"Hmm. Concentrate on a shore--northern or eastern--not a direction."
"southwest"	851249533	towers	--	eastern shore	--	"[diag-dir-rej]."
"trefoil"	515914088	towers	trefoil	--	--	"[towersloc]."
"noodles"	516535665	towers	solo den	--	--	"[towersloc]."
"solo"	298792959	towers	solo den	--	--	"[locname-part]."
"old"	149195505	towers	solo den	--	--	"[locname-part]."
"one"	271066194	towers	solo den	--	--	"[locname-part]."
"den"	217742706	towers	solo den	--	--	"[locname-part]."
"ones"	367340160	towers	solo den	--	--	"[locname-part]."
"accurst"	430012582	towers	--	accurst leap	--	"[focus-castle]."
"leap"	265273725	towers	--	accurst leap	--	"[focus-castle]."
"clear"	288137154	towers	--	clear catsup	--	"[focus-castle]."
"catsup"	407149153	towers	--	clear catsup	--	"[focus-castle]."
"pest"	408656052	towers	--	accrual	--	"[focus-castle]."
"accrual"	286630255	towers	--	accrual	--	"[focus-castle]."
"cactus"	344688779	towers	--	--	cppc rule	"[focus-castle]."
"pearl"	350597528	towers	--	--	cppc rule	"[focus-castle]."
"capsule"	485659083	towers	--	capsule cart	--	"[focus-castle]."
"cart"	209627224	towers	--	capsule cart	--	"[focus-castle]."
"accu"	145304795	towers	--	accu-plaster	--	"[focus-castle]."
"plaster"	549981512	towers	--	accu-plaster	--	"[focus-castle]."
"last"	255385641	towers	--	last acre cup	--	"[focus-castle]."
"race"	234323315	towers	--	last acre cup	--	"[focus-castle]."
"cup"	205577351	towers	--	last acre cup	--	"[focus-castle]."
"talc"	178117260	towers	--	talc spa cure	--	"[focus-castle]."
"spa"	179927743	towers	--	talc spa cure	--	"[focus-castle]."
"cure"	337241304	towers	--	talc spa cure	--	"[focus-castle]."
"mislit"	407258668	towers	limits	--	--	"[towersloc]."
"storew"	594801246	towers	--	--	degen-true rule	"[not-the-reg]."
"cinder"	367064940	otters	--	cinders	--	"You'll need to change more than one cinder."
"bulwark"	425718123	otters	--	bulwark	--	"The whole bulwark? No, you [if inhib is true]couldn't do much with it at full strength[else]can't do much[end if]. [if Inclosure is visited]You need to tackle Elvira in there[else]Maybe you can surprise Elvira in there[end if], with help[if inhib is true] and your powers back[end if]. Plus, Elvira checked to make sure you couldn't do anything drastic to, well, a bulwark."
"corona"	324129868	otters	--	racoon	--	"[poor-animal]."
"nails"	266175977	otters	--	snail	--	"[poor-animal]."
"thrones"	593056280	otters	--	hornets	--	"[poor-animal]."
"pines"	419446388	otters	--	snipe	--	"[poor-animal]."
"tail"	204104521	otters	--	a-l-t	--	"It's a nice tail, and the racoon seems proud of it, so it'd be kind of mean to change it."
"steward"	543665576	otters	--	Ed Riley	--	"Hm, you only managed to deal with adverbs so far, and steward doesn't have an L or Y. Maybe look at him for clues? Remember his name?"
"rye"	335489164	otters	--	deli rye	--	"[del-ry]."
"lied"	247641883	otters	--	deli rye	--	"[del-ry]."
"sandwich"	397613884	otters	--	deli rye	--	"[del-ry]."
"edriley"	583131047	otters	--	Ed Riley	--	"If only Ed Riley said things less loudly, boomingly, startlingly..."
"simply"	462981015	otters	--	sly imp	--	"He's acting simply, but he can't be gotten rid of that simply. At least, nothing happens when you try. Maybe you need to consider more specific ways he's moving."
"sly"	272447057	otters	--	sly imp	--	"[imp-sly]."
"imp"	190533958	otters	--	sly imp	--	"[imp-sly]."
"whiner"	472247338	otters	anteroom	--	--	"[whiney]."
"whiners"	568521304	otters	anteroom	--	--	"[whiney]."
"mack"	138201734	otters	--	macks	--	"If you messed with one mack, the others would gang up on you. Work on the argument, instead."
"macks"	234475700	otters	--	macks	--	"Hm, you probably can't change the macks. They're dead set in their ways. Perhaps you can reframe what they are saying[if macked-out > 0] some more[end if]."
"gretta"	454137468	otters	--	Gretta	--	"Gretta's been manipulated enough[if macks are visible]. Deal with the macks['] arguments, instead[end if]."
"frontage"	520802431	otters	fro	--	--	"[locname-part]."
"gent"	332423337	otters	fro	--	--	"[locname-part]."
"fora"	188379094	otters	fro	--	--	"[locname-part]."
"frat"	217136535	otters	fro	--	--	"[locname-part]."
"gone"	303665896	otters	fro	--	--	"[locname-part]."
"gents"	428697303	otters	fro	--	--	"They aren't (spiritually) gents, and you can't change them but their arguments."
"sobbingly"	530137500	otters	--	macks	--	"[mack-clue of 530137500]."
"wearingly"	645925650	otters	--	macks	--	"[mack-clue of 645925650]."
"nastily"	491645247	otters	--	macks	--	"[mack-clue of 491645247]."
"irately"	539593685	otters	--	macks	--	"[mack-clue of 539593685]."
"blearily"	508716411	otters	--	macks	--	"[mack-clue of 508716411]."
"coitally"	473635774	otters	--	macks	--	"[mack-clue of 473635774]."
"martially"	531864386	otters	--	macks	--	"[mack-clue of 531864386]."
"silently"	671077377	otters	--	macks	--	"[mack-clue of 671077377]."
"seedily"	594081210	otters	--	macks	--	"[mack-clue of 594081210]."
"shadily"	377939109	otters	--	macks	--	"[mack-clue of 377939109]."
"snidely"	535182609	otters	--	macks	--	"[mack-clue of 535182609]."
"ribaldly"	401939391	otters	--	macks	--	"[mack-clue of 401939391]."
"cattily"	448579376	otters	--	macks	--	"[mack-clue of 448579376]."
"tediously"	748843503	otters	--	macks	--	"[mack-clue of 748843503]."
"drywalling"	592962469	otters	--	macks	--	"[mack-clue of 592962469]."
"starkly"	516001874	otters	--	macks	--	"[mack-clue of 516001874]."
"redisplaying"	781752737	otters	--	macks	--	"[mack-clue of 781752737]."
"iq"	129398463	otters	--	medals	--	"[both-medals]."
"lucky"	353217661	otters	--	medals	--	"[both-medals]."
"island"	287205066	otters	loop pool	--	--	"Even if you could change it, the way across the loop pool is too treacherous."
"sea"	226267893	otters	--	sea cube	--	"The whole sea cube."
"cube"	270336406	otters	--	sea cube	--	"The whole sea cube."
"rev"	320294732	otters	--	p-2	--	"The [italic type]whole[roman type] picture."
"howe"	347375758	otters	--	p-2	--	"The [italic type]whole[roman type] picture."
"medal"	268912008	otters	--	medals	--	"It's what the medals say that makes them special."
"medals"	365185974	otters	--	medals	--	"It's what the medals say that makes them special."
"averts"	521866534	otters	--	sly imp	--	"You need to focus on HOW the imp averts, vaster."
"monstery"	742208386	otters	alcoves	--	--	"[w-change]."
"monastery"	744396204	otters	alcoves	--	--	"[w-change]."
"eelmr"	458825013	otters	--	--	eelmr rule	"[eelmry]."
"sober"	402175360	otters	--	sober robes	--	"If you did play a prank on Elmer and Merle, they might guess who you were and take you down."
"low"	236101189	otters	--	owls	--	"You probably want the owls not to swoop low. And you'll want to take care of them all."
"clipons"	438812280	otters	--	slopinc	--	"The ocelots would still be awkward even if they lost the clip-ons."
"kool"	255452171	otters	--	look-kool	--	"You're not here to mess with fashion."
"shades"	380853247	otters	--	look-kool	--	"You're not here to mess with fashion. Plus, the shades were last game."
"laminas"	332438948	otters	alcoves	--	--	"[no-lam]."
"lamina"	236164982	otters	alcoves	--	--	"[no-lam]."
"forces"	429276936	otters	alcoves	--	--	"[fresc]."
"force"	333002970	otters	alcoves	--	--	"[fresc]."
"hydra"	268182261	otters	--	--	hydra-know rule	"[if player is in Inclosure]The hydra's toast. Elvira is not. Deal with her[else]You try, but that doesn't do anything with, or to, the hydra to the west[end if]."
"pine"	323172422	otters	--	pines	--	"So many pines, hard to pick one. Might as well take care of them all."
"nail"	169902011	otters	--	nails	--	"So many nails, hard to pick one. Might as well take care of them all."
"raccoon"	343135453	otters	preserve	--	--	"[if corona is visible]The corona seems to waver, the 'c' in it vanishing and reappearing, as if it isn't really important[else]The rac(c)oon's fine as it is, with one C or two[end if]."
"ocelot"	452440705	otters	--	ocelots	--	"The ocelots are hanging too close together for you to pick off one[if ocelots are reflexed] and make him less cool[end if]."
"throne"	496782314	otters	--	thrones	--	"There's more than one throne, but it doesn't matter, really, for what you need to do."
"weltish"	 571213850	otters	--	whistle	--	"You [if whistle is reflexed]already learned to play the whistle, so you don't want to change it[else]probably need to learn to play the whistle right, instead[end if]."
"crone"	375395582	otters	Inclosure	--	--	"You can't do much with Elvira's 'real' name. Or her ex-hydra. You need to act."
"inclosure"	675582040	otters	inclosure	--	--	"You feel blocked from doing something to the area. Elvira wouldn't be so careless to allow THAT. You figure you probably need help."
"tripod"	410274292	otters	inclosure	--	--	"[Inclosure-scen]."
"becharm"	354099672	otters	inclosure	--	--	"[Inclosure-scen]."
"roarings"	489962023	otters	inclosure	--	--	"[Inclosure-scen]."
"roaring"	393688057	otters	inclosure	--	--	"[Inclosure-scen]."
"nacht"	230493228	otters	Inclosure	--	--	"It's annoying and unswayable, like most chants."
"stocked"	494510522	otters	Inclosure	--	--	"You can't release any prisoners from the stockade THAT easily. You'd need an army."
"vats"	308736622	otters	Inclosure	--	--	"[Inclosure-scen]."
"vat"	212462656	otters	Inclosure	--	--	"[Inclosure-scen]."
"pyre"	416955123	otters	Inclosure	--	--	"[Inclosure-scen]."
"stockade"	496698340	otters	Inclosure	--	--	"[Inclosure-scen]."
"warship"	455461464	otters	Inclosure	--	--	"[Inclosure-scen]."
"amulet"	456098744	otters	Inclosure	--	--	"[one-toy]."
"ultimate"	604201608	otters	Inclosure	--	--	"[one-toy]."
"shaper"	430339954	otters	Inclosure	--	--	"[one-toy]."
"purple"	534981476	otters	Inclosure	--	--	"[elv-mach]."
"oranger"	476501320	otters	Inclosure	--	--	"[elv-mach]."
"alcove"	384330748	otters	alcoves	--	--	"[locname]."
"alcoves"	480604714	otters	alcoves	--	--	"[locname]."
"pool"	283984952	otters	loop pool	--	--	"[locname]."
"barn"	174838034	otters	bran barn	--	--	"[locname]."
"wiredeck"	586831492	otters	wickeder wire deck	--	--	"[locname]."
"wire"	366057531	otters	wire deck	--	--	"[locname-part]."
"deck"	220773961	otters	wire deck	--	--	"[locname-part]."
"tapering"	546393763	otters	Tapering Anger Pit	--	--	"[locname]."
"anger"	316824940	otters	Tapering Anger Pit	--	imp-here rule	"[locname-part]."
"pit"	229568823	otters	Tapering Anger Pit	--	imp-here rule	"[locname-part]."
"inert"	430140284	otters	Tapering Anger Pit	--	--	"[locname-part]."
"gap"	116253479	otters	Tapering Anger Pit	--	--	"[locname-part]."
"anteroom"	600115563	otters	Anteroom	--	--	"[locname]."
"rote"	390592507	otters	Anteroom	--	callos-here rule	"[locname-part]."
"moan"	209523056	otters	Anteroom	--	callos-here rule	"[locname-part]."
"near"	284225238	otters	Anteroom	--	--	"[locname-part]."
"moot"	315890325	otters	Anteroom	--	--	"[locname-part]."
"preserve"	838970678	otters	perverse preserve	--	--	"[locname]."
"otter"	493702525	otters	--	--	degen-true rule	"[not-the-reg]."
"storet"	589976491	otters	--	--	degen-true rule	"[not-the-reg]."
"pear"	296783689	others	--	spear	--	"[plur-fruit]."
"plum"	304460758	others	--	lumps	--	"[plur-fruit]."
"pager"	329383391	others	--	pagers	--	"[plur-fruit]."
"lime"	290687947	others	--	slime	--	"[plur-fruit]."
"harmonica"	398315407	others	--	harmonicas	--	"The harmonicas seem stuck together, so you probably have to deal with both of them."
"drinksstand"	660968789	others	--	drinks stand	--	"[drink-stand]."
"drinks"	369460390	others	--	drinks stand	--	"[drink-stand]."
"stand"	291508399	others	--	drinks stand	--	"[drink-stand]."
"abandoned"	404826421	others	--	drinks stand	--	"[drink-stand]."
"needle"	527168763	others	--	compass	--	"The needle is working fine. No need to meddle."
"foliage"	362267787	others	--	foliage	--	"Alas, the foliage also blocks your magical powers and not just your explorations, but [if number of flippable things in filed field > 0]there's plenty else to work at[else]no big deal. You took care of everything else[end if] here."
"barriers"	545651053	others	--	b-w	--	"The barriers['] westness is important."
"len"	250527456	others	clearing	--	--	"[len-part]."
"craig"	184109754	others	clearing	--	--	"[len-part]."
"megaton"	473038885	others	--	mopeage rant	--	"[part-of-lots]."
"pear"	296783689	others	--	mopeage rant	--	"[part-of-lots]."
"magenta"	400874126	others	--	mopeage rant	--	"[part-of-lots]."
"rope"	368948448	others	--	mopeage rant	--	"[part-of-lots]."
"rampage"	395646362	others	--	mopeage rant	--	"[part-of-lots]."
"note"	374176212	others	--	mopeage rant	--	"[part-of-lots]."
"mopeage"	510293427	others	--	mopeage rant	--	"[part-of-lots]."
"rant"	259529147	others	--	mopeage rant	--	"[part-of-lots]."
"dam"	87292060	others	--	mad train	--	"[whole-item]."
"train"	304521993	others	--	mad train	--	"[whole-item]."
"eerie"	513734976	others	--	eerie blurbs	--	"[whole-item]."
"blurbs"	377355225	others	--	eerie blurbs	--	"[whole-item]."
"barber"	337479343	others	--	barber sickle	--	"[whole-item]."
"sickle"	394825523	others	--	barber sickle	--	"[whole-item]."
"riot"	307779244	others	--	riot cap	--	"[whole-item]."
"cap"	102659362	others	--	riot cap	--	"[whole-item]."
"buried"	402676559	others	--	b-r	--	"[whole-item]."
"raft"	217136535	others	--	b-r	--	"[whole-item]."
"sorer"	469080258	others	--	sorer bogey	--	"[whole-item]."
"bogey"	375536545	others	--	sorer bogey	--	"[whole-item]."
"pryer"	502278926	others	--	pryer bars	--	"[whole-item]."
"bars"	202204492	others	--	pryer bars	--	"[whole-item]."
"silly"	371253742	others	--	silly shirt	--	"[shirt-sez]."
"shirt"	366982932	others	--	silly shirt	--	"[shirt-sez]."
"sillyshirt"	738236674	others	--	silly shirt	--	"[shirt-sez]."
"rapt"	272087598	others	--	rapt figure	--	"[whole-item]."
"figure"	422343163	others	--	rapt figure	--	"[whole-item]."
"utensil"	600010093	others	--	rapt figure	--	"[rapt-glare]."
"spoon"	395352587	others	--	rapt figure	--	"[rapt-glare]."
"jagged"	265182945	others	--	jagged spoon	--	"[rapt-glare]."
"briar"	236247175	others	--	briar screen	--	"[whole-item]."
"screen"	525123080	others	--	briar screen	--	"[whole-item]."
"peanut"	488583219	others	--	peanut cola	--	"[whole-item]."
"cola"	149359819	others	--	peanut cola	--	"[whole-item]."
"moss"	330975662	others	--	moss cap	--	"[whole-item]."
"cap"	102659362	others	--	moss cap	--	"[whole-item]."
"banana"	162797375	others	--	an-a	--	"You try to poke at an A, but nothing comes from it."
"tekno"	427109390	others	--	tekno-token	--	"Best not to mess with official currency."
"icon"	207258516	others	--	coins	--	"Hmm. You could probably do something with just one coin, or you could do something with all of them."
"drol"	234519308	others	--	dollar	--	"[count-enuf]."
"droll"	288333147	others	--	dollar	--	"[count-enuf]."
"dollar"	290520965	others	--	dollar	--	"[count-enuf]."
"storage"	521653993	others	--	so-great	--	"You might break what is in the storage."
"great"	351027450	others	--	so-great	--	"You might break what is in the storage. Then it would be neither great nor so great."
"passport"	620454066	others	--	passport	--	"The passport is fine as it is, full of practical knowledge to look at it. You wonder if perhaps the [if viewer is reflexed]searcher[else if searcher is reflexed]viewer[else]viewer or searcher[end if] might contain more information."
"among"	242122758	others	--	--	need-mango rule	"Not quite the right way."
"list"	298190669	others	--	l-o-p	--	"[if l-o-p is reflexed]You already messed with the list[else]The list doesn't look odd, but maybe some the prices will make you exclaim something[end if]."
"overpriced"	774270700	others	--	peach	--	"[if peach is reflexed]No need to change now, and that's not the right way[else]That's over-thinking it. It's just a peach[end if]."
"lemon"	388955186	others	--	--	lemmel rule	"You can't focus on just one of them."
"auction"	417662159	others	--	caution	--	"[papay]."
"banner"	371551651	others	--	caution	--	"[papay]."
"trader"	424780640	others	--	Art Erd	--	"Art Erd is tarred real good. That's the point of tarring. But [if storage is in scape]you got what you wanted[else]he might trade that storage box[end if]."
"orange"	391177517	others	--	orange	--	"[if player has orange]You got it, already[else]That doesn't seem sneaky enough to get the orange."
"plant"	309485142	others	--	pugnacious plant	--	"[plant-no]."
"red"	234159001	others	scape space	--	--	"[no-art]."
"rat"	190621639	others	scape space	--	--	"[no-art]."
"pugnacious"	629997575	others	--	pugnacious plant	--	"[plant-no]."
"guava"	249245965	others	--	guava	--	"[cur-fru]."
"videotapes"	786189311	others	--	videotape	--	"[vtc]."
"videotape"	689915345	others	--	videotape	--	"[vtc]."
"video"	375345441	others	--	videotape	--	"[vtc]."
"tape"	314569904	others	--	videotape	--	"[vtc]."
"collection"	639160483	others	--	videotape	--	"[vtc]."
"kumquat"	516923398	others	--	kumquat	--	"[cur-fru]."
"lots"	327550400	others	--	so-great storage	--	"[slot-no]."
"lotslots"	655100800	others	--	so-great storage	--	"[slot-no]."
"review"	601028460	others	--	passport	--	"That's not the way to learn from the viewer--it's probably not that complicated. You hope."
"popstar"	524180100	others	--	passport	--	"You don't know whose passport it was, but it's yours, and you need to study it, not just hope to be a pop star."
"halt"	196393974	others	gates stage	--	--	"[if player has passport]The halt lath is ineffective, now you have the passport[else]The halt lath remains firm. Maybe you actually need some old-fashioned key-in-lock action[end if]."
"singed"	391609220	others	--	singed design	--	"The design is sort of glommed onto the coin[if coins are visible]s[end if]. So you should figure what to do, there."
"research"	581009492	others	--	passport	--	"That's not the way to learn from the searcher--it's probably not that complicated. You hope."
"prep"	376061830	others	--	--	can-i-prep rule	"It hurt to be called a perp. But maybe you can figure a way to think of it right. That wasn't quite it."
"field"	274156779	others	filed field	--	--	"[locname]."
"well"	343368560	others	swell wells	--	--	"[locname]."
"wells"	439642526	others	swell wells	--	--	"[locname]."
"gates"	361977613	others	gates stage	--	--	"[no-gate]."
"gate"	265703647	others	gates stage	--	--	"[no-gate]."
"clearing"	434637210	others	clangier	--	--	"[locname]."
"rustic"	453812025	others	rustic citrus	--	--	"[locname]."
"space"	326739437	others	scape space	--	--	"[locname]."
"arena"	286413056	others	gates stage	--	--	"[stad-chg]."
"near"	284225238	others	gates stage	--	--	"[stad-chg]."
"stadium"	436774697	others	gates stage	--	--	"[stad-chg]."
"admit"	235394924	others	gates stage	--	--	"[stad-chg]."
"other"	427874806	others	--	--	degen-true rule	"[not-the-reg]."
"storeh"	524148772	others	--	--	degen-true rule	"[not-the-reg]."
"peek"	390011355	demo dome	peek keep	--	--	"[dome-rm]."
"evoc"	328329091	demo dome	evoc-cove	--	--	"[dome-rm]."
"hows"	315843615	demo dome	hows show	--	--	"[dome-rm]."
"perl"	348409710	demo dome	hows show	--	--	"[its-a-museum]."
"inform"	364166783	demo dome	hows show	--	--	"[its-a-museum]."
"perlwall"	566159979	demo dome	hows show	--	--	"[its-a-museum]."
"informwall"	581917052	demo dome	hows show	--	--	"[its-a-museum]."
"codewall"	459943629	demo dome	hows show	--	--	"[its-a-museum]."
"codewalls"	556217595	demo dome	hows show	--	--	"[its-a-museum]."
"code"	242193360	demo dome	hows show	--	--	"[its-a-museum]."
"perlcode"	590603070	demo dome	hows show	--	--	"[its-a-museum]."
"informcode"	606360143	demo dome	hows show	--	--	"[its-a-museum]."
"neds"	314016672	demo dome	ned's dens	--	--	"Maybe in another wordplay game, flipping things around like this might work. But not here."
"sparse"	489331621	demo dome	sparse spares	--	--	"[dome-rm]."
"intel"	398630320	demo dome	intel inlet	--	--	"[dome-rm]."
"shall"	243371761	demo dome	peek keep	--	--	"You can't get near the shall halls, although you still have the nonmagical ability to change the future. Well, some day you will."
"great"	351027450	demo dome	peek keep	--	--	"It was tested to make sure even you couldn't magic it open."
"display"	422122769	demo dome	peek keep	--	--	"You won't figure the code. There isn't one. Muahaha."
"spy"	300099177	demo dome	peek keep	--	--	"You won't figure the code. There isn't one. Muahaha."
"dial"	122023592	demo dome	peek keep	--	--	"You won't figure the code. There isn't one. Muahaha."
"boltcase"	494968817	demo dome	sparse spares	--	--	"[its-a-museum]."
"talks"	308318819	demo dome	peek keep	--	--	"[its-a-museum]."
"talk"	212044853	demo dome	peek keep	--	--	"[its-a-museum]."
"spec"	324551619	demo dome	peek keep	--	--	"[its-a-museum]."
"space"	326739437	demo dome	peek keep	--	--	"[its-a-museum]."
"best"	345608998	demo dome	--	best cola	--	"[its-a-museum]."
"cola"	149359819	demo dome	--	best cola	--	"[its-a-museum]."
"trifle"	441561511	demo dome	sparse spares	--	--	"[its-a-museum]."
"dustpan"	478080165	demo dome	sparse spares	--	--	"[its-a-museum]."
"scalpit"	400850031	demo dome	sparse spares	--	--	"[its-a-museum]."
"placer"	369603113	demo dome	sparse spares	--	--	"[its-a-museum]."
"rudest"	538648792	demo dome	sparse spares	--	--	"[its-a-museum]."
"ladder"	311189747	demo dome	sparse spares	--	--	"[its-a-museum]."
"bulk"	230271729	demo dome	sparse spares	--	--	"Bulk-Klub's credibility took a hit once Elvira got on their board of directors, and it may need some fundamental reorganization, but you vowed to use your wits and not your wordplay power for that."
"calendar"	380261569	demo dome	intel inlet	--	--	"[these-docs]."
"thesis"	505739204	demo dome	intel inlet	--	--	"[these-docs]."
"chicloner"	530490151	demo dome	--	chic loner	--	"[no-no]."
"novella"	488046510	demo dome	--	chic loner	--	"[no-no]."
"sign"	242774022	demo dome	peek keep	--	--	"[no-mess]."
"entry"	507506690	demo dome	peek keep	--	--	"[no-mess]."
"unfold"	349723716	demo dome	peek keep	--	--	"[no-mess]."
"memoir"	460625641	demo dome	peek keep	--	--	"[no-mess]."
"demo"	287262928	demo dome	--	--	degen-true rule	"Museums are designed to be impassive and impermeable, for the most part. This is full of exhibits--your questing days are over."
"Elvira"	421289235	--	--	--	degen-true rule	"Changing Elvira is impossible, [if player is in Inclosure]even now you've resisted her first attack[else]and you certainly don't want to summon her[end if]."
"yorpwald"	548467110	--	--	--	degen-true rule	"You can't just unjumble Yorpwald with just one word. You need to deal with individual things."
"settler"	697243862	--	--	settler	--	"[no-set]."
"recoded"	476352361	--	--	settler	--	"[no-set]."
"deviser"	610396742	--	--	settler	--	"[no-set]."
"backside"	382647496	--	--	settler	--	"[no-set]."
"decal"	223842440	--	--	settler	--	"[no-set]."
"button"	473004833	--	--	settler	--	"[no-set]."
"receptors"	800467929	--	--	settler	--	"[no-set]."
"output"	572250186	--	--	settler	--	"[no-set]."
"display"	422122769	--	--	settler	--	"[no-set]."
"equals"	469593156	--	--	settler	--	"[no-set]."
"logo"	235118695	--	--	settler	--	"[no-set]."
"teach"	289391829	--	--	settler	--	"Aw, man, a third option for the settler wouldn't be fair. [if Elmo is off-stage]Trust me, i[else]I[end if]t's powerful enough as-is."
"sign"	242774022	--	--	settler	--	"You don't need to mess around with the sign on the settler, or any sign, except maybe one place[if hops shop is unvisited], which you'll know when you see it[else if gins sign is reflexed], and you already did something[else], where you took the chance[end if]."
"slider"	429239652	--	--	settler	--	"You can just switch the slider if you want to manipulate it."
"purse"	495975644	--	--	super purse	--	"The purse is just fine as it is."
"space"	326739437	--	--	super purse	--	"You don't want to mess with the space-capes. They work.."
"treatise"	690610687	--	--	treatise	--	"The treatise [if settler is off-stage]is[else]was[end if] there as help to discover [if settler is off-stage]what's in the latches[else]the satchel. It has only sentimental value, now[end if]."
"writing"	487861496	--	--	red writing	--	"[red-wri]."
"redwriting"	722020497	--	--	red writing	--	"[red-wri]."
"red"	234159001	--	--	red writing	--	"[red-wri]."
"wall"	217750269	--	--	--	in-innie rule	"[innies]."
"walls"	314024235	--	--	--	in-innie rule	"[innies]."
"terry"	523922985	--	--	--	past-strip rule	"You don't have any special tricks with RETRYing. Just do so if you're in a store and stuck."
"northwest"	804101071	--	--	--	degen-true rule	"[diag-dir-rej]."
"northeast"	698354116	--	--	--	degen-true rule	"[diag-dir-rej]."
"southeast"	745502578	--	--	--	degen-true rule	"[diag-dir-rej]."
"southwest"	851249533	--	--	--	degen-true rule	"[diag-dir-rej]."
"down"	272223947	--	--	--	degen-true rule	"[dir-rej]."
"north"	368976205	--	--	--	degen-true rule	"[dir-rej]."
"south"	416124667	--	--	--	degen-true rule	"[dir-rej]."
"east"	329377911	--	--	--	degen-true rule	"[dir-rej]."
"west"	435124866	--	--	--	degen-true rule	"[dir-rej]."
"pedanto"	478859078	--	--	--	degen-true rule	"You don't need to change the pedanto-notepad, except maybe by filling it up with ideas[if-no-pad]."
"warning"	410853958	--	--	--	degen-true rule	"You can't change warnings. Warnings are there to protect you. Even offer hints if you read them."
"gadget"	319332438	--	--	--	degen-true rule	"[so-last]."
"xyyzz"	603425821	--	--	--	degen-true rule	"[xyzzys]"
"plugh"	310267606	--	--	--	degen-true rule	"[xyzzys]"
"plover"	529927107	--	--	--	degen-true rule	"[xyzzys]"
"iths"	281659129	--	--	--	degen-true rule	"[major-swear]!"
"kcuf"	203559466	--	--	--	degen-true rule	"[major-swear]!"
"mand"	156199568	--	--	--	degen-true rule	"[major-swear]!"
"lelh"	272716086	--	--	--	degen-true rule	"[major-swear]!"
"parc"	187983165	--	--	--	degen-true rule	"[major-swear]!"
"heck"	237027171	--	--	--	degen-true rule	"[major-swear]!"
"curses"	529789236	--	--	--	degen-true rule	"[mild-swear]!"
"bother"	446293711	--	--	--	degen-true rule	"[mild-swear]!"
"bastard"	328531417	--	--	--	degen-true rule	"[mild-swear]!"
"ground"	387318486	--	--	--	degen-true rule	"Changing the ground beneath your feet is too dangerous a proposition."
"jump"	299607444	--	--	--	degen-true rule	"You consider the costs and benefits of collapsing in an impressively uncoordinated heap, then decide against doing so."
"point"	372828908	--	--	--	know-point rule	"There's no secret cheat between NO TIP and OPT IN."
"think"	307225849	--	--	--	degen-true rule	"Whenever you just try to too hard to think, things always get jumbled."
"score"	402762040	--	--	--	degen-true rule	"There's no way to scramble your score. And scoring another point won't help you solve things, anyway."
"poss"	348366468	--	--	--	degen-true rule	"You can't jumble the possible scores any other way."
"listen"	494904286	--	--	--	degen-true rule	"Trying to change how you listen gives no intels."
"about"	303175125	--	--	--	degen-true rule	"The 'about' [dir-cut]."
"credits"	497541416	--	--	--	degen-true rule	"The 'credits' [dir-cut]."
"history"	563694761	--	--	--	degen-true rule	"The 'history' [dir-cut]."
"hush"	275944371	--	--	--	degen-true rule	"[meta-rej]."
"spaceon"	469999522	--	--	--	degen-true rule	"[meta-rej]."
"son"	239534051	--	--	--	degen-true rule	"[meta-rej]."
"hint"	254292671	--	--	--	degen-true rule	"[meta-rej]."
"hints"	350566637	--	--	--	degen-true rule	"[meta-rej]."
"access"	360553029	--	--	--	degen-true rule	"[meta-rej]."
"exit"	388677054	--	--	--	degen-true rule	"[meta-rej]."
"exits"	484951020	--	--	--	degen-true rule	"[meta-rej]."

[the rules/texts below are organized in the order I thought up the nudges above, which is to say, more or less random. But nothing there is game-critical enough that it needs to be sorted. I hope.]

[ton]

to say fresc:
	say "Some art is just out there to troll people. The forces fresco is such. Even if you could vandalize it, Elvira might be on you in a second"

to say caps-no:
	say "It'd sort of stink if a caps lock button broke in real life, so, no"

to say die-sin:
	say "[if circle is visited]The words themselves do nothing. You found the way in[else]Nothing happens. You twiddle both words for a moment, then realize it's probably them, combined[end if]"

to say pit-full:
	say "[if mushrooms are off-stage]The whole seed pit[else]You already got the mushrooms[end if]."

this is the can-i-prep rule:
	if perp-clued is true:
		the rule succeeds;
	the rule fails;

to say i-com:
	say "The intercom crackles a bit, but you hear a louder buzz from the dialer. Maybe work on that instead"

to say no-fril:
	say "The saver is hopelessly no-frills. It'll never be anything better. But [if saver is reflexed]you made it look a bit nicer[else if saver is attempted]you might've been onto something looking at its brand name[else]maybe you could revisit its brand name to make it look nicer[end if]. Not that looks matter"

to say cop-sco:
	say "The copse and the scope are both fine as-is[if yurts are visible], though maybe you can do something about the yurts[end if]"

to say meta-rej:
	say "Meta-commands don't have any easter eggs, sadly"

to say dir-cut:
	say "There's no special addition to the 'about' section[if mrlp is demo dome], but you're at the director's cut bit right now[end if]"

to say whiney:
	say "You can't change who whiners are, but maybe you can make them whine [if ram3 is in lalaland or ram2 is in lalaland or ram1 is in lalaland]even [end if]less...whiningly"

to say no-ropin:
	say "[if duck is returned]No need to mess with the ropins any more[else]The prison ropins are too sturdy. You'll have to focus on a part that might open[end if]";

to say rev-sum:
	say "That document is the stone truth! It doesn't need revisionism or embellishment"

to say no-art:
	say "You don't need to do anything to Art, especially since [if storage box is in scape space]you want to get that storage box[else]you got that storage box[end if]"

to say out-rou:
	say "Changing the direction or the composition of the trail won't do anything"

to say gosh-camp:
	say "Gosh! The campsite's about as swell as can be, as is. No need to rearrange anything"

to say boor-grub:
	say "You can't change a whole suburb. Better to change yourself"

to say no-cray:
	say "No way. You're not changing the crays--and if you changed one, the others would get you. You need a way out";

to say caffeine-no:
	say "The name brand is not important. Besides, your body will break down the caffeine on its own, when needed"

to say ash-soot:
	say "It's one solid ashtray. You try aha's to do something, but you wind up all, yah, rats[if soot is in adobe]. Maybe it's the pipe soot you want[else]. Well, you got pipe soot from it, and that's enough[end if]"

to say grail-name:
	say "His full name, Liam Garn"

to say fun-leaves:
	say "Yes, it's fun to mess with leaves, but distracting"

this is the lemmel rule:
	if player is in clearing:
		if lemons are in clearing or melons are in clearing:
			the rule succeeds;
	the rule fails;

to say slot-no:
	if lost slot is off-stage:
		say "Nothing close to anagramming LOST is on the box right now. You may need to use something entirely different to get the slot to appear";
	else:
		say "After all that work getting it to appear, you don't want to make the lost slot vanish"

to say no-gate:
	say "The gate needs to be unlocked some other way"

this is the imp-here rule:
	if player is in Tapering Anger Pit and imp is in Tapering Anger Pit:
		the rule succeeds;
	the rule fails;

to say not-at-barley:
	say "You're not near enough to the barley to affect it. You need to ENTER through the otters"

to say barley-check:
	if the player's command includes "barley":
		if b-b is not prefigured:
			say "Still, that seems right, if you get there.";
			preef b-b;
			continue the action;

to say sculpt:
	say "That sculpture is pretty firm and stuck as-is. Better to go off and do something cooler than Shoer Osher ever got credit for"

to say pier-sign:
	say "That may not help you through the mist. Maybe read the sign instead"

to say no-logan:
	say "The cracks themselves give no clues as to No-Gal Logan's whereabouts";

to say dark-palm:
	say "[one of]You punch your fist as you realize DARK has no anagrams...right into the palm[or]Oh no, not again. Concentrate on the palm[stopping]"

this is the dark-study rule:
	if player is in study and study is dark:
		the rule succeeds;
	the rule fails.

to say dark-been:
	say "The darkness has always been there and always will be. You need to find a way to say it was dark"

this is the callos-here rule:
	if player is in anteroom:
		if whiners are in anteroom:
			the rule succeeds;
	the rule fails;

to say w-twi:
	say "The ads have probably gone through enough word-twisting"

to say war-one:
	say "[if number of visible warriors is 1]There's only one warrior left, and his name is Rodney[else if number of warriors in lalaland > 0]You've already dealt with one individual warrior--it can't be bad to tackle the others one at a time[else]One at a time. Each has his own weakness[end if]";

to say giz-tex:
	say "It's so technically detailed, you worry you might break it by thinking at it wrong. So you don't. A more science-ly type might be able to deal with it better"

to say hfre:
	say "You're probably overthinking it. The I-USED-TO examples are just plain tedious."

this is the know-point rule:
	if cur-score of manor > 1:
		the rule succeeds;
	the rule fails;

to say major-swear:
	say "[if mrlp is presto and cur-score of presto > 0]Curiously enough, you can't do anything with the major swears, and neither could I[else][cussy][end if]";

to say mild-swear:
	say "[if mrlp is presto and cur-score of presto > 0]This region has some lame swears, but that's not one of them[else][cussy][end if]";

to say flow-fine:
	say "The flowerpot is just fine--[if crocus is reflexed]and so is the crocus in it[else if crocus is not in flowerpot]it's the crocus that needs help[else if limits are unvisited]you haven't found anything to put in it yet[else]it needs something in it, though[end if]"

to say count-enuf:
	say "It's counterfeit enough as-is. You probably need to just find someone who'd actually accept it"

to say algo-no:
	say "It's more likely that that book would spin YOU around a good deal"

to say vtc:
	say "No, it's not just any videotape collection. It's those awful titles"

to say bab-v:
	say "Babbling's babbling, but what stinks is, it's just so VERBOSE. Well, it doesn't stink that VERBOSE has fewer anagrams than babbling(s), settler or no, so that's something";

this is the first-two rule:
	if player is in same mesa:
		the rule succeeds;
	if brother horbert is visible:
		the rule succeeds;
	the rule fails;

to say no-poi:
	say "The [if player is in mesa]poison stripe[else]oopsin['] priest[end if] can't be changed that easily. You'll have to search around for better ways to poke at things."

to say shoaly:
	say "That might cause some bizarre erosion and risk dumping YOU in Leak Lake"

to say all-fish:
	say "You need to deal with all the bullies at once, somehow, not just one at a time"

to say p-hole:
	say "City Hall can't fix potholes, and neither can you. You feel a bit of lost hope as you try. You need to look out for, and look within, yourself, here"

to say ca-co:
	say "The camo-coma remains as-is. It's sturdy, military-grade stuff"

to say elv-mach:
	say "You have enough to think about without one more of Elvira's machines"

to say patron:
	say "They would resist change. Not that they wouldn't mind a bit of drinking tales for next time. Maybe you could provide that"

to say shackbut:
	say "There are buttons all over the shack, but they should remain that way. You may have to figure or change their functions, though"

to say wait-see:
	say "The wait-seer shrugs patiently, unfazed you did not understand his full being. It is probably your inconvenience and not his";

to say the-books:
	say "The books could use some changing. But you're better off making Yorpwald itself safe for art, good or bad, first"

to say one-toy:
	say "Disable one of Elvira's toys, and there's still the other. Oh, and the army, too. You need your own army"

to say towers-made:
	say "What the towers are made of is not important. Just that they're big, and there's a quest behind them"

to say plutry of (pg - a guardian):
	now pg is plurtry;

to say odd-rob:
	say "You think a bit, but Daltho's advice comes back--oddly rewired robot--only rewired is tough enough"

to say nerd-a:
	say "You think a bit. The salesmen don't emphasize one word over the other during their sales pitches, so the NERD and AID of Nerd-Aid seem equally ludicrous. I mean important"

to say ego-dr:
	say "Until you see the ego-drains themselves as organised, you probably won't see how to get past them"

to say g-pin:
	say "It's more that it's a giant pin and not, like, a safety pin";

to say cone-rec:
	say "You think about the econ-cone being the recent center, but theorizing doesn't work. You need to look forward in other ways, to think of more concrete things, like [if prai is reflexed and rivets are reflexed]how to go west[else if prai is reflexive and rivets are reflexive]how to be inspired by that statue[else]going west or, maybe, that statue again[end if]"

to say w-change:
	say "You can't change the alcoves. It's what's to the west that needs changing"

to say engs:
	say "Nothing happens. You probably need to worry about the stores and/or what they become, instead"

this is the hydra-know rule:
	if the player is in Inclosure:
		the rule succeeds;
	if the player is in alcoves and hydra-known is true:
		the rule succeeds;
	the rule fails.

to say no-lam:
	say "You can't change them, and even if you could, Elvira would probably be alerted"

to say vs-oped:
	say "You try and twist Elvira's words or poke holes where they're wrong...and you can't. Sheesh"

to say preef-page:
	preef Pa Egg Pea;

to say chanty:
	say "The chant doesn't change. Chants are good at that"

to say its-msg:
	say "You may have more luck with the necklace's message. Not that it's very clever, it just--fits in more with the papery yapper"

to say cube-whole:
	say "The sea cube is unmoved. You may need to concentrate on the whole thing";

to say rapt-glare:
	say "The rapt figure almost seems to glare at you--or maybe its smile seems a little fake. You'll have to change IT before the spoon"

to say 1st-name:
	say "You're not sure you want to be on a first-name basis with Art Erd. Okay, you're sure you don't want to be";

to say prob-ov:
	say "You are probably over-thinking it. There's a more direct way to tackle the rude door"

to say is-boing:
	say "[if boing is reflexive]The number's got more numerals than letters[else]You got the boing mechanism working[end if]";

to say del-ry:
	say "The sandwich isn't just deli, or rye, or a sandwich. It's deli rye"

to say plur-fruit:
	say "Well, you don't technically need plurals for this"

to say cola-is-cola:
	say "It's cola, not soda or pop. And you can just drink it"

to say romstix:
	say "You'll know what to do with the sticks when you're ready to program";

to say trimsox:
	say "They're not just socks, or trim. They're trim socks."

to say papwall:
	say "The paperwall is unmoved. Maybe the stuff [if plaster is in lalaland and plates are in lalaland]that came from it[else if plaster is in Basement and plates are in Basement]in the wall[else]in and out of the wall[end if]  could help you more, here";

to say dirk-no:
	say "The kid looks at you curiously. You probably don't need to change his name or his intelligence";

to say dir-rej:
	say "This game usually doesn't require you to mess with cardinal directions";

to say diag-dir-rej:
	say "This game doesn't require you to mess with diagonal directions[if player is in waters], so maybe you should consider the other shores[else], so I hope that's a relief[end if]";

this is the is-unbent rule:
	if player is in Basement and Basement-been is false:
		the rule succeeds;
	the rule fails;

this is the is-bent rule:
	if player is in Basement and Basement-been is true:
		the rule succeeds;
	the rule fails;

to say stad-chg:
	if near arena is not examined:
		now near arena is examined;
		say "As you concentrate, you realize it's not just any arena, but the Admit-Us Stadium! ";
	say "Changing the stadium with (presumably) people in it would cause great harm. Maybe you should try to sneak in, instead";

to say cur-fru:
	say "Curtis is the one who messes with the fruits, not you";

to say fol-reag:
	say "[if player is in circle][follow-the-list][else]Brother Horbert will do [i]his[r] magic on the reagents at the right time";

this is the has-reag rule:
	if player is in cleric circle:
		the rule succeeds;
	if number of visible quest-items > 0:
		the rule succeeds;
	the rule fails;

to say so-last:
	say "That was soooo last game! Not that Shuffling Around was lame. I mean, I wrote it, and all. Just, I got even better at writing since then, and I wrote in newer awesomer adventures";

to say bland-sad:
	say "[if trefoil is not visited and waters are not visited]The badlands can't be changed on their own. They must be trekked through[else]You're beyond the badlands now[end if]"

this is the pas-vis rule:
	if number of visible hintpastries > 0:
		the rule succeeds;
	the rule fails;

to say prevrev:
	say "Scrambling the guy who left the mess won't work. You need to work with what is here, in the routes, now"

to say scrapap:
	say "It's what's on the scratch paper that [if scratch is reflexed]was[else]is[end if] important."

to say kboard-det:
	if the player's command matches "keyboard" or the player's command matches "key board":
		if keyboard is not prefigured:
			say "[line break]";
			preef-nol keyboard;
			continue the action;
		if keyboard is not off-stage:
			say "Besides, you already made a perfectly good keyboard.[no line break]";
		else:
			say "You need to find something less awful that could make a keyboard. That book would probably arrange the letters worse than QWERTY.[no line break]";

this is the bookvis rule:
	if number of visible badbooks > 0:
		the rule succeeds;
	the rule fails;

this is the past-strip rule:
	if strip of profits is visited:
		the rule succeeds;
	the rule fails;

to say name-worry:
	say "Perhaps it's better to focus on the names instead. Easier, too";

to say just-tea:
	say "Best to think of it as just tea";

to say imp-sly:
	say "The imp's too sly to get tricked by a word THAT short"

to say not-singular-hp:
	say "Neither the singular nor the plural version of a pastry can change it. They're for helping you with other things, anyway";

understand "pairer" as a mistake ("[if gizmo is off-stage]You don't need duplicates of anything here. Besides, the machine looks complex enough. It will probably reject or accept what it needs to[else]You don't need to repurpose the repair machine. It's done enough for you[end if].")

to say rapier-mach:
	say "The machine is complicated enough. You [if gizmo is off-stage]probably just need to figure what to put in it[else]already got something from it[end if]"

this is the duck-cant rule:
	if player is not in subsector and location of duck is location of player:
		the rule succeeds;
	the rule fails;

this is the bonker-gone rule:
	if player is in Danger Garden and bonker is in lalaland:
		the rule succeeds;
	the rule fails;

to say hisin:
	say "The high sign is a clue. Bad idea to change it"

to say not-stripe:
	say "The poison stripe is too incorporeal to do bend to your will"

to say follow-the-list:
	say "Maybe you can use your powers to get what's on the list, but you don't need to use them on it";

this is the am-along rule:
	if told-of-logan:
		the rule succeeds;
	the rule fails;

to say shirt-sez:
	say "Hm. There are a lot of silly shirts out there. Maybe the message is what you need to tackle"

to say part-of-lots:
	say "No, the [i]whole[r] thing. You see several...similar...items here right now"

to say whole-item:
	say "Nothing happens. Perhaps it's the whole item that's important"

to say focus-castle:
	say "Nah, that's just garbage. It's the curst palace you need to focus on"

this is the cppc rule:
	if player is in limits:
		if cactus pearl is in limits or pearl cactus is in limits:
			the rule succeeds;
	the rule fails.

to say len-part:
	say "Len Craig doesn't change, and even if you messed with his full name, he wouldn't"

to say ray-part:
	say "You can't do much with either part of Ray's name. Plus he has that keycar"

this is the gunter-onstage rule:
	if player is in study and gunter is off-stage:
		the rule succeeds;
	the rule fails;

this is the Gunter-left rule:
	if player is in study and Gunter is in lalaland:
		the rule succeeds;
	the rule fails.

to say drink-stand:
	say "Nothing happens. [if stand is examined]You found enough inside it, anyway[else]Maybe just examine it[end if]"

to say innies:
	say "You don't need to, and can't, do anything drastic to the walls when inside. That'd be kind of dangerous, anyway"

this is the in-innie rule:
	if location of player is innie:
		the rule succeeds;
	the rule fails;

to say both-medals:
	say "No, it's a combination of what's on both medals."

this is the is-hauntable rule:
	if player is in anger range and haunter is off-stage:
		the rule succeeds;
	if haunter is visible:
		the rule succeeds;
	the rule fails;

to say no-spoil:
	say "[if cur-score of troves is 0]You've got the right idea...sort of...but you're not worthy of big thoughts, yet[else]You can change Spoiloplis by thinking, but not like that. One idea at a time[end if]"

to say no-set:
	say "You won't gain anything trying to magic the settler, or parts of it, about. It's got all the technical tools you need, though";

to say cant-giant:
	say "The giant is too old and set in his ways. You may just need to listen to him from several different angles"

to say Inclosure-scen:
	say "You can't just muck around with one part of Elvira's army. You need a way to find allies"

to say list-stable:
	say "The checklist was built to be especially stable and singular of purpose. So, nothing happens"

to say eat-pastry:
	say "The pastry is for eating, not for changing[if toaster is not visible]. It might be more edible if you heated it up, though[end if]"

this is the strood rule:
	if player has strudel and strudel is reflexed:
		the rule succeeds;
	the rule fails;

to say reed-ale:
	say "Not just Reed's, or Ale. Reed's Ale"

to say ian-un:
	say "Ian is unchangeable, but maybe he is moveable.";

to say plant-no:
	say "You may want to listen to what the plant has to say, or what it makes you say";

to say river-no:
	say "That would cause serious injury to people and property, even if it could work";

to say mb-sign:
	say "The sign wobbles slightly, though there isn't really any wind. Perhaps you could be more straightforward and PUSH it[if circle is visited], though you've already been in the circle[end if]"

to say just-smoke:
	say "It's just smoke. You can't control it. Heck, governments more powerful than you can't control it, and they've been trying. But you can maybe enter it"

to say lec-un:
	say "The lecturer is unchangeable in his views, but maybe he is physically moveable"

to say no-mess:
	say "No need to mess with the helpful sign";

to say no-scen:
	say "Here in the Brunt, you don't need to mess with the scenery. Especially since it looks nicer than that dumpster";

this is the in-mazeroom rule:
	if location of player is mazeroom:
		the rule succeeds;
	the rule fails;

this is the Leo-sad rule:
	if Leo is washed up and player is in dirge ridge and Leo is in dirge ridge:
		the rule succeeds;
	the rule fails;

to say these-docs:
	say "These are documents of historical records! Revisionism is so Elvira";

to say red-wri:
	say "Red writing is a just clue of what to change";

to say dome-rm:
	say "You don't need to flip anything here, really. Certainly not a room."

to say its-a-museum:
	say "This is a museum! No messing with the exhibits, please. Or trying to";

to say no-no:
	say "You can't change the book's writing. Well, you could, I guess. But this is a museum!"

to say xyzzys:
	say "A hollow voice booms, 'Lo! Of...'[no line break]"

to say cussy:
	say "You're not fooling ME. Shame on you"

to say just-letter:
	say "It's just one letter in the maze. You may want to focus on the whole volt maze."

to say no-txtbk:
	say "The catechism would be more likely to scramble YOU up. [if usb is visible]It's way more complex than what you need to do now[else]It'll be there when you need to gloss over it[end if]";

to say no-dsk:
	say "That computer probably holds important information--you just need to extract it right, by trying other things";

to say horb-magic of (tt - a thing):
	say "[if list o toils is examined]Brother Horbert will work his magic with that[else if player does not have tt]Nothing happens. I mean, less than nothing. Perhaps you need to find a way to sneak around to get that[else]That seems curiously inert to your attempts[end if]";

to say not-the-reg:
	say "Trying to change the current region you're in would be risky, or useless, or maybe both";

to say locname:
	say "You don't need to riff on any location names to win the game[if splained is false and oyster is needed], though you may get a last lousy point from doing so if you're observant[end if]"

to say locname-part:
	say "You should never need to riff on part of a location name[if splained is false and oyster is needed], though you may get a last lousy point from doing so if you're observant[end if][one of], so that's one less thing to worry about, I hope[or][stopping]"

to say towersloc:
	say "It's not this location you need to change, but Castle Apcur, the Curst Palace [if player is in mislit limits]right by you[else if player is in trefoil or player is in solo den]nearby[else]across Leak Lake[end if]"

to say mack-clue of (nu - a number):
	if there is a mackhash of nu in table of nasty guys:
		choose row with mackhash of nu in table of nasty guys;
		say "You look for a way to redirect the conversation, even after it changes subject. But--hmm, [if still-doable entry is false]you already did something like that[else]not quite like that[end if]";
	else:
		say "[bug-report][line break]DETAILS: You are on the right track, but I forgot to fill something in a table. Sorry about that--I'll want to fix it in a future release";

to say papay:
	say "[if auction caution is reflexive]You're probably over-thinking it--just pay attention to what it says, instead[else]You've taken the banner's advice well enough[end if]";

to say slab-score:
	if slab-pts < 10: [prevent rollover]
		increment slab-pts;
	say "[if slab-pts > 5]+++ (tired yet?)[run paragraph on][else][slab-pts][end if]";

slab-pts is a number that varies.

this is the in-median rule:
	if player is in fro and Gretta is in fro:
		the rule succeeds;
	the rule fails;

this is the in-domain rule:
	if player is in fro and Gretta is not in fro:
		the rule succeeds;
	the rule fails;

this is the eelmr rule:
	if player is in alcoves and Elmer is in alcoves:
		the rule succeeds;
	if player is in bran barn and m-l is in bran barn:
		the rule succeeds;
	if player is in loop pool:
		the rule succeeds;
	the rule fails;

to say eelmry:
	if player is in bran barn:
		say "[if p-2 is reflexed]You managed to help Mr. Lee enough[else if eels are reflexed]It would be better to show Mr. Lee, but you don't need to, since you talked with Le Mer[else]You just need to show Mr. Lee, not change him[end if]";
		continue the action;
	if player is in loop pool:
		say "[if eels are reflexed]You managed to help Le Mer enough[else if p-2 is reflexed]It would be better to show Le Mer, but you don't need to, since you talked with Mr. Lee[else]You just need to show Le Mer, not change it[end if]";
		continue the action;
	if player is in alcoves and Merle is in alcoves:
		say "You can't change Merle and Elmer, but maybe you could find a way to get rid of them";
		continue the action;
	if bran barn is unvisited and loop pool is unvisited and alcoves is unvisited:
		say "You shouldn't know about Merle, Elmer et al yet";
	else:
		say "You think back to whom you've met so far once past the frontage"

this is the wise-to-sleep rule:
	if player is in hacks' shack:
		if scratch paper is visible and scratch paper is reflexive:
			if slept is false:
				the rule succeeds;
	the rule fails;

this is the in-med rule:
	if player is in fro:
		the rule succeeds;
	the rule fails;

this is the plains rule:
	if player is in plains:
		the rule succeeds;
	the rule fails;

this is the h-assuaged rule:
	if haunter is reflexed and haunter is in location of player:
		the rule succeeds;
	the rule fails.

this is the need-mango rule:
	if player is in clearing and mango is off-stage:
		the rule succeeds;
	the rule fails.

this is the kid-not-learnt rule:
	if smart kid is visible and doc-y is visible and smart kid is not reflexed:
		the rule succeeds;
	the rule fails.

this is the is-study-dark rule:
	if player is in study:
		say "In study.";
	if study is not lit:
		say "Study not lit.";
	if player is in study and study is not lit:
		the rule succeeds;
	the rule fails;

this is the crates-menace rule:
	if player is in Lapsin' plains and reacted is false:
		the rule succeeds;
	the rule fails;

this is the basement-visible rule:
	if player is in dusty study and t-b is not in dusty study:
		the rule succeeds;
	the rule fails;

this is the stable-visible rule:
	if player is in dusty study and tables are not in dusty study:
		the rule succeeds;
	the rule fails;

this is the chimney-visible rule:
	if player is in dusty study and niche is not in dusty study:
		the rule succeeds;
	the rule fails;

this is the my-cola rule:
	if fizzy cola is visible or dirty cola is visible:
		the rule succeeds;
	the rule fails;

this is the time-to-reboot rule:
	if player is in hacks' shack:
		if keyboard is on labs slab and computer screen is on labs slab:
			if caps lock is part of the keyboard:
				if disk is in hard drive:
					if rebooted is false:
						the rule fails;
	the rule succeeds.

this is the time-to-compile rule:
	if scratch paper is reflexive and rebooted is true:
		the rule succeeds;
	the rule fails.

this is the time-to-debug rule:
	if scratch paper is reflexed:
		the rule succeeds;
	the rule fails.

this is the lamb-blam rule:
	if lamb is visible and current action is not eating crust:
		the rule succeeds;
	the rule fails.

this is the volt-maze-visible rule:
	if ether is off-stage and player is in Grey Gyre:
		the rule succeeds;
	the rule fails.

this is the enemy-lines rule:
	if ether is in lalaland and player is in Grey Gyre and Leo is in Grey Gyre:
		the rule succeeds;
	the rule fails;

this is the washup rule:
	if player is in dirge ridge:
		if Leo is not washed up or Rand is not washed up:
			the rule fails;
	the rule succeeds;

this is the Leo-mad rule:
	if player is in dirge ridge:
		if Leo is fightin:
			the rule succeeds;
	the rule fails;

this is the Rand-mad rule:
	if Rand is fightin:
		the rule succeeds;
	the rule fails;

this is the gun-broken rule:
	if boing mechanism is reflexed:
		the rule fails;
	if marines seminar is unvisited:
		the rule fails;
	if player does not have popgun:
		the rule fails;
	the rule succeeds;

this is the troves-hate rule:
	if cold is visible:
		the rule succeeds;
	the rule fails.

this is the degen-true rule:
	the rule succeeds.

this is the degen-false rule:
	the rule fails.

to recover-items:
	let JJ be the map region of the location of the player;
	d "ITEMS: [item-list of JJ]";
	repeat with JJJ running through item-list of JJ:
		if JJJ is not scenery and JJ is not a backdrop:
			now player has JJJ;
			if JJJ is star:
				now player wears star;
			if JJJ is medals:
				now player wears medals;

section crust parsing

check eating curst crust:
	if swears < 1:
		say "[bug-report]" instead;
	if mrlp is stores:
		say "You should probably eat it when you're beyond the, er, spot." instead;
	if mrlp is not presto:
		say "The crust fell from the remains of store P. Perhaps it's best to eat it there." instead;
	say "You wince and prepare to take a bite...";
	now spoilit is true;
	try presto-hinting;
	now spoilit is false instead;

track-crust is a truth state that varies.

every turn when player has curst crust and mrlp is presto and track-crust is true:
	increment swears;
	try eating curst crust;

chapter say "[reject]" and lalaland

lalaland is a privately-named room. "[bug-report]"

lll is an unsolved region. lalaland is in lll.

last-solved-region is a region that varies. last-solved-region is usually lll.

headaches is a number that varies. headaches is 10.

to match-process (it1 - indexed text) and (it2 - indexed text):
	let it1a be filtered name of it1;
	let it2a be filtered name of it2;
	let lost-one be 0;
	say "Your settler begins to make noises: ";
	repeat with myc running from 1 to number of characters in it1a:
		if "[character number myc in it1a]" exactly matches the text "[character number myc in it2a]":
			say " HIGH";
			increment lost-one;
		else:
			say " LOW";
	if lost-one > 0:
		say "Ugh. [if lost-one > 0]Those high notes[else]That high note[end if] gave you caused a migraine mini-rage. You switch off the slider.";
		now slider is switched off;
		decrement headaches;
		now undo-code is 5;
		prevent undo;
	if headaches is 0:
		say "[line break]You're sick of those notes.";

to say dior-hint:
	say "That's not quite it. You can probably look at the diorama to see what to do"

to say l-r-bye-hint:
	say "It's kind of tough to say goodbye, firmly but kindly, and--that isn't quite it. You feel a bit jumbled"

to say di-cli:
	say "The dialer seems to click slightly"

docile-tried is a truth state that varies.

to say doc-try:
	now docile-tried is true;
	say "[one of][or], again[stopping]";

table of spechelp [tsh] [this is for specific error messages for specific items]
xtrhelp	helptxt
t-b	"The ten beams creak slightly. Maybe not all of them. But a few." [START manor]
palm	"[if dusty study is lit]The palm remains upright but seems slightly brighter[else]The darkness recedes for a second[end if]."
niche	"Hm, no, the niche--my niche--won't unfold that way."
latches	"You think you feel static through the latches. But they remain the same."
tables	"The tables seem to shift a bit."
giant pin	"The pin wobbles."
pavement	"[dior-hint]."
event map	"[dior-hint]."
crabgrass	"[dior-hint]."
brass crag	"[dior-hint]."
platform	"[dior-hint]."
farm plot	"[dior-hint]."
pedestal	"[dior-hint]."
steel pad	"[dior-hint]."
sitar	"You hear a sad-sax noise from the sitar. Well, a sitar version. 'Rats, I...' you think, seeing red."
stria	"'Rats, I...' you think as you see red. That's not quite it."
plates	"The plates shine slightly and rattle."
plaster	"The plaster crackles and shines slightly."
pram	"The pram creaks back and forth slightly."
rifle	"Elmo bobbles the rifle slightly, and you think he may've nodded encouragement at you."
Store B	"The smell from Store B becomes fruitier and more delicious." [START stores]
Store H	"Store H looks totally different from all the other stores for a second."
Store K	"An odd sweet smell from Store K, for a second."
Store N	"'Dude, you like must be close!' you hear from Store N."
Store P	"You hear old forgotten magic words which seem like they might almost apply if they were in the right order."
Store T	"You hear various unrecognizable animal noises."
Store U	"Store U seems to light up with lines and curves for a second, but no, that's not quite right..."
Store V	"A single paper currency flutters off from Store V, lost forever."
Store W	"Store W seems to push up from the ground and go narrower for a second."
Store Y	"You hear grinding, then a slimy gulp, from store Y. But nothing definitive."
lecturer	"The lecturer coughs and shakes his head, looking for someone who almost disrupted his speech. He doesn't close to finger you."
the-b	"The bean rolls back and forth a bit." [START routes]
worst ad	"The ad seems slightly nearer, for a moment."
bench	"You hang around the bench, hoping for something to happen, but nothing happens. Though it seems like it should."
bench-end	"Oof! You fail to jump on the bench end. Try mixing things up from what you just did."
giant's elbow	"[if bench-end is reflexive]You're nowhere close to the giant's elbow[else]You seem like you should be able to avoid the elbow, but maybe mix things up a bit[end if]."
huge thing form	"The huge thing form rocks in the air, as if it's about to fall."
pipe soot	"The soot smells a bit stronger than before for a moment."
seed pit	"The seed pit seems to bubble slightly."
Nuder	"The pages of Rude [']N Nuder flutter a bit."
un-road	"The un-road seems to lead somewhere, but you couldn't quite make it out like that."
darkness	"You feel it's ALMOST the right time for the darkness to lift."
narrow cracks	"The cracks almost seem to lead somewhere."
mist	"Hmm, you almost see a way through the mist."
ship controls	"The ship controls seem to adjust themselves slightly."
Thor	"Thor seems to gesture you by for a second."
new beet	"The new beet seems to spin slightly away from Thor for a second."
Pa Egg Pea	"You stare blankly at [i]Pa, Egg, Pea[r], but you're not quite doing it right." [START troves]
cold	"You think you feel less cold for a second. But you need to make it last."
heat	"Meh. Maybe you're closer than you think to motivation. How to make that matter?"
babblings	"The babbling remain verbose--mixing up subjects and making you consider things you hadn't before."
stop post	"You feel silly a bit. You can't let a simple stop post stop you!"
ltb	"You reflect that to LEAD, you must also put certain things in order. You know there are only so many ways."
bee's head	"The bee shakes its head, trying to make sense of the slightly disordered magic it felt from you."
what-a-bee	"The bee's buzzing goes off-kilter for a bit. You gain a bit of faith you're on the right track."
cellar door	"It's...hmm...you remember all the clues, but what order to place them in, now."
diapers	"Staring again at the diapers, you are depressed you couldn't even get being depressed right."
rivets	"Staring at the rivets, you get the feeling you've not quite found the right way to try. Or want."
large regal lager	"No...that is not quite the way to fight the temptation of the wicked brew."
brochure	"Your longing increases...but not enough."
prai	"That's not quite the way to look forward to praise. But it may be a start."
skyscraper	"The skyscraper almost seems to laugh at you, for being close, yet far."
noise	"The noise seems almost bearable."
tan ivy vanity	"You try to not pay attention to the babble behind the door, but you're trying too hard, and you fail. Still, you're on the right track."
lobster	"That's not quite the way to deserve that lobster[if ivy vanity is reflexive]. You can't quite concentrate, anyway, with the knock at the door[end if]."
stream	"That's not quite the way to focus on the stream[if ivy vanity is reflexive]. You can't quite concentrate, anyway, with the knock at the door[end if]."
DIVORCES	"DIVORCES suddenly seems more alluring and more rubbish at once."
shaker	"You don't quite draw inspiration from the shaker, but there can't be that many alts."
Eddie's Song	"You try to groove to Eddie's song, but that's not quite it."
playbill	"You try to imagine what the singer's songs are like, but that's not quite it."
lamb	"The lamb looks confused. Maybe you could be more forceful. Verbally, not physically." [START presto]
hump	"The hump suddenly looks a bit smaller. But not enough."
volt maze	"The volt maze crackles with increased energy, almost ready to break down."
dart	"The dart seems a bit closer, but...dang! Not quite."
decorative star	"The star seems to wiggle a bit, but not enough to pull it out."
plebe	"The plebe looks confused, as if you garbled what you said."
Leo	"There aren't that many things to do with Leo. So few, you could probably brute-force how to get by his, uh, brute force."
Rand	"There aren't that many things to do with Rand. So few, you could probably brute-force how to get by his, uh, brute force."
ether	"[if ether is prefigured]No, you definitely need to say THERE. You just need to have backup and maybe weapons[else]The ether pulses, but you still can't see through it[end if]."
ye hoop	"The hoop dips a bit as if to taunt you."
boing	"You try something that doesn't [i]quite[r] work, but you assure yourself it'll put you a bit closer to an a-ha moment."
maze walls	"The maze walls rumble a bit."
onyx censer	"That feels right, but it's not enough yet. You don't need anything profane, here."
Hogs	"The hogs snicker a bit, but they seem a little nervous, too."
Keys	"The hogs snicker a bit, but they seem a little nervous, too."
alert letters	"[l-r-bye-hint]."
log ons letters	"[l-r-bye-hint]."
ought letters	"[l-r-bye-hint]."
disk	"[if skid is in lalaland]Bleah. Did all this high-tech work make you forget the disk was a skid? Yes. Yes, it did[else]The disk seems to want to expand, but not quite into that. You must be close[end if]."
escaroles	"The escaroles seem slightly meatier."
pile of coal	"Microscopic bubbles seem to form on the coal and burst in the air."
flea	"The flea makes a crinkly noise but still seems quite dead."
drab yoke	"It'd take too long to type out all the possibilities, but that seems basically right. Hmm."
t-key	"The TBA key rattles within the keyboard a bit."
USB	"Hmm. There are only five possibilities, and more than one may be right. You've done the tough stuff."
trim socks	"You don't have the available memory in your head to see all the possibilities, but yes, something like that MUST work."
clock sap	"NO, REARRANGE AND TRY AGAIN, you think."
fount	"Hm, might be fun to try something like that again."
gum	"You stare at the gum. Hm, only a few ways it can be stretched or whatever."
piece of scratch paper	"Man! That's the thing about compiling. Switch one or two characters, and foom, it's just as bad as if you were completely off-base."
skid	"Bleah. Did all this high-tech work make you forget the skid was a disk? Yes. Yes, it did."
compiled code	"Hmm. Compiled code is tricky. Once it's fixed, if you have even one thing in the wrong order, it does nothing right. That MUST be what's happening here."
o-t	"Hm, no, that's not quite how to cover all the ground looking for the ol['] trap." [START oyster]
Capers Recaps	"You think of mocking Casper's writing style, but that's not quite it. Something more direct and physically insulting, maybe."
tumblers	"The tumblers wobble a bit as you try to do ... something ... to them."
stein	"Hm, the stein belongs somewhere you can destroy it, but not QUITE like that."
sign	"Nobody pays attention to your performance as you disobey the sign. Or try to."
clam	"The clam still seems enraged."
boats	"Perhaps if you were louder and more confident, the boats would hear you."
carps	"The carps and pikes laugh at--whatever you tried. But you know bullies are like that when someone is onto them. Hm, how to fix things."
tunes	"The tunes grow slightly less annoying, for a moment."
wrap	"That's not quite the way to pop the wrap."
trolls	"The trolls laugh at you a bit, but nervously."
urn	"The urn sits there, daring you to walk away."
raft	"The raft rocks slightly."
oars	"You see bubbling under the oars."
eeks	"You guess the eeks must be there--no, there!"
haunter	"Hm, not quite the right way to dig, dig?"
waste	"You realize you didn't quite psyche yourself to fix the waste."
heaps	"The heaps still look ugly as ever."
gleaner	"The gleaner remains too small to read."
dialer	"[di-cli]."
lever	"You look at the lever, wishing it would be a little more fun to pull."
d2	"[di-cli]."
yapper	"'Eh? What?' says the yapper. 'Speak up, you were about to make sense there.'"
serpent	"The serpent calms down for a split-second[doc-try]." [START towers]
diners	"The diners glare at you, then look up at the sky, slightly worried."
pirates	"The pirates blanch a bit but quickly regain their swagger."
serpent	"The serpent shakes its head and tail a bit."
man covered	"The man picks at his paint, as if he could almost peel it off."
strudel	"You almost expect the strudel to hop up[if player does not have strudel] into your arms[end if], but the moment passes."
ingrates	"The ingrates seem to wonder if it's worth complaining to you for a moment. You get the feeling that they may start off angriest, but if you could bend their mood, they might lose their willpower and give up."
fissure	"The fissure seemed to say half a word before freezing."
bonker	"'TANGENTIAL HIT!' blares the bonker. 'THE MARAUDING HORDES ARE ON TO US!'"
weeds	"The weeds almost seem to shrug."
saver	"The piece-of-junk raves saver suddenly, somehow, feels more valuable, almost shiny for a second."
iPrune	"The iPrune shrinks, slightly. I mean, it recedes, but it doesn't quite get smaller."
muscly	"The hulk stumbles for a moment."
organised	"The drains sizzle slightly but go back to menacing quiet."
admirer	"Your admirer looks askance, then returns to their puppy-love expression."
natives	"The natives look almost ready to be suckered by flattery or just a tall tale in general, but that look passes."
yurts	"The yurts sway slightly. They may not be guarding much, but maybe you could do for them."
alarming	"The grailman seems almost average for a moment."
nameless salesmen	"The salesmen grow momentarily protective of their Nerd-Aid supply."
Reed's Ale	"The Reed's Ale man listens to what you're saying for a minute, but--no, you didn't quite get it right. He goes back to reciting his tired sales pitch."
wait-seer	"The wait-seer looks bored and distracted for a second."
rewired robot	"The robot almost looked a bit odd there for a moment."
deacons	"The deacons ponder for a minute before going back to their scheming. But they looked scared--worried--you were close to exposing their ol['] heist."
Ray Eck	"The keycar slows down for a minute. Ray Eck frowns at you."
ropins	"The ropins remains secure, with no easy way to open it."
smart kid	"The kid seems to be trying so hard to concentrate, but he hasn't found it yet."
denim	"The denim bends and warps, but not enough to cut it."
pulses	"The pulses seem less there and less negative for a moment."
old ice	"The old ice seems to glimmer a bit."
turbos	"[jet-nq]."
blaster	"[jet-nq]."
eastern shore	"Maybe it's you, but the eastern shore seemed slightly closer."
Ed Yerg	"Ed looks slightly less avaricious."
crocus	"The crocus almost seems to perk up."
curst palace	"Hmm...[if player is in limits]no rumbling from the curst palace. You're going to need a big word, here[else]that's good practice, and a good guess, but even if it were right, you don't know if you could change the curst palace from here[end if]."
b-b	"The barley rustles in an imaginary wind--but hardly at all." [START otters]
Ed Riley	"Ed Riley looks askance at his deli rye, as if it had some bad aftertaste."
imp1	"[imp-nag]."
imp2	"[imp-nag]."
imp3	"[imp-nag]."
ram1	"[ram-nag]."
ram2	"[ram-nag]."
ram3	"[ram-nag]."
raptor	"The raptor recoils slightly."
parrot	"The parrot seems to roll its eyes at you, as if to say, [unless player is in alcoves]not here[else]you DO remember what I was[end if]."
cinders	"The cinders glow and even warm up for a bit."
Merle	"Merle and Elmer look askance at each other for a bit."
atmo-moat	"Hm, that's not it, but it must be elemental. No, elementary."
sea cube	"The sea cube shakes a bit."
eels	"The eels swim a bit faster."
owls	"Hmm. The owls still swarm and swirl too fast."
ghoul hat	"Mr. Lee shakes his head and adjusts the ghoul hat."
p-2	"Rev. Howe seems to snarl a bit more deeply for a moment."
thrones	"The thrones seem to buzz a bit."
nails	"[one of]O[or]Another o[stopping]ne of the nails seems to bend a bit."
pines	"The pines rustle as if an animal climbed through them."
corona	"The corona scurries about for a bit before settling down again."
ocelots	"The ocelots squint at you through their clip-ons."
leopard	"The leopard almost seems to un-cuff its hands."
badger	"The badger flexes imaginary suit lapels, then quickly goes back to brooding."
satyr	"The satyr puts a hand on its chin as if pondering music."
medals	"The medals waver noiselessly. Hm, that's not quite it."
weltish whistle	"The sound you make is experimental, in a new jazz sort of way, but it's not quite right."
moss cap	"The cap itches for a bit, then seems to try to spin you around." [others]
ppf	"The pipe panel fence sways slightly."
b-w	"You feel the barriers west pulling towards you."
sorer bogey	"The bogey's tone changes slightly for a second."
l-o-p	"Something glints off the list of prices."
auction caution	"Everyone promises quick payment, but what are you promising to pay quickly FOR?"
peach	"The peach still looks too expensive."
videotape	"You must be on the right track--but nothing happens. Yet."
barren cries	"The cries seem like they could change--or is it a dream to you?"
harmonicas	"The harmonicas whistle, as if something happened."
pagers	"The pagers light up slightly. Maybe give it another go."
riot cap	"Nothing happens. Your magic skills feel like the pits for a second."
nectarine	"The nectarine seems a little less shiny and new. But not enough."
tangerine	"You try and remember your geography. You must be close!"
peanut cola	"The peanut cola smells slightly fruity for a minute."
rapt figure	"The rapt figure frowns as if it's eaten something sour."
briar screen	"The briar screen briefly turns darker."
pryer bars	"The pryer bars briefly turn very red."
magenta rope	"The magenta rope and other items you uncovered briefly seem as one."
spear	"The spear stays as-is. But it can't be that hard to change."
slime	"The slime shifts about slightly, but not enough--yet."
lemons	"Len frowns at the lemons."
melons	"Len frowns at the melons."
quince	"That certainly sounds foreign--but it doesn't seem to sway Len."
silly shirt	"You don't quite have ESP, pal, but with the right logic skills you can seem like you do. That shirt's still resisting."
eerie blurbs	"The blurbs turn a few shades of purple before settling again."
mad train	"The train emits some fake smoke and seems ready to blow up--but no."
barber sickle	"The barber sickle sits there, dark, but you must be on the right track."
pugnacious plant	"The plant seems to adopt a defensive position with its arms/branches."
an-a	"The A shines for a split-second."
lumps	"The lumps seem almost ready to burst."
reserved sign	"You seem to read the sign backwards for a second."
coin	"The coin looks a bit more artistic for a moment--no, it's too drab, again. Hmm. You must be close."
coins	"The coins rattle and hum promisingly."
icons	"The icons rattle and hum promisingly."
s-c	"The sonic coins hum almost questioningly."

to say jet-nq:
	say "Despite your lack of technical knowledge, you think you almost did...something to improve the jetskis";

to say imp-nag:
	say "The imp looks slightly annoyed for a second. You may be on the right track";

to say ram-nag:
	say "The men manage to shush you more noisily than you've ever been shushed. You may be on the right track";

ana-repeats is a number that varies.

cur-help-item is a thing that varies. cur-help-item is usually yourself.

understand "wander" as a mistake ("A glare from Rodney snaps Andrew back from gazing outside.") when Andrew is visible.

understand "warden" as a mistake ("Andrew doesn't look like he has the leadership qualities necessary to become to main warden over Rodney.") when Andrew is visible.

to say spec-help of (itm - a thing):
	if rq is active:
		say "With that conversation, you can't concentrate on much...";
		continue the action;
	now itm is attempted;
	if itm is prefigured:
		say "No, you were right before, there. You just need some help to make that magic word in your notepad work, now. Or maybe you don't!";
		continue the action;
	if itm is a warrior:
		say "[if itm is rodney]Rodney blinks a bit, then frowns[else][itm] shakes his head, but a glare from Rodney sets him straight--for now[end if].";
		continue the action;
	if itm is an xtrhelp listed in the table of spechelp:
		choose row with xtrhelp of itm in table of spechelp;
		if there is a helptxt entry:
			say "[helptxt entry][line break]";
			if itm is cur-help-item:
				if can-prog-hint:
					increment ana-repeats;
					if ana-repeats is 3:
						now ana-repeats is 0;
						say "[line break]This guessing is getting a bit frustrating. You note the idlers['] slider on the settler[one of][or]again[stopping]. Maybe it could help you a bit.";
						continue the action;
			else:
				now ana-repeats is 0;
			now cur-help-item is itm;
			continue the action;
[		continue the action;]
[		else:
			say "You feel as though you could've done something.";]
	say "You feel a slight psychic push-pull coming from [the itm]. That's a decent omen.";

to decide whether can-prog-hint:
	if mrlp is oyster, decide no;
	if player does not have settler, decide no;
	if headaches is 0, decide no;
	if slider is switched on, decide no;
	decide yes;

doublewarn is a truth state that varies.

to say them-that of (tt - a thing):
	say "[if tt is a female person]her[else if tt is a person]him[else]that[end if]";

the block buying rule is not listed in any rulebook.

check buying:
	if player is in tenfold and yapper is in den loft:
		say "The papery yapper stage-whispers 'Ix-nay on the Vi-OS-ob-ay. That's not how business is DONE, here!'" instead;
	if player is in clearing:
		if player has noun:
			say "It's already yours." instead;
		say "You need to haggle. With actions. And descriptive words. And so forth." instead;
	if player is in scape space:
		if player has dollar:
			if noun is storage:
				try giving dollar to Art Erd instead;
		else:
			say "You have nothing Art Erd wants." instead;
	if player has tekno-token:
		say "This isn't a place of commerce." instead;
	if player is in sand home:
		if wipes are in sand home:
			say "You can't pay for the wipes, but maybe you don't need to." instead;
	say "There's nothing to buy, and there's nothing to buy it with[if player has ruby]. The ruby's kind of priceless[else if player has pearl]. The pearl isn't really tradeable[end if]." instead;

table of specreject [TSR - this can use a lot more entries]
specdone	spectalk
log ons	"[no-rehash]"
alert	"[no-rehash]"
ought	"[no-rehash]"

to say no-rehash:
	say "That'd be an awkward rehash. You need another way to say good-bye."

to say good-enuf of (goody - a thing):
	if goody is a specdone listed in table of specreject:
		choose row with specdone of goody in table of specreject;
		say "[spectalk entry]";
		continue the action;
	say "You've already changed [them-that of goody] enough.";

to say reject:
	if sss is true: [inform 7 gives extra space if I just follow the rule as-is]
		consider the show blues rule;
	let my-key be the hash of the player's command;
	let my-key-a be the hash of the player's command;
	d "The hash of the command is [my-key].[line break]";
	repeat through the table of anagrams:
		if the-from entry is visible:
			if my-key is the hashkey entry:
				if Gunter is off-stage and player is in dusty study and stuff-found is 3:
					say "You can't quite concentrate with the noise at the door.";
					continue the action;
				if the-from entry is reflexed:
					if the-from entry is not doc-y and the-from entry is not lemons:
						say "[good-enuf of the-from entry]";
						continue the action;
				if slider is switched on:
					match-process the player's command and the right-word entry;
				else:
					if Elmo is visible and the-from entry is not rifle:
						say "You need to [if Elmo carries rifle]disarm[else]talk to[end if] Elmo instead.";
						continue the action;
					if stuff-found < 3 and player is in study:
						say "Hmm. Nah. That's not quite it. Your skills are a bit rusty, but you'll figure it out.";
						continue the action;
					say "[spec-help of the-from entry]";
				continue the action;
	if number of words in the player's command > 1:
		now my-key is the hash of word number 1 in the player's command;
		d "The hash of word 1 of the command is [my-key].[line break]";
		repeat through the table of anagrams:
			if the-from entry is visible:
				if my-key is the hashkey entry:
					if Gunter is off-stage and player is in dusty study and stuff-found is 3:
						say "You can't quite concentrate with the noise at the door.";
						continue the action;
					if the-from entry is reflexed:
						if the-from entry is not doc-y:
							say "You've already changed [them-that of the-from entry] enough.";
							continue the action;
					if slider is switched on:
						match-process word number 1 in the player's command and the right-word entry;
					else:
						if Elmo is visible:
							say "You need to [if Elmo carries rifle]disarm[else]talk to[end if] Elmo instead.";
							continue the action;
						if stuff-found < 3 and player is in study:
							say "Hmm. Nah. That's not quite it. Your skills are a bit rusty, but you'll figure it out.";
							continue the action;
						if rq is active:
							say "With that conversation, you can't concentrate on much...";
							continue the action;
						say "[spec-help of the-from entry]";
						say "[line break](In particular, the first word seemed to have an effect, and you generally don't need a second word.)[line break]";
					continue the action;
	repeat through the table of nudges:
		if there is a hashval entry:
			if my-key is not 0:
				if my-key is hashval entry or my-key-a is hashval entry:
					if there is no this-reg entry or this-reg entry is mrlp:
						if there is a this-item entry:
							if this-item entry is visible:
								say "[this-clue entry][line break]";
								continue the action;
						else if there is a this-room entry:
							if location of the player is this-room entry:
								say "[this-clue entry][line break]";
								continue the action;
						else if there is a this-rule entry:
							say "[run paragraph on]";
							follow this-rule entry;
							if the rule succeeded:
								say "[this-clue entry][line break]";
								continue the action;
						else:
							d "Need error message for [this-cmd entry] misfire.";
			if doublewarn is false and my-key is hashval entry * 2 and my-key is not 0:
				say "It looks like you tried to act on something doubly, possibly something that anagrams itself. To remove any future confusion, you should know you don't need to do that [if lemons are in lalaland and melons are in lalaland]at all now you took care of the melons and lemons[else if otters is unsolved]until after you defeat Elvira[else] more than once in a special place in this region[end if].";
				now doublewarn is true;
				continue the action;
	if player has settler and settler-try is false:
		if the player's command includes "settler":
			say "It looks like you may be trying to do things with the settler. This game uses the simplified SCAN (OBJECT).";
			now settler-try is true;
			continue the action;
	if mrlp is otters:
		if the player's command matches the regular expression "^<a-z>+ly":
			say "[if whistle is reflexed and medals are reflexed]You don't know if you need to do any more of that[anicheck][else]You think you're on to something, but no--you can't find anything to focus on, thinking that.";
			continue the action;
	say "That's not something you can say, do or see here[if elmo is visible or gunter is visible]. Besides, there's someone to deal with[end if][if cur-score of manor > 0][one of]. (If you are trying to flip something back, you almost never need to.)[or].[stopping][else].[end if][if last-hash is my-key and last-hash > 0][line break]It looks like you're a bit stuck. You may need to take a step back and examine things, [mb-ss-ped]to see what you can change[trickier].[end if]";
	now last-hash is my-key;

to say anicheck:
	if nounsolve > 2 or adjsolve > 2:
		continue the action;
	say ", but you're worried you don't have enough allies";

settler-try is a truth state that varies;

to say trickier:
	if strip of profits is visited:
		say "[2da]the trickier stuff should have more than one clue";

to say mb-ss-ped:
	if player has settler:
		say "maybe with SS, ";
	if player has pedanto-notepad:
		say "maybe looking again through your pedanto-notepad for general tips, ";


last-hash is a number that varies.

section answer

[this is a small hack to allow ANSWER SIDE DOOR]

understand the command "answer [text]" as something new.

understand "answer [text]" as asking generically.

ansbufing is an action applying to one topic.

understand the command "answer [something]" as something new.
understand "answer [something]" as ansobjing.

ansobjing is an action applying to one thing.

does the player mean ansobjing the side door when Gunter is off-stage: it is very likely.

check ansobjing:
	if noun is a person:
		say "Try to ASK a person about something instead." instead;
	if noun is side door or noun is rude door or noun is secure door:
		try opening noun instead;
	say "That's not something animate." instead;


chapter notiping

notiping is an action out of world.

understand the command "no tip" as something new.

understand "no tip" as notiping.

carry out notiping:
	if cur-score of manor < 2:
		say "You shouldn't know about this command, yet. I mean, it was in Shuffling Around, but it's a bit different, this game." instead;
	say "You [if no-tip is true]already have[else]switch to[end if] NO TIP at a region's start. OPT IN will reverse this.";
	now no-tip is true;
	the rule succeeds;

chapter optining

optining is an action out of world.

understand the command "opt in" as something new.

understand "opt in" as optining.

carry out optining:
	if cur-score of manor < 2:
		say "You shouldn't know about this command, yet. I mean, it was in Shuffling Around, but it's a bit different, this game." instead;
	say "You [if no-tip is false]already have[else]switch to[end if] OPT IN at a region's start. NO TIP reverse this.";
	now no-tip is false;
	the rule succeeds;

chapter status bar and scoring

to decide what region is mrlp:
	decide on map region of location of player.

no-tip is a truth state that varies.

tip-warn is a truth state that varies.

to reg-inc:
	increment the score;
	if mrlp is nothing:
		say "BUG NOTE: This location needs a map region!";
	otherwise:
		increment the cur-score of mrlp;
		if mrlp is manor and rifle is off-stage and cur-score of manor is max-score of manor - 4:
			say "[line break]Congratulations, Iron [if player is male]Man[else]Woman (Ow)[end if] in Manor! You've found all the secrets here. You can just exit the basement now[if settler is unexamined], but it'd be a good idea to examine the settler, first[end if].";
		if mrlp is stores and cur-score of stores is max-score of stores:
			now stores is solved;
			now last-solved-region is stores;
	consider the notify score changes rule;
	repeat through table of init-points:
		if mrlp is myrg entry and cur-score of mrlp >= pttot entry:
			if no-tip is false and roved is false and doneyet entry is false:
				say "[line break][blurb entry][paragraph break]";
				if tip-warn is false:
					ital-say "you can turn this start-of-region hinting off with NO TIP and on again with OPT IN.";
					now tip-warn is true;
					pad-rec "opt in/no tip";
			now doneyet entry is true;

table of init-points
myrg	pttot	blurb	doneyet
manor	2	"Yay! You're still changing stuff to stuff. For now. But you're on home turf, now. If you get out in the world, it'll be trickier."	false
stores	1	"Well, it looks like the stores can be changed into something else. Maybe it won't be so easy behind them, but maybe you can get rid of a few to start and see any tricks later."
routes	1	"Well, that was different from the standard directions. But there can't be too many other ways to go."
troves	1	"Neat. You made progress just thinking. Or not-thinking. It could be either."
troves	2	"Thinking has gotten you somewhere, you think. [if Pa Egg Pea is reflexive]Maybe reading Pa, Egg, Pea right will help you further, let you look into your mind more dispassionately[else]Hating and gaping are totally different, except for the whole not actually doing anything, but they've both worked[end if]."
presto	1	"It feels cathartic, using sub-profanities to get going. Looks like words that generally don't mean anything, do, here."
presto	2	"Gee! Such good clean fun! Your only regret is, you won't get to use many huge compound words to change anything, if you know Yorpwald."
oyster	1	"You've started to get some action in."
oyster	2	"Bam! More action! You'll still sort of be guessing the verb, but it's sort of just reacting, too."
towers	1	"Well! You're starting to understand how things can, or should, be here."
towers	2	"You're sort of glad for the short-ish names and the brute force, here. Things will probably get tougher to describe outside the Trefoil, but this is good practice."
others	1	"Well, that's nice. With Elvira gone, it's back to changing stuff to...stuff."
otters	1	"Hmm. Being weak might not be so bad, for a while. It cuts down the words you can use, but...it cuts down a lot of extraneous possibilities, too!"

when play begins (this is the define-status-line rule):
	now left hand status line is "[lhs]";
	now right hand status line is "[cur-score of mrlp]/[if possibles is true][poss-range][else][max-score of mrlp][end if][if Strip of Profits is visited] [bracket][number of solved regions][close bracket][end if]";
	ital-say "NOTE: this game is a sequel to Shuffling Around. It has the same mechanics. But the back story is not important.";
	say "[wfak][line break]Yorpwald's been peaceful for a long time after your turn shuffling around. You weren't tabbed to lead the kingdom--but those in charge did a decent enough job, until along came Elvira. Nobody took her seriously at first, since it slipped that she was once branded the Necro-Crone.[wfak][line break]That was before she came out with a proposal she said you could not resist: ELVIRA'S REVISAL! You had to admit, if you didn't think it worked, then your shuffling around only went so far. But if you did, then obviously she was the right person to execute it, and so forth. Either way, the way you rescued Yorpwald was so silly, it couldn't happen again, and no bad guy would be dumb enough to leave things that way! There would be new, bold defenses against the next big challenge.[wfak][line break]Thus Elvira gained prominence, vowing to fight the scourge of stupid wordplay armed only with her charisma. 'ELVIRA'S REVISAL? I SLAVER!' became the chant. And people did. She was a more exciting conversationalist than you, weighing in on spoonerism elitists (pro and con), and implementing other 'improvements' such as Reality TV and gossip columns.[wfak][line break]Then one day she suggested the possibility you might become jealous of her popularity! And who could blame you?[wfak][line break]Her being the Necro-Crone was all in the past! She was way more exciting and social than you, and didn't people deserve a second chance? Of course they did![wfak]"

to say lhs:
	if mrlp is not troves:
		say "[location of player] ([mrlp])";
		continue the action;
	say "Poverty";
	let QQQ be the number of visited rooms in Troves;
	repeat with QQQQ running from 1 to 6:
		say "[if QQQQ is QQQ]*[else]-[end if]";
	say "Very Top (Troves)"

to say poss-range:
	if poss-score of mrlp > min-score of mrlp:
		say "[min-score of mrlp]-[poss-score of mrlp]";
	else:
		say "*[poss-score of mrlp]*";

carry out requesting the score:
	if mrlp is nothing:
		say "BUG: This location needs a region." instead;
	if mrlp is Demo Dome:
		say "You don't need a score in the Demo Dome. You just need to look around.";
		left-to-see instead;
	otherwise:
		d "# of turns = [turn count].";
		say "Ol['] Stat Totals:[paragraph break]You have [cur-score of mrlp] out of [max-score of mrlp] total points for the [mrlp] region, where you are now[if mrlp is solved] and have solved[end if][if mrlp is otters and inhib is true]. You probably need to do something to get back your full powers, too[end if]";
		if mrlp is not solved and possibles is true:
			if min-score of mrlp < poss-score of mrlp:
				say ". Lowest score to solve is [min-score of mrlp]. Maximum score available is [poss-score of mrlp]";
			else:
				say ". You need [min-score of mrlp] points to win";
		say ".[line break]";
	repeat with Q running through regions:
		if number of visited rooms in Q > 0:
			if mrlp is not Q and Q is not solved:
				say "You have scored [cur-score of Q] out of [max-score of Q] total points for the (unsolved[if Q is stores] hub[end if]) [Q] region.";
	if there is a solved region:
		let temp be 0;
		say "[line break]Won now:";
		repeat with rgn running through markable regions:
			increment temp;
			if mrlp is not rgn:
				say " [rgn] ([cur-score of rgn]/[max-score of rgn])[if temp < number of markable regions],[else].[end if]";
	otherwise:
		say "[line break]You haven't solved any regions yet.";
	if mrlp is others:
		eval-fruits;
	the rule succeeds;

possibles is a truth state that varies. min-alert is a truth state that varies.

report requesting the score for the first time:
	if possibles is false and min-alert is false:
		ital-say "You can toggle seeing the minimum points to pass an area, or maximum achievable points, by typing POSS. This is a potential meta-spoiler, since the minimum score increasing indicates you found a fun side quest, and the maximum score decreasing means you left something behind, but it may be helpful.";
		now min-alert is true;

definition: a region is markable:
	if it is mrlp, no;
	if it is solved, yes;
	no;

an exhibit is a kind of thing. an exhibit can be unnoted, perused or exhausted. an exhibit is usually unnoted.

to left-to-see:
	if number of unnoted exhibits is 0:
		let q be number of unexamined things in peek keep;
		if q > 0:
			say "You can still go see stuff [if sparse spares is visited]in Sparse Spares[else]below Peek Keep[end if].";
			continue the action;
	repeat through table of xibits:
		if exhib entry is unnoted:
			if location of exhib entry is unvisited:
				say "You still haven't gone [cueloc of exhib entry] from Peek Keep.";
				continue the action;
			if exhib entry is unexamined:
				say "You saw the [exhib entry] in [location of exhib entry], but you didn't examine it.";
				continue the action;
			say "You still have more of the [exhib entry] to look through.";
			continue the action;
	repeat through table of xibits:
		if exhib entry is perused:
			say "You haven't looked all the way through the [exhib entry] in [location of exhib entry].";
			continue the action;
	say "It looks like you've looked through everything. Thanks for paying attention."

to decide which direction is cueloc of (xx - an exhibit):
	let myway be the best route from Peek Keep to the location of xx;
	decide on myway.

chapter possing

possing is an action out of world.

understand the command "poss" as something new.

understand "poss" as possing.

carry out possing:
	if possibles is true:
		now possibles is false;
	otherwise:
		now min-alert is true;
		now possibles is true;
	say "Switching [if possibles is true]on[else]off[end if] minimum/maximum available point notification. ";
	if min-alert is false:
		ital-say "this is a quasi-spoiler of sorts, since watching the maximum possible score drop may mean you have missed an easter egg. Or watching the minimum score increase may mean you found one.";
	else:
		say "[line break]";
	pad-rec-q "poss";
	the rule succeeds;

chapter fliptoing

fliptoing is an action applying to one visible thing.

a mango is a fruit.

a thing can be reflexive, reflexed, vanishing, or nonreflexive. a thing is usually nonreflexive.

check fliptoing when inhib is true:
	if player is in wickeder or player is in preserve:
		say "[inhib]" instead;

preserve-animals is a number that varies.

check scaning jetskis:
	if blaster is reflexive and turbos are reflexive:
		say "Weird--the settler flips about, as if the components of the jetskis would give different readings." instead;
	if blaster is reflexed and turbos are reflexed:
		say "Nothing any more. You may've fixed the jetskis.";
	if blaster is reflexed:
		try scaning turbos instead;
	try scaning blaster instead;

note-progress is a truth state that varies.

after fliptoing a portal:
	if engravings are examined:
		now note-progress is true;
	continue the action;

basement-backpedal is a truth state that varies.

definition: a thing (called mything) is cromulent:
	if mything is in location of player:
		decide yes;
	if mything is palm and player is in dusty study:
		decide yes;
	if mything is curst palace and mrlp is towers:
		decide yes;
	if mything is visible: [put here to increase speed]
		decide yes;
	decide no;

to check-get-pad:
	if player does not have pedanto-notepad:
		say "[line break]In fact, you realize the notepad on the chair would be a great place to file that idea. It'll help tame lots that's meta, mate.";
		now player has pedanto-notepad;

to two-up:
	increment the score;
	increment cur-score of mrlp;
	reg-inc;

check fliptoing (this is the check ending flip rule):
	if noun is a thisflip listed in table of end-flips:
		choose row with thisflip of noun in table of end-flips;
		consider the check final region action rule for noun;
		if the rule succeeded:
			do nothing;
		else:
			do nothing instead;
	else if noun is a thatflip listed in table of end-flips:
		choose row with thatflip of noun in table of end-flips;
		consider the check final region action rule for noun;
		if the rule succeeded:
			do nothing;
		else:
			do nothing instead;

section check and carry out rules

check fliptoing (this is the portal palm and reflexive flip rule):
	d "Trying to flip [noun].";
	if noun is visible:
		if noun is a portal:
			try entering noun instead;
		if noun is reflexive or noun is vanishing:
			continue the action;
		choose row with the-to of noun in table of anagrams;
		if the-from entry is reflexed:
			say "[if there is a dubdip entry][dubdip entry][line break][else]Hey! No double dipping.[end if]" instead;
		try examining noun instead;
	if noun is t-b or noun is tables or noun is palm or noun is giant pin or noun is niche:
		if Gunter is not in lalaland:
			say "Nothing urgent yet[if stuff-found >= 3] except that bangish bashing[end if]. So no need to pre-flip, flipper.";
			check-get-pad;
			now noun is prefigured;
			pad-rec "flips" instead;
		if noun is part of diorama:
			now diorama-flip is true;

check fliptoing when player is in dusty study and gunter is off-stage (this is the don't flip til you should at start rule) :
	repeat through table of anagrams:
		if noun is the-to entry and the-from entry is cromulent:
			if player is in dusty study and urgent Gunter is off-stage:
				if stuff-found < 3:
					if the-from entry is not part of the diorama:
						now tried-flip is true;
						say "[if the-from entry is palm]You don't need a light source, yet[else if the-from entry is giant pin]There's no need to tidy your study up just now[else if the-from entry is satchel]Hmm, maybe there is something in there if you needed to go adventuring, but you don't, yet[else]Hm, well, that'd be a way to move around if you needed to sneak out. But you don't, yet[end if][one of]. Still, that seems right, so you file that idea away for later[or][stopping].";
						preef the-from entry;
						consider the Gunter knocks rule;
						do nothing instead;
				else:
					say "Worth trying later, but no need to pre-flip, flipper. See about that visitor, first.";
					preef the-from entry;
					do nothing instead;

check fliptoing (this is the sitar-stria-stair rule) :
	if noun is sitar:
		now stria is in lalaland;
		move stair backdrop to all stairy rooms;
	if noun is stria:
		now sitar is in lalaland;
		move stair backdrop to all stairy rooms;

check fliptoing (this is the reject flipping for reef and animal attack and alert sign rule):
	if noun is not owls and owls are visible:
		say "That's a good thought...once you've gotten rid of the owls. You don't have time to summon assistance.";
		preef noun;
		do nothing instead;
	if noun is not parrot and raptor is visible:
		say "That'd be nice to do, once that raptor's dealt with.";
		preef noun;
		do nothing instead;
	if noun is owls or noun is parrot:
		if inhib is true:
			say "You try, but you are too weak. Perhaps you should come back when your powers are recharged." instead;
	if noun is thor or noun is beet:
		if ship controls are reflexive:
			say "That'll be tricky, moving through or between Thor and the New Beet without being sure of the ship controls.";
			preef noun;
			do nothing instead;
	if noun is alert or noun is log ons or noun is ought:
		if Rand is not visible and noun is visible:
			say "You remember having more fun than you thought you'd have, bashing about with Leo and Rand. It was more fun than you realized at the time. But you have a mission to accomplish." instead;

check fliptoing (this is the by Rand and Leo rule):
	if noun is log ons or noun is alert or noun is ought:
		if Leo is in brunt:
			say "You mumble other words to shoo Rand and Leo, but you sort of miss them. Maybe you can get them to provide some muscle." instead;
	continue the action;

carry out fliptoing:
	repeat through table of anagrams:
		if noun is the-to entry and the-from entry is cromulent:
			if ff is true:
				append "[the player's command]: [the-to entry] to [the-from entry] denied![line break]" to the file of debuggery;
				say "[the-to entry] to [the-from entry] denied! Push ff to change this![line break]" instead;
			if the-from entry is reflexive:
				now the-from entry is reflexed;
			now the-from entry is unfigured;
			if location of player is preserve:
				if the-to entry is not parrot and the-from entry is not parrot:
					increment nounsolve;
			set pronoun it to the-to entry;
			set pronoun them to the-to entry;
			say "[the-msg entry][line break]";
			if mrlp is stores:
				if the-from entry is Store T:
					do nothing;
				else if the-from entry is bedruggled or the-from entry is Store H:
					min-up;
				else if number of supporting stos < 4:
					min-up;
			if the-to entry is not in lalaland:
				if the-from entry is boats and raft is reflexed:
					do nothing;	[a bailout if you type RAFT and BOAST]
				else if the-from entry is coins and the-to entry is s-i:
					two-up;
				else if the-to entry is t-b:
					if Basement is unvisited:
						two-up;
					else:
						now basement-backpedal is true;
				else if the-to entry is onyx censer and the player's command includes "phooey":
					min-up;
					two-up;
				else if the-from entry is not part of the diorama:
					reg-inc;
			if the-from entry is vanishing and the-from entry is the-to entry:	[this should work unless you flip an item twice and it vanishes 2nd time. Check.]
				now the-from entry is in lalaland;
			if there is a roomjump entry:
				if roomjump entry is Strip of Profits:
					solve-region the map region of the location of the player;
					continue the action;
				move player to roomjump entry;
				consider the show blues rule; [for debugging]
				consider the process random dialogue rule instead;
			else if the-to entry is satchel:
				move satchel to location of player;
			else if taked entry is true or player has the-from entry:
				now player has the-to entry;
			else if the-from entry is part of the diorama:
				now the-to entry is part of the diorama;
			else if the-to entry is not visible:	[components aren't broken off]
				if the-to entry is not the-from entry:
					move the-to entry to location of player;
			if the-to entry is lamp:
				now bean-smell is true;
				now dusty study is lit;
				if latches are off-stage:
					now player has latches;
				consider the adjust light rule;
			if the-to entry is not the-from entry and the-from entry is not reflexed:
				move the-from entry to lalaland; [this is to drop a new item in place]
			if the-to entry is visible: [assume that we are focused on the item we just flipped]
				set the pronoun it to the-to entry;
			if the-to entry is plural-named:
				set the pronoun them to the-to entry;
			if the-to entry is a person:
				if the-to entry is female:
					set the pronoun her to the-to entry;
				else:
					set the pronoun him to the-to entry;
			follow the show blues rule instead; [for debugging]
	repeat through table of anagrams:
		if noun is the-from entry and location of noun is location of player:
			say "You can't seem to change things back to how they were." instead;
	say "This case with [the player's command] in [location of player] shouldn't have happened. BUG." instead;
	the rule succeeds;

The look around once light available rule is not listed in the for printing the announcement of light rulebook. [only used in dusty study]

after fliptoing when player is in rustic citrus (this is the Curtis pleased rule):
	if cur-score of Others > 3 and moss cap is off-stage:
		say "You've done so well, Curtis explains there may be something north and gives you a moss cap to help you know which direction that is. After all, moss grows on the north side of trees...[paragraph break]You don't want to seem ungrateful, but you still point out that caps are to be worn on a head, killing any sense of direction.[paragraph break]Curtis points out that north is usually up in most reasonable maps, and if you can sit there and make fruit out of nothing, you can probably take the logic from there.[paragraph break]Awkward silence ensues, and Curtis sits down, exhausted from delegating. You ask Curtis about possible landmarks and such, but he's busy with new business ideas.[paragraph break]Hmm. Probably some of this garbage could be turned to more fruit, if you were the sort of person who wanted to do everything, but you'd rather help yourself right now.";
		now all carried fruits are in lalaland;
		now player has moss cap instead;
	if cur-score of others > 3:
		coin-eval;
	continue the action;

instead of wearing moss cap:
	say "It was a stupid idea, and it'll look stupid if you wear it."

chapter creditsing

creditsing is an action out of world.

understand the command "credits" as something new.

understand "credits" as creditsing.

carry out creditsing:
	say "Thanks to the organizers of IFComp 2012 and Spring Thing 2013. I must direct credit to my testers for finding bugs. Thanks to bitbucket for posting a project that let me organize bugs. Thanks to Heartless Zombie (David White) for his hash code and suggestions, which removed many technical barriers.[paragraph break]More generally, thanks to people involved with Inform 7. Sparser parsers couldn't have hacked this game.[paragraph break]More personally, thanks to my testers who beat my Beta. They are, in first-name alphabetical order: David White, Jason Ermer, Kevin Jackson-Mead, Paul Lee, Peter Butter, Melvin Rangasamy, and Wade Clarke. Robert DeFord provided moral support and proofread game documents.[paragraph break]Potsy typos and possibly a tyro's story are not their fault.[paragraph break]Out of the blue help post-release came from Toby Ott, who went through the game several times, and David Welbourn, whose walkthrough at www.plover.net/~davidw/sol/r/roili13.html inspired many bug, hint and user-friendliness fixes. Hanon Ondricek helped with user-friendliness issues and found the wonderful name Dawn Churlzest, Streever helped with a Heisenbug and lots of release 2/3 stuff, and Marshal Winter found cool stuff. For release 3, Elizabeth McDonald, Joel Webster, Lydia Q. Dames, Sean M. Shore and Steven Watson provided testing too, and Matt Weiner noted a debug-text bug that helped me overhaul under the hood stuff.[paragraph break]Thanks to Hanon Ondricek for finding the Electric Slide font and to Wade Clarke for consulting on the new release 3 cover art. If you hate the main idea, that's on me, but they helped me bring it out as best I could." instead;

chapter abouting

abouting is an action out of world.

understand the command "about" as something new.

understand "about" as abouting.

to say bbuck:
	say "https://bitbucket.org/andrewschultz/a-roiling-original/issues/new";

carry out abouting:
	if mrlp is routes and cur-score of mrlp > 0:
		say "You push your luck, but no u-boat shows up. [if pier is unvisited]Good thing you're above-ground[else if player is in pier]A ship is already there[else if player is in clipper]That's the last thing you'd need now[else][end if].";
		say "Oh, wait, did you want to see the ABOUT message for real? I should note here you don't need ABOUT to win the Routes area.";
		unless the player consents:
			say "OK." instead;
	say "A Roiling Original is the sequel to Shuffling Around and part 2 in my Stale Tales Slate. I doubt there'll be a third, since I've milked the concept dry.[paragraph break]ARO was initially written for Spring Thing 2013 and contains the same mechanics as Shuffling Around but hopefully is different enough to make for a new, original, and enjoyable story, especially since I focused on story in the post-comp release. You can see more abut the people who helped the game come to be by typing CREDITS.";
	ital-say "I really appreciate transcripts (even though this is a post-comp version,) as it's cool to tinker with what I made--or to be able to squash a bug, or to make a puzzle clearer. If you wish to send a transcript, you can do so by typing TRANSCRIPT at the command line, then mailing me that text file. ;, * and ? at the line's start will indicate comments.[paragraph break]You can directly report bugs or annoyances at [bbuck]--no need for an account." instead;

chapter bugtracking

to say bug-report:
	abort-if-bugfind;
	say "BUG! You should not have seen this. Write me at [email] to describe how and where you got this--use the up arrows, or have a transcript ready, if you want to give the last few commands.[paragraph break]You can also report reproducible bugs at [bbuck].";

bugsquash is a truth state that varies.

to abort-if-bugfind:
	if bugsquash is true:
		if word number 1 in the player's command is not "showme":
			say "Cutting off testing now.";
			end the story finally;
			follow the shutdown rules;

chapter exitsing

exitsing is an action out of world.

understand the command "exits" as something new.

understand "exits" as exitsing.

carry out exitsing:
	if mrlp is troves:
		say "No one direction seems better or worse than the next. Perhaps you need to find direction inside you, and you will move ahead in the world." instead;
	if mrlp is routes:
		if player is in mesa:
			if old giant is in mesa:
				say "You probably aren't going anywhere with that giant around." instead;
			if huge thing is not off-stage:
				say "You probably don't want to go anywhere with that [if huge thing is in mesa]thing[else]bean[end if] around." instead;
			say "There are plenty of ways to go, but they don't seem to lead anywhere. [if cleric circle is visited or idle deli is visited or adobe is visited]You've made it in one place, here, so maybe you can make it in another[else]There are three places to enter, though they do seem to shift[end if]." instead;
		if player is in deli or player is in adobe or player is in circle:
			say "You can go back out." instead;
		if mrlp is routes:
			say "Looks like you will need to figure a way to go onward without directions. You've been doing well so far." instead;
	if player is in den loft:
		say "You can go back outside, though you can also finish the job back here." instead;
	if player is in end den:
		say "You can go back outside to the Horned Hedron." instead;
	if player is in trefoil:
		say "You probably aren't going anywhere until Rodney does, first." instead;
	if player is in barley and b-b is in barley:
		say "Maybe you'll see some exits if you get rid of the barley." instead;
	if player is in rustic and compass is off-stage:
		say "You've lost your bearings a bit, but maybe [if player has compass]the compass could help[else]if you got enough fruits, Curtis would help you[end if]." instead;
	if player is in strip:
		say "There are no directional exits here, but you [if number of visible portals is 0]may want to try opening up a store[else if number of visible portals is 1]can go IN to the store-portal you made[else]have multiple ex-stores you can enter[end if]." instead;
	if number of viable directions is 0:
		say "There are no directional exits here, but that doesn't mean you're stuck. Maybe you can figure a way to create one[if number of visible enterable things > 0], and it looks like there's something to ENTER[end if].";
	else if number of viable directions is 1:
		say "You can try to go [list of viable directions].";
	else:
		say "There are [number of viable directions in words] viable exits[if mrlp is towers and number of visible guardians > 0], though not all are unblocked[end if]: [list of viable directions].";
	the rule succeeds;

chapter game-start

goshy is a truth state that varies.

when play begins (this is the basic initialization rule):
	let temp be 0;
	now the have-died flag is false;
	protect the have-died flag from undo;
	repeat with zozimus running through stos:
		now zozimus is in Strip of Profits;
	repeat through table of anagrams:
		if the-from entry is uncluing:
			now the-from entry is flippable;
	repeat through table of pad-stuff:
		if there is no readyet entry:
			now readyet entry is false;
		if there is no introtoo entry:
			now introtoo entry is false;
	repeat through table of init-points:
		now doneyet entry is false;
	move bulwark backdrop to all ominous rooms;
	move the curst palace backdrop to all towery rooms;
	add-errs manor;
	let convo-holes be false;
	repeat through table of ad slogans:
		if there is no blare entry:
			increment temp;
			now blare entry is false;
	d "[temp] unblared slogans of [number of rows in table of ad slogans] total slogans.";
	repeat through table of subject-blather:
		if there is no him-say entry:
			say "[him-who entry] / [person-subj entry] needs entry.";
			now him-say entry is "[bug-report]";
			now convo-holes is true;
	repeat with PE running through people:
		if PE is not a default-talker listed in the table of default-gen-blather:
			d "[PE] needs default-gen-blather.";
			now convo-holes is true;
		else if PE is not a him-who listed in the table of default-sub-blather and PE is not terse:
			if 1 > 2:
				d "[PE] might want default-sub-blather.";
		if PE is not terse:
			if PE is not a him-who listed in the table of subject-blather:
				if litany of PE is Table of No Conversation and PE is not a guardian:
					d "[PE] has nothing special or specific to say.";
			if PE is not a him-asked listed in the table of reflexive-blather:
				if litany of PE is Table of No Conversation:
					d "[PE] has nothing to say about themselves.";
	if convo-holes is false:
		d "No conversational holes.";
	now die-trigger is a random number from 3 to 5; [DIE TO US in Lectures]

definition: a room (called myrm) is ominous:
	if myrm is bleary barley and b-b is reflexive:
		decide no;
	if myrm is in otters:
		if myrm is Tapering Anger Pit or myrm is Anteroom:
			decide no;
		decide yes;

last-wall is a thing that varies. last-wall is usually inform 7 code wall.

when play begins (this is the hint and other randomization rule):
	let myrand be 0;
	if a random chance of 1 in 2 succeeds:
		now turbfirst is true;	[these are for random cluing]
	if a random chance of 1 in 2 succeeds:
		now goshy is true;
	if a random chance of 1 in 2 succeeds:
		now song-first is true;
	if a random chance of 1 in 2 succeeds:
		now viewer-first is true;
	if a random chance of 1 in 2 succeeds:
		now bee-head-first is true;
	if a random chance of 1 in 2 succeeds:
		now lobster-first is true;
	if a random chance of 1 in 2 succeeds:
		now thor-first is true;
	if a random chance of 1 in 2 succeeds:
		now t-or-b is turbos;
	else:
		now t-or-b is blaster;
	if a random chance of 1 in 2 succeeds:
		now rivets-first is true;
	sort byebyes in random order;
	now wibe-count is a random number between 0 and 1;
	sort marcitems in random order;
	sort nextclue in random order;
	if a random chance of 1 in 2 succeeds:
		now carps-pref is true;
	else:
		now carps-pref is false;
	now a random badbook is in hacks' shack;
	sort the table of xibits in random order;
	if a random chance of 1 in 2 succeeds:
		now last-wall is inform 7 wall;
	else:
		now last-wall is perl wall;
	let mycount be 0;
	d "[list of exhibits].";

volume regular verbs tweaks and irregular verbs

chapter jumping

instead of jumping:
	if player is in gyre and hump is in gyre:
		say "This is a silly anagram game, not a silly rhyming game." instead;
	if player is in campsite:
		say "You jump, clicking your heels and striking a ridiculous smile at the apex." instead;
	if player is in freight:
		say "You certainly are feeling jumpy right now, but--well, you want to jump towards the pale plea. And as reflexively as possible." instead;
	if player is in same mesa:
		say "You [if bench-end is not reflexed]try and jump onto the bench, but that's not quite the way. Hm[else]managed to get on the bench, and you don't need to, again[end if]." instead;
	if player is in austerer and hoop is in austerer:
		say "You jump but can't quite reach the hoop. You think you hear a voice saying 'O, ye hop!' You turn red.[paragraph break]You consider dropping your treasured possessions so you can grab the hoop, but you can't bring yourself to say the heck with them. Or, rather, you haven't, yet." instead;
	say "You try a jump but jam up[one of]. Boy, leaps lapse[or][stopping].";

chapter xyzzying

xyzzying is an action out of world.

understand the command "xyzzy" as something new.

understand "xyzzy" as xyzzying.

carry out xyzzying:
	say "That word is a mess and holds absolutely no power for you[if cur-score of manor is 0]. Hopefully you'll find why soon enough[else]. Trust me, I checked all the other twenty-nine combinations[end if].";
	the rule succeeds;

chapter knocking

knocking is an action applying to nothing.

understand the command "knock" as something new.

understand "knock" as knocking.

understand "knock [text]" as a mistake ("Just KNOCK instead.");

carry out knocking:
	if player is in plains or player is in study:
		if urgent Gunter is off-stage and stuff-found is 3:
			say "Knock knock! / Who's there? / An adventurer who should probably just OPEN the door instead." instead;
		say "A hollow CONKK, but nothing more. You may need to try other actions here." instead;
	if player is in gates stage:
		say "It'll be a bit tougher than that." instead;
	say "Knock knock! / Who's there? / An adventurer in a room with no doors!" instead;

chapter guardians

when play begins (this is the place guardians rule):
	repeat through table of guard-org:
		if there is a kloozorz entry:
			now guy entry is clueneedy;
		now guadir of guy entry is blockdir entry;
		now gualoc of guy entry is loc entry;

the block giving rule is not listed in any rulebook.

check giving something to:
	if second noun is ed yerg:
		say "[if ed yerg is reflexive]He mumbles, nonsensically, 'Eeg, dry,' and rejects your offer. You go red-faced at offering such a paltry gift--and his reaction[else]Ed is a reformed character. He needs no gifts of monetary value[end if]." instead;
	if second noun is a guardian:
		if second noun is serpent:
			say "You are present enough to present a present--but which present is most important or effective in this area? That is the question.[paragraph break]Plus, the whole no hands thing.";
		if second noun is iPrune:
			say "[one of]'Maybe that's how they do things IN PERU!' the hybrid fruit booms, turning red[or]Nah, you don't want that IN PERU lecture again[stopping]." instead;
		if second noun is pirates:
			say "'Tips are...' one says and shakes his head. You blush red at the meager gift you offered." instead;
		if second noun is ray eck:
			say "'That's real generous, but I got my hands full with this keycar!'" instead;
		say "No response. It looks like a gift won't be enough to get by. But you won't need one, based on what you've done so far." instead;
		if second noun is kid:
			if noun is a hintpastry:
				say "Giving sweets to kids? Really." instead;
			if doc-y is not in lalaland:
				say "The kid seems like he'd rather have the gift of knowledge." instead;
			if noun is settler:
				say "The kid seems impressed, but he's more mechanically than magically inclined." instead;
			unless noun is gizmo:
				say "That's not technical enough for the kid." instead;
			continue the action;
	if noun is flowerpot:
		if second noun is smart kid:
			say "He's more physical sciences than biological." instead;
		if second noun is doc-y:
			say "[one of]Dr. Yow puts the flowerpot on his head, angles it, shakes his head, and gives it back. He smiles and shrugs[or]You already tried that[stopping]." instead;
		if second noun is a guardian:
			say "You remember Old Hat Daltho's friend was across the water. So it can't be anyone guarding things over here." instead;
	if second noun is a fightin person:
		say "Bribery won't end this fight." instead;
	if second noun is bruisin:
		if noun is crust:
			say "Even he isn't gourmand enough to enjoy that." instead;
		say "He's not materialistic. He just wants a good dust-up." instead;
	say "Hm. Nah. [if second noun is plural-named]They don't[else if second noun is female]She doesn't[else if second noun is male]He doesn't[else]It doesn't[end if] want that--or, it seems, anything of yours." instead;

a guardian is a kind of person. a guardian is usually auxiliary and vanishing. a guardian can be passtried. a guardian is usually not passtried. a guardian can be clueneedy. a guardian is usually not clueneedy. a guardian can be unprodded or prodded. a guardian is usually unprodded. a guardian can be plurtry. a guardian is usually not plurtry.

a guardian has text called retrytext.

check objasking a guardian about a guardian (this is the guardian general chat rule):
	if noun is serpent:
		continue the action;
	if noun is curst palace:
		say "Nobody will ever rebuild it, but we still have to prevent others from doing so. For their own safety." instead;
	if noun is Elvira:
		say "Well, her choice to send [if noun is plural-named]us[else]me[end if] and be [if noun is plural-named]ourselves[else]me[end if]." instead;
	if noun is second noun:
		continue the action;
	else if second noun is in location of player:
		say "Nothing. Guess the guardians aren't going to rat on each other." instead;
	else if second noun is in lalaland:
		say "Threats or reminiscing won't get you anywhere." instead;
	else:
		say "Your grilling runs up against plausible deniability. Who? What? Where?" instead;

the specification of guardian is "A person that blocks your way through the towers area until you describe him correctly."

after doing something with a guardian:
	if noun is organised:
		set the pronoun them to noun;
	else:
		set the pronoun it to noun;
	continue the action;

a guardian has a room called gualoc.

a guardian has a direction called guadir.

a guardian can be blue, red, white or purple. a guardian is usually purple.

book push and pull to

Understand "pull [something] [direction]" or "pull [something] to [direction]" as pushing it to.

check pushing the skid to (this is the yak-oof rule):
	if yak is in lalaland:
		say "You probably don't need any more grunt work, now the yak's dealt with." instead;
	if the room second noun of location of player is nowhere:
		continue the action;
	if yak is on skid and location of player is phat path and second noun is north:
		say "The yoke doesn't quite fit through the door. It does, however, snap off and the yak looks freer, aliver, almost happy. It decides it's had enough of the leaf and, with a nod, walks off to a yak realm, perhaps in search of more malarkey. Maybe [if lamb is in lalaland]near the lamb you rescued[else]somewhere near the poor lamb's home[end if].";
		now yak is in lalaland;
		reg-inc;
		pad-del "Leo and Rand";
		now skid is in hacks' shack;
		now drab yoke is in hacks' shack;
		move player to hacks' shack; [?? why not MOVE PLAYER TO X INSTEAD]
		the rule succeeds;
	if player was in brunt and second noun is south and yak is on skid:
		try going south instead;
	if player was in gyre:
		if second noun is west:
			if hump is visible:
				say "You need to get over the hump." instead;
			else:
				say "The way west [if hoop is in lalaland]got cleared out when you jumped for the hoop[else if austerer is unvisited]looks like a dead end, nothing where your sled would need to go[else]was pretty much clear. You can't imagine needing to bring anything there[end if]." instead;
		if second noun is east:
			if plebe is in gyre:
				say "The plebe stands strong. You don't have the heart to run it over." instead;
			say "There's nothing in the Marines Seminar. Pushing the sled there would be a waste of time." instead;
	if player was not in shack:
		say "[if yak is on skid]Oof! Urg! The yak makes the skid a bit heavy, but you manage.[else]The skid grinds across the snowless ground with slowness.[end if]";
	continue the action.

After going a direction (called way-pushed) with the skid:
	if way-pushed is north and location is hacks' shack:
		say "The skid barely fits as you go in the door.";
	if way-pushed is south and location is phat path:
		say "The skid barely fits as you go out the door.";
	continue the action.

book thinking

thinko is a truth state that varies.

understand "ponder" as thinking when pernod is not visible.

instead of thinking:
	if player is in study:
		if stuff-found < 3:
			say "You begin a[one of][or]another[stopping] deep think, [one of]all about Elvira's rise to prominence and how she assured everyone that she could do wordplay if she were bored, and she was sure it was the best you could do, but really, there was no CREATIVITY at the heart of it, and the n-factorial possibilities--and that tagged gadget to give clues was a bit TOO convenient. It passes the time[or]but mulling and rehashing is no fun[stopping].";
			now thinko is true instead;
		else if Gunter is off-stage:
			say "Hard to think with that knocking." instead;
	if pernod is visible:
		say "No, you need to t hink a little more soulfully. ";
	say "If you need help, just say HINT. K?";

book touching

check touching:
	if noun is lamb:
		say "It's a bit too scared. Too scared to flee where it needs to go." instead;
	if noun is plaster or noun is paperwall:
		say "Seems a bit hollow but not enough to bust through." instead;

book listening

the you can hear stuff some places rule is listed before the block listening rule in the check listening to rulebook.

to say a-r:
	say "[one of]Ingera[or]Reagin[or]Rigena[in random order]"

before listening (this is the you can hear stuff some places rule):
	if player has s-i or player has s-c:
		say "A low buzzing from your [if player has s-c]sonic coins[else]sonic icons[end if]--odd. What could they do, or buy?" instead;
	if sorer bogey is visible:
		say "'I am the sorer bogey!' you hear. '[one of]Be sorry, ego[or]Oy! Erg! Sober[or]Ye sorer gob[in random order]!' it cries, as you see your skin redden." instead;
	if pugnacious plant is visible:
		say "The pugnacious plant is making an aggressive bb-arr-uh noise and seems to turn red in the process." instead;
	if barren cries are visible:
		say "The barren cries are sour and bitter and tiny." instead;
	if location of player is rustic citrus:
		say "Curtis is mumbling about some perceived slight." instead;
	if Rand is visible and Rand is washed up:
		say "The silence is a bit awkward, so you try chatting.";
		try asking a random washed up person about "rannygazoo" instead;
	if mrlp is presto:
		say "[if cur-score of presto is 0]A shot. Sort of[else]You don't hear anything congruent to what you've needed to say in this area, which is a good thing[end if]." instead;
	if player is in rawest waters:
		say "A scrawny swan cry. But not the Sawn Swan. You hope." instead;
	if player is in Trefoil:
		if number of visible warriors is 1:
			say "Rodney's intimidating enough, he can keep this place quiet." instead;
		if number of visible warriors is 0:
			say "Regular tavern bustle and storytelling once again, but nobody you need to talk to." instead;
		say "Rodney and his not-so-merry men stand impassive, united." instead;
	if reed's ale is visible:
		say "'He mutters and moans how [one of]Dr. Eleesa endorses it[or]E-dealers have it so easy[or]Lad Reese likes the stuff[or]Dre Eleas looks great in that ad for Reed's Ale[in random order], turning red, unsure if he wants to remove his costume or put it back on." instead;
	if ingrates are visible:
		say "You see red as the ingrates['] voices sound like tin gears." instead;
	if deacons are visible:
		say "The deacons aren't exactly yelling about their hostile ol['] heist. You might want to ASK them about, well, anything." instead;
	if rewired robot is visible:
		say "You listen until you cringe. Red lights flash across the robot, pleased he drew ire." instead;
	if player is in havens:
		say "You think you hear NEVAHs, but that might just be internal melodrama." instead;
	if player is in subsector:
		if doc-y is rowdy:
			say "Dr. Yow is yacking away noisily." instead;
		if doc-y is wordy:
			say "Dr. Yow is yacking away rapidly." instead;
		if doc-y is in ropins:
			if doc-y has been rowdy or doc-y has been wordy:
				say "Dr. Yow is silent once again." instead;
			say "Dr. Yow moans he could hack less shackles." instead;
	if ingrates is visible:
		say "The ingrates go red from [one of]complaining about [i]Geraint's[r] stupidity[or]describing how tacky [i]Nate's rig[r] is[or]having the [i]rangiest[r] list of complaints you've heard[or]babbling about how they've never been to [i]Tangiers[r][or]relating his horrible education at [i]St. [a-r][r][or]explaining what sane grit they have[or]a cloud of red nitre gas that passed a day ago[or]claiming you think you're a saner git than them[in random order]." instead;
	if admirer is visible:
		say "It's a bit embarrassing, really. Just generic praise that never feels right." instead;
	if atheists are visible:
		say "The atheists are really spelling out their logical arguments against any sort of God[if wait-seer is visible]. In light of this, the wait-seer doesn't seem to be the least tired[end if]. Maybe you could learn more details talking to the atheists." instead;
	if wait-seer is visible:
		say "The wait-seer is so serene, you almost can't waste ire on him blocking you. Almost. Maybe even saying random stuff might help a hint slip." instead;
	if player is in Achers' Arches:
		say "Silence--you wouldn't dare sin to upset the sardine with ear dins. OR WOULD YOU." instead;
	if player is in Hero's shore:
		say "You hear voices from the boats talking about great accomplishments. The raft makes unpleasant, disurbing noises." instead;
	if player is in lode and clam is in lode:
		say "You hear the clam snapping." instead;
	if player is in freight:
		try examining the pale plea instead;
	if player is in boredom:
		say "The dead air inspires no rad idea." instead;
	if old giant is in lalaland and player is in Same Mesa:
		say "Nice to have silence with the giant gone." instead;
	if tokers are visible and nestor is visible:
		say "[if nestor is visible]Conversation from the tokers you don't want to listen TOO closely to[else]The tokers bemoan their lost friend[end if]." instead;
	if nestor is visible:
		say "Nestor periodically mumbles about his lost buddies." instead;
	if player is in clearing:
		if mango is off-stage:
			say "Selly yells. [randbla] Amidst the hustle and haggling, a small voice is saying, 'Go, man!' You see red as it begins to nag mo[']. Where? How?" instead;
		else:
			say "Selly yells. [randbla][paragraph break]" instead;
	if lecturer is visible:
		say "You're hearing enough without trying, sadly." instead;
	if e-s is visible:
		say "A roar of angry undefinable words swirls from the, er, spot." instead;
	if rifle is visible:
		say "Awkward silence, what with Elmo holding that rifle." instead;
	if player is in rustic citrus:	[others]
		if pagers are visible:
			say "Annoying, low-tech beeping. Sounds like--well--pagers. You don't have the patience to find them all, though." instead;
		if barren cries are visible:
			say "Barren cries sift through the winds. You wonder if fruits have an feelings, or an afterlife." instead;
			say "You quieted the pagers and barren cries." instead;
	if player is in dusty study:
		if dusty study is not lit:
			say "Nobody's going to whisper a hint to you in the dark." instead;
		say "[if Gunter is in lalaland][randbla][else]Nothing, except... (knock, knock, knock.)[end if]" instead;
	if babblings are visible: [troves]
		try examining babblings instead;
	if player is in Used Lot:
		unless what-a-bee is reflexive and bee's head is reflexive:
			say "Someone helping someone else find their way around. 'How to get there? [one of]I'd veer...'[or]Eve, rid...'[or]Vie, Red!'[in random order] You see red a bit at getting no direct help, yourself." instead;
	if player is in rathole or player is in used lot:
		say "[if talk-quiet is false]You shut off the random gritty dialogue with HUSH[else]Actually, you can't help but hear gritty dialogue[end if]." instead;
	if player is in rotunda or player is in econ cone:
		say "[if talk-quiet is false]You shut off the random posh dialogue with HUSH[else]Actually, you can't help but hear posh dialogue[end if]. Anyway, no more badgering beggar din." instead;
	if noise is visible:
		say "No escaping the noise. Someone's knocking to get in." instead;
	if playbill is visible:
		say "No escaping the song." instead;
	if carps are visible: [oyster]
		say "You can't help but listen to the carps['] and pikes['] immature, nasty jibes." instead;
	if eeks are visible:
		say "You hear eeks. Arcing caring. Weeps sweep. 'Eek! Eek! Eek!'" instead;
	if aunt tuna is visible:
		say "Aunt Tuna is humming something tuneless as she goes about her business." instead;
	if location of player is Posh Hops Shop:
		say "[if tunes are reflexed]Silence. Awkward silence. An occasional cough.[otherwise]The jukebox notches technos (though a mere six remixes) with an anti-bore iron beat. Rap is par, too.[end if]" instead;
	if the-b is visible: [routes]
		say "[one of]You hear people crying 'The Bean has landed!'[or]'If the bean was a hat, our hero would be a HAT-BEEN.' You see red at the pun.[or]'Ban THEE then, [a-b]!' cries someone.[or]'How do we pull him/her/it without?' / 'Uh, tow it?'[stopping]" instead;
	if player is in cleric circle:
		say "Ol' Peg's Gospel is singing Our Spire Superior. Or Uh, Peter, Here Put the Pure Up There." instead;
	if old giant is visible:
		say "Those [i]tirades[r] from the giant. [if bench-end is reflexive][one of]Though he gets staider.[or]'Dear, it's...' he trails off.[or]'Sit. Dare!' he commands. 'Rad site! Rest aid!'[or]'I stared...'[or]He gestures to the bench, turning red. 'I'd rest a...'[or]'Die, rats! Rats, die!' he moans, to nobody in particular.[or]'A direst, aridest stare! I'd...'[or]'I stared! I'd stare!'[or]'It's a red...' he says, actually going red.[or]'Drat, [']e is!' cries the giant, turning red.[or]He explains what left Ed astir, turning red.[or]He rues the loss of the bench's side-art, his eyes turning red.[in random order][else if elbow is reflexive]Though his swinging elbow is more dangerous now.[else]All about that book, Rude [']N Nuder.[end if]" instead;
	if player is in ripe pier:
		say "Someone calling out they need help to go ABROAD." instead;
	if player is in Danger Garden: [towers]
		say "[if bonker is visible]A menacing silence spews from the bonker. Or maybe it's just your imagination[else]Honk, honk.[end if]" instead;
	if salesmen are visible:
		say "After hearing the salesmen chat for minutes, you're [i]dreadin['][r] what they'll say next." instead;
	if player is in Loftier Trefoil:
		if sir rodney is visible:
			say "Ugh. Sir Rodney is a dry one, barking out complaints." instead;
		say "Nobody has anything to say. Perhaps the fear remains." instead; [code should not be reached]
	if natives are visible:
		say "The too-pleasant sounds of the campsite are drowned out by the natives['] babble.";
		try objasking natives about natives instead;
	if player is in bran barn:	[otters]
		say "You hear morose mooers you can't see." instead;
	if Ed Riley is visible:
		say "Ed Riley doesn't seem to make any noise. He just blocks you west." instead;
	if macks are visible:
		say "Ick, man. Mackin[']. You really don't want to pay attention to the details, but you get the general impression." instead;
	if whiners are visible:
		say "The volume and speed they're at, the actual words don't matter. You need to bite the men's style somehow." instead;
	if sly imp is visible:
		say "You think you hear him saying something mean, and you're upset you might've, and you're upset he didn't. He's just being too subtle right now for you to think clearly." instead;
	if player is in Inclosure:
		say "Elvira's laughter still seems to echo, with a creator reactor in the distance, and an occasional shrike shriek, and an ominous BEWARE: WAR BEE." instead;
	if player is in stable or player is in Basement:
		say "Merciful quiet, for the moment." instead;
	if player is in shack:
		say "Classic techno music from the Baleets: 'Be Stale.'" instead;
	if player is in FiefCo Office:
		say "[if noise is in office]You can't help but hear the knocking. Which prevents you working on your big new REGION[else if salt is in lalaland][one of]You listen closely to 'I'd Cede.' But you see red at the memory of Eddie C.[']s followup, a vapid rehash, I Ceded[or]Oh man, that part that gets your eyes watery is up next[or]The song's chorus. Five notes. C, D, E, D, E... 'I...' just right to get your eyes red. There's just a little more[or]Three notes: E, C, E, '...did.' It gets you. You know your eyes are red now. Boy[cycling][else]. White noise, it is on. Whee[end if]." instead;
	say "The air! Hear it! Silent." instead;

book smelling

before smelling (this is the you can smell some stuff some places rule):
	if player is in study and study is dark: [manor]
		say "That worked in Hitch-Hiker's Guide to the Galaxy, but not here. That'd be copy-catting." instead;
	if player is in study and Gunter is in lalaland:
		say "Bean soup. Subpoena is near." instead;
	if player is in strip: [stores]
		if oyster is in strip:
			say "Seawater scents from Store Y." instead;
		if roved is true and hoster is visible:
			say "A mix of nice smells from the hoster where Store H was." instead;
	if player is in stable:
		say "Thankfully, you cleaned the tables before flipping them, so you smell no table scrap." instead;
	if lecturer is visible:
		say "It smells depressingly antiseptic here." instead;
	if tokers are visible:
		say "You smell something sweetish coming from the tokers I can't quite describe because, well, -ahem-. I'm for the right to do that sort of thing, on principle, but I don't." instead;
	if player is in adobe abode: [routes]
		say "The lingering pipe smoke that made the soot is actually agreeable. The ashtray itself doesn't smell especially strong[if pipe soot is in abode], so the pipe soot probably won't burn your hands if you can take it[end if]." instead;
	if player is in ripe pier:
		say "It smells of adventure and going [i]abroad[r]--or, at least, a bit away from the brackish, salty whiffs of trash." instead;
	if seed pit is visible:
		say "The seed pit smells a bit musty." instead;
	if player is in Loather Rathole or player is in Used Lot: [troves]
		say "Eew-gas sewage. Skint-stink." instead;
	if player is in boredom bedroom:
		say "Ew--mild mildew. A mustier semi-rut." instead;
	if player is in Dour Tan Rotunda or player is in skyscraper or player is in FiefCo Office:
		say "Perfumed. Dump-free." instead;
	if mrlp is presto: [presto]
		say "[if cur-score of presto is 0]Things turn to ash in your nose[else]You don't smell anything that'd make you say what you've needed to say in this area, which is a good thing[end if]." instead;
	if location of player is a mazeroom:
		say "'You smell a gefilte and think 'get a life.'" instead;
	if player is in shack and casserole is in shack:
		say "That casserole doesn't smell very good, but it's not toxic." instead;
	if player is in Posh Hops Shop: [oyster]
		say "You catch a whiff of some mokes['] smoke." instead;
	if player is in Hero's shore:
		say "Say, spare sea spray." instead;
	if player is in Achers' Arches:
		say "Sea rind." instead;
	if rude door is visible:
		say "A rued odor from the rude door." instead;
	if aunt tuna is visible:
		say "Antiseptic spice taint." instead;
	if player is in collapsed:
		say "This situation only stinks in general, not literally." instead;
	if player is in Den Loft:
		say "Old heat. Loathed hot lead." instead;
	if deacons are visible: [towers]
		say "The deacons wrinkle their noses back, hostile." instead;
	if ingrates are visible:
		say "Nitre gas. Or niter gas. You forget how it's spelled, and trying to remember makes you see red either way." instead;
	if leak lake is visible:
		say "The overwhelming smell of kale is not offensive, but you'd like to get by it." instead;
	if player is in solo den:
		say "Noodles so olden." instead;
	if player is in campiest campsite:
		say "[one of]You smell something generically nice and say 'Ahhhh! Nature!' a bit too loud. Ugg. You won't do that again.[or]You wonder to yourself if that's tarragon or rosemary or perhaps a hint of lavender... no, no, no.[or]I ran out of stupid jokes for this. Get on with the game, here.[stopping]";
		if salesmen are not visible:
			do nothing instead;
	if salesmen are visible:
		say "[if player is in campsite]Also, t[else]T[end if]he salesmen smell of Rind-Ade, the energy drink for people with more boisterous professions. It's the red stuff." instead;
	if deli rye is visible or noun is deli rye: [otters]
		say "The deli rye smells good, but Ed won't share." instead;
	if player is in fro:
		say "You can [if macks are visible]still [end if]smell the macks['] Cool-Gen Cologne, from that coy-hued bottle." instead;
	if player is in alcoves:
		say "A clove, likely from one alcove." instead;
	if player is in loop pool:
		say "Salt Water. Wet, astral." instead;
	if player is in Inclosure:
		say "Vast vats['] sulfinyl reek clearly eliminates all hope of silly fun." instead;
	if player is in rustic or player is in clangier:
		if slime is visible:
			say "The slime actually smells...nice, like dishwashing detergent." instead;
		say "Smells, savory, vary so." instead;
	if player is in filed field:
		say "A smell of many fruits." instead;
	say "Aroma-o-rama? Nothing's [i]tons[r] nigh." instead;

book taking

instead of taking a person:
	if noun is the player:
		say "I'm the only one who gets to be self-referential, here. Got it? Good." instead;
	if noun is the macks:
		say "They're the pick-up artists, here." instead;
	if noun is Gretta:
		say "You might be worse at picking Gretta up than the macks." instead;
	say "Lifting [if noun is plural-named]people[else]a person[end if] or something [if noun is plural-named]people[else]person[end if]-sized is too heavy for your superpowers. Even if your name happens to be Kate."

book examining

does the player mean examining a direction: it is very unlikely.
does the player mean entering a direction: it is very unlikely.

before examining (this is the mark as examined rule):
	if noun is inside:
		say "You need to specify the object you wish to look inside. You can also probably just X/EXAMINE it." instead;
	if noun is a direction:
		say "Looking in directions isn't supported in this game. Best to go where you want to look, or if a building is to the north, say X BUILDING instead." instead;
	if noun is not a thing:
		say "Try examining less abstract things instead." instead;
	if the noun provides the property examined:
		now noun is examined;

after examining:
	if noun is readable:
		now last-read is noun;
	continue the action;

book tying it to

check tying it to (this is the keyboard and key rule) :
	if noun is second noun:
		say "Tautology? Got ya, lout!" instead;
	if noun is hard drive:
		try tying second noun to noun instead;
	if second noun is caps lock:
		try tying second noun to noun instead;
	if noun is caps lock and second noun is keyboard:
		if caps lock is not part of the keyboard:
			say "'Pokey Key-op? Yep. Ok.' you say as you fit it in. No more in-caps panics.";
			now caps lock is part of the keyboard instead;

book waving

instead of waving:
	say "A view! I wave!" instead;

book swearing

instead of swearing obscenely:
	if mrlp is presto:
		if cur-score of presto is 0:
			say "That's too strong for here. But you have the right idea." instead;
		if hacks' shack is visited:
			say "There's no place for swearing now you've gotten to the hacks['] shack." instead;
		if plebe is visible:
			say "The plebe perks his ears up, but you didn't get enough oomph on that profanity. Maybe you should use a more general one--or one the plebe isn't expecting." instead;
		if hogs are visible:
			say "The hogs snicker at HOW you said that swear. They're the sort that get fazed by lame swears." instead;
		say "No, that's too strong for here. You've been doing quite well with the tame stuff." instead;
	if player is in sand home:
		say "You don't want Aunt Tuna to perform a tsk task." instead;
	if location of player is cleric circle:
		if curse-warned is false:
			now curse-warned is true;
			say "Only, uh, unholy. You can curse anywhere else except here without repercussion" instead;
		say "A voice booms CRUDE? CURED! as you feel a rage-slice for your sacrilege.";
		get-dead;
	if player is in cripple clipper:
		say "Siphon no pish on-ship." instead;
	otherwise:
		say "[randbla][line break]";

to say deth:
	let temp be a random number from 1 to number of rows in table of death messages;
	say "[blurb in row temp of table of death messages]";

curse-warned is a truth state that varies.

to say om:
	say "[if Rand is off-stage and dart is off-stage]one or two mild swears[else]one more mild swear[end if]";

instead of swearing mildly:
	if mrlp is presto:
		if hogs are visible:
			say "The hogs groan, as if to say, don't try that again. Maybe another lame swear will set them off." instead;
		say "[if dart is off-stage or Rand is off-stage]Well, maybe [om] would work here.[else if plebe is visible]The plebe tries hard not to snicker.[otherwise]You had your chance for a swear. And you took it. Yay, you.[end if]" instead;
	try swearing obscenely instead;

understand "bastard" as swearing mildly.

pointing it at is an action applying to two things.

understand the command "point [something] at [something]" as something new.

understand "point [something] at [something]" as pointing it at.

does the player mean pointing the settler at: it is very likely.

does the player mean pointing the settler at the player: it is very likely.

point-warn is a truth state that varies.

carry out pointing it at:
	if noun is not settler:
		say "You can really only point [if player has settler]the settler[else]one thing[end if] at other objects." instead;
	if noun is patcher:
		try zaping second noun instead;
	if point-warn is false:
		ital-say "it's much easier to SCAN objects instead.";
		now point-warn is true;
	try scaning second noun instead;

book scaning

[* bscanned is both-scanned, escanned is either-scanned]

scaning is an action applying to one thing.

understand the command "scan [something]" as something new.
understand the command "scan [something]" as something new.

understand "scan [something]" as scaning.

does the player mean scaning the player: it is unlikely.

troves-scan is a truth state that varies.

a thing can be cscanned. a thing is usually not cscanned.
a thing can be ncscanned. a thing is usually not ncscanned.

definition: a thing (called scanee) is bscanned:
	unless scanee is cscanned, no;
	unless scanee is ncscanned, no;
	yes.

definition: a thing (called scanee) is escanned:
	if scanee is cscanned, yes;
	if scanee is ncscanned, yes;
	no.

before scaning (this is the check as scanned if player can have/take settler rule) :
	if mrlp is dome:
		say "Old habits die hard! Relax and observe. You don't need to do solve any puzzles here." instead;
	if player does not have letters settler:
		if settler is visible:
			silently try taking the letters settler;
		if player does not have letters settler:
			say "You have no scanning item[if player is not in study], and you should, unless this is a test, so this could be a BUG[else if latches is off-stage]. You probably should answer the door first[else if settler is off-stage]. Maybe figure what to do with those latches[else]. This looks like a BUG, since you should keep the settler all game[end if]." instead;
	if noun is not a direction:
		if cheat-on is true:
			now noun is cscanned;
		else:
			now noun is ncscanned;
	else:
		say "The letters settler isn't THAT long-range." instead;

before scaning (this is the troves smart alecky rule):
	if Map region of location of the player is troves:
		if troves-scan is false:
			say "You're a bit worried this scanning shouldn't work here, since it is all about you. but then you realize you are just utilizing and leveraging proprietary technology, and that makes you feel like more of a go-getter.[line break]";
			now troves-scan is true;

first-good-scan is a truth state that varies.

to oscan (scanee - a thing):
	now scanee is ncscanned;
	now scanee is cscanned;

carry out scaning:
	if mrlp is demo dome:
		say "Questing time is over. No need." instead;
	if noun is big l or noun is big-let:
		say "Nothing happens. It's probably some sort of hint or guide in itself, not something you need to mess with." instead;
	if noun is player:
		say "According to your cutting-edge blend of magic and technology, you are either perfect as you are, or too boring to change anything else." instead;
	if noun is letters settler:
		say "The settler is not flexible, despite its flexible options. But it would show [full-monty of settler] if it were." instead;
	if a-text of noun is "":
		say "The letters settler registers nothing." instead;
	if first-good-scan is false:
		now first-good-scan is true;
		say "[one of]Ta-da! Data (a tad.) [or]Ta-dum! Datum! [at random]It's not an odd DOA doodad! [if mrlp is manor]You recall writing in your notepad about your tagged gadget from your first adventure and how it helped you determine what you needed to change an object to. But the settler has new colors. You'll need to find what they're for.[paragraph break][end if]";
		ital-say "NOTE: if your interpreter supports Glulx, see the top for a graphical representation of the colorings. You can also type SPACE ON or SON to space out the text if you are visually impaired, or NO SPACE or NOS to lump the text back. Also, LA repeats what you scanned last, if the window on top does not show it.";
		pad-rec-q "la";
		pad-rec-q "spaces";
	if noun is not the player:
		now last-scanned-thing is noun;
	say "Your settler registers [full-monty of noun].";
	repeat through table of aftertexts:
[	if noun is an xtradesc in table of aftertexts: ?! doesn't work]
		if noun is xtradesc entry:
			choose row with a xtradesc of noun in table of aftertexts;
			if bothscan entry is true:
				now noun is ncscanned;
				now noun is cscanned;
			if b-only entry is false or cheat-on is true: [if cheat is off and it's b-text only clue, ignore.]
				if clue-only-once entry is false or clued-yet entry is false:	[special clued-once text ignored]
					now clued-yet entry is true;
					say "[line break][xtratext entry][line break]";
			the rule succeeds;
	the rule succeeds;

chapter scaning air

[?! how to bother scaning air ]

check scaning heat:
	say "You look for a clue how to race...";

check scaning cold:
	say "You look for a clue how to make some heat..."

bogus-plains is an undesc. a-text of bogus-plains is "RRRYYR". b-text of bogus-plains is "RRRY??".

check scaning air (this is the air scan based on room rule) : [?! possible to define air based on where it is e.g. a-text/b-text for mango/voltmaze but silly]
	if location is Sun-Spared Underpass: [start routes]
		if darkness is visible:
			try scaning darkness instead;
	if the-b is visible:
		try scaning the-b instead;
	if location of player is Cripple Clipper:
		if ship controls are reflexive:
			say "You scan, trying to find [one of]where the hit win button is, and you get [hit-win][or]where Ben hid the button, and you get [ben-hid][in random order]." instead;
	if location of player is Loather Rathole: [start troves]
		if cold is visible:
			try scaning cold instead;
		if heat is visible:
			try scaning heat instead;
	if location of player is Econ Cone:
		if pernod is visible:
			try scaning pernod instead;
		if rivets are reflexive and prai is reflexive:
			if rivets-first is true:
				say "The rivets have a weird magnetic pull to them. As if there's brain waves in there pulling you towards it so it can tell you what to do.";
				try scaning rivets instead;
			else:
				say "The PRAISE text seems to pull your settler to it.";
				try scaning prai instead;
	if cellar door is visible:
		try scaning cellar door instead;
	if location of player is boredom bedroom:
		if diapers are reflexive:
			say "Whoah, yeah, you're pretty bummed here! You're even too bummed to POINT a handy device like the settler at anything specific. Now THAT'S bummed." instead;
	if location of player is Used Lot:
		if verbose is visible:
			try scaning verbose instead;
		if what-a-bee is reflexive and bee's head is reflexive:
			say "That bee is all up in your face. So you sort of scan it by default.";
			try scaning what-a-bee instead;
	if location of player is FiefCo Office:
		if noise is in office:
			say "The settler seems to pulse with the noise's volume.";
			try scaning noise instead;
		if salt is not visible:
			try scaning song instead;
		if stream is reflexed or lobster is in lalaland:
			try scaning salt instead;
	if location of player is hacks' shack and compiled code is visible: [start presto]
		say "As you contemplate further how to budge the code, your wave your settler at it.";
		try scaning compiled code instead;
	if lar is visible:
		try scaning lar instead;
	if volt maze is visible:
		try scaning volt maze instead;
	if player is in a mazeroom:
		say "The air scans [full-monty of volt maze]." instead;
	if location of player is Posh Hops Shop: [start oyster]
		say "The settler points towards the door and the trolls.";
		try scaning trolls instead;
	if player is in freight:
		try scaning pale plea instead;
	if player is in lean lane:
		say "The air's full of eeks, which your settler picks up." instead;
		try scaning eeks instead;
	if player is in plains:
		if splained is false:
			say "[full-monty of bogus-plains]" instead;
	if location of player is bleary barley and b-b is reflexive: [start otters]
		try scaning b-b instead;
	if location of player is clangier: [start others]
		if mango is off-stage:
			say "As you listen to the crowds, you notice [full-monty of dummy-mango] on your settler." instead;
	if player is in swell wells:
		if sorer bogey is visible:
			try scaning sorer bogey instead;
	say "You can't find anything specific to scan, and nothing shows up on your settler." instead;

to say hit-win: [?! bad idea for spacing]
	say "[if cheat-on is true]RGPRGR[else]RYRRYP[end if]"

to say ben-hid:
	say "[if cheat-on is true]PGRYRP[else]RYRYRR[end if]"

volume big lumpy rules

chapter going

check going nowhere (this is the towers-mis-go rule):
	if mrlp is towers:
		if noun is inside or noun is outside:
			say "You can't go in, here." instead;
	if cliff is visible:
		say "The cliff is in the way. There's no way to climb it--the scope in the copse [if spec-o-scope is unexamined]may point where you need to go[else]didn't indicate you needed to[end if]." instead;
	if shoals are visible:
		say "Even if you were a swim swami, you'd wind up aslosh on the shoals." instead;

upwarned is a truth state that varies.

check going nowhere (this is the spam can't go that way rule) :
	if upwarned is false:
		if noun is up or noun is down:
			say "You can't go that way[if mrlp is demo dome and player is not in sparse spares], though Sparse Spares is a room away and down[else]. In fact, you almost never have to go up or down in this game[end if].";
			now upwarned is true instead;
	repeat through table of nowheres:
		if theloc entry is location of player:
			say "[thereject entry][line break]" instead;
	if number of viable directions is 0:
		say "You can't go that way--in fact, you can't go any way here. This is a sort of puzzle room." instead;
	else if number of viable directions is 1:
		say "You can only go [if room noun of location of player is visited]back [end if][list of viable directions] here." instead;
	else:
		say "You can go [list of viable directions] here." instead;
	if noun is outside:
		say "Exiting is ambiguous--if there's only one direction, you'll take it, but otherwise, the cardinal directions usually work better." instead;

table of nowheres [tnw]
theloc	thereject
Basement	"You can probably go back up, or you can go in if you're ready to face what's beyond."
stable	"No time for mooching around the manor. You probably need to take [if sitar is visible]a[else]that[end if] secret passage in, or down."
highest heights	"You can go back IN to the study, though you don't need to, or you could try [if ramp is visible]to get the pram out of the way[else]going DOWN the ramp[end if]."
Strip of Profits	"Why run off for fun? See [if number of visible portals is 0]what one of those stores can become[else]what's in one of those portals[end if] instead." [manor]
Cruelest Lectures	"The trumped-up charges and the teleological lectures have totally conked your sense of direction. You can, however, TRY to go outside."
Lost Lots	"Outback. You back out."
Ripe Pier	"You've lost all sense of direction here, but you need to figure how to get on that boat." [routes]
Sun-Spared Underpass	"Far into A rift? No. You can't [if darkness is visible]see far enough to [end if]rely on directions, here[if darkness is visible]. You just need to find No-Gal Logan[end if]."
Cripple Clipper	"[if noun is inside or noun is down]Locked ol['] deck. No bowel on below.[else]Drowning ails or roils a sailor.[end if]"
Idle Deli	"Nowhere to go but out. Yup, not only does this restaurant lack ambiance, but it also lacks washrooms."
Adobe Abode	"This do be a one-room place. You can really only go outside."
Loather Rathole	"[if cold is reflexive]You're too cold. While haste heats, the new random direction would offer no more [i]heat[r] than here.[else]You've got to race after that guy, but you wonder if it really matters.[end if]" [troves]
Used Lot	"[if noun is down]Yes, the cellar is down, but you can't remember WHERE the passage down to the cellar is.[else if post is reflexed]You haven't figured a way to get to the cellar, man. Running away won't help.[else]You can't run from this big fight now that you've traced the robber![end if]"
Boredom Bedroom	"You need to look at something that would inspire you to move, instead."
Dour Tan Rotunda	"You are definitely going places, but you aren't going places by actually WALKING. Perhaps if you meditate on that brochure."
Econ Cone	"That could lead to ransom manors."
FiefCo Office	"You're at the very top. You don't really want to change that without really good motivation."
Burnt Brunt	"East or west would be an alpinist tailspin ('CHARGE! Eh, crag.') Try north or south, instead." [presto]
Dirge Ridge	"The vile veil seems to almost repel a leaper except where it opens to the north. Note if it were an evil veil, it would probably pull you down the side of the ridge. Lucky you!"
Austerer Treasure	"The treasure room has no secret passages--so you can only go back east."
Marines Seminar	"The camo-coma fields are just obvious enough to anyone paying attention, for legal reasons. Plus, either you are awake enough to see them, or you get too tired to walk into the center. West is the only way out."
Posh Hops Shop	"[if noun is not outside]You just got here, so direction means nothing. So you can only really go out, but those trolls will just coax you back inside. Unless you can out-cool them[else if silly-acts is 3]You try to make a dash, but you're not smooth enough. The trolls hold you back and ask you to explain yourself[else if silly-acts is 2]You start a bit too herky-jerky towards the exit. 'Forego, goofer,' says one of the trolls. 'You too good for this place?' Nonchalance is required here[else if silly-acts is 1]The trolls glare at you--they know you've been disruptive--but they've seen worse and are still blocking the way out[else if silly-acts is 0]The trolls are blocking you from going out. You'll have to exit the Posh Hops Shop more smoothly[else]BUG--you annoyed people too much. You should've gotten killed. Please let me know how you did this[end if]."
Lean Lane	"You can only go back west, or you would risk running into a mesh crab chambers or a crab crib full of bric-a-brac." [oyster]
Handsome Sand Home	"Though you are a guest, probably best not to go poking around. You can go back west."
Lapsin' Plains	"You can only go back south, or[if door-sux is false], once you defeat the door,[end if] inside."
Achers' Arches	"You can only go north to the Hedron[if sardine is in arches], once the sardine is gone,[end if] or east back to Anger Range."
Hedron	"The main exit is south, though some enclosed place is west, too. It'd be a tougher hedron to guard if it had lots of exits. Well, you can also go IN to the [if a-p is visible]portal[else]ol['] trap once you disarm it[end if][if walleyes are visible], though you probably don't need the walleyes watching you try[end if]."
Tenfold	"While you can go back outside, you can just finish things here[unless-max]."
Loftier Trefoil	"[if rodney is visible]One look from Rodney, and you stay put[else]Taverns are generally meant to make you forget compass directions, among other things. You probably just want to go out[end if]." [towers]
Topside Deposit	"The badlands are too dangerous any way but[if scope copse is visited] back[end if] north[if Ray Eck is visible], and Ray Eck's in the way right now[end if]."
Campsite	"Oh! This is such a nice place! But other than back east, all ways are perilous! Perilous!"
Coastlines	"You can't get across Leak Lake without some sort of craft[if jetskis are visible], like the jetskis, which Dirk will let you take[end if]."
Outer Route	"The route can't lead anywhere good. Or at least anywhere nearer the castle."
Lost Lots	"Going anywhere but north would get you really...lost."
Subsector	"If you could go any way other than back west, the subsector wouldn't be obscurest, now."
Shaven Havens	"Any direction but back east might drive you too far from the palace."
Alcoves	"You sway to the side, not ready to face the menace to the west." [otters]
Loop Pool	"The pool is wide and long. You can only go back south."
Reclusion Inclosure	"Even without the raw-bulk bulwark that way, Elvira wouldn't let you anywhere into her private chambers. Neither will her creations. Maybe you can sneak back east."
Rustic Citrus	"[unless player has compass]You try to go north by not going north, but everywhere's a border, arbored[else if swell wells are unvisited]That's not north, according to your compass[else]You can only go back north to the wells[end if]." [others]
filed field	"[if b-w are visible and noun is west]The barriers west block you. Maybe you can get rid of them.[else]With all the foilage foliage and [if-fence], the only way to say I fled is to go back east.[end if]"
Scape Space	"The scape space is pretty sparse. No spare rooms, restrooms, anything. You can only go back up."

to say if-fence:
	say "[if ppf is visible]the pipe panel fence too[else]even without the fence[end if]"

to say unless-max:
	let my-tot be poss-score of oyster - cur-score of oyster;
	if lever is reflexive:
		decrement my-tot;
	if dialer is reflexive:
		decrement my-tot;
	if d2 is reflexive:
		decrement my-tot;
	say "[if my-tot is 0], and you've done everything else[else], or maybe you can look around to get more points[end if]";

volume urgent Gunter

Urgent Gunter is a terse person. "Urgent Gunter is here, but you shouldn't be seeing this text, so that's a bug. [bug-report]"

description of Gunter is "He actually looks a bit worried, for once. Usually, his smile is just a little too wide, but you miss that now."

the litany of Urgent Gunter is the table of Gunter comments.

okay-thats-it is a number that varies.

diorama-flip is a truth state that varies.

tried-flip is a truth state that varies.

to decide what number is stuff-found:
	let mytemp be 0;
	if gunter is in lalaland, decide on 3;
	if thinko is true, increase mytemp by 2;
	if sad ads are examined, increment mytemp;
	if player has pedanto-notepad, increment mytemp;
	if notice is examined, increment mytemp;
	if bookshelf is examined, increment mytemp;
	if diorama-flip is true, increment mytemp;
	if tried-flip is true, increment mytemp;
	if pad-consult is true, increment mytemp;
	if mytemp >= 3:
		now mytemp is 3;
		decide on mytemp;
	decide on mytemp.

every turn when location of player is dusty study and stuff-found >= 3 (this is the Gunter Knocks rule):
	if urgent Gunter is off-stage:
		increment okay-thats-it;
		if okay-thats-it is 6:
			say "You're sick of the knocking, so you just answer the door, already.";
			try opening side door instead;
		say "[one of]Whoah! Bangish bashing at the door[it-door]![or]The bangish bashing continues.[stopping]";

to say it-door:
	set the pronoun it to the side door;

volume intro

book Dusty Study

to say tables-beams:
	if tables are in study:
		say "[if tables are in study]tables (the spreadsheety kind) on one wall[else]a way OUT where the tables were[end if], and [if t-b are in study]beams on another wall[else]a way down where those beams were[end if]";

Dusty Study is an innie room in Roman Manor. "[one of]Your study's not very sophisticated, but it's you. That doesn't mean you're not very sophisticated. But you were sophisticated enough to know that.[paragraph break][or][stopping]It's a bit messy here, with a diorama hanging down. There's a bookshelf way too large to move, [tables-beams]. A rich chair [if pedanto-notepad is on rich chair]holds your pedanto-notepad[else]is here, too, holding some sad ads[end if][if thinko is false and gunter is off-stage]. It's a good place to just THINK[end if][if Gunter is in lalaland]. After your sleep, you remember you built some secret passages[end if][if gunter is in lalaland]. You'll want to take them[else]. You came in through your super-secret side door, and you don't feel like going back out, yet.[end if][if bean-smell is true][paragraph break]You smell something, and you hear something, too. Probably from outside, but you don't want to go out there.[end if]"

rule for printing the name of a dark room: say "No light-glint, oh!"

rule for printing the description of a dark room: say "[one of]You can't see much. You're pretty sure you forgot to replace the bulb on a usual light source, so you'll need something else.[or]Still, no light source.[stopping]"

the player is in Dusty Study.

a rich chair is useless scenery in Dusty Study. "You thought you preferred a recliner but this is real. Nicer. It guards against cushionless slouchiness. Its backrest is shaped like brackets, and it's from Art Beck's. Small things can get lost in it[if pedanto-notepad is on chair]. Like your pedanto-notepad, just sitting on it[end if][if latches are off-stage]. In fact, it seems a bit lumpy now[end if]."

the sad ads are plural-named scenery. "[one of]The ads aren't sad because they're drab but rather because so many people fall for them. And they're not even magically possessed. This is the price of prosperity, and yet... One[or]Another[stopping] ad [hawk-blare]."

understand "ad" as sad ads.

instead of taking sad ads:
	say "You're not in the mood for bargains. You can examine them if you like."

instead of doing something with the sad ads:
	if action is procedural:
		continue the action;
	if current action is taking:
		continue the action;
	say "There's not much to do with the ads other than reading them.";

check examining sad ads for the first time:
	say "It's impossible to look away...advertising certainly has gotten more prominent since Elvira arrived. She's been so good at saying you need to advertise, and yet--she does not need to. Apparently she is quite a consultant for opposing ad firms.";

does the player mean entering the rich chair when Gunter is off-stage: it is very likely.

check entering rich chair:
	if latches are off-stage:
		try searching rich chair instead;
	say "You're too restless right now." instead;

check searching rich chair:
	if latches are off-stage:
		say "Ah, so that's what that lump is. Some latches, from Old Man Almond, who helped you when you first arrived. But what're they good for?";
		now player has latches instead;
	else:
		say "You find nothing further in the chair." instead;

carry out examining rich chair:
	ignore the examine supporters rule.

instead of doing something with chair:
	if action is procedural:
		continue the action;
	if current action is pushing or current action is pulling or current action is climbing:
		if niche is visible:
			say "You don't need to climb the chair--at least, not until you find a way up through the ceiling." instead;
		else:
			say "You climb on the chair to go up.";
			try going up instead;
	say "[if gunter is in lalaland]The chair can't hide an exit out of here[else]It's nice, but you can't do much with it, and you're too antsy to sit in it[end if]."

to say study-blah:
	if Gunter is in lalaland:
		say "[if tables are not visible]. You could probably go [b]in[r], to the stable, with the tables gone[otherwise]. Some tables are propped up against a side wall[end if][if t-b is visible]. Some beams on one wall seem worth looking closer at[else]. You also cleared a path [b]down[r] to the basement[end if]"

report taking pedanto-notepad:
	say "Good choice taking the notepad. It'll help you tame lots that's meta, mate.";
	move-ads instead;

to move-ads:
	now sad ads are in lalaland;
	say "Taking the pedanto-notepad uncovered some sad ads on the chair.";

instead of pushing or pulling or searching or opening or closing bookshelf:
	say "There's no secret passage behind it. And if there were, you couldn't move it. It's got about [book-est] books, after all."

estim is a number that varies.

to say book-est:
	if estim is 0:
		now estim is number of rows in table of random books;
		increase estim by a random number between 0 and 99;
		now estim is estim / 100;
	let base be estim / 10;
	let rema be the remainder after dividing estim by 10;
	if base > 0:
		say "[base in words] thousand";
		if rema > 0:
			say " [rema in words] hundred";
		continue the action;
	say "[estim in words] hundred or so";

the bookshelf is amusing scenery in dusty study. "[one of]It's engraved READING A DINGER, I GANDER and sturdy enough to withstand any magic transformations. It's far too heavy to move to make a secret passage, what with [book-est] sloven novels (writing and appearance) you just got SENT, somehow, from trailery to literary discouraging infectious fiction use--the titles blur so fast through your mind, the oeuvres overuse--well, YOU know. Story tyros TRY so.[paragraph break]On glancing at some of the more ridiculous pen names, you also remember how FameHints NameShift and Smokiner Monikers were both allegedly a subsidiary of Elvira's MoneyCo. Nothing proven, and the journalist...well, they haven't written anything lately.[paragraph break]One book you won't remember next move is [or]Another book you won't read. [stopping][i][randbla][r]."

understand "shelf" and "books" as bookshelf.

instead of taking bookshelf:
	say "[if Gunter is in lalaland]None of the books could really help you[else]You would have trouble choosing just one. You wonder if any are any good[end if]."

check exiting in dusty study:
	try going outside instead;

geez-already is a number that varies.

every turn when dusty study was not lit and lamp is off-stage (this is the clue lamp rule):
	if palm is prefigured:
		increment geez-already;
		if geez-already is 5:
			say "You're sick of this stumbling around, so you just flip the palm to a lamp, already.";
			try fliptoing lamp instead;
		say "Hm. You didn't need to change that palm to a lamp before, but it might be a good time, now." instead;
	say "[one of]Usually, in situations like this, you go in for a four-letter word. But an obscene one wouldn't help much here.[or]No use to blub til you produce a lit bulb. Or, better, something that contains one.[or]You need to get light. What's a good plam (sic)?[or]You have ampl (sic) power to change the lamp into something else, you know.[or]You remember changing a toga into a goat before you ever entered Yorpwald. Perhaps the same sort of thing would work here.[or]You remember how a school cafeteria cashier named Pam L. used to light up everyone's day. Well, halfway.[or]There are only 20 possibilities for what the lamp can change into, minus the clues I've already given.[or]Getting lampshady about your special power has made me feel shady.[or]Oh, for a Light Activating Movable Paraphernalia![stopping]"

before going nowhere in dusty study:
	if study is not lit:
		say "You can't really go much of anywhere. You remember secret passages in this study, but you'd probably stumble into that [i]palm[r] first in the dark." instead;
	if Gunter is off-stage:
		say "[if stuff-found is 3]You shouldn't just run away when someone is knocking[else]You're just in the mood for quiet time, now, just looking around[end if]." instead;
	if noun is down:
		say "[if Gunter is off-stage]Yeah...you do have somewhere to hide., but no full excuse, yet[else]There's a room below. What's it called, again? Boy[end if]." instead;
	if noun is outside:
		say "You don't want to go outside, and you don't want to walk around where you might be seen[if Gunter is in lalaland], especially after that chat with Gunter[end if]." instead;
	say "You always lose all sense of direction in your study. You generally just think of it as a place you can go into or out of. There [if t-b are visible]may be[else]is[end if] a passage down, too. Hard to forget how down works[if niche is visible]. Maybe there's something above, too[else]. You can also shimmy [b]UP[r][end if]." instead;

Rule for printing the description of a dark room (this is the dusty study rule):
	if location of player is dusty study:
		say "Man, you're still trying to get your bearings. You probably can't go stumbling around--you'd poke your eye on that palm, or something. Wouldn't be bright." instead;

the giant pin is a semi-easy LLPish thing in Dusty Study. "A giant pin (bowling) hangs on the wall here.". description is "Man, it's a giant pin. Cardboard, too. It's never managed to bowl or blow over any guests despite being surprisingly artsy."

instead of pushing or pulling giant pin:
	say "It won't budge. It's too thin to hide a way out, too.";

understand "nip" as a mistake ("Maybe if it weren't a giant pin. Well, giant enough to hide a wall safe.")

a-text of giant pin is "RYYRRYRR". b-text of giant pin is "RYYPPYRR".

instead of taking giant pin:
	say "That'd be dreadfully impractical. It's too [i]giant[r] a t'ing.";

the abstract painting is a useless LLPish undesc. "That painting you changed from a giant pin hangs here."

instead of doing something with abstract painting when abstract painting is visible:
	if current action is taking or searching or attacking:
		say "It's a false law there has to be a wall safe behind it. Besides, [if Gunter is off-stage]the person knocking might see what you're doing[else]you got enough goodies so far[end if]. You remember it was sort of based on parts of your manor." instead;
	unless action is procedural:
		say "The painting's really just there to be observed. Like most art." instead;
	say "The painting gives no pure-art rapture, though you muse 'Quite an antique. I put it up.' and notice a place where horses are kept, a roof with smoke rising, and a downstairs living place. It's not exactly worth looking at in detail, but it's just good to know it's there.";

propaganda is a kind of thing. propaganda is usually amusing.

the dope op-ed is propaganda. "That 'dope' op-ed Gunter threw at you landed here. It's a lot longer than your usual op-ed, probably terribly overwritten, but possible to enjoy if you like that sort of thing.". description is "The dope op-ed is broken into several pages. It's by Elvira, and it's apparently tackling you on your own ground. The pages are labeled nitro-intro, questin['] inquest, MoneyCo and Economy, Shatter-Threats, [if player is male]I Trash His Art[else]Her Arts Er Trash[end if], and By Li'l Billy."

understand "pedo" as a mistake ("[one of]Yep. It's probably part of Elvira's reject-and-retreat, insinuating something without proving it. One of her 'clever' games[or]Don't dwell on it. It's lies[stopping].") when player is in study and op-ed is in study.

the Nitro Intro page is propaganda. it is part of the dope op-ed. the printed name of nitro intro is "Nitro-Intro page".

description of nitro intro page is "Elvira lays out that she is clearly aliver in her introduction, where she will beat you at your own game.[paragraph break]She notes how Penal Panel--panel IX--explain the Porter Report--the questin['] inquest on your life file. The media aimed you with RELATED! ALERTED! REQUIRES QUERIERS. Governor Ron Grove found taint--a tint. Ties to the Postage Gestapo. Recommended a deport-o-torpedo. Senator Ron East said can't snore at treason.[paragraph break]No hot-plate hate plot on! Elvira is dedicated to making Yorpwald safe, not just from outside forces, but from the influx of silly old anagrams and the LIKELY PERSON BEHIND THEM--a certain reruns nurser! Someone who resorted to boring old anagrams a computer could crank out.[paragraph break]She also notes she will refrain from calling you the obvious name she COULD in an op-ed, because she has class. But really, oppo = poop."

the Questin' Inquest page is propaganda. it is part of the dope op-ed.

description of Questin' Inquest is "[one of]It's headed Good deeds? Sodded ego! Elvira lays out how you saved Yorpwald and all. But everyday stuff? You couldn't repair a flat tyre with flattery, make custard out of car dust or spumoni from an ion sump. Or even a cellphone from cellophane.[paragraph break]You pause. That's so contrived. What kind of faker-freak would think that up?[or]It's no less annoying the second time around.[cycling]"

understand "questin" and "questin inquest" as inquest.

a thing called the MoneyCo and Economy page is propaganda. it is part of the dope op-ed.

description of MoneyCo is "Elvira notes Yorpwald's more profitable than ever! What's good for MoneyCo is good for Yorpwald! The motto 'Come Yon, Con Em, Yo!' is a coy omen. If there were fraud, it'd have been found out. But one day MoneyCo will deserve to be MyOneCo! I mean, think about it. Elvira is cool. Money is cool. Elvira deserves money! And of course the Trips Strip deserved to become the Strip of Profits! It rousts tourists! Gets us guests!"

The Shatter-Threats page is propaganda. it is part of the dope op-ed.

description of Shatter-Threats is "[one of]Elvira notes all political parties have agreed on a do-pry law for Yorpwald. The Swanker Wankers and Ruthless Hustlers and even the fringe Smugger Muggers and Ballsier Liberals. Sporto-troops, rowdies, weirdos gave statements, testaments. It's to fight Evil-Ra, who is everywhere, even if we can't see him, and worse than Ol['] King Jim. We need the Tautest Statute yet. A polished shield-op. Dragnet Granted for Unclear Evils Surveillance. To Finger Fringe so the homeland doesn't become a [d-word] hole, a lamer realm, a stage-one stone age. Everyone's a suspect, including--or especially you. Elvira points out there are only so many nouns LEFT to change, making you a bit useless. But there is a chance you could mess things back up if you were jealous of her popularity.[paragraph break]Besides, it's not like it's the RESTRICT-STRICTER law![paragraph break]There's a bit more.[or]She notes yours was an insecure sinecure. Nice? Sure. But four out of five leading intellectuals, stuffy or non, agree what she has remade should not be reamed. She also notes the law doesn't prevent you from flipping stuff in your own home--just don't get any ideas.[paragraph break]Plus GOOD IDEA has no meaningful anagrams. Worth thinking about![cycling]"

The I Trash His Art page is propaganda. The Her Arts Er Trash page is propaganda.

description of I Trash His Art is "[artrash]". description of Er Trash is "[artrash]".

to say artrash:
	say "[one of]Elvira offers an apology for not seeing to the heart of the matter about all your anagramming. Oh, sure, she had clever opinions about whether obvious anagrams were better than non-obvious ones, and she changed around, and she's glad people found them interesting, but really, it's kind of nerdy now that your good deeds were DONE. Lots of examples, ahead[or]Elvira lists games that don't make kids or concerned parents happy. Mega Mage Game (e-mag: a gem!) as well as many others: [twiddle of table of lame computer games and 4][paragraph break]She blames you for the games['] technical and aesthetic faults, mainly due to the anagram craze you never quite discouraged[or]Elvira discourses on rap music. 'Rap music is, um, [crap]. Funky? F'n yuk! Pop stars, stop raps!' She lists D.J. JD as even worse than [twiddle of table of bad rappers and 4]Geez! So many horrible 'musicians.' The 'hits,' too[or]Elvira has harsh words for other genres, yet they keep cranking things out! [twiddle of table of lousy hit songs and 5]You...you find yourself agreeing with her, but you never commissioned any of that[or]Elvira ravages the rigidness of music in general. All the latest...hits. Mourning oldies soiled by Chas Cash-Asch and his Sex Rime Remixes, and how SOMEONE with word power (guess who) makes the fliest stifle itself. Though she praises Ariel V's album [i]We Do No Wooden Ode Now[r], she rips the same ol['] lame-os: [twiddle of table of oldies singers and 3][or]Elvira 'begs the question' of who is getting a lot of royalties! Someone probably in a nice cosy hidden manor! She finishes by berating the Klaw Walk and Bungie Beguin as dumb dances[or]Elvira shows little respect for comedians like [twiddle of table of comedians and 1]--that pissant is pants--but also [twiddle of table of comedians and 3] even/especially if they make jokes about you. It is too easy. While those about her fall flat or generally have to paint her in a favorable light[or]Elvira eviscerates dummies['] mediums that produce movies like [twiddle of table of lame movies and 3], but there's the small screen too...[or]They're just unbearable, TV shows like [twiddle of table of lame tv shows and 3]. Even stuff rated g grated--that's the end of THIS article, thankfully[drt][or]No. Really. You don't want to read it again. She always seems to know which way the wind is blowing, then she blames you for it[stopping].[no line break]"

dope-read is a truth state that varies.

to say drt:
	now dope-read is true;

The By Li'l Billy page is propaganda. it is part of the dope op-ed.

description of Billy page is "Next to no text. Gross caricatures of you, by Li'l Billy, in the Tenure Tureen: NEUTER! Deserve Severed!, or Elvira as archon and you as anchor. Re: tha heart-hater. MESSIAH AMISS, HE IS? SHAME!!!"

instead of doing something with propaganda:
	if current action is taking:
		say "You don't need to take that blunt-lie bulletin, or any part of it. You don't need to take the insults therein, either, unless you really want to." instead;
	if current action is examining or reading or objhinting:
		continue the action;
	if current action is scaning:
		say "Err, yeah, scanning is MUCH better than close reading in this case.[paragraph break]Oh, wait, you meant with the settler? Nothing shows up." instead;
	say "The propaganda's not good for much other than reading. It's not really good for reading, either." instead;

dope-idx is a number that varies.

after fliptoing when player is in dusty study (this is the more min points in study rule) :
	if noun is t-b:
		now basement-backpedal is false;
		if tables are in lalaland or niche is in lalaland:
			d "Min point for tables or niche.";
			min-up; [already have way out of study]
			if sitar is in lalaland or pram is in lalaland:
				d "Min point for [if sitar is in lalaland]sitar [end if][if pram is in lalaland]pram [end if].";
				min-up; [already have way out of study]
	else if noun is chimney:
		if t-b is in lalaland or niche is in lalaland:
			min-up;
	else if noun is tables:
		if t-b is in lalaland or niche is in lalaland:
			min-up;
	continue the action;

after fliptoing ramp (this is the check ramp min-up rule) :
	if tables are in lalaland and sitar is in lalaland:
		min-up;
	else if t-b is in lalaland:
		min-up; [check if passage is made via beams or stable->stair]
	continue the action;

after fliptoing sitar (this is the check sitar min-up and exits rule) :
	now Basement is mapped below stable;
	if the room below study is nothing:
		now study is mapped above Basement;
	if t-b is in lalaland:
		min-up;
	else if niche is in lalaland and pram is in lalaland:
		min-up; [check if passage is made via beams or chimney->pram]
	continue the action;

chapter side door

the semi-secret side door is scenery in Dusty Study.

answer-warn is a truth state that varies.

check answering:
	if answer-warn is false:
		now answer-warn is true;
		say "This game generally uses ASK X ABOUT Y instead, unless you are in a conversation with numbered choices[if haunter is visible or kid is visible]. However, the X, Y syntax can work here[end if]." instead;
	else:
		try asking noun to try taking inventory instead;

does the player mean opening side door: it is very likely.

description of semi-secret side door is "[one of]Oh, man, I can't really tell you. It's yours, and it's a secret, and I would've had to, like, violate your property rights to be able to describe it better than you could. Okay, i[or]I[stopping]t's an innocuous door that looks like boring aluminum siding from the outside. It has a peephole, too."

the peephole is part of the side door. description is "Starin['] strain... [one of]People? Eh? [or][stopping][if Gunter is in lalaland]Shouty youths outside, chanting something[else if stuff-found < 3]Nobody[else][one of]You see Urgent Gunter behind. He's one of the biggest messengers in Yorpwald. You haven't seen him in a while. He must have something important for you[or]Urgent Gunter is waiting out there. You should probably invite him in[stopping][end if]."

instead of searching peephole:
	try examining peephole instead;

check opening side door:
	if stuff-found < 3:
		say "You don't feel like going out without a really good reason." instead;
	if urgent Gunter is off-stage:
		say "[if peephole is examined]Urgent Gunter charges in[else]It's Urgent Gunter[end if], full of sensible bileness. '[one of]Pallid li'l pad[or]Stodgy sty, dog[at random]! Elvira wants to see you. About your powers. Me and my pouter troupe agree. Me, best messenger in all of Yorpwald. Hey, if you've done nothing wrong--and it seems like you've done NOTHING since all that shuffling around--you have nothing to hide.'";
		now urgent Gunter is in Dusty Study;
		pad-del "rove over";
		try talking to urgent Gunter instead;
	say "A rallies sallier? With snipers pressin[']? Better not." instead;

chapter palm and lamp

The palm is a thing in Dusty Study. description is "It has spent a lot of time soaking up all that weight is stored in there, to help you one day if you need to break out in the middle of the night or something.". "A palm soaks up sunlight here. For later, maybe."

instead of taking the palm:
	say "It's kind of useless and bulky at the moment.";

a-text of palm is "RYRR". b-text of palm is "RGRR".

The lamp is a lit thing. description is "It's red-framed, with a slightly off-center (to the left) light that flickers from yellowish to greenish--which seems slightly more illuminating--and back[if settler is not visible]. Odd colors. You haven't seen anything like them[else]. Hmm. where've you just seen colors like that, now[end if]."

understand "palm" as a mistake ("Maybe you could, but you will need the light. You won't need the landscaping.") when lamp is visible

check switching on lamp:
	say "It already is. It will last as long as you need it." instead;

check switching off lamp:
	say "You may still need the lamp's light a bit." instead;

chapter latches

The latches are a plural-named super-easy thing. "Some latches--the sort you lock a door with--are jumbled together here."

instead of opening the latches:
	if treatise is off-stage:
		say "(fumbling and seeing a prepared red paper fall out, which you take)";
		now player has treatise;
	say "You can't figure how to open them. The latches are a Gordian knot, and you probably mix up where to start or end, but maybe the red paper has more information on what to do.";


understand "chalets" as a mistake ("You don't need a safe home, right now. You need adventure[if latches are visible]. Oh, and you don't have to switch that many letters, either[end if].") when latches are visible or satchel is visible.

to trea-check:
	if treatise is not visible:
		say "As you [if current action is taking]take the latches[else]look closer[end if], you see a wad of prepared red paper contained in the latches and pull it out. It looks stained with tears[if player does not have latches and current action is examining]. You take the latches, too[end if].";
		now player has treatise;
		if player does not have latches:
			now player has latches;

check taking latches:
	if player has latches:
		say "You fiddle with them uselessly for a bit." instead;
	trea-check instead;

after examining latches:
	trea-check;

description of latches is "They're knotted hopelessly--you won't be able to un-knot or untangle them or whatever by natural means. [if teariest treatise is unexamined]They probably become something or other, or Gunter wouldn't have given them to you[else]The letter said they might be carrying something, but you don't see anything inside[end if]. Weird."

understand "prepared/ red/ paper" as teariest treatise.

to say dear-reader:
	if treatise is examined and satchel is visible:
		say "(Stuff about getting the satchel that you don't need to reread.)";
		continue the action;
	say "Dear, er, Reader: Apologies for any sucky yucks. I couldn't have sent tens of snug gnus, sought toughs, or any gubbins subbing for you. These latches, shut thus, contain a recoded decoder, a revised deviser. Help make your tour a rout. Not that it emits smite. Have a peek, then keep, to help lift the doom mood in Yorpwald. But you'll need to be refined, definer. Just changing things to other things, relived, won't deliver. It's powerful, too. My magician-lawyer Drab Brad warned me creating it would drain my life force. But I feel great!";

the teariest treatise is a thing. description is "[dear-reader][line break]Even without cheat mode, it's pretty handy, because it shows the letters [i]should[r] be either...[one of][paragraph break]The note ends abruptly. You stare. Tears. Eyes watery yet raw. Arg. Life. Fragile.[or][paragraph break](Yes, the old timer is a time lord now.)[stopping]"

understand "letter" as treatise.

a-text of latches is "RYRRRYR". b-text of latches is "RGPPPGR".

the satchel is a thing. description is "You doubt it holds anything else in its folds.". "The satchel you managed to conjure lies useless on the [if player is in stable]ground[else]floor[end if]."

a-text of satchel is "RYRRRYR". b-text of satchel is "RGPPPGR".

check inserting into the satchel:
	ignore the can't insert what's not held rule;
	say "The purse is much handier." instead;

instead of taking satchel:
	say "It may achieve sentimental value one day, but the purse will carry more."

chapter ten beams

instead of taking t-b:
	say "They're too solid to move, physically.";

The t-b are privately-named plural-named vanishing scenery in Dusty Study. understand "ten beams" and "ten" and "beams" as t-b. the printed name of t-b is "ten beams".

understand "net" as a mistake ("But the net would still block you.") when player is in study and t-b are in study.

a-text of t-b is "RYRYRYRR". b-text of t-b is "RYRYRYRR".

instead of searching t-b:
	say "Nothing. And you checked all ten beams.";

understand "best name" and "bestname" as a mistake ("Hm, you're pretty sure the beams guard something below. What's the best name for a room that's below? (You note the first and third squares on your settler turn purple as you think of the best name.)")

description of t-b is "You count them. One, two, ..., ten. Exactly ten beams lined up together, unpainted and uncovered. What could they be hiding?"

chapter tables

The tables are plural-named vanishing scenery in Dusty Study. understand "table" as tables.

after fliptoing tables:
	now study is mapped inside stable;
	now stable is mapped inside study;
	continue the action;

after fliptoing t-b:
	now Basement is mapped below study;
	now study is mapped above Basement;
	continue the action;

instead of pushing or pulling tables:
	say "They're not that kind of tables. They're tables drawn on the wall."

table-warn is a truth state that varies.

before doing something with tables when table-warn is false:
	if the player's command matches the regular expression "\btable\b":
		now table-warn is true;
		ital-say "it's important that the tables are plural, as you [if cur-score of manor is 0]may find[else]already found[end if].";
	else:
		continue the action;

a-text of tables is "RRYRRY". b-text of tables is "RRYRRY".

description of tables is "[one of]They are tables of the ablest bleats--they look like outright vandalism, all in red, but you know you wrote them there a while ago, and you're sure there's a reason. Maybe if you look at them more, it'll be evident[or]They were verified by LabSet technologies with their BeLast algorithm--writing in red--with a bit more below[or]Instructions to eBlast the tables is written below in red[or]The data in the tables seems quite possibly shifted over a row[or]The more you look, the clearer it is the data is very un- ... oh, that would just open the barn door, to say it outright[cycling].";

to decide whether you-can-stableize:
	if tables are in dusty study:
		decide yes;
	decide no.

check going in study:
	let need-line-break be false;
	if room noun of study is not nowhere:
		if latches are in study:
			say "You take the latches--they must be useful for something[if player does not have treatise]. There's also a tear-stained paper bound up in them. You pull it out[end if].";
			now player has latches;
			now need-line-break is true;
		if pedanto-notepad is on a rich chair:
			if need-line-break is true:
				say "[line break]";
			say "You[if need-line-break is true] also[end if] swipe your pedanto-notepad, since it was so helpful your first time shuffling around in the Forest and Sortie and Metros your first time through Yorpwald.";
			now player has pedanto-notepad;

book diorama

before examining when Gunter is off-stage and stuff-found is 3:
	if noun is diorama or noun is part of diorama:
		say "The diorama is too intricate to observe in any detail with the knocking at the door." instead;
	if noun is bookshelf:
		say "You couldn't read--not even just titles--with that knocking at the door." instead;

the diorama is a backdrop. "[one of]Yes, you remember when Old Man Almond gave it to you. You've half forgotten it's here, now, but he said one day, just in case, it'd be useful. For simpler prelims than your first time shuffling around.[paragraph break][or][stopping]It's a loose conglomeration of [if platform is part of diorama]a platform[else]a farm plot[end if], [if pavement is part of diorama]some pavement[else]an event map[end if], [if pedestal is part of diorama]a pedestal[else]a steel pad[end if], and [if crabgrass is part of diorama]some crabgrass[else]a brass crag[end if]. A notice down the center reveals what these items can become."

after scaning when player is in study (this is the pad-diorama rule) :
	if noun is part of diorama:
		pad-rec "diorama";
	continue the action;

does the player mean examining the steel pad: it is unlikely.

to say dior-scan:
	if screenread is true:
		say "This may be an info dump if you are visually impaired. Go ahead?";
		if the player consents:
			do nothing;
		else:
			continue the action;
	say "R=red Y=yellow P=purple G=green.";
	say "[fixed letter spacing]";
	repeat with prt running through ramabits:
		now prt is ncscanned;
		now prt is cscanned;
	say "[scans of platform and farm plot]";
	say "[scans of pavement and event map]";
	say "[scans of pedestal and steel pad]";
	say "[scans of crabgrass and brass crag]";
	say "[r]";

to say scans of (a1 - a thing) and (a2 - a thing): [?!?! not work with visual impair]
	let sp be "        ";
	if a1 is not escanned and a2 is not escanned:
		continue the action;
	say "[line break]";
	if a1 is crabgrass:
		now sp is "         ";
	if screenread is true:
		if a1 is ncscanned:
			say "[a1] to [a2] is [a-text of a1].";
		if a2 is ncscanned:
			say "[a2] to [a1] is [a-text of a2].";
		if a1 is cscanned:
			say "[a1] to [a2] is [b-text of a1].";
		if a2 is cscanned:
			say "[a2] to [a1] is [b-text of a2].";
	if a1 is ncscanned or a2 is ncscanned:
		say "[sp][if a1 is ncscanned][a-text of a1][else][sp][end if][sp] [if a2 is ncscanned][a-text of a2][else][sp][end if][line break]";
	say "[a1][dashy of a1][a2][if a2 is escanned][dashy of a1][a1][end if][line break]";
	if a1 is cscanned or a2 is cscanned:
		say "[sp][if a1 is cscanned][b-text of a1][else][sp][end if][sp] [if a2 is cscanned][b-text of a2][else][sp][end if][line break]";
	else:
		say "[line break]";

to say dashy of (a11 - a thing):
	let spcs be 0;
	increase spcs by the number of characters in "[printed name of a11]";
	decrease spcs by 8;
	say "[if spcs is 2]-[end if][if spcs is 1]-[end if]------->";

check taking crabgrass:
	say "No need for a crass grab." instead;

niche-found is a truth state that varies.

after examining diorama when player is in study and niche-found is false:
	now niche-found is true;
	say "Oh, hey, there's some words on the ceiling. MY NICHE. Wonder what those could be." instead;

the niche is flippable scenery in dusty study. "The words MY NICHE have a square dotted outline around them."

understand "my niche" and "my" as niche

after examining niche:
	say "It sounds like there's whistling from the niche, but only if you listen very closely. Have a listen?";
	if the player consents:
		say "A haunting ice-hymn coming through the dotted outline--or maybe the words you imagine--leaves you red-eyed.";
	else:
		say "Okay.";

understand "ceiling" as niche.

a-text of niche is "RRYRRYO". b-text of niche is "RRYRRYO".

instead of doing something with niche:
	if action is procedural:
		continue the action;
	say "It's too far away to meaningfully interact with.";

the chimney is scenery. "It's where your niche was. You can probably put your chair on the bed, then climb the chair to reach it. I won't even make you spell out the details. Just go [b]up[r]."

before going up in study:
	if niche is in study:
		say "Hm, the letters saying MY NICHE indicate something could be there. Hm, what." instead;
	say "[one of]I'll skip on the whole piling your chair on the bed bit. Though actually it's kind of fun, jumping up and down to pull yourself up. The chimney has enough handholds. You walk through one of your Closest Closets--they provide localized teleporting through your manor--to find yourself high up[or]You climb up again[stopping].";

after fliptoing chimney:
	now highest heights are mapped above dusty study;
	now dusty study is mapped below highest heights;
	continue the action;

instead of entering chimney:
	try going up;

instead of reading diorama:
	try examining the notice;

the notice is part of the diorama. description is "PLATFORM/FARM PLOT[line break]PAVEMENT/EVENT MAP[line break]PEDESTAL/STEEL PAD[line break]CRABGRASS/BRASS CRAG[paragraph break]There's even small print: objects on diorama are to pre-sow powers for instructional purposes and likely contain more letters and flexibility than real life situations."

instead of taking notice:
	say "It's the lowest-hanging part of the diorama, but you don't need it.";

instead of taking diorama:
	say "It's there for practice. You can just fiddle with its parts." instead;

instead of scaning diorama:
	say "You remember now. A diorama was chosen because it couldn't be messed with at some level. But its parts can be."

getall-warn is a truth state that varies.

before taking (this is the dumb take jokes rule) :
	if ed riley has the noun:
		say "'I am not an item yielder!' Ed Riley booms." instead;
	if noun is crabgrass or noun is brass crag:
		say "No need for a crass grab." instead;
	if noun is part of the diorama:
		say "Don't pull the diorama apart. That was a gift! An instructional gift! From a recently deceased father figure!" instead;

a thing can be spacy. a thing is usually not spacy.

a thing can be hinthelpy. a thing is usually not hinthelpy.

the pavement is part of the diorama. the pavement is spacy. description is "It's sidewalk pavement. It seems like something has been written on it, but it's too bumpy to read, especially since the pavement is so small."

a-text of pavement is "YRYRRRYR". b-text of pavement is "YRYRRRYR".

the event map is a thing. description of event map is "You can read it from here--maybe because you remember it, but you can."

after examining event map:
	let bluh be false;
	if screenread is false:
		say "Do you want a text-map view (yes or no)?";
		if the player consents:
			say "[fixed letter spacing]?????
[line break]  |     t
[line break]  v   s r
[line break]+-+-+ t i
[line break]| | | o p
[line break]F I M r s
[line break]| | | e s
[line break]+-+-+ s t
[line break]  |     r
[line break]  v   i i
[line break]  R   n p[variable letter spacing]
[paragraph break]You remember stores A-Z in the Trips Strip and how you cleared F, I and M.";
			now bluh is true;
	if bluh is false:
		say "It's a flowchart that breaks from the Trips Strip into store F (forest,) store I (sortie,) and store M (metros,) before merging at store R, the resort.";
	say "You wonder if there is something in the others now, and if so, what.";

a-text of event map is "RYRYRYRR". b-text of event map is "RYRYRYRR".

the platform is part of the diorama. the platform is spacy. description is "It's one of those speaking platforms that people would stand behind. If it weren't so small."

a-text of platform is "RYRR*RRYR". b-text of platform is "RYRR*RRYR".

the farm plot is a thing. description is "It doesn't actually have any dirt on it or it'd have crumbled long ago. If the words FARM PLOT weren't traced in it, in fact, you'd probably think it was just a dirt road. Hooray for helpful documentation."

a-text of farm plot is "RRYRRYRR". b-text of farm plot is "RRYRRYRR".

the pedestal is part of the diorama. the pedestal is hinthelpy and spacy. description is "Too small to put anything on, but it's a good size for instructional purposes."

a-text of pedestal is "RRYYR*RYR". b-text of pedestal is "RRYGR*RGR".

does the player mean scaning steel pad: it is likely.

the steel pad is a hinthelpy thing. description is "It's really wiry and reminds you that you don't do the dishes often enough. You probably don't have time, now."

a-text of steel pad is "RYRYRRYR". b-text of steel pad is "RYRGRRGR".

some crabgrass is part of the diorama. the crabgrass is hinthelpy and spacy. description is "It might be fake, seeing as how it hasn't died after all these years."

indefinite article of crabgrass is "some".

a-text of crabgrass is "RRYRR*RRYR". b-text of crabgrass is "RPGRR*RRYR".

the brass crag is a hinthelpy thing. description is "It would be majestic if it weren't so miniature. You think. Well, it wasn't meant as scenery."

a-text of brass crag is "RRYRRRYRR". b-text of brass crag is "RPGRRRYRR".

kind-of-cool is a truth state that varies.

spacy-hint is a truth state that varies.

after scaning (this is the init-scan rule) :
	if first-good-scan is true and kind-of-cool is false and noun is not held:
		say "And hey. That was kind of cool. You didn't have to press the settler all up in anything, or anyone's personal space.";
		now kind-of-cool is true;
	if noun is part of the diorama:
		if noun is not hinthelpy:
			say "You switch the cheat button and scan again and flip it back again, but the colors don't seem to change. Maybe that's a hint in itself[one of]. But the reds and yellows must tell you something about what the [noun] is supposed to turn into. Which you already can read on the diorama. Hmm[or][stopping].";
		else:
			say "You switch the cheat button back and forth and notice a few colors change: [if cheat-on is true][spacies of b-text of noun] to [spacies of a-text of noun][else][spacies of a-text of noun] to [spacies of b-text of noun][end if].";
		now noun is cscanned;
		now noun is ncscanned;
	if noun is spacy and spacy-hint is false:
		say "You also notice the black dot (*) -- hmm, the [noun] should become something with a space.";
		now spacy-hint is true;
	continue the action;

book basement

understand "basement [text]" and "[text] basement [text]" and "[text] basement" as a mistake ("You can just [if t-b are visible]change the ten beams by saying[else]go down to go to the basement[end if].") when player is in dusty study and latches are not off-stage.

understand "[text] stable [text]" and "stable [text]" and "[text] stable" as a mistake ("You can just [if t-b are visible]change the tables by saying STABLE[else]go IN to go to the stable[end if].") when player is in dusty study and latches are not off-stage.

Basement-been is a truth state that varies.

Basement is a stairy innie privately-named room in Roman Manor. printed name of Basement is "[bsmnt]". "[one of]Aw, man! This basement was supposed to be a place for solitude, but it was so good at being inconspicuous, even you forgot about it! You see and remember the evac-cave now. It's your way out[or]You can go into the evac-cave here[stopping][if cur-score of manor < 9], though if you're a completist, you may want to poke around the study and such first[end if][if stria are visible]. Stria glisten on the ceiling[end if]. [one of]There's a diorama hanging here, identical to the one in the study, too[or]That diorama's here, too[stopping].";

understand "basement" as Basement.

understand "sitar" as a mistake ("[if stair is visible]You already changed to what you need[else]You don't need music right now. A way to get around would be better[end if].") when player is in Basement.

to say bsmnt:
	if Elmo is in Basement and rifle is in lalaland:
		say "Be Set, Man";
		continue the action;
	say "[if rifle is visible]Bam, Tense[else if Basement-been is true]Same Bent[else]Meet-Bans[end if] Basement";

diorama is in dusty study and Basement.

understand "mole" as a mistake ("You can't change Elmo into an animal. Your powers don't work that way. [if rifle is in lalaland]He already seems to be[else]But maybe he is[end if] a different sort of mole.") when Elmo is visible.

the evac-cave is scenery in Basement. "It's a bit small, but you can enter it, or go inside."

understand "evac/cave" as evac-cave.

instead of doing something with evac-cave:
	if action is procedural:
		continue the action;
	if current action is entering:
		try going inside instead;
	say "You probably just want to enter the cave or go IN.";

the stria are plural-named vanishing LLPish scenery in Basement. "You never knew what they were until Old Man Almond told you. 'You'll be glad one day, maybe,' he said. They're like veins, vines." [stria are LLPish because if you're in the basement you don't need to attack them]

a-text of stria is "RRYYR". b-text of stria is "PPYGR".

understand "astir" as a mistake ("[if stair is visible]You don't need to do any more with the stair[else]You need to change that to something else, then it'll be astir[end if]") when stair is visible or stria is visible or sitar is visible.

the stair is a backdrop. "It leads [if player is in Basement]up[else]down[end if].";

does the player mean climbing the stair: it is very likely.

check climbing stair:
	if player is in stable:
		try going down instead;
	else:
		try going up instead;

understand "wallpaper" as a mistake ("You try the word-flip, to check--sadly, it doesn't work. Maybe there is another way to remove the paperwall.") when paperwall is visible

understand "basement" as a mistake ("Well, if you want points for that, you'll need to go back to the study.") when player is in Basement and t-b are in dusty study.

after printing the locale description for Basement when Basement is unvisited:
	if do-i-chat is false:
		if tables are in study and t-b are in study:
			say "After your trip down the ramp, you note the stria--and the ten beams. Ten beams, basement--that makes sense. You could probably do something to the stria or visit the closets if you wanted, but you don't have to.";
		else if tables are in study:
			say "The stria remind you of the stable you walled up a long time ago. It must have been behind the tables you scribbled on the wall so long ago. Maybe not worth going back to uncover.";
		else if t-b are in study:
			say "[if tables are in study][line break][end if]Okay. So that's what the beams in the study were for[if t-b are unexamined]. You remember there were ten now[else]. All ten[end if]. You could uncover them if you were completionist that way.";
		if possibles is false and min-alert is false:
			ital-say "you don't need to do anything else in the manor, but if you want to track what you can do, POSS will do so.";
			now min-alert is true;
		continue the action;

check going outside in Basement:
	say "To get out of the basement, you need to go inward. So let's go that way.";
	try going inside instead;

check exiting in Basement:
	try going inside instead;

check going down in dusty study:
	if t-b are in dusty study:
		say "Ouch! You smack into a bunch of beams. Ten[if study is not lit]. It might've hurt less if you'd found a light source[end if]." instead;

check going in stable:
	if noun is inside or noun is outside:
		if backcheck is false:
			now backcheck is true;
			say "You shouldn't need to go back unless you need to figure out the diorama and how the settler works. Do you want or need to do this?";
			if the player consents:
				now player is in dusty study instead;
			else:
				say "Ok, probably best to [if pram is not in lalaland]find a way out. Clean out that pram, maybe[else]see about that ramp[end if]." instead;

	
check going down in stable:
	if stair is not visible:
		say "There should be a way down. That sitar could trans-substantiate or be reincarnated as something more useful." instead;
	move player to Basement instead;

instead of doing something with stair:
	if current action is not climbing and current action is not entering:
		say "Can't do much but go up or down a stair." instead;

check going up in Basement:
	if stria are visible and t-b are in dusty study:
		say "Hmm. There should be a way back up. The stria could be disposable." instead;
	if backcheck is false:
		now backcheck is true;
		say "You shouldn't need to go back to your study unless you want to get more points. Do you want or need to do this?";
		if the player consents:
			now Basement-been is true;
			now player is in dusty study instead;
		else:
			say "Ok, probably best to find a way out." instead;

settler-x-nag is a truth state that varies.

check going inside in Basement:
	if player has latches:
		if treatise is off-stage:
			say "You fumble nervously with the latches before entering, and a treatise falls out. Maybe it will help you decide what to do with the latches, before you go out into the wide world without a scanning device to help you know where to use your power.";
			now player has treatise instead;
		say "[one of]You probably want to figure what those latches are for. What could they be hiding? You've done okay without them, but who knows how you'll react in pressure situations. Whatever they need to be, Old Man Almond would've made it easier than what you've done so far[or]Those latches. Gotta be a trick to [']em, since Old Man Almond had them sent to you[stopping]. Maybe it'd help to [if treatise is examined]re-[end if]read the teariest treatise." instead;
	if player has settler and settler is unexamined:
		if settler-x-nag is false:
			now settler-x-nag is true;
			say "You look at your settler and realize you haven't really EXAMINED it. Maybe you should, before going out in the world. You've been able to guess what to do so far, with the help of heuristics and generally knowing what's in a house, but you may need technical help you can rely on when you hit less friendly areas." instead;
	say "A brief mental lament as you leave gives way to fear of a sting-ops stop sign. But you miss...[paragraph break]'Hands up!'[paragraph break]You say 'grrr' and feel all yellow, then see red as you scream 'Eeeee!' Because it's not a joke. Some guy has a rifle! You drop your lamp, which shatters.[paragraph break]He's got a rifle. You choke, 'O heck.' You notice the name on his uniform is Elmo, which gives you some hope.";
	now lamp is in lalaland;
	now Elmo is in Basement instead;

book carven cavern

Carven Cavern is an innie room in Roman Manor. "This is an oddly carved cavern. [if plaster is visible]The plaster on one wall is just tacky[else if paperwall is visible]The paperwall behind the plaster seems almost as out-of-place as the plaster was[otherwise]you demolished two layers of wall so you can move onward and inward[end if]. You probably don't want to go back outside.";

understand "trainer" as a mistake ("You're on your own. Perhaps you'd be better off scanning the plaster and [if staple is visible]staple[else]plaster[end if] to get on with things.") when player is in cavern

check exiting in cavern:
	if paperwall is in lalaland:
		say "Exiting the cavern, entering the passage, the same thing.";
		try going inside instead;
	say "You probably want to go in." instead;

check going nowhere in cavern (this is the cavern check rule):
	say "The only way to make progress is inward, through that [if paperwall is visible]paper[else if paperwall is not visible]ex-[end if]wall.";
	if paperwall is in lalaland:
		say "[line break]Go through?";
		if the player consents:
			try going inside instead;
		else:
			say "That is probably the way out of the manor. But you are free to look around." instead;
	do nothing instead;

check going inside in cavern:
	if plaster is visible:
		say "You'll probably need a way through that plaster." instead;
	if paperwall is visible:
		say "You'll probably need a way through that paperwall." instead;
	say "You walk through the former paperwall--and through an obscure part of Old Warpy. You hear a voice: 'You! Find! Unify! Do!' It's only when you totally lose your sense of direction that you see a way out. It's the Trips Strip, er, Strip of Profits. Which looks the same and different.";
	now satchel is in lalaland;
	now roman manor is solved;
	now last-solved-region is roman manor;
	move player to strip of profits instead;

chapter plaster

some plaster is scenery in cavern. "It looks sloppily put on, as if someone wanted it to be torn down the right way, though you don't have the patience or tools to do so physically[if plates are visible]. Some plates are stuck in it too[end if]. RETRAIN TERRAIN is written at the top."

understand "psalter" as a mistake ("You don't need prayer when you have this cool magic power.") when plaster is visible.

a-text of plaster is "RRYRRYR". b-text of plaster is "RRGRRGP".

the stapler is a container. description of stapler is "[if stapler contains staple]Locked and loaded with a staple[otherwise]Empty, but given its width, ready for some heavy-duty ammo[end if].". "An oddly wide metal stapler lies here. The normal material would nearly get lost in it."

check examining stapler:
	ignore the examine containers rule;

check closing stapler:
	say "No need to futz. [if staple is in stapler]You already have something in there[else]When you put something in the stapler, it'll be good[end if]." instead;

check opening stapler:
	if staple is in stapler:
		say "You don't need to. The staple belongs in there, to be stapled against the sorts of things that find themselves getting stapled." instead;
	if player has staple:
		say "I'm going to assume you mean opening the stapler to put the staple in.";
		try inserting staple into stapler instead;
	if paperwall is in lalaland:
		say "You've probably done enough with your stapler, here." instead;
	say "You don't have anything to put in the stapler." instead;

check inserting into stapler:
	if noun is not staple:
		say "Only one thing goes in a stapler." instead;

after inserting staple into stapler:
	say "The staple fits in with minimal fuss.";
	continue the action;

the peeling paperwall is scenery. "It's oddly lined, with one vertical stripe on the edge and a bunch of horizontal stripes. There's a small pair of holes in the upper left-hand corner. You imagine it's many layers of papers, so pulling them one by one wouldn't work."

understand "wall" and "walls" as paperwall when player is in cavern and paperwall is in cavern.

to say could-staple:
	say "You need the right tool to do so. You probably need one that could get a grip on some paper[if player carries stapler]. Maybe you could use the stapler to STAPLE the wall[stapload][end if]";

instead of opening the paperwall:
	say "[could-staple].";

to say stapload:
	say "[if staple is in stapler]especially since[else]once[end if] it's loaded";

instead of taking paperwall:
	try pulling paperwall instead.

instead of pulling the paperwall:
	say "[could-staple].";

the vertical stripe is part of the peeling paperwall. description of vertical stripe is "Not very dark, but off to the left, creating a sort of margin.".

the horizontal stripes are part of the peeling paperwall. description of horizontal stripes is "Bluish, and there are about thirty."

the small holes are part of the paperwall. description is "They look like some sort of weird lock or something.". understand "hole" as small holes.

understand "paper/ wall/ " and "wallpaper" as paperwall.

after fliptoing stapler:
	if peeling paperwall is not in cavern:
		now peeling paperwall is in cavern;
	continue the action;

chapter plates

some plates are a plural-named thing in carven cavern. description of plates is "They're cracked and useless and appear to be squarish, but each has metallic trim around its edge[if plaster is visible]. In some odd way, they sort of seem to belong wedged in the plaster[end if].". "Some plates [if plaster is visible]are wedged in the plaster[otherwise]lie[end if] here[one of]. So that's where they go after the dishwasher eats them[or][stopping]."

understand "petals" as a mistake ("That's already been done, and quite well, by Alan Garner in The Owl Service. If you haven't read his Brisingamen books, you should! They're not too long and very entertaining.") when plates are visible or staple is visible.

understand "pastel" and "palest" as a mistake ("The plates are more metallic. Plus, you are a text adventurer, not an interior decorator.") when plates are visible or staple is visible.

understand "pleats" as a mistake ("You are a text adventurer, not a fashion designer.") when plates are visible or staple is visible.

instead of taking plates:
	if plaster is visible:
		say "The plates are wedged in, as if they belonged there. Sort of.";
	otherwise:
		say "They are too broken and bulky to be of much use.";

a-text of plates is "RRYRRY". b-text of plates is "RRGRRY".

the staple is a thing. description is "It looks unbent (well, beyond the two bends all staples have) and usable. It's the biggest staple you've seen by a long shot."

understand "staples" as staple.

check taking staple:
	if staple is in stapler:
		say "It belongs in the stapler." instead;

book stable

Stable is a stairy innie room in Roman Manor. "You never actually used this stable to, say, let a foal named Olaf loaf, and you couldn't think of anything else to do with it[if stair is visible]. The stair you made leads down[end if]. But despite disuse, it is blest with privacy and not falling apart.";

printed name of stable is "A Blest Stable"

the sitar is a vanishing thing in stable. "A sitar, from your kitschy phase, sits here[one of]. You were wondering where it went[or][stopping]."

a-text of sitar is "RRYYR". b-text of sitar is "PRYYP".

description of sitar is "It possesses a one-is-many-ness about it that can lead you to dizzying heights of thought...or sink you down low. You can read it to find its previous owner."

backcheck is a truth state that varies.

check going outside in stable:
	if backcheck is true:
		now backcheck is false;
		say "You don't really need to go back inside unless you're unsure of how your powers work[if satchel is off-stage]. You haven't figured what to do with the latches, and maybe their 'right' form will give you clues[end if]. Plus, the sitar [if sitar is visible]has an odd thereness about it[else]became a nice stair to the basement[end if].[paragraph break]Still, go back to the study anyway?";
		if the player consents:
			continue the action;
		else:
			say "Okay, onward." instead;

check going inside in dusty study:
	if tables are in dusty study:
		say "Hm, maybe those tables on the wall provide a clue where 'in' leads[if study is not lit], or they would, if you could see them[end if]." instead;

book highest heights

Highest Heights is an innie room in Manor. "Well, you're in the top room of your manor, here. The floor is, of course, divided in eighths, set high, with niches up to several inches. The patented closest closets lead back down the chimney again[if ramp is visible], and the ramp you made slopes down[end if]."

after going when heights are visited and strip of profits is unvisited:
	if location of player was unvisited: [and location of player is not heights]
		say "'Oh! That's where your closets were hidden here. Handy.";
		move closets backdrop to all visited rooms;
	continue the action;

the closest closets are a backdrop. "You can't quite see where they are going. They are weird to look inside. But they probably lead back to the [if player is in study]Highest Heights[else]dusty study[end if]."

understand "closet" as closets.

instead of taking closets:
	try entering closets;

the closest closets are in Highest Heights.

check entering closets:
	if player is in study:
		say "The closets sure are faster than climbing the chimney.";
		now player is in heights instead;
	if player is in heights:
		say "You go back down to the closets[if ramp is visible], not ready for the ramp yet[else], not able to figure the pram yet[end if].";
	else if player is in Basement:
		if backcheck is false:
			now backcheck is true;
			say "You shouldn't need to go back to your study unless you want to get more points. Do you want or need to do this?";
			if the player consents:
				now Basement-been is true;
				say "[if t-b are in study]You go back through the closets to your study[else]Woo! You save the effort of climbing up stairs[end if].";
				now player is in dusty study instead;
			else:
				say "Ok, probably best to find a way out." instead;
	else if player is in stable:
		say "[if tables are in study]You go back through the closets to your study[else]Woo! You save the effort of walking through where the tables are[end if].";
	now player is in study instead;

the pram is a semi-easy thing in highest heights. "A pram lies here, one of those stupid gifts you never got to use."

a-text of pram is "RYRR". b-text of pram is "RYRR".

instead of taking the pram:
	say "It'd be hard to carry any reasonable distance."

description of pram is "It was a painfully obvious hint of a gift from someone very well-meaning. But it seemed pretty useless, what with all the stairs in the rest of the manner you had to go up and down. [painful-memory]"

to say painful-memory:
	say "[one of]You see red at a further painful memory. Relive it?[or]Re-relive the painful memory associated with it?[stopping]";
	if the player consents:
		say "[one of]The person who gave it to you said it would help you [if player is female]meet[else]feel like[end if] Mr. Pa. You see red as you cringe at the memory.[or]The memory of encouragement to [if player is female]meet[else]be[end if] Mr. Pa still makes you see red after all this time.[stopping][run paragraph on]";
	otherwise:
		say "Yeah, you probably don't need to, to figure what to do with the pram.[no line break]";

the ramp is scenery. "The ramp slopes not too sharply down."

check going down in highest heights:
	if ramp is not visible:
		try entering closets instead;
	else:
		say "You slide down the ramp--into the basement you [if t-b are not in study]uncovered another, easier way to get to[else]nearly forgot you had[end if].";
	now player is in Basement instead;

check going inside in highest heights:
	try entering closets instead;

chapter stapleing

stapleing is an action applying to one thing.

understand the command "staple [something]" as something new.

understand "staple [something]" as stapleing.

does the player mean stapleing the paperwall: it is very likely.

rule for supplying a missing noun when stapleing:
	if paperwall is visible:
		now noun is paperwall.

carry out stapleing:
	if stapler is not in staple and player has staple:
		say "(Putting the staple in the stapler first)";
		try inserting staple into stapler;
		if staple is not in stapler:
			say "[reject]" instead;
	if noun is holes:
		try stapleing paperwall instead;
	if noun is treatise:
		say "It's only one piece of paper. It doesn't need stapling." instead;
	if noun is not paperwall:
		say "That doesn't need stapling." instead;
	If noun is the player:
		say "I can't imagine where you want to staple yourself, and I don't want to know." instead;
	if stapler is off-stage:
		say "[reject]";
	if staple is not visible:
		say "You can't staple with that stapler until you have a staple." instead;
	say "You staple the paperwall. The staple is the right strength to cut in all the layers, grab them at once, and peel them back. The paperwall snaps back, slamming like a door and melting into the wall--and taking the stapler with it. You can't repaper, but [if latches are visible]with those latches, you may[else]you won't[end if] need to prepare to go [b]in[r] to further adventure!";
	now paperwall is in lalaland;
	now staple is in lalaland;
	now stapler is in lalaland;
	reg-inc;
	the rule succeeds;

turns-wasted is a number that varies.

high-sign is a truth state that varies.

every turn when Elmo is visible and Elmo has rifle:
	increment turns-wasted;
	if turns-wasted > 4:
		if high-sign is false:
			say "You hear a sigh nigh. A high sign from Elmo?";
			now high-sign is true;
			now high sign is in Basement;
		else:
			say "Elmo is flashing some sort of high sign. Bold cue? Could be.";
	else:
		say "Elmo listlessly [one of]mutters 'a rifle re-fail.'[or]sings 'He's got a hostage.'[in random order]";

check going outside in Carven Cavern:
	say "There's no way back, and you wouldn't want to go back." instead;

the rifle is a vanishing thing. description is "It's probably loaded with a bullet with your name on it. But you don't want to find out. You think you can read writing on it, if you look closely."

Mole Elmo holds the rifle.

understand "gun" as rifle.

after doing something with rifle:
	if the player's command includes "gun":
		say "It's a rifle, not a gun. This may or may not help.";
	continue the action;

understand "filer" as a mistake ("You can't just give Elmo a desk job. Though maybe some paperwork would help.") when rifle is visible.

understand "lifer" as a mistake ("You start to educate Elmo about the penalties for murder, but he gestures at you like you've almost guessed a Charades clue or something.") when rifle is visible.

check fliptoing when rifle is visible and player is in Basement:
	if noun is not rifle:
		say "Any distraction, and Elmo might fire. Unless, of course, you can change the rifle itself." instead;

instead of doing something to the rifle when Elmo is visible:
	if the current action is taking:
		say "Not even if you were an action hero." instead;
	if the action is procedural:
		continue the action;
	say "You're not in a position to do anything physical with the rifle. Maybe it can become something.";

a-text of rifle is "RRYYR". b-text of rifle is "RRYYR".

selftalk-warn is a truth state that varies.

before talking to (this is the default talking to rule):
	if noun is not Elmo and noun is not Gunter and noun is not Elvira and noun is not Gretta:
		if noun is Gretta and macks are visible:
			say "The macks are monopolizing the conversation. Maybe you should get rid of them." instead;
		if noun is a person:
			if selftalk-warn is false:
				ital-say "ASK (PERSON) ABOUT (PERSON/THING) is what this game uses for detailed conversation. However, TALKing asks about a default subject and gives a general reply, which may be useful, too. You can do so now, and this warning won't appear again.";
				pad-rec "talking";
				now selftalk-warn is true;
			try objasking noun about noun instead;
	if noun is door:
		say "The door seems to grumble and curse very quietly[if splained is false]. Perhaps you could find a way of lecturing it without explicitly talking, but it's probably not critical[else]. Well, you already splained to it[end if]." instead;
		repeat through table of default-gen-blather:
			if noun is default-talker entry:
				say "[gen-blah entry][line break]" instead;
		if noun is not pugnacious plant:
			say "You can only talk to animate objects. This isn't one, or the game (mistakenly or otherwise) doesn't think it's one." instead;

check talking to Mole Elmo (this is the can't talk while Elmo has the rifle rule) :
	if rifle is visible:
		say "'Hostages['] hot gases!' Elmo booms, waving his rifle." instead;

Mole Elmo is a person. description is "He is waving that rifle you probably need to neutralize. Yet you can't tell if his expression says wry, or worry.". "[if do-i-chat is true]Mole Elmo's rifle changes to a flier[else]Mole Elmo looks at you, then the rifle, half as if he wants you to do something with it[hi-sign][end if]."

to say hi-sign:
	if high-sign is true:
		say ", even flashing a high sign.";

the high sign is undesc.

instead of doing something with the high sign:
	if current action is not objhinting:
		say "[if current action is not examining and current action is not reading]Not much to do but look. [end if]Elmo appears to be flashing the numbers 3, 4, 2, 5 and 1 in order with his fingers. Then a pause, then he tries it again[one of]. Hm, nothing here five letters except that rifle[or][cycling].";

check scaning when rifle is visible:
	say "Elmo might shoot you if you went for the settler, which you notice is blinking [spacies of a-text of rifle]. Which has to be the rifle. You hope." instead;

the litany of Mole Elmo is the table of Elmo comments.

after fliptoing rifle:
	pad-rec-q "rove over";
	now high sign is in lalaland;
	try talking to Mole Elmo instead;
	continue the action;

Chapter super purse

instead of searching purse:
	say "(You can type I to take inventory in the future.)";
	try taking inventory instead;

The super purse is a warpable thing. description is "[one of]You find a small note inside, apologizing if it's [if player is male]unusual for you[else]heinously stereotypical[end if], explaining it was a choice between this and an all-wet wallet, and it's 50% bigger than a co-kept pocket. [or][stopping]The inside seems to be covered with space capes, a weird technology that lets the inside be greater than the outside. It re-ups your carrying capacity."

the space capes are part of the super purse. the space capes are useless and plural-named. description of space capes is "If I understood the science behind them, I'd be wasting my life programming games like this, wouldn't I? Okay, maybe I am, anyway."

instead of doing something other than examining space capes:
	say "The capes work--no need to futz with them or to wonder how they work.";

understand "paces" as a mistake ("The space capes are already abstract and bizarre enough. They work, and you probably don't want to change them.") when space capes are visible.

pursins is a truth state that varies.

check inserting into the purse:
	if noun is lamp:
		say "Fire hazard." instead;
	if player does not have noun:
		if pursins is false:
			ital-say "putting something in the purse is the same as taking it.";
			now pursins is true;
		try taking noun instead;
	say "That should already be in the purse.";

instead of doing something with purse when mrlp is troves and stop post is reflexive:
	say "Do not worry about wealth you lost. [i]Only worry about the wealth you can create[r].";

chapter letters settler

The Letters Settler is a warpable thing. understand "recoded decoder" and "recoded/decoder" and "revised/deviser" and "revised deviser" as letters settler. understand "device" as letters settler.

instead of showing settler to smart kid:
	try objasking kid about settler;

after examining settler for the first time:
	say "You figure up some heuristics to make the settler easier to use.";
	pad-rec "the settler";
	continue the action;

understand "scanner" as settler.

a-text of letters settler is "RYRRRYR". b-text of letters settler is "RGPPRYR".

description of the letters settler is "It's shaped like a hand-held vacuum, with an output display on the front. Weird receptors can SCAN things. Below a colorful logo, you also notice a button labeled TEACH/CHEAT. I guess it doesn't wish to judge.[paragraph break]You also feel a switch, some sort of slider and a decal on the backside."

check examining settler (this is the examine to scan under duress rule) :
	if rifle is visible:
		try scaning rifle instead;
	if owls are visible:
		say "You reflexively point the settler at the swooping owls as they attack.";
		try scaning owls instead;
	if raptor is visible:
		say "You reflexively point the settler at the charging raptor as it attacks.";
		try scaning raptor instead;
	if player is in bleary barley and b-b is reflexive:
		say "The barley seems to be causing readings on your settler.";
		try scaning b-b instead;

the receptors are part of the letters settler.

instead of doing something with the receptors:
	say "They're not important. Actually, scratch that, they're too important to fiddle with and break." instead;

the output display is undesc. the output display is part of the letters settler.

the receptors are part of the settler. description is "You know little about electronics and magic theory, and you have no time to find out."

check examining output display:
	say "You look at the display, not really expecting to see anything unless you SCAN something. Maybe there's something in the air.";
	try scaning air instead;

the colorful logo is undesc. the colorful logo is part of the settler.

seen-blues is a truth state that varies.

check examining logo:
	say "Some of the letters in the logo shimmer a bit, as if they could be changed by pushing the right button. They spell out:";
	if glulx graphics is supported:
		if cheat-on is false:
			display figure graflogo-1;
			if seen-blues is true and Elmo is off-stage:
				say "[one of]It might be wise to take note of which letters changed colors and why and how[or]The logo is in its less colorful setting now[stopping].";
		else:
			display figure graflogo-2;
			if Elmo is off-stage:
				say "The different colored e's seem interesting.";
			now seen-blues is true;
	else:
		say "LETTERS SETTLER. [if cheat-on is false]Es in yellow and everything else in red[else]first Es of each word in green, the Ts in purple, the second Es in yellow. The other letters are all red[end if]. Below, you read: teach/cheat recolors. ";
		if screenread is false:
			ital-say "you may want to get an interpreter like Gargoyle and Zoom to see the 1-kb PNG of this in all its glory.";
	the rule succeeds;

instead of doing something to the logo:
	if action is procedural:
		continue the action;
	say "The logo's just there to say what it is. And maybe as a hint to examine.";

check scaning (this is the scan settler and paperwall parts rule):
	if noun is part of the settler:
		say "Impossible. It's part of the settler." instead;
	if noun is small holes:
		say "They register nothing. Perhaps there's some sort of key-thing that fits in them." instead;
	if noun is paperwall or noun is part of paperwall:
		say "The paperwall registers nothing. Perhaps you need to find a way to unlock the small holes in the paperwall[if staple is off-stage]. You don't have anything that makes holes, yet[else]. Hmm, you have something that could make a small hole[end if]." instead;

the stubborn switch is part of the settler. description is "It doesn't seem to budge easily--maybe that's because it gives some unusually good hints."

instead of switching on the settler:
	try switching on the stubborn switch instead.

instead of switching off the settler:
	try switching on the stubborn switch instead.

the tcb is a privately-named thing. the tcb is part of the letters settler. understand "teach button" and "cheat button" and "teach" and "cheat" and "button" as tcb when tcb is visible. printed name of tcb is "teach/cheat button"

description of tcb is "It's a tech simple enough. Looks like you can push it to toggle it as much as you want."

cheat-on is a truth state that varies.

instead of switching on the tcb:
	try pushing the tcb instead;

instead of switching off the tcb:
	try pushing the tcb instead;

check pushing the tcb:
	say "You push the teach-cheat button, and it's now [if cheat-on is true]off. Hooray for more challenge[otherwise]on. Hooray for more information[end if][one of] when you SCAN in the future--though you can push the button to go back to normal mode[or][stopping][if cheat-on is false and seen-blues is false]. The logo seems to change colors as well[end if].";
	if cheat-on is true:
		now cheat-on is false instead;
	now cheat-on is true instead;

does the player mean doing something with the equals sign: it is unlikely.

the equals sign is part of the Letters Settler. description is "The equals sign is [if squee is false]dark[otherwise]light[end if], but you can push it to change that."

squee is a truth state that varies.

check pushing the equals sign:
	say "You push the equals sign, and it [if squee is false]lights up[otherwise]darkens[end if].";
	if squee is true:
		now squee is false;
	otherwise:
		now squee is true;
	the rule succeeds;

instead of switching on the equals sign:
	try pushing the equals sign instead;

instead of switching off the equals sign:
	try pushing the equals sign instead;

set-sw is a truth state that varies.

ever-switched is a truth state that varies.

instead of pushing or pulling or attacking the stubborn switch:
	try switching on the stubborn switch;

does the player mean switching on the stubborn switch: it is very likely.

instead of switching on the stubborn switch:
	show-bluable instead;

to show-bluable:
	if stubborn switch is not visible:
		say "[reject]";
		continue the action;
	let QQ be number of bluable things;
	let QQQ be nothing;
	if QQ is 1:
		now QQQ is a random bluable thing;
	if set-sw is false:
		now set-sw is true;
		if the player's command does not include "ss":
			ital-say "in the future, you can shorten this with SS.";
			say "[line break]";
		pad-rec-q "ss";
	if QQ is 0:
		swi-say "You see nothing unusual after doing so.[line break]";
		continue the action;
	swi-say "[one of]You switch the settler, then shake it. Your vision swirls for a minute, and o[or]Switch, shake, swirl. O[stopping]nly [bluable-list] [if QQ is 1 and QQQ is not plural-named]is[else]are[end if] visible. It's a bit of a headache to stare too long, so you switch it off.[line break]";
	if ever-switched is false:
		say "[line break]Wow! That's handy! The switch shows you which items identifiably change definability!";
		now ever-switched is true;

to say bluable-list:
	let QQ2 be number of bluable things;
	let inc be 0;
	repeat with bloo running through bluable things:
		increment inc;
		if inc is QQ2 and QQ2 > 1:
			say " and ";
		if bloo is an altview listed in table of altviews:
			choose row with altview of bloo in table of altviews;
			if there is an alttext entry:
				say "[alttext entry]";
		else:
			say "[the bloo]";
			if bloo is auxiliary:
				say "(but a bit blurry)";
			if inc + 1 < QQ2:
				say ", ";

table of altviews
altview	alttext
sorer bogey	"an outline of the sorer bogey"
eeks	"some cartoony representation of EEKS"
Elmer	"Elmer and Merle"
Merle	--

test towtru with "towers/towers/enter towers/rustled/docile/n/mined/pastier/greyed/punier/n/clumsy/weirder/mistier/n/married/weariest/angstier/e/marginal/s/himself/unable/resealed/get all/w/s/w/put dagger in rapier repair/e/e/unreal/drained/e/rusty/grandiose/broken/e/wordy/push retape/w/w/w/n/n/n/push repeat/s/s/s/e/e/e/unlocked/w/n/holiest/n/porcine/ask kid about doctor/s/s/e/attentive/rowdy/w/n/n/give gizmo to kid"

to swi-say (sst - indexed text):
	if sss is false:
		say "[sst]";
	else:
		append "[sst][line break]" to the file of debuggery;

definition: a thing (called candi) is bluable:
	[say "[candi] [if candi is ghostly]invis[end if] [if candi is uncluing]uncluing[end if] [if candi is visible] visible[end if].";]
	if candi is unscannable, no;
	if candi is reflexed, no;
	if candi is ghostly, no;
	if candi is uncluing, no;
	if candi is decrepit mark or candi is decrepit mark, no;
	if candi is tunes, no;
	if candi is crate:
		if reacted is false or traced is false, yes;
		no;
	if candi is haunter:
		if player is in anger range and candi is off-stage:
			decide no;
	if candi is visible, yes;

definition: a thing (called candi) is outlinable:
	[say "[candi] [if candi is ghostly]invis[end if] [if candi is uncluing]uncluing[end if] [if candi is visible] visible[end if].";]
	if candi is not ghostly, no;
	if candi is uncluing, no;
	if candi is visible, yes;

to say outline-invis:
	if number of outlinable things > 0:
		say "You can also briefly see outlines of [a list of outlinable things]. ";

the backside is part of the letters settler. understand "back" as backside.

check examining backside:
	if glulx graphics is supported:
		display figure yorpwald-1;
	else:
		say "It reads SAVE YORPWALD WITH WORDPLAY. SAVE and WITH are dark, but in the other two words, the Y's are orange.";
		if screenread is false:
			ital-say "a glulx interpreter like Gargoyle shows things clearer.";
	say "[one of]Hmm. The orange seems odd. Perhaps it's a clue, if you need one. [or][stopping]There's also a switch below the decal.";
	the rule succeeds;

the laced decal is part of the letters settler.

description of laced decal is "[bug-report]"

instead of examining decal:
	try examining backside instead.

instead of taking decal:
	say "It's really wedged on there. You'd destroy it scraping it off. And besides, maybe it's a hint, too.".

description of backside is "[bug-report]";

before scaning:
	if noun is part of the settler:
		say "The settler's pretty powerful, but it's not four-dimensional, so it can't wrap to scan itself--or parts of itself." instead;

chapter slider

the idlers' slider is a device. the slider is switched off. the slider is part of the letters settler. description is "The slider[one of], which is red (a nice touch--slider and idlers not having any letters that match up,) [or] [stopping]is currently switched [if slider is switched on]on[else]off[end if], with a number [headaches] next to it[one of]. You'd guess that is the number of charges left, or something[or][stopping]."

after examining slider:
	toggle-slider-note;

slider-toggle is a truth state that varies.

to toggle-slider-note:
	if slider-toggle is false:
		ital-say "You can type SL to toggle the slider in the future.";
		pad-rec-q "sl";
		now slider-toggle is true;
		continue the action;

after entering oyster-x:
	say "You hear a click from the slider[if slider is switched on] as it switches off[else] and you notice it's jammed[end if][if cur-score of oyster is 0]. Hopefully thinking will not be at a premium here[else]. But you know action counts more here[end if].";
	continue the action;

check switching on slider:
	if mrlp is oyster:
		say "Geez. It's jammed[if cur-score of oyster > 0]. Well, it's harder for the slider to ascertain actions instead of ideas[else]. Hm, maybe thinking is less important than other things, here[end if]." instead;
	toggle-slider-note;
	if slider is switched on:
		say "It already is." instead;
	if headaches is 0:
		say "You can't afford any more headaches." instead;
	say "You switch the slider on." instead;

check switching off slider:
	if slider is switched off:
		say "It already is." instead;
	now slider is switched off;
	say "You switch the slider off." instead;

sling is an action applying to nothing.

understand the command "sl" as something new.

understand "sl" as sling.

carry out sling:
	if slider is switched off:
		try switching on slider instead;
	try switching off slider;
	the rule succeeds;

chapter teariest treatise

book pedanto-notepad

the pedanto-notepad is a warpable thing on a rich chair. understand "pad/note" and "note pad" and "pedanto/ notepad/" as pedanto-notepad.

understand "book" as pedanto-notepad when player is not in shack.

understand "consult [text]" as a mistake ("You can CONSULT PAD ABOUT X, CONSULT ABOUT X, or PAD X.") when pedanto-notepad is visible.

instead of opening the pedanto-notepad:
	say "You can just type PAD to get all the subjects, or PAD (SUBJECT) for a specific one."

instead of searching the pedanto-notepad:
	say "You can just type PAD to get all the subjects, or PAD (SUBJECT) for a specific one."

instead of dropping the pedanto-notepad:
	say "One problem with owning a pedanto-notepad is that you are wracked with silly reasons to keep it, even if you have the big-picture stuff covered. Sorry about that.";

vaguing is an action applying to nothing.

does the player mean objasking about the dingy dwelling:
	if mrlp is routes:
		it is very likely;
	it is very unlikely.


understand the commands "consult pad" and and "consult about" and "pad" as something new.

understand "consult pad" and "consult about" and "pad" as vaguing.

carry out vaguing:
	if location of player is dark:
		say "You can't [if player does not have pedanto-notepad]locate[else]read[end if] your notepad right now." instead;
	if player does not have pedanto-notepad:
		try taking pedanto-notepad;
	say "[cur-has]";
	the rule succeeds.

description of pedanto-notepad is "Other people have computers, but your notepad is yours[one of]. It's made by Da Ponte, who now have a monopoly. But you just like it. The color, the feel[or][stopping]. [cur-has][no line break]"

check examining pedanto-notepad for the first time:
	say "It's your workbook. It holds bookwork. The original, from the first time you saved Yorpwald, is in some museum. But this is about the same. It's small enough to fit in a pocket, and you have clipped a pen over it, too.[paragraph break]It won't actually make you pedantic--it just stores the fourth-wall stuff that non-text-adventurers aren't even aware of. Stuff that's a nuisance for text adventurers. While most of it is marginally intuitive (he said, behind the fourth wall,) having to remember it can take away from puzzle solving and such[if player does not have pedanto-notepad]. You decide to take it. It'll help tame lots that's meta, mate[end if].[paragraph break](To use the notepad, you can type PAD (subject) or CONSULT PAD ABOUT (subject). If you forget what you've written about, you can type PAD or CONSULT PAD.)";
	if player does not have pedanto-notepad:
		now player has pedanto-notepad;
	the rule succeeds;

to decide whether (qq - a truth state) is unrelevant:
	if qq is false:
		decide yes;
	let mrl be mrlp;
	if qq is true:
		if mrl is manor or mrl is stores:
			decide no;
	decide yes;

to say cur-has:
	say "Currently you can consult your pad about these general topics:[line break]--";
	let A be 0;
	let fixies be 0;
	repeat through table of pad-stuff:
		if known entry is true:
			if there is a fixed-region entry and mrlp is fixed-region entry and introtoo entry is unrelevant:
				increment fixies;
			else:
				if remainder after dividing A by 4 is 0:
					say "[if A > 0].[line break]--[end if]";
				otherwise:
					say ", ";
				increment A;
				say "[if readyet entry is false][i][end if][short entry]";
				if short entry is "flips" and pf-warn is true:
					say "/pf";
				say "[r]";
	say ".[line break]Unconsulted subjects are in [i]italics[r].";
	if fixies > 0:
		now A is 0;
		say "[line break]You can also consult your pad about [if fixies is 1]a topic[else]topics[end if] specific to this region:[line break]--";
		repeat through table of pad-stuff:
			if known entry is true and there is a fixed-region entry:
				if mrlp is fixed-region entry and introtoo entry is unrelevant:
					if remainder after dividing A by 4 is 0:
						say "[if A > 0].[line break]--";
					otherwise:
						say ", ";
					increment A;
					say "[if readyet entry is false][i][end if][short entry][r]";
		if remainder after dividing A by 4 is not 0:
			say "[line break]";
	else:
		say "There are no topics specific to this region right now.";

the pen is part of the pedanto-notepad.

description of the pen is "It's clipped there so you don't misplace it."

instead of taking the pen:
	say "Bad idea. You tend to lose those things like nobody's business if they're not nailed down."

qmspoil is a truth state that varies.

[top]
table of pad-stuff
topic (topic)	known	blurb	short	verify	fixed-region	readyet	introtoo
"access"	true	"Typing ACCESS toggles handicapped accessibility mode, which generally helps the visually impaired with graphics clues and avoids a stream of useless punctuation. It is currently [if screenread is true]on[else]off[end if]."	"access"	false	--	false
"free turns" or "free/turns"	true	"Some actions do not take a turn. For instance, examining, looking or taking inventory, or 'out of world' actions like SCORE, will not cost you time if you are in a tight situation."	"free turns"	false
"saying"	false	"Instead of SAYing or THINKing, you can just type the word."	"saying"	false
"talking"	false	"TALKING is the equivalent of asking someone about themselves."	"talking"	false
"sleep/sleeping"	false	"SLEEP is only advisable in a protected area."	"sleep"	false
"long commands" or "long/command/commands"	false	"Commands over 4 words long aren't necessary. You can say TAKE ALL or GET ALL, eliminate THE, or use half an open compound word without repercussions."	"long commands"
"random/ dialogue/dialog/"	false	"HUSH turns random dialogue off. UHHS turns it on. It is [if talk-quiet is false]on[else]off[end if]."	"random dialogue"	false
"diorama"	false	"[dior-scan]"	"diorama"	true
"question mark" or "question/mark"	false	"[if qmspoil is true]The question mark is often better than a red or yellow in Cheat mode, because it limits you to two possibilities[else]The question mark is, well, a question mark. But maybe it's not as vague as it seems. You can HINT it if you're stuck[end if]."	"question mark"	true
"opt in" or "opt/notip/optin/tip" or "no tip"	false	"OPT IN lets you see initial region hints. NO TIP turns them off."	"opt in/no tip"	false
"poss"	false	"POSS toggles whether you can see the maximum/minimum score for a region. It is a potential meta-spoiler, but it can be helpful, too."	"poss"	false
"go to" or "go/gt/goto"	true	"You can GO TO/GOTO  or GT a location or thing if it's a bit far away but in the region."	"go to"	false
"clues"	false	"You can LISTEN, ASK people about random stuff, or EXAMINE them to figure how to change them."	"clues"	true
"Elvira" or "necro/crone" or "necro-crone" or "necrocrone"	false	"Apparently, appreciating her is what separates us from the animals. According to Gunter[if mrlp is otters]. But you need to know more and ask around about her[end if]."	"Elvira"	true
"gretta"	false	"If you can find Gretta Garett-Tatger, she may give you something to help hit at Elvira."	"Gretta"	true
"Elmo"	false	"There are areas behind stores P, U, V, W, Y and, most cryptically, T."	"Elmo"	true
"old warpy" or "old/warpy"	true	"Old Warpy is the force that allows people to move between distant areas of Yorpwald that need help. It aided you so long ago getting to the Trips Strip, and it may aid you again. You always wondered where else it led, but you knew if you found out, Yorpwald would be in trouble."	"Old Warpy"	false
"shatter/threats" or "shatter-threats" or "shatter threats"	true	"It's that new law Elvira got passed, about how you couldn't flip things to their anagrams, because there are too few anagrams--things to change to things--left for you to save Yorpwald again. Well, outside your own house. Of course, if you protested, that would look suspicious.[paragraph break]The title was based on a really convoluted acronym you can't remember."	"SHATTER-THREATS"	false
"store p" or "p"	false	"E-Viral has managed to seize the Internet communications of almost everywhere except a small pocket of resistance behind Store P. Many people expend words on it but few take action."	"store p"	true	presto	--	true
"store t" or "t"	false	"Elvira's behind there. Who knows what she's designing. It may be worth checking to note your progress, though."	"store t"	true	otters	--	true
"store u" or "u"	false	"People have lost all sense of direction there. Rev. Ali has told them they did, and they believe it. An invisible poison stripe forces them to the same mesa."	"store u"	true	routes	--	true
"store v" or "v"	false	"Mayor Irv Lea has made Spoiloplis the richest per capita city in the land. You must infiltrate the world of money and move from 'impossible' to 'I'm possible.'"	"store v"	true	troves	--	true
"store w" or "w"	false	"A very modern socialite called Liv Rea has pushed for re-zoning Castle Apcur, the Curst Palace, in order to increase property value, which would profit only her. Maybe you can restore the Curst Palace to its former glory."	"store w"	true	towers	--	true
"store y" or "y"	false	"The subsea abuses behind Store Y are fast and furious. A rabid gang has taken over the town, headed by the ruthless Ira Lev. Plenty of unsafe sea fun."	"store y"	true	oyster	--	true
"spaces/space/son/nos" or "space on" or "no space"	false	"[if screenread is false]To put spaces in letters settler readings, type SPACEON or SON. NOSPACE or NOS reverses this[else]Spaces are on by default in accessibility mode[end if]."	"spaces"	true
"parrot"	false	"He wants to come back some time. He wants revenge. As the raptor."	"parrot"	false	otters
"asking"	false	"You will want to ASK about Elvira a lot."	"asking"	false	otters
"the settler" or "settler"	false	"c/t/cheat/teach pushes teach/cheat button[line break]la = last scan (best for vision impaired since graphic should appear in top frame) [line break]ss = switch settler or shake settler to see all transformable objects[line break]You don't ever need to SCAN X WITH SETTLER, just SCAN X."	"the settler"	true
"la"	false	"Shortcut command to recall what you scanned last."	"la"	false
"sl"	false	"Shortcut command to turn slider on."	"sl"	false
"sy"	false	"Shortcut command to scan with hints, overriding the equals sign and the current setting."	"sy"	false
"sn"	false	"Shortcut command to scan without hints, overriding the equals sign and the current setting."	"sn"
"ss"	false	"Shortcut command to shake the settler and see what all in the general area needs changing."	"ss"	true
"hacking" or "hack"	false	"A reminder that cussing won't make a computer work any better, and you need to get everything set up first on your comfy labs slab, and only then should you take action with various technical programming activities."	"hacking"	true	presto
"methods"	true	"You probably want to talk to and examine everyone. Even hostile people drop clues when asked about themselves, or stuff in general. Searching and reading writing, or even trying to run past or attack enemies, can offer information, too."	"methods"	false
"red"	true	"Stuff that's all red, or an idea that makes you or someone see red, is all wrong, which is a clue in its own way."	"red"	true
"shuffling/ around" or "shuffling around"	true	"Postmortems? Most sport em. Details: I lasted. I miss my tagged gadget and how it helped me through the Forest (store F,) Sortie (store I,) and Metros (store M) in the Trips Strip. To the resort (store R.) Redness = guised guides (letters all wrong.)"	"Shuffling Around"	true
"no-gal/logan" or "no-gal logan"	false	"No-Gal Logan may have a ship that can get you out of here. It is beyond an un-road."	"No-Gal Logan"	true	routes
"tagged/gadget" or "tagged gadget"	true	"You wrote some notes about the Tagged Gadget in here, about Certify and Rectify modes. How Certify showed all the right letters, and Rectify made the first and last right[if player does not have settler]. You could do with a new thingamabob now[else]. How Secure allowed you to keep both modes and Recuse let you skip a store. Your settler is apparently handy in a different way[end if][if cavern is unvisited]. Probably a bunch of different commands to use, though[end if]."	"tagged gadget"	true
"retry" or "terry"	true	"You wrote notes about how you can RETRY thanks to Terry if you get stuck somewhere past a store."	"retry"	true
"warp"	true	"[i][bracket]FOURTH WALL NOTE: if you solved Store P, U, V, W, or Y in an earlier release, you can type the final command to bypass it. Also, the final command changed between versions for some areas, because they were (hopefully) improved, so you can use either. The game will warn you if you used an old one.[close bracket][r]"	"warp"	true
"directions/dirs"	true	"A Roiling Original uses north, south, east and west. You may be able to go in or out, too, especially when only one exit is listed."	"directions/dirs"	false	--
"casper"	false	"Casper talked to you about how this place is full of action, how there's a haunter beneath Anger Range, and it may have lost something. Casper also explained you'll need a way through the Horned Hedron."	"casper"	true	oyster
"reagents/reagent"	false	"You need three reagents to help Brother Horbert: mushrooms[if player has mushrooms] (check)[end if], a runed book[if player has runed book] (check)[end if], and pipe soot[if player has pipe soot] (check)[end if]."	"reagents"	true	routes
"Leo/Rand" or "Leo and Rand"	false	"Leo and Rand may be able to help you with heavy lifting."	"Leo and Rand"	true	presto
"haunter"	false	"The haunter is beneath Anger Range, but it is only part of what is making everyone angry. It is angry about a jewel it had stolen from it."	"haunter"	true	oyster
"die" or "die thou" or "hideout" or "hangout"	false	"If the Horned Hedron could be undermined or infiltrated, perhaps things would get back to normal. And perhaps the haunter could be used against them. It hates them."	"hangout"	true	oyster
"progress"	false	"You note the following: manor = stuff[other-areas]."	"progress"	false
"curst/palace" or "curst palace"	false	"You apparently can't scan the curst palace fully with the settler [']til you're all the way there. But maybe you can guess."	"curst palace"	true	towers
"xray" or "xraying"	false	"You can XRAY something you can't describe to see what it can or should be[if xrayvision is false], but you need to put a pastry in the toaster first[else], and that pastry you ate will help. You can wait as long as you need to use it[end if]."	"xray"	false	towers [?? all are gone?]
"hit/ win/ button/" or "ben/ hid"	false	"Ben hid a HIT WIN button somewhere. Where?"	"hit win button"	false	routes
"scenery"	false	"Ed Yerg told you to look for [the entry clue-index in nextclue]."	"scenery"	false	towers
"flips" or "flip" or "pf"	false	"[what-can-flip]"	"flips"	false
"rove" or "over" or "rove over"	false	"You can just ROVE OVER to where Curtis is. Though he is less important than Elvira."	"rove over"	false	--
"talking"	false	"[if number of terse-warned hintrelevant people > 0]You got nothing from [list of terse-warned hintrelevant people][else]Nobody nearby seems useless...YET[end if]."	"talking"	false	--
"badlands" or "bland/sad badlands" or "bland sad badlands"	false	"Old Hat Daltho told you that the people guarding passage would be tough. Like, six or more letters tough. But you might be able to listen to them and talk to them. He also mentioned [if subsector is unvisited]Dr. Yow, whom you haven't found yet, and how [end if]the flowerpot was for a friend called Ed."	"badlands"	false	towers

pf-warn is a truth state that varies.

to say what-can-flip:
	if pf-warn is false:
		if word number 1 in the player's command is not "pf":
			ital-say "you can abbreviate this with PF in the future.";
			now pf-warn is true;
	if number of prefigured things is 0:
		say "You have nothing [if ever-fig is true]else [end if]you figured in advance.[no line break]";
		continue the action;
	say "Stuff you figured that may be handy later: ";
	repeat with pft running through not unfigured things:
		if pft is a preflip listed in table of pres:
			say "[line break][pretodo entry]";
		else if pft is a the-from listed in table of anagrams:
			choose row with the-from of pft in table of anagrams;
			say "[line break]Deal with [the-from entry]: [right-word entry].";
		else:
			say "[line break]You remember you need to think [pft] at some time.";

table of pres
preflip	thereg	pretodo
bench	routes	"Find a way to be fearless so you can lean AGAINST the bench." [routes]
elbow	routes	"You can go BELOW the giant's elbow once he swings it around."
narrow cracks	routes	"You can look AROUND to find the un-road."
un-road	routes	"You can go ALONG the un-road...once you find it."
thor	routes	"You can go THROUGH [if controls are reflexed]now[else]if[end if] the ship controls are working."
new beet	routes	"You can go BETWEEN [if controls are reflexed]now[else]if[end if] the ship controls are working."
Pa Egg Pea	--	"You can GAPE at a particularly bad page you may come across in the future."
stop post	troves	"You can't focus enough to SPOT, yet."
salt	troves	"You can LAST [if stream is reflexed or lobster is in lalaland]now[else]once[end if] you have confidence in your skills."
lobster	troves	"You can BOLSTER yourself to eat the lobster."
stream	troves	"You can MASTER the relaxation technique seen with the stream."
song	troves	"You can DECIDE once you've paid your dues."
playbill	troves	"You can RESIGN once you've paid your dues."
DIVORCES	troves	"You can DISCOVER what rubbish DIVORCES magazine is."
onyx censer	presto	"The censer can become a SCREEN once you've found a place to put it."
plebe	presto	"You can shout BLEEP at the plebe [if player wears star]now[else]once[end if] you look more authoritative."
ether	presto	"You haven't yet found the right moment to shout THERE into the ether."
trolls	oyster	"You can't quite STROLL past the trolls, yet."
haunter	oyster	"You should UNEARTH the haunter once you figure how to handle it."
a-s	oyster	"SEARCH the arches."
dialer	oyster	"With the yapper gone, you should be able to DERAIL."
d2	oyster	"You should be able to REDIAL the dialer with the proper preparation."
lance	oyster	"CLEAN the lance once you have something to wash it with."
duck	towers	"The lone duck could make SOMETHING unlocked[if subsector is visited]. Maybe the prison ropins[end if]."
ropins	towers	"It would be nice if something made the prison ropins UNLOCKED[if duck is prefigured], like, maybe the duck[end if]."
rodney	towers	"Rodney can be [if roddro is false]sent YONDER[else if rodyon is false]made DRONEY[else]sent YONDER or made DRONEY[end if]."
b-b	otters	"You can make the barley be BARELY there once you get past the otters."
eels	otters	"You can tell the eels ELSE [unless player has medals]once you have[else]now you've got[end if] a token of your goodness."
sea cube	otters	"You can tell the eels in the sea cube BECAUSE once you know why."
ghoul hat	otters	"You can say ALTHOUGH to Mr. Lee and his ghoul hat [if player has medals]now you've figured[else]once you figure[end if] where the bad guys are."
p-2	otters	"You can say HOWEVER to deal with Mr. Lee and Rev. Howe."
atmo-moat	otters	"You can collapse the atmo-moat to an ATOM once you have the power."
medals	otters	"The medals can help you go QUICKLY[if adjsolve < 3 or nounsolve < 3], though they may not be fully magical, yet[end if]."
mango	others	"You can look AMONG once you have currency to haggle in the clearing."

to say other-areas:
	repeat through table of region-spoilers:
		if last-loc of hint-reg entry is visited:
			if hint-reg entry is not others and hint-reg entry is not roman manor and hint-reg entry is not stores:
				say "[spoil-expl entry]";
			else:
				say "(????)";

after objasking aunt tuna about:
	pad-rec-lump "haunter";
	pad-rec "die thou"

after objasking casper about:
	pad-rec "haunter";
	pad-rec "die thou"

[tope]

chapter consulting

the block consulting rule is not listed in any rulebook.

consulting is an action applying to one thing and one topic.

pad-consult is a truth state that varies.

check consulting it about:
	if location of player is dark:
		say "Not in the dark." instead;
	if noun is not pedanto-notepad:
		say "You can only really consult your notepad. ASK something animate, if you want to." instead;
	if player does not have pedanto-notepad:
		try taking pedanto-notepad;
	repeat through table of pad-stuff:
		if known entry is true and topic understood includes topic entry:
			now readyet entry is true;
			say "[blurb entry][line break]";
			now pad-consult is true;
			the rule succeeds;
		otherwise:
			do nothing;
	say "You haven't written anything about that. [cur-has]";
	the rule succeeds;

chapter padding

understand the command "consult about [text]" as something new.
understand "consult about [text]" as padding.

understand the command "notepad/pedanto/pad [text]" as something new.
understand "notepad [text]" and "pedanto [text]" and "pad [text]" as padding.

padding is an action applying to one topic.

carry out padding:
	try consulting pedanto-notepad about topic understood instead;

recbuffer is indexed text that varies.

to pad-rec-p (q - text):
	pad-rec q;
	say "[paragraph break]";

to decide whether need-line-break:
	if player is in study and gunter is in study:
		decide no;
	if player is in fro and gretta is in fro:
		decide no;
	if player is in Basement and elmo is in Basement:
		decide no;
	decide yes;
		
to pad-rec (q - text):
	repeat through table of pad-stuff:
		if there is no short entry:
			say "Need short entry for [q]: [bug-report]";
		else if short entry is q:
			if known entry is false:
				now known entry is true;
				if number of characters in recbuffer > 0:
					replace the regular expression "\/$" in recbuffer with "";
				if there is no verify entry or verify entry is true or number of characters in recbuffer > 0:
					say "[if need-line-break][line break][end if][italic type][bracket]You record the information about [recbuffer][short entry] in [mult-if]your [one of]pedanto-[or][stopping]notepad.[close bracket][roman type]";
			now recbuffer is "";
			the rule succeeds;
	say "BUG! Tried to write [q], a notepad entry that wasn't there. This isn't a game-breaking bug, but it's bad for user-friendliness. Please let me know at [email].";
	abort-if-bugfind;

to say mult-if:
	if recbuffer matches the text "/":
		say "multiple entries in ";

to pad-rec-lump (q - text):
	repeat through table of pad-stuff:
		if there is no short entry:
			say "[bug-report] need short entry for [q].";
		else if short entry is q:
			if known entry is false:
				now known entry is true;
			now recbuffer is "[recbuffer][q]/";
			the rule succeeds;

to pad-rec-q (q - text): [pad-rec without saying, you add the info]
	repeat through table of pad-stuff:
		if there is no short entry:
			say "[bug-report] need short entry for [q].";
		else if short entry is q:
			if known entry is false:
				now known entry is true;
			now recbuffer is "";
			the rule succeeds;
	say "BUG! Tried to quiet-write [q], a notepad entry that wasn't there. This isn't a game-breaking bug, but it's bad for user-friendliness. Please let me know at [email].";
	abort-if-bugfind;

to pad-del (q - text):
	repeat through the table of pad-stuff:
		if there is no short entry:
			say "[bug-report] need short entry for [q].";
		else if short entry is q:
			if known entry is true:
				now known entry is false;
			the rule succeeds;
	say "BUG! Tried to delete [q], a notepad entry that wasn't there. This isn't a game-breaking bug, but it's bad for user-friendliness. Please let me know at [email].";
	abort-if-bugfind;

chapter pfing

pfing is an action applying to nothing.

understand the command "pf" as something new.

understand "pf" as pfing.

carry out pfing:
	now pf-warn is true;
	if player does not have pedanto-notepad:
		say "You need your notepad to use the PF shortcut.";
	else:
		choose row with short of "flips" in table of pad-stuff;
		if known entry is false:
			say "You consult your notepad but haven't figured any flips in advance yet." instead;
		try consulting pedanto-notepad about "flips";
	the rule succeeds;

volume others

citrus-score is a number that varies. non-citrus-score is a number that varies.

book Rustic Citrus

understand "sell [text]" as a mistake ("You are paving the way for commerce, not interacting") when player is in citrus or player is in clearing.

Rustic Citrus is a room in Others. last-loc of Others is Rustic Citrus.

fruits-flipped is a number that varies.

after fliptoing a fruit (this is the check minimum fruits and score rule) :
	if player is in rustic citrus:
		coin-eval;
	check-fruit-min;
	continue the action;

to check-fruit-min:
	increment fruits-flipped;
	if fruits-flipped > 20:
		min-up;

description of Rustic Citrus is "A sign on an abandoned drinks stand says RUSTIC CITRUS and, well, it's pretty rustic even if nothing much is growing[if spear is visible]--I don't think the spear stuck in the ground counts[end if][if mad train is visible], and a mad train lies glaring at the lack of track ahead[end if]. [if lumps are visible]The ground's covered with lumps, too. [end if][if pagers are visible]You hear pagers beeping all around as well. [end if][if slime is visible]You also have trouble not looking at some slime oozing off to the side. [end if][if videotape is in citrus]That videotape collection you uncovered from the drinks stand lies here, too. [end if]"

Curtis is a person in Rustic Citrus. description is "I curst him to be nondescript.". "Curtis is pottering around, waiting for you to hand over [if cur-score of others is 0]some[else]more[end if] fruits."

extra-citrus is a number that varies.

curtis-other-coin is a truth state that varies.

negged-yet is a truth state that varies.

after printing the locale description for rustic citrus:
	coin-eval;

The mad train is scenery in Rustic Citrus. description is "It's got quite a frown in its cow catcher, all right. It was apparently designed by Dr. Nimata, whose name is in red.".

a-text of mad train is "RYRYRYRR". b-text of mad train is "RGRYPYRR".

instead of taking mad train:
	say "You'd strain to find a use for trains here.";

a tamarind is a fruit. description is "It looks more like a potato than any fruit you know. But it still counted."

check giving fruit to curtis:
	if moss cap is off-stage:
		say "'No, no. A bit more, then I'll give you a reward." instead;
	say "Oops. BUG. Curtis should've taken the [noun]." instead;

check going inside in Rustic Citrus:
	say "You can't go backward. There is enough to do here, including figuring where to go next." instead;

A spear is scenery in Rustic Citrus. description of spear is "It'd make a powerful weapon, but you couldn't hold anything else. Plus, this isn't that sort of game."

understand "rapes" and "rape" as a mistake ("[one of]Some things, you can't joke about. So please, don't try that again.[or][cutoff][stopping]") when spear is visible.
understand "reaps" as a mistake ("No, not verbs. Well, not here by Curtis.") when spear is visible.
understand "spare" as a mistake ("No, not adjectives. Well, not here by Curtis.") when spear is visible.

to say cutoff:
	stop game abruptly;

a-text of spear is "RYYRR". b-text of spear is "RYYRR".

instead of taking spear:
	say "This is a thinking puzzling game, not a violence game. Though I hope the puzzles have not given you violent thoughts."

the pears are a fruit.

understand "parse" as a mistake ("No, that's my job. Okay, it's your job to parse the anagrams, but you'll need to be more specific with [if spear is visible]the spear[else]other fruits besides the pear[end if].") when spear is visible or pears are visible.

the lumps are plural-named scenery in Rustic Citrus. "They're more purplish than dirt usually is."

a-text of lumps is "RRYRR". b-text of lumps is "RRYRP".

the plums are a plural-named fruit.

understand "slump" as a mistake ("Don't get exhausted! You're near the end!") when lumps are visible or plums are visible

chapter coin-give

to decide what number is curtis-level:
	if number of fruits in lalaland < 8:
		decide on 0;
	if number of fruits in lalaland < 12:
		decide on 1;
	if number of fruits in lalaland < 16:
		decide on 2;
	if number of fruits in lalaland < 20:
		decide on 3;
	decide on 4.

to coin-eval:
	if number of visible fruits is 0:
		continue the action;
	let temp be curtis-level;
	if temp is 4:
		say "Curtis says 'Boy, you have a lot of goodies now. Wouldn't want to lose them carrying all those fruits.' He helps keep your inventory lean and mean.";
		now all carried fruits are in lalaland;
	if number of carried fruits > 0 and temp < 4:
		say "Curtis relieves you of your burden[if number of carried fruits > 1]s[end if] you found[one of]. He thanks you but is curt[or][stopping].";
		repeat with fru running through carried fruits:
			now fru is in lalaland;
	if curtis-level > temp:
		repeat through table of coingiving:
			if levb4 entry is temp and levaf entry is curtis-level:
				say "[line break][blabber entry][line break]";
				if get-token entry is 1:
					now player has tekno-token;
				if get-coin entry is 1:
					now player has coin;
				if get-coins entry is 1:
					if player has icon:
						now icon is in lalaland;
						now player has icons;
						now singed design is part of the icons;
						say "[line break]You fiddle with the coin you got, and now it's an icon, too. So now you have icons!";
					else if player has coin:
						now coin is in lalaland;
						now player has coins;
						now singed design is part of the coins;
					else:
						now player has coins;
						now singed design is part of the coins;
				if get-dollar entry is 1:
					now player has droll dollar;
				continue the action;

a droll dollar is a thing. description is "It has a picture of some gangster--wait, it's Lord Al Ollard--lighting a cigar with a dollar remarkably similar to it--on which is a gangster lighting a cigar, and so forth[one of]. LOL, rad, you think, though the joke wears off[or][stopping]."

understand "dollar/-- bill" as droll dollar.

to say if-clear:
	say "[if clearing is visited]--ah, you're nodding, you've seen it--[else] [end if]"

table of coingiving
levb4	levaf	get-token	get-coin	get-coins	get-dollar	blabber
0	1	1	0	0	0	"'Ok. Neat. Take on a token. There's a clearing some ways away[if-clear]where you can swipe it to trade for things. Haggle. That sort of thing.'"
0	2	1	1	0	0	"'Wow! You got a lot done on that errand. Here's a tekno-token AND a coin. If you go to this clearing[if-clear]the token'll last you a bit. More deals. Coin'll be useful for...something.'"
0	3	1	0	1	0	"'Surprised you can lug all that back! Here's a tekno-token to use in a clearing[if-clear] and some coins. Maybe you'll find what to do with them. Keep it up!'"
0	4	1	0	1	1	"'Wow! Impressive! I'm half curious if you cheated somehow! Here's a tekno-token for the clearing up north and east--not that you may need it--and a couple coins, and a dollar. Don't know if I can give you anything else.'"
1	2	0	1	0	0	"'Glad you didn't say scru-it. We're getting somewhere[if player has moss cap]. Maybe if you physically get somewhere, we can get further[end if].' Curtis hands you a coin for your efforts."
1	3	0	0	1	0	"'Wow. So much done at once.' Curtis hands you two coins for your efforts."
1	4	0	0	1	1	"'Spurtin['] turnips! All that at once? I--well, here's the rest of my junk I don't know what to do with.' Curtis, looking very pleased, hands you two coins and some sort of dollar."
2	3	0	0	1	0	"Curtis, looking quite the citric critic, hands you another coin identical to the one he gave you before."
2	4	0	0	1	1	"Curtis hands you a coin and a suspicious looking dollar. He nods as if to say, that's all you'll get from him."
3	4	0	0	0	1	"'Nice going. Here. Have this paper currency I never could quite spend. It looks kind of illegal. It's all I have for you.'"

chapter moss cap

the moss cap is a thing.

description of moss cap is "The moss bits of the cap go on the outside, leaving the dirty bits to fit over your head. So you'd feel AND look weird wearing it."

the compass is a thing.

description of compass is "It is property of Camp SOS. Its needle is pointing steadily north, so at least it wasn't a SpasmCo product."

check examining compass when mrlp is routes:
	say "It's flipping about uselessly. Guess you can't rely on normal directions here." instead;

the needle is part of the compass. needle is undesc. needle is useless

instead of doing something with the needle:
	say "The needle's inside the compass, and you don't need to mess with it."

a-text of moss cap is "RYRRYRR". b-text of moss cap is "RGRRYRR".

the harmonicas are a plural-named thing in rustic citrus. "Two harmonicas, rusted together, are here."

description of harmonicas is "They're an off-red, unlike your usual visions in the game. Their condition is the pits. They look like a...how do you spell it? Anachorism?"

instead of taking harmonicas:
	say "They're too rusty.";

a-text of harmonicas is "RYRYRRRYRY". b-text of harmonicas is "RGPYRRRYRY".

the maraschino cherry is a fruit.

some slime is singular-named scenery. "It's green, like most slime. But it smells nicer than most slime and is even a bit bumpy."

a-text of slime is "RYRYR". b-text of slime is "RYRYR".

instead of taking slime:
	say "Eww. Not in that form you won't."

some limes are a fruit.

understand "smile" as a mistake ("[if limes are visible]You are thrilled to have gotten those limes, yes.[else if slime is visible]You smile at the slime. It can't be that hard to figure what to do.[otherwise][reject][run paragraph on][end if]")

understand "miles" as a mistake ("[if limes are visible]You don't need miles and miles of limes.[else if slime is visible]You don't want miles and miles of slime.[else][reject][run paragraph on][end if]")

check going north in Rustic Citrus:
	if moss cap is off-stage:
		say "[one of]Rats! You've no clue which direction is north. Maybe if you help Curtis, he'll give you pointers. But he's quite a businessman.[or]You still have no sense of direction.[stopping]" instead;
	if player has moss cap:
		say "The moss cap isn't helping your sense of direction as much as it should. Well, not in its present form." instead;
	now others is unspoiled;

some pagers are plural-named scenery in rustic citrus. description is "They come in green and reddish-purple and black. Like all pagers, they seem a bit seedy."

instead of taking pagers:
	say "Nobody ever saved a country with a pager."

a-text of pagers is "RRYRYR". b-text of pagers is "RRYRYP".

to say mami:
	if player is male:
		say "[d-word-u] Mister Master Mind";
	else:
		say "[if player is in citrus]Named It[else]AND TIME,[end if] Mrs Master Mind";

understand "gapers" and "gasper" as a mistake ("Really, you don't need people all [mami] over changing those [if pagers are visible]pagers[else]grapes into anything else[end if]. That's not your style.") when pagers are visible or grapes are visible.

instead of taking pagers:
	say "As much as you'd like to bash them, there's another way to shut them up."

instead of examining pagers:
	say "Remember when these things were the most annoying electronic devices? Then came cell phones and iPods."

grapes are a fruit.

after fliptoing grapes:
	say "You hear barren cries now that the pagers aren't distracting you.";
	now barren cries are in citrus;
	continue the action;

after fliptoing cranberries:
	now briar screen is in lalaland;
	now barren cries are in lalaland;
	continue the action;

cranberries are a fruit.

section reading

The reading action translates into I6 as "Read".

Understand the commands "r" and "read" as something new.

Understand "r [something]" and "read [something]" as reading. Reading is an action applying to one thing, requiring light.

carry out reading:
	if noun is red writing:
		if number of readable things is 0:
			say "No writing around here on anything." instead;
		if number of readable things is 1:
			try examining a random readable thing instead;
		say "Too much to read." instead;
	if noun is a to-read listed in the table of readables:
		choose row with to-read of noun in table of readables;
		if there is a what-read entry:
			say "[what-read entry][line break]" instead;
		try reading alt-read entry instead;
	if noun is drinks stand:
		try examining blurbs instead;
	try examining noun instead;

the red writing is a backdrop. the indefinite article of red writing is "some". the writing is everywhere. description of writing is "BUG. You should've been kicked to something to read. Let me know how this happened at [email].". understand "words" and "red/-- letters" as writing.

does the player mean reading ltb: it is very likely.
does the player mean reading the red writing when number of readable things > 0: it is likely.
does the player mean reading the red writing when number of readable things is 0: it is unlikely.
does the player mean examining the red writing when number of readable things > 0: it is likely.
does the player mean examining the red writing when number of readable things is 0: it is unlikely.

last-read is a thing that varies.

does the player mean reading last-read when last-read is visible: it is likely.

instead of doing something with red writing:
	if current action is examining or current action is reading:
		if player is in solo den:
			say "GYDIN['] in big red letters." instead;
		if number of readable things is 0:
			say "No red writing around here on anything." instead;
		if number of readable things is 1:
			try reading a random readable thing instead;
		if last-read is visible:
			try reading last-read instead;
		say "That's sensible but ambiguous here with so much to look at--the preferred verb is to READ one of [the list of readable things]." instead;
	 if current action is objhinting:
		continue the action;
	if number of readable things is 0:
		say "There's no red writing here to do anything with." instead;
	say "You can really only read the writing." instead;

definition: a thing (called cand) is readable:
	if cand is not a to-read listed in table of readables:
		decide no;
	if cand is not visible:
		decide no;
	decide yes;

table of readables [tre]
to-read	what-read	alt-read
sitar	"Oh, right. You bought it from Trisa Israt." [manor]
rifle	"It's kind of tricky to read red writing on a red gun, but it appears to be an Irelf-Efril rifle."
Store H	"'All who enter here risk exclusion. Closed for having a truly frightening HOSTER. Trespassers will be, er, shot. - E. S. Roth'" [stores]
ltb	"You can't get settled. Everything seems too general or too specific, and as you read, you hear voices from the past: 'What a spaz! [if player is female]She[else]He[end if] needs to learn to, like...!' They always acted as if it was so simple."	[troves]
DIVORCES	"All sorts of articles that make you see red. This one's about [one of]Rod's Vice[or]Rev. Disco[or]VeriDocs[or]someone who Scored IV[in random order],"
card	"[one of]A message: Derp on, Epdorn![or]The message is from Dr. Peno & Ned Orp.[cycling]"
playbill	"[one of]S. Negri and N. Regis are the band. And there's a promotions company to read about, too[or]Isnerg promotions[cycling]."
volt maze	"[one of]The writing says EZ-Ol[']-Av['] (TM) Volt Maze. [or]Olav Metz and Zemo Valt were the main architects. [cycling] You can read it again to see the [one of]architects[or]company, again[cycling]." [presto]
drab yoke	"It is, apparently, an OAK DERBY drab yoke, from the small red print."
jar of pills	--	ps	[oyster]
stein	"The stein reads TIENS in red, trying to be foreign and exotic, maybe."
jukebox	"Complicated instructions for, of all things, how to turn off the tunes currently playing. Always tunes, never songs. [one of]Do, undo[or]Reset, set[or]Do, undo, set, reset? Hm[cycling]."
tumblers	"The PITS is written in red on the bottom of one tumbler."
scrawl	"[if carps are visible][reject][else]Etahn Ru. Near-Hut Haunter.[end if]"
gleaner	"It was made by Al Green, written in red."
dialer	"A red warning courtesy of I. ALDER says the letters can be shuffled but not LAIRED."
strudel	"DR. ELTUS recommends this strudel!"	[towers]
keycar	"When the car slows a bit, you read KC AYER in red."
iPrune	"InPure industries[one of]. Yep, you heard rumors Elvira was involved with them, too[or][stopping]."
rewired robot	"Rewired -- DR. EWRIE."
o-s	"[if deacons are in lalaland]The shrine reads LOST? HIE! THE LOIS![else][one of]Written in red on the shrine is THE LOIS, who helped you in the sortie pre-Elvira You can read a bit more.[or][one of]LOST? HIE! [or]THE LOIS [cycling]is written on the ole shrine in red.[stopping][end if]"
prison	"Part of the red writing on the prison says [one of]Made by DunkelCo[or]Made in LOUDNECK[or]CONKLUDE there's no way to break in[in random order]. There're two other bits to read."
blaster	"ALBERT'S."
welt-proof flowerpot	"GYDIN['], >> 'Y/N, dig?'"
p-2	"One barely legible bit reads [one of]Eeh, Row V![or]Veer How?[or]Rev. Howe[or]Whereov[in random order]."	[otters]
whistle	"Ed Plye, apparently, made the whistle."
drinks stand	--	blurbs	[others]
riot cap	"It's red and [one of]made of I-TRAP-CO material[or]designed and shaped by CAPTOR-I, whoever they are[in random order]"	--
mad train	"DR. NIMATA."
singed design	"The singed design on the [if player has coins or player has s-c]coins[else if player has coin]coin[else if player has icon]icon[else if player has icons]icons[else]BUG[end if] reads, when you look close, property of NISCO."


chapter peanut cola

the abandoned drinks stand is scenery in Rustic Citrus. "[one of]It's pretty easy to see why it's abandoned. Unfortunately, it's not hi-tech enough to be hooked up to a wiki with gifs, which would make things easier for you. But you do find a can of nasty peanut cola there. It's too gross in concept to take. And there's a rampage note with a mopeage rant, and plans for a megaton pear, under some magenta rope. And there's a lame video collection.[or]There's no other nasty cola, or writing, or 'art,' to find.[or][stopping][if eerie blurbs are visible] You notice some eerie blurbs written on the stand.[end if]"

the videotape collection is scenery in Rustic Citrus. description is "A bunch of weird films in this collection. One title is [one of]Mr. Pinsome, in red[or]One Ms. Prim, in red[or]Moni's Perm, in red[or]Nope, Mr. Sim, in red[in random order]."

the persimmon is a fruit.

a-text of videotape is "RYRRYRRYR". b-text of videotape is "RYRRYRRYR".

magenta rope is a vanishing thing. "A magenta rope is here by the drinks stand, partially obscuring a rampage note and mopeage rant."

does the player mean doing something with rampage note when rampage note is visible: it is very likely.

description of magenta rope is "Oddly colored. It's got a yellowish tinge."

instead of doing something other than scaning megaton pear:
	say "It's--well, maybe not a megaton, but it sure is heavy. And certainly inedible. Maybe it can be changed to a real fruit."

instead of doing something other than scaning rampage note:
	say "A glance seems to indicate some unfortunate writing--either Curtis actually still believes that stuff, or he's embarrassed ever to have written it. Either way, he doesn't need to be alerted to you knowing about it. Best to get rid of it."

instead of doing something other than scaning mopeage rant:
	say "A glance seems to indicate some unfortunate writing--either Curtis actually still believes that stuff, or he's embarrassed ever to have written it. Either way, he doesn't need to be alerted to you knowing about it. Best to get rid of it."

instead of taking magenta rope:
	say "It would uncover Curtis's silly writings--the note and the rant. You'd be best off getting rid of all three, somehow."

megaton pear plans are plural-named auxiliary scenery. description of megaton pear is "[bug-report]".

rampage note is auxiliary scenery. description of rampage note is "[bug-report]".

mopeage rant is auxiliary scenery. description of mopeage rant is "[bug-report]".

a-text of magenta rope is "RYRYRRYRYRY". b-text of magenta rope is "RYRGRRGRYRG".

a-text of rampage note is "RYRYRRYRYRY". b-text of rampage note is "RYPYRRYPYPG".

a-text of mopeage rant is "RYRYRRYRYRY". b-text of mopeage rant is "RGRGRRYRGRY".

a-text of megaton pear is "RYRYRRYRYRY". b-text of megaton pear is "RYRYRRYRYRY".

the pomegranate is a fruit.

Instead of taking the peanut cola:
	say "Blech. Too nasty to touch. You might drink it in a moment of weakness."

after fliptoing pomegranate:
	now megaton pear is in lalaland;
	now rampage note is in lalaland;
	now mopeage rant is in lalaland;
	continue the action;

after examining drinks stand:
	if peanut cola is off-stage:
		now peanut cola is in rustic citrus;
	if magenta rope is off-stage:
		now megaton pear is in Rustic Citrus;
		now magenta rope is in Rustic Citrus;
		now rampage note is in Rustic Citrus;
		now mopeage rant is in Rustic Citrus;
	continue the action;

the citrus sign is part of the abandoned drinks stand. description is "It says CURTIS['] (sic) RUSTIC CITRUS.". the citrus sign is useless.

the eerie blurbs are part of the abandoned drinks stand. description is "A weird blue-purple. The worst of them reads BIEBER RULES.[paragraph break]Yup, this place needs help."

instead of taking blurbs:
	say "Please tell me you're not a fan of his.";

a-text of eerie blurbs is "RRYYRYRRYYR". b-text of eerie blurbs is "RRYYRYRRYYP".

check scaning blurbs when cheat-on is true:
	let a1 be b-text of eerie blurbs;
	let a2 be "PRYYRYPRYGP";
	say "They read [spacies of a1], except for 'Bieber Rules,' which says [spacies of a2]." instead;

the blueberries are a plural-named fruit. description is "Yes, they're really more purple, I know."

after examining abandoned drinks stand:
	if slime is off-stage:
		now slime is in Rustic Citrus;
		say "Eww. You also brushed against some slime while looking around.";
		now slime is in Rustic Citrus;
	continue the action;

the can of peanut cola is a thing. description is "There's an actual peon on one side, a neat cupola on the other. It's orange-pink and tan."

a-text of peanut cola is "RYRRYRYYRY". b-text of peanut cola is "RYRRYRYYRY".

the cantaloupe is a fruit.

check drinking peanut cola:
	say "[one of]Eww. Nasty[or]You don't want to repeat that experiment[stopping]. If only you could change it into something else entirely with just one word!" instead;

book Swell Wells

Swell Wells is north of Rustic Citrus. "Wells, err, swell from this [one of]lowland[or]old lawn[cycling]. You can go east to a loud clearing, or down the wells, or west to a filed field[if sorer bogey is visible]. You think you hear something from the wells[end if]."

the sorer bogey is ghostly scenery in Swell Wells. "You can't see the sorer bogey, but knowing it's there makes your skin break out in pimples...no, bumps."

check taking sorer bogey:
	say "Don't be a silly goose." instead;

a-text of sorer bogey is "RYYRYRYRRO". b-text of sorer bogey is "RGYRYPYRRB".

the gooseberry is a fruit.

s-w are privately-named scenery in swell wells. printed name of s-w is "the wells". understand "wells" as s-w. "'Ye borers, GO!' is written in red on the wells."

check inserting into s-w:
	if noun is coin or noun is coins:
		say "Maybe make your own luck by doing something with/to the coin[if noun is coin]s." instead;
	say "They're dry wells. You can see all the way down. If you want, you can go that way." instead;

check climbing s-w:
	try going down instead;

check going to Swell Wells for the first time:
	say "'Ramble, ambler!' Curtis calls.";

the lost slot is a thing. description of lost slot is "It's soft to the touch, as if it could change its shape for the right item."

understand "lots" as a mistake ("You only need the one slot.") when lost slot is visible.

Swell Wells is in Others.

the silly shirt is a thing in Swell Wells. "A silly shirt lies here."

the riot cap is a thing in swell wells. description is "It's orangish-reddish, an odd pastel. It looks even dumber than the moss cap from Curtis. Red writing is stamped on each side of the riot cap. You can read it.". "A riot cap hangs from one of the wells."

a-text of riot cap is "YRRYRYR". b-text of riot cap is "YRRYPYR".

the apricot is a fruit. "It's a regular apricot. Nothing special."

instead of doing something with riot cap:
	if action is procedural:
		continue the action;
	say "You wouldn't want to make the riot cap parotic--you can't imagine violence ahead."

description of silly shirt is "It's a hideous red-and-green-and-yellow blend with the phrase 'Got ESP, PAL?'"

a-text of shirt is "YRRRYR". b-text of shirt is "YRPRYR".

instead of doing something with silly shirt:
	if action is procedural, continue the action;
	say "You wouldn't want to take or wear the shirt. Maybe it can be recycled.";

the apples are plural-named fruit.

check opening slot:
	say "It will fit if you give it the right thing." instead;

check closing slot:
	say "It needs to be open--or how will you pass the gate?" instead;

book gates stage

Gates Stage is north of Swell Wells. "Important-looking gates lead to the north. They don't look strictly locked, but you probably need some sort of ID--or confidence--to get by them. Behind them you see [if arena is examined]the Admit-Us Stadium[else]a near arena[end if]."

Gates Stage is in Others.

A near arena is scenery in Gates Stage. "[one of]It looks familiar--wait--it's Yorpwald's famous, enormous Admit-Us Stadium! What's more, you hear a hubbub that means some event must be going on[or]The Admit-Us Stadium stands behind the gate, a hubbub still indicating that something important must be going on[stopping]."

understand "stadium/admit" and "admit us" as arena when arena is examined.

check going inside in gates stage:
	try going north instead;

check entering gs:
	try going north instead;

check entering d-d:
	try going north instead;

does the player mean entering gs: it is likely;

instead of doing something with a near arena:
	if action is procedural:
		continue the action;
	say "You can't do much but look at the arena."

gs are privately-named scenery in Gates Stage. printed name of gs is "gates". "They're [if player has passport]open for easy entry north[else]closed by a halt lath[end if]."

understand "gate" as gs.

the halt lath is part of the gs. the halt lath is undesc.

instead of doing something with the halt lath:
	say "[if player has passport]You don't need to do anything with the halt lath[else]The halt lath looks sturdy and won't be budging[end if].";

d-d is north of gates stage. d-d is privately-named. "You've reached the Admit-Us Stadium, but you shouldn't be seeing this text."

printed name of d-d is "Admit-Us Stadium".

understand "gates" as gs.

check closing gs:
	say "They're not some late game lame gate. They won't open or close at your whim." instead;

check opening gs:
	say "[if player has passport]You need some sort of passport to get through.[else]You wave the passport and the grates start to creak open.[end if]" instead;

instead of opening gs:
	try going north;

instead of giving something to gs:
	say "The gates seem to have a sensor that can detect if you have ID[if player has passport]. You know, that passport should be enough[end if]."

perp-check is a truth state that varies.

to say two-of-three:
	say "[if searcher is not reflexed]prep and review[else if viewer is not reflexed]research and prep[else]review and research[end if]"

perp-clued is a truth state that varies.

check going north in Gates Stage:
	if player does not have passport:
		say "'Need ID! Indeed!' the gates say mechanically." instead;
	if number of carried fruits > 0:
		say "(First returning the extra fruit[unless number of carried fruits is 1]s[end if])[paragraph break]";
		now all carried fruits are in lalaland;
	if gate-level is 0:
		now perp-clued is true;
		say "You try to sneak through--you're backstage at the Admit-Us Stadium! You might be able to make a big speech, but you are too terrified. The passport doesn't help a bit as a bouncer yells 'Perp!' Maybe you can learn from the passport. Or parts of it." instead;
	else if gate-level is 1:
		say "[one of]You try to sneak into the Admit-Us Stadium, and you hold up under some questioning--but you don't have enough 'cool' to get past the final guard. [if perp-check is false]He yells 'PERP!' and pushes you back. [end if]And with the stage in sight! Thankfully, you have enough to know you'd better leave before people turn hostile[or]You haven't learned anything new since your last attempt to enter[stopping]. Maybe you can use that passport some more." instead;
	say "You've managed to [two-of-three] about this whole charisma thing, but you wonder, does it really work? Is it really that easy, if you don't overthink it? Well, why not? You've mastered all the parts of speech, and now your knowledge of more practical word-use gets you by various guards in the Admit-Us Stadium. You're blinded by an air-gem mirage at the gig going on--the TV show, Optical/Topical Capitol, Elections Selection edition. A three-way debate: Interims Minister Rimstein, Ex-Brat Baxter of the Swanker Wankers and Fatherly Flaherty of the Ruthless Hustlers![paragraph break]The crowd gasps as they recognize you on the stage. But what do you say?'Able, I'd bailed,' you start. Silence at first.[wfak]Then, a lone voice. 'Re-speak, speaker!' The simple encouragment spurs you: [randbla][paragraph break]'Go, O.G.,' people call. You're on a roll: [randbla] [randbla][paragraph break]By trial 4 or 6, a fair vote proclaims you favorite. Everyone's all '[mami].' You can only say 'Ah, I try out authority.' Your Roman Manor becomes the Furthermore-Reformer Hut.[paragraph break]It won't be easy. You'll likely procrastinate a few big choices with random anagrams, from force of habit. But you've learned how, well, all KINDS of words work a bit better, now.[paragraph break]Congratulations! You achieved the 'extended' ending in A Roiling Original. There's not much more to do, except visit DEMO DOME MODE, if you want, which is a look behind the scenes.";
	now others is solved;
	if debug-state is true:
		append "Test passed for Others.[line break]" to the file of debuggery;
	choose the row with final response activity of putzing about in the table of final question options;
	now final response activity entry is nextlisting; [this is an awful hack but I'd rather not reveal this til after you beat OTHERS]
	choose the row with final response activity of nrling about in the table of final question options;
	now final response activity entry is nextreglisting;
	choose the row with final response activity of potzing around in the table of final question options;
	now final response activity entry is showing a list;
	choose the row with final response activity of potzing about in the table of final question options;
	now final response activity entry is showing list of lists;
	choose the row with final response activity of reging about in the table of final question options;
	now final response activity entry is showing regional lists;
	choose the row with final response activity of ddming in the table of final question options;
	now final response activity entry is demo dome moding;
	end the story finally instead;

every turn when player is in gates stage and perp-check is true and passport is not reflexed (this is the perp-clue rule):
	if a random chance of 1 in 2 succeeds:
		say "The bouncer's yell of 'PERP!' rings in your ears.";

chapter sonicing

does the player mean doing something with coins when coins are off-stage: it is likely.
does the player mean doing something with icons when icons are off-stage: it is likely.
does the player mean doing something with coin when coin is off-stage: it is likely.
does the player mean doing something with icon when icon is off-stage: it is likely.

the coin is a super-easy thing. description is "The coin really looks more omen-y than money. Perhaps its value is only symbolic, and it could help you with the stuff money can't buy. There's a singed design on it, which is signed."

[giving it to: coin, icon, coins, icons??]

a-text of coin is "YRYR". b-text of coin is "YRYP".

the icon is a thing. description is "The icon is designed to be too interesting to pitch but not important looking enough to be currency. There's a singed design on it, which is signed."

the coins are plural-named things. description is "The coins really look more omen-y than money. Perhaps their value is only symbolic, and they could help you with the stuff money can't buy. There's a singed design on them, which is signed."

the singed design is part of the coin. description is "The singed design is some sort of amalgamation of musical notes and instruments intertwined. You can't read who wrote it, but it makes the coin look more artsy than commercial."

after fliptoing (this is the shift the singed design rule) :
	if noun is s-c or noun is s-i or noun is icon or noun is icons:
		now singed design is part of the noun;
	continue the action;

understand "designs" as singed design when player has coins or player has icons.

check reading (this is the default to singed design rule) :
	if noun is icon or noun is coins or noun is icons or noun is s-c or noun is s-i:
		if singed design is not part of the noun:
			say "BUG: there should be a singed design to read." instead;
		try reading singed design instead;

instead of doing something with singed design:
	if current action is scaning:
		say "(You wind up scanning the coin instead.)";
		let myc be a random thing incorporating singed design;
		try scaning myc instead;
	if current action is examining:
		continue the action;
	say "You can't do much with the design except examine it.";

the icons are plural-named things. description is "The icons are designed to be too interesting to pitch but not important looking enough to be currency. Instead of someone important, they each have shattered musical notes on them. Each has a singed design, signed."

check scaning coins:
	say "The settler flashes back, with [if cheat-on is false]all five entries changing[else]all but the last entry--which stays red--changing[end if].";
	say "Hm. Maybe it would be better to scan just one coin?";
	if the player consents:
		let mytext be indexed text;
		if cheat-on is true:
			now mytext is b-text of coin;
		else:
			now mytext is a-text of coin;
		say "You see [spacies of mytext]." instead;

a-text of coins is "?????". b-text of coins is "?????".
a-text of icons is "RYRYR". b-text of icons is "RYRYR".

after fliptoing (this is the move the design rule) :
	if noun is s-c or noun is icons:
		now singed design is part of noun;
	continue the action;

understand "scion" as a mistake ("Money, or something like it, should not be the guide of you.") when player has s-i or player has coins or player has s-c or player has icons.

the s-c are privately-named plural-named things. description of s-c is "The coins vibrate from the sound they make. They looks even more omen-y than money.". understand "sonic/ coins" as s-c. printed name of s-c is "sonic coins".

understand "coin" and "sonic coin" as s-c when player has s-c.

a-text of s-c is "YRYRR". b-text of s-c is "YRY??".

the s-i are privately-named plural-named things. description of s-i is "The icons vibrate from the sound they make. They may have some hidden power. Or some trivial one.". understand "sonic/icons" and "sonic icons" as s-i. printed name of s-i is "sonic icons".

understand "icon" and "sonic icon" as s-i when player has s-i.

sonicing is an action applying to nothing.

understand "sonic" as a mistake ("Maybe if you had more than one [if coin is visible]coin[else]icon[end if].") when player has coin or player has icon.

to slot-appear:
	if lost slot is not part of storage box:
		say "The So-Great Storage box begins to rattle by your [if player has s-i]icons[else if player has s-c]coins[else][bug-report][end if], and a lost slot appears in it.";
		now lost slot is part of storage box.

check inserting into storage box:
	if lost slot is visible:
		say "The box has a slot, so I assume you meant that.";
	try inserting noun into lost slot instead;

check inserting into lost slot:
	if noun is s-c or noun is coins:
		say "The coins hum a bit before they're spit back out. You catch them. The box seems averse to money." instead;
	if noun is tekno-token or noun is coin:
		say "The box wheezes slightly and spits the monetary item back out." instead;
	if noun is icon or noun is icons:
		say "The box splutters for a while but eventually rejects the [noun]. Still, you must be close to having the right thing." instead;
	if noun is not s-i:
		say "That doesn't fit." instead;
	say "The icons fit just fine. The box opens up, dissolving to reveal a popstar's passport.";
	now storage box is in lalaland;
	now s-i is in lalaland;
	now player has popstar's passport instead;

the popstar's passport is an uncluing thing. description is "It's got a picture inside, of you. And surprisingly, it's flattering and realistic and electronic! With an artifact this rare, you feel [if viewer is reflexed or searcher is reflexed]full of[else]near to[end if] stardom most rad. It's interactive, too--there's a little viewer on the right and a searcher on the left, and once you really learn how to use it, maybe the passport can be a minder, too. Written on the bottom is some nonsense about how it's not enough to have the passport to improve quality of life--you need to use it, too."

check scaning the passport:
	if viewer is reflexed:
		say "The settler only lights up when it points at the searcher.";
		try scaning searcher instead;
	if searcher is reflexed:
		say "The settler only lights up when it points at the viewer.";
		try scaning viewer instead;
	say "The settler's reading for the passport seems to alternate between six and eight characters--for the viewer and researcher. You should maybe scan one individually." instead;

the viewer is part of the passport. the viewer is reflexive. description is "[if viewer is reflexive]You poke around at the viewer but aren't focused enough. You're convinced it should be good for you, and you can learn from it, but you are having too much fun messing around.[else]You've gotten what you can from it. Through the gates![end if]"

a-text of viewer is "RYRYYR". b-text of viewer is "RYRYGR"

instead of doing something to the viewer:
	if action is procedural or current action is reviewing:
		continue the action;
	try examining the viewer instead;

the searcher is part of the passport. the searcher is reflexive. description is "[if viewer is reflexive]You poke around at the searcher but aren't focused enough. You're convinced it should be good for you, and you can learn from it, but you are having too much fun messing around.[else]You've gotten what you can from it. Through the gates![end if]"

instead of doing something to the searcher:
	if action is procedural or current action is researching:
		continue the action;
	try examining the searcher instead;

chapter preping

to decide what number is gate-level:
	let A be 0;
	if viewer is reflexed:
		increment A;
	if searcher is reflexed:
		increment A;
	if passport is reflexed:
		increment A;
	decide on A.

to say n-gates:
	say "[if arena is examined]in the Admit-Us Stadium[else]to the north[end if]"

to upgrade-passport:
	if gate-level is 2:
		say "'Gray date? Great day!' you tell yourself. You feel ready to tackle what lies [n-gates], now[if cur-score of others < max-score of others]. You wonder if you could've helped Curtis a bit more, but that's totally up to you[end if].";
	else if gate-level is 1:
		say "You feel almost ready to tackle what lies [n-gates], now. Even if you didn't get anywhere, the failure might teach you something.";
	reg-inc;
	continue the action;

preping is an action out of world.

understand the command "prep" as something new.

understand "prep" as preping.

prepped is a truth state that varies.

carry out preping:
	if player does not have passport:
		say "[reject]" instead;
	if gate-level >= 2:
		say "No need to over-study or over-think. Through the gates!" instead;
	if passport is reflexed:
		say "You need to fiddle with the passport differently." instead;
	say "You use the viewer and searcher in tandem and learn about self-presentation, being charismatic, etc. While part of it seems artificial and open to abuse, it's easier than figuring out anagrams, that's for sure.";
	now passport is reflexed;
	upgrade-passport instead;

chapter reviewing

reviewing is an action applying to one thing.

understand the command "review" as something new.

understand "review [something]" as reviewing.

does the player mean reviewing viewer: it is very likely.

carry out reviewing:
	if noun is not viewer:
		say "[reject]";
	if gate-level >= 2:
		say "No need to over-study or over-think. Through the gates!" instead;
	if viewer is reflexed:
		say "You need to fiddle with the passport differently." instead;
	say "You conduct a thorough review. Of hard stuff and easy stuff and what's most relevant. It's easier than you thought.";
	now viewer is reflexed;
	upgrade-passport instead;

chapter researching

researching is an action applying to one thing.

understand the command "research" as something new.

understand "research [something]" as researching.

does the player mean researching searcher: it is very likely.

carry out researching:
	if noun is not searcher:
		say "[reject]";
	if gate-level >= 2:
		say "No need to over-study or over-think. Through the gates!" instead;
	if searcher is reflexed:
		say "You need to fiddle with the passport differently." instead;
	say "You conduct thorough research. Of hard stuff and easy stuff and what's most relevant. It's easier than you thought.";
	now searcher is reflexed;
	upgrade-passport instead;

chapter amonging

understand "among" as a mistake ("Maybe if there were mango trees around.") when mrlp is routes.

understand "go man" as a mistake ("That's the right idea but the wrong sorts of words.") when player is in clearing and mango is off-stage.

understand "nag mo" as a mistake ("[one of]You get all red faced asking people how to trade for a mango, and asking, and asking[or]That'd just get you red-faced again[stopping].") when player is in clearing and mango is off-stage.

understand "an omg" as a mistake ("Lashing out that way leaves you feeling you must be close to the right way to get a mango.") when player is in clearing and mango is off-stage.

book Clangier Clearing

check fliptoing when player is in clearing and player does not have tekno-token:
	if noun is not carried by player:
		let temp be number of fruits in lalaland + number of fruits carried by player;
		say "That would work, but you don't have anything resembling currency to haggle with. Maybe you [if temp < 8]can earn some currency elsewhere[else]can go see Curtis for remuneration. You've done a good bit[end if]." instead;

Clangier Clearing is east of Swell Wells. Clangier Clearing is in Others. "There's lots of noise among traders here, though most of them pay you no attention. That leaves you time to notice a list of prices and another banner saying AUCTION CAUTION. It looks like people are using all sorts of speech tricks and gesturing to haggle here."

after choosing notable locale objects when player is in clangier clearing:
	set the locale priority of len craig to 1;
	if tangerine is visible and tangerine is not carried:
		set the locale priority of tangerine to 3;
	repeat with froo running through fruits in clearing:
		if froo is not tangerine and froo is not carried:
			set the locale priority of froo to 6;

for writing a paragraph about a fruit (called froo) in Clangier Clearing:
	if froo is tangerine:
		continue the action;
	say "[if tangerine is in clearing]Also[else]Still[end if] for barter: [a list of not mentioned fruits in clearing].";
	now lemons are mentioned;
	now melons are mentioned;
	now nectarine is mentioned;
	now tangerine is mentioned;

understand "cigar" as a mistake ("That'd be out of place among fresh fruits. Plus, whether or not Len deserves a cigar, he doesn't deserve to be turned into one.") when player is in clearing.

understand "mango" as a mistake ("That's the fruit you need to find. You see red wondering where or how?") when player is in clearing and mango is off-stage.

clearing-fruits is a number that varies.

after fliptoing when player is in clearing:
	if noun is a fruit or noun is l-o-p:
		increment clearing-fruits;
	continue the action;

a tekno-token is a thing. description of tekno-token is "It bears the stamp of OKNet, who control its production and so forth. You have no clue how much is left on it, but though it looks like a bluer ruble, it's decent enough to barter with.". understand "tekno/ token" and "tekno" as tekno-token.

the l-o-p is privately-named proper-named reflexive scenery in Clangier Clearing. "Reading the list, the kumquat [if kumquat is reflexive]in particular seems too expensive and probably easiest to barter down, or whatever[else]is the most reasonably priced item on the list[end if], though other prices almost make you want to curse."

check taking l-o-p:
	say "That'd leave everyone in the market confused[if l-o-p is reflexed] and undo your help fixing the prices[end if]." instead;

understand "list/of/prices/" or "price list" or "list of prices" as l-o-p.

the printed name of l-o-p is "the list of prices".

a-text of l-o-p is "RRYRYR". b-text of l-o-p is "RPGRGP".

understand "precis" as a mistake ("It's already a precis, of sorts. Less pretentious words will work better here.") when l-o-p is visible.

understand "silt" as a mistake ("Dirty way to slash prices.") when l-o-p is visible.

understand "slit" as a mistake ("Dirty way to slash prices.") when l-o-p is visible.

the kumquat is a fruit. description is "Weird and orange and oblong."

check fliptoing kumquat when kumquat is in lalaland:
		say "Len Craig already gave you enough for your help. Don't push it." instead;

check fliptoing papayas when papayas are in lalaland:
		say "You already got credit for prompt payment." instead;

the auction caution is super-easy reflexive scenery in Clangier Clearing. "It's pretty clear: PAY ASAP covers over half of it. That probably applies to non-auctions, too.". understand "banner" as auction caution.

some papayas are a plural-named fruit. description is "Goldish and gourdish."

instead of doing something with auction caution:
	if the current action is taking:
		say "Vandalism." instead;
	unless the action is procedural:
		say "You can really only examine the banner[if caution is reflexive] or maybe get another fruit from it[end if]." instead;
	continue the action;

Len Craig is a person in Clangier Clearing. "[one of]A man introduces himself as Len Craig, proprietor of LargeInc. He's willing to haggle, if you have the right items[or]Len Craig is still here, waiting to haggle[stopping]."

description of Len Craig is "Unperturbed by the noise, he makes hand and nodding gestures at everything he has for sale."

some lemons are a reflexive fruit in clearing. some melons are a reflexive fruit in clearing.

check fliptoing lemons (this is the lemon-melon rule) :
	if player has lemons and melons are visible:
		try fliptoing melons instead;

description of lemons is "Sour and frowny."

a-text of lemons is "RYRYRR". b-text of lemons is "RYRYRR".

description of melons is "It's pebbled so it looks sour and frowny--a cool optical illusion."

a-text of melons is "RYRYRR". b-text of melons is "RYPYRR".

A nectarine is a reflexive fruit in Clangier Clearing.

a-text of nectarine is "YRRYYRRYR". b-text of nectarine is "YRPYYRRYR".

The description of the nectarine is "[if nectarine is reflexed]It's greener than green and could use aging, maybe a little wrinkling[else]It looks fully ripe[end if]." [ancienter/ancienter]

the tangerine is a reflexive fruit in Clangier Clearing. "A tangerine is here. Its wrinkles remind you of [one of]someone you'll remember if you examine again[or]Jorge Luis Borges's face[stopping]. It's stamped with some small lettering."

description of tangerine is "It says GUESS MY NATIONALITY (WIKIPEDIA IS USELESS HERE)"

a-text of tangerine is "YRRYRRYRY". b-text of tangerine is "YRRYRRGPG".

the small lettering is part of the tangerine. description is "GUESS MY NATIONALITY (WIKIPEDIA IS USELESS HERE)"

A quince is a reflexive fruit in Clangier Clearing. description of quince is "[if quince is reflexive]Written on it is NAME A PRICE IN ITALIAN[else]Nothing too special about it[end if]. It looks like your average combination of an apple and a pear."

a-text of quince is "RYRRYY". b-text of quince is "RYRRYG".

An overpriced peach is a reflexive semi-easy fruit in Clangier Clearing.

check taking a fruit when player is in clangier clearing:
	if player has noun:
		continue the action;
	say "That'd be shoplifting. Surely you can try to bargain instead." instead;

description of the overpriced peach is "[if peach is reflexive]Len Craig sees you looking at it and assures you it's expensive[otherwise]Plump and fuzzy[end if]."

a-text of peach is "RRYYR". b-text of peach is "RRYYR".

check taking (this is the shoplift in clearing rule) :
	if noun is in clearing:
		say "No stealing. This is a marketplace!" instead;

understand "solemn" as a mistake ("Why so grouchy? You got a good price on the lemons AND the melons.") when player is in clangier clearing.

chapter amonging

amonging is an action applying to nothing.

understand the command "among" as something new.

understand "among" as amonging.

carry out amonging:
	if player is in clearing:
		if mango is off-stage:
			if player does not have tekno-token:
				say "You'd look a little too suspicious mingling without anything of value to trade. Maybe when you have something, though.";
				preef mango;
				the rule succeeds;
			say "You mingle among the shoppers for a while. Eventually you find somewhere you didn't see before. You stifle an OMG when you see a mango. You stop to haggle. It goes well.";
			reg-inc;
			now player has mango instead;
		else:
			say "Snag mo['] mangos? No mas, G." instead;
	say "[reject]" instead;
	the rule succeeds;

book Filed Field

Filed Field is west of Swell Wells. "I'd call this a mowed meadow or a purest pasture, but that'd be cheating. Foliage cause foilage all directions except east. [if b-w are visible]Barriers west block you. [end if][if ppf is visible]A fence--the kind they call pipe panel--is here. [end if][if rapt figure is visible]A rapt figure towers here. [end if][if briar screen is visible]You can also see a briar screen, and you hear barren cries[end if][if ppf is in lalaland and briar screen is in lalaland and b-w is in lalaland and rapt figure is in lalaland]. You've gotten rid of all the junk here--good job![else].[end if]"

the b-r is scenery in Filed Field. "It's jammed into the ground. You can't take it.". printed name of b-r is "buried raft". understand "buried/raft" and "buried raft" as b-r.

the breadfruit is a fruit. description is "It doesn't look doughy at all."

a-text of b-r is "RRYYRRRYYR". b-text of b-r is "PRYYRRPYYP".

the barren cries are scenery in Filed Field. "You can't see them or where they're coming from. But they sound sour and bitter and tiny."

a-text of barren cries is "RRYRRYRRYYR". b-text of barren cries is "RRYRRYRPGGP".

the foliage is useless scenery in filed field. "It'll still block you going anywhere but back east, even with the more man-made obstacles gone."

understand "fidel" as a mistake ("A thin voice howls 'I fled!'") when player is in Filed Field.

Filed Field is in Others.

The briar screen is scenery in filed field. "It's stained dark off-red and smells kind of bitter. You can barely see what it is screening. Examining it amplifies the barren cries."

a-text of briar screen is "RRYRRYRRYYR". b-text of briar screen is "RPYRRYRPYGR".

after fliptoing cranberries:
	now briar screen is in lalaland;
	now barren cries are in lalaland;
	continue the action;

Instead of taking the briar screen:
	say "The briars it is screening would prickle you."

the jagged spoon is part of the rapt figure. understand "utensil" as jagged spoon. description of jagged spoon is "It's jagged at the end.".

instead of doing something with the jagged spoon:
	say "[one of]The utensil untiles nothing, nor does it contain luteins[or]All you need to know is, it's a hint, and you don't need to futz with it[stopping]."

the ppf is privately-named scenery in Filed Field. "It's not worth sneaking over or through, either way. It's an eyesore, really."

understand "pipe/ panel/ fence" as ppf. printed name of ppf is "pipe panel fence".

check taking ppf:
	say "You don't have the strength. Maybe you can change it, though." instead;

a-text of ppf is "RYRYYRRRY". b-text of ppf is "PGRGYRRRY".

the pineapple is a fruit.

the rapt figure is scenery in filed field. It is fixed in place.

a-text of rapt figure is "RRYRYRRYYR". b-text of rapt figure is "RRYRYRRGYR".

description of rapt figure is "It's smiling, with ruby red lips and white teeth. It's holding a jagged spoon."

the grapefruit is a fruit.

the dummy-mango is a useless thing. the dummy-mango is undesc.

a-text of dummy-mango is "YRYRR". b-text of dummy-mango is "YRYRR".

Some pryer bars are a thing in Filed Field. description is "They're not quite crowbars. They have drupelets on them.". "Some pryer bars sit here, and it'd be nice to put them to a less distasteful use than to break into places."

check touching pryer bars:
	say "They feel like spry rebar." instead;

a-text of pryer bars is "RYRRRYRRO". b-text of pryer bars is "RYRRRYRPO".

check taking pryer bars:
	say "You don't need to open any crates or fight anyone. This isn't that sort of game. Repurpose them, instead!" instead;

check taking drupelets:
	say "You could take a hint from them, but you can't take them. They're part of the pryer bars." instead;

the drupelets are part of the pryer bars. the drupelets are plural-named. description of drupelets is "Little dark-red spherical bits stuck together that'd probably burst with juice if you tried to pop them."

a raspberry is a fruit.

b-w are plural-named proper-named privately-named scenery in Filed Field. "The barriers west seem to mark the end of the Filed Field."

printed name of b-w is "the barriers west"

check taking b-w:
	say "Too heavy, and there's nothing west, anyway." instead;

understand "barriers/ west/w/" as b-w.

a-text of b-w is "RRRYRRYRRYYR". b-text of b-w is "RRPYRRYRRYYR".

strawberries are a plural-named fruit.

book Scape Space

Scape Space is an innie room in Others. Scape Space is below Swell Wells.

The reserved sign is semi-easy auxiliary scenery in Scape Space. "RESERVED for the DESERVER."

the guava is a fruit.

a-text of reserved sign is "RYRYRRYR". b-text of reserved sign is "*GRGPRG*".

description of Scape Space is "This well-hidden area may be a raft of criminal activity, or maybe any puzzles here may be criminally unfair."

an-a is a super-easy privately-named thing in Scape Space. printed name of the an-a is "An a". "An a is here, waiting for you to take it. Well, take it the right way.". description of an-a is "Greenish, then golden, then a nasty dark brown.". understand "the/an a" and "a" as an-a.

understand "banana" as a mistake ("Hm, that's the fruit you want, but which letter to grab? And how?") when an-a is in scape space and player is in scape space.

the pugnacious plant is a thing in Scape Space. "A pugnacious plant waits for a fight here."

a-text of pugnacious is "RRYRYRR". b-text of pugnacious is "RRYRYRR".

description of pugnacious plant is "It's completely indescribable and quite possibly mechanical. You hear a noise coming from it."

rhubarb is a fruit.

instead of doing something with the pugnacious plant:
	if action is procedural:
		continue the action;
	say "The plant senses you trying to do something with it and whips a burr at you. [one of]'Burr. Bah!' you say as you notice a brief red welt[or]'Bah. Burr,' you say, as a burr bounces off[or]'Arrh, bub,' you brag as you duck the plant's reflexive attack[or]'Bub...' Art Erd distracts you. 'Arrh!' you cry, as you pick out a burr the plant shot at you[in random order]." instead;

check scaning plant:
	say "The settler doesn't register anything, though the plant gestures threateningly. Maybe you need to be more hands-on, here." instead;

check scaning an-a:
	say "There should be only three letters, but you see more.";

Instead of taking an-a:
	say "You feel something ban you from taking an a. The a almost seems to say 'Na-Naa-B' as you take it.";

a-text of an-a is "RYRYRY". b-text of an-a is "YGRYRY".

The small yellow banana is a fruit.

Red Rat Art Erd is a person in Scape Space. "[one of]Oh my goodness! A tarred trader is here. But if you look closely--yes, it's Red Rat Art Erd! Who performed all sorts of 'risky' financial transactions, but Elvira managed to get him bailed out because he was being interesting and creative, or something. Some people tarred him, and, well, he deserved it[or]Red Rat Art Erd, the tarred trader, is stil slumped here. He probably got kicked out [if clearing is unvisited]from somewhere more reputable[else]of the Clangier Clearing[end if][stopping][if storage box is in scape space]--he's sort of holding out a box labeled So-Great Storage[end if]."

understand "tarred trader" and "tarred/trader" as Art Erd.

understand "retard" as a mistake ("You can picture people like Art Erd calling you, or people he 'provided financial services to,' that, but two wrongs don't make a right. Besides, if anything, he was being too clever.") when player is in scape space

understand "darter" as a mistake ("Art Erd has nowhere to run[if storage box is in scape space], and you don't know if you want him taking that storage box with him[end if].") when player is in scape space

rule for printing a locale paragraph about Art Erd:
	if storage box is in scape space:
		now storage box is mentioned;
	continue the action;

the so-great storage box is a thing.

the storage box is in Scape Space. "A box labeled So-Great Storage is here.".

description of storage box is "[unless lost slot is part of storage box]It's so great at storing, you can't find a way in there. It reads LOST SLOT, and the slot certainly, uh, is[else]There's a (formerly) lost slot in the box. What to put into it, now[end if].".

instead of opening box:
	say "If brute force worked, it wouldn't be so great for storage.";

check taking storage box:
	say "Art Erd guards it carefully. 'I need currency. Give me currency.'" instead;

check giving droll dollar to someone:
	if second noun is not Art Erd:
		say "[second noun] isn't seedy enough to accept it." instead;

check giving something to Art Erd:
	if player has storage:
		say "You've already traded." instead;
	if noun is coin or noun is coins:
		say "'[one of]No redeem. Need more.'[or]Too heavy.' Hey! A veto![in random order]" instead;
	if noun is dollar:
		say "He consults an imaginary calendar. 'Sell date. All's teed. Let's deal.' On receiving the dollar, he cries 'Monies so mine!'[paragraph break]You take the storage box.";
		now Art Erd has dollar;
		if player has s-i:
			slot-appear;
		now player has storage instead;
	if noun is tekno-token:
		say "Traceable. Be real, cat." instead;
	say "'An empty payment.' He's not interested in that. Just money." instead;

description of Art Erd is "Tarred literally and figuratively, he gives off an 'I'm sly. Slimy.' air. Grease agrees with him."

instead of doing something to Art Erd:
	if action is procedural:
		continue the action;
	otherwise:
		if player has storage:
			say "You don't want to deal with Red Rat Art Erd any more than you have to." instead;
		say "Art Erd shrugs, then does the 'let's swap' hand gesture. Hmm, what could you give Art Erd to get that so-great storage?"

The basket of blackberries is a fruit. description is "It's from Bickerers['] Lab, wherever that is."

the orange is a fruit in Scape Space.

understand "gorean" as a mistake ("This game isn't about sexual stuff. Not that there's anything wrong with that.") when orange is visible.

a-text of orange is "RY*RYYR". b-text of orange is "RY*RYYR".

instead of taking the orange:
	say "[one of]With a sleepy, sly 'Eep,' [or]T[stopping]he trader whips his hand out and grabs you with alacrity. Maybe even two lacrities--it was much faster and intenser than you thought possible. You back off, and he goes back to semi-dozing. You rage on and see red before thinking, Maybe you need to sneak up somehow."

chapter gonearing

gonearing is an action applying to nothing.

understand the command "go near" as something new.

understand "go near" as gonearing.

carry out gonearing:
	if orange is in Scape Space and orange is visible:
		say "You move cautiously, with moves as sneaky as Art Erd's that eventually got him tarred. He sees you grab it but sniffs 'O anger. A goner.' Sour grapes at the orange!";
		now player has orange;
		reg-inc;
		check-fruit-min instead;
	say "[reject]" instead;

instead of dropping the orange:
	say "But you worked so hard to get it!"

the barber sickle is a flippable vanishing thing in filed field. description is "It's the color of some sort of dark juice, similar in texture to the pryer bars.". "A barber sickle lies here, not sharp but very dark."

a-text of barber sickle is "RRYRRRYRRYYR". b-text of barber sickle is "PRYRRRYRRYYR".

check taking barber sickle:
	say "You don't need weapons in this game. Or a haircut." instead;

volume stores

book Strip of Profits

Strip of Profits is a room in Stores. "[if roved is true]Well, those stores you took care of are gone, and so is the megaton magneto-montage. [h-or-others].[else]Most of the twenty-six stores from your first time here remain, though you're not here to shop[which-stores].[paragraph break]A megaton magneto-montage[i-u] stands here.[end if]"

last-loc of Stores is Strip of Profits.

to say i-u:
	if magneto montage is unexamined:
		say ", which looks like a directory of some sort,"

to say h-or-others:
	say "[if store h is in strip]But Store H remains[else]That hoster remains where Store H was[end if]"

does the player mean entering a sto: it is likely.

understand "restow" as a mistake ("[if store w is visible]Store W glows red as you try this[else if towers are visible]The towers glow red as you try this[else]You did what you could in store W and the towers[end if]") when player is in strip of profits

after printing the locale description for Strip of Profits when Strip of Profits is unvisited:
	if roved is false:
		say "You remember something from your first trip to Yorpwald--how Terry would help you RETRY if you got stuck in any stores. So you write that in your pedanto-notepad. Also, as a fourth-wall note, if you have solved any area, simply type the command you used to win it.";
		pad-rec-lump "retry";
		pad-rec "warp";

disamb-store is privately-named useless scenery in Strip of Profits. printed name of disamb-store is "the entire store bank". understand "store" and "entire/ store bank/" and "stores" as disamb-store.

description of disamb-store is "[sto-desc].".

to say sto-desc:
	say "Some stick out more than others. Some have too many shoppers around. Some seem more solitary and ready to explore[one of]. You notice stores F, I, M and R are missing--of course they are, since you got past them to the forest, sortie, metros and resort last time here[or][stopping]. You can examine one in particular with, say, X STORE Q"

instead of entering disamb-store:
	say "Hmm, you can't enter all the stores at once. You'll need to pick a store--you can also refer to it by its abbreviation, e.g. Q for Store Q.";

does the player mean examining disamb-store:it is likely.
does the player mean entering disamb-store: it is likely.

check going south in Strip of Profits:
	if hoster is not visible:
		try going west instead;

to decide whether (myp - a thing) is nonpost:
	if myp is not a portal, decide no;
	if myp is hoster, decide no;
	if myp is in strip of profits, decide yes;
	decide no;

check going inside in Strip of Profits (this is the which portal rule) :
	if number of maingame portals in strip is 1:
		if hoster is in strip:
			say "You figure the hoster can be put off [']til later.";
		try entering a random visible maingame portal instead;
	if hoster is in strip and roved is true:
		say "Yup. Only the hoster's left.";
		try entering hoster instead;
	if number of maingame portals in strip > 1:
		say "You have more than one area you can enter[if hoster is in strip], not counting the hoster, which you'll deal with later[end if].";
		let RP be nothing;
		let curdif be 99;
		repeat with EP running through portals in strip:
			if diffic of EP < curdif:
				now RP is EP;
				now curdif is diffic of EP;
		say "[line break]The[if RP is e-s], er, spot[else] [RP][end if] look[if RP is not plural-named]s[end if] le[if number of portals in strip is 2]ss[else]ast[end if] intimidating[if RP is smoke cloud], though maybe not even worth it[end if]--try [if RP is plural-named]them[else]it[end if]?";
		if the player consents:
			try entering RP instead;
		say "Okay. [if RP is plural-named]They're[else]It's[end if] not going anywhere[unless patcher is off-stage], unless you fry it with the patcher[end if]." instead;
	if smoke cloud is in strip:
		try entering smoke cloud instead;
	say "There's nothing you can enter--the plain old stores don't count. You don't have time to shop." instead;

instead of doing something to ads:
	if action is procedural, continue the action;
	say "They aren't what's really wrong with Yorpwald. I mean, they're not right, but they're an inevitable consequence of a place not in total peril. Best do something with the stores, or what they can become, instead.";

to say which-stores:
	if number of visible flippable stos is 0:
		say ", but there aren't any more you can switch up";
		the rule succeeds;
	if number of visible flippable stos is 1:
		say ". Only [random visible flippable sto] is still worth investigating";
		the rule succeeds;
	let BBQ be a list of things;
	now BBQ is list of flippable not bedruggled stos in Strip of Profits;
	remove Store B from BBQ, if present;
	remove Store H from BBQ, if present;
	sort BBQ;
	let A be indexed text;
	now A is "[BBQ]";
	now A is "[A in title case]";
	replace the text "store " in A with "", case insensitively;
	replace the text "And" in A with "and";
	say ". Stores [A] seem in decent shape[if hoster is visible], but that hoster you made looks too scary for now[end if].[no line break][tokies] Looks like near the end of the alphabet's where it's at";

definition: a sto is game-critical:
	if it is not in Strip of Profits, no;
	if it is not flippable, no;
	if it is bedruggled, no;
	if it is Store H, no;
	if it is Store B, no;
	yes;

definition: a sto is supporting:
	if it is Store T, no;
	if it is Store H, no;
	if it is Store B, no;
	if it is bedruggled, no;
	if it is game-critical, yes;
	no;

to say tokies:
	if number of visible bedruggled stos is 0:
		say "[no line break]";
		continue the action;
	say " Also, [list of visible bedruggled stos] seem[if number of visible bedruggled stos is 1]s[end if] nearly condemned.[no line break]";

section ads

check scaning ads:
	say "Few have deeper meaning. You wonder if they are worth scanning with your own eyes." instead;

to say hawk-blare:
	increment this-ad;
	let mxad be maxidx corresponding to a mytab of table of ad slogans in table of megachatter;
	if this-ad > mxad:
		say "exhorts HANKER! HARKEN! You must be at the end.";
		now this-ad is 1;
		continue the action;
	choose row this-ad in table of ad slogans;
	say "[if blare entry is true]blares[else]hawks[end if] [blurb entry][if blare entry is false][end if]"

this-ad is a number that varies. this-ad is usually 0.

chapter roveovering

roveovering is an action applying to nothing.

understand the command "rove over" as something new.

understand "rove over" as roveovering.

roved is a truth state that varies.

to say h-other:
	say "[if store h is visible]Store H[else]the hoster[end if]";

carry out roveovering:
	[d "[number of fruits] fruits: [list of fruits]. [list of backdrops] = backdrops.[line break]";]
	if roved is true:
		say "You already did." instead;
	if player is not in dusty study:
		say "You're not sure where to." instead;
	if Gunter is not off-stage:
		say "It's not that easy. Maybe once you've returned [if player is in study]back here [end if]to your Dusty Study, you can sneak out a more usual passage. But you need to fix things in Yorpwald, first. Or restart the game." instead;
	say "Oh man. That's right. Those adventures--the routes, the troves--and Curtis. Elmo told you to ROVE OVER. Better than Gunter's [one of]cringy-crying[or]slimey-smiley[or]bubbly-blubby[in random order] plea peal, a big tear rate about Elvira...mumbling 'Sad I said a dis.' No, you don't want a CHANCE to be suckered [if stuff-found < 3]if he comes knocking[else]by opening that door[end if]. You slip out a secret passage. Shouldn't need a last atlas for this, but...don't slow down LOTS. You eat a carbo-carob cobra for the long journey.";
	now roved is true;
	now first-good-scan is true;
	now kind-of-cool is true;
	move player to strip of profits;
	repeat with ZT running through needed regions:
		now ZT is bypassed;
	repeat with ZT running through patchable things:
		now ZT is in lalaland;
	now Store K is in lalaland;
	now Store N is in lalaland;
	now magneto is in lalaland;
	now player has super purse;
	now player has letters settler;
	now player has pedanto-notepad;
	the rule succeeds;

chapter stores

the windows are useless plural-named scenery in Strip of Profits. the windows are undesc. understand "window" as windows.

instead of doing something with windows:
	if current action is attacking:
		say "Unfortunately, if you enter a store that way, while it's still a store, there'd be nothing worth exploring.[paragraph break]Plus Elvira'd have a field day if and when you get caught." instead;
	unless action is procedural:
		say "Unfortunately, with all those windows, it's hard to be specific. But you should be able to refer to the store with the windows you want to look in." instead;
	say "Unfortunately, you can't do much with the windows. Since stores sort of have to have them, that gets ambiguous. It's probably simpler to refer to the store you want to inspect.";

does the player mean scaning a sto:
	it is very likely;

a sto is a kind of thing. a sto is usually undescribed. a sto is usually fixed in place. description of a sto is "This is some posh shop or other. But it has been integrated into the whole strip. It can't lead anywhere interesting."

specification of sto is "Something that may or may not change into a portal."

the plural of sto is stos.

instead of entering a sto:
	if noun is store b:
		say "You [if store b is reflexive]need to say what you want a free sample of[else]already got your free sample[end if]." instead;
	if noun is store c:
		say "You'd have to show ID. Then they'd know who you were. Then Elvira would have you arrested. Plus, ew." instead;
	if noun is store h:
		say "[if roved is true]You need to figure how to convert Store H into something different[else]Store H looks so wild and confusing, you're disoriented when approaching it. Maybe take care of Elvira first[end if]." instead;
	if noun is store k or noun is store n:
		say "That looks distinctly too seedy. It actually does need to be demolished, somehow." instead;
	if noun is store r:
		say "You can't go back to your resort. Not until Elvira's dispatched." instead;
	if noun is useless:
		say "There's nothing you'd want in that store, even if you were shopping." instead;
	if noun is flippable:
		say "Probably not in its present state." instead;
	say "You're not here to shop. You're here to save Yorpwald[if noun is nonreflexive]. Not shop in some random store[one of]. You changed a few other stores to get where you needed before--maybe do that again[or]. Like this one[stopping][else], and you remember how changing stores helped you get places before[end if]."

a sto can be bedruggled. a sto is usually not bedruggled.

to say gd:
	say "It's oddly greyed out, like an area in a video game you can't get to. [no line break]"

store-a is a privately-named useless sto. understand "store/ 1/one/a" as store-a when player is in Strip of Profits. the printed name of store-a is "Store A".

Store B is a LLPish reflexive sto. understand "store/ 2/two" as Store B when player is in Strip of Profits.

a-text of store b is "RYRRYR". b-text of store b is "PYRRGR".

description of Store B is "It's not as greyed out as most of the other stores. It reads BERTO'S (crossed out) then OBERT'S BEST, OR... It also claims to be better than Dupree Pureed[if store b is reflexive]. It's probably some sort of food store, and it feels a bit cold nearby[end if][one of]. You think you see who built this--you could examine it again. Red text[or]. The builder's name is REST, BO, in red text[stopping]."

Store C is a useless sto. understand "store/ 3/three" as Store C when player is in Strip of Profits.

description of Store C is "[one of]To porn! Pronto! [or][stopping][randbla]".

check examining Store C for the first time:
	say "You look in, noticing a corset ideal for the escort sector--and that the doorbell if you're (lol) bored is in the basement--but She Bop Phobes cry 'Skeezer! Eekzers! Sicko! So ick!'[paragraph break]";
	ital-say "store C is a no gamier mirage but a pro-sin prison--enough smut you must need Tums--so this fun fort may be a turnoff to examine again[if censor-minor is true], especially since you have profanity disabled[end if]. So, pardon da porn (hetero or the other) or call pornog no-prog. I'm not judging. I just discovered them all by intellectual curiosity and guesswork, so stop saying that. Go on. Harp. Pry.";
	the rule fails;

Store D is a useless sto. understand "store/ 4/four" as Store D when player is in Strip of Profits.

Store E is a useless sto. understand "store/ 5/five" as Store E when player is in Strip of Profits.

description of Store E is "It's bolted up but seems to be advertising a stereo sale."

the forest is useless scenery in Strip of Profits. understand "store f" and "store/f" as forest when player is in strip of profits. "It's not really Store F any more. It's been preserved--a foster forest. But new stores have sprouted up."

instead of doing something with the megaton magneto montage:
	if current action is scaning:
		say "Your settler registers nothing. It looks too dense to change. Besides, it's got information on the stores, and you wouldn't want to lose that." instead;
	if action is procedural:
		continue the action;
	say "The magneto-montage's not good for much besides looking at. But it's a useful guide.";

instead of entering forest:
	say "You don't know if you'd be welcome at that tourist trap, and there's nothing more to do there."

the megaton magneto montage is useless scenery in Strip of Profits. printed name of montage is "megaton magneto montage"

understand "look behind [thing]" as searching.

description of megaton magneto montage is "It's a sort of directory of all the stores[one of]. You read it through, but you can gloss through it for interesting bits (or even call it LM,) later[or]. You gloss through for what interests you[stopping].[paragraph break][b]CLOSED ON YORPDAY (that's today)[r]: A, D, E, G, J, L, O, Q, S, X, Z[if store b is reflexive][line break][b]FREE SAMPLES: B[r][end if][if store c is not examined][line break][b]NO PRUDES, USED !!!!: C[r][end if][line break][b]DON'T BOTHER UNLESS YOU'VE NOTHING, I MEAN NOTHING, TO DO[r]: H[one of][line break][b]OF HISTORICAL SIGNIFICANCE[r]: F/Forest, I/Sortie, M/Metros, R/Resort[or][stopping][if store k is in strip or store k is in strip][line break]CONDEMNED: K, N[line break][end if][b]NOT ELVIRA-APPROVED. ENTER AT OWN RISK[r]: P, U, V, W, Y[if store t is in profits][line break][b]ELVIRA SAYS KEEP EXTRA DOUBLE OUT[r]: T[paragraph break][engrav-note]."

to say engrav-note:
	say "[if engravings are examined]Those engravings are at the bottom, too[else]You note engravings craftily hidden below all this[end if]"

check examining magneto montage when roved is true:
	say "It's not really relevant now that there's just [if store h is visible]Store H[else]the hoster." instead;

change-warn is a truth state that varies.

after examining magneto montage when change-warn is false:
	if number of solved regions + number of bypassed regions > 1:
		say "It's kind of out of date since you got to work, but it'll be good enough reference in the future.";
		now change-warn is true;

Store G is a useless sto. understand "store/ 7/seven" as Store G when player is in Strip of Profits.

understand "ergots" as a mistake ("You're trying to rescue the people of Yorpwald, not give them fungus infections.") when Store G is visible.

understand "gorest" and "go rest" as a mistake ("Store G is too busy to allow that these days.") when Store G is visible.

Store H is a sto. understand "store/ 8/eight" as Store H when player is in Strip of Profits. [description of Store H is "Spray painted on this locked store is: others are in the throes of being reshot."]

description of Store H is "Store H appears broken-down. It sprawls a bit but is not particularly tall. A warning in bright red says:[paragraph break]'All who enter here risk exclusion. Closed for having a truly frightening HOSTER. Trespassers will be, er, shot. - E. S. Roth'"

understand "tosher" as a mistake ("[if store h is in strip]Insults will get you nowhere. You see red at thinking such a word[else]The hoster does look a bit weird, but you need to enter it, not change it[end if].") when player is in strip of profits

a-text of store h is "YRRYRR". b-text of store h is "YPRYRR".

check scaning store h:
	if otters is not solved:
		say "The settler gives a weird noise, as if it doesn't want to scan this store--yet." instead;

understand "throes" as a mistake ("No, you are not in your last throes. Neither is Yorpwald. [if otters is solved]Try thinking of a more common word[else]Try looking at the other end of the alphabet[end if].") when Store H is visible or hoster is visible.

understand "hoster" as a mistake ("That was sort of a given from the warning on Store H[if Store H is unexamined], as you note E. S. Roth's signature[end if], and it is all in red. So none of those letters are in place. Hmm, what's a place/person that's been isolated?") when Store H is visible.

the hoster is a not lumpable not maingame portal. "That stupid hoster is here where Store H was. [if roved is true]Since[else]If[end if] you have nothing better to do than save Yorpwald, it's worth a shot.". description is "It's a truly terrifying open, smiling mouth, being far too welcoming. It might be worse if it had a cavity, but it's pretty bad. You're not sure you want to know where it leads."

understand "mouth" as hoster.

does the player mean entering a sto:
	it is very unlikely.

does the player mean doing something with Store Z:
	it is unlikely.

check entering hoster:
	if rustic citrus is visited:
		continue the action;
	if roved is false:
		say "You think about entering, but you remember Elmo saying it wasn't critical to save Yorpwald." instead;

the sortie is useless scenery in Strip of Profits. understand "store f" and "store/f" as sortie when player is in strip of profits. "The sortie leads to the erstwhile Lord Ablemiser's territory, which you were able to neutralize your first time through. You think he still likes you--but you've no time to verify that."

instead of entering sortie:
	say "You don't know if you'd be welcome at that tourist trap, and there's nothing more to do there."

Store J is a useless sto. understand "store/ 10/ten" as Store J when player is in Strip of Profits.

Store K is a bedruggled sto. understand "store/ 11/eleven" as Store K when player is in Strip of Profits.

understand "stroke" as a mistake ("You need a stroke of genius, but that's all wrong. You are left seeing red a bit. But this puzzle probably isn't worth risking your health over.")

a-text of Store K is "RYRYRR". b-text of Store K is "RYRYRR".

the smoke cloud is a not maingame not lumpable portal. diffic of smoke cloud is 1. "The tokers['] smoke cloud hovers--[if lectures is visited]but you don't want to go back[else]maybe there's a small 'adventure' inside[end if]."

description of smoke cloud is "It hangs all around the tokers[if lectures is visited]. You don't really want to go back[otherwise]. But it probably can't harm you. Maybe it even leads to adventure[end if]."

go-region of smoke cloud is stores.

check entering smoke cloud:
	if nestor is off-stage:
		say "'Dude, we, like, can't share these righteous fumes unless you help us. Maybe find our friend or something.'" instead;
	if lecturer is reflexive:
		say "The tokers beginning singing 'Oh sigh, so high,' then 'TO PHONY TYPHOON!' and you're all 'Rest. OK?' You step into the smoke cloud and find yourself on a way high highway. (Proof that stuff's an entry drug.) You wind up saving lands similar to Yorpwald which speak Spanish, French, German and Italian.[paragraph break]Well, in a dream, anyway. Then you wake up. A policeman towers over, asking if you're on drugs: 'Don't cop a lie, man. No jukein['] on, junkie.'[paragraph break]After a stern lecture about how using drugs makes you miss obvious details (other than, well, a WANTED poster of you that you see) and you druggies think you're special but there's nothing magical about drugs, the no-[crap] narc-op pushes you to an anti-drug seminar.";
		min-up;
		now player is in lectures instead;
	say "Oh, no. Not that again. Country'll have a new alphabet the next time. And a worse lecture." instead;

check smelling when smoke cloud is visible:
	say "Err. I can't tell you exactly how the smoke smells. I wouldn't know." instead;

after choosing notable locale objects when player is in strip of profits:
	if store h is in strip of profits:
		set the locale priority of store h to 0;
	if hoster is in strip of profits:
		set the locale priority of hoster to 0;
	if otters-x are in strip of profits:
		set the locale priority of otters-x to 10;
	if tokers are in strip of profits:
		set the locale priority of tokers to 1;
	if tokers are in strip of profits and nestor is in strip of profits:
		set the locale priority of nestor to 0;
	continue the action;

the tokers are plural-named people. "Some tokers are here[if Store N is visible], moaning about their friend they lost nearby[otherwise], doing their tokin['] thing[if-nest]."

for writing a paragraph about a lumpable portal (called ptl) :
	say "Where stores once sat, you can now enter [list of lumpable portals in location of the player].";
	now all lumpable portals in location of the player are mentioned;
	continue the action;

rule for printing a locale paragraph about tokers:
	now nestor is mentioned;
	continue the action;

to say smocloud:
	say "[if lectures is unvisited]can enter that[else]figure you should avoid that[end if]"

to say if-nest:
	if nestor is visible:
		say ", your friend Nestor participating fervently"

description of tokers is "Long-haired, lazy, babbling bums, unwilling to do anything nearing earning. Their taste in clothes is worse than their taste in music. they seem to be fervently arguing whether it is best to say dude, like, or man too much."

description of Store K is "[one of]A peculiar smell of smoke and incense seeps from Store K, but that's probably not the BIG reason this place went downhill. 'Hey! stop violating our privacy, Dude, or we will maybe, like, insult you next time![or]'Dude! We're trying to REST, OK?' someone looks briefly at you through bloodshot eyes.[or]Someone with bloodshot red eyes begins blasting the truly awful music of K. T. Rose.[or]You wonder how they can rest okay while listening to the music of K. T. Rose.[stopping]"

Store L is a useless sto. understand "store/ 12/twelve" as Store L when player is in Strip of Profits.

description of Store L is "You take a peek inside but feel loster and loster as you do."

the metros are useless plural-named scenery in strip of profits. understand "store m" and "store/m" as metros when player is in strip of profits.

description of metros is "It's probably a quick path to Mt. Rose, which does not need your help. In fact, with public opinion as it is right now, if you showed up there, you might get beaten up for implying there was something wrong with Mt. Rose."

instead of entering metros:
	say "You don't know if you'd be welcome at that tourist trap, and there's nothing more to do there."

Store N is a bedruggled sto. understand "store/ 14/fourteen" as Store N when player is in Strip of Profits.

description of Store N is "Someone appears to be in there."

a-text of Store N is "RYRRYR". b-text of Store N is "RYRRYR".

Nestor is a person. description of nestor is "[if tokers are visible or smoke cloud is visible]Nestor is somewhere among the tokers, you'd guess[otherwise]Nestor pines for his most bummedly lost friends[end if].". initial appearance of Nestor is "Nestor mopes around, hoping his friends drop by."

rule for printing a locale paragraph about nestor:
	if smoke cloud is visible or tokers are visible:
		do nothing instead;
	continue the action;

to say no-stoner:
	say "";

understand "stoner" as a mistake ("[if nestor is visible]Being a stoner isn't treason. Use his real name.[else][one of]'Hey, man! Don't depersonalize me! Or I'll throw something at you!' You hear from inside Store N.[or]'Like, don't do it again, dude, or I will literally totally throw these empty bottles at you.'[or]The door to Store N opens, and two bottles whizz in your direction but nowhere close. They're bright red, and they appear to be lotions or something.[or]You've teased him enough. You should have enough clues to figure his name now, anyway.[stopping][end if]") when player is in Strip of Profits

the bottles of toners are a plural-named cluey thing. understand "lotions" as toners. description is "They are trial-sized bottle of toners for skin care[one of]. Thankfully, they weren't made of Sterno, which wouldn't have helped you at all[or]. They're so rent you can't see a brand name[or]There's lots--er, tons--to look at if you see it right[stopping]. The bottles are disgracefully red."

Store O is a useless sto. understand "store/ 15/fifteen" as Store O when player is in Strip of Profits.

Store P is a semi-easy sto. understand "store/ 16/sixteen" as Store P when player is in Strip of Profits.

understand "repost" as a mistake ("That's not what you need to do with [if store p is visible]store P--you even see red trying to figure HOW you would[else]the, er, spot[end if].") when store p is visible or e-s is visible

description of Store P is "There's a big poster in the window of this average-sized store."

a-text of Store P is "RRYRRY". b-text of Store P is "RRYRRY".

understand "pteros" as a mistake ("[if store p is in strip or e-s is in strip]You don't need to face any predators[else]They're in the past, and so are Store P and the Presto region[end if].") when player is in strip of profits.

the curst crust is a thing. description of crust is "[one of]It's probably from Curt's, the worst bakery in the world. [or][stopping]You have about [swears in words] bites of this disgusting thing left to eat."

understand "bread" as curst crust.

swears is a number that varies. swears is usually 2.

the e-s is a proper-named portal. diffic of e-s is 5. the go-region of e-s is Presto. the printed name of e-s is "an, er, spot". description is "It's hecka swirly. You're sure it goes somewhere the speech is louder and so forth.". initial appearance of e-s is "The, er, spot created when you said PRESTO swirls here."

understand "er/spot" and "er spot" as e-s.

prestoing is an action applying to nothing.

the tropes poster is part of Store P. the tropes poster is auxiliary and semi-easy.

description of tropes poster is "It features many important, if mis-stated, memes, including how certain nonsense words reliably move the plot forward or make something out of nothing. When you think on them, they are so pert, you see red."

a-text of poster is "RRYRRY". b-text of poster is "??YRRY".

Store Q is a useless sto. understand "store/ 17/seventeen" as store Q when player is in Strip of Profits.

description of store Q is "This is a posh shop like many others in the Strip of Profits. It doesn't look likely to hide any sort of portal, even shared with Store U."

Store R is a useless sto. understand "store/ 18/eighteen" as Store R when player is in Strip of Profits.

description of Store R is "It could lead back to your resort, to your Roman Manor. But you would not be welcome or safe there."

understand "resort" as a mistake ("You can't go back to the Roman Manor. Well, you can, but it's a bad idea.") when player is in strip of profits.

to say how-far-along:
	say "This needs to be filled in to describe the poster on Store P."

to decide whether you-can-advance:
	if number of solved regions < 5:
		decide no;
	decide yes.

Store S is a useless sto. understand "store/ 19/nineteen" as Store S when player is in Strip of Profits.

description of Store S is "As you get near, you hear GO AWAY YOU TOSSER. The accent doesn't sound British, so you suspect this person just needed to use a new swear and kind of forced things a bit."

Store T is a sto. understand "store/ 20/twenty" as Store T when player is in Strip of Profits.

understand "tortes" as a mistake ("There's no time for food! Especially fatty, non-brain food!")

a-text of Store T is "YRRYRR". b-text of Store T is "YPRYRR".

description of Store T is "Store T is average-sized, but it seems to repel you. Its window is really lovely stained-glass--it's a depiction of a family of sea animals. There's an engraving below it."

otters-x are a privately-named plural-named not lumpable portal. printed name of otters-x is "the twin otters". understand "twin otters" as otters-x.

description of otters-x is "They are named Darin and Randi, according to what is engraved below. You see a field of barley beyond them. There's also something below their names, and it reads:"

understand "barely" as a mistake ("You [one of][or]still [stopping]aren't close enough for such a weak word to affect the barley. But that seems right[one of] and worth writing in your notepad[or][stopping].[preefsay of b-b]") when f-o-b is visible.

to say preefsay of (pfy - a thing):
	if pfy is not prefigured:
		preef pfy;
		say "[line break]";
		pad-rec-q "flips";

after examining otters-x:
	try examining engravings;
	now f-o-b is in strip of profits;

the engravings are part of magneto montage. the engravings are plural-named. understand "engraving" and "names" as engravings when engravings are visible.

description of engravings is "[emph of e-s]Man, [r][b]SOMEONE[r] [emph of towers-x]evil[r] [emph of troves-x]will[r] [emph of oyster-x]pay[r] [emph of routes-x]up[r], [emph of otters-x]hard[r][if note-progress is true].[paragraph break][i]NOUNED: UNDONE.[r][paragraph break]The letter emphases seem to have changed since you last read it[npoff][end if]."

eng-scan is a truth state that varies.

check scaning engravings:
	say "None of the words on the engravings scan to anything.";
	now eng-scan is true instead;

after examining engravings when eng-scan is false:
	say "You scan the engravings, just in case, but none of the words turn up anything special. There's probably a different hint at stake, here. Also, it's odd an anti-Elvira message would be around. Maybe it's Gretta's clue Elmo mentioned, and maybe it'll make more sense after you've made your way a bit more.";
	now eng-scan is true;
	continue the action;

to say npoff:
	now note-progress is false;

to say emph of (r - a portal):
	say "[r]";
	if go-region of r is solved or go-region of r is bypassed or go-region of r is shortcircuited:
		say "[b]";
	if r is visible:
		say "[i]";

understand "randi" and "darin" as otters-x.

rule for printing a locale paragraph about otters-x:
	say "Statues of twin otters wait here, facing each other--it's all blurry behind them.";
	now otters-x is mentioned;

understand "twins/otters/statues" as otters-x.

f-o-b is privately-named scenery. printed name of f-o-b is "the field of barley".

description of f-o-b is "You look behind the otters at the field of barley. [if b-b is reflexed]There's not much left.[else]It's everywhere, up to your waist, with no end in sight.[end if]"

check entering otters-x:
	if number of needed regions > 0:
		d "[list of needed regions].";
		say "As you step between them, you feel mess-up spumes from the otters--maybe a passive sap-vise--drain you to a nadir. 'I...darn![paragraph break]You could take your powers going dormant, but they might get mordant. Maybe you need to build them up by fixing things elsewhere[if patcher is in strip of profits], or you can cheat with that patcher. I won't judge. The fate of a world is at stake[end if]." instead;
	if eels are not in lalaland:
		now inhib is true;
	say "You begin to feel drained, and you let out a 'darn, I...' you slow down but just make it. 'Rad! In!'"

Store U is a semi-easy sto. understand "store/ 21/twentyone" as Store U when player is in Strip of Profits.

understand "ouster" as a mistake ("It's your job to be the ouster in Store u, but how to get there?") when Store U is visible or routes-x are visible.

understand "sureto" or "sure to" as a mistake ("You'll be sure to figure it out sooner or later. You see red a bit at not quite being there yet.") when Store U is visible or routes-x are visible.

a-text of Store U is "RYYRYR". b-text of Store U is "RYYRGR".

description of Store U is "Though Store U is the smallest of the stores that stand out, along with Store V[if store v is not visible] before you changed it[end if], you see a dizzying array of branching possibilities inside. Well, roads, except each seems to have a number or label. The roads are red and almost seem to form letters if you look at them right."

the roads are part of store u. description is "When you stare just right, the red roads reform to 'Sure to set our...'"

instead of doing something with roads:
	if action is procedural:
		continue the action;
	say "The roads are inside the store. You can really only examine them." instead;

a-text of roads is "RYYRYR". b-text of roads is "RYYRYR".

the routes-x are a privately-named plural-named portal. diffic of routes-x is 2. understand "routes" as routes-x. the printed name of routes-x is "routes extending many confusing directions". initial appearance of routes-x is "odd winding routes".

description of routes-x is "They appear to branch out in all directions."

Store V is a sto. understand "store/ 22/twentytwo" as Store V when player is in Strip of Profits.

description of Store V is "Store V would be the smallest of the stores that stand out, but for Store U[if store u is not visible] before you changed it[end if]. Strange garnets lie inside. You also see a hologram of voters."

voters are part of Store V. understand "hologram" as voters. description of voters is "The voters in the hologram seem to be complaining 'Elections? Selection. Have to vote. Ha. Pols? Slop.'[paragraph break]An impressive display of defeatist thinking."

a-text of voters is "RRYRYR". b-text of voters is "RRYRYP".

a-text of Store V is "RRYRYR". b-text of Store V is "RRGRGR".

troves-x are a privately-named plural-named portal. diffic of troves-x is 3. understand "troves/jewels" as troves-x. printed name of troves-x is "troves of glittering jewels". go-region of troves-x is troves. initial appearance of troves-x is "[if Loather Rathole is visited]empty troves[else]troves of too-good-to-be-true jewels[end if] glisten here.". understand "trove" as troves-x. description of troves-x is "[if Loather Rathole is unvisited]Shiny. Tempting. You have enough room for a few jewels your super purse[else]You could probably go through the ordeal of them vanishing to get back to Spoiloplis[end if]."

instead of taking troves-x:
	try entering troves-x instead;

Store W is a sto. understand "store/ 23/twentythree" as Store W when player is in Strip of Profits.

a-text of Store W is "RYRYRR". b-text of Store W is "RYRYRR".

description of Store W is "It's the biggest structure in the strip. You see replicas of two tall, narrow buildings. You can also read a reddish inscription."

the reddish inscription is part of store w. the reddish inscription is cluey. description of reddish inscription is "WESTOR is the name of the company that built this. They used the SET-ROW method."

the towers-x are a plural-named portal. diffic of towers-x is 7. the go-region of towers-x is Towers. understand "two/twin towers" and "ivy/ivory tower" and "towers" as towers-x. the printed name of towers-x is "very tall twin towers". "Two towers, ivy or ivory, are here.". description of towers-x is "Ivy or ivory. You can't tell which is tower, er, two. Both are huge and intricate, and even one would be intimidating to enter."

the tower-base is privately-named. it is part of the towers-x. understand "base" as tower-base. the printed name of tower-base is "tower base". description is "There seems to be no reason you can't enter it if you wanted."

instead of entering tower-base:
	try entering towers-x;

the ivory tower is scenery. "You're sure it's even further from the real world of Yorpwald than Yorpwald is from, well, the real world."

the ivy tower is scenery. "You could view Troy from the top, if it existed. The ivy offers lousy privacy."

check entering ivy tower:
	say "You try to enter the ivy tower, but they keep shifting around, and you find yourself walking between them.";
	try entering towers-x instead;

check entering ivory tower:
	say "You try to enter the ivory tower, but they keep shifting around, and you find yourself walking between them.";
	try entering towers-x instead;

Store X is a useless sto. understand "store/ 24/twentyfour" as Store X when player is in Strip of Profits.

Store Y is a super-easy sto. understand "store/ 25/twentyfive" as Store Y when player is in Strip of Profits.

a-text of Store Y is "YORRYR". b-text of Store Y is "YORRGR".

description of Store Y is "The store seems filled with water. It's wide but not tall. You think you see shells. The window of store y has TOYERS in red with a line through."

the shells are part of store y. the shells are uncluing and undesc.

instead of doing something with the shells:
	say "Messing with the shells won't help you get in Store Y, but maybe they're a clue." instead;

the oyster-x is a privately-named portal. diffic of oyster-x is 6. the printed name of oyster-x is "oyster". understand "oyster" as oyster-x. the go-region of oyster-x is Oyster. "The oyster that was Store Y is open. You could definitely fit in.". description of oyster-x is "It's not particularly tall, but its wideness suggests there's a lot to do there."

understand "toyers" as a mistake ("You see red at the possibility people might mess with your mind in whatever's behind store Y--especially after noting the TOYERS with the red line through in the window.") when store y is visible.

understand "troyes" as a mistake ("Store Y does not lead to France.") when store y is visible.

instead of eating oyster-x:
	say "In Soviet Yorpwald, oyster eat you. Plus, it's all shell, no slime."

Store Z is a useless sto. understand "store/ 26/twentysix" as Store Z when player is in Strip of Profits.

understand "follow [text]" as a mistake ("This game doesn't allow the FOLLOW verb--you should ENTER a road or something if you need to.") [for ROUTES]

book Cruelest Lectures

Cruelest Lectures is an innie room in Stores. "You're standing in the back of an uncomfortable auditorium[one of]. People stare at a lecturer as if they've been drugged. Um, hypnotized[or][stopping]. Nearby, a passage leads to[if e-revealed is false] somewhere called[end if] Studio E."

check looking in lectures for the first time:
	say "As you march through the smoke, you hear 'Freeze! Anti-drug drag unit!' You turn around to see a tall bulky man wearing a T-shirt saying 'IAN. A DRUG GUARDIAN. QUADS SQUAD.'[paragraph break]'So! you're one of those people who have been poking around stores K and N. But these are no-drugs grounds. We finger fringe like you. [if smoke cloud is examined]Second hand funny-smoke. No rationalizations about how you cheat drug lords that way. It's an entry drug and that's facts. [end if]Let's go.'[paragraph break]He frog-marches you to an auditorium. It's quite a crowd, and you're a bit late, so you can't even sit.";

the seats are useless plural-named scenery in lectures. "'If you'd gotten here earlier, you might've gotten one,' growls Ian. You're not sure that'd make sense even if you actually [i]were[r] stoned."

instead of doing something to the seats:
	if current action is scaning:
		say "You consider scanning them, but it'd freak out the audience. Or Ian. Or the lecturer." instead;
	if action is procedural:
		continue the action;
	try examining seats instead;

rule for supplying a missing noun when entering:
	if location of player is Hero's shore:
		try entering raft;
	if location of player is Strip of Profits and number of visible portals is 1:
		now noun is a random visible portal;
	if location of player is Cruelest Lectures:
		if the player's command matches the text "sit":
			now noun is seats;
		if e-revealed is true:
			now noun is seats;
		now noun is passage.

the passage is scenery in lectures. "The passage that leads to Studio E seems unguarded. Maybe you could sneak in there."

instead of scaning passage:
	if e-revealed is true:
		say "You already got YYRRGRG from it.";
	else:
		say "Be brave! ENTER the passage!";

understand "studio e/" as passage.

e-revealed is a truth state that varies.

check entering passage:
	if e-revealed is true:
		say "No. Regardless of how cynical you are, you don't need to see that again. But you remember YYRRGRG." instead;
	say "You sense that you may uncover a deeply disturbing truth if you enter. Or, you might just get a too-spoilery hint that gets you out of here. Care to continue?";
	if the player consents:
		say "You step into studio E. There, you see well-known pharmaceutical industry barons discussing perfectly legal and safe substitutes to various illegal drugs, along with perfectly air-tight patents and tax avoidance schemes. You also see a bottle 'DORI'S ROIDS: for IAN' with a so-tired needle beside it.[paragraph break]You rush out of Studio E before you see anything more--although you quickly [if cheat-on is false]switch your gadget back and forth and note it[otherwise]note your gadget[end if] flashes YYRRGRG.";
		now e-revealed is true;
	otherwise:
		say "You decide to rely on what you see in the Lectures to get out.";
	the rule succeeds;

[strudel/lsd-ture and joke if eat after visiting]

the lecturer is a reflexive person in Cruelest Lectures. "A lecturer lectures lecturingly about why his wasting your time is better for society than how you waste your time. And how the sooner you agree, the less you'll waste HIS time, and the golden rule and stuff."

check scaning lecturer:
	say "You point your settler at the tedious lecturer.";

a-text of lecturer is "YYRRYRY". b-text of lecturer is "YYRRYRY".

understand "max p lee" and "max/lee" and "max lee" as lecturer.

description of lecturer is "He's wearing a very expensive suit and tie. You're not sure why they should be expensive, but you know they are. They're probably about as showy as drug dealers['] $5,000 suits and $300 ties. You read MAX P LEE, EXAMPLE projected behind him, and he is sponsored by RutCorp, who help pull you out of ruts, apparently."

idg is a privately-named person in Cruelest Lectures. printed name of idg is "Ian (a Drug Guardian)". description is "'What? Those biceps are from pure hard work. And a proper diet. And the right vitamins.' He nods and points to the lecturer.". "Standing by the only exit is Ian (a Drug Guardian.)"

understand "ian" and "drug/guardian" and "guardian" as idg.

instead of doing something with idg:
	if current action is scaning:
		say "'No offense, chum, but it's me who should probably be scanning you lawbreakers.' He nods and smiles, faux-friendly, and you turn back to the lecturer." instead;
	if current action is attacking:
		say "He's too big for you." instead;
	if player does not have heartfelt reflections:
		say "Before you can do anything with or to Ian, he thrusts a sheet of heartfelt reflections on drug use at you[one of][or] again[or] yet again[stopping]. 'It will help you in ways you don't know. And even I don't know.' Do you take it?";
		if the player consents:
			now player has heartfelt reflections;
			say "'Good choice. Say, if they're good enough, do you think you could put in a word for me--to a lecturer like THAT?" instead;
		otherwise:
			say "Ian looks hurt, then blames it on the lack of attention span from the drugs you've been taking. That cheers him up." instead;
	otherwise:
		if action is procedural:
			continue the action;
		say "Before you can do anything, Ian points at the heartfelt reflections he shared on you. Or at you. But not just plain with you. He's so much bigger than you, it distracts you from whatever you meant to do.";

The heartfelt reflections are plural-named thing.

after doing something with reflections:
	set pronoun it to reflections;

description of reflections is "It's a list of thirty-odd sentences beginning I USED TO. It's in hard-hitting simple language but no less painful to read for all that. I will spare you the details--a brochure's such a borer."

a-text of reflections is "YYRRYRY". b-text of reflections is "YGRRYRY".

check exiting in Cruelest Lectures:
	say "[one of]You make a half-hearted (well, 42.86%-hearted) effort to leave, but without a planned destination (jeesh! The self-help speak's already hitting you) you'll just wind up coming back around here. Even though it's so [i]tedious[r][or]You managed to leave for a bathroom break, and you were sort of curious what was in Studio E. You tried the door. It was locked[or]You might wander around inside, but you would come back. That's how you got stuck inside your cubicle at the company so long. Tedious but safe. Oops[or]They...they can't zap your severance check for ditching this tedious lecture? Probably not. But the ushers would guilt trip you into sitting back down[or]The lecturer isn't as tedious as coworker chitchat, but you never pulled yourself away from THAT, either[or]Tedious, tedious, tedious[stopping]." instead;

[say "[one of]Something [i]deters[r] you from leaving. You know the lecturer doesn't care about you one way or another, but you would feel guilty just walking out. As if you were giving up[or]If you were more [i]rested,[r] you might be able to leave without guilt.[or]You are almost ready to go, but then you see a brochure about [i]Ester D.[r] extolling a wonderful work-from-home moneymaking opportunity. 'It works! It really does! I'm proof!'[paragraph break]How can you pass that up?[or]Your eyes wander to an electronic timer with a [i]red set[r] of dots...[or]You cringe at the neologism the lecturer offered up early on. [i]REDEST[r]ination.[or]You hear a voice from behind the fourth wall loud-whispering LOOK AT THE STATUS LINE, ALREADY.[or]That voice, again. 'Good thing we're not playing hangman.'[or]Amazingly, I'm still going to give you a point once you say the right command.[or]Okay, now you're just fishing for smart-aleck responses. Get on with it, already![stopping]" instead;]

volume Towers

book drawing the map

to decide whether can-see-map:
	if waters is visited or limits is visited, decide no;
	if spec-o-scope is unexamined, decide no;
	if mrlp is towers, decide yes;
	decide no.

tow-x-start is a number that varies. tow-x-start is 320.
tow-y-start is a number that varies. tow-y-start is 8.
tow-delta is a number that varies. tow-delta is 16.
square-from-center is a number that varies. square-from-center is 4.

after examining spec-o-scope (this is the specoscope draw rule):
	draw-my-loc;
	continue the action;

to draw-my-loc:
	let myx be 0;
	let myy be 0;
	draw-towers-map;
	repeat through table of towers-locs:
		if location of player is my-loc entry:
			change current foreground-color to (R 0 G 0 B 0);
			now myx is tow-x-start + (tow-delta * my-x entry) - 2;
			now myy is tow-y-start + (tow-delta * my-y entry) - 2;
			draw a rectangle (current foreground-color) in current graphics window at myx by myy with size 5 by 5;

carry out looking when mrlp is towers (this is the towers YOU ARE HERE redraw rule):
	now the location is visited;
	if can-see-map:
		draw-my-loc;
	if deacons are visible and deacon-plot is false:
		say "The deacons don't see you coming at first. They quiet down once they do, but you could not help hearing their plot against the shrine nearby: a hostile ol['] heist if there ever was one!";
		now deacon-plot is true;
	continue the action;

deacon-plot is a truth state that varies.

to wipe-towers-map:
	if can-see-map:
		change current foreground-color to (R 255 G 255 B 255);
		let x-start be tow-x-start - square-from-center;
		let y-start be tow-y-start - square-from-center;
		draw a rectangle (current foreground-color) in current graphics window at x-start by y-start with size 1 + (2 * square-from-center) + (4 * tow-delta) by 1 + (2 * square-from-center) + (4 * tow-delta);

to draw-towers-map:
	let sqsz be (square-from-center * 2) + 1;
	let myx be 0;
	let myy be 0;
	repeat through table of towers-locs:
		if my-loc entry is accessible:
			if my-loc entry is unvisited:
				change current foreground-color to (R 42 G 126 B 126);
			else:
				change current foreground-color to (R 42 G 210 B 42);
		else if my-loc entry is sideview:
			change current foreground-color to (R 168 G 168 B 42);
		else if my-loc entry is mightaswell:
			change current foreground-color to (R 84 G 84 B 84);
		else:
			change current foreground-color to (R 210 G 42 B 42);
		now myx is tow-x-start + (tow-delta * my-x entry) - square-from-center;
		now myy is tow-y-start + (tow-delta * my-y entry) - square-from-center;
		draw a rectangle (current foreground-color) in current graphics window at myx by myy with size sqsz by sqsz;
	repeat through table of guard-org:
		if guy entry is in lalaland:
			change current foreground-color to (R 42 G 210 B 42);
		else:
			change current foreground-color to (R 210 G 42 B 42);
		draw-line loc entry and blockdir entry;

to draw-line (lcc - a room) and (bd - a direction):
	choose row with my-loc of lcc in table of towers-locs;
	let x-start be tow-x-start + (tow-delta * my-x entry);
	let y-start be tow-y-start + (tow-delta * my-y entry);
	let x-end be tow-x-start + (tow-delta * my-x entry);
	let y-end be tow-y-start + (tow-delta * my-y entry);
	if bd is north:
		decrease y-start by square-from-center;
		decrease y-end by (tow-delta - square-from-center) - 1;
	if bd is south:
		increase y-start by square-from-center + 1;
		increase y-end by (tow-delta - square-from-center);
	if bd is east:
		increase x-start by square-from-center + 1;
		increase x-end by (tow-delta - square-from-center);
	if bd is west:
		decrease x-start by square-from-center;
		decrease x-end by (tow-delta - square-from-center) - 1;
	linedraw (current foreground-color) in current graphics window from x-start by y-start to x-end by y-end with 1;
[To linedraw (hue - a number) in (win - a g-window) from (x1 - a number) by/x (y1 - a number) to (x2 - a number) by/x (y2 - a number) with (wgt - a number):]

table of towers-locs [arranged n to s then w to e]
my-loc	my-x	my-y
havens	1	0
route	0	1
anemic	1	1
deltas	2	1
coastlines	3	1
saltbed	1	2
ravages	2	2
shoreline	3	2
campsite	0	3
copse	1	3
sunbelt	2	3
Danger Garden	3	3
subsector	4	3
topside	1	4
lots	3	4

book basic guardian work

rule for printing a locale paragraph about a guardian (called gua):
	if gua is not ray eck:
		increment guardians-seen;
		say "[initial appearance of gua][no line break] ";
		if guardians-seen is number of visible guardians:
			say "[paragraph break]";
	continue the action;

guardians-seen is a number that varies.

before looking:
	now guardians-seen is 0.

towerclose is a number that varies.

after printing the locale description when mrlp is towers (this is the castle near/far rule) :
	let rm be location of player;
	let any-reveal be false;
	repeat with adude running through guardians in location of player:
		if adude is clueneedy and any-reveal is false:
			now adude is not clueneedy;
			now any-reveal is true;
			say "[kloozorz corresponding to a guy of adude in table of guard-org][paragraph break]";
	if rm is unvisited and rm is a towloc listed in the table of towercomments:
		choose row with towloc of rm in table of towercomments;
		if there is a towquo entry:
			say "[towquo entry][paragraph break]";
			if there is a towdist entry:
				if towdist entry > towerclose:
					now towerclose is towdist entry;
		else if there is a towdist entry:
			if towdist entry > towerclose:
				let tempint be towdist entry;
				say "[which-cue of towdist entry][paragraph break]";
				now towerclose is towdist entry;
		else:
			d "Room not defined but not critical";
	if player is in coastlines:
		if smart kid is off-stage:
			say "You think you hear rustling off to the side, as if someone or something is hiding from the [random visible guardian].[paragraph break]";
	continue the action;

the castle near/far rule is listed last in the after printing the locale description rulebook.

to say which-cue of (therow - a number) :
	say "[observ in row therow of table of townarr]";

table of townarr
observ
"[line break]The palace is barely visible now."
"The palace seems a bit closer now. You probably have a way to go, but it's a start. Maybe the scope could provide some sort of map. And those three guardians--well, maybe you can bribe, attack or talk to them. For information if nothing else. The rewired robot, particularly, keeps its eyes on you. Maybe it's guarding something important."
"You still can't make out any details of the palace, but it's certainly there, across the big lake to the northeast. But there are more stupid guardians here--they look more resolute and tougher to figure, but you are getting the hang of things. You think."
"The castle looks a little bigger now--but you may eventually need to cut [if location of player is cinema]east[else]north[end if] a bit to get to it. It looks like there're dead ends [if location of player is cinema]north and west[else]south and east[end if], and you still aren't sure how to cross Leak Lake."
"You're a good deal closer to the palace than at the copse, but you can probably go northeast a bit more to get closer. That still leaves Leak Lake to pass."
"Now that you're at the shores of Leak Lake, it's too far to swim. You may need some craft. And crossing here might leave you far from the palace."
"You can see the other side of Leak Lake from here. It's still too far to swim, but it's clearly closer than anywhere else you've been."
"Since your head's barely above water, you can't see a shore any more. But you know it must be there."
"The palace--well, you can see why it was spectacular, once."

table of towercomments
towloc	towdist	towquo
loftier trefoil	0	"The castle--well, you couldn't even see it outside. Maybe someone will help you, once you've sorted this mess out."
campiest campsite	--	"The palace has receded a bit, but--well--that machine's got to be good for something."
scope copse	2	--
saltbed	3	--
sunbelt	3	--
anemic cinema	4	--
savager ravages	4	--
Danger Garden	5	--
salted deltas	6	--
ole shrine shoreline	6	--
shaven havens	--	"You're going side-to-side to see the curst palace without getting closer, but hooray to seeing some other life form."
obscurest subsector	--	"You're going side-to-side to see the curst palace, but hooray to seeing some other person. Even if he is locked up."
lost lots	--	"This may've been a step away from the palace, but hooray, stuff to pick up."
outer route	--	"This may've been a step away from the palace, but hooray, stuff to pick up."
actionless coastlines	7	--
rawest waters	8	--

to say tow-dirs:
	let golist be a list of directions;
	repeat with DR running through directions:
		unless the room DR of location of player is nowhere:
			add DR to golist;
	repeat with VG running through visible guardians:
		if gualoc of VG is location of player:
			remove guadir of VG from golist, if present;
		else:
			remove opposite of guadir of VG from golist, if present;
	if number of entries in golist > 0:
		say ". You have clear passage [golist]";

book a-1 cleanup

the jetskis are plural-named scenery. understand "jetski/skis/ski" as jetskis.

chapter outsideing

outside-warned is a truth state that varies.

after fliptoing lecturer (this is the disable the macks slightly too rule) :
	min-up;
	now reflections are in lalaland;
	increase headaches by 10;
	now lectures is shunned;
	choose row with mackhash of 748843503 in table of nasty guys; ["tediously"]
	now still-doable entry is false;
	move player to Strip of Profits;
	continue the action;

check going outside:
	if mrlp is routes and outside-warned is false and cur-score of routes > 0:
		say "(That's a preposition, but it's not one you need.)";
		now outside-warned is true;

book Ole Shrine Shoreline

Ole Shrine Shoreline is north of Danger Garden and east of Savager Ravages. "Leak Lake spans far to the east. You can't cross it here. An ole shrine[if deacons are in lalaland], where the deacons went,[else], possibly for the deacons,[end if] lies disused here, not to be confused with a lone shire[tow-dirs].". Ole Shrine Shoreline is in Towers.

after printing the locale description for Shoreline when Shoreline is unvisited:
	if deacons are prodded and organised are prodded:
		continue the action;
	if deacons are prodded:
		say "The organised ego drains look menacing, as if there are several very good reasons you can just walk around them, and really, you probably don't need a direct route south.";
	else if organised are prodded:
		say "The once-sad deacons begin discussing theological minutae in fits of one-upmanship. They're very slippery, and you suspect it's not that they're deacons, but just that--well, they seem snaky with their arguments, like the serpent you had to make docile.";
	else:
		say "The ego-drains and their nine letters leave you worried you're up to the task, but the once-sad deacons seem downright shifty. Snakes, with their argument, like the serpent you had to make docile.";
	now deacons are prodded;
	now organised are prodded;
	continue the action;

after going to Actionless Coastlines:
	kid-appears;
	continue the action;

to kid-appears:
	if kid is off-stage:
		if atheists are in lalaland and deacons are in lalaland:
			now kid is in actionless coastlines;
			if player is in coastlines:
				say "Some kid comes into view from a dark mist with the atheists and deacons gone, [what-kid-does].";
			else:
				say "You hear a kid yell, 'Boy! They're gone! And He's gone!' to the [if player is in shoreline]north[else]east[end if].";
		else:
			say "You hear [if deacons are not in lalaland]voices[else]a voice[end if] yell [one of]'Sadly no, nosy lad[or]a bizarrely accented 'Abort, o brat[in random order]!' to someone you can't see.";

after fliptoing deacons:
	kid-appears;
	continue the action;

after fliptoing ray eck:
	move keycar to lalaland;
	continue the action;

after fliptoing atheists:
	kid-appears;
	continue the action;

book Anemic Cinema

Anemic Cinema is north of Baldest Blasted Saltbed. "Well, you're not [i]in[r] the cinema. It's off to the side[if ingrates are visible]. Something smells to the west, too[end if][tow-dirs].". Anemic Cinema is in Towers.

after printing the locale description for Anemic Cinema when Anemic Cinema is unvisited:
	say "The ingrates grumble about how they were given a boring and useless passage to guard. Maybe you don't really need to get rid of them.[paragraph break]";

The theater is useless scenery in anemic Cinema. description of theater is "[bug-report]"

understand "theatre" and "anemic/ cinema" as theater.

check going inside when player is in cinema:
	try entering theater;

instead of doing something with theater:
	if current action is entering:
		try entering theater;
	say "The theater thereat, with such lame titles as 'Me, I can,' / 'Nice, Ma!' and 'Iceman,' has been abandoned. And really, you shouldn't be staring at some screen when you are trying to save a world."

book Loftier Trefoil

Loftier Trefoil is an innie room in Towers. "This opt-outs['] outpost is slightly classier than servant taverns. Still, you can't afford to stay, and you can't leave it with Rodney around. It has other rooms, but since this isn't an RPG, the cellar below and rooms upstairs are off-limits.".

after printing the locale description for Mislit Limits when Mislit Limits is unvisited (this is the adjust min towers score passing waters rule):
	now poss-score of Towers is 4 + cur-score of towers;
	now min-score of Towers is 1 + cur-score of towers;
	if player has strudel and strudel is not reflexed:
		increment poss-score of towers;

after printing the locale description for Rawest Waters when Rawest Waters is unvisited (this is the adjust min towers score in waters rule):
	now poss-score of Towers is 5 + cur-score of towers;
	now min-score of Towers is 2 + cur-score of towers;
	if player has strudel and strudel is not reflexed:
		increment poss-score of towers;

book Topside Deposit

Topside Deposit is a room in Towers. "[if ray eck is in lalaland]You don't seem to have much else to do here. While you can go any direction, it's only sensible to go back north[else]There's a bit more life to the north--it's wooded, but it's also guarded[end if]. The curst palace is barely visible in the distance."

inside of Deposit is nowhere.

understand "dopiest" as a mistake ("You sense that Ray Eck [if ray eck is in deposit]is[else]was[end if] one of the easier people to deal with, here, but you don't want to overstate it.") when player is in topside.

understand "posited" as a mistake ("You formulate a proof that the place you are in does actually exist.") when player is in topside.

the geese are useless plural-named scenery. description of geese is "You can't get a glimpse of the geese for all their noise."

understand "gander" as geese.

instead of doing something with geese:
	if action is procedural:
		say "The geese are noisy but not worth poking at.";
	say "The geese are just--there, but hiding, happy the serpent is gone. You've restored the garden, and now it's time for a new challenge."

understand "cleats" as a mistake ("The castle is run-down and unromantic enough. Changing it to cleats would be even worse.") when mrlp is towers.

check going north in deposit:
	if player does not have Rosetta Toaster and ray eck is not visible:
		say "[one of]The Rosetta Toaster looks handy, you have to admit, looking back at it[or]You ignore the toaster, again[stopping].";

the strudel is a LLPish reflexive hintpastry in Topside. "Some strudel sits here in a sled rut.". description is "It reminds you of stuff stolen from parents' cabinets during sleepovers--wouldn't ordinarily taste great, but stolen? A bit better. You notice the letters [i]Certified Nutritious by Dr. Eltus[r] stamped on it, in red. Magically, it doesn't look dirty from having spent time on the ground."

a-text of strudel is "RYRRRYR". b-text of strudel is "RYRRRGR".

check scaning strudel:
	if strudel is reflexed:
		say "You already rustled it." instead;
	say "You don't suspect you need to do anything with the strudel, but the settler still pops something up. Maybe it'd be practice to figure how you could've taken it.";

The sled rut is useless scenery in Topside. "It's flecked with red, oddly[if strudel is in Topside], and the strudel's still in it[else if strudel is reflexed], though you think you know why, now[end if]."

The Rosetta Toaster is a container. It is in Topside Deposit. "A rosetta toaster rotates here."

check scaning toaster:
	say "[one of]The toaster looks like a pretty good diagnostic item as-is, and it doesn't need an upgrade, so you're not disappointed when nothing pops up[or]Still nothing. The toaster probably doesn't need an upgrade[stopping]." instead;

check taking toaster when player is in coastlines:
	say "You don't need to take it again.";

Rule for printing room description details of the Rosetta Toaster:
	do nothing instead.

the Rosetta Toaster has a number called charges. the charges of the Rosetta Toaster is usually 0.

the description of the Rosetta Toaster is "This nutriments instrument, according the writing beneath 'O Treats,' automatically applies a much more appropriate description to the target of your choice than the most obvious one. Which makes up for it not having a dial for how dark you toast your preferred flat bread product. It's not available at-store and known to cause conflicts with namer ramen[one of].[paragraph break]You could also call it a toast-o-stat[or][stopping]."

understand "toast-o-stat" and "stat" as toaster.

Report taking the Rosetta toaster:
	say "Though you feel a small surge as you pick up the toaster, it stops spinning nonetheless. Yup, this thing could be powerful." instead;

after fliptoing strudel:
	now player has strudel;
	continue the action;

check fliptoing strudel:
	if player has strudel and strudel is reflexive:
		say "(Yeah, okay. You were supposed to pick the strudel up this way in the first place. But hey, have a point anyway.)";

Report taking the strudel:
	say "You take it from the rut with no problem. Maybe you could've done it fancier, but eh, well." instead;

xrayvision is a truth state that varies.

check inserting into the rosetta toaster:
	if xrayvision is true:
		say "You've already got some x-ray vision. So you can just XRAY whatever you want." instead;
	if noun is not a hintpastry:
		say "That's not a toaster pastry." instead;
	if noun is strudel and noun is reflexive:
		say "You pause momentarily, wondering if you could've done something with the strudel to make it feel--well, yours. But you don't need style points.";
	now noun is heated;
	now xrayvision is true;
	say "[if xray-warn is false]Looking at yourself after eating the pastry, you see you can see what you'd want to be--stronger, slimmer, etc. You feel like you could look through something else to see what it really should be now. Just XRAY it[else]The x-ray vision comes back. Once again, you can XRAY what you want to[end if].";
	now xray-warn is true;
	if noun is strudel and strudel is reflexive:
		poss-d;
	pad-rec "xray";
	now noun is in lalaland instead;

chapter toasting

toasting is an action applying to one thing.

understand the command "toast/heat/warm" as something new.

understand "toast [something]" and "heat [something]"  and "warm [something]" as toasting.

carry out toasting:
	if noun is the player and toaster is visible:
		say "That's not the way to get on a hot streak." instead;
	if player does not have the toaster:
		if toaster is visible:
			try taking the toaster;
			if player does not have toaster:
				say "You can't get the toaster to do that." instead;
		else:
			say "You have no toasting device." instead;
	if noun is a guardian or noun is reflexive or noun is vanishing:
		if noun is strudel:
			do nothing;
		else:
			say "The correct usage is to toast something edible, and then you can xray something." instead;
	if noun is a person:
		say "The toaster is not a weapon. It's not that big, either." instead;
	try inserting the noun into the toaster;

chapter xraying

xraying is an action applying to one thing.

does the player mean xraying a guardian: it is very likely.

understand the command "xray/x-ray [something]" as something new.

understand "xray [something]" as xraying.
understand "x-ray [something]" as xraying.

understand "xray" as a mistake ("You don't have x-ray vision right now.") when xrayvision is false.

to say if-duck:
	if duck is not visible:
		say "--but nothing [if ravages is visited]here [end if]seems to fit with UNLOCKED";

to say big-hint of (rayx - a thing) :
	if rayx is a guardian or rayx is a warrior:
		choose row with the-from of rayx in the table of anagrams;
		say "[right-word entry in upper case]";
	else:
		say "[if rayx is kid]attentive[else if rayx is turbos]robust[else if rayx is blaster]stabler[else if rayx is duck]unlocked--well, maybe the duck will help something become unlocked[else if rayx is prison ropins]unlocked[if-duck][else if rayx is crocus]dingy[else if rayx is flowerpot and limits is visited]dingy[else if rayx is ed yerg]greedy[else if rayx is denim]mined[else if rayx is weeds]sewed[else if rayx is old ice]coiled[else if rayx is eastern]nearest[else if rayx is serpent]present[else if rayx is pulses]unreal[else if rayx is palace]spectacular[else if rayx is strudel]rustled[else]BUG[end if]";

xray-warn is a truth state that varies.

to say mrmaam:
	say "[if player is female]ma'am[else]mister[end if]";

check giving hintpastry to Ed Yerg:
	say "He's used to loftier meals than that." instead;

check giving hintpastry to a guardian:
	if second noun is diners:
		say "They scoff at what your idea of fine cuisine seems to be." instead;
	say "Bribery won't work." instead;

palace-warn is a truth state that varies.

check xraying:
	if map region of location of noun is not towers:
		say "You're not in the right region to x-ray anything." instead;
	if noun is rayed and xraytrump is false:
		ital-say "you already xrayed this, so you're just remembering what it was...";
	else if xrayvision is false and xraytrump is false:
		say "You don't have x-ray vision now." instead;
	if mrlp is not towers:
		if Topside is unvisited:
			say "[reject]" instead;
		say "That was for the towers. It doesn't work anywhere else because, well, different areas are different." instead;
	if noun is the player:
		say "You might expose yourself to harmful rays and stuff, looking that close." instead;
	if noun is kid and doc-y is not visible:
		say "[if doc-y is not visible]'I--I don't like free candy, [mrmaam],' he says, looking scared.[paragraph break]Maybe you can't quite help him now[else]The kid seems to cringe, memories of bullying hall monitors, probably[end if]." instead;
	if noun is reflexed or noun is nonreflexive:
		say "That doesn't seem to need internal changing. Maybe find something or someone else to x-ray." instead;
	if noun is doc-y:
		if doc-y has been rowdy and doc-y has been wordy:
			say "You've done what you can with Dr. Yow. He can be rowdy or wordy." instead;
		if doc-y has been wordy:
			say "You realize Dr. Yow has a rowdy side, too.";
		else if doc-y has been rowdy:
			say "You realize Dr. Yow has a wordy side, too.";
		otherwise:
			say "You see Dr. Yow has both a wordy and rowdy side that have been crushed by prison.";
		if noun is not rayed:
			now undo-code is 2;
			prevent undo;
		do nothing instead;
	if noun is jetskis:
		if turbos are reflexed and blaster is reflexed:
			say "The jetskis appear as workable as they can be." instead;
		if t-or-b is reflexive:
			try xraying t-or-b instead;
		if blaster is reflexive:
			try xraying blaster instead;
		if turbos are reflexive:
			try xraying turbos instead;
	if noun is palace:
		if palace-warn is false:
			now palace-warn is true;
			say "Boy! This is a big one. You are overwhelmed by the superlativeness of the way to describe the castle. You are pretty sure you can handle it. Well, I'm pretty sure you are pretty sure. Are you pretty sure?";
			if the player consents:
				do nothing;
			else:
				say "You decide to be pretty sure you can figure it on your own, instead." instead;
	if noun is guardian:
		say "Hmm. You bet you could get past if [if noun is plural-named]those blockers[else]that blocker[end if] were [big-hint of noun].";
	else if noun is warrior:
		say "Boy! Sure would be nice if he were [big-hint of noun].";
	else if noun is rayed:
		say "You remember you could still think [big-hint of noun].";
	else:
		say "You have a good gaze, and you know what to do and say and think. Gotta be [big-hint of noun].";
	if noun is not rayed:
		now noun is rayed;
		now xrayvision is false;
		now undo-code is 2;
		prevent undo;
	the rule succeeds;

xraytrump is a truth state that varies.

chapter xring - not for release

xring is an action out of world.

understand the command "xr" as something new.

understand "xr" as xring.

carry out xring:
	now xraytrump is true;
	the rule succeeds;

chapter xaing - not for release

xaing is an action out of world.

understand the command "xa" as something new.

understand "xa" as xaing.

carry out xaing:
	now xraytrump is true;
	repeat with xc running through all things in location of player:
		if xc is not curst palace and xc is not the player:
			say "[xc]:[line break]";
			try xraying xc;
	the rule succeeds.

book Actionless Coastlines

Actionless Coastlines is north of Ole Shrine Shoreline. Actionless Coastlines is east of Salted Deltas. Actionless Coastlines is in Towers. "Leak Lake is calmer and narrower here, but even with no rocks, you can't make it across on your own. Thankfully, no sectionals are being held here right now. If you had some sort of craft, maybe you could[if atheists are visible]. You can go back south, however[else if deacons are visible]. You can go back west, however[else]. You can go west and south, though[end if][one of]. There's no sign of sectionals, past, present or future[or][stopping]."

o-s is a backdrop. o-s is in coastlines and shoreline.

printed name of o-s is "the Ole Shrine".

understand "ole/shrine" and "ole shrine" as o-s.

instead of doing something with o-s:
	if current action is entering and player is in shoreline:
		say "[if deacons are in lalaland]No need to disturb the deacons since they let you past[else]The deacons might string you up for sacrilege, the mood they're in, even if they're keeping away from it, now[end if]." instead;
	if action is procedural:
		continue the action;
	if current action is entering:
		say "That would feel sacrilegious." instead;
	if player is in coastlines:
		say "The ole shrine is too far away to do anything other than look at, [if deacons are in lalaland]and you don't need to bother the deacons[else]even without the deacons blocking you[end if]." instead;
	say "There's nothing much to do with the shrine. It's not blocking you, [if deacons are in lalaland]and neither are the deacons[else]but the deacons are[end if].";

description of o-s is "It's relatively modest, and where you enter (or you would, if you were religious,) it mentions its sister shrine Heron Isle[if deacons are visible]. You'd think the deacons would want to enter, but they glare at it, and the red writing on it, looking [i]hostile[r][end if]."

book Scope Copse

Scope Copse is north of Topside Deposit. Scope Copse is in Towers. "A [one of]spec-o-scope (scope, for short)[or]scope[stopping] looks into the ground in the center of this wooded area[if yurts are visible], with some yurts looking out of place here[end if]. Paths lead in all directions, though things open up to the north and east."

the yurts are super-easy plural-named scenery in scope copse. "The yurts, of dull sturdy metal, don't look very lived-in. They read TRY US in red letters."

understand "yurt" as yurts.

the Owers'-Bin Brownies are a plural-named LLPish hintpastry. description of Brownies is "These cheap brownies don't look too unappetizing. However, nobody wanted to eat them until it was re-advertised as food that helps you think your way out of your problems, because it definitely can't be served at parties. Nobody much still wants to eat them, because doing so is now an admission you have, well, problems."

understand "brownie" as brownies.

understand "worse" as a mistake ("The brownies don't need to taste any worse.") when player has Brownies.

a-text of yurts is "RYRRO". b-text of yurts is "RGRPO".

the spec-o-scope is scenery in Scope Copse. understand "map/scope/specoscope/spec" and "copse scope" as spec-o-scope.

Include (-
	has transparent talkable
-) when defining spec-o-scope.

instead of taking spec-o-scope:
	say "It's firmly stuck in place. And it might lose its powers if you moved it.";

instead of searching spec-o-scope:
	try examining spec-o-scope;

the pack of start tarts is a hintpastry. description is "They are a mystery flavor. They're that breakfast pastry with goo on the inside that everyone eats but nobody admits to, or particularly likes. You remember they taste gross cold but help get your day started with a good strat. You can probably eat them whenever, though.". "A pack of start tarts lies here where the denim was mined."

understand "copes" as a mistake ("You find it easier to cope, here, with the spec-o-scope to guide you, but you need to move on.") when player is in scope copse.

understand "pecos" as a mistake ("This game ain't a dadgum Western.") when player is in scope copse.

before examining spec-o-scope for the first time:
	say "A telescope! Place to see!"

check examining spec-o-scope:
	say "[one of]It seems like an OK tool to look. You notice the word HI carved in big block letters on the scope--the I being just the H rotated.[paragraph break][or][stopping][i][bracket][one of]Fourth wall time--w[or]W[stopping]ould you prefer a textual summary of the map in the scope to a visual one?[close bracket][r][line break]";
	if the player consents:
		say "An area three rooms square. A river, maybe a lake, borders it on the north and east. About [number of accessible rooms in words] area[if number of accessible rooms is not 1]s are[else] is[end if] open in the center, with [number of sideview rooms in words] open off to the side. In particular, the highlighted area just north of the north shore is [unless admirer is in lalaland]un[end if]available, another just west is [unless ingrates are in lalaland]un[end if]available, a particularly important location east of the east shore seems [unless bonker is in lalaland]un[end if]available, and just south of it, an area looks [unless natives are in lalaland]un[end if]available. It also appears the area just west of you is highlighted, there's something northeast of the water.";

description of spec-o-scope is "You look into the scope and see:[paragraph break][fixed letter spacing]
[line break]  !       *
[line break]  [bloorg of admirer]~~~~~~
[line break]+[bloorg of ingrates].[bloorg of wait-seer].[bloorg of atheists].~ +
[line break]  [bloorg of iPrune] [bloorg of grailman] [bloorg of deacons]~
[line break]  .[bloorg of robot].[bloorg of reed's ale].~
[line break]  [bloorg of muscly] [bloorg of man covered in inapt paint] [bloorg of ego drains]~
[line break]![bloorg of pirates].[bloorg of diners].[bloorg of salesmen].[bloorg of bonker]!
[line break]  [bloorg of Ray Eck]   [bloorg of natives]
[line break]  !   +[variable letter spacing][paragraph break]| = passage, x = no passage, . = location, ! = important, + = treasure."

to say bloorg of (gg - a guardian):
	if gg is in lalaland:
		say "[if guadir of gg is west or guadir of gg is east]-[else]|[end if]";
	else:
		say "x";
	[say "[if gg is blue]B[else if gg is red]R[else if gg is purple]P[else]W";]

book Campiest Campsite

Campiest Campsite is west of Scope Copse. Campiest Campsite is in Towers. "The dead leaves here are a bit too pastel, the chirping of unseen birds is a bit too sharp, and it smells a bit too much like air freshener. At least [one of]yon camp has no campy company (copy, man?)[or]no campers scamper[or]saucy yucas haven't burst from the ground[in random order] here. It's heavily wooded, and you can really go back east."

the camp is useless scenery in campsite. understand "site/campsite" as camp.

description of camp is "Wow! It's just so inspiring and ALIVE!"

instead of doing something with camp:
	if action is procedural, continue the action;
	say "Well, gosh! There's not a whole lot to do with the camp but have fun being around it! Oh, and maybe figure what goes in the rapier repair." instead;

the dead leaves are useless plural-named scenery in campsite. "[bug-report]"

instead of doing something with dead leaves:
	say "Dead leaves! Man! Why is it dead leaves make you feel so ALIVE?!"

A rapier repair machine is in Campiest Campsite. "A shiny machine labeled RAPIER REPAIR [if dagger is in lalaland]fizzles[else]chugs[end if] along here.". description is "It's a hi-watts whatsit that reads 'Paranoid? A poniard!' It looks like what you imagined a left-handed smokebender did, back when you were being hazed in [if player is male]Boy[else]Girl[end if] Scouts. [if dagger is not in lalaland]It's nowhere near big enough to clean a lance, but you could probably PUT any blade smaller than a rapier in there[otherwise]You seem to have broken it creating the gizmo[end if]."

instead of taking rapier repair:
	say "It's at best impractical and at worst impossible to take. Besides, [if dagger is in lalaland]you already used it[else]it'd be easier to carry something that'd fit into IT[end if]."

the I ZOMG Gizmo is a thing. description is "[one of]Whew. I'm buffaloed on this one. Somebody who knows how to build things would probably understand how to activate, much less use, the [randbla] or [randbla]. Hey, if I understood, I would be writing stuff far less silly than this game.[or]You find yourself baffled by the [giz-part][stopping]."

to say giz-part:
	choose row with mytab of table of gizmo parts in table of megachatter;
	if curidx entry is maxidx entry:
		say "[randbla]";
	else if curidx entry is maxidx entry - 1:
		say "[randbla]. Or, still, the [randbla]";
	else:
		say "[randbla] and [randbla]";

check opening gizmo:
	say "It's too complicated to learn about." instead;

check inserting into rapier repair machine:
	ignore the can't insert into what's not a container rule;
	if noun is gizmo:
		say "The gizmo is so cool, the machine broke itself producing one." instead;
	if ragged dagger is in lalaland:
		say "The machine has already given its all to create the gizmo." instead;
	if noun is not ragged dagger:
		say "That's nothing like a rapier. It's not sharp, metal and pointed. You'll need to find something else." instead;
	say "The dagger is sucked into the machine, which gets raspier as it repairs. A couple minutes of proclaiming itself 'the sharpener that resharpens,' and a final wheezing choke later, you open it. Instead of a riper rapier, or a clever cleaver, it's a gizmo--bearing the label of the famed novelty company I ZOMG.";
	now player has the I ZOMG Gizmo;
	now ragged dagger is in lalaland;
	reg-inc instead;

chapter repairing

repairing is an action applying to one thing.

understand the command "repair" as something new.

understand "repair [something]" as repairing.

carry out repairing:
	if repair machine is not visible:
		say "You need to be by a repair machine." instead;
	try inserting noun into repair machine instead;
	the rule succeeds.

book Salted Deltas

Salted Deltas is north of Savager Ravages and east of Anemic Cinema. "Leak Lake, with its shoals aslosh, is to the north and far too wide to cross[tow-dirs].". Salted Deltas is in Towers.

s-d are useless scenery in salted deltas. understand "salted/ deltas" as s-d. printed name of s-d is "salted deltas".

description of s-d is "[bug-report]".

instead of doing something with s-d:
	say "The salted deltas are scenery. No need to futz."

to say meet-kid:
	now met-kid is true.

a smart kid is a reflexive person. "[if met-kid is false]'Hi! I'm Dirk Stam! Thanks for getting rid of those big mean adults!' It's the kid you rescued. You exchange greetings[meet-kid][else if doc-y is in lalaland][what-kid-sez][else]Your friend Dirk Stam the smart kid is here[if-tent][end if]."

to say if-tent:
	if player is in coastlines:
		say ", looking far-off, as if for inspiration he hasn't found yet";
	if player is in subsector:
		say ", looking [if smart kid is reflexed]attentive[else]too tentative[end if]"

check answering smart kid that:
	if the player's command matches the regular expression "\b(doctor|dr|yow)\b":
		try objasking smart kid about doc-y instead;

a-text of smart kid is "YRRYRRYRY". b-text of smart kid is "YRRYRPGPG".

[gotoing subsector is kiddoing.

talking to doc-y is kiddoing.]

persuasion rule for asking smart kid to try gotothinging doc-y:
	try objasking smart kid about doc-y instead;

persuasion rule for asking smart kid to try gotothinging prison ropins:
	try objasking smart kid about doc-y instead;

persuasion rule for asking smart kid to try gotoing subsector:
	try objasking smart kid about doc-y instead;

persuasion rule for asking smart kid to try doing something (this is the block kid to subsector rule) :
	if the player's command matches the regular expression "gizmo" and kid is reflexive and player has gizmo:
		try giving gizmo to smart kid instead;
	if the player's command matches the regular expression "jetski" and kid is reflexive:
		try objasking smart kid about jetskis instead;
	if the player's command matches the regular expression "\b(doctor|dr|yow)":
		if subsector is unvisited:
			say "You don't know about that area yet.";
			persuasion fails;
		try objasking smart kid about doc-y instead;
	say "The kid is good at mechanical stuff, but he's not very good at following orders.";
	persuasion fails;

check scaning smart kid:
	if smart kid is reflexed:
		say "'Oh! Pf! I bet I could make one of those, easy." instead;
	if smart kid is reflexive and smart kid is in subsector:
		say "[if cheat-on is false]YRRYRRYRY[else]YRRYRPGPG[end if]." instead;
	say "'Wow! Cool! What is that?' Hmm, maybe you'll get to use it on him later." instead;

met-kid is a truth state that varies.

to say what-kid-sez:
	say "[if kid has gizmo]Dirk Stam now has the jetskis he made. He looks nervously at you--he can't bring himself to ask you to try them.[no line break][else]The smart kid potters around here. 'Aww man! I have a wicked awesome plan for some jetskis! But I don't have the right tools.' He kicks at the ground[end if]";
	now met-kid is true;

to say what-kid-does:
	if doc-y is visible:
		say "looking [if smart kid is reflexed]attentive[else]tentative[end if]ly at Dr. Yow";
		continue the action;
	say "drawing in the air and mouthing ideas[one of]. 'Hey! I'm Dirk Stam! They tell me I'm a smart kid but never let me learn the cool stuff. Those mean adults kept bugging me about religion! Bo-ring! Maybe you can teach me? Or find someone who can?' You never were good at that technical stuff, but maybe you [if prison ropins is reflexed]have found[else]can find[end if] someone else who is[meet-kid][or][stopping]"

understand "dirk stam" and "dirk" and "stam" as smart kid.

before taking gizmo:
	if smart kid has gizmo:
		say "That'd be mean, since you just gave it to the kid." instead;

check giving hintpastry to smart kid:
	say "He knows better than to take sweets from strangers." instead;

check giving hintpastry to doc-y:
	say "He doesn't seem hungry." instead;

check giving hintpastry to duck:
	say "It turns away as if to say, yuck." instead;

check giving raves saver to smart kid:
	say "[one of]He frowns at it. 'No way! That's way too ancient! Maybe it's useful for you, cause you're one of a few people remembers how it works, but...' he pauses awkwardly.[or]That won't help the kid build anything.[stopping]" instead;

before giving something to doc-y when doc-y is in prison ropins:
	say "Nothing fits through the fence." instead;

check objasking doc-y about gizmo when player has gizmo:
	if doc-y is not in prison ropins:
		try giving gizmo to doc-y instead;

check giving gizmo to doc-y:
	say "'A bit too applied for me.'" instead;

check objasking smart kid about gizmo:
	try giving gizmo to smart kid instead;

to say heat-remain:
	if number of hintpastries carried by the player > 0:
		say ", first heating your remaining pastr[if number of hintpastries carried by the player is 1]y[else]ies[end if] to get x-ray vision";
	now xrayvision is true;
	now all carried hintpastries are heated;

check giving gizmo to smart kid:
	if doc-y is in lalaland:
		say "He takes the gizmo. 'Gee! Not as stone age...stage one...' He activates the gizmo's pliers, ignoring design perils--but he doesn't have enough. You [if player has toaster]offer your toaster[heat-remain][else]remember that toaster in the garden[end if]--the toaster would've caused an electric shock in the water anyway. The spare parts just allow him to tacks on turbos and a blaster to his jetskis. They don't look TOO sturdy, but maybe you can fix that.";
		now smart kid has gizmo;
		now toaster is in lalaland;
		now blaster is part of jetskis;
		now turbos are part of jetskis instead;
	else:
		say "'Wow! That'd be neat if I have something to build.'" instead;

description of smart kid is "Freckly-faced and buck-toothed and talking to himself[if doc-y is visible]. He's visibly [i][at-ten][r] just being around Dr. Yow[end if].";

to say at-ten:
	say "[if kid is reflexed]attentive[else]tentative[end if]"

the smart kid can be lonely or following or found. smart kid is lonely.

book Shaven Havens

Shaven Havens is north of Anemic Cinema. Shaven Havens is in Towers. "This place wasn't, like, shaved with a razor. It's just free of anything that could hide bad guys, and hey, small things. It looks too dangerous to go anywhere except back south."

havens-visit is a truth state that varies.

after printing the locale description for havens when havens-visit is false:
	ital-say "you may wish to GO TO DUCK to get back here with less hassle.";
	now havens-visit is true;
	continue the action;

The lone duck is an animal in Shaven Havens. "[if lone duck is friendly]That[otherwise]A[end if] lone duck is quacking along here[if id tag is examined]. It is wearing a small ID tag[end if][if smart kid is visible], and it's ignoring the kid[end if]."

a-text of lone duck is "YRRYRRYR". b-text of lone duck is "YRRYRRYR".

understand "lone/ noel" as lone duck when id tag is examined.

check giving something to duck:
	say "The duck doesn't seem interested in anything edible. Or inedible." instead;

instead of touching the duck:
	say "It waddles away[if doc-y is in subsector] behind Dr. Yow[else if lone duck is friendly], even though it seems attracted to your raves saver[else]--maybe it needs some way to trust you[end if]."

instead of taking the duck:
	if lone duck is returned:
		say "It's Dr. Yow's. No stealing." instead;
	say "It gives you a wobbly blowby [if lone duck is friendly]despite your raves saver[otherwise]and gives a warning honk. Maybe you need to find some way to befriend it[end if]."

description of lone duck is "A pretty normal duck, but it doesn't seem that interested in you. It's not running away, though. So it's probably domesticated, but a bit timid--so don't make any loud noises[one of]. It pecks at a speck you can't see[or][stopping]."

the ID tag is part of the lone duck.

instead of taking the ID tag:
	say "It's for identification. It's not worth removing."

description of the ID tag is "'  Lone Noel[paragraph break]Dr. Yow's Duck'"

the lone duck can be aloof, friendly or returned. the lone duck is aloof.

book Baldest Blasted Saltbed

Baldest Blasted Saltbed is north of Scope Copse. "This is a dreary place that doesn't seem worth guarding, [if number of visible guardians is 0]but you took care of everyone here[else]so maybe people, or things close enough, are just stopping you leaving[end if]. Some old ice is to the west[if old ice are reflexive][one of]. You doubt it's blocking anything, but it might look more impressive if it were less, well, flat[or][stopping][else]. You made it coiled, so it looks cool[end if][tow-dirs]."

Baldest Blasted Saltbed is in Towers.

instead of doing something to the cliff:
	if action is procedural, continue the action;
	say "Looking at the cliff, you spend moments in awe of it unclimbable verticality--and of how Inform 7 lets you implement backdrops that can be in several rooms at once." instead;

book unblest sunbelt

Unblest Sunbelt is east of Scope Copse. Unblest Sunbelt is in Towers. "The land here is dry and unforgiving. You doubt there's much to do here besides get on[if number of visible guardians is 0], especially since you got rid of the guardians here[end if][if pulses are visible], though you feel [i]neural pulses[r] you'd love to get rid of[end if][tow-dirs]."

after printing the locale description for Unblest Sunbelt when Unblest Sunbelt is unvisited:
	if inapt paint is prodded and salesmen are prodded:
		continue the action;
	if inapt paint is prodded:
		say "The salesmen, being nameless, swear by their wares they think you'll like. NERD-AID!";
	else if salesmen are prodded:
		say "Hm, that inapt paint--nah, it'd be a tap-in by itself, according to Old Hat Daltho. Must be the actual words.";
	else:
		say "Over the salesmen hawking NERD-AID, you consider Old Hat Daltho's advice: the inapt paint can't be a tap-in.";
	now salesmen are prodded;
	now inapt paint is prodded;
	continue the action;

book Danger Garden

Danger Garden is a room in Towers. Danger Garden is east of Unblest Sunbelt. printed name of Danger Garden is "[if bonker is visible]Danger[otherwise]Gander[end if] Garden". "[if bonker is visible]This garden seems both describable and indescribable. You're sure it's inspired its share of overblown prose and poetry, and of thinking how things are or should be, but there's no time for that now[otherwise]You hear the geese honking now with the bonker gone, but they are too scared of you[end if]. The curst palace is barely visible in the distance north-ish, and you can take a path any which way.".

understand "danger/gander garden" and "garden" as Danger Garden when mrlp is towers.

after printing the locale description for Danger Garden when Danger Garden is unvisited:
	say "The natives look, well, restless, as if they might want to find a better place to guard[if ego drains are unprodded]. Also, the ego drains seem to put ideas into your mind that you really don't need or deserve to go north, and maybe you can just go around--and, well, it makes a lot of sense as-is and is far less over the top than the rest of the campsite[end if].";
	now ego drains are prodded;
	continue the action;

book Savager Ravages

Savager Ravages is north of Unblest Sunbelt and east of Baldest Blasted Saltbed. "This place is just a total mess. You see [if weeds are visible and denim is visible][we-g] along with the denim patching what's probably a hole[else if weeds are visible][we-g][else if denim is visible]denim patching a hole[else]nothing else you can shake down for items[end if]. Paths in all four directions here[if number of visible guardians is 0], all unobstructed[else if number of visible guardians is 1], even if one's blocked[else], even if some are blocked[end if].". Savager Ravages is in Towers.

to say we-g:
	say "weeds swaying, despite no wind,"

understand "swede" as a mistake ("That might make the weeds FROM Scandinavia, but it wouldn't SEND them there[if man covered is in ravages]. The man who is not Flemish shakes his head, sure you're one of those people too concerned about nationalities[end if].") when player is in ravages and weeds are in ravages.

every turn when player is in ravages and weeds are in ravages and player was in ravages:
	say "The weeds [one of][or]continue to [stopping]sway freely and menacingly[one of]. Perhaps you can get rid of them, since they're not actual people blocking passage[or], but they can't be THAT tough[stopping].";

after printing the locale description for ravages when ravages is unvisited:
	if inapt paint is unprodded:
		say "Hm, that inapt paint--nah, it'd be a tap-in by itself, must be the actual words.";
		now inapt paint is prodded;

before going down in ravages:
	say "[if denim is in ravages]The denim is too thick[else]You try to look into the dark where the denim was. Going in would be the dopiest posited thing you could do, even with a light source[end if]." instead;

the denim is LLPish semi-easy vanishing scenery in ravages. the indefinite article of denim is "some".

understand "i mend" as a mistake ("You're more interested in doing the opposite--seeing what's behind.") when denim is in ravages and player is in ravages.

a-text of denim is "RYRYR". b-text of denim is "RYPYR".

description of denim is "Too heavy for normal tools to cut."

the weeds are super-easy scenery in Ravages. "They look like some sort of mutant weeds from the future, maybe a crazy one with multi-layered cities. They blow in some undetectable wind: west, then east a while, then down and south. There may be something inside them, but you can't tell."

check taking weeds:
	say "They spin around you like a garment before picking you up and placing you away." instead;

a-text of weeds is "RYRYR". b-text of weeds is "RGRYR".

the raves saver is a reflexive LLPish semi-easy thing. the raves saver can be yow-talk, yow-yell, goosey, ducky, or silent. the raves saver is silent.

understand "tape recorder" and "tape/recorder" as raves saver.

check opening raves saver:
	say "It's cheap and rickety enough, the tapes are stuck in like paste. It has no open button or mechanism." instead;

a-text of saver is "RYYRRO". b-text of saver is "???RR?".

description of raves saver is "[if saver is reflexive]It has an inscription REPLAY PLAYER, which is a violation of copyright law--those have video--but nobody's going to sue or care. But[else]It's slightly more polished now you made it pearly, and[end if] it also has a REPEAT button and a RETAPE button[one of].[paragraph break]It doesn't even have a socket for Hears-Share earphones.[stopping]"

repeat button is part of the raves saver.

description of repeat button is "It looks as pushable as the retape button."

retape button is part of the raves saver.

description of retape button is "It looks as pushable as the repeat button."

the ragged dagger is a thing.

description of ragged dagger is "It can't shag much less gash. Written on it is evidence it was once Hank's shank."

does the player mean doing something with repeat button when repeat button is not visible: it is unlikely.

check pushing retape button:
	if waters is visited or limits is visited:
		say "The saver has suffered permanent water damage. It doesn't even make any weird warpy noises." instead;
	if raves saver is not silent:
		if salesmen are visible:
			say "The salesmen decry the sound quality of your raves saver. They reiterate that anyone who'd use a piece of junk like that ISN'T going places." instead;
		if number of visible guardians > 0:
			say "Nothing on your saver is abrasive enough to move a guardian out of your way." instead;
	if doc-y is visible:
		if kid is visible:
			say "You don't need to record the two of them, now." instead;
		if doc-y is calm:
			say "Recording the awkward silence with Dr. Yow around would do little." instead;
		if doc-y is wordy:
			if raves saver is yow-talk:
				say "That's already on the saver." instead;
			say "You record Dr. Yow talking[prev-rec].";
			now raves saver is yow-talk instead;
		if doc-y is rowdy:
			if raves saver is yow-yell:
				say "That's already on the saver." instead;
			say "You record Dr. Yow ranting[prev-rec].";
			now raves saver is yow-yell instead;
	if duck is visible:
		if raves saver is ducky:
			say "The duck's already on the saver." instead;
		say "The clicking of the RETAPE button causes the duck to quack inquisitively. The saver records the quacks[prev-rec].";
		now raves saver is ducky instead;
	if player is in Danger Garden:
		if raves saver is goosey:
			say "The duck's already on the saver." instead;
		say "You record the geese's honks[prev-rec].";
		now raves saver is goosey instead;
	if kid is visible:
		say "'Whoah! That thing looks ancient!' the kid yells before you push the button[if saver is yow-talk or saver is yow-yell]. Maybe you meant to push repeat...the kid is interested in science, and Dr. Yow's voice is in the recorder[end if]." instead;
	say "There's nothing that seems worth re-taping here, so you decide against doing so." instead;

to say prev-rec:
	say " over [if saver was silent]the previous silence[else if saver was ducky]the duck's quacking[else if saver is goosey]the geese's honking[else if saver is yow-yell]Dr. Yow's rants[else if saver is yow-talk]Dr. Yow's talking[end if]";

check pushing repeat button:
	if waters is visited or limits is visited:
		say "The saver has suffered permanent water damage. It doesn't even make any weird warpy noises." instead;
	if smart kid is visible:
		if raves saver is goosey or raves saver is ducky:
			say "'Yawn. The zoo is kind of boring. I like making stuff.'" instead;
		if raves saver is yow-yell or raves saver is yow-talk:
			try objasking smart kid about doc-y instead;
		say "'Whoah! That thing looks ancient!' the kid yells before you push the button." instead;
	if doc-y is visible:
		if raves saver is yow-yell or raves saver is yow-talk:
			say "Dr. Yow doesn't need to be mimicked." instead;
	if player is in Danger Garden and saver is ducky:
		say "The geese honk in protest. One tries to attack your saver until the recording dies down." instead;
	if duck is visible and saver is goosey:
		say "The duck cowers in fear, unable to locate the source of the noise[if doc-y is visible], and Dr. Yow seems to glare at you a bit[end if]." instead;
	if raves saver is yow-yell and duck is visible:
		say "The duck seems to walk forward but gets scared by the volume and rapidity of the noise." instead;
	if raves saver is yow-talk and duck is visible:
		if duck is friendly:
			say "You've already got the duck's attention." instead;
		otherwise:
			say "The duck perks up. It recognizes Dr. Yow's voice! It gives a hankering honk.";
			now duck is friendly instead;
	say "[if raves saver is silent]Silence. Nothing has been recorded, yet.[else if raves saver is yow-yell]You hear someone yelling.[else if raves saver is ducky]Quack, quack.[else if raves saver is goosey]Honk, honk.[otherwise]You hear Dr. Yow talking.[end if]" instead;

after going somewhere (this is the duck-follows-you rule):
	if duck was visible and duck is friendly:
		say "The duck [one of]quacks along[or]waddles[or]trudges[or]schleps[in random order] behind you.";
		move duck to location of player;
	continue the action;

chapter retapeing

retapeing is an action applying to nothing.

understand the command "tape/retape/record" as something new.

understand "tape" and "retape" and "record" as retapeing.

carry out retapeing:
	if raves saver is not visible:
		say "[reject]" instead;
	try pushing retape button instead;

chapter repeating

repeating is an action applying to nothing.

understand the command "repeat" as something new.

understand "repeat" as repeating.

carry out repeating:
	if raves saver is not visible:
		say "[reject]" instead;
	try pushing repeat button instead;

book Lost Lots

Lost Lots is south of Danger Garden. Lost Lost is in Towers. "[one of]Well, I guess those annoying natives were right. [or][stopping]This is just a barren area, without even a slot. You should probably go back north before losing all sense of direction."

understand "slot" as a mistake ("If you made it, you might fall in the slot and never get out.") when player is in Lost Lots.

a pack of Claire's Scalier Éclairs is a hintpastry in Lost Lots. description is "To those who eat these scalier éclairs (O CALORIES,) much is clear. However, it is not recommended that you eat them cold."

check opening a hintpastry:
	say "You can just try to [if player has toaster]TOAST or [end if]EAT that if you want." instead;

understand "eclair/eclairs" as Éclairs.

after doing something with Éclairs:
	set the pronoun them to Éclairs;
	continue the action;

book Obscurest Subsector

Obscurest Subsector is east of Danger Garden. Obscurest Subsector is in Towers. "A place this obscure is perfect for prison ropins, which [if duck is returned]lie here useless, thanks to the duck[else]are holding someone in captivity[end if]. A log-gaol keeps the subsector obscurest and keeps you from going anywhere back west.".

a log gaol is scenery in obscurest subsector. "It surrounds the subsector on four sides, helping keep it obscure."

subsector-visit is a truth state that varies.

after printing the locale description for subsector when subsector-visit is false:
	ital-say "you may wish to GO TO GAOL to get back here with less hassle.";
	now subsector-visit is true;
	continue the action;

understand "locked" as a mistake ("[if doc-y is in prison ropins]No, the opposite...[else]You don't need to fiddle with the lock now.[end if]") when player is in subsector.

understand "delock" as a mistake ("[if doc-y is in prison ropins]No, this is the wrong area for pure action[else]Unlocked worked better, here[end if].") when player is in subsector.

after choosing notable locale objects when player is in subsector:
	set locale priority of prison ropins to 0;

instead of cutting prison ropins:
	say "[no-rips]";

instead of cutting gaol:
	say "[no-rips]";

to say no-rips:
	say "[if player has dagger]The dagger is too ragged[else if player has gizmo]The gizmo is too unwieldy to fit between the mesh. You try to cut it, but the blade squeaks against the steel[else]You have nothing that could cut anything[end if]."

The prison ropins are a reflexive plural-named transparent container in Subsector. ropins are fixed in place. "The prison ropins are dense and strong enough that they will cause no rips, but you can see through them. They're made to ensure no rips (of course!) [if duck is returned]though you found another way in[else]and look locked, but there must be some way to make them openable--[one of]ah, there's a[or]there's that[stopping] small fissure which is the closest thing to a keyhole, and some writing, too[end if]."

understand "jail" as prison ropins.

instead of entering prison ropins:
	say "It's not very full of fun or useful things. If it were, Dr. Yow would've gone all MacGyver and burrowed out without your help.";

instead of going inside in subsector:
	try entering prison ropins instead;

a-text of prison ropins is "YRRYRRYR". b-text of prison ropins is "YRRYRRYR".

understand "unlocked" as a mistake ("There's nothing here to unlock. [if subsector is visited]Though you've been to the subsector with the prison ropins[else]Maybe someone's imprisoned somewhere[end if][if duck is not friendly]. And besides, the duck doesn't seem cooperative, yet[end if][if duck is not prefigured]. Still, that's an idea[end if].[preefsay of duck]") when duck is visible and prison ropins is not visible.

understand "goal" as a mistake ("You fantasize briefly about being a sports star instead of a text adventurer[if doc-y is in ropins]. But it changes nothing. You look at the poor figure in the gaol[else]. You've done a good job rescuing Dr. Yow, but you still feel far from your main goal[end if].") when player is in subsector.

understand "olga" as a mistake ("Even if the goal could become a person, they'd be kind of wooden") when player is in subsector.

description of ropins is "[if duck is returned]It's open now, not that you want to enter.[else]The gaol advertises itself as the involuntary home of one Dr. Yow.[end if]"

check examining ropins:
	ignore the examine containers rule;

check scaning ropins:
	say "The settler does very little until you get near [if ropins are examined]a fissure you didn't see at first[else]the fissure[end if]. The result makes you think you don't need to do anything to the prison as a whole.";
	now ropins are examined;

before scaning a reflexed thing:
	if noun is not dialer and noun is not bench:
		say "The settler emits a BEEEOOOP as if to say there's no need to do any more, there." instead;

understand the command "kick" as something new.

understand "kick [something]" as attacking.

instead of attacking:
	if player is in campsite:
		say "A loud voice booms LE FIST ITSELF! You quiver in fear at the thought of retribution from attacking anything." instead;
	if noun is ray eck:
		say "Not even his cousin, Kim Eck, deserves that." instead;
	if noun is a guardian:
		say "You need to see into this blocker's nature instead[if player has dagger]--that dagger would just make things murder[end if]." instead;
	if noun is a store:
		say "Sore at a store?" instead;
	if noun is Elvira:
		say "'Hater-heart.' She pouts. She summons a proto-troop that easily defeats you. '[one of]Pretty try, pet[or]Gritty try, git[in random order]!' she laughs. 'A feted defeat!' Perhaps you need backup.";
		get-dead;
		follow the shutdown rules;
		the rule succeeds;
	if noun is scary crays:
		say "You are severely outnumbered, captured, and sent to the hold. Maybe they will find out who you are, and maybe not. You will be at either Elvira's mercy or theirs.";
		get-dead;
		follow the shutdown rules;
		the rule succeeds;
	if noun is a target listed in the table of attack-specific:
		choose row with target of noun in table of attack-specific;
		say "[nohit entry][line break]" instead;
	if player has lance:
		say "Wrong enemy for the lance." instead;
	if noun is urn:
		say "Your irrational anger turns to irrational greed when you get close enough to smack it." instead;
	if noun is denim:
		say "The denim is too tough to cut[if player has dagger], even with that dagger[end if]." instead;
	say "[randbla][line break]" instead;

to say sign-r-or-b:
	say "[if sign-other is true]black[else]red[end if]";

ever-pushed is a truth state that varies.
sign-other is a truth state that varies.

to say flipsine:
	now ever-pushed is true;
	if sign-other is true:
		now sign-other is false;
	else:
		now sign-other is true:

to say dont-hit of (fi - a person):
	say "[if fi is fightin]Neat! Be Beaten! (You'd go to a lit posh hospital where CPR is crisp for that. Think. Or, rather, out-think.)[else if fi is washed up]He'd still beat you up, even though he really doesn't want to fight. Wouldn't change that he and [other-guy of fi] are still [i]washups[r]. Maybe a talk with them would break their funk.[else]Slug lugs? As d-u-m as mud.[end if]"

table of attack-specific
target	nohit
plaster	"You're not strong enough to bust through."
paperwall	"You're not strong enough to bust through."
drama armada	"That'd be a silly way to die."
brief message	"Better than attacking the messenger. Probably because you aren't going to FIND the messenger."
serpent	"Snaky yanks would backfire on you. Maybe you can calm the snake, though."
sweatier wait-seer	"You find it tough to get close to his sweatiness. 'Ew...I...tears,' you say, your eyes going red."
rewired robot	"Don't MAKE it become a boot-o-bot."
Ed Yerg	"Ye dreg!"
church sign	"You kick the sign down the middle. It rocks back and forth slightly. Perhaps you'd be better off PUSHing it. Maybe it could swivel."
the-b	"It's like a dense metal or something. It's more likely it would make something else crack."
Leo	"[dont-hit of Leo]"
Rand	"[dont-hit of Rand]"
trolls	"'I'd beat...' you think, before you realize you've been BAITED. You think bouncers, one scrub. That cools you down."
carps	"That sounds so--brutal. And nonspecific."
pikes	"That sounds so--brutal. And nonspecific."
hornets	"You didn't rescue them to kill them like this."
snipe	"You didn't rescue them to kill them like this."
snail	"You didn't rescue them to kill them like this."
racoon	"You didn't rescue them to kill them like this."
parrot	"No. He's here to help."
ed riley	"'I could DRIL YEE!' Ed booms. You can just HEAR the flagrant misspelling, and it makes you see red."
imp	"He jumps out of reach, streakily, satyrlike."
whiners	"That idea is banefully unflyable."
Pa Egg Pea	"It deserves to be ripped to shreds, but that'd just be littering."
old giant	"You don't have a weapon big enough to take him. One won't appear in your super purse."
skis	"You give them a whack, and it hurts much more than it should."
Brother Horbert	"Yorpwald's already got a St. Lip-Split."
ant	"You poke at the ant, which keeps it at bay. You need something more simple, violent and direct."
doc-y	"[if doc-y is in prison ropins]You can't reach in, and it's a bad idea anyway[else]You imgaine Dr. Yow mouthing a dry 'ow,' which isn't quite an anagram, but suddenly remember a fellow called Dry Mo, who may or may not be Dr. Yow's bodyguard. Besides, Dr. Yow is here to help you[end if]."
leopard	"Even if he weren't a hardened criminal, you'd lose. I mean, a leopard."
ocelots	"They're bigger than average. And the leopard would back them up."
satyr	"It's bigger than average. And the leopard would back it up."
badger	"It's bigger than average. And the leopard would back it up."
raptor	"Not even."
cube	"Bounce no cube."
yapper	"I dunno. Not without scissors you don't. That yapper looks pretty tough. He could take out a rock-man or two, you bet."
boats	"You may be able to make some sort of noise to request the boats['] service."
raft	"Yes, the stupid oars don't seem to move themselves, but that's no reason to get upset! Think!"
denim	"[if player has gizmo]The gizmo can't cut through[else if player has dagger]Your ragged dagger doesn't quite cut it[else]You've got nothing sharp enough[end if]. It's thickly packed denim, for sure."
trout	"This game's kind of topsy turvy, but not like THAT."
lamb	"Meanie. There's a better way to help it flee home."
walls	"Brute force is ineffective. As well as all the swears you use with the brute force. You need to wipe out the whole volt maze, not just these walls."
Elmer	"'Die, brag brigade!' you think. But they see your evil look and say 'Venomous? Us? Move on.'"
Merle	"'Die, brag brigade!' you think. But they see your evil look and say 'Venomous? Us? Move on.'"
Elmo	"Elmo kind of has the upper hand here."
boats	"Sabot? Batso!"
knob	"[if knob is reflexed]It's been hit already[else]Yes, but how?[end if]"
rude door	"[if door-sux is true]The door is miserable enough for having to let you through.[else]Well...maybe not the WHOLE door...[end if]"
prison ropins	"[which-sharp]--but force doesn't seem the right way in, anyway."
log gaol	"[which-sharp]----but there is probably nothing beyond in the Badlands anyway."
yourself	"Surly foe: yourself? Lose fury!"
macks	"[one of]Don't hate the player, hate the game.[paragraph break]Um, sorry about that. But b[or]b[stopping]eing outnumbered, maybe you can attack their arguments instead."

to say which-sharp:
	say "[if player has ragged dagger]The dagger is not very sharp[else if player has gizmo]The gizmo is versatile but not sharp[otherwise]You have nothing remotely sharp[end if]"

check opening prison ropins:
	if doc-y is in prison ropins:
		say "You rattle it a bit, but it's too strong. Probably dead-bolted too, so it's physically impossible to use brute force.";
	otherwise:
		say "It's got nothing you want there any more.";
	the rule succeeds;

check opening ropins:
	say "It's too sturdy, and you've no reason to believe what's behind it is worth visiting." instead;

check unlocking ropins with duck:
	say "Almost. You're going about it wrong, though. What do you want the fence to BE? Or be described AS?" instead;

before locking (this is the yow unlock rule) :
	if noun is ropins or noun is fissure:
		say "[if doc-y is in prison ropins]It already is, and two locks won't make an unlock[else]No need to fuss any more[end if]." instead;
	say "There's no need to lock anything in this game." instead;

does the player mean unlocking with dagger: it is very likely;
does the player mean unlocking with settler: it is likely;

does the player mean unlocking with pedanto-notepad when settler is off-stage: it is likely.

does the player mean locking with dagger: it is very likely;
does the player mean locking with settler: it is likely;

the can't unlock without a lock rule is not listed in any rulebook.

check unlocking:
	if player is in subsector:
		if noun is prison ropins or noun is fissure:
			if prison ropins is reflexed:
				say "The prison is already open." instead;
			if second noun is gizmo:
				say "You fumble with the gizmo but have utterly no luck. The prison remains locked." instead;
			if duck is visible:
				say "The duck looks curiously at what you're trying to do. You can't pick it up, but maybe you can coax the duck with the right word..." instead;
			if noun is fissure:
				say "Nothing you have seems to fit in there." instead;
			say "The prison doesn't seem like something you can unlock--well, not with a key. There's nothing that resembles a keyhole. That weird fissure, maybe..." instead;
	if noun is drab yoke:
		say "It doesn't seem to have a key or anything. But whatever's inside it might." instead;
	if noun is side door:
		say "[if Gunter is off-stage]Just open it instead[else]With what's outside? Bad idea[end if]." instead;
	if noun is rude door:
		say "Sticking a key in the rude door would annoy it further." instead;
	if noun is prison ropins:
		say "[if duck is returned]You already did[else]Yes. There should be a way to open it...but you haven't found a key, or anything like it, anywhere[end if]." instead;
	say "You don't have anything resembling a key, and that doesn't seem to need to be unlocked." instead;

the fissure is part of the ropins. description is "It's rounded, more ovular than elliptical. It doesn't seem to fit any sort of keycard--and you can't see any tumblers in it. It's shaped like a mouth mid-complaint. A name by the fissure reads [one of]Doc Lunke[or]Ned Lucko[or]Ed Clunko[or]O'Klenduc[in random order]". the fissure is vanishing and semi-easy and auxiliary.

a-text of fissure is "RYRRYYR". b-text of fissure is "PYPPYYR".

after fliptoing (this is the yow is free rule) :
	if noun is fissure or noun is prison ropins:
		now duck is unfigured;
		now prison ropins is unfigured;
		now fissure is unfigured;
		now fissure is in lalaland;
		now prison ropins is reflexed;
		now doc-y is in subsector;
		now duck is returned;
	continue the action;

check inserting into the fissure:
	say "Nothing from your inventory seems to fit it. It's really oblong."

doc-y is a super-easy auxiliary privately-named person in prison ropins. description is "[one of]You remember a slanderous (or is it libelous?) article claiming he was really Dr. Ieow, but he does look a[or]A[stopping] bit wonky, y'know? But with an intense look in his eyes[if doc-y is rowdy] as he yells[else if doc-y is wordy]as he babbles[end if][what-can-doc-say].". "Dr. Yow is pacing around semi-absent-mindedly[if doc-y is not in prison ropins] enjoying[otherwise] pining for[end if] his freedom."

to say what-can-doc-say:
	let tosay be 0;
	if doc-y has been rowdy:
		increment tosay;
	if doc-y has been wordy:
		increment tosay;
	say "[if tosay is 2]. He looks repressed, as if he has so many ways to say things, but he needs someone to bring it out of him[else if tosay is 1]He looks slightly agitated, as if he's only said half of what he wants to say[end if]"

a-text of doc-y is "RYRRO". b-text of doc-y is "RYRRO".

understand "dr/doctor/doc /yow" as doc-y.

printed name of doc-y is "Dr. Yow"

understand "dowry" as a mistake ("Dr. Yow is an intellectual. He needs a [if duck is returned]breakout[else]willing pupil[end if], not material things or romance.") when doc-y is visible.

doc-y can be rowdy, wordy or calm. doc-y is calm.

check fliptoing prison ropins:
	if duck is not visible:
		say "You fiddle with the fence but probably need someone or something to MAKE it unlocked due to how it's configured. You don't have anything on you[if ravages is unvisited]. You haven't explored up north yet[else if duck is prefigured]. You remember trying 'unlocked' with the duck[end if]. Then, UNLOCKED should work. It just feels right.";
		preef prison ropins;
		do nothing instead;

check fliptoing fissure:
	if duck is not visible:
		say "The fissure squirms a bit but settles back down. When it was open, maybe something could've gone in, but you're carrying nothing close to the right shape.";
		preef fissure;
		do nothing instead;

book Outer Route

Outer Route is west of Anemic Cinema. Outer Route is in Towers. "You're on a dirt trail, very neutral-naturel. Too bad. It could be outré if things were just rearranged a bit and maybe the right bits were accented, though it's nothing to rue. As is, it just leads west away from the curst palace."

check going west in Outer Route:
	say "That's the wrong way. You'd probably get lost." instead;

a dirt trail is useless scenery in outer route. "It's nothing special, but by the looks of it, it goes west a ways. Farther than you'd care to walk."

instead of doing something with dirt trail:
	if action is procedural:
		continue the action;
	say "Not much to do with the trail except walk west on it, which isn't the way you want to go."

instead of entering a rut:
	say "It's not the right size or shape for you."

the solve-a-loaves are an edible plural-named hintpastry in outer route. "Some solve-a-loaves have been left here.". description is "They are not huge loaves and could probably fit in a small oven[if player has toaster], like your toaster[end if]. Solve-a-Loaves is an actual brand here in Yorpwald, fortified with brain enriching nutrients."

understand "loaves" and "loaf" as solve-a-loaves.

instead of eating a person:
	if noun is the player:
		try swearing obscenely instead;
	say "You have no fork, or anything that could become a fork. Plus, gross." instead;

check eating (this is the try to eat a hint tart rule) :
	If noun is a hintpastry:
		if xrayvision is true:
			say "You're already under the influence of a pastry. XRAY something before continuing.";
		if diners are visible:
			say "The diners scoff at you eating something like that cold--well, eating that at all--and you're too embarrassed to do so[if toaster is visible]. But maybe you can put it in the toaster[end if]." instead;
		if salesmen are visible:
			say "'You know what would go great with that? NERD-AID!' says one salesman. The others agree, quickly." instead;
		if noun is not heated:
			if toaster is visible:
				say "You figure you'd better heat that up in the toaster first. So you do. Mmm, not bad[if diners are visible]. The diners let loose some dry wit about people who enjoy something THAT unrefined[end if].";
				try inserting noun into toaster instead;
			say "You should probably heat [if noun is plural-named]those[else]that[end if] up first. Like, put it in [if player has toaster]that toaster you have[else if player is in Danger Garden]the toaster on the ground[else]some household appliance for warming pastries[end if]." instead;

book rawest waters

Rawest Waters is a room in Towers. "Ew. Rats. You're splashing around in a spry raspy spray, unable to go back southwest, and unable to decide if the northern or eastern shore is closer."

eastern shore is reflexive scenery in rawest waters. "The eastern shore's not necessarily closer than the other two, unless you want it to be."

southwestern shore is scenery in rawest waters. "You can barely see it--the kid isn't there either."

northern shore is scenery in rawest waters. "You can barely see it--it's as far as the eastern shore--but it seems darker and more foreboding.". northern shore is undesc.

instead of doing something with the southwestern shore:
	if action is procedural:
		continue the action;
	say "No way to get back to the southwestern shore, really."

instead of doing something with the northern shore:
	if action is procedural:
		continue the action;
	say "It's too far to swim or do much more than magick."

understand "earnest" as a mistake ("The shore wants to get physically closer to you now. You can feel it. But that doesn't do any good. You feel like you made progress, though.") when player is in rawest.

does the player mean doing something with eastern shore: it is very likely.

a-text of eastern shore is "RYYRYRR". b-text of eastern shore is "RYYRGRR".

every turn when player is in waters:
	say "[one of]Gurgle, er, glug... [or]Waters waster, you think... [or]Spirited riptides... [in random order]your eyes go red [one of]thinking of Ernesta, the lady of finding directions[or]half-praying to St. Renae[or]half-praying to St. Earne[in random order]."

the raspy spray is scenery in rawest waters. the spray is undesc.

does the player mean drinking the spray:
	it is very likely.

instead of doing something with spray:
	if current action is drinking:
		say "You'd hate the taste of the sips." instead;
	if current action is xraying:
		continue the action;
	say "You need to worry about getting out of the spray."

understand "prays" as a mistake ("Too late to be a prayers sprayer.") when player is in rawest.

chapter jetskis

the jetskis are a plural-named thing.

check examining jetskis:
	if turbos are not part of jetskis:
		say "The jetskis seem bare-bones at the moment, not ready to ride." instead;

description of jetskis is "You don't see much on the jetskis you understand, except some turbos and a blaster. [if turbos are reflexed]The turbos seem robust enough[otherwise]A pair of turbos doesn't look quite ...hardy? No, some other word ... to help propel you across the river[end if]. [if blaster is reflexed]The blaster seems stabler than it used to be[otherwise]The blaster hums and shakes erratically[end if]."

the turbos are a reflexive plural-named thing. description of turbos is "You're not sure how they should work, but [if turbos are reflexed]you managed to[else]maybe you can[end if] counter the kid's technical knowledge by tweaking it."

the blaster is a reflexive thing. description of blaster is "You're not sure how it should work, but [if blaster is reflexed]you managed to[else]maybe you can[end if] counter the kid's technical knowledge by tweaking it. You see red writing on it."

t-or-b is a thing that varies.

instead of doing something to the turbos:
	if the action is procedural, continue the action;
	say "The turbos are too technical for you--you can probably just examine or scan them."

instead of doing something to blaster:
	if the action is procedural, continue the action;
	say "The blaster is too technical for you--you can probably just examine or scan it."

a-text of turbos is "RYRYRR". b-text of turbos is "RYRYRR".

a-text of blaster is "RRYRRYR". b-text of blaster is "RRGRRGP".

to towers-min-adj: [this is when you leave the mainland]
	wipe-towers-map;
	let und be number of guardians not in lalaland;
	d "Left [und] guardians.";
	if denim is in copse:
		d "Left denim.";
		increment und;
	if old ice are not in lalaland:
		d "Left old ice.";
		increment und;
	if pulses are not in lalaland:
		d "Left pulses.";
		increment und;
	now poss-score of towers is cur-score of towers;
	if turbos are reflexed and blaster is reflexed:
		do nothing;
	else:
		increment poss-score of towers;
	now poss-score of towers is poss-score of towers + 5; [dingy, spectacular, greyed, give flowerpot]
	now min-score of towers is min-score of towers + 1; [4 warriors, spectacular]
	if turbos are reflexive or blaster is reflexive: [rawest waters]
		increment poss-score of towers;
		increment min-score of towers;
	if player has strudel and strudel is reflexive:
		increment poss-score of towers;

to say mrmamu:
	say "[if player is female]Ma'am[else]Mister[end if]";

check taking toaster:
	if toaster is in coastlines:
		say "Best leave it with the kid." instead;

check taking jetskis:
	if turbos are not part of jetskis:
		say "'It's not even built yet, [mrmaam]! I need a tool to get the blaster and turbos working!'" instead;
	if player has toaster:
		say "'Hey! [mrmamu]! It'd be dangerous to take that toaster across the water!' He's right[if number of carried hintpastries > 0]. But you decide to heat up what you have[end if]. You leave the toaster--you bet the kid could do some cool stuff with it. it will be a decent enough payment for his time and efforts. The kid leaves the toaster on the sand.[line break]";
		now all carried hintpastries are heated;
		now toaster is in coastlines;
	else if toaster is visible:
		if number of carried not heated hintpastries > 0:
			say "You heat up the food you found since you were last here.";
		now all carried hintpastries are heated;
	if turbos are reflexive and blaster is reflexive:
		say "[one of]'Go, [mrmaam]!' You strap parts of the jetskis as instructed and head vaguely northeast, but the turbos that propel it conk out barely after you leave the shore, and the blaster fizzes, too. 'Dang! What do I need to do?' the kid mutters to himself.[or]Unfortunately, nothing's changed since the last time you were here. 'Man! I still need to fix the blaster. Or the turbos. Maybe both.'[stopping]" instead;
	say "BRRRRM! The jetskis work great. 'I'll make a glider girdle next!' the kid shouts, out of view.";
	if turbos are reflexed and blaster is reflexed:
		say "You speed across the deeps of the rawest waters as if on nine-seg engines and to the shore on the other side--so hard, they snap in two. Well, it would've been hard to return them to the kid anyway. You've made it!";
		towers-min-adj;
		now player is in Mislit Limits instead;
	say "Then you hear a voice call AIR FLUE FAILURE as you hear the [if turbos are reflexive]turbos go burst-o[otherwise]blaster, er, blast[end if]. You fall in the waters, about halfway to the opposite shore.";
	towers-min-adj;
	now player is in rawest waters instead;

check going in rawest waters:
	say "Spirited riptides! You panic a bit, unsure which shore would take the least time to get to--northern, southwestern or eastern. They all seem about the same distance. If only you could force the issue somehow--the [i]eastern[r] looks a bit more pleasant." instead;

book mislit limits

the accurst leap is auxiliary cluey scenery. "It would be sad if you jumped off it, so close to your goal."

a-text of accurst leap is "RRYRRYRYRYR". b-text of accurst leap is "RRYRRYRYRGR".

check jumping when accurst leap is visible:
	say "I won't let you! You're too close! You can't do it!" instead;

the packet of clear catsup is auxiliary cluey scenery. "The packet of clear catsup is something you'd have missed without knowing about it. It is the sort of litter that keeps the castle seeming worse than ordinary."

instead of eating clear catsup:
	say "Yuck.";

instead of opening clear catsup:
	say "Not only is it litter, but it doesn't have any ridged bits to make it open easier. Still, a potential clue is a potential clue."

a-text of clear catsup is "RRYRRYRYRYR". b-text of clear catsup is "RRGRRYRYRYR".

the pest accrual is auxiliary cluey scenery. "Eww! Maybe they're good for nature or something."

a-text of pest accrual is "RRYRRYRYRYR". b-text of pest accrual is "RRYRRYPYRGR".

the c-p is privately-named auxiliary cluey scenery. printed name of c-p is "cactus pearl.". "You're pretty sure it's not a pearl cactus. That'd be bigger."

a-text of c-p is "RRYRRYRYRYR". b-text of c-p is "RRYRRYRYRYR".

does the player mean doing something with the c-p when c-p is visible: it is likely.
does the player mean doing something with the pearl cactus when c-p is not visible: it is likely.

the pearl cactus is auxiliary cluey scenery. "You're pretty sure it's not a cactus pearl. That'd be smaller and rounder."

a-text of cactus pearl is "RRYRRYRYRYR". b-text of cactus pearl is "RRYRRYRYRYR".

the accu-plaster is auxiliary cluey scenery. "It was meant to hold some of the curst palace together, but it's crumbling now."

a-text of accu-plaster is "RRYRRYRYRYR". b-text of accu-plaster is "RRYRRYRYRYP".

the capsule cart is auxiliary cluey scenery. "It is bright red and could've held anything, really, but it reads CAPSULE CART."

a-text of capsule cart is "RRYRRYRYRYR". b-text of capsule cart is "RRYRRYRYRYR".

the Last Acre Cup is auxiliary cluey scenery. "A reward for a forgotten and useless contest, just part of the garbage here."

a-text of last acre cup is "RRYRRYRYRYR". b-text of last acre cup is "RRYRRYRYRYR".

the Talc Spa Cure is auxiliary cluey scenery. "It's empty, but it's another sort of luxury item that people moving into the Curst Palace's old location would love."

a-text of Talc Spa Cure is "RRYRRYRYRYR". b-text of Talc Spa Cure is "RRYPRYRYRYR".

nextclue is a list of thing variable. nextclue is { accurst leap, clear catsup, pest accrual, cactus pearl, pearl cactus, accu-plaster, capsule cart, last acre cup, talc spa cure }

clue-index is a number that varies.

after going to mislit limits:
	if flip-final-clue is true:
		say "You notice something [if clue-index > 0]else [end if]you wouldn't have seen without Ed Yerg's help.[run paragraph on]";
		if clue-index > 0:
			move entry clue-index in nextclue to lalaland;
		increment clue-index;
		if clue-index > number of entries in nextclue:
			now clue-index is 1;
		move entry clue-index in nextclue to mislit limits;
		say " That [entry clue-index in nextclue] must be important. You note it as further scenery in your pedanto-notepad.";
		pad-rec-q "scenery";
		now flip-final-clue is false;
	continue the action;

check taking scenery in mislit limits:
	if noun is curst palace:
		say "You need to make it worth taking back." instead;
	if noun is clear catsup:
		say "Picking up litter is admirable, but it's small thinking with your powers." instead;
	if noun is accurst leap:
		say "Take a leap of logic instead." instead;
	say "You can't and don't need to take it, but maybe you can take a clue from it." instead;

to say 3-random:
	sort table of magnifs in random order;
	say "[blurb in row 1 of table of magnifs]! [blurb in row 2 of table of magnifs]! [blurb in row 3 of table of magnifs]! He-he. Eh?[paragraph break]";

table of magnifs
blurb
"Breathtaking"
"Exceptional"
"Fantastic"
"Magnificent"
"Marvelous"
"Miraculous"
"Outstanding"
"Overwhelming"
"Sensational"
"Stupendous"
"Superlative"
"Unsurpassed"

to say a-bunch:
	say "[if number of visible warriors is 2]an ex-bunch[else]a bunch[end if]"

rule for printing a locale paragraph about a warrior (called ww):
	if ww is not Rodney:
		The rule succeeds;
	now Rodney is mentioned;
	say "Sir Rodney, still loud and boastful, is [if number of visible warriors is 1]making his last stand--he won't attack anyone, but nobody's going out[else][one of]calling to[or]leading[stopping] [a-bunch] of warriors blocking the way out. [they-just] [list of followy warriors][end if][one of].[paragraph break]But maybe this show of force will backfire. They don't look as gung-ho as they could, and once you pick off one weak link, you'll know what people--or things--are like, here[or][stopping].";
	now all visible warriors are mentioned;

definition: a room (called twr) is towery:
	if twr is trefoil, decide no;
	if map region of twr is towers, decide yes;

to say they-just:
	say "[if number of visible warriors is 2]Well, there's just[else]They include[end if]"

To decide whether the current action is no-timely:
	 (- meta -)

to decide whether the action is procedural: [aip]
	if the current action is no-timely, yes;
	if discerning, yes;
	if examining, yes;
	if fliptoing, yes;
	if attacking, yes;
	if scaning, yes;
	if scanlasting, yes;
	if objhinting, yes;
	if xraying, yes;
	if smelling, yes;
	if reading, yes;
	if gotoing, yes;
	if saying yes, yes;
	if saying no, yes;
	if dropping, yes;
	if looking, yes;
	if objasking about, yes;
	if listening, yes;
	no;

definition: a thing is followy:
	if it is rodney, no;
	if it is a warrior and it is visible, yes;
	no.

check asking Sir Rodney about:
	say "He yells 'None shall pass!' [one of]when you get close[or]and thus lives up to his name[stopping]." instead;

check going outside in Loftier Trefoil:
	if Sir Rodney is visible:
		say "Sir Rodney is blocking the way." instead;
	else:
		say "BUG! you should have been kicked out after talking to Daltho.";

check going up in Loftier Trefoil:
	say "One stare at the rates for an overnight room almost leads you to tears. You exit the large inn with a lean grin and no learning." instead;

check going down in Loftier Trefoil:
	say "'Don't loot the wines. Swine.' someone calls. Harsh." instead;

the impressive cliff is a useless backdrop. it is in Blasted Saltbed, anemic cinema, Unblest Sunbelt, danger garden. "It's impressive enough to inspire you to do something impressive, full of scaly clays."

Leak Lake is a useless backdrop. it is in salted deltas, Actionless Coastlines, Ole Shrine Shoreline. "Leak Lake is so named because many bodies of water leak into it, and it leaks into others. It smells strongly of kale. At least it does not smell of carp."

check entering leak lake:
	if jetskis are visible:
		try taking jetskis instead;
	say "Go out, eh? Too huge!" instead;

understand "kale" as a mistake ("It'd take all your energy to turn the whole lake into kale. Plus, then, the kale would have no water to survive.") when leak lake is visible.

the shoals aslosh are a useless plural-named backdrop. they are in salted deltas, Actionless Coastlines, Ole Shrine Shoreline. "They make you say 'Ah! Loss!' (or Oh! Lass! if you're feeling romantic.)"

chapter Old One's Solo Den

Solo Den is west of Mislit Limits. printed name of Solo Den is "[if ed yerg is reflexive]Lone Sod[else]Old One's[end if] Solo Den". Solo Den is an innie room in towers. "You see some writing on the wall here, and you smell something, too."

Ed Yerg is a person in Solo Den. description is "[if ed is reflexive]Despite a wrinkled face, his hair is gleaming and dark[else if crocus is not in lalaland]Ed looks a little sad[else]Ed looks relaxed and ready to chat[end if]."

understand "gyre" as a mistake ("Ed doesn't deserve THAT for his past sins. Plus, you'd get sucked in.") when player is in solo den.

check going east in solo den (this is the force give flowerpot rule):
	if player has flowerpot and flowerpot contains crocus and Ed Yerg is reflexed:
		say "Before you leave, you remember Old Hat Daltho's speech--the flowerpot seems like a nice gift for Ed, now that Ed is nicer. You give it to him.[paragraph break]'Come back if you need help with Castle Apcur!' he says, as he goes to set the crocus out somewhere nice.";
		now flowerpot is in lalaland;
	continue the action;

[??led soon]

Old Hat Daltho is an undesc.

before giving the crocus to:
	try giving flowerpot to second noun instead;

before showing the crocus to:
	try showing flowerpot to second noun instead;

understand "flower" as crocus.

check giving to Ed Yerg:
	if second noun is crocus:
		try giving flowerpot to Ed Yerg;
	if ed yerg is reflexive:
		say "Ed turns his nose up at your meager offering[if noun is flowerpot] but mentions he might've liked it when he was less ambitious[end if]." instead;
	unless noun is flowerpot:
		say "Ed thanks you, but that's not quite what he wants[if flowerpot is in lalaland]. The flowerpot was probably enough[end if]." instead;
	if crocus is reflexive:
		say "You consider giving the flowerpot to Ed Yerg, but there's nothing in it, yet. You think back to the crocus you saw outside." instead;
	say "Ed smiles at the flowerpot and looks less tense. He realizes whom the gift must be from. He sighs, nods hangs his new flower out back where it can get better, then returns, thanking you.";
	min-and;
	now flowerpot is in lalaland instead;

check going outside in solo den:
	try going east instead;

Ed Yerg is a LLPish reflexive person in Solo Den. "[if ed yerg is reflexive][one of]'What?! You got by my pester'n serpent?! Ah, good, you didn't kill it. Say, I bet I know who you must be. I'm Ed Yerg. I'll give you some valuable advice--for the right price.' You realize you have nothing of material value.[or]Ed Yerg is still here, looking greedy[stopping][else]Ed Yerg is waiting here, looking [edlook].[end if]"

to say edlook:
	if flowerpot is in lalaland:
		say "content";
		continue the action;
	else if crocus is not in flowerpot:
		say "at your flowerpot";
	else:
		say "at your [if crocus is reflexed]dying [end if]crocus";

the welt-proof flowerpot is a reflexive and LLPish container. description of flowerpot is "You don't know what good welt-proofing will do, but it might help you read the red writing on the flowerpot a bit better[if-crocus]."

to say if-crocus:
	if crocus is in flowerpot:
		say "[if crocus is reflexed], though it's probably less useful now with the crocus in decent shape[else], which can maybe help with the dying crocus[end if]";
	else:
		say ". The flowerpot is empty";

after printing the name of the flowerpot while taking inventory:
	if crocus is in flowerpot:
		say " (holding a succor crocus)";
		now succor crocus is mentioned;
	omit contents in listing;
	continue the action;

understand "pot" and "flower pot" as flowerpot.

a-text of flowerpot is "RYRRO". b-text of flowerpot is "PYRRO".

check inserting into the flowerpot:
	if noun is crocus:
		if noun is in limits:
			try taking noun instead;
		say "The crocus is in the flowerpot already." instead;
	say "Only a flower [if crocus is in flowerpot]like the crocus [end if]belongs in the flowerpot." instead;

check putting on the flowerpot:
	say "The flowerpot's sole purpose is to hold the succor crocus." instead;

instead of taking crocus:
	if crocus is in limits:
		say "It looks a bit TOO colorful for a flower, almost radioactive. In fact, from what you know about the species, that means it's close to DYING. Maybe you could tone it down." instead;
	say "It's been through enough [if crocus is reflexive]bad times[else]upheaval[end if]."

the succor crocus is an auxiliary thing in mislit limits. "A succor crocus lies here, full of livid colors that don't make you happier."

description of crocus is "[if crocus is reflexive]From what you know, the brighter a succor crocus is, the less it works. Right now, it's far too bright, and it's close to dying[else]Looking much better now[end if]."

check fliptoing flowerpot:
	if crocus is not visible:
		say "A more dingy flowerpot wouldn't help things. Maybe you need to put something in it.";
		preef flowerpot;
		do nothing instead;

after fliptoing flowerpot:
	now crocus is in flowerpot;
	continue the action;

a-text of crocus is "RYRRO". b-text of crocus is "PYRRO".

to say new-yerg-thing:
	now flip-final-clue is true;

flip-final-clue is a truth state that varies.

section planting

planting is an action applying to one thing.

understand the command "plant" as something new.

understand "plant [something]" as planting.

carry out planting:
	if noun is not crocus:
		say "You can only plant a, well, plant." instead;
	if crocus is reflexive:
		say "It already is. But maybe you could fix it and replant it." instead;
	say "The crocus is already in the flowerpot. That is planted enough." instead;
	
chapter Mislit Limits

to decide what number is palace-let:
	if location of player is topside or location of player is campsite, decide on 4;
	if location of player is copse, decide on 5;
	if location of player is lots or location of player is route or location of player is sunbelt or location of player is saltbed, decide on 6;
	if location of player is ravages or location of player is subsector or location of player is Danger Garden or location of player is havens or location of player is cinema, decide on 7;
	if location of player is deltas or location of player is shoreline, decide on 8;
	if location of player is coastlines, decide on 9;
	if location of player is solo den, decide on 10;
	if location of player is limits, decide on 11;
	decide on 2;

Mislit Limits is a room in Towers. "Everything looks a bit wrong here. It is most definitely a curst place, very reddish and separate from the curst palace nearby. You're gonna need some crazy action, or word, to make it what it was. And yet--something in the air says, lo, curse or clues? There's also a den to the west."

The Curst Palace is a reflexive backdrop.

understand "crust" as a mistake ("It probably needs less crust, not more. The whole curst palace.") when mrlp is towers.
understand "a place" as a mistake ("It already is a place. It needs to be more than that, to wipe off the stigma of being the curst palace.") when mrlp is towers.

understand "castle apcur" and "castle/apcur" as the curst palace.

check examining curst palace when player is not in mislit limits:
	say "The curst palace is too far away to make out details beyond its general decrepitude." instead;

max-pal-seen is a number that varies.

check scaning curst palace (this is the nab a few letters rule) :
	if player is in trefoil:
		say "You'll want to walk outside first, at the very least." instead;
	if player is not in mislit limits:
		if max-pal-seen is 0:
			say "You'd think you would see eleven lights for the curst palace, but some are blacked out, as if the settler was too far away to analyze everything.";
		else if palace-let > max-pal-seen:
			say "Ooh! A few more lights, now.";
		else:
			say "You don't see any more than you have before[if palace-let < max-pal-seen]. In fact, you have less information than when you were closer[end if].";
	else if max-pal-seen < 11:
		say "The entire settler lights up[if max-pal-seen is 0]--but it takes a while. You're lucky you're so close.[else], finally[end if]!";
	if max-pal-seen < palace-let:
		now max-pal-seen is palace-let;

check fliptoing curst palace when player is not in mislit limits:
	say "Your word, stupendous as it is, has no effect. Yet. You [if player is in solo den]may need to go back outside[else]are probably not close enough[end if].";
	preef curst palace;
	the rule fails;

instead of doing something with the curst palace when player is not in mislit limits:
	if action is procedural:
		continue the action;
	say "The palace is too far away to interact. You need to get closer, and even then, you can probably only examine or scan it. Or say the right word to restore it.";

a-text of curst palace is "[cpset of false]". b-text of curst palace is "[cpset of true]".

to say cpset of (mytru - a truth state):
	let p-l be palace-let;
	say "RRY[if p-l < 4]*[else]R[end if][if p-l < 5]*[else if mytru is true]?[run paragraph on][else]R[end if][if p-l < 6]*[else]Y[end if][if p-l < 7]*[else]R[end if][if p-l < 8]*[else]Y[end if][if p-l < 9]*[else]R[end if][if p-l < 10]*[else]Y[end if][if p-l < 11]*[else]?[run paragraph on][end if]";

instead of entering curst palace:
	say "No time to browse bowers. Plus, it's still cursed."

description of Curst Palace is "The curst palace Castle Apcur towers high enough to see across the lake. But perhaps it could be much nicer...with just one word..."

check going inside in Mislit Limits:
	if serpent is visible:
		say "You can't risk sneaking by the serpent--Castle Apcur is right here, waiting to be changed! Just one (long) word! Though maybe if you could get rid of the serpent, it might help." instead;
	try going west instead;

check going in Mislit Limits:
	if noun is not inside and noun is not west:
		say "No. Your destiny is here[if serpent is visible], though the serpent may be guarding some help to the west[else], though maybe you can go west for help[end if]. One big, powerful word and the castle will be restored!" instead;

check going west in mislit limits:
	if pester'n serpent is in limits:
		say "Not with that serpent pester'n." instead;

section serpent

understand the command "present" as something new.

A pester'n serpent is a vanishing LLPish animal in Mislit Limits. initial appearance of pester'n serpent is "[one of]A[or]The[stopping] pester'n serpent guards the way west. It lets out ten reps of a particularly nasty hiss."

rule for supplying a missing second noun when showing:
	if pester'n serpent is visible:
		now second noun is pester'n serpent.

understand "repents" as a mistake ("The serpent remains kinda chaotic evil looking, and not just because it can't understand English. You see red at using a verb and not an adjective.") when serpent is visible.

understand "respent" as a mistake ("You're not sure if the serpent's ever been spent, so you can't quite make it re-spent. You feel you have to be close, though.") when serpent is visible.

a-text of pester'n serpent is "RRYRYRR". b-text of pester'n serpent is "?RYRY??".

book Towers specific verbs

check fliptoing kid:
	if doc-y is not visible:
		say "[reject]" instead;

chapter rowdying

every turn (this is the cool rowdy rule):
	if doc-cool > 0:
		decrement doc-cool;
		if doc-cool is 1:
			if doc-y is visible:
				say "Dr. Yow was [if doc-y is rowdy]rowdier[otherwise]wordier[end if] a bit ago. Now he's worried.";
		if doc-cool is 0:
			if doc-y is visible:
				say "Dr. Yow quits talking. He's not [if doc-y is rowdy]rowdy[otherwise]wordy[end if] any more.";
			now doc-y is calm;

doc-cool is a number that varies. doc-cool is usually 0.

rowdying is an action applying to nothing.

understand the command "rowdy" as something new.

understand "rowdy" as rowdying.

carry out rowdying:
	if doc-y is not visible:
		if location of player is not obscurest:
			say "[reject]" instead;
	if doc-y is rowdy:
		say "You recharge Dr. Yow's rowdiness.";
	otherwise:
		say "Dr. Yow appears charged! He begins ranting about scientific solutions and implementations and so forth, and how [one of]he was called wormy Mr. Yow until he got his Ph.D., and the worst he gets is 'Wooly Ol['] Yow' now[or]someone needs to grundy Dr. Yung[or]you can be a weirdo AND woe-rid[or]Dr. Ney is his idol[cycling]. It's quite a sight[if doc-y is in prison ropins], even through the jail door[end if][unless doc-y has been rowdy][one of]. You doubt he's like this all the time, though. Maybe he can speak more calmly, in other situations[or][stopping][end if].";
	unless doc-y has been rowdy:
		reg-inc;
	now doc-y is rowdy;
	now doc-cool is 3;
	if kid is visible:
		now doc-cool is 0;
		if kid is reflexive:
			say "[line break]The kid is too star-struck to listen carefully. It's hard not to be tentative in the presence of such a great genius. He's unstabler than a subaltern of a great thinker like Dr. Yow needs to be.";
		otherwise:
			kid-gets-it instead;
	the rule succeeds;

[rowdy -> attentive]

to kid-gets-it:
	say "The kid's understanding is paltry at first, but he's attentive, so he gets it partly, then he exclaims raptly 'Droll Dr. LOL!' Dr. Yow's confident now, explaining patly and aptly. 'Call me Dr. Leo--older version of you.' They converse animatedly about the dream of no-silage gasoline, but Dr. Yow convinces him to start small.[paragraph break]The lecture over, the kid says, 'Dr.?'[paragraph break]'Toy! Try! Do!' The kid smacks his forehead and runs off 'It--it won't just be pseudo-souped! Pen lids, spindle...' He runs off to the Actionless Coastlines.[paragraph break]'Wait! Kid! I have this lots-o-tools stool...' but the kid's gone.[paragraph break]'Wait! Where is it? O lost!' He searches his pockets, just in case.[paragraph break]'Dr. Yow's Drowsy. My lab: balmy. Long cameo.' Then, above his duck's quack, 'come along.' He follows a loading diagonal, off for some bachelor lab chore. Before he does, he shows you a picture labeled CURSEE RESCUE, featuring--a very unflattering portrait of yourself, before sticking it in his pocket. 'That dude[if player is female], um, dudess[end if] with the powers. House arrest, I heard. You look like someone who cares.' Unintentional compliments are the nicest.";
	now doc-y is in lalaland;
	now duck is in lalaland;
	now kid is in Actionless Coastlines;
	now jetskis are in actionless coastlines;

after fliptoing smart kid:
	if doc-y is wordy:
		say "The kid's attentive now, but Dr. Yow's wordiness isn't quite exciting enough for learning." instead;
	if doc-y is rowdy:
		kid-gets-it instead;
	say "Unfortunately, Dr. Yow has nothing to say--maybe you can help him, there.";
	continue the action;

chapter wordying

wordying is an action applying to nothing.

understand the command "wordy" as something new.

understand "wordy" as wordying.

carry out wordying:
	if doc-y is not visible:
		if location of player is not obscurest:
			say "[reject]" instead;
	if doc-y is wordy:
		say "You recharge Dr. Yow's wordiness.";
	otherwise:
		say "[if smart kid is visible]Dr. Yow starts discussing Wry Do too theoretical for adolescent ears to appreciate. You hear the kid mutter 'Ow. Dry.'[line break][else]Dr. Yow just starts talking about stuff like the weather, etc. It's drivel, a nice version of Dr. Evil[wordy-hinty].[end if]";
	unless doc-y has been wordy:
		reg-inc;
	now doc-y is wordy;
	now doc-cool is 3;
	if kid is visible:
		say "[line break][if doc-y was wordy]Dr. Yow's wordiness isn't helping the kid[else]The kid initially seems excited as Dr. Yow begins to talk, but it's all a bit too wonky, y'know? It quickly becomes dry--ok, dorky. Perhaps if the presentation were more exciting[end if].";
	the rule succeeds;

to say wordy-hinty:
	say "[unless doc-y has been wordy][one of]. You doubt he's like this all the time, though. Maybe he can speak more excitingly, in other situations[or][stopping]"

understand "dowry" as a mistake ("Marriage is probably the last thing on Dr. Yow's mind right now[if prison ropins is reflexed], even though he probably is pleased with you[else], and the only thing worse than being imprisoned would be...well...feeling like property[end if].") when doc-y is visible.

chapter guardian stubs

report taking in Topside:
	if noun is toaster:
		say "[if Ray Eck is in topside]'A neat gadget. But not as fun as my keycar.'[else]You won a free toaster once, in a raffle. But getting this toaster feels cooler.[end if]";
	else if noun is strudel and ray eck is in topside:
		say "Ray Eck babbles on about how that food's been on the ground, even if it's been in a wrapper, and it probably has all these preservatives, and if it didn't it's probably even worse for you. You sort of wish you could've snuck it without him noticing.";
	else:
		say "[if number of visible guardians > 0]The [random visible Guardian] can't resist eye-rolling when you pick up something seemingly so worthless.[else][one of]Even though no one is watching, you still feel a bit silly taking something this goofy.[or]What the heck, free [foods of noun] is free [foods of noun].[stopping][end if]";
	the rule succeeds;

to say foods of (myf - a thing):
	say "[if myf is a hintpastry]food[else]stuff[end if]";

to say gd of (zz - a guardian):
	if zz is ray eck:
		say "[one of]A yacker using a remote to control a keycar[or]Ray Eck, with his keycar,[stopping]";
		now zz is mentioned;
	else:
		say "[A zz]";
		if zz is deacons:
			say "[one of][or] (still mum about their hostile ol['] heist)[stopping]";
		if zz is atheists:
			say "[one of] (well, they're certainly wasting each other's time talking about there's no afterlife)[or][stopping]";
		if zz is nameless salesmen:
			say "[one of][or] still hawking Nerd-Aid[stopping]";
		if zz is natives:
			say "[one of][or] (you assume, by how they are talking about the Badlands and looking at you funny)[stopping]";
		if zz is ego drains:
			say "[one of][or] (you know, those barely visible spirits that make you feel bad about doing things quickly and efficiently. They exist in non-magic worlds, too)[stopping]";
	say " [if zz is plural-named]are[else]is[end if][mb-also] guarding the way [if gualoc of zz is location of player][guadir of zz][otherwise][opposite of guadir of zz][end if][mb-aswell]";

to say mb-aswell:
	if guardians-seen is 3:
		say " as well";

to say mb-also:
	if guardians-seen is 2:
		say " also";

the initial appearance of a guardian is usually "[gd of the item described]."

chapter who are the guardians?

The once-sad deacons are plural-named purple guardians. description is "They tut-tut you and argue the reason you are most likely to miss out on heaven. But they are all equally hostile."

understand "deacon" as deacons.

a-text of deacons is "RYRYYRR". b-text of deacons is "PGRYYRR".

The man covered in inapt paint is a blue guardian. description is "He has, in inapt paint on his chest, FLEMISH. He cries out 'I'm not Flemish! Nothing against [']em! It's just not me!'"

understand "tap in" and "tapin" as a mistake ("You don't have time for soccer/football, and unfortunately, it's not a five-letter solution. Perhaps you should read what the paint says.") when man covered is visible.

understand "painted man" and "mel fish" and "mel" and "fish" as man covered in inapt paint.

the i-p is part of the man covered in inapt paint. the i-p is privately-named. printed name of i-p is "inapt paint". understand "inapt/paint" and "inapt paint" as i-p.

does the player mean doing something with inapt paint: it is very likely.

after doing something with paint:
	set the pronoun him to man covered in inapt paint;
	continue the action;

instead of scaning i-p:
	try scaning inapt paint instead;

description of i-p is "Didn't need a pint to spell out FLEMISH."

a-text of man covered in inapt paint is "RYRRYRR". b-text of man covered in inapt paint is "RYRRYRR".

understand "flemish/painted man" as man covered in inapt paint.

some natives are a plural-named white guardian. indefinite article of natives is "several".

understand "native" as natives.

description of natives is "They're not, like, a particular skin color or with a particular accent. That'd be racist of me. They just seem to talk about the Badlands like they know all about it, and they're looking at you funny, as if they know you don't fit in."

a-text of natives is "RYYRYRR". b-text of natives is "?GYRYRR".

The sweatier wait-seer is a blue guardian.

understand "wait/ seer" as wait-seer.

description of sweatier wait-seer is "He is sweatier than anyone else you have run across here. But as-is, he has more than enough energy to beat you up. He mutters 'I...we...stare,' turning red, as you look at him."

understand "sweat" and "waste" and "waste ire" as a mistake ("You waste sweat and ire thinking what to do.") when sweatier wait-seer is visible.

a-text of wait-seer is "RYYRYYRR". b-text of wait-seer is "?YYRY?RR".

The snider diners are plural-named semi-easy flippable blue guardians. description is "They're sniffing the air and mumbling about sophisticated palates and not being interrupted. All very drily."

understand "diner" as diners.

a-text of snider diners is "RYRRYR". b-text of snider diners is "R??R?R".

The nameless salesmen are plural-named male blue guardians. understand "men/salesman" as salesmen.

description of nameless salesmen is "They look dandier than anyone you've met here. They seem to gain energy from their shirts, bizarrely. Shirts by that one designer whose name you can't remember.[paragraph break]You think you smell something, too, but you can't place it."

the salesmen wear the shirts. the shirts are cluey and plural-named.

instead of doing something with the shirts:
	if current action is scaning or current action is examining or current action is objhinting:
		continue the action.;
	say "They're the salesmen's, and you couldn't pull off wearing them. You wouldn't want to. So you don't need to do much with them."

the bottles of Nerd-Aid are an auxiliary thing. the salesmen carry the Nerd-Aid. understand "wares" as nerd-aid. understand "nerd/aid" and "nerdaid" and "nerd aid" as nerd-aid.

a-text of Nerd-Aid is "RRYYRYR". b-text of Nerd-Aid is "RRYYRYP".

description of Nerd-Aid is "You can't make out what the Nerd-Aid should be, and maybe that's all for the best."

instead of doing something with the nerd-aid:
	if current action is taking or current action is eating or current action is drinking:
		say "You'd need to buy it, and you've no money, and it's pretty much glorified sugar-water anyway." instead;
	if action is procedural:
		continue the action;
	say "The Nerd-Aid is not worth doing anything with. To, maybe, but not with.";

description of shirts is "You think you recognize them now. They're from the popular designer Ed Indar. Who always signs his name in red."

a-text of salesmen is "RRYYRYR". b-text of salesmen is "PRYYRGR".

a-text of shirts is "RRYYRYR". b-text of shirts is "PRYYRGR".

The muscly hulk is a red guardian.

description of muscly hulk is "He's certainly muscly. He looks relatively light on his toes for his size, too."

understand "scumly" as a mistake ("Creative, but borderline ungrammatical moral judgments won't help you get on with things. They're awkward, careless, unwieldy, lumbering...hmmph.") when muscly hulk is visible.

a-text of muscly is "RRYRRO". b-text of muscly is "RRYRRB".

The ingrates are plural-named white guardians.

understand "ingrate" as ingrates.

understand "granites" and "granite" as a mistake ("They're already stonewalling you from going west. You're not sure you need to, but if you do, you won't til they're gone.") when ingrates are visible.

description of ingrates is "They're spouting some of the [i]angriest[r] ranting you've heard, though it doesn't make you see red right away. And yet, angriest is so close to whining."

a-text of ingrates is "YRRRRYYR". b-text of ingrates is "YPPRRYGR".

[a-text of ingrates is "YRRRRYYR". b-text of ingrates is "GPPRRYYR".]

description of pester'n serpent is "It's coiled and ready to strike anyone who tries to go by it."

The bonker is a purple guardian. description of bonker is "It's twice your height and upright and club-shaped and probably ready to [if bonker is passtried]re-[end if]bonk anyone who goes east while it's still functional, and boy does it look functional[one of]. Other guardians are not so violent. Must be something important back there[or][stopping]."

a-text of bonker is "RRYRYR". b-text of bonker is "PRYPGR".

retrytext of bonker is ", poised to re-bonk"

An admirer is a female purple guardian.

a-text of admirer is "RYRRYYR". b-text of admirer is "RYRRYGR".

description of admirer is "[if admirer is male]He[else]She[end if] seems to be gazing at you raptly, as if out of puppy love. While [admsex] is too scared to approach you, you doubt you can get by without some really awkward conversation. It's like [admsex] needs that special someone you can't be while you're trekking the Badlands."

to say admsex:
	say "[if admirer is male]he[else]she[end if]"

the oddly rewired robot is a purple guardian. understand "prevent/robot/bot" as oddly rewired robot.

description of oddly rewired robot is "It is in perfect compliance with Obst-Bots (Obstacle? Obstinate? Both? Nobody ever remembers) regulations assuring you it has recently been [i]rewired[r] to be the best at guarding important places. You could probably listen to its odd beeping to drive yourself up the wall. You see red writing on it."

a-text of oddly rewired robot is "RYYRRYR". b-text of oddly rewired robot is "RGYRRGR".

the man in a REED'S ALE costume is a semi-easy red guardian.

understand "reeds ale man" and "reeds" as man in a REED'S

before doing something with costume:
	if current action is opening or current action is closing or current action is pulling or current action is taking:
		say "The man fidgets uncontrollably as you get near. Perhaps you need to help him and leave him feeling it was his choice." instead;

description of the Reed's Ale costume man is "He is in a REED'S ALE costume so annoyingly huge and bright you'd surely remember the ad and not his name if you saw him again. The costume seems half on, half off--and it seems he doesn't know which way would be best. Get canned and be free, or suffer humiliation for a paycheck? Maybe you can help."

a-text of reed's ale is "RYRYYRYR". b-text of reed's ale is "PGRYYRYR".

rese is a truth state that varies.

the alarming grailman is a blue guardian. understand "liam/ garn/" as grailman.

description of grailman is "You could probably take a below-average grailman, but this one's a cut above. He seems to be flexing his muscles a lot, waiting for someone to try going by."

a-text of alarming is "RYRRYRYR". b-text of alarming is "RYRRYR?R".

the organised ego drains are a plural-named red guardian.

description of organised ego drains is "You recognize the ego drains as odd spirits that make you feel bad about yourself and your purpose."

a-text of organised is "RRYRRYYRY". b-text of organised is "R*YRRYYRY".

the unripe iPrune is a red guardian. understand "prune" and "unripe prune" as iprune.

description of iPrune is "It's almost impossibly big for being unripe and disturbingly animated. You knew Elvira was a bit too into genetic mutations, and combining weird technology and biology, but this is crazy. It's branded with red writing."

a-text of iPrune is "RYRYYR". b-text of iPrune is "RYR?YR".

some pirates are semi-easy plural-named red guardians. description of pirates is "Sun-burnt and proud of it. They traipse, unlikely to hand you a piastre[one of]. If you look again, you might remember what the dance they're doing is[or]. You blush as you recall their dance is the Star Pie Traipse[stopping]."

understand "pirate" as pirates.

pirate-countdown is a number that varies.

every turn when pirates are visible:
	if pirate-countdown > 0:
		decrement pirate-countdown;
	else:
		if a random chance of 1 in 5 succeeds:
			say "A pirate swats at an air pest, red-faced--and reaps it! But it leaves a red welt.";
			now pirate-countdown is 3;

a-text of pirates is "RYRRYYR". b-text of pirates is "PYRRYGR".

the old ice is LLPish reflexive scenery in Blasted Saltbed. "[if old ice is reflexed]It's coiled into a really cool pattern now, thanks to you[else]Big chunks of ice are always impressive, but this could be more artistic if it weren't so flat[end if]."

a-text of old ice is "RYYRYR". b-text of old ice is "R?YRYR".

check scaning cliff:
	if old ice is reflexive:
		say "Nothing happens until you also flick across the old ice.";
		try scaning old ice instead;

Ray Eck is a proper-named semi-easy purple guardian in Topside Deposit.  description is "He doesn't look particularly wealthy or elitist, but he sure does like watching his keycar go round and round."

a-text of ray eck is "RRYYRO". b-text of ray eck is "RRYYRO".

the keycar is auxiliary scenery. description of keycar is "It zips around as Ray fiddles with his remote. It appears to have its designer's name written in red. You'd be able to read it with out too much difficulty.". understand "key" and "key car" and "car" as keycar.

check taking keycar:
	say "Ray Eck laughs as it zips around out of your grasp. What a jerk." instead;

a-text of keycar is "RRYYRO". b-text of keycar is "RRYYRO".

the Atheists are plural-named purple guardians. description is "They nod and gesture and say 'A-ha!' a lot, but they do seem to draw out everything they say."

understand "atheist" as atheists.

a-text of atheists is "RYRRYYRR". b-text of atheists is "RYRRGYRR".

the neural pulses are plural-named LLPish vanishing scenery in Unblest Sunbelt.

description of neural pulses is "They seem to cause neural shocks when you get too close. And they make you see red when you think of...Lauren. Man, she was beyond fake. What did [if player is male]other [end if]guys see in her?"

a-text of pulses is "YRRYYR". b-text of pulses is "YRRYGP".


chapter guardian table

table of guard-org [organized going 1st north then east. W, N, E.]
guy	loc	blockdir	blokzorz	kloozorz	taunt	aux
muscly hulk	Scope Copse	north	"He shows surprising dexterity for someone so muscly as he forces you back."
oddly rewired robot	Scope Copse	west	"'I-was-rewired-enough-to-be-just-normal-enough-to-block-you,' says robot, as if pre-set to 'pester.' It smiles in a way it knows drew ire, and you see red."
snider diners	Scope Copse	east	"They sniff and seem to dig around for concealed cutlery. You don't need or want any part of that, or of their wit[if player has dagger], even if your ragged dagger were more effective[end if]."	--	"The diners smack their lips, and you think you hear the zhk of silverware."
iPrune	Blasted Saltbed	north	"The iPrune rumbles over to block your way. [one of]It asks where you're going, and you mumble, red-faced, 'Er, up in...' but you can't say where, ultimately[or]'REIN UP!' it yells, making you see red[in random order][one of]. Maybe if you tried to pass again, both sides could have their say[or][stopping]."	"Looking at the iPrune, you are intimidated by how unnaturally big it is. Maybe the solution is easier than you're worried it is."
pirates	Blasted Saltbed	east	"'Tips are...' one pirate says. 'Spare it!' you lash out. Everyone's a bit red-faced over this."	--	"A wry, wary 'Yawr!' from the pirates makes you feel awry."
ingrates	Anemic Cinema	west	"They quite simply won't shut up about things, though they seem well-feed, intelligent and un-ugly enough. They're the rangiest of the nuisances you've come across, zipping back and forth in a red blur."
an admirer	Anemic Cinema	north	"Your admirer, a rampant mantrap, hugs you and won't let go and explains you are even cuter than the lost duck over behind them."
sweatier wait-seer	Anemic Cinema	east	"The wait-seer doesn't break a second sweat as he convinces you you don't need to go past him. There are ways around him, and perhaps you don't need to visit what is behind him to fulfill this quest. He seems not at all tired by his lecture, or by whatever mind-fu he pulled on you while just sitting there."
man covered in inapt paint	Unblest Sunbelt	north	"The man grabs you and whines about who he is, who he's been made to be, who he can't be, and ends with 'I'm flesh!' You back off until he lets go."
nameless salesmen	Unblest Sunbelt	east	"You try to sneak by, but you don't have the energy to resist their waves of faux-politeness as they offer up some Nerd-Aid, which seems just right for someone like you--don't take it the wrong way--that they're [i]dandier[r] than. The energy just radiates from their shirts as their stream of yannos annoys you into...gnh...nothing."
reed's ale	Ravages	east	"The Reed's Ale man blocks you--his costume looks stupid, but it's not encumbering--and asks you to help him out, and not just about buying, but about whether he should continue this career."	"The Reed's Ale man fidgets with his costume, unsure if he wants to take it off or put it on."
an alarming grailman	Ravages	north	"The grailman, with well-above-average skills for your average passage-blocker, gets in front of you. You're not going that way with him there."
Ray Eck	Deposit	north	"The yacker controls his keycar so it runs over your foot. You briefly wonder if he has a twin named Kim."	"The yacker introduces himself as Ray Eck, grateful there's someone out here who doesn't mind talking."	"Ray Eck's keycar can't go that far, so you manage to escape."	keycar
organised ego drains	Danger Garden	north	"'[one of]NO, SIR! EGAD[or]NO, EGAD, SIR[or]SIR, EGAD, NO[at random]!' you seem to hear as you try to walk through a mist that turns red. [if player is female]You lack the confidence even to mention you are female, so they're wrong like that, at least. [end if]You also get this idea in your mind--why bother going that way? It's coherent and not over-the-top, [one of]why not to visit that SAD REGION[or]that you could get there some other way, DIG, REASON[or]that you're lucky you got no EAR DOSING[or]capped with a motto, DOERS GAIN[in random order]. So few words, so much seeing red."
bonker	Danger Garden	east	"[if bonker was passtried]RE-BONK! You see red and[else]BONK! The bonker, true to its name, re-bonks you with sockin['] coinks. Your retinas re-stain. It's not lethal or anything, but you[end if] stagger back, dazed, to the center of Danger Garden[if natives are visible]. The natives can't help but mutter that THEY would've known better[end if]. The bonker still looks in good shape."	"'JAIL DEFENDED!' you hear from the east."
natives	Danger Garden	south	"The natives assure you there isn't anything you REALLY want to see there. Perhaps there are better things elsewhere, but nothing behind there. I mean, they don't even know why they're HERE. They should be doing better."
Atheists	Deltas	east	"The atheists slowly and painfully explain to you that you're ignoring them and their very logical arguments. You can run away, but running through them--that's just rude."
once-sad deacons	Ole Shrine Shoreline	north	"They mention you [one of]should know better than[or]are more persistent than[stopping] that kid with his blasphemous science experiments.[paragraph break]How very [i]hostile[r]. It might be good for their careers if you fixed that."

chapter min-score-of-towers

adjblasting is an action applying to one thing.

a room can be tower-accessible. a room is usually not tower-accessible.

test tm with "gonear strip/purloin settler/towers/enter/poss/docile/n"

a room can be accessible, sideview, mightaswell or inaccessible. a room is usually inaccessible.

after fliptoing a guardian (this is the track guardian progress rule):
	let G be up;
	choose row with guy of noun in table of guard-org;
	if location of player is loc entry:
		now G is blockdir entry;
	else:
		now G is opposite of blockdir entry;
	let MR be the room G of location of player;
	now noun is prodded;
	if noun is ray eck:
		now topside is accessible;
		now copse is accessible;
		continue the action;
	if noun is white:
		now MR is mightaswell;
		min-up;
		if can-see-map:
			draw-my-loc;
		continue the action;
	if noun is purple:
		if MR is coastlines or player is in coastlines:
			now MR is accessible;
		else:
			now MR is sideview;
		if can-see-map:
			draw-my-loc;
		continue the action;
	if MR is accessible:
		say "You [if room G of location of player is visited]notice somewhere [G] you already went to, so it'll be a little easier to get around[else]calculate you found a new path to an area you haven't seen yet[end if].";
		d "You already unlocked [MR].";
	else:
		d "You just unlocked [MR].";
	if MR is not sideview or MR is not mightaswell:
		now MR is accessible;
	if can-see-map:
		draw-my-loc;
	let RG be number of red guardians not in lalaland;
	let BG be number of blue guardians not in lalaland;
	d "Reds now [RG], blues now [BG]. [noun] = [if noun is red]red[else if noun is blue]blue[else if noun is white]white[else]purple[end if].";
	if noun is red and RG >= BG:
		min-up;
	if noun is blue and BG >= RG:
		min-up;
	if number of visible guardians > 0:
		now mr-hinty is a random visible guardian;
	else if scope copse is visited:
		if any-cleared is false:
			now any-cleared is true;
			say "Well, this is the first place you cleared all the guardians from, which feels nice. [if spec-o-scope is unexamined]You don't know if you need any area completely cleared, but maybe you can check the scope[bak-copse] for more guidance[end if].";
		else if RG is 0 or BG is 0:
			if clear-warn is false:
				say "You can move everywhere, now, but maybe you can clear a few more passages, if you want.";
				now clear-warn is true;
		else if RG + BG < 6:
			say "You probably don't have much left to do, to get everywhere you need.";
		else if number of guardians not in lalaland is 0:
			say "You've gotten rid of everyone! Now to get across the lake."; [?? tighten up a bit]
	continue the action;

clear-warn is a truth state that varies.

any-cleared is a truth state that varies;

to say bak-copse:
	say "[if player is not in copse] back in the copse";

[	if MR is a hotcorner:
		now distance of MR is 0;
	repeat with HS running through hotcorners:
		if MR is adjacent to HS and MR is a hotcorner and distance of MR > 1:
			now distance of MR is 1;
	d "[new-br-needed] is the new br needed. [br-needed] is the old.";
	d "Blue = [number of blue guardians not in lalaland] Red = [number of red guardians not in lalaland], overall = [new-br-needed].";]

mr-hinty is a guardian that varies.

check going (this is the guardian reposition before rule):
	if mrlp is Towers:
		if noun is not a direction:
			say "You need to specify a direction, not a place." instead;
		repeat with Q running through guardians:
			if Q is in location of player:
				choose row with guy of Q in table of guard-org;
				if Q is not in lalaland:
					now Q is passtried;
					if loc entry is location and blockdir entry is noun:
						say "You're blocked going [noun] by [unless Q is proper-named]the [end if][Q]. [blokzorz entry][line break]" instead;
					if loc entry is not location and blockdir entry is opposite of noun:
						say "You're blocked going [noun] by [unless Q is proper-named]the [end if][Q]. [blokzorz entry][line break]" instead;
		if number of taunty guardians > 0:
			let Q be a random taunty guardian;
			choose row with guy of Q in table of guard-org;
			say "[taunt entry][line break]";
			continue the action;

definition: a guardian (called myg) is taunty:
	if location of myg is not location of player:
		decide no;
	choose row with guy of myg in table of guard-org;
	if there is a taunt entry:
		decide yes;
	decide no;

after going (this is the guardian reposition after rule):
	if mrlp is Towers:
		now guardians-seen is 0;
		reposition-guardians;
		if number of visible guardians > 0:
			now mr-hinty is a random visible guardian;
	continue the action;

chapter reposition-guardians

to reposition-guardians:
	[say "Repositioning guardians.";]
	repeat through table of guard-org:
		if guy entry is not in lalaland:
			if location of player is loc entry:
				now guy entry is in location of player;
				if there is an aux entry:
					now aux entry is in location of player;
			if the room blockdir entry of loc entry is location of player:
				now guy entry is in location of player;
				if there is an aux entry:
					now aux entry is in location of player;

chapter warriors

A warrior is a kind of person. a warrior is usually vanishing. a warrior can be leaderly. a warrior is usually not leaderly. a warrior can be pinko. a warrior is usually not pinko. a warrior is usually terse.

the chum of a warrior is usually Andres.

the specification of warrior is "A person who blocks your way out of the Trefoil."

roddro is a truth state that varies.
rodyon is a truth state that varies.

check fliptoing Rodney:
	if number of visible warriors > 4:
		if the player's command includes "yonder":
			say "Your attempt to bounce Rodney yonder is blocked by a few of his friends, who stumble a bit but stay upright as they combat the invisible force sucking him away. That looked like the right idea, but maybe get rid of a few of them, first?";
			now rodyon is true;
			preef Rodney instead;
		say "Rodney's voice would certainly seem droney by itself, but he segues into a marching song. I guess when you're a leader, you have that confidence. Maybe diminish his forces?";
		now roddro is true;
		preef Rodney instead;

after fliptoing a warrior:
	let vw be number of warriors in trefoil;
	d "[list of visible warriors].";
	if noun is Rodney:
		now all visible warriors are pinko;
		d "[vw] left.";
		if vw > 0:
			decrease poss-score of towers by vw;
		now all visible warriors are in lalaland;
		now player has flowerpot;
		continue the action;
	else if vw < 4:
		min-up;
	else if vw is 4:
		say "Rodney's followers look a bit shaken. If you got rid of him by saying [if roddro is true and rodyon is true]by YONDER or DRONEY[else if rodyon is true]YONDER[else if roddro is true]DRONEY[else]something to shoo him[end if], you might be able to clear the lot. Or you can mess with all his pals, first. Your choice.";
	if vw > 1:
		now h-w is a random not leaderly warrior in Trefoil;
	else if vw is 1:
		say "Time to put Rodney out of his misery. Okay, he'll still be miserable, so just put [i]yourself[r] out of the range of his misery.";
		now h-w is rodney;
	continue the action;

Sir Rodney is a leaderly warrior. description is "A big strong fellow who probably won't be removed by physical force. He looks sort of like Red Bull Burdell's weaker younger brother.". The chum of Rodney is yourself.

Andres is a warrior. description is "He doesn't look restricted in any way.". The chum of Andres is yourself.
Andrew is a warrior. description is "He has a careless look in his eyes. He does not seem to be aware of risk."
Archie is a warrior. description is "He looks free of pain."
Barney is a warrior. description is "He seems far too close, but maybe you could push him back."
Blake is a warrior. description is "He beams, likely a paragon of positive thinking."
Bredo is a warrior. description is "He seems focused and interested."
Cedrick is a warrior. description is "He moves effortlessly, without any hitches."
Daryl is a warrior. description is "He has no fat on him."
Demitri is a warrior. description is "He stares out, bolder than his compatriots."
Dewey is a warrior. description is "Solidly build, almost less just a man than a big tree."
Edwin is a warrior. description is "He looks sober and focused, except when he briefly gives a red-faced glare at all the alcohol in here."
Eldon is a warrior. description is "He looks vigorous and youthful."
Ernest is a warrior. description is "He looks relaxed and ready to gaffle tavernlings."
Geno is a semi-easy warrior. description is "Well, he's ... here. He hasn't left yet. He may not be the best warrior, but he's still stronger than you."
Goldy is a warrior. description is "Goldy has an amoral, mercenary look about him."
Leander is a warrior. description is "He looks too dumb to contemplate anything besides knocking people's heads in."
Marcel is a warrior. description is "He is clearly just agitated."
Marlon is a warrior. description is "He doesn't look like all the rest, but he's comfortable with that."
Preston is a warrior. description is "He appears to be the best protected of your persecutors."
Reggie is a warrior. description is "He looks spotless--no stains on his clothes. He probably smells as nice as he looks, too."
Royce is a warrior. description is "He seems to be looking at the door as if to make a bolt for it."
Shane is a warrior. description is "He looks well-tanned."
Terrance is a warrior. description is "He constantly looks at Rodney and nods."
Tyson is a warrior. description is "He keeps snarling at people, red-faced."
Wade is a warrior. description is "He looks confident, as if nothing can drain that."

a-text of Andres is "RRYRYR". b-text of Andres is "RPYPGR".
a-text of Andrew is "RYRRYR". b-text of Andrew is "RYRRGR".
a-text of Archie is "YRRYYR". b-text of Archie is "GRRYYR".
a-text of Barney is "RYYRRO". b-text of barney is "RYYRRB".
a-text of Bredo is "RYRYR". b-text of Bredo is "PYRYR".
a-text of Blake is "RRYYR". b-text of Blake is "PPYYR".
a-text of Cedrick is "RRYRRYR". b-text of Cedrick is "PRYRRYR".
a-text of Daryl is "RYRRO". b-text of Daryl is "RGPRO".
a-text of Demitri is "RYRYRYR". b-text of Demitri is "RYPGRYR".
a-text of Dewey is "RYYRO". b-text of Dewey is "RGYRB".
a-text of Edwin is "RYRYR". b-text of Edwin is "RYRYR".
a-text of Eldon is "YRRYR". b-text of Eldon is "YPPYP".
a-text of Ernest is "RYRRYR". b-text of Ernest is "RYPRYR".
a-text of Geno is "RYRY". b-text of Geno is "PYPY".
a-text of Goldy is "RYRRO". b-text of Goldy is "PGRRB".
a-text of Leander is "RYYRRYR". b-text of Leander is "PGGRRGR".
a-text of Marcel is "RYRRYR". b-text of marcel is "RGRRGR".
a-text of Marlon is "RYRRYR". b-text of Marlon is "RYPRYR".
a-text of Preston is "RRYRYRR". b-text of Preston is "PPYRYRR".
a-text of Reggie is "YRRYYR". b-text of Reggie is "YRPYYR".
a-text of Rodney is "OYRRYR". b-text of Rodney is "OGRRGR".
a-text of Royce is "RYOYR". b-text of royce is "RGBYR".
a-text of Shane is "YRRYR". b-text of Shane is "YRRYR".
a-text of Terrance is "RYRRYYRR". b-text of Terrance is "RGRPYYRR".
a-text of Tyson is "RRYRO". b-text of Tyson is "RRYRO".
a-text of Wade is "YRYR". b-text of wade is "YRYR".

Table of warguys
fighter	vuln	wargrp
Andres	"snared"	5
Andrew	"warned"	5
Archie	"achier"	5
Barney	"nearby"	5
Blake	"bleak"	3
Bredo	"bored"	3
Cedrick	"cricked"	6
Daryl	"lardy"	3
Demitri	"timider"	6
Dewey	"weedy"	3
Edwin	"wined"	2
Eldon	"olden"	2
Ernest	"tenser"	4
Geno	"gone"	1
Goldy	"godly"	2
Leander	"learned"	6
Marcel	"calmer"	4
Marlon	"normal"	4
Preston	"pronest"	6
Reggie	"eggier"	4
Rodney	"yonder"	7
Royce	"coyer"	2
Shane	"ashen"	1
Terrance	"recreant"	6
Tyson	"stony"	1
Wade	"awed"	1

when play begins (this is the distribute warriors rule) :
	now Rodney is in Loftier Trefoil;
	sort table of warguys in random order;
	repeat with temp running from 1 to 6:
		choose row with wargrp of temp in table of warguys;
		now fighter entry is in trefoil;
	now h-w is a random not leaderly warrior in Trefoil;
[This pulls 1 guy from each wargroup. As of release 3 there are 26 distinct guys with 5.65 letters--the shuffling was previously totally random but now it's weighted down to ~5.61 with a more uniform distribution. You are sure to get 2 6's, 2 5's, a 7-8 and a 4-5.]

understand "wendi" as a mistake ("Now that would be too embarrassing. Maybe you could embarrass him a little, though.") when player is in trefoil and Edwin is in trefoil.

understand "recalm" and "recalm marcel" as a mistake ("Right idea, but it might work better in [if cur-score of oyster > 0]the oyster[else]another area[end if].") when player is in trefoil and marcel is in trefoil.

understand "radly" as a mistake ("You don't want to make any warriors do things RIGHT. Maybe you could make Daryl feel less radly about himself.") when player is in trefoil and Daryl is in trefoil.

volume routes

last-loc of routes is Same Mesa.

book Same Mesa

Same Mesa is a room in Routes. "Routes lead in all directions here, but they seem to twist before going anywhere. There's a plain old church here, replete with a church sign. You see [if bench is in lalaland]that bench the giant sat on[else if old giant is visible]the giant's bench[else]a bench, which looks to be a giant's[end if].[paragraph break]A grubby dwelling[if adobe is visited and pipe soot is in abode] (ACROSS to go back)[end if] and a dilapidated restaurant[if idle deli is visited and mushrooms are off-stage] (PAST to go back,)[else],[end if] each with its own sign, are here[if worst ad is visible], and far off, beyond the perimeter of the poison stripe, you can see the worst ad you've ever seen[go-worst][end if]."

to say go-worst:
	if worst ad is prefigured:
		say "--the one you tried to go TOWARDS with the giant around";

check scaning old giant (this is the scan other parts of giant instead rule):
	if bench-end is reflexive:
		try scaning the bench-end instead;
	if elbow is reflexive:
		say "The settler registers something only when the elbow is in its way.";
		try scaning elbow instead;
	if nuder is visible:
		try scaning nuder instead;

tirades are scenery. "They're not very good tirades[if nuder is visible], but they're all about Rude [']N Nuder[else if bench-end is reflexed], and you're more concerned about the giant's elbow[else], but maybe you could position yourself better to listen to them[end if]."

check scaning tirades:
	if bench-end is reflexive:
		try scaning bench-end instead;
	if elbow is reflexive:
		say "The settler lights up when the elbow flashes across.";
		try scaning elbow instead;
	say "The settler really lights up when the giant waves the book at it.";
	try scaning Nuder instead;

after fliptoing old giant:
	now tirades are in same mesa;
	continue the action;

understand "preposition" and "prepositions" as a mistake ("Yes, but WHICH prepositions?") when player is in same mesa.

the poison stripe is scenery in Same Mesa.

description of poison stripe is "You can't really see it, but you can FEEL it."

instead of doing something with the poison stripe:
	say "You can really only sense the poison stripe, which is all you need to do. You will need to look around for a way out."

understand "seam" as a mistake ("You can't find any crack in the Same Mesa that you could follow[if the-b is visible], except maybe under the bean[end if].") when player is in same mesa.

the plain old church is a backdrop. the plain old church is in Same Mesa and Cleric Circle. "It shows signs of decent upkeep but nothing special."

[after printing the locale description for cleric circle:
	now plain old church is in circle;

after printing the locale description for same mesa:
	now plain old church is in same mesa;]

check entering plain old church:
	if player is in cleric circle:
		try going outside instead;
	else:
		try going inside instead;

does the player mean doing something with rs:
	if player is in Same Mesa:
		it is likely;
	it is unlikely.

rs are privately-named scenery in Same Mesa. understand "routes" as rs. printed name of rs is "routes". "Staring at them makes you lose your sense of direction even further."

understand "ouster" as a mistake ("You're the ouster here, trying to get by the routes.") when player is in Same Mesa.

instead of doing something with rs:
	if action is procedural, continue the action;
	say "They're painful to think about for too long. They wind together and go off in the distance and loop around."

understand "satired" as a mistake ("Bad idea to poke fun at someone that much bigger than you.") when player is in mesa and old giant is visible.

A church sign is reflexive flippable scenery in Same Mesa.

a-text of church sign is "YRRYRY". b-text of church sign is "YRRYR[if sign-other is true]Y[else]G[end if]".

check taking the church sign:
	say "Appropriation of church property! [if circle is visited]Brother Horbert[else]Whoever's in there[end if] wouldn't deserve that." instead;

[does the player mean examining the church sign: it is likely.
does the player mean objhinting the church sign: it is likely.
does the player mean pushing the church sign: it is likely.
does the player mean scaning the church sign: it is likely.]

does the player mean entering plain old church: it is likely.
does the player mean doing something with the plain old church: it is unlikely.

sign-pushed-prompt is a truth state that varies.

after scaning church sign:
	if cheat-on is true and sign-pushed-prompt is false:
		now sign-pushed-prompt is true;
		say "Man! That wasn't helpful at all! The sign does look a bit wobbly, though, and you know these things are two-sided. Give it a push?";
		if the player consents:
			try pushing church sign instead;
		otherwise:
			say "Well, if you feel like it later, the sign or whoever put it there will forgive you."

the description of the church sign is "Parish of Satin Saint Astin[paragraph break][if Cleric Circle is unvisited]Six letters below: [dssd][kickhint][otherwise]Pal, Meet a Temple! Hubris-b-rubbish![end if]".

to say kickhint:
	if ever-pushed is false:
		say "[paragraph break]The sign does look a bit wobbly, though. Perhaps you could PUSH it.[no line break]";

understand "indies" as a mistake ("You don't need to worry about art, here.") when church sign is visible.

to say dssd:
	say "[if sign-other is false]SIN DIE[else]DIE SIN (in red)[end if]"

inwarn is a truth state that varies.

in-try is a truth state that varies.

check going in Same Mesa (this is the pin the player to the Mesa puzzles rule) :
	if old giant is visible:
		say "Even without the giant's unavoidable tirades, your head is spinning too much for directions." instead;
	if noun is a direction:
		if noun is inside:
			if Cleric Circle is unvisited:
				if adobe is visited or deli is visited:
					if adobe is visited and deli is visited:
						if inwarn is false:
							ital-say "if you want to get back to the adobe or deli, you have to go ACROSS or PAST. Sorry for the ambiguity.";
							now inwarn is true;
					else:
						say "That isn't quite how to enter the church. Do you wish to go back to the [if adobe is visited]adobe[else]deli[end if]?";
						if the player consents:
							if adobe is visited:
								move player to adobe instead;
							else:
								move player to idle deli instead;
				now in-try is true;
				say "You just can't make it through the door to the plain old church. Something blocks you--you seemed a bit too glib about getting in, and they're not sure you're on their side[if abode is visited or deli is visited]--note, for where you already visited, you need to use [aop][end if]." instead;
			move player to cleric circle instead;
		say "You try going [noun] and looking for that poison stripe--but it's invisible and makes you wind up taking turns unconsciously. You arrive back at... the same mesa[one of] (thank you, I'm here all game,)[or],[stopping] from the [opposite of noun], after several minutes." instead;
	otherwise:
		say "No matter where you try to wander, you wind up back where you are.";

to say aop:
	say "[if abode is not visited]PAST[else if deli is not visited]ACROSS[else]PAST or ACROSS[end if]";

before entering the plain old church:
	if Cleric Circle is unvisited:
		say "Its doors are open to all, but one does not enter it by brute forcing directions." instead;
	otherwise:
		say "You re-enter, no longer worried about the exact preposition for doing so.";

the dingy dwelling is semi-easy auxiliary scenery in Same Mesa. "The mark above it says Oscar's."

understand "oscar's/oscars" as the dingy dwelling.

the decrepit mark is semi-easy auxiliary scenery in Same Mesa. "***Oscar's***"

a-text of dingy dwelling is "YRRYRR". b-text of dingy dwelling is "YRRYRP".

a-text of decrepit mark is "YRRYRR". b-text of decrepit mark is "YRRYRP".

the grubby restaurant is super-easy auxiliary scenery in Same Mesa. "The marquee above it says Pat's."

the marquee is super-easy auxiliary scenery in Same Mesa. "***Pat's***[paragraph break]Only the fliest filets![paragraph break]Hopefully, that's figurative and not literal."

understand "pat's/pats" as the grubby restaurant.

understand "taps" as a mistake ("You have no bugle. Well, not in this game.") when player is in Same Mesa or player is in Idle Deli.

understand "spat" as a mistake ("Picking a fight--or spitting--is uncouth.") when player is in Same Mesa or player is in Idle Deli.

a-text of grubby restaurant is "RYRR". b-text of grubby restaurant is "PGRR".

a-text of marquee is "RYRR". b-text of marquee is "PGRR".

does the player mean entering the dingy dwelling: it is very likely.
does the player mean entering the grubby restaurant: it is very likely.
does the player mean examining the dingy dwelling: it is likely.
does the player mean examining the grubby restaurant: it is likely.

instead of entering mark:
	try entering dingy dwelling instead;

instead of entering marquee:
	try entering grubby restaurant instead;

the bench is reflexive scenery in Same Mesa. "[if old giant is in Same Mesa]The giant's on it, and he covers enough of it, you could only half squeeze in between him and the armrests[else if old giant is off-stage]It'd be a chore to sit on--it looks like it's a giant's. Probably because the words A GIANT'S are painted where you would sit. Maybe he'll come back[otherwise]The giant probably won't be around here any more[end if]."

a-text of bench is "YRYYRRR". b-text of bench is "GPYYPRR".

a-text of bench-end is "YRRRYRY". b-text of bench-end is "YRRRYRY".

check taking bench-end:
	say "The bench is too well made." instead;

check taking bench:
	say "The bench is way too big." instead;

check scaning bench:
	if old giant is off-stage:
		continue the action;
	if bench is reflexed:
		if bench-end is reflexive:
			say "The settler blinks a bit during each lull in the giant's tirades.";
			try scaning bench-end instead;
		if elbow is reflexive:
			say "Nothing happens until his elbow gets in the way of your scanner.";
			try scaning elbow instead;
		if rude is visible:
			say "Nothing happens until the giant starts waving Rude [']N Nuder in your face.";
			try scaning rude instead;
	if old giant is in lalaland:
		say "There's no more magic in the bench. Nothing more to do." instead;

Rude 'N Nuder is a semi-easy thing.

description of Rude 'N Nuder is "You aren't able to see the inside, and that's probably a good thing. People do tend to get worked up a bit more than they should about this sort of 'work,' whether extolling freedom of speech or saying how tasteless it is."

instead of doing something to Rude 'N Nuder:
	if action is procedural, continue the action;
	if old giant has Rude 'N Nuder:
		say "You can't do much with Rude 'N Nuder until you have it." instead;
	say "You don't need to do anything special with Rude [']N Nuder. Well, maybe apart from the special stuff you've been doing so far this game." instead;

a-text of Rude 'N Nuder is "YRRYR". b-text of Rude 'N Nuder is "YRPG?".

check entering the bench:
	say "[if old giant is in lalaland]You don't need to fool with the bench any more.[else if old giant is visible]You don't quite have room. And you're not going to get the giant to scootch over.[otherwise]From the size, the bench seems to be [i]a giant's[r]. If he came along, he could sit on you pretty easily.[end if]" instead;

the grouchy old giant is a person. "There's a grouchy old giant here sitting on the big bench[if Rude 'N Nuder is in Same Mesa], waving something called Rude [']N Nuder in the air[otherwise], going on some [i]tirades[r] about something or other[flail]. You're not sure if he needs his space or someone to listen to[end if]."

understand "staider" as a mistake ("[if bench-end is reflexive]You already did your best with the tirades[else]Not only directions but mind games fail to work here[end if]. The giant will complain if he wants to.") when old giant is visible.

understand "tardies" as a mistake ("You can't tell the giant off for being late.") when old giant is visible.

the giant's elbow is part of the grouchy old giant. description is "Well, thankfully, only one is flailing. Both would be extra tough to dodge. [if elbow is reflexed]But you have the hang of it now[else]Still, there's almost a pattern to it, and maybe there's a safe spot[end if]."

understand "elbows" as giant's elbow.

check fliptoing Rude 'N Nuder:
	if bench-end is reflexive:
		say "You're already below, but if you were close enough to listen, that could work." instead;

after fliptoing runed book:
	now grouchy old giant is in lalaland;
	continue the action;

the elbow is reflexive and semi-easy and auxiliary.

a-text of elbow is "RYRYR". b-text of elbow is "RYRGP".

does the player mean doing something with Rude 'N Nuder when Nuder is visible:
	it is likely.

instead of doing something to elbow:
	if action is procedural, continue the action;
	say "You'll need to find the right way to avoid it."

to say flail:
	say "[if elbow is reflexive] and flailing each elbow all about[end if]"

description of grouchy old giant is "You can't do much more than listen to the giant. [if bench is reflexed]You're not sure what he's complaining about, but it seems he really needs to[else if elbow is reflexed]His [i]tirades are as loud as ever, his arms flailing high in the air[else]He seems to be half gesturing for you to have a seat, which is ironic, because only half a seat is left[end if]."

understand "bowel" and "bowels" as a mistake ("The giant's spouting enough verbal diarrhea, so, just... no.[paragraph break]Also, you don't need to go THAT far down.") when old giant is visible and elbow is reflexive

the huge thing form above is a flippable super-easy thing. description is "It's huge all right. And it's a thing. It could cloud the stripe for a while. Perhaps it is what the priest summoned. If you could bring it down, maybe you could see what it is.". "[one of]A huge thing form above just[or]That huge thing form above still[stopping] HANGS there. It doesn't quite make sense, physically or grammatically. You'll probably want to deal with it before going anywhere."

check taking huge thing:
	say "It'd crush you. You need another way to bring it down." instead;

understand "gnash" as a mistake ("You gnash your teeth a bit thinking about how threatening the form is. Maybe if it were closer, the threat would not be so scary.") when huge thing is visible.

understand "night" as a mistake ("The thing can't block out THAT much of the sky. You've got the wrong word.") when thing form is visible.

a-text of thing form is "RRYR". b-text of thing form is "PRYP".

the worst ad is LLPish vanishing scenery in Same Mesa. "Dang it, a giant ad for RADWOST, and it's all in red, but it's too lousy to determine what RADWOST is about. Maybe if you point your settler at it, you can pick it up. You're not sure how best to approach it, with all these twisty roads. You're not sure if you need to, really."

check fliptoing worst ad:
	if old giant is visible:
		say "You can't just walk away from the giant. Well, you can, but I don't advise it. Maybe when the giant's gone.";
		preef worst ad;
		do nothing instead;

a-text of worst ad is "RYRYRRR". b-text of worst ad is "RGRYRRR".


the bench-end is part of the bench. understand "end" as bench-end. description of bench-end is "Thick enough to sit on, with not too much pain, if you found the right way.". the bench-end is reflexive.

check fliptoing bench-end:
	if old giant is not visible:
		say "You'd get lonely up there without company." instead;

chapter insideing

insideing is an action applying to nothing.

understand the command "inside" as something new.

understand "inside" as insideing.

carry out insideing:
	if player is in mesa:
		if drama armada is in mesa or the-b is in mesa:
			say "[but-armada]" instead;
	if old giant is visible:
		say "Walking away would upset the giant. I mean, into doing something, not just talking. And he is bigger than you. Maybe listening will help." instead;
	if player is in Same Mesa:
		say "[if Cleric Circle is unvisited]The church resigns ingress.[else]You go back inside, being a bit over-cautious with protocol. You could've just said IN.[end if]";
		if Cleric Circle is unvisited:
			reg-inc;
		now player is in Cleric Circle instead;
	try going inside instead;

after looking in Cleric Circle:
	if number of held quest-items is 3:
		now all quest-items are in lalaland;
		say "'You have all the reagents! Wonderful!' The priest gains esprit. 'Mixture...mixture...true mix! To censor crones like the Spiter Sprite and repeal the red orb border, changing the moronic omicron to dreamiest diameters, nag ol['] No-Gal Logan beyond an un-road to dig an urn during an... rarify this friary ... act divine. Vindicate.' He rushes off.[paragraph break]No-Gal Logan. That's an odd name. You write it down.";
		pad-rec "No-Gal Logan";
		now Brother Horbert is in lalaland;
		pad-del "reagents";
		now huge thing form above is in Same Mesa;

understand "under" as a mistake ("[if giant is visible]You can't hide from the giant like that, right now[else]There's nobody to hide from, though you could fit under the bench[end if].") when player is in mesa and Rude 'N Nuder is not visible.

understand "below" as a mistake ("Nice try, but wrong preposition for the situation.") when below-is-wrong.

to decide whether below-is-wrong:
	if player is in Adobe Abode and runed book is in Adobe Abode:
		decide yes;
	if the-b is in stripe and player is in stripe:
		decide yes;
	decide no.

after fliptoing bench:
	now old giant has Rude 'N Nuder;
	continue the action;

understand "astride" as a mistake ("[if bench-end is reflexed]The giant's not falling for your false sympathy again[else if old giant is not visible]Nobody or nothing big enough to get astride of[else]Not quite the right way to position yourself, yet[end if].") when cant-get-astride.

to decide whether cant-get-astride:
	if bench-end is reflexed, yes;
	unless old giant is visible, yes;
	decide no;

after fliptoing the-b:
	if drama armada is off-stage:
		now drama armada is in Same Mesa instead;
	continue the action;

book THE BEAN

the-b is a privately-named vanishing thing. printed name of the-b is "THE BEAN". "Oh, great. A bean landed on the Same Mesa. It's utterly enormous and forbidding. [i]The bean[r] has filled a drama armada surrounding it with bane.". description of the-b is "It's not just any bean. It's stamped THE BEAN in all-red letters. In case you were wondering if it was an egg or something, I guess.". the-b is fixed in place.

instead of taking the-b:
	say "You can't move it. Maybe you can find a way to get inside or under--wait, no, those have been done here.";

instead of entering the-b:
	say "It doesn't appear cracked." instead;

a-text of the-b is "RYRYYRR". b-text of the-b is "RYRYYRR".


understand "bean" as the-b.

a drama armada is scenery. understand "crowds" as drama armada. description of drama armada is "They're all milling around, waiting on you to say the right thing and make it snappy, and staring at the enormous bean. You'd like to push it out of the way."

check pushing the-b:
	say "The drama armada joins in to push the bean, but unfortunately, they wind up pushing it from all sides and complaining it's too heavy. You need to give an order."

Include (-
	has transparent animate
-) when defining drama armada.

check going when huge thing is visible:
	say "That huge thing is distracting you. Maybe you can deal with it now." instead;

check going when the-b is visible:
	if noun is down:
		say "Maybe there is something below, or something. But you can't prove it." instead;
	say "The drama armada won't let you go anywhere with the bean present." instead;

chapter beneathing

understand "beneath" as a mistake ("Nice try, but wrong preposition for the situation.") when runed book is visible or elbow is visible.

book Sun-Spared Underpass

Sun-Spared Underpass is an innie room in Routes.

after printing the locale description for Sun-Spared Underpass when Sun-Spared Underpass is unvisited:
	if worst ad is not in lalaland:
		poss-d;

description of Sun-Spared Underpass is "[if darkness is visible]This room was always unlit... but things don't always have to be in the past...[else]Now, you need to find No-Gal Logan. You need to find a good unroad...because roads and inroads will loop back.[end if]"

chapter untiling

the darkness is semi-easy scenery in Sun-Spared Underpass. "It is better to create light and move forward than cast about in the darkness."

a-text of darkness is "YRRYR". b-text of darkness is "GPRGR".

to say to-o:
	say "Brother Horbert talked about how if you had faith, and patience to see them right, they might lead you to an un-road or to No-Gal Logan if you knew how to study them."

the narrow cracks are scenery. "[to-o]"

a-text of narrow cracks is "YRYYRR". b-text of narrow cracks is "YRYYRP".

the un-road is scenery. "The un-road must lead to No-Gal Logan. But how to follow it?"

instead of doing something with un-road:
	if action is procedural:
		continue the action;
	say "It leads somewhere, you think. But how to follow it to No-Gal Logan?";

understand "trail" as un-road.

a-text of un-road is "YRYRR". b-text of un-road is "YRYRR". understand "unroad" as un-road.

the cracks you followed are useless scenery. "They led you here on the road--no, near the un-road to near No-Gal Logan."

understand "around" as a mistake("You can't see anything around, yet. It's too unlit, here.[preefsay of narrow cracks]") when darkness is visible and player is in Sun-Spared Underpass.

understand "along" as a mistake ("[if underpass is unvisited]You aren't far enough along to, err, look along[else]There must be some passages, but you can't see anywhere to go along, yet. You need to do more looking[end if].[paragraph break][preefsay of un-road]") when told-of-logan.

to decide whether told-of-logan:
	if mrlp is not routes, decide no;
	if huge thing form is off-stage, decide no;
	if un-road is in sun-spared underpass, decide no;
	decide yes;


book Ripe Pier

Ripe Pier is a room in Routes. "You see mist on this pier where a brighter rig berth should be. You don't know if you can go any farther without help. There's a sign before the mist. You wonder what you can yell to get on a ship, or find the right way to one."

understand "hips" as a mistake ("Unfortunately, nothing can become hoorays. So that doesn't help.") when player is in ripe pier.

understand "pish" as a mistake ("Pretending you don't want to get on the ship won't help you get on the ship.") when player is in ripe pier.

the pier sign is vanishing scenery in ripe pier. "You can't see much of the actual pier, but you can smell it. Thankfully, the pier sign offers some advice. 'Ripe pier! Boat rides ABROAD! Disclaimer: deal with DA MIST at your own risk.'[paragraph break]Hmm. There may be more than one way to get by."

da mist is vanishing scenery in ripe pier. "My, It's misty. It phases through shapes, but there's a sign in front of it."

a-text of da mist is "YRYRRR". b-text of da mist is "YRYRPP".
a-text of pier sign is "YRYYRR". b-text of pier sign is "GPYYRP".

instead of doing something to mist:
	if action is procedural:
		continue the action;
	if current action is taking:
		say "Mistake. Ha ha ha." instead;
	try examining noun instead;

No-Gal's Boat is scenery in Ripe Pier. "No-Gal's on it, waving you to come in."

instead of entering mist:
	say "Part of you admits it will be tricky to figure out. Maybe if you entered the right way, with a plan..."

after fliptoing mist:
	pad-rec-q "hit win button";
	continue the action;

after fliptoing pier sign:
	pad-rec-q "hit win button";
	continue the action;

before going inside in Ripe Pier:
	try entering mist instead;

understand "abroad" as a mistake ("Very close. But first, you must try getting on the ship.") when mist is visible.

book Cripple Clipper

Cripple Clipper is a room in routes. "You see a free reef ahead and to each side. You aren't much of a sailor, [if hit win button is visible]and the hit win button didn't even do everything[else]but maybe you can somehow hit win on the ship controls[end if]."

the ship controls are reflexive scenery in Cripple Clipper. "They're on-deck, but conked. [one of]I rag a rig, you note. [or][stopping]You've no clue how to [if ship controls are reflexive]find where Ben hid the Hit Win button[else]operate them[end if]."

a-text of ship controls is "RYR??R". b-text of ship controls is "?G???P".

the hit win button is scenery. "Well, pushing it alone won't work. You'll need one last flourish."

instead of doing something to the hit win button:
	if action is procedural, continue the action;
	say "[if ship controls are reflexed]Just pushing it isn't going to solve your problems. Or, your final problem, here.[else]Where is it? You need to find it. Or where Ben hid it.[end if]"

the free reef is scenery in Cripple Clipper. the free reef is undesc.

instead of doing something with the free reef:
	if current action is scaning:
		say "You may want to pick a ref--Thor or the new beet. They're too far apart to scan both at once." instead;
	say "You can't do much but look from here. The one free reef has Thor, looking for a hug. The other has a new beet that seems to have been wet recently--it is still dripping. They are rather close together, and it will be a squeeze to get by, but you probably know what to do by now. You may want to concentrate on one reef, Thor or the beet."

Thor is reflexive semi-easy auxiliary scenery in Cripple Clipper. "He's looking for a hug. Arms opened wide. Grinning disturbingly."

instead of doing something to thor:
	if action is procedural, continue the action;
	say "You can't do much to him without getting near him, which would be inadvisable."

thor-hug is a truth state that varies.

check scaning thor:
	if thor-hug is true:
		now thor-hug is false;
	else:
		now thor-hug is true;
	say "Thor booms [if thor-hug is true]'Thor hug!'[else]'Hug Thor!'[end if] as you point the settler at him.";

a-text of thor is "RRRYYRR". b-text of thor is "[if thor-hug is false]RRRYYRR[else]PPRYYRR[end if]".

the new beet is reflexive super-easy auxiliary scenery in Cripple Clipper. "It's dripping something gross and purple, which lands in the water with a hiss. With your navigation skills, you'd probably get too close to it or Thor."

a-text of new beet is "RYRRYYR". b-text of new beet is "RGRRGGR".

instead of doing something to new beet:
	if action is procedural, continue the action;
	say "You can't do much to the beet without getting near it and getting drenched in acidic beet juice."

book Cleric Circle

[does the player mean doing something with mark:
	if the pronoun it is grubby dwelling:
		it is likely.

does the player mean doing something with restaurant marquee:
	if the pronoun it is garish restaurant:
		it is likely.

does the player mean doing something with church sign:
	if the pronoun it is church that dislikes sin:
		it is likely.]

does the player mean scaning dingy dwelling: it is likely.
does the player mean scaning grubby restaurant: it is likely.

Cleric Circle is an innie room in Routes. "Things seem less confused here than outside. It's quieter, too--no organs['] groans, but chants you can't stanch: a steady Latiny litany, no skyier kyries[if list o toils is visible]. You see a list-o-toils on the wall[end if]. Of course, there are Spew Pews, a common legacy from Elvira's suggestions to make religion more exciting and practical, along with a picture of the previous, viperous pious rev.".

the spew pews are amusing plural-named scenery in cleric circle. "You rifle absentmindedly through the pews som more, but nothing turns up."

check closing summary:
	say "You fold up the summary and start at page 1.";
	now summary-page is 1;
	try examining summary instead;

check opening summary:
	try closing summary instead;
	
Mum Ray's Summary is a thing. description of Mum Ray's Summary is "[part-of-summary]";

to say part-of-summary:
	choose row summary-page in the table of summary text;
	say "[sum-page entry]";
	increment summary-page;

summary-page is a number that varies. summary-page is usually 1.

check searching pews:
	try examining pews instead;

check looking under pews:
	try examining pews instead;

check entering pews:
	say "A voice seems to intone: '[']Tis no sin to sit on, is...? NOT!'" instead;

check touching pews:
	try examining pews instead;

check examining the pews when summary is off-stage:
	say "You search through the pews, just as when you were a kid, looking for anything, maybe a note from the last person. You found something from yourself, once. But this time, something actually turns up! It's been hidden carefully, tucked where two woody bits are glued together.[paragraph break]An initial glance reveals nothing about Mum Ray's identity. Is it a woman with a last name of Ray? A silent fellow named Ray who preferred to write? Or just a pen name? They probably needed the anonymity, with the power Rev. Ali had, and either way, there's a lot to read.";
	now player has the summary instead;

table of summary text
sum-page
"The story starts with Rev. Ali being violently opposed to Elvira. He dropped by the Same Mesa, and many people followed him. He was constantly yelling how she was too exciting, and the way to fightt back was not to get swept up in her newness be happy enough, you guess."
"People listened to him, and his austerity helped prevent hearing about Elvira's latest charm offensive. But he got more and more severe, restricting where people could go, and even directions how to get there. If people knew where they wanted to go, and it was really important, they'd get there."
"Then Elvira dropped by. Rev. Ali took the time to admit he was wrong! In doing so, he informed the residents of the Same Mesa that they would do well to follow his lead. Terrified, they accepted. Elvira's excitement had matured, and he didn't realize how good she was at pointing out people's faults. It would help to improve them."
"Rev. Ali left, but with one final 'character-building' challenge. The roads out of the Same Mesa would lead nowhere until someone found a new clever way out beyond them. And if nobody found the way out--well, there were some wise guys who were all about thinking for yourself. Maybe they were not as good at it as they claimed to be."
"It was rumored Rev. Ali moved on to a new community to 'help.' His legacy remains, though. People are not willing even to visit Pat's and Oscar's. Why should they? The Same Mesa is a mix of countermanding and warnings about what you can't do, and how you can't even get the basics right, like cardinal directions. Someone needs to break through, somehow."

after examining summary (this is the notify last summary page rule) :
	if summary-page is number of rows in table of summary text:
		say "Whew. That was the last page.";
		now summary-page is 1;
	else:
		say "Push P to read the next page (you're at [summary-page] of [number of rows in table of summary text]).";
		let cho be the chosen letter;
		if cho is 80 or cho is 112:
			try examining the summary;
			the rule succeeds;
		else:
			say "OK. You'll start at the next page, next time. You can OPEN or CLOSE the summary to start at the first page.";
			the rule succeeds;
	the rule succeeds;

after printing the locale description for Cleric Circle when Cleric Circle is unvisited:
	say "(press any key)[wfak][paragraph break]";
	say "Brother Horbert steps on something that flips up into the air and into your hands! He points at you. 'It...you...I was told...the spoon must be for you!'[paragraph break]He explains it is a snoop spoon, one that helps the right person--the one it chooses--to examine it for direction when needed. Apparently you have to tilt it right so all the rays or whatever get focused at the focal point, but you can figure that out as you go.";
	now player has snoop spoon;

the snoop spoon is a thing. description is "The spoon looks pretty normal despite the powers Brother Horbert claims it has."

understand "noops" as a mistake ("The snoop spoon isn't as complicated as assembly language.") when player has snoop spoon.

check examining snoop spoon:
	if scams is false:
		say "Examine the spoon at just the right angle, for a hint?";
		unless the player consents:
			continue the action;
	now spoilit is true;
	try routes-hinting;
	now spoilit is false;
	the rule succeeds;

instead of exiting in Cleric Circle:
	if toils is unexamined or pews are unexamined:
		say "You look back at the [if toils is examined]pews[else if pews are examined]list-o-toils[else]pews and list-o-toils[end if]. Perhaps closer inspection might give you [if toils is examined]the 'why'[else if pews are examined]the 'what'[else]the 'what' and 'why'[end if] for dealing with the directionless Same Mesa.[paragraph break][randbla]";
	now player is in Same Mesa instead;

check going in Cleric Circle:
	if noun is not outside:
		say "[one of]'Directions are not important here, my son. They are arbitrary, but eternal truth is eternal. Just EXIT, if you want to.' So you do.[or]'One day, my son, you will learn to put aside your need for compass directions.'[stopping][line break]You go back outside.";
	move player to Same Mesa instead;

Brother Horbert is a person in Cleric Circle. description is "Slightly anxious, and in the usual black clerical garb.". "[one of]You see a man muttering, 'Only hope? Holy peon!' He turns and blinks. 'Greetings! I am Brother Horbert. Father Hafter and Veteran Rev. Nate are not here to help with the colossal local SOS.'[paragraph break]'Some people call me the Oopsin['] Priest because...oops!'[or]Brother Horbert, the oopsin['] priest, paces about here.[stopping]"

understand "oopsin priest" and "oopsin/priest" as Brother Horbert

to say pious1:
	if pious-state is false:
		now pious-state is true;
	else:
		now pious-state is false;

pious-state is a truth state that varies.

the picture of the previous viperous pious rev is useless scenery in Cleric Circle. "[one of]It's a picture of Rev. Ali, whose distincter interdicts left the Mesa in the lurch, looking even harsher than[or]Rev. Ali's still outdoing[stopping] [pious1][randbla][one of], full of tarnished sin-hatred and obliged god-bile for your sinner inners[or][stopping]. [one of]Their creeds-screed contains[or]Another no-heart rant, e-oh:[stopping] [pious1][randbla]"

understand "ali" and "rev ali" as pious rev.

check examining pious rev for the first time:
	say "Just a small check-off: there's some religious stuff in here, poking fun at hot button issues. This might be annoying, and I don't want do do that. Do you wish to go ahead?";
	unless the player consents:
		say "Okay. This warning will vanish next time." instead;
	say "Man! This guy is a grouch. You have morals and all, but geez."

check asking Brother Horbert about:
	say "Brother Horbert shrugs. He doesn't know much about the outside world.";

does the player mean doing something with the list o toils:
	if player is in cleric circle:
		it is likely;
	it is unlikely.

the list o toils is scenery in Cleric Circle. "[list-o-toils-text]"

understand "recipe" as list o toils.

read-list is a truth state that varies.

to say list-o-toils-text:
	let missing-one be false;
	say "Precise recipes # 2: Mix of reagents greatens. Fix mo['].[no line break]";
	repeat with QQ running through quest-items:
		say "[line break]";
		if QQ is enclosed by the player:
			say "(Y) ";
		otherwise:
			now missing-one is true;
			say "(N) ";
		say "[QQ]";
	if read-list is false and missing-one is true and Brother Horbert is visible:
		say "[line break]";
		pad-rec "reagents";
		say "[paragraph break]Brother Horbert mumbles something about how if they had any reagents left around here, they'd have used them, but they don't.[no line break]";
		now read-list is true;

understand "opposite" as a mistake ("Hm. The list doesn't seem to be what you need to stand opposite from. It doesn't seem offensive enough") when list o toils is visible.

a quest-item is a kind of thing.

after printing the name of a quest-item while taking inventory:
	if read-list is true:
		say " (for Brother Horbert)";

the specification of quest-item is "One of three items needed for Brother Horbert's potion."

check objasking brother horbert about a quest-item:
	if player has second noun:
		try giving second noun to brother horbert instead;
	else:
		say "'Found it? ... Find out! Do it! Fun!' Brother Horbert looks slightly guilty at his impatience and vagary, afterwards[one of]. But the mesa doesn't seem too big--what you need can't be far off[or][stopping]." instead;

some mushrooms are a quest-item. description of mushrooms is "They have all different lengths of stems, and you're not sure which are poisonous and which aren't."

understand "mushroom" as mushrooms.

instead of eating mushrooms:
	say "One of them is probably poisonous, and not even I can tell[if list o toils is examined]. Plus, Brother Horbert needs them[end if]."

check dropping something:
	if player is in treasure and hoop is in treasure:
		say "You aren't in the right state of mind to drop all your possessions, even for a half a move. Doing so might let you jump and grab the hoop, but you need to say, the heck with it. Or something." instead;
	if noun is a fruit:
		say "Best return the fruit to Curtis, instead." instead;
	If mrlp is roman manor:
		say "You probably need to abscond with everything useful you can get your hands on." instead;
	say "Hero[if player is female]in[end if]es shouldn't be litterbugs[if player has purse]! Your super purse should hold whatever.[else]![end if]" instead;

the runed book is an uncluing quest-item. description of runed book is "The runes on the cover are beyond you. What's inside is probably even more esoteric. You hope [pri-who] knows what to do with it.". "A runed book is high above you, stuck to the ceiling."

does the player mean doing something with runed book when runed book is visible: it is likely.

book Adobe Abode

Adobe Abode is an innie room in Routes. "A dilapidated residence with a trashy ashtray[if pipe soot is in abode], which could use some emptying[end if]. The only exit is out to the Mesa.";

understand "orcas" as a mistake ("But the whales would drown. [if list o toils is unexamined]Oscar doesn't seem to need change[else if pipe soot is in abode]Besides, it's the pipe soot you want[else]Besides, you got the pipe soot[end if].") when player is in adobe abode.

after choosing notable locale objects when player is in adobe abode:
	set the locale priority of pipe soot to 0;

Oscar is a person in Adobe Abode. description is "He gives a weary hi. 'Haywire.'". "[one of]Someone who must be [or][stopping]Oscar mopes around here, probably not willing to talk about more than himself."

a trashy ashtray is scenery in adobe abode. "[if pipe soot is in abode]The ashtray is full of pipe soot, but at least, no Pepsi too[else]You emptied the ashtray[end if]."

understand "ash/tray" and "ashtray" as ashtray.

check scaning ashtray:
	if player does not have pipe soot:
		say "Only the pipe soot does anything to the settler, so you focus on that.";
		try scaning pipe soot instead;

instead of doing something with ashtray:
	if action is procedural:
		continue the action;
	say "You can't do much with the ashtray besides be all 'Artsy, ha!' or 'Ay, trash.'";

oscar-annoy is a truth state that varies. oscar-annoy is usually false.

check exiting in Adobe Abode:
	try going outside instead;

check going outside in adobe abode:
	say "You leave the adobe/abode.";
	now player is in Same Mesa instead;

check going outside in Adobe Abode:
	try exiting instead;

check entering dingy dwelling:
	if old giant is in mesa:
		try acrossing instead;
	if Adobe Abode is unvisited:
		now oscar-annoy is true;
		say "You try going directly to Oscar's, but the place curves away from you." instead;
	otherwise:
		if oscar-annoy is true:
			say "No more funny business from Oscar's. You walk in without having to pretend to walk away.";
			now oscar-annoy is false;
		now player is in Adobe Abode;
	the rule succeeds;

some pipe soot is a reflexive quest-item in Adobe Abode.

instead of dropping a quest-item: say "You need to keep it--it's a reagent for Brother Horbert."

check taking the pipe soot when soot is in adobe:
	say "Oscar snaps at you. 'Hey! Whoa! No stealing! Even worthless stuff!'[paragraph break]Maybe if you could position yourself so he can't see you taking it." instead;

a-text of pipe soot is "YRRYRYRY". b-text of pipe soot is "YRPYPYRY".

the description of pipe soot is "If you picked it apart, which you don't need to, there might be evidence it was once tobacco. It actually smells more like some fruit you can't, and won't, recognize."

instead of eating pipe soot:
	say "Well, it doesn't SMELL that bad, but...umm, no."

to say pri-who:
	if list o toils is examined:
		say "Brother Horbert";
	else:
		say "someone";

instead of giving something to Brother Horbert:
	if noun is a quest-item:
		say "You should maybe wait to give Brother Horbert all the reagents first. He would probably forget where he put the [noun]."

instead of doing something to the runed book:
	if action is procedural:
		continue the action;
	say "Best not try anything fancy. You probably want to get that book back to [if list o toils is examined]Brother Horbert[else]someone who can use it properly[end if].";

understand "under" as a mistake ("Wrong preposition.") when the-b is visible

chapter acrossing

acrossing is an action applying to nothing.

understand the command "across" as something new.

understand "across" as acrossing.

to say listen-cue:
	say "Walking away would upset the giant. I mean, into doing something, not just talking. And he is bigger than you. Maybe listening will help";

carry out acrossing:
	if player is not in Same Mesa:
		say "[reject]" instead;
	if huge thing is in mesa:
		say "That huge thing is distracting you. Maybe you can deal with it now." instead;
	if drama armada is in mesa or the-b is in mesa:
		say "[but-armada]" instead;
	if old giant is visible:
		say "[listen-cue]." instead;
	if Adobe Abode is unvisited:
		say "You walk across, not worrying about what is in front of you. Oscar's appears in front of you. You walk in.";
		reg-inc;
	otherwise:
		say "Yeah, ACROSS is fewer keystrokes than ENTER OSCAR'S, so hey...";
	now player is in Adobe Abode instead;

chapter pasting

to say but-armada:
	say "But... [if the-b is in mesa]THE BEAN[else]the huge thing[end if]! What to do with it[if armada is in mesa]? The armada mumbles nervously.[else]?[end if]"

pasting is an action applying to nothing.

understand the command "past" as something new.

understand "past" as pasting.

carry out pasting:
	if player is not in Same Mesa:
		say "[reject]" instead;
	if huge thing is in mesa:
		say "That huge thing is distracting you. Maybe you can deal with it now." instead;
	if drama armada is in mesa or the-b is in mesa:
		say "[but-armada]" instead;
	if old giant is visible:
		say "Walking away would upset the giant. I mean, into doing something, not just talking. And he is bigger than you." instead;
	if Idle Deli is unvisited:
		say "You decide to walk past Pat's. Then, you turn and enter the alley just past it. The building lurches sideways toward you, and you manage to jump through the doorway with only a minor bump as it slams into you. You hear taps spat as you enter.";
		reg-inc;
	otherwise:
		say "You try the walking into the alley trick again, but the building stays still. You're a bit disappointed you can just walk in like that.";
	now player is in Idle Deli;
	the rule succeeds;

book Idle Deli

Idle Deli is an innie room in Routes. "This restaurant has no customers, and that's no surprise, what with the seed pit in the back ruining the ambiance--not even pie crust pictures by Stu Price. It's seedy, even without the warning sign, but at least ants be absent. You can go out back to the mesa."

Pat is a person in Idle Deli. description is "He looks beaten down from the lack of business.". "[one of]'Lint? Use utensil. Fix store for exits...' mumbles some poor soul. 'Oh! A customer!'[or]Pat is still plodding here.[stopping]"

understand "tap pat" and "tap" as a mistake ("You have Pat's attention, already[if seed pit is reflexive], and he's not letting you in that seed pit without argument[end if].") when player is in idle deli.

understand "pat pat" and "pat" as a mistake ("Pat doesn't need consolation for his lost business.") when player is in idle deli.

understand "pta" as a mistake ("You don't need to attend any school board meetings.") when player is in idle deli.

understand "atp" as a mistake ("No need for biochemistry, here.") when player is in idle deli.

understand "apt" as a mistake ("Actually, Pat's advice may not be apt[if seed pit is reflexive]. Look to the seed pit[end if].") when player is in idle deli.

The warning sign is auxiliary semi-easy scenery in Idle Deli. "'Every time someone enters, PETS DIE.'"

a-text of warning sign is "RYRRYRY". b-text of warning sign is "RGRRYRG".

check exiting in Idle Deli:
	say "You leave Pat's idle deli.";
	now player is in Same Mesa instead;

check going outside in Idle Deli:
	try exiting instead;

check entering grubby restaurant:
	if Idle Deli is unvisited:
		say "You try to do so, but the building shifts further away." instead;
	if old giant is in same mesa:
		try pasting instead;
	say "You walk back into Pat's idle deli more confidently the second time. The building does not shift.";
	now player is in Idle Deli instead;

the seed pit is reflexive scenery in Idle Deli. "[if mushrooms are off-stage]It's ugly and moldy but you find yourself thinking, if I had just one reason to go in there, against any warnings...[otherwise]You got through okay once, but you don't want to know what might sit deep in there.[end if]"

understand "seedpit" as seed pit.

a-text of seed pit is "RYRRYRY". b-text of seed pit is "RGRRYRY".

instead of entering seed pit:
	say "[if mushrooms are off-stage]Pat holds you back, warning 'best SPEED IT away from there!' You see red at the odd-sounding admonition.[otherwise]You already got something from there.[end if]"

the can't eat unless edible rule is not listed in any rulebook.

check eating:
	if noun is a hintpastry:
		say "You'll want to put the pastry in the toaster[if toaster is in Danger Garden]back in the garden[end if], first, or it'll just be calories." instead;
	say "That's not in a test-taste state." instead;

Procedural rule while eating something: ignore the carrying requirements rule.

volume troves

the block singing rule is not listed in any rulebook.

i-sung is a truth state that varies.

lyre-dest is a truth state that varies.

to silly-min:
	increment silly-acts;
	if silly-acts < 3:
		min-up;

check singing:
	if player is in hops shop:
		d "[silly-acts] acts so far.";
		if i-sung is false:
			if silly-acts is 3:
				check-silly-death;
				the rule succeeds;
			now i-sung is true;
			now gins sign is reflexed;
			say "Your singing is abominable. But not as abominable as the lyrics or the 'melody' played in the bar right now. So customers only glare at you, but others order another beer because they're not as drunk as you, clearly.";
			remove gins sign from marcitems;
			reg-inc;
			silly-min;
		else:
			say "Your testing other patrons['] patience would be abominable.";
		continue the action;
	if player is in peek keep:
		say "No, this is a quieter place than the Posh Hops Shop." instead;
	if Ed Riley is visible:
		if lyre-dest is false:
			now lyre-dest is true;
			say "Unexpectedly, Ed pulls out a lyre from somewhere and yells 'LYRE! DIE!' like he's in some medieval heavy metal band or something. He's really seeing red as he stomps it to dust." instead;
		say "You don't want to push your luck. His yelling LYRE DIE and seeing red kind of weirded you out." instead;
	if warning sign is visible:
		say "Wrong area for that." instead;
	if clam is visible:
		say "If you could sing, it might settle the clam down. But you can't, so it doesn't." instead;
	if deacons are visible:
		say "That won't make them any less hostile." instead;
	if gins sign is visible:
		if cheat-on is true and gins sign is escanned:
			say "Knowing what you know, singing shouldn't work. You sing a song of frustration when you realize you'd need to GISN with what the settler says, here." instead;
		say "You sing the nicest song you remember about goodness and virtue. After sickening yourself into the bargain with no transport arriving, you notice the sign may've been vandalized, and plus sing/sign was a bit too easy." instead;
	if location of player is FiefCo Office:
		say "You can't quite mimic the singer, but maybe you could tweak his singer-ness. You can't move to artists['] straits with your job. You're more suing than 'I sung' now." instead;
	if mrlp is troves:
		say "No hippy trippy blues song about being poor here, if you please. And you will--you're not in power, yet." instead;
	if player is in campsite:
		say "[one of]'Oh sappy! So happy!' The birds go chürp chürp chëëp chëëp[or]Best not encourage cheeps-speech. The dirt itself might burst into song[stopping]!" instead;
	if player is in same mesa:
		say "You look at the church sign for a clue what to sing, and it says [dssd]. Hmm. You don't know any songs like that." instead;
	if player is in cleric circle:
		say "You don't know any appropriate songs, here." instead;
	say "[randbla][line break]" instead;


check waiting:
	if mrlp is troves:
		if player is in boredom bedroom:
			say "Solo detail? Isolated? No. Desolation." instead;
		if cur-score of troves is 0:
			say "That's the wrong sort of inaction for here[one of]. Better watch it, or snotbag nagbots or a boot-o-bot will get you[or][stopping]." instead;
		say "You are paralyzed by the hustle and bustle of the big city. Though how much is bustle or hustle, I really couldn't say." instead;
	if carps are visible:
		try listening instead;
	say "[randbla][line break]" instead;

book Loather Rathole

before going up in troves:
	say "Moving on up needs to be a state of mind here." instead;

before going down in troves:
	say "It is important to be down to earth as you work your way to the top, yes." instead;

Pa Egg Pea is a super-easy proper-named reflexive LLPish thing. printed name of Pa Egg Pea is "Pa, Egg, Pea"

description of Pa Egg Pea is "[randbla]".

a-text of Pa Egg Pea is "RYRY". b-text of Pa Egg Pea is "??R?".

understand "book" as Pa Egg Pea.

instead of opening Pa Egg Pea:
	say "(to read it, I assume)[line break]";
	try reading Pa Egg Pea instead;

check examining Pa Egg Pea for the first time:
	say "[i]Pa, Egg, Pea[r], of course, recently topped [i][twiddle of table of self-help bestsellers and 1][r] and [i][twiddle of table of self-help bestsellers and 1][r] as the best-selling self-help book all-time in Yorpwald, at least until its promised sequels in the Tryin[']-it Trinity, [i]The MORE Theorem[r] and [i]No Guts? Go Nuts[r], appear. It combines overused success-story fables with spectacularly improbably leaps of logic to 'prove' both thinking your way to success and doing your way to success are more important than the other, and anybody who finds these to be a contradiction is just intellectually lazy.[paragraph break]The introduction explains YOU AND ONLY YOU must think up the way out of a tough situation.[paragraph break]A rudimentary flip through shows that it's full of aphorisms and heavily invested in sustaining the personality cult of its author, Peg A. Page. You remember a suppressed review that went 'Ee! Gag! Pap!' and aren't sure of the best way to read it, if any. Though it's probably symptomatic of the times, you doubt it can help you with your specific situation[if cur-score of troves is 0], but it may help you get started[else], especially now you're started a bit[end if]." instead;

check looking in Loather Rathole for the first time:
	now the player has Pa Egg Pea.

check going nowhere (this is the troves general direction reject rule):
	if mrlp is troves:
		say "Nothing urgent that way. Once you figure out what you need to do, you'll figure if you need to go anywhere. Focus, focus, focus." instead;

Loather Rathole is a room in Troves. last-loc of troves is Loather Rathole.

every turn when player is in Loather Rathole (this is the Loather Rathole complaints rule) :
	say "[if heat is in Loather Rathole]You need your super purse back. But you try and fail to get stoked enough to be a race-acer![else]'Heat...' you think. Then you see red and muse [one of]'[one of]At... eh...[no line break][or]Eh... at...[no line break][in random order]' as you are not sure where you are.[or]'A...the...' your thoughts degenerate.[or]'The...a...' your thoughts degenerate, as your eyes redden.[in random order][end if]";

the Loather Rathole complaints rule is listed after the process random dialogue rule in the every turn rules.

after printing the locale description for Loather Rathole when Loather Rathole is unvisited:
	say "Skid Row, Wordski.";
	continue the action;

the fretful truffle is a thing. description is "It's probably a character building experience to eat it. You may learn something about how to think or what to do."

truf-warn is a truth state that varies.

check eating fretful truffle:
	if truf-warn is false and scams is false:
		now truf-warn is true;
		ital-say "this chocolate is a cool cheat that tells you what to [if cur-score of troves is 0]type[else]think next[end if]. Are you sure you want to do this?";
		unless the player consents:
			say "Okay. This warning won't appear again." instead;
	now spoilit is true;
	try troves-hinting;
	now spoilit is false instead;

spoilit is a truth state that varies. spoilit is false.

description of Loather Rathole is "Under the stinky tin sky, [if heat is visible]you feel the heat out on the street, but more importantly, you're feeling the loss of your super purse. You just aren't motivated to [i]race[r] after the robber and get that money back, though[otherwise]you feel nothing but bone-chilling poverty here. [i]Heat[r]. It's what you need. All you can think of[end if]. Of course, there are plenty of potholes about."

the potholes are useless plural-named scenery in Loather Rathole.

instead of doing something with the potholes:
	say "The potholes symbolize lost hope. You don't need that sort of thinking right now!"

potholes are undesc.

understand "a rec" as a mistake ("You've done nothing to deserve a rec yet. You need to think for yourself. Maybe you can become someone who give a rec, one day.") when player is in rathole and heat is in rathole.

book Used Lot

Loudest Used Lot is a room in Troves.

Used Lot is in Troves. "A hopeless passe hole close to the Boorboro and Grubburg suburbs. Someone seedy owns this area, [randbla]. This messhole with its sidewalk laid askew is almost as bad as being homeless...[paragraph break][if babblings are visible]Except for a stop post that seems to be distracting your attention. Verbose babblings are in the air[else]The stop post is still there, but you can deal[end if]. [if stop post is reflexive]You'll need to look around to find what to do[else]You [one of]can't see the entrance to the cellar anywhere. Perhaps you'll have to use your mind a bit[or]still can't make out the cellar entrance, yet--perhaps you could try to look back on the cellar or listen for clues[stopping][end if]."

a sidewalk laid askew is useless scenery in Used Lot. "You don't really have time to memorize the sidewalk's cracks."

instead of doing something with a sidewalk laid askew:
	if action is procedural:
		continue the action;
	say "You may want to pay attention to something more positive and alive.";

the rustin ruts are useless scenery in Used Lot. printed name of ruts is "rustin['] ruts". understand "rustin ruin" and "rustin/ruin" as ruts. "If you stare too long, you may get in a rut yourself."

instead of doing something with rustin ruts:
	if action is procedural:
		continue the action;
	say "You may want to pay attention to something more positive and alive.";

understand "obverse" as a mistake ("You can't just make things obverse by wanting them to be. [i]But if change comes within, perhaps things are closer to obverse than you think[r].") when babblings are visible.

understand "redive" as a mistake ("Close, but you need to figure out where to re-dive back into the cellar.") when player is in Used Lot and babblings are in lalaland

bab-lis is a truth state that varies.

the verbose babblings are vanishing scenery in Used Lot. "[listen-careful]."

a-text of verbose is "YRRYRRY". b-text of verbose is "YRRYRRG".

to say listen-careful:
	if bab-lis is true:
		say "You don't really want to see Eve's Bro or Bo Evers. The thought makes you see red. You feel you should pay attention to more important, big-picture things";
	else:
		say "The voices by the sidewalk don't seem to be about anything that could help. [i]Unless they are, and you might feel silly these people knew more than you did without knowing. [r]Listen more carefully?";
		if the player consents:
			say "'Aw man! We're going to see [erv] The people running by are all wearing red--with some yellow thrown in. Tacky";
			now bab-lis is true;
		else:
			say "Ok";

to say erv:
	say "[one of]Eve's Bro serve Bo! Bo Evers!'[or]Erv be so...'[cycling]";

check examining stop post when babblings are in Used Lot:
	say "You try to, but you get a headache. Everyone here's too [i]verbose. [r]You need to find what to do make them less verbose. Or seem that way." instead;

The stop post is reflexive super-easy scenery in Used Lot. "[if babblings are reflexive]You're so distracted by it, you can't stop and see the big picture. It blocks out all but the babblings round--it's really big and verbose and you could look at it a while without seeing anything meaningful. You can't even remember what you just read. As if you'd lost the ability to.[else if post is reflexive]Its opts. aren't exactly tops. Apparently, though, it is made of recycled pots.[else if bee's head is reflexive]You notice an ad in red proclaiming O. Asner as Nero.[else]An ad in red for L. Clear cleaning[one of], with directions below to [one of]Evans Ave N/S[or]Weave Ave E/W[in random order][or][stopping].[end if]"

check scaning stop post:
	if babblings are visible:
		try scaning babblings instead;

check fliptoing stop post:
	if babblings are visible:
		say "That should work, but you--your eyes are wandering now. You're not taking it all in. The post--and some voices you hear--are too verbose.";
		preef stop post;
		do nothing instead;

understand "observe" as a mistake ("You already did all the general observing you needed.") when player is in Used Lot and babblings are not in Used Lot.

a-text of stop post is "RRYR". b-text of stop post is "?R??". [show example]

every turn when player is in Used Lot:
	if what-a-bee is not reflexive or bee's head is not reflexive:
		if current action is not listening:
			say "How to get down to the cellar? The cellar.";

the what-a-bee is a reflexive privately-named thing. printed name of what-a-bee is "[if bee's head is reflexive and what-a-bee is reflexive]evil bee[else if bee's head is reflexed and what-a-bee is reflexed]live bee[otherwise]vile bee[end if]"

check taking what-a-bee:
	say "I'll be stingy. Better than the bee, eh?" instead;

Include (-
	has transparent animate
-) when defining what-a-bee.

description of what-a-bee is "[if bee's head is reflexed and what-a-bee is reflexed]It looks utterly defeated, but at least it didn't die[otherwise if bee's head is reflexive and what-a-bee is reflexive]It seems to know you want to go down to the cellar. Bees can smell that, especially an EVIL BEE[one of]. One thing's for sure, no free beers while this bee's freer[or][stopping][otherwise]It's buzzing a bit, but it's not moving around so fast. You're not threatened by it any more. You could probably sneak past it[end if][if bee's head is reflexive]. Bizarrely, it has NO EARS. And it's a bit red where the ears should be[end if][if bee's head is reflexive or what-a-bee is reflexive]. It seems pretty [vile-evil][end if]."

to say vile-evil:
	if bee's head is reflexive and what-a-bee is reflexive:
		say "evil";
	else if bee's head is reflexed and what-a-bee is reflexed:
		say "live";
	else:
		say "vile";

understand "evil/ bee" as what-a-bee when bee's head is reflexive and what-a-bee is reflexive.
understand "vile/ bee" as what-a-bee when bee's head is reflexive and what-a-bee is reflexed.
understand "vile/ bee" as what-a-bee when bee's head is reflexed and what-a-bee is reflexive.
understand "live/ bee" as what-a-bee when bee's head is reflexed and what-a-bee is reflexed.

a-text of what-a-bee is "RYRYYRY". b-text of what-a-bee is "[if bee's head is reflexed]RYPYYRG[else]RYRYYRG[end if]".

a-text of bee's head is "RYYRYR". b-text of bee's head is "RYYRYR".

check scaning what-a-bee:
	if what-a-bee is reflexive and bee's head is reflexive:
		if a random chance of 1 in 2 succeeds:
			say "The bee pokes her head in so near and disrupts your settler's reading.";
			try scaning bee's head instead;
	if what-a-bee is reflexed and bee's head is reflexive:
		say "Nothing shows up until you get to the bee's head.";
		try scaning bee's head instead;
	if bee's head is reflexed and what-a-bee is reflexed:
		say "The bee rests, silent, and so does your settler." instead;

book Boredom Bedroom

Boredom Bedroom is a room in Troves. "Here [one of]in a dump, um, pad (it's no Bro-Dome, but at least it's been broomed,) a step up from Get-a-Cot Cottage, [or][stopping]is a picture of a sad pier, a box of diapers, and a spider crawling[if ltb is reflexed]. You are immune to such details, now. You have learned to despair and to deal, and now you need a third way between them. You believe you deserve to [i]reside[r] somewhere better[else if diapers are reflexed]. Such details will drag you back. You want to break out of the funless fulness of Drag-grad, here, to [i]lead[r][end if]. All equally depressing."

understand "praised" as a mistake ("You would like to be, but you can't just want others to. Change comes from within.") when player is in boredom bedroom.

understand "asipred" as a mistake ("Now is not the time to fret on past dreams.") when player is in boredom bedroom.

the picture of a sad pier is auxiliary semi-easy scenery in boredom bedroom. "It is a warding drawing of what not to wallow in: solitude so dilute in an old suite. According to [i]Pa, Egg, Pea[r], if it were not marked as such, it should be illegal."

a-text of sad pier is "RYRRYYR". b-text of sad pier is "RYRPYYP".

box of diapers is reflexive scenery in boredom bedroom. "The diapers are a symbol of a new rebirth by starting from nothing, or something. At least, you hope they are."

after fliptoing diapers:
	now ltb is in boredom bedroom;
	continue the action;

a-text of diapers is "RYRRYYR". b-text of diapers is "PYRPYYR".

a spider is scenery in boredom bedroom. "You're don't know whether to crush it or even think 'I spared a spider.'"

a-text of a spider is "RYRRYYR". b-text of a spider is "RYRRYYP".

understand "broomed" as a mistake ("You are not rich and consequential enough to order people to clean up after you, yet.") when player is in boredom bedroom.

book Dour Tan Rotunda

Dour Tan Rotunda is an innie room in Troves. "This could also be a rotund rotunda, but obesity is not very posh. Nobody is quite happy here. It's posh enough, but designed specifically to make people want even more. There's not much to do except stare at a brochure just lying around. But oh, what a brochure!".

a brochure is vanishing scenery in Dour Tan Rotunda. "[one of]'Got here? No debt to bend? Go there!'[paragraph break][or][stopping][randbla]"

a-text of brochure is "RYRYRY". b-text of brochure is "R???RG".

instead of taking brochure:
	say "No. What would the next person here read?"

book Econ Cone

Econ Cone is a room in Troves. printed name of econ cone is "Econ-Cone". "You've reached the recent center of the econ-cone, thus called because the perky crass skyscraper in the center forms the top of the skyline, which is itself a cone. [one of]Once here, t[or]T[stopping]he bluster from your average bustler is subtler here. Less rusty din, more industry (it's un-dry. Sturdyin['].)[paragraph break]You have lost all sense of direction, mainly because that statue nearby looks so important! [if rivets is reflexive and prai is reflexive]Maybe it will help you motivate yourself even more[else if rivets is reflexive or prai is reflexive]Now you're super-motivated, maybe you need to have the right sort of think[else]That statue taught you all it could, so maybe you can move on--or in--to the skyscraper[end if]."

the skyline is scenery in Econ Cone. understand "cone" as skyline when player is in Econ Cone. the skyline is undesc.

instead of doing something with the skyline:
	say "The most interesting part of the skyline is the perky crass skyscraper! You feel pulled to it. The rest is...well, okay for other people, but not you.";

understand "once" as a mistake ("Yes! You only need a chance! Once! To get inside! [if rivets is reflexive and prai is reflexive]You are almost enthused enough[else]You're enthused enough, but you need to strategize[end if].") when player is in Econ Cone.

understand "persia" as a mistake ("You redden at the thought of mystical lands that aren't relevant to the here and now.") when player is in Econ Cone.

check going inside in Econ Cone:
	say "You can't just walk in[if statue is reflexed or rivets are reflexed] even with your desire at its level[end if]! You need the right sort of thinking." instead;
	try going west instead;

after fliptoing prai:
	continue the action;

after fliptoing rivets:
	continue the action;

after fliptoing when location of player is Econ Cone (this is the hello Pernod rule):
	if noun is prai or noun is rivets:
		if pernod is off-stage:
			say "Your concentration is broken by shattering glass! When you turn around, you notice the person who originally gave you the Peg A. Page book. He has been escorted out by security. They hand him a bottle. There's an argument, he smashes the bottle, and he runs away. Perhaps this is your chance, to take his place now that he has burned out!";
			now pernod is in Econ Cone;
	continue the action;

the bottle of Pernod is a semi-easy vanishing thing. "A broken bottle of [if label is in lalaland]N-E-Prod[else]Pernod[end if] champagne lies here. There's a card that seems glued to it, with some writing on it."

after fliptoing pernod:
	if rivets are reflexive or prai is reflexive:
		decrement poss-score of troves;
	continue the action;

description of bottle of pernod is "It says [if label is in lalaland]N-E-Prod below where the label was[else]PERNOD on the label, which looks a bit loose[end if]. There's also a card you could read."

understand "champagne" as Pernod.

understand "prod/neprod/n-e-prod" and "bottle of prod/neprod/n-e-prod" as Pernod.

check taking the card:
	say "It's glued to the Pernod." instead;

a-text of card is "RYRRYR". b-text of card is "[if label is part of pernod]P[else]R[end if]YRRYR".
	
the label is part of the bottle of pernod. description of label is "It says PERNOD."

check taking the label:
	say "The label comes off to reveal a much less hoity-toity label: the generic N-E-PROD is the [i]REAL[r] manufacturer! It's in red letters, too.";
	now label is in lalaland instead;
	
check examining the label:
	say "It looks like you could TAKE it off! You wonder if this bottle is a fake. It says PERNOD, but there's also a card tied to the bottle." instead;
	
instead of scaning the label:
	try scaning the pernod instead;
	
a-text of pernod is "RYRRYR". b-text of pernod is "[if label is part of pernod]P[else]R[end if]YRRYR".

the card is part of the bottle of Pernod. description of card is "It's got red writing on it that you could read."

check reading pernod:
	try reading card instead;

check taking bottle of Pernod:
	say "The jagged glass would cut your hands, or your super purse's space-capes." instead;

instead of entering skyscraper:
	say "You try to go enter, but your brute force approach attracts nobody. You are filled with desire to move up in the world, but perhaps not the thoughtfulness, yet.";

the perky crass skyscraper is reflexive scenery in Econ Cone. "It's built by [trev] and is emblazoned with his twin motto, PROPERTY IS PROSPERITY and ADVERTS-STARVED? READ TVS. It doesn't let up on opulent. You remember reading a scientific study that just wanting to work there five minutes a day increases productivity by 25%."

check scaning skyscraper:
	if pernod is off-stage:
		say "The skyscraper shows nothing. Which is sort of a relief, though it probably means you haven't found what you need to focus on.[paragraph break]Anyway, you'd hate to spend all that time however many possibilities 'skyscraper' would give. You dream of hiring some mathy dweeb to figure that out stuff like that (it's 725760. Uh, some guy told me, then I took his lunch money.)[paragraph break]" instead;
	else:
		say "Your settler seems to give the same reading for the Pernod as for the skyscraper.";
		try scaning pernod instead;

to say trev:
	say "Trevis Vister[one of], Ph.D in Life Success[or][stopping]";

The astute statue is uncluing scenery in Econ Cone. "[one of]It is, of course, of [trev]. It's thirty feet tall and a decent likeness, except it's a shocking red, so nobody can miss it, and he has a full head of hair instead of that ridiculous comb-over. Also, his arm is around air, because when this statue was initially commissioned, his third wife demanded to be part of it. She was removed when he remarried, replaced by his fourth wife, who divorced him when she was portrayed as shorter than he was.[or][trev] is unchanged, himself, just waiting for you to want to be like him.[stopping][paragraph break]Rivets lie at the bottom of the statue in some sort of pattern. [one of]. It is not a statue of limitations, for sure[or][stopping]."

Include (-
	has transparent talkable
-) when defining astute statue.

understand "trevis/vister" and "trevis vister" as astute statue.

the rivets are part of the statue. description is "[one of]After looking for a few seconds, you realize t[or]T[stopping]he rivets spell out PRAISE. They're probably Vister's idea of art, to show there's more than one way to want to be like him. Or want to want to be like him.". the rivets are reflexive.

rivets-first is a truth state that varies.

check objhinting rivets:
	if rivets-first is false and prai is reflexive:
		try objhinting prai instead;
	if rivets are reflexed and prai is reflexive:
		try objhinting prai instead;
	if rivets are reflexive and prai is reflexive:
		all-say "You learned all you could from the statue." instead;

the prai is privately-named reflexive scenery in Econ Cone. prai is undesc. printed name of prai is "PRAISE".

a-text of prai is "YRRYRY". b-text of prai is "YRRGRG".

check scaning rivets:
	if rivets are reflexed and prai is reflexive:
		try scaning prai instead;

instead of doing something with rivets:
	if action is procedural:
		continue the action;
	if current action is taking:
		say "Petty theft is not big thinking! You'd do better to take a message from the rivets.[paragraph break]Plus, you don't have the right tool." instead;

check scaning statue for the first time:	[let statue be the first thing you scan] [?? weird flips]
	say "You're pretty sure Trevis Vister did his best to make his statue couldn't be melted down by some silly mind-game, but maybe the settler will turn up something...hmm, nothing, except for the rivets.";

check scaning statue:
	try scaning rivets instead;

a-text of rivets is "RRRYRY". b-text of rivets is "[if prai is reflexed]RRRYRY[else]?RR?R?[end if]".

[stew: many people sit outside and want more money. You want something else, though.]

after fliptoing skyscraper:
	consider the region-knock rule;
	continue the action;

check fliptoing skyscraper:
	if prai is reflexive and rivets are reflexive: [stri is false and asp is false:]
		say "You sit and ponder for a bit. But it is just general complaining. The whole mish-mosh about people approximately as unfortunate as you. No wish for [i]praise rivets[r] you enough for you to ponder positively." instead;

book FiefCo Office

check fliptoing when player is in FiefCo Office and noise is in FiefCo Office: [note that this trumps check fliptoing song]
	if noun is song:
		say "First things first: you need to outlast that noise.";
		preef salt;
		do nothing instead;
	if noun is not noise:
		say "Thud, thud, thud. You might be able to do that properly later, but not now, with the noise distracting you from your new job listed on your vanity.";
		preef noun;
		do nothing instead;

FiefCo Office is an innie room in Troves. "From the nerf fern to the tan ivy vanity[if divorces is visible],[else] and[end if] Slick-Tech Checklist[if divorces is visible], and DIVORCES magazine[end if] on your desk to the plasm lamps above, to the inspirational picture of a stream, your office conforms to the opulent/no let-up deco-code. Including the double-plus-secure door out[if song is visible].[paragraph break]Eddie C.[']s song[one of][or], I'd Cede,[cycling] echoes, still[else]. A shaker of salt sits on the vanity, too[end if]."

the noise is vanishing scenery in FiefCo Office. "It's noise from the person you locked out."

instead of doing something with the noise:
	if action is procedural:
		continue the action;
	if current action is objasking about or current action is asking about:
		say "You don't want to step down from a strong negotiating point."

the playbill is scenery. "It's for Siren G. Grines, Singer. That's in red, as is smaller writing about the band and promoters and so forth. It looks counter-cultural, but you are intrigued."

instead of doing something with playbill:
	if action is procedural:
		continue the action;
	say "You can just examine or read the playbill, but that's about it."

instead of doing something with eddie's song:
	if action is procedural:
		continue the action;
	say "You can just listen to Eddie's song for evocative details and stuff."

the secure door is scenery in FiefCo Office. "It isn't even to be thought about."

instead of doing something with the secure door:
	if current action is opening:
		say "[if noise is in office]And let that person in? No[else]You have too much to do. No sneaking out[end if]!" instead;
	if action is procedural:
		continue the action;
	say "You don't even want to think about that door with all you have to do."

DIVORCES Magazine is vanishing scenery in FiefCo Office. "[one of]Its motto: 'A hipper, happier paper. Hi!' You note all sorts of lurid articles and features about depravity in high society and its 'wonderful' fashion, too. One[or]Another 'worldly' article[stopping] is [randbla]"

a-text of divorces is "RYRRYRYR". b-text of divorces is "PGRRYRGR".

instead of doing something to DIVORCES:
	if current action is taking:
		say "No. It's best read briefly, if at all." instead;
	if action is procedural:
		continue the action;
	say "DIVORCES is mostly for reading, mostly, unless you have an insight otherwise." instead;

understand "signer" as a mistake ("No. Your eyes redden as you remember you are already a signer. The singer makes you want to do something else.") when player is in FiefCo Office.

understand "maters" and "tamers" as a mistake ("Such people would be beneath your delegational abilities.") when stream is visible.

does the player mean examining the big important desk: it is very likely.

the big important desk is scenery in FiefCo Office. "Made of nice to notice eco-tin, it has a Slick-Tech Checklist (more popular and efficient than the [randbla]) on it that you could read all day."

the Slick-Tech Checklist is scenery in FiefCo Office. understand "list" and "checklist" and "slick/tech" and "slick tech" as checklist.

description of slick-tech checklist is "You browse some steno-notes on your Slick-Tech Checklist: [randbla]"

the plasm lamps are plural-named scenery in FiefCo Office. "They start to inspire a Psalm, until you remember you're a busy [guy] with a job to do."

to say guy:
	say "[if player is female]wo[end if]man";

instead of taking lamps:
	say "That'd be expensive and toxic."

check going east in FiefCo Office:
	say "You couldn't just run out on your company and your responsibilities like that! You would engage to leave a note or something first. And, of course, you would need to mentally prepare yourself to[if salt is visible]. And you'd need to have proved yourself. You haven't, yet[otherwise]. I guess you could leave now, if you did the right thing, first[end if]." instead;

the tan ivy vanity is auxiliary scenery in FiefCo Office. "[one of]It's utterly useless and tacky. I mean, ivy is either green or, if it's dying, brown. [or][stopping][if noise is in office]There's lots of red text:[paragraph break][fixed letter spacing]  GOREN I. REGNIO[line break]Ergnio-Onregi Region[r][paragraph break]So that's who you took over from. You sense you need to...marginalize Goren's memory somehow.[else]It's now engraved CEO FOR US? OF COURSE![end if]"

instead of opening vanity:
	say "It's not a case sort of vanity. It's just a useless sort of vanity.";

instead of scaning vanity:
	say "You scan around the vanity for clues.";
	if noise is in office:
		say "You note the noise and that you can read the vanity[if vanity is examined] again[end if].";
		try scaning noise instead;
	if lobster is in office and stream is reflexive:
		say "Your settler picks up a signal when it moves to the lobster.";
		try scaning lobster instead;
	if salt is in office:
		say "Your settler picks up a signal when it moves to the salt.";
		try scaning salt instead;
	if playbill is visible:
		say "Your settler picks up a signal when it moves to the playbill.";
		try scaning playbill instead;
	say "You weren't able to find any. But there must be something to do!"

a-text of noise is "YRRYRY". b-text of noise is "YRRYRY".

chapter vanscaning

[* scans vanity every move in troves]

vanscan is a truth state that varies.

vanscaning is an action out of world.

understand the command "vanscan" as something new.

understand "vanscan" as vanscaning.

carry out vanscaning:
	if vanscan is false:
		now vanscan is true;
	else:
		now vanscan is false;
	say "[if vanscan is true]Scanning vanity every move[else]No longer scanning each move[end if].";
	the rule succeeds;

every turn when vanscan is true:
	say "Results of scanning vanity:[line break]";
	try scaning vanity;

chapter lager

The can of Large Regal Lager is a vanishing LLPish thing in Boredom Bedroom. description is "It has a picture of someone smiling as he chugs a can of Large Regal Lager--the LARGE being black and above the red Regal Lager below. A warning on the can says that important people drinking too many of these is as bad for the economy as people with nothing better to do not drinking enough. Also there's a rubbish story about how the beer is brewed."

the rubbish story is part of the Regal Lager. the rubbish story is cluey and auxiliary. description is "[one of]It's in red and about how Ergal Agler brewed the first batch long ago. It kills almost as many brain cells as you drinking it[or]Your eyes gloss over all but the red ERGAL AGLER[stopping]."

a-text of rubbish story is "RRYRY". b-text of rubbish story is "RRYRY".


instead of scaning rubbish story:
	try scaning Large Regal Lager instead;

a-text of lager is "RRYRY". b-text of lager is "RRYRY".

instead of drinking lager:
	say "One sip is--nope. Next, a liter, retail. Though it's not as nasty as Camelot Eco-Malt, it'd make your liver viler and send you to Bum Lane seeing blue men.[paragraph break]Though you can't bring yourself to throw it out. Maybe you are not looking at things the right way.";

instead of eating lager:
	say "It drinks like a meal, you're sure, but you're too important now to risk brain cells to find out.";

instead of taking lager:
	say "No, touching or holding a can almost always leads to drinking from it. You may even be able to ignore the Large Regal Lager altogether. But you will need to steel yourself before taking it."

an extra fancy lobster meal is in FiefCo Office. description is "Oh, man, it looks awesome. You wonder if you really deserve to eat it. If you built yourself up the right way, I'm sure you could chow down[if stream is reflexed]--though you are feeling confident enough, having dealt with the stream[end if].". fancy lobster meal is vanishing. initial appearance of lobster meal is "A meal's on the desk. Lobster! You may or may not have the confidence to eat it."

a-text of lobster is "RYRRRYR". b-text of lobster is "RGRPPGP". lobster is semi-easy and auxiliary. [if a-text is not "" then it is auxiliary]

instead of eating lobster meal:
	say "You don't quite feel you deserve to eat it, yet.";

instead of taking lobster meal:
	say "A big executive like you shouldn't worry about procedural details like taking something before eating it."

chapter stream painting

The painting of the stream is reflexive scenery in FiefCo Office. "It's labeled as PRACTICAL RELAXATION FOR TODAY'S LEADERS. The stream is about all there is to it. It shimmers based on how you stare at it[if stream is not reflexed and lobster is in lalaland]. You doubt you need to do anything with it, since you had that delicious lobster, but then, it might be one more overachievement[end if]."

a-text of stream is "RYRRYR". b-text of stream is "RYRRYR".

instead of doing something to painting of the stream:
	if action is procedural, continue the action;
	say "It doesn't need to be physically futzed with[if painting of the stream is reflexive]. In fact, you've already gotten use out of it[end if].";

chapter salt shaker

instead of doing something to the salt shaker:
	if action is procedural, continue the action;
	say "[if shaker is reflexed]The previous occupant probably had it there to salt away some dumb motivational saying[else]You salted this puzzle away, already[end if]."

the salt shaker is super-easy auxiliary scenery in FiefCo Office.

description of salt shaker is "It has a few wise sayings: Be worth your [i]SALT[r]. Salt helps things preserve themselves. And, oh, wait, there's no way to get the salt out. It's just a cheap motivational gimmick!"

a-text of salt is "RYRR". b-text of salt is "RGRP".

before eating salt:
	say "You're in a high-pressure enough environment, as-is. Plus, the shaker can't actually get the salt out. It does sort of shake, though." instead;

check putting salt on:
	ignore the can't put what's not held rule;
	if second noun is lobster:
		say "That'd ruin it." instead;
	say "The salt is there for ornamental and inspirational purposes. Plus, there's nothing here to eat[if lobster is visible], except the lobster, which doesn't need it[end if]." instead;

chapter nerf fern

The nerf fern is useless scenery in FiefCo Office.

description of nerf fern is "It saves time, since you don't have to water it. But you can't see how it gives any new ideas."

instead of doing something with the nerf fern:
	if current action is examining or scaning:
		continue the action;
	say "Don't futz with it. It's there for ambiance. The sort of ambiance people less busy than you care about.";

book silly verbs needed to win Troves

understand "care" as a mistake ("You find yourself boohooing over mumbo-jumbo about how the socioeconomic system must be even more unfair to people without your powers. How unproductive to care about THAT.") when heat is not visible and mrlp is troves.

understand "race" as a mistake ("Races scare you without the proper motivation from inside.") when player is in Loather Rathole and cold is visible.

understand "acre" as a mistake ("That farm-boy terminology won't help show you give a darn in the big city.") when player is in Loather Rathole and cold is not visible.

section note from dale

ltb is a privately-named vanishing super-easy thing. "A copy of LEAD[one of], the bestseller Pa, Egg, Pea dethroned,[or][stopping] lies here.". description of ltb is "It's by Dale Elda and Leda Adle, with both the last names in red. You don't quite feel up to reading it, yet. You aren't in the right frame of mind. Just from the cover, and the authors['] names, you bet the writing is kind of forced.". printed name of ltb is "LEAD".

a-text of ltb is "RYYR". b-text of ltb is "???R".

understand "copy" and "book" and "lead" as ltb when player is in boredom bedroom.

does the player mean doing something with ltb when the player is in boredom bedroom: it is likely.

understand "aled" as a mistake ("Getting drunk will not solve your problems[if lager is in bedroom]. And that lager would taste awful, anyway[else]. Especially when there's nothing here to get drunk with[end if]. You see red at yourself for such thoughts.") when ltb is visible

instead of taking the ltb:
	say "You already have one motivational book. Perhaps you need to find the right way to soak up LEAD's essence."

understand "eiders" as a mistake ("But what would ducks DO in the big city? They have no ambition. They don't crave...") when brochure is visible

the cold is flippable scenery in Loather Rathole. "[one of]Even though you wasted time watching weathercasts as a kid (boo!) and never learned to small-talk about it with important people (boo!) t[or]T[stopping]he cold's still just...cold."

a-text of cold is "RYRY". b-text of cold is "PYRY".

understand "hate" as a mistake ("You don't want to get burnt up with hate[if heat is visible], and that won't get back your super purse like racing after that guy[end if].") when cold is not visible.

the heat is flippable vanishing scenery. "The heat is nice and all, but being happy for it isn't the right emotion, here, with your possessions stolen."

a-text of heat is "RYRY". b-text of heat is "RGRG".

chapter ignoreing

every turn while player is in FiefCo Office (this is the region-knock rule):
	if noise is in office:
		say "[one of]'Er...go in?' cries a voice not worth your attention[or]You hear the voice cry '[one of]Erin! Go[or]Go, Erin[cycling]!' which makes you see red. YOU'RE in charge here[or]Your 'visitor' seems to be plotting...he says 'One: rig...' but you tune the rest out, seeing red[or]'No! I...erg!' your adversary rages[in random order].[paragraph break]If only you could tune that out!";

instead of taking bee's head:
	say "You're not fast enough to behead the bee's head."

the bee's head is part of the what-a-bee. the bee's head is reflexive. description is "[if bee's head is reflexed]It appears a bit duller now, after you reasoned so well against it[else]It shines brightly, as if it is ready for a battle of wits[end if]."

after fliptoing bee's head:
	if what-a-bee is reflexed:
		min-up;
	else:
		say "Now that the bee's buzzing less, you can hear people giving directions, and maybe you can listen in. Or concentrate on the cellar.";
	continue the action;

after fliptoing what-a-bee:
	if bee's head is reflexed:
		min-up;
	else:
		say "Now that the bee's buzzing less, you can hear people giving directions, and maybe you can listen in. Or concentrate on the cellar.";
	continue the action;

chapter resigning

Eddie's song is super-easy reflexive scenery. "Eddie C. warbles on."

a-text of song is "RYRYRY". b-text of song is "RYPYPG".

check scaning playbill for the first time:
	say "You see only six lights, which means it's probably the text on the playbill.";

a-text of playbill is "RYRYRR". b-text of playbill is "RYRYRR".

understand "snog" as a mistake ("You're too busy for...THAT. You focus on the singer. Probably someone you'd like to...hire to sing a song you wrote.") when player is in FiefCo Office.

instead of examining song:
	try listening instead;

understand "resign" as a mistake ("Wrong place for that. If you must, QUIT instead.") when player is not in FiefCo Office.

understand "reigns" as a mistake ("You try to convince yourself it totally reigns here, but the singer pushes you towards giving up your responsibility.") when song is visible.

check fliptoing song:
	if lobster is in office and stream is reflexive:
		say "Man. That seems right. But you haven't improved yourself enough to last, yet.";
		preef salt;
		do nothing instead;

after fliptoing song:
	say "You're besieged by art, in fact! What's...what's that sound? It's that song! By Eddie C.!";
	now playbill is in fiefco;
	continue the action;

troend1 is privately-named useless scenery. troend1 is undesc. printed name of troend1 is "I'd Cede (Eddie C.)"

troend2 is privately-named useless scenery. troend2 is undesc. printed name of troend2 is "Singer flyer"

check fliptoing troend1:
	if lobster is visible and stream is reflexive:
		say "But you aren't important, hard-working and enough of a fixture here for your resignation to mean much.";
		preef song instead;

check fliptoing troend2:
	if lobster is visible and stream is reflexive:
		say "But you aren't important, hard-working and enough of a fixture here for your resignation to mean much.";
		preef playbill instead;

decide-win is a truth state that varies.

after fliptoing troend1:
	now decide-win is true;
	continue the action;

check scaning post:
	if babblings is reflexive:
		try scaning babblings instead;
	if post is reflexed:
		say "You've dealt with the post." instead;
	say "[if cheat-on is false]RRYR[else]The stop post blinks between PRGR and RRYP[end if]." instead;

check fliptoing what-a-bee:
	if verbose is reflexive:
		say "You haven't paid enough attention to know what to spot." instead;

the cellar door that must be here somewhere is vanishing scenery in Used Lot. "You can't really examine it if you don't know where it is."

a-text of cellar door is "RYRYRR". b-text of cellar door is "RGRYRR".

instead of doing something to cellar door:
	if current action is taking or current action is opening or current action is closing:
		say "But you're not sure where the door is, so you can't do that." instead;
	if action is procedural, continue the action;
	say "No, you need to do something to find the cellar. Since you can't quite remember...";

derived is a truth state that varies.

after fliptoing cellar door:
	if the player's command includes "derive":
		now derived is true;
	if bee's head is reflexive or what-a-bee is reflexive:
		poss-d;
	continue the action;

check fliptoing cellar door:
	if what-a-bee is off-stage:
		say "You haven't forgotten anything important, yet." instead;
	if bee's head is reflexive and what-a-bee is reflexive:
		say "Darn it, that should work. But you can't focus on anything with that evil bee buzzing around you right now." instead;

volume otters

book coevals' alcoves

Coevals' Alcoves is a room in otters. Alcoves is west of fro. "A monstery monastery. Laminas of mythical or extinct animals populate the walls here, along with a forces fresco. You can go back out to the east, or in to the west, if you dare."

check going when player is in alcoves:
	if noun is inside:
		try going west instead;
	if noun is outside:
		try going east instead;

the forces fresco is scenery in Alcoves. description of forces fresco is "One glance tells you it deserves an f-score, with or without recs of disturbing violence and amorality."

instead of doing something with the forces fresco:
	if current action is examining, continue the action;
		say "The fresco is just there to taunt and annoy people not aligned with Elvira."

the laminas are useless scenery in alcoves. "Disturbing, really. They depict bizarre mutants designed for warfare, for keeping people down. They're signed, unsurprisingly, VELASCO.". understand "animals/lamina/animal" as laminas.

instead of doing something with laminas:
	if action is procedural:
		continue the action;
	say "The laminas are just part of the whole bad-guy ambiance.";

check going east in alcoves:
	if medals are reflexed and Inclosure is unvisited:
		say "You don't know when your super-speed will wear off. You'd hate to waste it where you've already been." instead;

chapter elmer and merle

Elmer is an auxiliary person in Alcoves. Elmer is henchy.

Merle is a reflexive LLPish person in Alcoves. Merle is henchy. The chum of Merle is Elmer.

a-text of Merle is "RYRYRRRO". b-text of Merle is "RYRYRRRO".
a-text of Elmer is "RYRYRRRO". b-text of Elmer is "RYRYRRRO".

to say e-m:
	say "[one of]Merle[or]Elmer[in random order]";

initial appearance of Elmer is "[bug-report]".
initial appearance of Merle is "[bug-report]".

rule for printing a locale paragraph about Elmer:
	say "Elmer and Merle, two robed bored Coevals in scowl cowls, glance over at you contemptuously as they babble.";
	now Merle is mentioned;
	now Elmer is mentioned;

understand "drobe" as a mistake ("That's pretty much their whole drobe. You're not here to talk fashion, anyway.") when Merle is visible.

description of Elmer is "He wears sober robes. His mouth smiles on the left and frowns on the right."

description of Merle is "He wears sober robes. His mouth smiles on the right and frowns on the left."

the sober robes are plural-named scenery in Alcoves.

instead of doing something to sober robes:
	if action is procedural, continue the action;
	say "Elmer and Merle, noticing you looking at their robes, yell 'Us? Drab? Absurd!'"

description of sober robes is "Elmer and Merle don't stylize zestily."

book bleary barley

to say if-ed:
	if ed riley is visible:
		say ", or you could if a steward weren't keeping you eastward";

Bleary Barley is a room in otters. "[if b-b is reflexive]Bleary Barley blocks you completely, stretching out seamlessly, endlessly[else]You can go west past where Ed Riley was[if-ed], and though the barley's too thick to the east, north and south are okay[end if]."

check going east in Bleary Barley when b-b is reflexed:
	say "The barley is a bit too thick that way[if ed riley is in Bleary Barley]--they almost look more like marsh plants than barley[end if]." instead;

[glow red as you want to get rid of them]

last-loc of otters is Bleary Barley.

check going in Bleary Barley:
	if noun is up or noun is down:
		continue the action;
	if b-b is reflexive:
		say "The barley is nearly everywhere. Without knowing where you're going, you'll get lost." instead;
	if Ed Riley is visible:
		if noun is south or noun is north:
			say "Ed Riley booms, 'Yielder! That's right. Go [noun]. Not west.'";
			continue the action;

b-b is privately-named reflexive scenery in Bleary Barley. the printed name of b-b is "bleary barley". understand "bleary/barley" and "barley" as b-b. "[if b-b is reflexed]Not so impressive now--it might be a mirage, but it looks like the barley to the east is on water, and thicker-yellow on top. It reminds you of a marsh[otherwise]It ranges expansively--but the weird thing is, it hasn't flowered. Very bleary though[end if]."

does the player mean gotothinging b-b:
	if map region of player is otters:
		it is very likely;
	it is very unlikely.

a-text of b-b is "RYRYRO". b-text of b-b is "P??YRB".

check scaning b-b:
	if b-b is reflexed:
		say "Nothing registers." instead;
	say "Your settler registers [if cheat-on is false]RYRYRO[else]PGPYRB[end if]." instead;

instead of taking b-b:
	say "[if b-b is reflexed]It'll be barely useful[otherwise]Your inventory doesn't expand infinitely[end if]."

check eating b-b:
	say "[if b-b is reflexed]Bleah. That'd go down terribly[otherwise]Don't think gluttonously[end if]." instead;

Ed Riley is a vanishing man. description is "'You won't get past Ed Riley, yielder!' he booms. For all this bluster, you get the feeling his loud voice hides an insecurity.". "Ed Riley acts as a steward here to keep you eastward. He is carrying an ER, YIELD sign and a loaf of deli rye."

the deli rye is an edible auxiliary thing. description is "It looks delicious enough for Ed not to share with you.". Ed Riley carries the deli rye.

instead of doing something with Ed Riley:
	if action is procedural:
		continue the action;
	if current action is taking:
		continue the action;
	if current action is objasking about or current action is asking about:
		continue the action;
	say "You probably don't need much more than your usual tricks to get past him. Even in your diminished state."

understand "yielder" and "steward" as Ed Riley.

a-text of ed riley is "RYYRYRO". b-text of ed riley is "RYYRYRB".
a-text of deli rye is "RYYRYRO". b-text of deli rye is "RGYRYRO".

the Er Yield sign is a semi-easy auxiliary thing. Ed Riley carries the yield sign.

a-text of er yield is "RYYRYRO". b-text of er yield is "RYYRYPO".

understand "idle" as a mistake ("Ed Riley looks pleased he's pressured you into laziness.") when Ed Riley is visible.

understand "lied" as a mistake ("You can't think of anything to lie about that would sucker Ed Riley. You try to tell him the people who gave him this 'job' lied but realize you don't know who you are.") when Ed Riley is visible.

the description of the er yield sign is "'Spiffy, huh? I was told I could wipe off the 'er' for the first person I scared into not passing me for good.'"

to say ed-nonsense:
	say "[one of], and then he bangs on about not trying to sing or attack him[or][or][or][cycling]"

check going west in Bleary Barley:
	if Ed Riley is visible:
		say "'I will not re-yield! I am no longer a yielder! Ye Idler!' booms Ed Riley[ed-nonsense].[paragraph break]He's not bigger than you, but his loud voice scares you. And he could probably swat you with either that deli rye or er, yield sign. You back away." instead;

the weltish whistle is a reflexive thing. description is "It's ugly, that's for sure, but [if parrot wears whistle]the parrot isn't carrying it around for nothing[else if whistle is reflexive]you can probably PLAY it and practice to figure how to use it[else]you do know how to PLAY it, and that's something[end if]. It reads DISCOURAGE-SCOURGE AID. WHISTLES: SHE WILTS. Red writing indicates who crafted it..";

after printing the name of the whistle while taking inventory:
	say " ([if whistle is reflexed]which you know how[else if whistle-play is true]which you tried and failed[else]which you haven't tried[end if] to play)";

a-text of whistle is "RYYRRO". b-text of whistle is "RGYPRO".

check fliptoing the whistle when whistle is reflexive:
	if Elvira is visible:
		say "Elvira summons her monsters to attack as you learn to play the whistle. 'Sorriest resistor! Apt end, pedant.' is the last you hear. Maybe you should've practiced somewhere else.";
		get-dead;
		follow the shutdown rules instead;
	if number of visible people > 1:
		say "Your practicing might be rough on [random visible person]. Maybe you should go back to the Frat-Gone Frontage[if merle is in lalaland] or the Alcoves[end if]." instead;

does the player mean playing the whistle: it is very likely.

instead of taking whistle when parrot has the whistle:
	say "'Awk! I like you, but not til I've had my revenge.'"

book otters specific verbs

chapter quicklying

to first-status: (- DrawStatusLine(); -);

to get-dead:
	if location of player is not Inclosure:
		if joke-death is false:
			d "Missed joke-death.";
		now joke-death is true;
	if the have-died flag is false:
		now undo-code is 9;
	else:
		now undo-code is 10;
	if location of player is freight:
		ital-say "maybe that pale plea can help you figure how to escape.";
	else if location of player is inclosure:
		ital-say "there are a few ways to die here in the confrontation with Elvira, but you should always be able to back out. In fact, you can flee if you think you need to.";
	else if location of player is alcoves:
		do nothing;
	else if joke-death is true:
		ital-say "this death was an easter egg. I hope it amused you. The death message below is random, and it's probably easier to read the source or win the game than UNDO and retry them.";
	d "Getting dead: [undo-code].[line break]";
	end the story saying "[deth]";

ever-fig is a truth state that varies.

to preef (thi - a thing): [text listed in table of pres]
	now ever-fig is true;
	if player is in study:
		check-get-pad;
	if thi is not prefigured:
		say "[i][bracket]You add the information to your pedanto-notepad under FLIPS.[close bracket][r][line break]";
	now thi is prefigured;
	if player is not in study and player does not have pedanto-notepad:
		say "You should have your notepad, but you don't. This is a BUG, reportable at [email], and I'm giving you the notepad.";
		now player has pedanto-notepad;
	pad-rec "flips";

to preef-nol (thi - a thing):
	now ever-fig is true;
	if thi is not prefigured:
		say "[i][bracket]You add the information to your pedanto-notepad under FLIPS.[close bracket][r]";
	now thi is prefigured;
	if player is in study:
		check-get-pad;
	pad-rec "flips";

check fliptoing medals:
	if Merle is visible:
		say "Elmer and Merle's stupid underling chatter is bad enough at regular speed. You're worried going at super speed might drive you nuts[med-unf]. [if hydra-known is true]You probably need force to get west, too[else]You might need that speed in the final combat, instead[end if].";
		preef medals instead;
	if player is not in alcoves:
		say "There's nothing you really need to attack or avoid quickly here or nearby[med-unf].";
		 preef medals instead;
	if nounsolve < 3 or adjsolve < 3:
		say "You feel a surge, but not enough. [if nounsolve < 3 and adjsolve < 3]Both medals seem[else]One of the medals seems[end if] tarnished. Maybe that's holding some power back. Maybe you have some good deeds to perform, still[med-unf].";
		 preef medals instead;

to say med-unf:
	say "[if medals are unfigured], but that feels right. You note what to do for later[end if]"

i-quipped is a truth state that varies.

Elvira-delay is a number that varies.

every turn when player is in Inclosure and player was in Inclosure (this is the Elvira gains confidence rule):
	unless action is procedural:
		if current quip is final-quip:
			if current action is not playing whistle and current action is not qbc responding with and current action is not objasking generically and current action is not objasking about and current action is not asking about and current action is not asking generically:
				increment Elvira-delay;
				if Elvira-delay is 2:
					say "Elvira smirks when she sees you have no plan. 'Wane anew, blunder bundler,' she says as she gives that silvery laugh.[paragraph break] 'Potent--to PENT' are the final words you hear. Hmm. You probably can't hang around, but there must be a simple way to defeat her[if whistle is not reflexed]. Perhaps you can even retreat to prepare to defeat her[end if].";
					get-dead instead;
				else:
					say "Elvira looks a little less shocked, now. You might want to retreat if you have no plan to defeat her.";

chapter cinders

cinders are a vanishing LLPish thing. "Cinders lie here, probably cold enough to take.";

report taking cinders:
	say "They crackle with energy as you take them. Perhaps you can do something with them.";
	the rule succeeds;

Include (-
	has transparent talkable
-) when defining cinders.

understand "increds" as a mistake ("You marvel at the possible power of the cinders and even see red at the thought of giving them up.") when player has cinders or location of cinders is location of player

description of cinders is "You feel a wave of power as you [if player has cinders]finger through[else]get close to[end if] them. Nothing dangerous, but power to see how to do something, if you think right. But also power to believe you can do it all on your own."

check dropping cinders:
	say "You may be able to get rid of them, but they're holy and powerful and you may need some sort of ritualistic action." instead;

a-text of cinders is "RYRRYRR". b-text of cinders is "R?RR??R".

chapter discerning

discerning is an action applying to one thing.

understand the command "discern" as something new.

understand "discern [something]" as discerning.

does the player mean discerning the cinders: it is very likely.

does the player mean discerning the player: it is likely.

[every turn when player has cinders (this is the stupid cinders cheat rule):
	try discerning cinders;
	now player has cinders;]

to say orish of (myl - a list of text):
	repeat with lelt running from 1 to number of entries in myl:
		if lelt < number of entries in myl:
			say "[entry lelt in myl], ";
		else:
			say "or [entry lelt in myl]";

to say Rand-to-go:
	let mysc be random reflexive scenery in location of player;
	repeat through table of anagrams:
		if mysc is the-from entry:
			say "[right-word entry in upper case]";
			continue the action;
	say "BUG--[if player is in Anteroom]loathingly or tersely[else]angrily or brutely[end if]";

rescind-cinders is a truth state that varies.

after fliptoing cinders:
	now rescind-cinders is true;
	continue the action;

carry out discerning:
	let do-i-dis be true;
	if noun is whistle:
		say "The whistle's not technical enough. Don't waste the cinders on that." instead;
	if noun is not cinders:
		if mrlp is not otters:
			say "[reject]" instead;
		say "[if player has cinders]You need to discern the cinders--they will tell you what is most important to do next[else]You're not around the right item to do that[end if]." instead;
	if ed riley is visible:
		say "You discern that it might be a bit early to use this. Surely the cinders could be saved for later--and you could make Ed's voice higher. Still, discern further?";
		unless the player consents:
			say "You look at the barley to the east. It seems different." instead;
		say "You discern Ed Riley could speak more reedily.";
	else if player is in bran barn and p-2 is in bran barn:
		say "You discern an argument going although...however[if alcoves are unvisited], but you need to know the evil folks west of the [fro] are evil[end if].";
	else if player is in loop pool and eels are visible:
		say "You discern an argument going because...else[if alcoves are unvisited], but you need to know the evil folks west of the [fro] are evil[end if].";
	else if macks are visible:
		say "You listen to the macks and discern you could make them act and talk more [mack-actions].";
	else if sly imp is visible:
		say "You discern the imp would look ridiculous moving [Rand-to-go].";
	else if whiners are visible:
		say "You discern the men could be less intimidating acting [Rand-to-go].";
	else if player is in perverse preserve:
		if raptor is visible:
			say "You discern that the raptor could become a parrot[if inhib is true] with your powers back[end if].";
		else if nounsolve < 4:
			say "You discern what you can still rescue. [if racoon is off-stage]A racoon. [end if][if nails are in preserve]A snail. [end if][if thrones are in preserve]Hornets. [end if][if pines are in preserve]A snipe. [end if][line break]";
		else:
			now do-i-dis is false;
	else if player is in wire deck:
		if owls are visible:
			say "You discern that you make the owls slow[if inhib is true] with your powers back[end if].";
		else if adjsolve < 4:
			say "You discern which animals can get which help. [if leopard is reflexive]The leopard can be PAROLED. [end if][if ocelots are reflexive]The ocelots can become the COOLEST. [end if][if satyr is reflexive]The satyr can become ARTSY. [end if][if badger is reflexive]The badger can be GARBED. [end if][line break]";
		else:
			now do-i-dis is false;
	else if player is in alcoves and parrot is in alcoves:
		say "[if Merle is reflexive]Merle and Elmer's on-the-sly-ness is too sly to discern absolutely. Also, y[else]Y[end if]ou discern the parrot can become a RAPTOR again.";
	else if parrot is in lalaland and medals are reflexive:
		say "You discern you need to [if player is not in alcoves]go to the alcoves and [end if]see the medals can make you go QUICKLY.";
	else if player has whistle:
		if whistle is reflexive:
			say "You discern you may need [if player is in Inclosure]to leave the inclosure [end if]to see how to make the whistle play DEEPLY.";
		else if nounsolve < 3 or adjsolve < 3:
			say "You discern you may not have enough allies after you blow the whistle and have them go quickly. You left some behind in [if nounsolve > 3]the wire deck[else if adjsolve >= 3]the preserves[else]the preserves and wire deck[end if].";
			now do-i-dis is false;
		else:
			say "You discern you need to play the whistle [if player is in Inclosure]here[else]in the inclosure[end if].";
	else:
		now do-i-dis is false;
	if do-i-dis is false:
		say "The cinders do not dissolve. Looks like they had nothing super-profound for you to discern." instead;
	say "[line break]The cinders blow away, having imparted knowledge.";
	prevent undo;
	now undo-code is 7;
	poss-d;
	now cinders are in lalaland;
	the rule succeeds.

to say mack-actions:
	let xy be a random number from 1 to the number of rows in table of nasty guys;
	let zw be macked-out;
	while zw < 3:
		increment xy;
		if xy > number of rows in table of nasty guys:
			now xy is 1;
		choose row xy in table of nasty guys;
		if still-doable entry is true:
			increment zw;
			if zw is 2:
				say "[adverb-to-say entry], or ";
			else if zw is 3:
				say "[adverb-to-say entry]";
			else:
				say "[adverb-to-say entry], ";


chapter blowing

blowing is an action applying to one thing.

understand the command "blow" as something new.

understand "blow [something]" as blowing.

carry out blowing:
	if noun is harmonicas or noun is whistle:
		try playing the noun instead;
	if noun is a person:
		say "You don't really want an STD that leads to DTs." instead;
	say "That's not an instrument." instead;

chapter playing

playing is an action applying to one thing.

understand the command "play" as something new.

understand "play [something]" as playing.

whistle-play is a truth state that varies;

carry out playing:
	if noun is sitar:
		say "Your attempt at music does not provide the way to heaven." instead;
	if noun is saver:
		try pushing repeat button instead;
	if noun is harmonicas:
		say "I'll have to stem that. Your playing's the pits. Music, not game playing." instead;
	if noun is whistle:
		if parrot has whistle:
			say "Not while the parrot has it." instead;
		if whistle is reflexive:
			if location of player is Reclusion Inclosure:
				say "Elvira looks momentarily worried as you blow on the whistle, then gives laugh more musical than your unpracticed playing. '[randbla]!' As you fall, you hear Elvira giggle '[if player is female]Hereon, [b]I[r], heroine[else]I Master A Mister[end if].'";
				get-dead;
				follow the shutdown rules instead;
			now whistle-play is true;
			say "A horrible noise[one of][or]again[stopping], as if someone [i]yelped[r][one of]. You can't put up with it more than a split-second, and you probably need to figure how to make a more tolerable sound[or]. Hm, how to lower the pitch[stopping]." instead;
		if location of player is Reclusion Inclosure:
			if nounsolve + adjsolve is 0:
				say "Elvira looks momentarily worried, then giggles sardonically as nothing happens on your end. Plenty happens on hers. 'Ah, treat a threat.' Maybe you need some help?";
				get-dead;
				follow the shutdown rules instead;
			abide by the check final region action rule for Elvira;
			if the rule failed:
				say "OK." instead;
			say "As you blow the whistle, you feel a deep vibration on the ground. You hear a cacophony of animal noises in the distance. '[randbla]!' Elvira's voice still lilts as she calls for slayer layers relays. 'Gash, hags! Groupies, uprise! Go!'[paragraph break]'Ahh, get the hag!' you yell. The battle is on![wfak]Elvira cries 'New aid? Naw, die!' then 'To arms! A storm!' at...all the lethal: [twiddle of table of elvira machines and 3]. 'No mischance mechanics on...'[paragraph break]But animals from the fabled Odd Pack Paddock find valence in this enclave: [twiddle of table of animal friends and 5]. [wfak]Even ticks stick to Elvira's monsters and manage to triage a tiger, too. You see her wit wither, writhe, grow whiter. 'Strafe faster! Ye slack lackeys!' She and her creations fall with a prime thud as you triumph in their dump. The fiendish is FINISHED--influential, until...FINALE.";
			now otters is solved;
			now last-solved-region is otters;
			first-status;
			say "But wait! That's not all. You remember Curtis. Maybe you have time to ROVE OVER and help him out. Worth the bother?";
			unless the player consents:
				say "Yeah. Maybe later. If you want to help him, you can ROVE OVER from your dusty study when you hear the knock. Or you can just UNDO at the next command.";
				end the story finally saying "A MONSTER ROTS. AMEN.";
				follow the shutdown rules instead;
			say "Yeah. You've got nothing pressing back at the manor. But it's probably a good idea to keep the settler and notepad. The whistle and medals will go to a museum, or something.";
			clean-for-roving;
			continue the action;
		else:
			say "The whistle doesn't seem to make any noise. Well, not here." instead;
	say "That doesn't seem like a toy or an instrument." instead;
	the rule succeeds;

to clean-for-roving:
	now roved is true;
	if smoke cloud is in strip:
		move smoke cloud to lalaland;
	if tokers are in strip:
		move tokers to lalaland;
	if nestor is in strip:
		move nestor to lalaland;
	move otters-x to lalaland;
	move whistle to lalaland;
	move medals to lalaland;
	move magneto to lalaland;
	move player to strip of profits;
	if number of portals in strip of profits > 0:
		say "Moving [list of portals in strip of profits] out of the Strip. They shouldn't be there.";
		say "[bug-report]";
		now every portal in strip of profits is in lalaland;

to say lee-or-eels:
	say "[wfak]";
	if p-2 is in lalaland:
		if eels are in lalaland:
			say "You're surprised to see Mr. Lee and the eels together, 'LEE'S EELS,' alongside--yes, Gretta with animals of her own.";
		else:
			say "Some eels tag long behind Mr. Lee. You [if loop pool is visited]don't recognize them[else]look away sheepishly--you didn't convince them[end if], and they glare briefly as if to say, you should've TOLD us about the fun.";
	else:
		say "A man tags along behind the eels you rescued. [if bran barn is visited]It's Mr. Lee, whom you couldn't befriend[hat-gone], but he salutes you in half-apology[else]He salutes you, and he's little more than a spectator, but he smiles at the slaughter he hopes is ahead.";

to say hat-gone:
	say "[if ghoul hat is in lalaland] despite zapping that ghoul hat[else], though his ghoul hat's gone[end if]";

chapter whistleing

whistleing is an action applying to nothing.

understand the command "whistle" as something new.

understand "whistle" as whistleing.

carry out whistleing:
	if parrot is visible:
		say "You try to drop a hint for the parrot to give you the whistle, but he croaks for revenge." instead;
	if player does not have whistle:
		say "Music is not your talents. You'd need an instrument." instead;
	try playing the whistle instead;

book fro

fro is west of Bleary Barley. fro is part of otters. "[if Gretta is visible]This seems like the best place to meet a maiden in Yorpwald. Okay, it is probably the only one[else]Not much to do here now you ruined the 'fun' for those macks[end if]. A raw-bulk bulwark is to the west[if alcoves is unvisited], too big to hide nothing[else if Inclosure is unvisited], with much more than the alcoves you've seen[end if][if atmo-moat is in fro]. A moat blocks entry right now[end if]. You can go, more safely, back east or [if loop pool is visited or bran barn is visited]re-[end if]check what's north or south[if inhib is false], not that you need to[end if]."

the atmo-moat is super-easy vanishing scenery in fro. understand "atmo/moat" and "atmo moat" as atmo-moat. "Nothing subtle, no bustle. It's not the bluest you've seen water--in fact, for a moat, it's really red."

a-text of atmo-moat is "YRYR". b-text of atmo-moat is "??YR".

Include (-
	has transparent animate
-) when defining atmo-moat.

instead of drinking atmo-moat:
	say "A chorale warns that you might get cholera.";

instead of entering atmo-moat:
	say "It's too gulfy. Things'd get fugly. You've no diver pod provided. Plus you might get poked by strident tridents."

check fliptoing atmo-moat:
	if macks are in fro:
		say "That'd definitely tip the macks off to who you were, even if your powers were back.";
		preef atmo-moat;
		do nothing instead;
	else if inhib is true:
		say "That seems like it should work, but you just can't summon the power. Someone here should be able to help you, you hope.";
		preef atmo-moat;
		do nothing instead;

after printing the locale description for fro when fro is unvisited:
	say "[line break]But whatever they call themselves, you know macks['] M.O. Jump from subject to subject, to seem 'exciting,' and capitalize on when people give the benefit of the doubt. Still, there's always a hole in their 'impressive' stories--and even if you realize it a few turns later, you can drain their perseverance."

the raw bulk bulwark is a backdrop in fro. "It takes up a huge chunk of space to the west."

instead of doing something with the raw bulk bulwark:
	unless the action is procedural:
		say "[if player is in alcoves or player is in Inclosure]Being inside the bulwark, you can't do much TO it[else]Not much to do with the bulwark but look at it and realize it must be protected for a reason[end if]." instead;
	continue the action;

fro is privately-named. printed name of fro is "[if Gretta is in fro]Gent-Fora Frontage[else]Frat-Gone Frontage[end if]"

the sad elm is useless scenery in fro. description is "It was probably sad before the macks came along, but it's not really important."

instead of climbing sad elm:
	if Gretta is visible:
		say "You can beat [']em, so don't join [']em trying to impress her.";
	else:
		say "Yorpwald's still up a tree. Don't join it."

the macks are plural-named flippable reflexive people in fro. description is "'[if player is male]You can watch, but you won't LEARN[else]We're not trying to impress YOU. Geez[end if].' Their looks aren't so important--but they seem to be rotating through subjects quickly, and maybe you could catch them out on the right one. Given what you've done so far here, well, there'll be certain restrictions on what you can do--and that might actually help you narrow things down.". "Macks dressed all coy-hued are here, [if macked-out is 0]completely besieging[else if macked-out is 1]still trying to impress[else]desperately trying to captivate[end if] Gretta."

understand "mack" as macks.

a-text of macks is "BUG". b-text of macks is "BUG".

rule for printing a locale paragraph about macks:
	say "[one of]You hear a conversation. Men trying to impress--yes, it's Gretta Garett-Tatger--here. Their pick-up lines and stories are just horrible. But that's how it is, with macks. Or whatever annoying flirters are called these days[or]The macks continue to annoy Gretta[how-macked][stopping].";
	now Gretta is mentioned;
	now macks are mentioned;

to say how-macked:
	if macked-out is 1:
		say ", though not as much as when they started, since you got them";
	else if macked-out is 2:
		say ", but they're wavering a bit. If you blow up their flow once more, you could probably get rid of them"

Gretta Garett-Tatger is a female person in fro. "[bug-report]". description of Gretta is "She seems to be cringing at the pick-up lies, or the prospect she will let one work so she doesn't have to listen to them anymore."

before doing something when Gretta is visible and macks are not visible:
	if current action is examining:
		say "You should probably talk with Gretta Garett-Tatger a bit." instead;
	if current action is attacking:
		say "She's on your side." instead;
	if action is blathery:
		say "She's heard enough rambling conversation on others['] terms, here." instead;
	if current action is not talking to Gretta and current action is not QBC responding with:
		say "[convoforce].";
		reject the player's command;
	continue the action.

the litany of Gretta Garett-Tatger is the table of Gretta comments.

table of Gretta comments
prompt	response	enabled
"Boy, those macks, huh?"	gre-macks-quip	1
"What's your history with Elvira?"	gre-elv-quip	0
"I sort of lost my powers. Well, most of them. What can I do now?"	gre-what-quip	0
"[if loop pool is visited]What can I do with the pool[else]What's[end if] to the north?"	gre-north-quip	0
"[if bran barn is visited]What can I do in the barn[else]What's[end if] to the south?"	gre-south-quip	0
"What's back east[if sly imp is in lalaland or whiners are in lalaland]? I got rid of some people, but I got stuck.[else]?[end if]"	gre-east-quip	0
"Rescuing animals? How?"	gre-animals-quip	0
"[if optleft of Gretta is 1]Wow! You've been a big help[else if gre-go-warn is true]That's really all, now[else]Um, that's all, I guess[end if]. Thanks."	gre-go-quip	0

to decide what number is optleft of (myp - a person):
	let mytemp be 0;
	let myt be the litany of myp;
	repeat through myt:
		increase mytemp by enabled entry;
	decide on mytemp;

chapter smacking

smacking is an action applying to one thing.

understand the command "smack" as something new.

understand "smack [thing]" as smacking.

does the player mean smacking the macks: it is likely.

carry out smacking:
	if noun is macks:
		say "They really, really deserve it, but keep your cool. Smack their arguments down instead and they may smack each other for you." instead;
	try attacking noun instead;
	the rule succeeds;

chapter medals

the medals are a reflexive wearable plural-named thing.

understand "iq medal" and "iq" and "lucky medal" and "lucky" as medals.

after printing the name of medals while taking inventory:
	say " ([if nounsolve < 3 and adjsolve < 3]very tarnished[else if nounsolve >= 3 and adjsolve >= 3]polished[else]somewhat tarnished[end if])";

understand "medals" as a mistake("For shame! The macks only want to make her a FIGURATIVE trophy. Do something to earn some medals, like helping Gretta Garett-Tatger.") when Gretta Garett-Tatger is visible

description of the medals is "They're roped together--the smaller, [tarn of nounsolve]oxidized, says IQ, and the other, [tarn of adjsolve]tarnished, says LUCKY."

to say tarn of (tlev - a number):
	if tlev is 0:
		say "totally ";
	say "[if tlev is 0]extremely [else if tlev is 1]very [else if tlev is 2]somewhat[else if tlev is 3]barely [else if tlev is 4]un[else]BUG[end if]";

medals-lucky-first is a truth state that varies.

check switching on the medals:
	med-flip instead;

check switching off the medals:
	med-flip instead;

to med-flip:
	unless the player's command matches the regular expression "\b(on|off)\b":
		say "(Okay, silly parser stuff--just switch the medals)";
	say "You switch the medals so the [if medals-lucky-first is true]larger[else]smaller[end if] is on the right.";
	if medals-lucky-first is false:
		now medals-lucky-first is true;
	else:
		now medals-lucky-first is false;
	the rule succeeds;

nounsolve is a number that varies.
adjsolve is a number that varies.

check scaning medals:
	if nounsolve < 3 or adjsolve < 3:
		say "The settler reads oddly for a while but doesn't show anything. Maybe you need to reveal the medals some more." instead;

a-text of medals is "RYYRRRO". b-text of medals is "[if medals-lucky-first is true]RGYRRRO[else]RYYRRRB[end if][one of]--hmm, maybe if you switched the medals, you might get another clue. If you need it.[or][stopping]".

chapter ladying

ladying is an action applying to nothing.

irately is a truth state that varies.

understand the command "wearingly/blearily/nastily/snidely/seedily/coitally/martially/shadily/irately/tearily/ribaldly/cattily/tediously/starkly/despairingly/drawlingly/sobbingly/silently" as something new.

understand "wearingly" and "nastily" and "irately" and "blearily" and "tearily" and "coitally" and "martially" and "seedily" and "desparingly" and "shadily" and "starkly" and "snidely" and "silently" and "ribaldly" and "cattily" and "tediously" and "despairingly" and "drawlingly" and "sobbingly" as ladying.

carry out ladying:
	let mackstate be false;
	if macks are not visible:
		say "[reject]" instead;
	repeat through table of nasty guys:
		if the player's command matches the text "[adverb-to-say entry]":
			now mackstate is true;
			if ff is true:
				say "This would work, but flipping is frozen." instead;
		if there is a second-text entry and the player's command matches the text "[second-text entry]":
			now irately is true; [?? could modify if there was more than 1 double anagram, to a chose-second being true or false, false by default, true here]
			now mackstate is true;
		if mackstate is true:
			if still-doable entry is false:
				say "You already tipped the maps into [mack-do entry]. Maybe you can work on something else they're jabbering about." instead;
			say "[if its-been-done entry is false](Wow, you did this without seeing the macks act anything like that!) [end if][mack-phail entry]";
			now still-doable entry is false;
			process-macks instead;
	say "[reject]" instead;

macked-out is a number that varies. macked-out is usually 0.

check talking to Gretta when macks are in fro:
	say "The macks are monopolizing the conversation. They outnumber you." instead;

to process-macks:
	increment macked-out;
	if macked-out is 1:
		say "[paragraph break]The maiden looks a bit unsure but less engaged than before, and the macks seem off-stride and unenthusiastic.";
	otherwise if macked-out is 2:
		say "[paragraph break]The maiden nods, able to reject the worst of the macks['] bragging, but she still listens, likely out of cognitive dissonance. Strike two for the macks.";
	otherwise:
		say "[paragraph break]Suddenly, the maiden realizes zeal is, er, SLEAZIER. 'The balls! All the BS!'[paragraph break]Their preludes repulsed, they shuffle off all 'Man hater mantra, eh? Yum, so mousy. A dim maid. Hotness she's not!' as a beastly last 'bye,' to a beer hall, label her only worth trifling flirting. Their lustin['] becomes insult, but you look steely, as if saying 'Lest Ye!' Even to the heckling lech-king.[paragraph break]Gretta Garett-Tatger thanks you for saving her. She shuffles her feet a bit, unsure whether to leave or stay. She must have had a reason to hang around the bulwark in the first place. But you can't ask that straight out.";
		now player has the medals;
		now macks are in lalaland;
		reg-inc;
		try talking to Gretta;
		continue the action;
	reg-inc;

check going in fro when Gretta is visible:
	if noun is north or noun is south or noun is east:
		say "[cree-pee].";

to say cree-pee:
	say "A few macks [if player is male]laugh at how you obviously can't give Gretta Garett-Tatger the attention they can[else]let Gretta Garett-Tatger know she's more worth impressing than you[end if] as you leave"

check taking atmo-moat:
	say "Way too big." instead;

check going west in fro:
	if macks are in fro:
		say "One of the macks stops you from tripping the atmo-moat, and he tries to convince Gretta he's a great guy for saving you. The others yell at him for trying to play hero too obviously." instead;
	if atmo-moat is in fro:
		say "The moat just--scares you. It's too red, and when you recognize it as an atmo-moat, it turns blue, but it's still scary." instead;
	if Gretta is visible:
		say "[cree-pee]." instead;

chapter nasty things guys do

mack-row is a number that varies. mack-row is 1.

when play begins (this is the mack-randomize rule):
	let my-wt be 0;
	repeat through table of nasty guys:
		now wt-rand entry is number of characters in adverb-to-say entry;
	sort the table of nasty guys in random order;
	repeat through table of nasty guys:
		increment my-wt;
		increase wt-rand entry by my-wt;
	sort the table of nasty guys in random order;
	repeat through table of nasty guys:
		now its-been-done entry is false;

every turn when macks are visible (this is the macks hitting on rule):
	let this-bool be false;
	let recyc be false;
	increment mack-row;
	if mack-row > number of rows in table of nasty guys:
		now mack-row is 1;
		now recyc is true;
	choose row mack-row in the table of nasty guys;
	now this-bool is still-doable entry;
	while this-bool is false:
		increment mack-row;
		if mack-row > number of rows in table of nasty guys:
			now mack-row is 1;
		choose row mack-row in the table of nasty guys;
		now this-bool is still-doable entry;
	choose row mack-row in the table of nasty guys;
	say "[dumb-action entry][line break]";
	now its-been-done entry is true;
	if recyc is true:
		say "The macks take a break. They've [one of][or]once again [stopping]babbled for long enough, and about enough, they can repeat their 'exciting' conversation all over again[if macked-out > 0], except for what you managed to alter[end if]."

table of nasty guys
dumb-action	still-doable	mack-do	adverb-to-say	mack-phail	its-been-done	set-txt	second-text	mackhash	wt-rand
"Amazingly, the macks make projects like drywalling seem almost exciting--how competent they are, how incompetent some other guys are. Maybe it's just they're talking so fast, that they make [i]drywalling[r] interesting."	true	"blabbing about drywalling"	"drawlingly"	"The macks begin talking slower, and suddenly, their conversational hold is broken. Gretta realizes there's no good way to make home repair discussions more exciting and says so. She looks relieved."	false	"[if cheat-on is false]RRYRRYRRRO[else]PPYPRYRRRO[end if]"	--	592962469	10
"Each mack discusses how he outyields someone else with a lousy diet, all, 'You! Idlest!' You see red."	true	"disparaging a lousy diet"	"tediously"	"The macks begin whinging with the same old argument, going dreadfully off-subject, and so forth. Suddenly, their nonsense is less believable, or fun to believe."	false	"RYRYYYRRO"	--	748843503	9
"The macks continuing their lobbyings, far too cheery and confident."	true	"making lobbyings"	"sobbingly"	"The macks change up the mood, but it is for the worst. One starts crying, then others do--and it'spathetic enough, their plucky efforts to persuade without logic fall to pieces."	false	"[if cheat-on is false]RYRRYRRRO[else]RGPPYRRRO[end if]"	--	530137500
"Each mack discusses tacitly why he's got something the others don't."	true	"acting tacitly"	"cattily"	"The macks each lose their composure, each putting down the next guy's uniqueness or virtues or whatever. They're talking more sense than before, but the truth hurts, and things get out of hand quickly."	false	"[if cheat-on is false]RYRRYRO[else]RGRRYPB[end if]."	--	448579376
"The macks suddenly start acting very saintly."	true	"acting saintly"	"nastily"	"The saintliness act breaks out into competition, which becomes cutthroat, and one idiot, then another, lets slip that he could impress a better woman than Gretta with a nice-guy act. They scramble to assure her they didn't mean it that way, but she's not fooled."	false	"[if cheat-on is false]RYRRYRO[else]RGRRYPB[end if]."	--	491645247
"The macks begin redisplaying and redisplaying why they're so great."	true	"redisplaying their 'greatness'"	"despairingly"	"The macks become upset Gretta does not recognize just how swell they are--as a group, and individually. Gretta shrugs and shakes her head, maybe more at herself than the macks."	false	"[if cheat-on is false]RYRRYYRYRRRO[else]RGRRYYRYRRRO[end if]."	--	781752737
"The macks ooze on about how women want companionship, as much as men, and that's REALITY."	true	"discussing reality"	"tearily"	"One suitor is reduced to tears as he talks about reality, or his version of it. 'Dude, that was pathetic,' someone else says. 'Yet...LIAR! True-luv vulture!' The argument reflects well on no-one."	false	"[if cheat-on is false]RYYRYRO[else]RGGRGRB[end if]."	"irately"	539593685
"The macks ask if she has been thinking bridally."	true	"talking bridally"	"ribaldly"	"The macks move from the wedding to what they expect on the wedding night. She wanted to believe they would not, but they couldn't help it."	false	"[if cheat-on is false]RYRYRRRO[else]RYRYRRPB[end if]."	--	401939391
"The macks blather about how she is better than Lindsey."	true	"negging Lindsey"	"snidely"	"The macks refer to Lindsey a little too unfavorably and ignore Gretta's hint that she doesn't really hate Lindsey. Their apologies fail."	false	"[if cheat-on is false]RRYRYRO[else]RRYPYRB[end if]."	--	535182609
"A few macks do something stupid with their eyelids to get her attention."	true	"twiddling their eyelids"	"seedily"	"That thing they were doing? With their eyelids? Well, Gretta seems to have caught on, now. She laughs and groans a bit, and the macks accuse each other of being too obvious."	false	"[if cheat-on is false]RYYRYRO[else]RYGRGRO[end if]."	--	594081210
"The macks try to talk about ladyish things and fob off any awkwardness in the conversation to simple honesty."	true	"seeming ladyish"	"shadily"	"You manage to make them let slip a mean dis of other maidens."	false	"[if cheat-on is false]RRYRYRO[else]RRYRGRO[end if]."	--	377939109
"The macks perform a disturbingly convincing snit-yell: a style nit over a joke at SillyNet."	true	"having a snit-yell"	"silently"	"The macks run out of words to describe their style nit, and they begin miming, but that just makes them look a parody of themselves. With time to think, Gretta is able to say how sad they look."	false	"[if cheat-on is false]RYRYRRRO[else]P**YRRRO[end if]"	--	671077377
"Some of the macks even begin to talk maritally."	true	"blabbing maritally"	"martially"	"The men, in an effort to prove their worth, begin talking about that most manly of subjects, war. They talk very loudly and begin discussing cool ammunition and weapons and blood and guts. And shoot-em-up games. Gretta yawns conspicuously, clamming the macks up."	false	"[if cheat-on is false]RYRRYYRRO[else]PGPRYGPPB[end if]."	--	531864386
"Some of the macks compare her to Krystal, being sort-of favorable to both. Still, it's icky."	true	"comparing Gretta and Krystal"	"starkly"	"The macks finally get a bit too explicit about looks, and Gretta is able to overcome their flattery."	false	"RRYRRRO"	--	516001874
"The macks discuss how nice it is to meet her in this locality."	true	"'admiring' this locality"	"coitally"	"Sometimes you just have to let idiots talk about what, apparently, all men think about. With these guys, it's like you almost didn't have to do anything."	false	"[if cheat-on is false]RYYRYRRO[else]RGYRYRRB[end if]."	--	473635774
"The macks cut each other off reliably, giving Gretta no time to reject them or point out they're not THAT exciting."	true	"interrupting each other reliably"	"blearily"	"They interrupt each other, but not forcefully enough. Gretta comments, 'fascinating,' further cutting them."	false	"[if cheat-on is false]RRYYRYRO[else]RRYYRYPB[end if]."	--	508716411
"The macks begin lawyering about why she should probably choose ONE of them. You see red, a bit."	true	"lawyering"	"wearingly"	"They start repeating their arguments, and finally, Gretta draws up the courage to explain it's getting old."	false	"[if cheat-on is false]RYYRYRRRO[else]RYYRYRRRO[end if]."	--	645925650

check scaning macks: [?? doesn't give text at top]
	choose row mack-row in table of nasty guys;
	say "The settler switches to [set-txt entry][line break][one of][line break]Hmm, seems it changes as the subject does. Though maybe you can bring up a past subject to annoy them.[or][stopping]" instead;

book Bran Barn

Bran Barn is an innie room in otters. Bran Barn is south of fro. "This is a bran barn, empty of grain right now, and it'll probably stay that way[if p-2 is in bran barn]. A painting covers a good chunk of the interior here[end if]. You can go back north."

mr-l is a reflexive privately-named person in Bran Barn. description of mr-l is "He is one of those people you see nothing and everything special about at the same time[if alcoves is visited]. A less evil version of Merle and Elmer combined[end if].". "Mr. Lee stands here, undescribed."

mr-l wears the ghoul hat.

the ghoul hat is vanishing. description is "red and bloody and gruesome, it seems affixed to Mr. Lee. Maybe you can help it come loose, and Mr. Lee would appreciate that."

for printing a locale paragraph about mr-l:
	say "[one of]Someone crying 'Hunger, [one of]he rung[or]rehung[cycling],' lamenting his destroyed barley and calling himself [or][stopping]Mr. Lee stands here, ";
	if p-2 is in lalaland:
		say "doing farmy chores.";
	else if ghoul hat is in lalaland:
		say "glancing nervously at the painting of Rev. Howe.";
	else:
		say "[one of]musing 'Here to GLOAT, HUH?'[or]looking red-eyed and growling 'Hola, thug!'[or]giving a hot laugh.[or]crying, red-eyed, 'Ugh! O, halt!'[cycling]";
	now mr-l is mentioned.

printed name of mr-l is "Mr. Lee". understand "mr/ lee" as mr-l.

a-text of ghoul hat is "YRRRYYRR". b-text of ghoul hat is "YRRRYYRR".

check scaning mr-l:
	if ghoul hat is visible:
		say "Nothing happens until the settler points to the ghoul hat.";
		try scaning ghoul hat instead;

the p-2 is privately-named super-easy vanishing scenery in bran barn. "The painting has four bits of red writing on it."

printed name of p-2 is "painting of Rev. Howe".

understand "painting" and "rev howe" and "rev/howe" as p-2 when player is in bran barn.

a-text of p-2 is "RYRYRYR". b-text of p-2 is "RYRYRYR".

understand "whoever" as a mistake ("Actually, Mr. Lee is wondering whoever you might be. Tweak things, and you'll convince him.") when ghoul hat is in lalaland and p-2 is reflexive.

chapter althoughing

althoughing is an action applying to nothing.

althoughed is a truth state that varies.

check fliptoing mr-l:
	if alcoves is not visited:
		say "[nuh-uh]" instead;

check fliptoing p-2:
	if mr-l wears ghoul hat:
		say "Mr. Lee pulls on his ghoul hat, as if he wants to believe you, but his brain is half being controlled by something. You may need another word, first[if alcoves is not visited], and, perhaps, proof of what is in the bulwark[end if].";
		preef p-2 instead;

book loop pool

Loop Pool is a room in otters. Loop Pool is north of fro. "A pool encases a small island. The atmo-moat around the island babbles[if le mer is visible] pretentiously, [i]'Je suis le mer!'[r][else].[end if] You can go back south."

after choosing notable locale objects when player is in loop pool:
	set the locale priority of Le Mer to 0;

understand "polo" as a mistake ("No time for games! [if eels are in lalaland]Even with the eels rescued/on your side[else if inhib is true]You don't have your powers back, anyway. It's what's IN the water you want to change[else]Even with your powers back[end if].") when player is in Loop Pool

Le Mer is a person in loop pool. description is "You can't locate where, exactly, Le Mer is."

the sea cube is a semi-easy transparent vanishing container in loop pool. description is "You see eels in the cube.". "Eels float inside a sea cube here, just across the loop pool.".

check examining sea cube:
	ignore the examine containers rule;

a-text of sea cube is "RYRYYRY". b-text of sea cube is "RGRYGRG".

Instead of doing something with the sea cube:
	If action is procedural:
		continue the action;
	say "You aren't getting across the pool to do anything with the sea cube." instead;

the eels are a super-easy plural-named vanishing person in the sea cube. description of eels is "They seem listless, as if they need a reason to do something.". "Eels squirm around waiting for your directive."

understand "slee" as a mistake ("The eels aren't what needs to be reduced to rubble, here.") when eels are visible.

understand "lees" as a mistake ("The eels would be insulted to be referred to as dregs.") when eels are visible.

a-text of eels is "YRRY". b-text of eels is "GRRY".

check fliptoing eels:
	if player does not have medals:
		say "[nuh-uh]";
		preef eels instead;
	if sea cube is visible:
		say "You consider the end to an argument, but you don't have a start. The eels rattle against the sea cube, just waiting for the right first word.";
		preef eels instead;

to say nuh-uh:
	say "You try to argue that you're that person who saved Yorpwald in the first place, but you have no compelling reason--or evidence, really. You've got no evidence you're, well, you. [if location of player is bran barn]Mr. Lee[else]Le Mer[end if] is unmoved.[line break]";

check fliptoing sea cube:
	if player does not have medals:
		say "[nuh-uh]";
		preef sea cube instead;

section otters flipto and min points

[we need to check herer ifwe are completing both pool and barn points.]

to de-inhib:
	now inhib is false;
	say "You hear voices[one of][or], again[stopping]. 'Revil-a-Elvira?' / 'Yes, her.' / 'HERESY!'";

check fliptoing ghoul hat:
	if player does not have medals:
		say "[nuh-uh]";
		preef ghoul hat instead;

after fliptoing ghoul hat:
	if sea cube is in lalaland:
		min-up;
	continue the action;

after fliptoing p-2:
	de-inhib;
	if eels are in lalaland:
		min-up;
	continue the action;

after fliptoing sea cube:
	now eels are in loop pool;
	if ghoul hat is in lalaland:
		min-up;
	continue the action;

after fliptoing eels:
	de-inhib;
	if p-2 is in lalaland:
		min-up;
	continue the action;

book Tapering Anger Pit

Tapering Anger Pit is an innie room in otters. Anger Pit is north of Bleary Barley. printed name of Anger Pit is "Tapering [if sly imp is in Anger Pit]Anger Pit[else]Inert Gap[end if]". "This north-south passage is [if sly imp is visible]frustratingly blocked[else]pleasantly lifeless with the imp gone[end if]."

understand "inert gap" and "inert/gap" as anger pit when sly imp is in lalaland.

The sly imp is a flippable person in Anger Pit. "A sly imp simply zooms about [if imp1 is reflexive]rangily [end if]guarding the way north[if imp2 is reflexive], with a butlery air[end if][if imp3 is reflexive], showing legendary patience[end if] that allows vaster averts[if inhib is false]. But for all that, you think you could've taken the imp even before you regained your full powers[end if].". description of sly imp is "He looks back at you with an entirely tiny leer, planning how to keep one step ahead of you as effortlessly as he can, or keep you just mad enough not to think how to get rid of him.[paragraph break]He seems to have several tricks, but that may just mean several ways to get at him."

understand "green lady" and "enragedly" as a mistake ("You remember reading about the Green Lady in the Silver Chair, where she started nice and started acting furiously--no, that's not the word, not quite, it doesn't fit with Legendary. But it must be something like that.") when imp3 is reflexive and sly imp is visible.

a-text of sly imp is "BUG". b-text of sly imp is "BUG".

imp1 is privately-named unscannable reflexive ssno scenery in Anger Pit. printed name of imp1 is "the imp's actions". description of imp1 is "[bug-report].".

imp2 is privately-named unscannable reflexive ssno scenery in Anger Pit. printed name of imp2 is "the imp's actions". description of imp2 is "[bug-report].".

imp3 is privately-named unscannable reflexive ssno scenery in Anger Pit. printed name of imp3 is "the imp's actions". description of imp3 is "[bug-report].".

a-text of imp1 is "RRYRYRO". b-text of imp1 is "PRYRGRB".
a-text of imp2 is "YRRRYRO". b-text of imp2 is "YRRRGPB".
a-text of imp3 is "YRRYRYRRO". b-text of imp3 is "YRRYRYRRB".

understand "simply" as a mistake ("He's already simply annoying, so that has no effect. Maybe you can alter how he does things another way.") when sly imp is visible

understand "implys" as a mistake ("You will have to be subtle here, but you'll want to work on actions, instead.") when sly imp is visible

check going north in Anger Pit:
	if imp is visible:
		say "The imp gives a sidle-slide, then idles in front of you. He's too smooth for you right now." instead;
	if inhib is true:
		say "You hear a dangerous hooting as you go north. You run from a bunch of owls before they can carve at you with their beaks, but boy, they were quick, and it was close. You don't want to risk it again, with your powers drained." instead;

Wickeder Wire Deck is north of Anger Pit. Wickeder Wire Deck is part of otters. "Since it's been redone, there're no deer. Exotics coexist here[if adjsolve is 4], so many you think Gee, Fur Refuge[end if]. You can go back south."

after choosing notable locale objects when player is in wire deck:
	if owls are in wire deck:
		set locale priority of owls to 9;

the ocelots are plural-named reflexive animals in wire deck. description is "[if ocelots are reflexive]They glance nervously back, as if they've done something wrong[otherwise]They glance back at you, give you a finger-point you're not cool enough to give back, then ignore you in the nicest possible way[end if].". "Ocelots are making gestures here that you'd look silly making[if ocelots are reflexive]. They do, too, with their stupid sunglasses[end if]."

understand "ocelot" as ocelots.

the ocelots wear the SlopInc Clip-Ons. description of clip-ons is "Just terribly un-hip. They make the ocelots look like jive turkeys and not jive cats."

instead of doing something with the Clip-Ons:
	say "Uncool. Both the clip-ons and paying too much attention to them. And by too much, I mean any. Maybe you can help the ocelots, though."

the Look-Kool Shades are a wearable thing. description of Look-Kool is "Man! You couldn't wear them, or tell why they rout the cheap Ok-Ol[']-Look knockoffs, but the coolest ocelots can."

understand "sunglasses/glasses/shades" as SlopInc when ocelots wear SlopInc.
understand "sunglasses/glasses/shades" as Look-Kool when ocelots wear Look-Kool.

a-text of ocelots is "RYYRYRR". b-text of ocelots is "RYYPYRR".

The leopard is a reflexive animal in Deck. "A leopard is here--[if leopard is reflexive]his colorings make it look like he is wearing a tacky (mostly) burnt orange jumpsuit, and he seems paw-tied, too[else]he looks more camoflagued since you changed him[end if]."

understand "ape lord" and "apelord" as a mistake ("You [if leopard is reflexed]already changed the leopard[else]can't change what the leopard is, but you need to release him from his captivity[end if].") when player is in deck.

understand "preload" and "pre-load" and "pre load" as a mistake ("The leopard is plenty powerful as-is, [if leopard is reflexed]and it's already on your side[else]but you need to get it on your side[end if].") when player is in deck.

a-text of leopard is "RYRYRYR". b-text of leopard is "RYRYRYP".

description of leopard is "He's got those jumpsuit markings and appears to be [if leopard is reflexed]no longer [end if]handcuffed."

the jumpsuit is part of the leopard. description is "The leopard looks back at you as if sorry for some inexplicable things he did, as if hoping he's served his time.". understand "markings" as jumpsuit.

The badger is a reflexive animal in Deck. description is "[if badger is reflexed]He looks dumber with those clothes, but you aren't about to tell him[otherwise]Despite having all that fur, he seems embarrassed with his body[end if].". "[if badger is reflexed]A garbed badger stands around confidently here[otherwise]A badger covers his naughty bits that were buried under his fur anyway[end if]."

a-text of badger is "RYRRYR". b-text of badger is "RGRRGR".

understand "barged" as a mistake ("You don't want the badger to have barged into you. Clothed or not.") when player is in Deck.

understand "b grade" and "bgrade" as a mistake ("The badger [if badger is reflexive]already[else]no longer[end if] feels second-rate, so [if badger is reflexive]you need another way to help him[else]he needs no more help[end if].") when player is in Deck.

the satyr is a reflexive animal in Deck. description is "[if satyr is reflexed]He looks like he's dreaming of a poem or something, but he doesn't want to be disturbed[else]He looks preoccupied and mistrustful. His eyes stray.[end if].". "A satyr strides here, [if satyr is reflexed]dreaming of a better Yorpwald[else]looking out for himself[end if]."

a-text of satyr is "YRRRO". b-text of satyr is "YRPRO".

understand "stary" as a mistake ("What good would the satyr be, staring all the time?") when satyr is visible.

understand "stray" as a mistake ("No, you can get him on your side.") when satyr is visible.

understand "trays" as a mistake ("You can't transform something living into something dead. Besides, you don't need something that be trays. (Sorry.)") when satyr is visible.

understand "ratsy" as a mistake ("You don't want a rat on your side. Or someone who says rats too much.") when satyr is visible.

the owls are plural-named terse vanishing animals in Wire Deck. description of owls is "Their big owly eyes follow you.". "[one of]You hear hooting and a flapping of wings. You've probably triggered some sort of trap. You look up to see owls swooping. You can duck the first blow, and you maybe have time to look at your settler, but they're too speedy en masse[or]All those animals are nice, but the owls about to dive-bomb you here mean you'll need to think fast. I think[stopping]."

understand "lows" as a mistake ("Actually, you'd like the owls NOT to reach lows like you are. Or not to get there before you can avoid them.") when owls are visible.

a-text of owls is "RRYR". b-text of owls is "RRYR".

check going south in wire deck:
	if owls are in wire deck:
		say "[if inhib is true]You're not ready to deal with the owls yet[else]You'll deal with the owls later[end if].";

check going north in perverse:
	if raptor is in perverse:
		say "[if inhib is true]You're not ready to deal with the raptor yet[else]You'll deal with the raptor later[end if].";

every turn (this is the owls kill you rule):
	if owls were visible and owls are visible:
		unless the action is procedural:
			say "You were not fast enough to dispel the owls. They peck you to a death so horrible even an unemotional computer type is willing to give you a chance to change it with UNDO.";
			get-dead;
		else:
			ital-say "You'll get a mulligan for instantaneous actions like examining, but you may want to deal with those owls, or flee.";

every turn (this is the raptor kills you rule):
	if raptor was visible and raptor is visible:
		unless the action is procedural:
			say "You were not fast enough to dispel the raptor. It gobbles you so quickly and gruesomely that even an unemotional computer type is willing to give you a chance to change it with UNDO.";
			get-dead;
		else:
			ital-say "You'll get a mulligan for instantaneous actions like examining, but you may want to deal with that raptor, or flee.";

After printing the name of the letters settler while taking inventory:
	say "[set-det]";

After printing the name of a hintpastry (called the curfood) while taking inventory:
	say " [if curfood is heated](heated)[else](cold)[end if]";

to say set-det:
	say "[unless player has purse]: [end if]Cheat/teach mode is [if cheat-on is true]on[else]off[end if], slider is [if slider is switched on]on[else]off[end if] with level [headaches]";

After printing the name of the satchel while taking inventory:
	say " (somewhere in the purse)";

after printing the name of the stapler while taking inventory:
	if staple is in the stapler:
		say " (with a staple in it)";
		now staple is mentioned;
	else:
		say " (empty)";

before listing contents while taking inventory: group hintpastries together

instead of taking inventory:
	if mrlp is troves:
		if truffle is off-stage:
			say "Boy! this is a seedy area. You're worried you might get robbed of what you have.";
		if purse-stolen is true:
			say "All you have is [i]Pa, Egg, Pea[r] and your pedanto-notepad and your settler[if player has fretful truffle] and that fretful truffle[end if]. You still need to get your super purse back." instead;
	if number of things enclosed by the player is 0:
		say "Just your powers, at the moment. Nothing tangible." instead;
	now all things carried by the player are marked for listing;
	if player has lamp and player has super purse:
		say "You're carrying a lamp, for light.[paragraph break]";
		now lamp is unmarked for listing; [lamp can fit in purse but isn't useful there]
	if player has settler and player has super purse:
		say "You're carrying your letters settler, to help with hints. [set-det].[line break]";
		now settler is unmarked for listing;
	say "[if purse-stolen is true and mrlp is troves]In your hands, because you lost your super purse:[else if player has super purse]In your super purse:[else]Item time:[end if][line break]";
	if number of things enclosed by the player is 0:
		say "Nothing." instead;
	now compass is unmarked for listing;
	if player has super purse:
		now super purse is unmarked for listing;
	list the contents of the player, with newlines, indented, including contents, with extra indentation, listing marked items only;
	if number of worn things > 0:
		say "You are also wearing [a list of worn things].";
	if location of player is location of skid:
		say "[line break]There's also that skid you can push around[if number of things on skid > 0]. It holds [the list of things on skid][end if].";
	if mrlp is otters and inhib is true:
		say "You also DON'T have your full powers. You'll need to fix that before hitting the bulwark to the west.";
	if player has compass:
		say "You also have a compass to tell direction.";

silence-tally is a number that varies.

after fliptoing when player is in Anger Pit (this is the break the imp down rule) :
	increment silence-tally;
	if silence-tally is 2:
		say "The sly imp lets out a curse. He's completely failed to keep his cool. He leaves, confidence shattered. You can go past now.";
		now imp is in lalaland;
		now imp1 is in lalaland;
		now imp2 is in lalaland;
		now imp3 is in lalaland;
	continue the action;

section debug - not for release

[understand "i1" as imp1.
understand "i2" as imp2.
understand "i3" as imp3.
understand "r1" as ram1.
understand "r2" as ram2.
understand "r3" as ram3.]

chapter animaling

to say inhib:
	say "You can't summon the energy to do that. It seems it should work, but it doesn't. You may need a recharge.";

after fliptoing an animal:
	if location of player is wire deck:
		let temp be number of visible reflexed animals;
		if temp is 1:
			say "The LUCKY medal you're wearing clanks against the IQ medal. It looks a bit clearer, now.";
		else if temp is 3:
			say "The [list of visible reflexed animals] all look over at you, point and give you a thumbs-up. They glance over at the [list of visible reflexive animals] and shrug a bit, as if it can come along if it wants to. Your LUCKY medal looks very shiny now.";
		else if temp is 4:
			d "[the list of visible reflexed animals]. You get a min-up.";
			min-up;
	if location of player is perverse preserve:
		d "[number of visible animals] [the list of visible reflexed animals]--current min = [min-score of otters].";
		let temp be number of visible animals;
		if temp is 2:
			say "The IQ medal you're wearing clanks against the LUCKY medal. It looks a bit clearer, now.";
		else if temp is 4:
			say "The [list of visible animals] swarm around you in a circle a few times. You seem to have established leadership of them, whether or not you can do anything with the [random pre-animal]. Your IQ medal looks very shiny now.";
		else if temp is 5:
			min-up;
	if noun is reflexed and location of player is wickeder:
		increment adjsolve;
	continue the action;

[carry out animaling:
	if location of player is not wire deck:
		say "[reject]" instead;
	if owls are not slowed:
		say "Deal with the owls first." instead;
	repeat through table of animal-stuff:
		if my-animal entry is visible:
			if the player's command matches the text "[adjective-to-say entry]":
				if inhib is true:
					say "That would work...if you had your power back." instead;
				if my-animal entry is adjed:
					say "You already worked your magic." instead;
				say "[animal-happy entry]";
				reg-inc;
				increment adjsolve;
				if adjsolve is 4:
					min-up;
				now my-animal entry is adjed instead;
	say "[reject]" instead;]

book Rote-Moan Anteroom

Rote-Moan Anteroom is south of Bleary Barley. Anteroom is part of otters. Anteroom is innie. "[if whiners are visible]The noise here is just unbearable--men guarding the way south and not shutting up about it[else]This room is quieter now, just a north-south passage[end if]."

ram1 is privately-named unscannable reflexive ssno scenery in Anteroom. ram1 is undesc. printed name of ram1 is "the men's shouting".
ram2 is privately-named unscannable reflexive ssno scenery in Anteroom. ram2 is undesc. printed name of ram2 is "the men's shouting".
ram3 is privately-named unscannable reflexive ssno scenery in Anteroom. ram3 is undesc. printed name of ram3 is "the men's shouting".

a-text of ram1 is "RRYYRYRRO". b-text of ram1 is "RRYYRYRRB".
a-text of ram2 is "RYRRYRO". b-text of ram2 is "RGRRYPO".
a-text of ram3 is "RYYRRYRRRO". b-text of ram3 is "RYYRRYRRRO".

book perverse preserve

to say pre-desc:
	if number of animals in perverse preserve is 1:
		say "Weird. This fenced off area seems like a living area, but you don't see any animals. You think. And no pea to change to an ape.[no line break]";
		continue the action;
	else:
		say "You rescued [if nounsolve is 4]all the[else if nounsolve is 1]one of the[else]a few[end if] animals here, but it's still eerie.[no line break]";
		continue the action;

Perverse Preserve is south of Rote-Moan Anteroom. Perverse Preserve is part of otters. "[pre-desc]"

A corona is a semi-easy thing in Preserve. the corona is fixed in place. description is "It's almost like a pair of dark scavenger's eyes. You can't locate its original light source--you try to cut it off, but you can't.". "A corona of light scurries about on the floor. It may have an extra c around its edge."

a-text of corona is "RYRYYR". b-text of corona is "RYRGYR".

the racoon is an animal. description is "It looks at you trustingly, seeming to understand you rescued it.". "A racoon sits up alertly here. It has a lit tail."

a-l-t is part of the racoon. a-l-t is undesc and amusing. printed name of a-l-t is "a lit tail". understand "lit/ tail" as a-l-t.

instead of doing something with a-l-t:
	say "The racoon's tail is beautiful and eerie, but useless as far as you can tell, so it's not worth bothering with."

the thrones are plural-named things in Preserve. the thrones are fixed in place.

understand "throne" as thrones.

description of thrones is "They're made out of, not metal, but locusts. Well, not quite that."

understand "hornet" as a mistake ("The thrones are plural. Besides, just one hornet--what could it do?") when thrones are visible. [?? move to ToA]

understand "shorten" as a mistake ("[if thrones are visible]Well--not shorten, but break it down...you see red from the effort[else]They're more likely to shorten you with a few stings[end if].") when thrones are visible or hornets are visible.

a-text of thrones is "RYRRYRR". b-text of thrones is "RYPRYRP".

the hornets are plural-named animals. description is "Thankfully, they are not buzzing with intent to sting you.". "Hornets are buzzing around here."

understand "hornet" as thrones.

instead of taking the thrones:
	say "They seem abnormally sharp, as if they could sting you again and again.";

the pines are a plural-named thing in perverse Preserve. description is "The bases of the pines look almost like birds['] feet."

the pines are fixed in place.

check taking pines:
	say "The effort would crush your spine." instead;

check taking snipe:
	say "It will follow you when you call."

the snipe is an animal. description is "It has a long needle-like bill.". "A snipe is pacing around here."

a-text of pines is "RRYRY". b-text of pines is "RRYRY".

Some nails are semi-easy plural-named things in Preserve. "Some nails are lying all over the floor here."

understand "slain" and "as nil" as a mistake ("[if nails are visible]The nails are already dead as a doornail[else]You're trying to SAVE the animals, actually[end if].") when player is in preserve

description of nails is "They're in a spiral. Odd."

instead of taking nails:
	say "They're almost glued to the floor or something."

a-text of nails is "RRYYR". b-text of nails is "RRYYR".

the snail is an animal. description is "It's quite spiky and seems to move faster than your average snail.". "The spiky snail you summoned is slithering impatiently in a circle."

the shrewin' whiners are plural-named flippable people in Anteroom. description is "They blather on hopelessly, as if you should try to be as whiny as they are. [one of]Probably many of them are named Sherwin, but more importantly, m[or]M[stopping]aybe you can make them run out of energy.". "Shrewin['] whiners are [if ram1 is reflexive]tallyhoing[else]babbling[end if][if ram2 is reflexive] with great callosity[end if] here[if ram3 is reflexive]. They restyle why they can't let you go south[end if][if inhib is false]. Yet, for all their bluster, you feel like you could've taken them even before you regained your powers[end if]."

a-text of whiners is "BUG". b-text of whiners is "BUG".

check scaning imp:
	say "The settler seems to jump around with the imp a bit before stabilizing. The imp's [if silence-tally is 0]patience is legendary and butlery--but it's moving rangily[else if imp1 is in lalaland]patience is legendary and butlery[else if imp3 is in lalaland]It has a butlery air as it moves rangily[else if imp2 is in lalaland]patience feels legendary as it moves rangily[end if].";
	let tempscn be random reflexive scenery in Anger Pit;
	try scaning tempscn instead;

check scaning whiners:
	say "The settler seems to jump around a bit before stabilizing. It blinks about as they [if ram1 is reflexive]restyle[else]continue[end if] [if ram2 is reflexive]tallyhoing[else]their noisiness[end if] [if ram3 is reflexive] with callosity[end if]";
	let tempscn be random reflexive scenery in Anteroom;
	try scaning tempscn instead;

check going south in Anteroom:
	if whiners are visible:
		say "The whiners can't imagine why anyone would want to go there. They block you, for your own good. They seem to have all sorts of reasons, and there's no way past the quantity, if not the quality, of their arguments." instead;
	if inhib is true:
		say "A very loud roar scares you. You doubt adverbs are up to the task of calming it. You decide to return once you have your full powers." instead;

to say shout-check:
	say "[one of]The din loses speed, energy, nastiness and volume. A re-count of the men reveals several leavers. But even with them gone, too many men are left blocking the way south.[no line break][or]Slowly, conversation dwindles until it leaves every hassler rahless, slasher of noise. They find another place where rioters roister.[no line break][stopping]";

quietness is a number that varies.

after fliptoing when player is in Anteroom (this is the de-tallyho rule) :
	increment quietness;
	if quietness is 2:
		say "As they sulk away, they whimper about that bum Ed Riley who got a more exciting post than they did despite his moving so weedily[if ed riley is in Bleary Barley]. You're a bit sad you couldn't dispatch that loudmouth yet, but yay, working your enemies against each other[end if].";
		now printed name of Anteroom is "Near-Moot Anteroom";
		now whiners are in lalaland;
		now ram1 is in lalaland;
		now ram2 is in lalaland;
		now ram3 is in lalaland;
	continue the action;

chapter raptor trap

the raptor is an animal in Perverse Preserve. description is "It's small for a raptor, but that's all relative. It's still bigger than most mythical beasts, but it's also oddly colored, red and yellow and green and purple patches. But it's still dangerous.". "[one of]You hear a hollow ol['] howl and a pounding of very large paws. You may've triggered some silent trap--a huge raptor comes into view, though it is too big to follow you back north[or]A nervous, ravenous raptor squawks and roars[stopping]."

before entering thrones:
	say "You try to sit on the thrones, by you feel a stinging." instead;

Rule for choosing notable locale objects for the preserve (this is the raptor last rule):
	if raptor is in preserve:
		set the locale priority of raptor to 9;
		set the locale priority of nails to 2;
		set the locale priority of thrones to 2;
		set the locale priority of pines to 2;
		set the locale priority of corona to 2;
	continue the action;

the parrot is a vanishing animal. description is "Pretty much every color of the rainbow.". "A multi-colored parrot flutters about, here."

the parrot wears the weltish whistle.

check fliptoing raptor:
	if location of player is not alcoves:
		say "'Awk! I'd just kill you in that form. Try that around some bad guys.'" instead;

every turn when parrot is visible (this is the parrot-chat rule):
	if location of player is alcoves:
		say "The parrot hides out of sight of Elmer and Merle, eyeing them evilly.";
	else if location of player is wire deck:
		if number of visible reflexive animals is 0:
			say "'Awwk! Happy animals! They might do something for you some day, adventurer!'";
			continue the action;
		say "The parrot notes the [list of reflexive animals] [if number of visible reflexive animals > 1]don't[else]doesn't[end if] look happy.";
	else if location of player is wire deck:
		if number of visible animals is 6:
			say "The parrot flies around all the animals.";
		else:
			say "The parrot pokes at the [list of nonreflexive things in preserve][if number of nonreflexive things in preserve > 1] in turn[end if].";


a-text of raptor is "RYRRYR". b-text of raptor is "RGRRGR".
a-text of parrot is "RYRRYR". b-text of parrot is "RGRRGR".

raptor-trap is a truth state that varies. raptor-trap is false.

after fliptoing parrot:
	preef parrot;
	continue the action;

book Reclusion Inclosure

hydra-known is a truth state that varies.

check going west in Alcoves (this is the need quick rule):
	if parrot is in lalaland and raptor is in lalaland:
		if medals are not reflexed:
			say "Your medals clink as you go west. Elvira hears them and ambushes you! She touches what you recognize as the Ultimate Mutilate-It Amulet and fires the legendary Phrase Shaper Phaser at you. You think of possible replies, of ways to block her, as you slump to the ground. But you are not fast enough. Your last thought is of the medals Gretta gave you that you never quite used.";
			get-dead;
			follow the shutdown rules instead;
		continue the action;
	if hydra is in Reclusion Inclosure:
		now hydra-known is true;
		say "Stricter critters restrict--wait, no, that's a hardy hydra with an HD-Ray. Er, dang. Danger[if parrot is visible]. Your friend the parrot gives a helpful AWWWK as y[else]Y[end if]ou run out of sight." instead;
	say "[one of]You pass asps and feel live evil enduringly underlying...you yell 'Time's Up! Impetus imputes...'[paragraph break]'Um, spite? I'm upset!' Elvira shrugs. 'Spume it.'[or]A punitive invite-up calls you back.[or]'Resenter re-enters!' Elvira laughs.[stopping]";

after printing the locale description for Inclosure when Inclosure is unvisited:
	if Inclosure is unvisited:
		say "'Proceedings precognised. Rats, the...eh, start the arts,' Elvira mutters as she pulls out the Ultimate Mutilate-It Amulet! A blast of energy flies at you, and reflexively, you yell 'Ail ME? Tut!' The ray fizzles.[paragraph break]'Ooh! Stout! ... Shootout!' She pulls out her phrase shape phaser, but you hum an e-sharp to deflect it. 'Won't kill a know-it-all.'[paragraph break]'Intact? It can't! SPAWN, Pawns!' she cries. 'P. S. Naw,' you say.[paragraph break]Elvira gives a crusty curtsy. 'Oh! Most smooth,' she says, with indulga-languid calm, i.e. malice, and hi-grade hid rage. And the sort of tinkly laugh you always felt forced to trust. 'You temporarily disabled my purple pulper and oranger groaner. I can't attack you first--but, details! You have to admit it was clever, filling Yorpwald with annoying anagrams to frame you!'[paragraph break]And you almost do. She has that glibness blessing! You're almost suckered, yourself. You may need fighters impervious to her charms to get rid of her for good.[paragraph break](Push any key.)[wfak]";
		say "'Gah, hag!' you say.[paragraph break]'Neat ante. Gas [']em, mages!' But they aren't there. 'Me, cry mercy?'[paragraph break]Stalemate. Lame state. Unless you have a way to kill her[if number of reflexive animals in wire deck > 1 or number of pre-animal things in preserve > 1]. Or round up more troops[end if].";
		if do-i-chat is true:
			now qbc_litany is litany of Elvira;
		else:
			try talking to Elvira;
	else:
		say "'Serious issue, or...?'";

Reclusion Inclosure is an innie room in otters. Reclusion Inclosure is west of Alcoves. "You feel as slowed here as you did on entering the barley field. Vast vats emit sour moisture over a prey pyre. The room is cluttered with a stocked stockade, a torpid tripod (slowing you down,) and entrances to a warpish warship and becharm-chamber. That nacht-chant could be coming from any of them. You can leave to the east."

the torpid tripod is amusing scenery in Inclosure. tripod is an undesc.

instead of doing something with the torpid tripod:
	say "It's too far away to do anything with and survive. For your purposes, it's just one more bit of evil scenery."

the becharm chamber is amusing scenery in Inclosure. chamber is an undesc.

instead of doing something with the becharm chamber:
	say "It's too far away to do anything with. For your purposes, it's just one more bit of evil scenery."

understand "aliver" as a mistake ("For whatever reason, you decide to give Elvira even more power. This time, you don't have the time or guts to reject her phaser.[uurrgg]")

understand "drop it" as a mistake ("For whatever reason, you just decide to give up. Elvira cackles. 'I knew you'd see it my way.' You wind up apologizing on national TV for getting too big for your anagramming britches and accepting a general brainwashing to boot. It's not that bad, only because, well, um, it just isn't. You're thrown in a jail, which can't be anagrammed, but it's for your own good. You're cool with that.[uurrgg]") when player is in Inclosure.

understand "prod it" as a mistake ("You prod curiously at the machinery, and soon, Elvira realizes you don't have anything up your sleeve, and you won't be able to retreat in time. The purple pulper and the rest of her army subdue you easily.[uurrgg]") when player is in Inclosure.

understand "sherpa" as a mistake ("You don't need someone to help you climb. You need help fighting Elvira.") when player is in Inclosure.

the nacht chant is amusing scenery in Inclosure. chant is undesc.

instead of doing something with nacht chant:
	say "You--you're almost getting used to the nacht chant."

the vast vats are amusing plural-named scenery in Inclosure. vats are undesc.

instead of doing something with vast vats:
	say "The vats are far away, but you can smell sulfinyl in them reeking sinfully--no silly fun."

carry out going east in Reclusion Inclosure:
	if do-i-chat is true:
		say "This should not happen in full release mode, but all you can do is blow the whistle to win." instead;
	say "You leave her sin shrine before getting a shiner.[paragraph break]Elvira mocks you[one of], but makes no attack[or] again[stopping]: [randbla]";
	now Elvira-delay is 0;
	continue the action;

the roarings garrison is amusing scenery in Inclosure. garrison is undesc.

the warpish warship is amusing scenery in Inclosure. warship is undesc.

instead of doing something with warship:
	say "You'll never do anything with the warship on your own. But defeating Elvira will probably disable it."

a stocked stockade is amusing scenery in Reclusion Inclosure. stockade is undesc.

instead of doing something with stockade:
	say "You shudder to think what you could do with it--or what it could do to you."

Elvira is a woman in Reclusion Inclosure. understand "necro/crone" and "necro-crone" and "necrocrone" as Elvira. "[one of]It's Elvira! The necro-crone![paragraph break]'Coren,' she cries, over the rapidly vaporizing body of her pet hydra.[or]Elvira seems impatient for you to make a move.[stopping]". description is "Elvira's actually quite attractive. Sterling ringlets. She looks like a seraph even with that phrase-shaper-phaser. Though her beauty makes you say yea, but..."

Elvira wears the Ultimate Mutilate-It Amulet.

the mutilate-it amulet is amusing. description is "It's very bare except for the words 'Um...a title?' on it."

instead of doing something with the mutilate-it amulet:
	if action is procedural:
		continue the action;
	say "Hm, best not to try anything. It can't zap you if you don't mess with it."

The phrase shaper phaser is an amusing thing. Elvira carries the phaser. description of phaser is "It's curvy and futuristic and gives her the grained endearing to look more like a seraph than an amused medusa."

instead of doing something with the phaser:
	if action is procedural:
		continue the action;
	say "You heard rumors. But you did not believe it was true. She can just say something, hit someone with it, and make you forget what you were doing. Even if the amulet doesn't work on you." instead;

check talking to Elvira when current quip is final-quip:
	say "'[one of]Neat lob. Notable. Bleat on!' [or]State nag?! Stagnate!' [in random order] Reason won't work, here." instead;

every turn when current quip is final-quip and player is in Inclosure:
	say "Cordial, cold air. [one of]'Make a diss, punk? Kiss and make up!' She pauses. 'Enough of this anagram nonsense! That's playing YOUR game. It's not like YOU ALONE can kill me. No person is brave enough to join you.' [or][stopping][one of]Elvira points out you're just jealous she got here on charisma.[or]Elvira mentions she's making ot