/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// OutputStream.cpp: implementation of the COutputStream class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "event.h"

#include "OutputStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CWinAceView *COutputStream::p_view;
CString COutputStream::face=_T("Arial");
int COutputStream::size = 120;
CList < CEvent, CEvent >COutputStream::eventList;

COutputStream::COutputStream( CWinAceView *theview)
{
p_view = theview;

}

COutputStream::COutputStream()
{
}

COutputStream::~COutputStream()
{

}

void COutputStream::WriteDesc(CString Description, int ScreenMode)
{
	ClearScreen();
	Write(Description); //remove the final newline
}


void COutputStream::Write(CString Text)
{
  eventList.AddTail( CEvent( EVT_TEXT, 0, FormatString(Text) ) );
}

void COutputStream::StartWrite()
{
}

void COutputStream::RawWrite( CString Text )
{
 eventList.AddTail( CEvent( EVT_TEXT, 0, Text ) );
}

void COutputStream::EndWrite()
{
 eventList.AddTail( CEvent( EVT_TEXT, 0, CString("") ));
}

void COutputStream::WriteLine(CString Text)
{
	Write( Text );
	Write(_T("<BR/>"));
}

CString COutputStream::FormatString( CString Text )
{

	int index=0;
	while ( (index = Text.Find('\n')) != -1 )
	{	
		Text.SetAt( index,' ' );
		Text.Insert( index,_T("<br/>"));
	}

	return Text;
}


void COutputStream::ClearScreen()
{
	eventList.AddTail( CEvent( EVT_CLS, 0, CString("") ));
}

void COutputStream::SetFont( CString fontName, int pointSz )
{
	face = fontName;
	size = pointSz;
}



void COutputStream::AddHTML(CString)
{

}

void COutputStream::ClearHTML()
{

}

void COutputStream::SetView(CWinAceView *newView)
{
 p_view = newView;
}

bool COutputStream::empty()
{
	return eventList.IsEmpty();
}

CEvent COutputStream::getNextEvent()
{
	
 return eventList.RemoveHead();
}

void COutputStream::addStart()
{
	eventList.AddTail( CEvent( EVT_TEXT,0, CString("") ) );
}

void COutputStream::AddWaitKey()
{
	eventList.AddTail( CEvent( EVT_ANYKEY,0, CString("") ) );
}

void COutputStream::AddFinish()
{
	eventList.AddTail( CEvent( EVT_FINISHED,0,CString("")));
}

void COutputStream::AddPause(int seconds)
{
	eventList.AddTail( CEvent( EVT_PAUSE, seconds, CString("") ));
}

void COutputStream::AddEnd(CString prompt)
{
	eventList.AddTail( CEvent( EVT_END, 0, prompt ) );
}

void COutputStream::AddQuit(CString prompt)
{
	eventList.AddTail( CEvent( EVT_QUIT, 0, prompt ) );
}

void COutputStream::flush()
{
	eventList.RemoveAll();
}

CString COutputStream::getFontName()
{
	return face;
}

int COutputStream::getFontSze()
{
	return size;
}


void COutputStream::clearEvents()
{
	flush();
}
