/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// MessageList.cpp: implementation of the CMessageList class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "MessageList.h"
#include "OutputStream.H"
#include "RuntimeError.h"
#include "CVocab.HPP"
#include "CParser.HPP"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
IMPLEMENT_SERIAL( CMessageList, CObject, 1)




CMessageList::CMessageList()
{
  Messages.SetSize(5000);
  OutStream = new COutputStream();
}

CMessageList::~CMessageList()
{
delete OutStream;
}

CString CMessageList::GetMessage( int MessNo )
{
    if ( MessNo > MaxMessages )
		throw( new CRuntimeError ((LPCTSTR)"Fatal Error : Attempt to Access Unkown Message - ",MessNo ));

	return Messages[MessNo];
}

void CMessageList::SetMessage( int MessNo, CString Message)
{
	Messages[MessNo]=Message;
}

void CMessageList::Serialize( CArchive &ar )
{

	CString temp;
	if ( ar.IsStoring() )
	{
		ar<<MaxMessages;

		for ( int count=0; count <= MaxMessages; count++ )
		{

			ar<<Messages[count];
		}
	}
	else
	{
		ar >> MaxMessages;
		for ( int count=0; count <= MaxMessages; count++ )
		{
			ar>>Messages[count];	
			if ( Messages[count].GetLength() > 1 )
			{
				if ( Messages[count].GetAt(Messages[count].GetLength()-1) == '\n' )
				{
					Messages[count].Delete( Messages[count].GetLength()-1,1);
				}
			}
		
		}
	}
	
}

CString CMessageList::FormatMessage( CString Message, CParser *parser )
{
	CVocab *vocab = parser->vocabulary;
	CString newMessage( Message );

	newMessage.Replace( _T("^N1"),  CString(parser->getNoun1()) );
	newMessage.Replace( _T("^N2"), CString(parser->getNoun2()) );
	newMessage.Replace( _T("^V1"), CString(parser->getVerb()) );
	newMessage.Replace( _T("^A1"), CString(parser->getAdjective1()) );
	newMessage.Replace( _T("^A2"), CString(parser->getAdjective2()) );
	newMessage.Replace( _T("^AV"), CString(parser->getAdVerb()) );

	return newMessage;
}


int CMessageList::PrintMessage(int Message, CString CurrentObject, CParser *parser)
{
int uspointer;
CString Temp;

if ( Message > MaxMessages ) 
	throw ( new CRuntimeError (_T("Fatal Error : Attempt to Access Unkown Message - "),Message ));
	

Temp = CString( Messages[ Message ] );

Temp.Replace(_T("_"), CurrentObject );

CString formattedMessage = this->FormatMessage( Temp, parser );

OutStream->Write( formattedMessage );

/*if ( ( uspointer = Messages[Message].Find('_') ) == -1 )
{
	Temp = FormatMessages[Message];
	OutStream->Write( Temp );
	return 0;
}

else 

{	
	Temp = Messages[Message].Left(uspointer);
	OutStream->Write(Temp);

	Temp = CurrentObject;
	OutStream->Write(Temp);

	Temp = Messages[Message].Right( Messages[Message].GetLength() - ( uspointer + 1));
	OutStream->Write(Temp);

}*/

return 1;

}

int CMessageList::PrintRawMessage(int Message, CString CurrentObject)
{
int uspointer;
CString Temp;

if ( Message > MaxMessages ) 
	throw ( new CRuntimeError (CString("Fatal Error : Attempt to Access Unkown Message - "),Message ));
	
if ( ( uspointer = Messages[Message].Find('_') ) == -1 )
{
	Temp = Messages[Message];
	OutStream->RawWrite( Temp );
	return 0;
}

else 

{	
	Temp = Messages[Message].Left(uspointer);
	OutStream->RawWrite(Temp);

	Temp = CurrentObject;
	OutStream->RawWrite(Temp);

	Temp = Messages[Message].Right( Messages[Message].GetLength() - ( uspointer + 1));
	OutStream->RawWrite(Temp);

}
	return 1;

}



bool CMessageList::validate(int MessageNo)
{
 if (MessageNo > MaxMessages ) return false;
	return true;

}
