/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// FlagsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "WinAce.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "FlagTable.h"
#include "FlagsDialog.h"
#include "IntValueDialog.h"


/////////////////////////////////////////////////////////////////////////////
// CFlagsDialog dialog


CFlagsDialog::CFlagsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CFlagsDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFlagsDialog)
	//}}AFX_DATA_INIT
	p_FlagTable = NULL;


}



void CFlagsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFlagsDialog)
	DDX_Control(pDX, IDC_LIST1, m_flagList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFlagsDialog, CDialog)
	//{{AFX_MSG_MAP(CFlagsDialog)
	ON_BN_CLICKED(IDHIDE, OnHide)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST1, OnDblclkList1)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_LIST1, OnGetdispinfoList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFlagsDialog message handlers

BOOL CFlagsDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_flagList.InsertColumn( 0,_T("Flag Number"), LVCFMT_CENTER, 80 );
	m_flagList.InsertColumn(1,_T("Flag Value"), LVCFMT_CENTER, 80 );
	m_flagList.InsertColumn(2,_T("Description"), LVCFMT_LEFT, 150 );
	m_flagList.SetItemCount(1999);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFlagsDialog::updateFlags()
{

}

void CFlagsDialog::setFlagTable(CFlagTable *p_FlagTable2)
{
	p_FlagTable = p_FlagTable2;
}


void CFlagsDialog::OnHide() 
{
	ShowWindow( SW_HIDE);	
}

void CFlagsDialog::OnDblclkList1(NMHDR* pNMHDR, LRESULT* pResult) 
{

	int selection = m_flagList.GetSelectionMark();
		
	if ( selection != -1 )
	{
		CIntValueDialog valueDlg;
		valueDlg.m_newValue = p_FlagTable->GetFlag( selection );
		if ( valueDlg.DoModal() == IDOK )
		{
			p_FlagTable->SetFlag( selection, valueDlg.m_newValue );
			m_flagList.RedrawItems( selection, selection);
				
		}
	}

	
	*pResult = 0;
}

void CFlagsDialog::OnGetdispinfoList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	LV_ITEM* item = &pDispInfo->item;

	if (item->mask & LVIF_TEXT) //valid text buffer?
	{
		wchar_t buffer[10]=_T("\0\0\0\0\0\0\0\0\0");
		if ( item->iSubItem == 0 )
		{
		    wsprintf(buffer, _T("%d"), item->iItem);
			wcsncpy(  pDispInfo->item.pszText,buffer, 6 );
			item->mask =  LVIF_DI_SETITEM;

			
		}
		
		if ( item->iSubItem == 1 )
		{
		    wsprintf( pDispInfo->item.pszText, _T("%d"), p_FlagTable->GetFlag( item->iItem));
		//	::mbstowcs(  (unsigned short*)pDispInfo->item.pszText,buffer, 6 );
			
		}

    }

		*pResult = 0;
}
