/* getaline.c - routines used to read a line in vary length 
 * Copyright (C) 2005, 2006, 2007 Jia Wang <skyroam@gmail.com>
 *
 *
 *
 * This file is part of GNU Proxyknife.
 * GNU Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 3 of the License, or (at your 
 * option) any later version.
 *
 * GNU Proxyknife is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */

#include <proxyknife.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
/* Read a entire line and store the address of the buffer  containing
   the text into *line. The buffer is newline-terminated.

   If *line is NULL, getaline() routine will allocate a new buffer in 
   engough size(try  *size firstly)  to contain the text. 
   If *line is too small to contain the entire line, the 
   routine will realloc buffer until it is big enough. 
   
   So *line should be free by user.
   
   SIZE: size of init-buffer if *line == NULL.
   
   Return value:
   -1: failed.
   number of characters including \n: sucess.
   */
/* need a speed version including last line */
/* fgets may no use for lines in every length */
int
getaline_old (unsigned char **line, int *size, FILE * f)
{
  unsigned char *p, *q, ret;
  int offset, n, D = 256;

  if (*size <= 0)
    return -1;

  if (*line == NULL)
    {
      p = xmalloc (*size);
      /*if (p == NULL)
	{*/
	  /* *line = NULL;		*//*no memory allocated,no need clean mem */
	  /* return -1; */
	  /*xexit (EXIT_FAILURE);
	}*/
    }
  else
    {
      p = *line;
    }

  offset = 0;
  while (1)
    {
      if (offset + 2 > *size)
	{
	  *size += D;
	  q = xrealloc ((void *) p, *size);
	  /*
	     if (q == NULL)
	     { */
	  /* this will not work if realloc destroy p for bug */
	  *line = p;
	  /* return -1; */
	  /*xexit (EXIT_FAILURE);
	     }
	     else */
	  p = q;
	}
      n = fread (p + offset, 1, 1, f);
      if (n != 1)
	{
	  *line = p;
	  return -1;
	}
      if (p[offset] == '\n')
	{
	  p[offset + 1] = '\0';	/* total offset+2 len */
	  *line = p;
	  return (offset + 1);	/* including '\n'; */
	}
      offset++;
    }
}

/* Read a line into *line. 
   The size of block *line point to will be *size. 

   If *line !=NULL, free it before call. 

   Do not update *line,*size, until success. */
int
getaline (unsigned char **line, int *size, FILE * f)
{
  unsigned char *p, *q;
  int offset, n, D = 256;
  int psize;


  psize = D;

  p = xmalloc(psize);
  offset = 0;
  while (1)
    {
      if (offset + 2 > psize)
	{
	  psize += D;
	  q = xrealloc ((void *) p, psize); 
      /* Fail to exit main process without free! */
	  p = q;
	}
      n = fread (p + offset, 1, 1, f);
      if (n != 1)
	{
	  xfree((void **)&p); 
	  return -1;
	}
      if (p[offset] == '\n')
	{
	  p[offset + 1] = '\0';	/* total offset+2 len */
	  if(*line != NULL) xfree((void **)line);
      *line = p;
      *size = psize;
	  return (offset + 1);	/* including '\n'; */
	}
      offset++;
    }
}


/* The same as above,but used between pthread mutex.
   Inner mutex was used in pmalloc and prealloc. 
   Use fgets for performance,so it should be protected by the  
   mutex outside.

   The struct thread_mem is only used for pmalloc and prealloc. 

   No change  to *line,*size unless  succeeding in reading a line.
   If *line!=NULL, it will be free before update. 
   The var *size will be update, and not be use as  init value for buffer.
 */


int
getaline_r (char **line, int *size, FILE * f, 
                struct thread_mem *thread_mem)
{
  char *p, *q, *s;
  int offset, n, D = 256, linelen = 80;
  size_t len;
  int psize;

  /* default size */
  psize = D;

  /* Use a internal memory.Tt will waste some memory.
     but can avoid of exiting  with wrong realloc to *line before 
     read call. Though  *size can be used  to reover the orignal buffer
     ,it may not reflected the real blocksize with wrong call. 
     */

  p = pmalloc(*size,thread_mem);
  if( p == NULL)
          return PROXYKNIFE_THREAD_EXIT;

  offset = 0;
  while (1)
    {
      if (offset + linelen > psize)
	{
	  psize = offset + linelen + D;
	  q = prealloc (p, psize, thread_mem);
	  if (q == NULL){
              if(p!=NULL) {
                      pxfree((void **)&p);
              }
	    return PROXYKNIFE_THREAD_EXIT;
      }
	  p = q;
	}

      /* ftell */
      s = fgets (p + offset, linelen, f);
      /* ftell ,sub= read */


      if (s == NULL)
	{
	  pxfree((void **)&p);
            return -1;		/*  end of file or errors */
	}
      else
	{
	  len = strlen (p + offset);	/* count before NULL, ignore others */
	  if (*(p + offset + len - 1) == '\n')
	    {
                /* update *line,*size */
                if(*line != NULL) pxfree((void **)line);
	      *line = p;
          *size = psize;
	      return (offset + len);	/* including '\n'; */
	    }
	  else
	    {
	      offset += len;
	    }
	}
    }
}
