# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.31
#
# Don't modify this file, modify the SWIG interface instead.
# This file is compatible with both classic and new-style classes.

"""
This is a wrapper for The CD Input and Control library (libcdio) which
encapsulates CD-ROM reading and control. Python programs wishing to be
oblivious of the OS- and device-dependent properties of a CD-ROM can
use this library.
"""

import _pycdio
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


CDIO_READ_MODE_AUDIO = _pycdio.CDIO_READ_MODE_AUDIO
CDIO_READ_MODE_M1F1 = _pycdio.CDIO_READ_MODE_M1F1
CDIO_READ_MODE_M1F2 = _pycdio.CDIO_READ_MODE_M1F2
CDIO_READ_MODE_M2F1 = _pycdio.CDIO_READ_MODE_M2F1
CDIO_READ_MODE_M2F2 = _pycdio.CDIO_READ_MODE_M2F2
cdio_read_sectors = _pycdio.cdio_read_sectors
cdio_eject_media_drive = _pycdio.cdio_eject_media_drive
VERSION_NUM = _pycdio.VERSION_NUM
INVALID_LBA = _pycdio.INVALID_LBA
INVALID_LSN = _pycdio.INVALID_LSN
CD_FRAMESIZE = _pycdio.CD_FRAMESIZE
CD_FRAMESIZE_RAW = _pycdio.CD_FRAMESIZE_RAW
ISO_BLOCKSIZE = _pycdio.ISO_BLOCKSIZE
M2F2_SECTOR_SIZE = _pycdio.M2F2_SECTOR_SIZE
M2RAW_SECTOR_SIZE = _pycdio.M2RAW_SECTOR_SIZE

def audio_pause(*args):
  """
    audio_pause(cdio)->status

    Pause playing CD through analog output.
    """
  return _pycdio.audio_pause(*args)

def audio_play_lsn(*args):
  """
    auto_play_lsn(cdio, start_lsn, end_lsn)->status

    Playing CD through analog output at the given lsn to the ending lsn
    """
  return _pycdio.audio_play_lsn(*args)

def audio_resume(*args):
  """
    audio_resume(cdio)->status
    Resume playing an audio CD.
    """
  return _pycdio.audio_resume(*args)

def audio_stop(*args):
  """
    audio_stop(cdio)->status
    Stop playing an audio CD.
    """
  return _pycdio.audio_stop(*args)
READ_MODE_AUDIO = _pycdio.READ_MODE_AUDIO
READ_MODE_M1F1 = _pycdio.READ_MODE_M1F1
READ_MODE_M1F2 = _pycdio.READ_MODE_M1F2
READ_MODE_M2F1 = _pycdio.READ_MODE_M2F1
READ_MODE_M2F2 = _pycdio.READ_MODE_M2F2

def lseek(*args):
  """
    lseek(cdio, offset, whence)->int
    Reposition read offset
    Similar to (if not the same as) libc's fseek()

    cdio is object to get adjested, offset is amount to seek and 
    whence is like corresponding parameter in libc's lseek, e.g. 
    it should be SEEK_SET or SEEK_END.

    the offset is returned or -1 on error.
    """
  return _pycdio.lseek(*args)

def read_cd(*args):
  """
    read_cd(cdio, size)->[size, data]

    Reads into buf the next size bytes.
    Similar to (if not the same as) libc's read()

    The number of reads read is returned. -1 is returned on error.
    """
  return _pycdio.read_cd(*args)

def read_sectors(*args):
  """
    read_sectors(bytes, lsn, read_mode)->[size, data]
    Reads a number of sectors (AKA blocks).
      
    lsn is sector to read, bytes is the number of bytes.

    If read_mode is pycdio.MODE_AUDIO, the return buffer size will be
    truncated to multiple of pycdio.CDIO_FRAMESIZE_RAW i_blocks bytes.

    If read_mode is pycdio.MODE_DATA, buffer will be truncated to a
    multiple of pycdio.ISO_BLOCKSIZE, pycdio.M1RAW_SECTOR_SIZE or
    pycdio.M2F2_SECTOR_SIZE bytes depending on what mode the data is in.
    If read_mode is pycdio.CDIO_MODE_M2F1, buffer will be truncated to a 
    multiple of pycdio.M2RAW_SECTOR_SIZE bytes.

    If read_mode is CDIO_MODE_M2F2, the return buffer size will be
    truncated to a multiple of pycdio.CD_FRAMESIZE bytes.

    If size <= 0 an error has occurred.
    """
  return _pycdio.read_sectors(*args)

def read_data_bytes(*args):
  """
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).
      
    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
  return _pycdio.read_data_bytes(*args)
TRACK_FORMAT_AUDIO = _pycdio.TRACK_FORMAT_AUDIO
TRACK_FORMAT_CDI = _pycdio.TRACK_FORMAT_CDI
TRACK_FORMAT_XA = _pycdio.TRACK_FORMAT_XA
TRACK_FORMAT_DATA = _pycdio.TRACK_FORMAT_DATA
TRACK_FORMAT_PSX = _pycdio.TRACK_FORMAT_PSX
CDIO_TRACK_FLAG_FALSE = _pycdio.CDIO_TRACK_FLAG_FALSE
CDIO_TRACK_FLAG_TRUE = _pycdio.CDIO_TRACK_FLAG_TRUE
CDIO_TRACK_FLAG_ERROR = _pycdio.CDIO_TRACK_FLAG_ERROR
CDIO_TRACK_FLAG_UNKNOWN = _pycdio.CDIO_TRACK_FLAG_UNKNOWN
CDIO_CDROM_LBA = _pycdio.CDIO_CDROM_LBA
CDIO_CDROM_MSF = _pycdio.CDIO_CDROM_MSF
CDIO_CDROM_DATA_TRACK = _pycdio.CDIO_CDROM_DATA_TRACK
CDIO_CDROM_CDI_TRACK = _pycdio.CDIO_CDROM_CDI_TRACK
CDIO_CDROM_XA_TRACK = _pycdio.CDIO_CDROM_XA_TRACK
AUDIO = _pycdio.AUDIO
MODE1 = _pycdio.MODE1
MODE1_RAW = _pycdio.MODE1_RAW
MODE2 = _pycdio.MODE2
MODE2_FORM1 = _pycdio.MODE2_FORM1
MODE2_FORM2 = _pycdio.MODE2_FORM2
MODE2_FORM_MIX = _pycdio.MODE2_FORM_MIX
MODE2_RAW = _pycdio.MODE2_RAW
INVALID_TRACK = _pycdio.INVALID_TRACK
CDROM_LEADOUT_TRACK = _pycdio.CDROM_LEADOUT_TRACK

def get_first_track_num(*args):
  """
    get_first_track_num(p_cdio) -> int
    Get the number of the first track. 

    return the track number or pycdio.INVALID_TRACK if there was
    a problem.
    """
  return _pycdio.get_first_track_num(*args)

def get_last_track_num(*args):
  """
    get_last_track_num 
    Return the last track number.
    pycdio.INVALID_TRACK is if there was a problem.
    """
  return _pycdio.get_last_track_num(*args)

def get_track(*args):
  """
    cdio_get_track(lsn)->int

        Find the track which contains lsn.
        pycdio.INVALID_TRACK is returned if the lsn outside of the CD or
        if there was some error. 
        
        If the lsn is before the pregap of the first track, 0 is returned.
        Otherwise we return the track that spans the lsn.
    """
  return _pycdio.get_track(*args)

def get_track_channels(*args):
  """
    get_track_channels(cdio, track)->int

    Return number of channels in track: 2 or 4; -2 if implemented or -1
    for error.  Not meaningful if track is not an audio track.
    """
  return _pycdio.get_track_channels(*args)

def get_track_copy_permit(*args):
  """
    get_copy_permit(cdio, track)->int

    Return copy protection status on a track. Is this meaningful 
    not an audio track?

    """
  return _pycdio.get_track_copy_permit(*args)

def get_track_format(*args):
  """
    get_track_format(cdio, track)->format

    Get the format (audio, mode2, mode1) of track. 
    """
  return _pycdio.get_track_format(*args)

def is_track_green(*args):
  """
    is_track_green(cdio, track) -> bool

    Return True if we have XA data (green, mode2 form1) or
    XA data (green, mode2 form2). That is track begins:
     sync - header - subheader
    12     4      -  8
        
    FIXME: there's gotta be a better design for this and get_track_format?
    """
  return _pycdio.is_track_green(*args)

def get_track_last_lsn(*args):
  """
    cdio_get_track_last_lsn(cdio, track)->lsn

    Return the ending LSN for track number
    track in cdio.  CDIO_INVALID_LSN is returned on error.
    """
  return _pycdio.get_track_last_lsn(*args)

def get_track_lba(*args):
  """
    cdio_get_track_lba  
        Get the starting LBA for track number
        i_track in p_cdio.  Track numbers usually start at something 
        greater than 0, usually 1.

        The 'leadout' track is specified either by
        using i_track CDIO_CDROM_LEADOUT_TRACK or the total tracks+1.

        @param p_cdio object to get information from
        @param i_track  the track number we want the LSN for
        @return the starting LBA or CDIO_INVALID_LBA on error.
    """
  return _pycdio.get_track_lba(*args)

def get_track_lsn(*args):
  """
    cdio_get_track_lsn (cdio, track)->int

    Return the starting LSN for track number. 
    Track numbers usually start at something greater than 0, usually 1.

    The 'leadout' track is specified either by
    using i_track pycdio.CDROM_LEADOUT_TRACK or the total tracks+1.

    pycdio.INVALID_LSN is returned on error.
    """
  return _pycdio.get_track_lsn(*args)

def get_track_msf(*args):
  """
    get_track_msf(cdio,track)->string

      Return the starting MSF (minutes/secs/frames) for track number
      track.  Track numbers usually start at something 
      greater than 0, usually 1.

      The 'leadout' track is specified either by
      using i_track CDIO_CDROM_LEADOUT_TRACK or the total tracks+1.
        
    @return string mm:ss:ff if all good, or string 'error' on error.
    """
  return _pycdio.get_track_msf(*args)

def get_track_preemphasis(*args):
  """
    cdio_get_track_preemphasis(cdio, track)

    Get linear preemphasis status on an audio track.
    This is not meaningful if not an audio track?
    """
  return _pycdio.get_track_preemphasis(*args)

def get_track_sec_count(*args):
  """
    get_track_sec_count(cdio, track)->int

    Get the number of sectors between this track an the next.  This
    includes any pregap sectors before the start of the next track.
    Track numbers usually start at something 
    greater than 0, usually 1.

    0 is returned if there is an error.
    """
  return _pycdio.get_track_sec_count(*args)
DRIVE_CAP_ERROR = _pycdio.DRIVE_CAP_ERROR
DRIVE_CAP_UNKNOWN = _pycdio.DRIVE_CAP_UNKNOWN
DRIVE_CAP_MISC_CLOSE_TRAY = _pycdio.DRIVE_CAP_MISC_CLOSE_TRAY
DRIVE_CAP_MISC_EJECT = _pycdio.DRIVE_CAP_MISC_EJECT
DRIVE_CAP_MISC_LOCK = _pycdio.DRIVE_CAP_MISC_LOCK
DRIVE_CAP_MISC_SELECT_SPEED = _pycdio.DRIVE_CAP_MISC_SELECT_SPEED
DRIVE_CAP_MISC_SELECT_DISC = _pycdio.DRIVE_CAP_MISC_SELECT_DISC
DRIVE_CAP_MISC_MULTI_SESSION = _pycdio.DRIVE_CAP_MISC_MULTI_SESSION
DRIVE_CAP_MISC_MEDIA_CHANGED = _pycdio.DRIVE_CAP_MISC_MEDIA_CHANGED
DRIVE_CAP_MISC_RESET = _pycdio.DRIVE_CAP_MISC_RESET
DRIVE_CAP_MISC_FILE = _pycdio.DRIVE_CAP_MISC_FILE
DRIVE_CAP_READ_AUDIO = _pycdio.DRIVE_CAP_READ_AUDIO
DRIVE_CAP_READ_CD_DA = _pycdio.DRIVE_CAP_READ_CD_DA
DRIVE_CAP_READ_CD_G = _pycdio.DRIVE_CAP_READ_CD_G
DRIVE_CAP_READ_CD_R = _pycdio.DRIVE_CAP_READ_CD_R
DRIVE_CAP_READ_CD_RW = _pycdio.DRIVE_CAP_READ_CD_RW
DRIVE_CAP_READ_DVD_R = _pycdio.DRIVE_CAP_READ_DVD_R
DRIVE_CAP_READ_DVD_PR = _pycdio.DRIVE_CAP_READ_DVD_PR
DRIVE_CAP_READ_DVD_RAM = _pycdio.DRIVE_CAP_READ_DVD_RAM
DRIVE_CAP_READ_DVD_ROM = _pycdio.DRIVE_CAP_READ_DVD_ROM
DRIVE_CAP_READ_DVD_RW = _pycdio.DRIVE_CAP_READ_DVD_RW
DRIVE_CAP_READ_DVD_RPW = _pycdio.DRIVE_CAP_READ_DVD_RPW
DRIVE_CAP_READ_C2_ERRS = _pycdio.DRIVE_CAP_READ_C2_ERRS
DRIVE_CAP_READ_MODE2_FORM1 = _pycdio.DRIVE_CAP_READ_MODE2_FORM1
DRIVE_CAP_READ_MODE2_FORM2 = _pycdio.DRIVE_CAP_READ_MODE2_FORM2
DRIVE_CAP_READ_MCN = _pycdio.DRIVE_CAP_READ_MCN
DRIVE_CAP_READ_ISRC = _pycdio.DRIVE_CAP_READ_ISRC
DRIVE_CAP_WRITE_CD_R = _pycdio.DRIVE_CAP_WRITE_CD_R
DRIVE_CAP_WRITE_CD_RW = _pycdio.DRIVE_CAP_WRITE_CD_RW
DRIVE_CAP_WRITE_DVD_R = _pycdio.DRIVE_CAP_WRITE_DVD_R
DRIVE_CAP_WRITE_DVD_PR = _pycdio.DRIVE_CAP_WRITE_DVD_PR
DRIVE_CAP_WRITE_DVD_RAM = _pycdio.DRIVE_CAP_WRITE_DVD_RAM
DRIVE_CAP_WRITE_DVD_RW = _pycdio.DRIVE_CAP_WRITE_DVD_RW
DRIVE_CAP_WRITE_DVD_RPW = _pycdio.DRIVE_CAP_WRITE_DVD_RPW
DRIVE_CAP_WRITE_MT_RAINIER = _pycdio.DRIVE_CAP_WRITE_MT_RAINIER
DRIVE_CAP_WRITE_BURN_PROOF = _pycdio.DRIVE_CAP_WRITE_BURN_PROOF
DRIVE_CAP_WRITE_CD = _pycdio.DRIVE_CAP_WRITE_CD
DRIVE_CAP_WRITE_DVD = _pycdio.DRIVE_CAP_WRITE_DVD
DRIVE_CAP_WRITE = _pycdio.DRIVE_CAP_WRITE
MMC_HW_VENDOR_LEN = _pycdio.MMC_HW_VENDOR_LEN
MMC_HW_MODEL_LEN = _pycdio.MMC_HW_MODEL_LEN
MMC_HW_REVISION_LEN = _pycdio.MMC_HW_REVISION_LEN
SRC_IS_DISK_IMAGE_MASK = _pycdio.SRC_IS_DISK_IMAGE_MASK
SRC_IS_DEVICE_MASK = _pycdio.SRC_IS_DEVICE_MASK
SRC_IS_SCSI_MASK = _pycdio.SRC_IS_SCSI_MASK
SRC_IS_NATIVE_MASK = _pycdio.SRC_IS_NATIVE_MASK
DRIVER_UNKNOWN = _pycdio.DRIVER_UNKNOWN
DRIVER_AIX = _pycdio.DRIVER_AIX
DRIVER_BSDI = _pycdio.DRIVER_BSDI
DRIVER_FREEBSD = _pycdio.DRIVER_FREEBSD
DRIVER_LINUX = _pycdio.DRIVER_LINUX
DRIVER_SOLARIS = _pycdio.DRIVER_SOLARIS
DRIVER_OSX = _pycdio.DRIVER_OSX
DRIVER_WIN32 = _pycdio.DRIVER_WIN32
DRIVER_CDRDAO = _pycdio.DRIVER_CDRDAO
DRIVER_BINCUE = _pycdio.DRIVER_BINCUE
DRIVER_NRG = _pycdio.DRIVER_NRG
DRIVER_DEVICE = _pycdio.DRIVER_DEVICE
MIN_DRIVER = _pycdio.MIN_DRIVER
MIN_DEVICE_DRIVER = _pycdio.MIN_DEVICE_DRIVER
MAX_DRIVER = _pycdio.MAX_DRIVER
MAX_DEVICE_DRIVER = _pycdio.MAX_DEVICE_DRIVER
DRIVER_OP_SUCCESS = _pycdio.DRIVER_OP_SUCCESS
DRIVER_OP_ERROR = _pycdio.DRIVER_OP_ERROR
DRIVER_OP_UNSUPPORTED = _pycdio.DRIVER_OP_UNSUPPORTED
DRIVER_OP_UNINIT = _pycdio.DRIVER_OP_UNINIT
DRIVER_OP_NOT_PERMITTED = _pycdio.DRIVER_OP_NOT_PERMITTED
DRIVER_OP_BAD_PARAMETER = _pycdio.DRIVER_OP_BAD_PARAMETER
DRIVER_OP_BAD_POINTER = _pycdio.DRIVER_OP_BAD_POINTER
DRIVER_OP_NO_DRIVER = _pycdio.DRIVER_OP_NO_DRIVER
FS_AUDIO = _pycdio.FS_AUDIO
FS_HIGH_SIERRA = _pycdio.FS_HIGH_SIERRA
FS_ISO_9660 = _pycdio.FS_ISO_9660
FS_INTERACTIVE = _pycdio.FS_INTERACTIVE
FS_HFS = _pycdio.FS_HFS
FS_UFS = _pycdio.FS_UFS
FS_EXT2 = _pycdio.FS_EXT2
FS_ISO_HFS = _pycdio.FS_ISO_HFS
FS_ISO_9660_INTERACTIVE = _pycdio.FS_ISO_9660_INTERACTIVE
FS_3DO = _pycdio.FS_3DO
FS_XISO = _pycdio.FS_XISO
FS_UDFX = _pycdio.FS_UDFX
FS_UDF = _pycdio.FS_UDF
FS_ISO_UDF = _pycdio.FS_ISO_UDF
FS_ANAL_XA = _pycdio.FS_ANAL_XA
FS_ANAL_MULTISESSION = _pycdio.FS_ANAL_MULTISESSION
FS_ANAL_PHOTO_CD = _pycdio.FS_ANAL_PHOTO_CD
FS_ANAL_HIDDEN_TRACK = _pycdio.FS_ANAL_HIDDEN_TRACK
FS_ANAL_CDTV = _pycdio.FS_ANAL_CDTV
FS_ANAL_BOOTABLE = _pycdio.FS_ANAL_BOOTABLE
FS_ANAL_VIDEOCD = _pycdio.FS_ANAL_VIDEOCD
FS_ANAL_ROCKRIDGE = _pycdio.FS_ANAL_ROCKRIDGE
FS_ANAL_JOLIET = _pycdio.FS_ANAL_JOLIET
FS_ANAL_SVCD = _pycdio.FS_ANAL_SVCD
FS_ANAL_CVD = _pycdio.FS_ANAL_CVD
FS_ANAL_XISO = _pycdio.FS_ANAL_XISO
FS_MATCH_ALL = _pycdio.FS_MATCH_ALL
FS_UNKNOWN = _pycdio.FS_UNKNOWN

def close_tray(*args):
  """
    close_tray(drive=None, driver_id=None) -> [status, driver_id]

    close media tray in CD drive if there is a routine to do so. 
    The driver id is returned. An exception is thrown on error.
    """
  return _pycdio.close_tray(*args)

def close(*args):
  """
    destroy(p_cdio)
    Free resources associated with p_cdio.  Call this when done using
    using CD reading/control operations for the current device.

    """
  return _pycdio.close(*args)

def eject_media(*args):
  """
    eject_media(cdio)->return_code

    Eject media in CD drive if there is a routine to do so. 

    """
  return _pycdio.eject_media(*args)

def eject_media_drive(*args):
  """
    eject_media_drive(drive=None)->return_code
    Eject media in CD drive if there is a routine to do so. 
      
    psz_drive: the name of the device to be acted upon. 
    The operation status is returned.
    """
  return _pycdio.eject_media_drive(*args)

def get_arg(*args):
  """
    get_arg(p_cdio, key)->string

    Get the value associatied with key.
    """
  return _pycdio.get_arg(*args)

def get_device(*args):
  """
    get_device(cdio)->str

    Get the CD device associated with cdio.
    If cdio is NULL (we haven't initialized a specific device driver), 
    then find a suitable one and return the default device for that.
        
    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it and it is possible for this routine to return
    None even though there may be a hardware CD-ROM.
    """
  return _pycdio.get_device(*args)

def get_default_device_driver(*args):
  """
    get_default_device_driver(driver_id=None)->[device, driver]
    Return a string containing the default CD device if none is specified.
    if p_driver_id is DRIVER_UNKNOWN or DRIVER_DEVICE then find a suitable
    one set the default device for that.
        
    None is returned as the device if we couldn't get a default device.
    """
  return _pycdio.get_default_device_driver(*args)

def get_devices(*args):
  """
    get_devices(driver_id)->[device1, device2, ...]

    Get an list of device names.
    """
  return _pycdio.get_devices(*args)

def get_devices_ret(*args):
  """
    get_devices_ret(driver_id)->[device1, device2, ... driver_id]

    Like get_devices, but return the p_driver_id which may be different
    from the passed-in driver_id if it was pycdio.DRIVER_DEVICE or
    pycdio.DRIVER_UNKNOWN. The return driver_id may be useful because
    often one wants to get a drive name and then *open* it
    afterwards. Giving the driver back facilitates this, and speeds things
    up for libcdio as well.
    """
  return _pycdio.get_devices_ret(*args)

def get_devices_with_cap(*args):
  """
    get_devices_with_cap(capabilities, any)->[device1, device2...]
    Get an array of device names in search_devices that have at least
    the capabilities listed by the capabities parameter.  
        
    If any is False then every capability listed in the
    extended portion of capabilities (i.e. not the basic filesystem)
    must be satisified. If any is True, then if any of the
    capabilities matches, we call that a success.

    To find a CD-drive of any type, use the mask pycdio.CDIO_FS_MATCH_ALL.

    The array of device names is returned or NULL if we couldn't get a
    default device.  It is also possible to return a non NULL but after
    dereferencing the the value is NULL. This also means nothing was
    found.
    """
  return _pycdio.get_devices_with_cap(*args)

def get_devices_with_cap_ret(*args):
  """
    Like cdio_get_devices_with_cap but we return the driver we found
    as well. This is because often one wants to search for kind of drive
    and then *open* it afterwards. Giving the driver back facilitates this,
      and speeds things up for libcdio as well.
    """
  return _pycdio.get_devices_with_cap_ret(*args)

def get_driver_name(*args):
  """
    get_driver_name(cdio)-> string

    return a string containing the name of the driver in use.

    An IOError exception is raised on error.

    """
  return _pycdio.get_driver_name(*args)

def get_driver_id(*args):
  """
    get_driver_id(cdio)-> int

    Return the driver id of the driver in use.
    if cdio has not been initialized or is None, 
    return pycdio.DRIVER_UNKNOWN.
    """
  return _pycdio.get_driver_id(*args)

def get_last_session(*args):
  """
    get_last_session(p_cdio) -> int
    Get the LSN of the first track of the last session of on the CD.
    An exception is thrown on error.
    """
  return _pycdio.get_last_session(*args)

def have_driver(*args):
  """
    have_driver(driver_id) -> int

    Return 1 if we have driver driver_id, 0 if not and -1 
    if driver id is out of range.
    """
  return _pycdio.have_driver(*args)

def have_ATAPI(*args):
  """
    have_ATAPI(CdIo_t *p_cdio)->bool
    return True if CD-ROM understand ATAPI commands.
    """
  return _pycdio.have_ATAPI(*args)

def is_binfile(*args):
  """
    is_binfile(binfile_name)->cue_name

    Determine if binfile_name is the BIN file part of a CDRWIN CD disk
    image.

    Return the corresponding CUE file if bin_name is a BIN file or
    None if not a BIN file.
    """
  return _pycdio.is_binfile(*args)

def is_cuefile(*args):
  """
    is_cuefile(cuefile_name)->bin_name

    Determine if cuefile_name is the CUE file part of a CDRWIN CD disk
    image.

    Return the corresponding BIN file if bin_name is a CUE file or
    None if not a CUE file.
    """
  return _pycdio.is_cuefile(*args)

def is_device(*args):
  """
    is_cuefile(cuefile_name)->bin_name

    Determine if cuefile_name is the CUE file part of a CDRWIN CD disk
    image.

    Return the corresponding BIN file if bin_name is a CUE file or
    None if not a CUE file.
    """
  return _pycdio.is_device(*args)

def is_nrg(*args):
  """
    is_nrg(cue_name)->bool

    Determine if nrg_name is a Nero CD disc image
    """
  return _pycdio.is_nrg(*args)

def is_tocfile(*args):
  """
    is_tocfile(tocfile_name)->bool

    Determine if tocfile_name is a cdrdao CD disc image
    """
  return _pycdio.is_tocfile(*args)

def get_media_changed(*args):
  """
    get_media_changed(cdio) -> int

    Find out if media has changed since the last call.
    Return 1 if media has changed since last call, 0 if not. Error
    return codes are the same as driver_return_code_t
    """
  return _pycdio.get_media_changed(*args)

def get_hwinfo(*args):
  """
    get_hwinfo(p_cdio)->[drc, vendor, model, release]
    Get the CD-ROM hardware info via a SCSI MMC INQUIRY command.
    """
  return _pycdio.get_hwinfo(*args)

def set_blocksize(*args):
  """
    set_blocksize(cdio, blocksize)->return_status

    Set the blocksize for subsequent reads.
    """
  return _pycdio.set_blocksize(*args)

def set_speed(*args):
  """
    cdio_set_speed(cdio, speed)->return_status
    Set the drive speed.
    """
  return _pycdio.set_speed(*args)

def open_cd(*args):
  """
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name. 

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or 
    None on error or no device.
    """
  return _pycdio.open_cd(*args)

def set_python_errstring(*args):
  """
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name. 

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or 
    None on error or no device.
    """
  return _pycdio.set_python_errstring(*args)
DISC_MODE_CD_DA = _pycdio.DISC_MODE_CD_DA
DISC_MODE_CD_DATA = _pycdio.DISC_MODE_CD_DATA
DISC_MODE_CD_XA = _pycdio.DISC_MODE_CD_XA
DISC_MODE_CD_MIXED = _pycdio.DISC_MODE_CD_MIXED
DISC_MODE_DVD_ROM = _pycdio.DISC_MODE_DVD_ROM
DISC_MODE_DVD_RAM = _pycdio.DISC_MODE_DVD_RAM
DISC_MODE_DVD_R = _pycdio.DISC_MODE_DVD_R
DISC_MODE_DVD_RW = _pycdio.DISC_MODE_DVD_RW
DISC_MODE_DVD_PR = _pycdio.DISC_MODE_DVD_PR
DISC_MODE_DVD_PRW = _pycdio.DISC_MODE_DVD_PRW
DISC_MODE_DVD_OTHER = _pycdio.DISC_MODE_DVD_OTHER
DISC_MODE_NO_INFO = _pycdio.DISC_MODE_NO_INFO
DISC_MODE_ERROR = _pycdio.DISC_MODE_ERROR
DISC_MODE_CD_I = _pycdio.DISC_MODE_CD_I

def get_disc_last_lsn(*args):
  """
    get_disc_last_lsn(cdio)->lsn
    Get the LSN of the end of the CD.

    pycdio.INVALID_LSN is returned on error.
    """
  return _pycdio.get_disc_last_lsn(*args)

def get_disc_mode(*args):
  """
    get_disc_mode(p_cdio) -> str

    Get disc mode - the kind of CD (CD-DA, CD-ROM mode 1, CD-MIXED, ...)
    that we've got. The notion of 'CD' is extended a little to include
    DVD's.
    """
  return _pycdio.get_disc_mode(*args)

def get_joliet_level(*args):
  """
    get_joliet_level(cdio)->int

    Return the Joliet level recognized for cdio.
    This only makes sense for something that has an ISO-9660
    filesystem.
    """
  return _pycdio.get_joliet_level(*args)

def get_mcn(*args):
  """
    get_mcn(cdio) -> str

    Get the media catalog number (MCN) from the CD.
    """
  return _pycdio.get_mcn(*args)

def get_num_tracks(*args):
  """
    get_num_tracks(p_cdio)->int

    Return the number of tracks on the CD. 
    On error pycdio.INVALID_TRACK is returned.
    """
  return _pycdio.get_num_tracks(*args)
INCLUDE_CLASS = _pycdio.INCLUDE_CLASS


def get_drive_cap(*args):
  """
    get_drive_cap()->(read_cap, write_cap, misc_cap)

    Get drive capabilities of device.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it. In this situation capabilities will show up as 
    empty even though there is a hardware CD-ROM.
    get_drive_cap_dev()->(read_cap, write_cap, misc_cap)

    Get drive capabilities of device.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it. In this situation capabilities will show up as 
    empty even though there is a hardware CD-ROM.
    """
  return _pycdio.get_drive_cap(*args)
cvar = _pycdio.cvar

