/*
 * Decompiled with CFR 0.152.
 */
package cryptix.math;

import cryptix.math.BigNum;
import cryptix.util.core.Hex;
import java.io.PrintWriter;

public class BigInteger
extends BigNum {
    public static final BigInteger zero = new BigInteger();
    public static final BigInteger one = new BigInteger(1);
    private static final String USD_HASH = "2d0a96ecc3bef46309b2f753a804f9d9";
    private static final String TMP_STR1 = "d0a96ecc3bef46309b2f753a804f9d9";
    private static final String TMP_STR2 = "0d0a96ecc3bef46309b2f753a804f9d9";
    private static final String TMP_STR3 = "1d0a96ecc3bef46309b2f753a804f9d9";
    private static final String TMP_STR4 = "1d0a96ecc3bef46309b2f753a804f9d";

    public BigInteger() {
    }

    public BigInteger(int n) {
        this.assign(n);
    }

    public BigInteger(BigInteger bigInteger) {
        BigNum.copy(this, bigInteger);
    }

    public BigInteger(String string) {
        this.fromString(string);
    }

    public BigInteger(byte[] byArray) {
        this.fromByteArray(byArray);
    }

    public int bitLength() {
        return BigNum.bitLength(this);
    }

    public Object clone() {
        return new BigInteger(this);
    }

    public void copy(Object object) {
        BigNum.copy(this, (BigInteger)object);
    }

    public BigInteger assign(BigInteger bigInteger) {
        BigNum.copy(this, bigInteger);
        return this;
    }

    public BigInteger assign(int n) {
        BigNum.assign(this, n);
        return this;
    }

    public void fromString(String string) {
        if (string.length() == 0) {
            BigNum.zero(this);
            return;
        }
        this.fromBinary(Hex.fromString((String)string));
    }

    public String toString() {
        byte[] byArray = this.toByteArray();
        String string = Hex.toString((byte[])byArray);
        int n = 0;
        int n2 = string.length();
        while (n < n2 && string.charAt(n) == '0') {
            ++n;
        }
        if (n == n2) {
            return "0";
        }
        return string.substring(n);
    }

    protected void finalize() {
        super.finalize();
    }

    public BigInteger modExp(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = (BigInteger)this.clone();
        BigNum.modExp(this, bigInteger3, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger inverseModN(BigInteger bigInteger, BigInteger bigInteger2) {
        BigNum.inverseModN(this, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger mod(BigInteger bigInteger, BigInteger bigInteger2) {
        BigNum.mod(this, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger mul(BigInteger bigInteger, BigInteger bigInteger2) {
        BigNum.mul(this, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger div(BigInteger bigInteger, BigInteger bigInteger2) {
        BigNum.div(this, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger add(BigInteger bigInteger, BigInteger bigInteger2) {
        BigNum.add(this, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger add(int n) {
        BigNum.add(this, n);
        return this;
    }

    public BigInteger sub(BigInteger bigInteger, BigInteger bigInteger2) {
        BigNum.sub(this, bigInteger, bigInteger2);
        return this;
    }

    public BigInteger gcd(BigNum bigNum, BigNum bigNum2) {
        BigNum.gcd(this, bigNum, bigNum2);
        return this;
    }

    public int cmp(BigInteger bigInteger) {
        return BigNum.cmp(this, bigInteger);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        return this.cmp((BigInteger)object) == 0;
    }

    public BigInteger inc() {
        BigNum.inc(this);
        return this;
    }

    public BigInteger dec() {
        BigNum.dec(this);
        return this;
    }

    public BigInteger shiftLeft(int n) {
        BigNum.shiftLeft((BigNum)this, (BigNum)this, (short)n);
        return this;
    }

    public BigInteger shiftRight(int n) {
        BigNum.shiftRight((BigNum)this, (BigNum)this, (short)n);
        return this;
    }

    public static BigInteger zero() {
        BigInteger bigInteger = new BigInteger();
        BigNum.zero(bigInteger);
        return bigInteger;
    }

    protected static byte[] newBuffer(int n) {
        return new byte[(n + 7) / 8];
    }

    public byte[] toByteArray() {
        byte[] byArray = BigInteger.newBuffer(this.bitLength());
        this.intoBinary(byArray);
        return byArray;
    }

    public void fromByteArray(byte[] byArray) {
        this.fromBinary(byArray);
    }

    public java.math.BigInteger toJavaMathBigInteger() {
        return new java.math.BigInteger(this.toString(), 16);
    }

    public static BigInteger fromJavaMathBigInteger(java.math.BigInteger bigInteger) {
        return new BigInteger(bigInteger.toString(16));
    }

    public static void main(String[] stringArray) {
        try {
            BigInteger.self_test(new PrintWriter(System.out, true));
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        BigInteger bigInteger = new BigInteger(Integer.MAX_VALUE);
        printWriter.println("Displaying 0x7fffffff: " + bigInteger.toString() + " / " + bigInteger.bitLength());
        bigInteger.inc();
        printWriter.println("Adding one: " + bigInteger.toString() + " / " + bigInteger.bitLength());
        bigInteger.inc();
        printWriter.println("Adding one: " + bigInteger.toString() + " / " + bigInteger.bitLength());
        BigInteger bigInteger2 = new BigInteger(Integer.MAX_VALUE);
        BigInteger bigInteger3 = new BigInteger(Integer.MAX_VALUE);
        BigInteger bigInteger4 = new BigInteger();
        BigNum.add(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("add: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.add(bigInteger4, bigInteger4, bigInteger2);
        printWriter.println("add: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.sub(bigInteger4, bigInteger4, bigInteger2);
        printWriter.println("sub: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2.fromString("ffffffffffffffff");
        bigInteger3.fromString("ffffffffffffffff");
        BigNum.add(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println(String.valueOf(bigInteger2.toString()) + " + " + bigInteger3.toString() + " = " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2.copy(bigInteger4);
        BigNum.sub(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println(String.valueOf(bigInteger2.toString()) + " - " + bigInteger3.toString() + " = " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(3);
        bigInteger3 = new BigInteger(3);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(23);
        bigInteger3 = new BigInteger(23);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(127);
        bigInteger3 = new BigInteger(127);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(2047);
        bigInteger3 = new BigInteger(2047);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(Short.MAX_VALUE);
        bigInteger3 = new BigInteger(Short.MAX_VALUE);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(524287);
        bigInteger3 = new BigInteger(524287);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(0x7FFFFF);
        bigInteger3 = new BigInteger(0x7FFFFF);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(bigInteger4);
        bigInteger3 = new BigInteger(bigInteger4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(Integer.MAX_VALUE);
        bigInteger3 = new BigInteger(Integer.MAX_VALUE);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(bigInteger4);
        bigInteger3 = new BigInteger(bigInteger4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2.copy(bigInteger4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger2);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2.copy(bigInteger4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger2);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(32768);
        bigInteger3 = new BigInteger(32768);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(524288);
        bigInteger3 = new BigInteger(524288);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(0x800000);
        bigInteger3 = new BigInteger(0x800000);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(bigInteger4);
        bigInteger3 = new BigInteger(bigInteger4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mul: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4 = new BigInteger(1);
        bigInteger4.shiftLeft(1);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(2);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(4);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(61);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(62);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(63);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(64);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(1);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(2);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(4);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(61);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(62);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(63);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(64);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2.fromString(USD_HASH);
        bigInteger3.fromString(TMP_STR4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println(String.valueOf(bigInteger2.toString()) + " * " + bigInteger3.toString() + " = " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigInteger bigInteger5 = new BigInteger();
        BigInteger bigInteger6 = new BigInteger();
        bigInteger4.copy(bigInteger2);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftLeft(124);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(1);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(1);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(1);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4.shiftRight(1);
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2.fromString(USD_HASH);
        bigInteger3.fromString(TMP_STR4);
        BigNum.mul(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println(String.valueOf(bigInteger2.toString()) + " * " + bigInteger3.toString() + " = " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.div(bigInteger5, bigInteger6, bigInteger4, bigInteger2);
        printWriter.println("div = " + bigInteger5.toString() + " / " + bigInteger5.bitLength());
        printWriter.println("rem = " + bigInteger6.toString() + " / " + bigInteger6.bitLength());
        BigNum.div(bigInteger5, bigInteger6, bigInteger4, bigInteger3);
        printWriter.println("div = " + bigInteger5.toString() + " / " + bigInteger5.bitLength());
        printWriter.println("rem = " + bigInteger6.toString() + " / " + bigInteger6.bitLength());
        printWriter.println("shift: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        printWriter.println("stuff");
        bigInteger5.fromString(TMP_STR4);
        bigInteger5.shiftLeft(126);
        printWriter.println("cmp = " + BigNum.cmp(bigInteger4, bigInteger5));
        bigInteger5.shiftRight(1);
        printWriter.println("cmp = " + BigNum.cmp(bigInteger4, bigInteger5));
        printWriter.println("stuff");
        BigInteger bigInteger7 = zero;
        bigInteger4 = new BigInteger(0);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger4 = new BigInteger(10);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        BigNum.dec(bigInteger4);
        printWriter.println("dec (-1): " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(76543);
        bigInteger3 = new BigInteger(2);
        BigNum.div(bigInteger4, null, bigInteger2, bigInteger3);
        printWriter.println("div: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        printWriter.println("cmp: " + bigInteger4.cmp(bigInteger7));
        printWriter.println("ucmp: " + BigNum.ucmp(bigInteger2, bigInteger3));
        printWriter.println("a len: " + bigInteger2.bitLength());
        printWriter.println("b len: " + bigInteger3.bitLength());
        BigInteger bigInteger8 = new BigInteger();
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 1);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 1);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 1);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 2);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 5);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 5);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("b: " + bigInteger3.toString() + " / " + bigInteger3.bitLength());
        BigNum.shiftLeft((BigNum)bigInteger8, (BigNum)bigInteger3, 15);
        printWriter.println("ds: " + bigInteger8.toString() + " / " + bigInteger8.bitLength());
        printWriter.println("cmp: " + bigInteger4.cmp(bigInteger8));
        bigInteger2 = new BigInteger(76543);
        bigInteger3 = new BigInteger(2);
        BigNum.mod(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mod: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        printWriter.println("cmp: " + bigInteger4.cmp(bigInteger7));
        bigInteger2 = new BigInteger(34567);
        bigInteger3 = new BigInteger(13);
        BigNum.mod(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("mod: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        printWriter.println("cmp: " + bigInteger4.cmp(bigInteger7));
        printWriter.println("cmp: " + bigInteger4.cmp(bigInteger7));
        printWriter.println("cmp: " + bigInteger4.cmp(zero));
        printWriter.println("cmp: " + bigInteger4.cmp(bigInteger7));
        printWriter.println("cmp: " + bigInteger7.cmp(bigInteger4));
        BigNum.display(printWriter, (BigNum)bigInteger4);
        BigNum.display(printWriter, (BigNum)bigInteger7);
        bigInteger4 = zero;
        printWriter.println("zero: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        printWriter.println("zero: " + zero.toString() + " / " + zero.bitLength());
        bigInteger2 = new BigInteger(15);
        bigInteger3 = new BigInteger(27);
        BigNum.gcd(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("gcd: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(13);
        bigInteger3 = new BigInteger(500);
        BigNum.gcd(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("gcd: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        bigInteger2 = new BigInteger(79);
        bigInteger3 = new BigInteger(3220);
        BigNum.inverseModN(bigInteger4, bigInteger2, bigInteger3);
        printWriter.println("inv: " + bigInteger4.toString() + " / " + bigInteger4.bitLength());
        BigInteger.test(printWriter, USD_HASH);
        BigInteger.test(printWriter, TMP_STR1);
        BigInteger.test(printWriter, TMP_STR2);
        BigInteger.test(printWriter, TMP_STR3);
        BigInteger.test(printWriter, TMP_STR4);
    }

    private static void test(PrintWriter printWriter, String string) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.fromString(string);
        printWriter.println("Test: " + string);
        printWriter.println("  big int  " + bigInteger.toString());
        bigInteger.fromString(bigInteger.toString());
        printWriter.println("  restored " + bigInteger.toString());
    }

    static {
        BigInteger.zero();
    }
}

