/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.IJCE;
import java.security.InvalidParameterException;
import java.security.InvalidParameterTypeException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchParameterException;
import java.security.NoSuchProviderException;
import java.security.Parameterized;
import java.security.Provider;
import java.security.SecretKey;
import java.security.SecureRandom;

public abstract class KeyGenerator
implements Parameterized {
    private String algorithm;

    protected KeyGenerator(String string) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
    }

    public static KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        return (KeyGenerator)IJCE.getImplementation(string, "KeyGenerator");
    }

    public static KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return (KeyGenerator)IJCE.getImplementation(string, string2, "KeyGenerator");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public abstract void initialize(SecureRandom var1);

    public abstract SecretKey generateKey();

    public void setParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string == null) {
            throw new NullPointerException("param == null");
        }
        this.engineSetParameter(string, object);
    }

    public Object getParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string == null) {
            throw new NullPointerException("param == null");
        }
        return this.engineGetParameter(string);
    }

    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        throw new NoSuchParameterException(String.valueOf(this.getAlgorithm()) + ": " + string);
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        throw new NoSuchParameterException(String.valueOf(this.getAlgorithm()) + ": " + string);
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " KeyGenerator [" + this.algorithm + "]";
    }

    public static String[] getAlgorithms(Provider provider) {
        return IJCE.getAlgorithms(provider, "KeyGenerator");
    }

    public static String[] getAlgorithms() {
        return IJCE.getAlgorithms("KeyGenerator");
    }
}

