#include <LEDA/graph.h>
#include <LEDA/graph_alg.h>



main(int argc, char** argv)
{

GRAPH<int,int> G;
edge e;

cmdline_graph(G,argc,argv);

edge_array<int>  cap(G,0);
edge_array<int>  flow(G,0);

forall_edges(e,G) G[e] = cap[e] = random(1,100000);

node s = G.first_node();
node t = G.last_node();

float T = used_time();

cout << "MAX_FLOW(int)     ";
cout.flush();
int total_flow = MAX_FLOW(G,s,t,cap,flow) ;
cout << string("time: %6.2f sec  flow = %d",used_time(T),total_flow);
newline;



edge_array<double>  cap1(G,0);
edge_array<double>  flow1(G,0);

forall_edges(e,G) cap1[e] = cap[e];

cout << "MAX_FLOW(double)  ";
cout.flush();
double total_flow1 = MAX_FLOW(G,s,t,cap1,flow1);
cout << string("time: %6.2f sec  flow = %f",used_time(T),total_flow1);
newline;


if (Yes("show flow values? "))
forall_edges(e,G) 
  { G.print_edge(e);
    cout << string(" flow = %6d  flow1 = %4.2f\n",flow[e],flow1[e]);
  }
newline;

return 0;

}
