#include <LEDA/list.h>
#include <LEDA/array.h>


// Any built-in, pointer, item, or user-defined class type can be used 
// as actual type parameter for a parameterized data type. Class types T
// have to provide the following operations:
// 
// a constructor taking no arguments   T::T()
// a copy constructor                  T::T(const T&)
// a Read function                void Read(T&, istream&)
// a Print function               void Print(const T&, ostream&)
// 
// A compare function  "int compare(const T&, const T&)" has to be defined 
// if required by the data type.


class d3_point
{
   double x;
   double y;
   double z;


   public:

   d3_point(double a=0, double b=0, double c=0) { x = a;   y = b;   z = c; }
   d3_point(const d3_point& p)                  { x = p.x; y = p.y; z = p.z; }


   LEDA_MEMORY(d3_point);

   friend istream& operator>>(istream& I, d3_point& p);
   friend ostream& operator<<(ostream& O, const d3_point& p);
   friend int      compare(const d3_point& p, const d3_point& q);

};

istream& operator>>(istream& I, d3_point& p) 
{ return I >> p.x >> p.y >> p.z;}

ostream& operator<<(ostream& O, const d3_point& p)
{ return O << "(" << p.x << "," << p.y << "," << p.z << ")"; }


void Read(d3_point& p, istream& I)        { I >> p; }
void Print(const d3_point& p, ostream& O) { O << p; }

int compare(const d3_point& p, const d3_point& q)  // lexicograph.
{ int b;
  if (b=compare(p.x,q.x)) 
     return b;
  else 
     if (b=compare(p.y,q.y)) 
        return b;
     else 
        return compare(p.z,q.z); 
}


#if !defined(__TEMPLATE_FUNCTIONS__)
LEDA_TYPE_PARAMETER(d3_point)
#endif

void Read(list<d3_point>& L, istream& in)  { L.read(in); }

void Print(const list<d3_point>& L, ostream& out)  { L.print(out); }

int compare(const list<d3_point>& L1, const list<d3_point>& L2)
{ if (L1.empty() && L2.empty()) 
     return 0;
  else
     if (L2.empty()) 
        return 1;
     else
        if (L1.empty()) return -1;
     else
        return compare(L1.head(),L2.head()); 
 } 


#if !defined(__TEMPLATE_FUNCTIONS__)
LEDA_TYPE_PARAMETER(list<d3_point>)
#endif


main()
{
  array<list<d3_point> > A(1,5);
  //                  ^
  //                  |
  //                blank !!!


  for(int i=1;i<=5;i++) A[i].read(string("List[%d]: ",i));
  newline;

  A.print("input:",'\n');
  newline;
  newline;

  for(i=1;i<=5;i++) A[i].permute();
  A.permute();

  A.print("permuted:",'\n');
  newline;
  newline;

  for(i=1;i<=5;i++) A[i].sort();
  A.sort();

  A.print("sorted:",'\n');
  newline;
  newline;

  return 0;
 }
