/*******************************************************************************
+
+  LEDA  3.0
+
+
+  stack.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_STACK_H
#define LEDA_STACK_H

#include <LEDA/basic.h>
#include <LEDA/impl/slist.h>

//------------------------------------------------------------------------------
// stacks                                                                
//------------------------------------------------------------------------------


template<class type>

struct _CLASSTYPE stack : SLIST
{
  void copy_el(GenPtr& x)  const { x=Copy(ACCESS(type,x)); }
  void clear_el(GenPtr& x) const { Clear(ACCESS(type,x)); }

  stack() {}
  stack(const stack& S) : SLIST(S) {}
 ~stack() { clear(); }

  void push(type x)  { SLIST::push(Convert(x)); }
  type top()   const { return ACCESS(type,SLIST::head());}
  type pop()         { type x=top(); SLIST::pop(); return x; }
  int  size()  const { return SLIST::length(); }
  int  empty() const { return SLIST::empty(); }
  void clear()       { SLIST::clear(); }

  stack& operator=(const stack& S) { return (stack&)SLIST::operator=(S); }
};

#endif
