/*******************************************************************************
+
+  LEDA  3.0
+
+
+  h_array.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_HARRAY_H
#define LEDA_HARRAY_H

//------------------------------------------------------------------------------
// h_array  
//------------------------------------------------------------------------------ 
#include <LEDA/basic.h> 
#include <LEDA/impl/slist.h> 
#include <LEDA/impl/dp_hashing.h> 


template<class itype, class etype>

class _CLASSTYPE h_array : public dphash {

void clear_key(GenPtr& x)   const { Clear(ACCESS(itype,x)); }
void clear_inf(GenPtr& x)   const { Clear(ACCESS(etype,x)); }
void copy_key(GenPtr& x)    const { x=Copy(ACCESS(itype,x));  }
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS(etype,x));  }

int  int_type() const { return 1; }

etype init;
SLIST def_list;

public:

etype& operator[](itype y) { stp i=lookup(Convert(y));
                             if (i==nil) { i=insert(Convert(y),Convert(init));
                                           def_list.append(Convert(y));  }
                             return ACCESS(etype,info(i)); }
/*
etype  operator[](itype y) const
                           { stp i=lookup(Convert(y));
                             if (i==nil) return init;
                             else return ACCESS(etype,info(i)); }
*/
bool defined(itype y)    { return member(Convert(y)); }

void init_iterator()     { def_list.init_iterator(); }
bool next_index(itype& y){ GenPtr p; bool b=def_list.next_element(p);
                           y = ACCESS(itype,p); return b; }

 h_array() { }
 h_array(int n,itype* I,etype* E): dphash(n,(GenPtr*)I,(GenPtr*)E) { }
 h_array(etype i) { init=i; }

 h_array(const h_array& A): dphash((dphash&)A) { init = A.init; }

virtual ~h_array() { def_list.clear(); }
};


#define forall_defined(i,A)  for ((A).init_iterator(); (A).next_index(i); )


#endif
