/*****************************************************************************
*   Socket communication for IRIT.					     *
*									     *
* Written by:  Gershon Elber				Ver 0.1, June 1993.  *
*****************************************************************************/

#ifndef IRIT_SOC_H
#define IRIT_SOC_H

#include "iritprsr.h"
#include "allocate.h"

#ifdef OS2GCC
#define IRIT_PIPE_BUFFER_SIZE	1024
#endif /* OS2GCC */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Client and/or read routines. */
int SocReadCharNonBlock(int Handler);
char *SocReadLineNonBlock(int Handler);
void SocEchoInput(int Handler, int EchoInput);
IPObjectStruct *SocReadOneObject(int Handler);
int SocClientCreateSocket(int BinaryIPC, int Read);
void SocClientCloseSocket(int Handler);

/* Server and/or write routines. */
void SocWriteChar(int Handler, char c);
void SocWriteLine(int Handler, char *Line, int LineLen);
void SocWriteOneObject(int Handler, IPObjectStruct *PObj);
int SocServerCreateSocket(int BinaryIPC, int Read);
int SocServerAcceptConnection(int Handler);
int SocServerActive(int Handler);
void SocServerCloseSocket(int Handler);

/* Communication with other processes. */
int IritPrsrSrvrExecAndConnect(char *Program,
			       int *PrgmInput,
			       int *PrgmOutput,
			       int IsBinary);
int IritPrsrSrvrKillAndDisConnect(int Kill, int PrgmInput, int PrgmOutput);
int IritPrsrClntAcceptConnect(int *PrgmInput, int *PrgmOutput);
int IritPrsrClntCloseConnect(int PrgmInput, int PrgmOutput);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* IRIT_SOC_H */
