#ifdef __GNUC__

/******************************************************************************
* The Amiga port of gcc relies on the shell defining a stderr stream that is  *
* different from stdout. Unfortunately, few shells do so, resulting in total  *
* chaos. This little kludge will wedge itself between the C startup code and  *
* main(), redefining stderr to be a stream that is separate from stdout.      *
******************************************************************************/

#include <stdio.h>

static FILE *oldstderr;

static void
restorestderr(void)
{
    fclose(stderr);
    stderr = oldstderr;
}

int
main(int argc, char **argv, char **env)
{
    oldstderr = stderr;
    stderr = fopen("*", "w+");
    atexit(restorestderr);

    return mymain(argc, argv, env);
}

#endif /* __GNUC__ */
