typedef float real;

typedef struct SINGLE_POINT {
  real		x;
  real		y;
  real		z;
} SINGLE_POINT;

typedef struct POINT_LIST {
  SINGLE_POINT	p;
  struct POINT_LIST	*next;
} POINT_LIST;

typedef struct POINT {
  SINGLE_POINT	world;
  SINGLE_POINT	view;
} POINT;

typedef struct POLYGON {
  enum		{LINE,POLY}	type;
  int		n_points;
  POINT		*points;
  real		z_pos;		/* for sorting to do hidden line removal */
  char		*text;
  SINGLE_POINT  norm;  /* normaal vector op polygoon */
  float           brightness;
  struct POLYGON	*next;
} POLYGON;

typedef struct MIN_MAX {
  SINGLE_POINT	min;
  SINGLE_POINT	max;
  SINGLE_POINT	edge;
} MIN_MAX;

typedef struct TRANSFORM {
  real		proj_focus;	/* distance from the view origin	*/
  real		proj_plane;	/* distance in from the focus		*/
  real          norm_proj_focus;
  real          norm_proj_plane;
  real		x_low;		/* in view co-ordinates, [0-1]		*/
  real		x_frac;		/* in view co-ordinates, [0-1]		*/
  real		x_view_scale;	/* put the tranformed image in the viewport*/
  real		x_view_move;
  real		x_scale;	/* supplied scale factor (default 1)	*/
  real		x_move;
  real		x_rot;
  real		sin_x_rot;
  real		cos_x_rot;
  real		y_low;
  real		y_frac;
  real		y_view_scale;
  real		y_view_move;
  real		y_scale;
  real		y_move;
  real		y_rot;
  real		sin_y_rot;
  real		cos_y_rot;
  real		z_scale;
  real		z_move;
  real		z_rot;
  real		z_view_scale;
  real		z_view_move;
  real		sin_z_rot;
  real		cos_z_rot;
} TRANSFORM;

typedef struct STYLE {
  enum		{NONE,BOX,AXIS} axis_style;
  enum		{POST_SCRIPT,PLOT,GRAPH,X} output_style;
  enum		{FIRM,SOFT} scale_style;
  enum		{D2,D3} dimension;
  int		remove_hidden;
  int		border;
  int		bounds;
  int		invisible_border;
  int		orient;	/* show a little labelled axis set in the corner */
  long		ps_scale;
  long		plot_scale;
  int		erase;
  real		x_char_size;
  real		y_char_size;
  SINGLE_POINT  light_source;
} STYLE;
