#include <stdio.h>
#include "hdf.h"

/*
$Header: rpoly.c,v 1.4 91/04/09 16:29:34 mullm_update Exp $

$Log:	rpoly.c,v $
 * Revision 1.4  91/04/09  16:29:34  mullm_update
 * Added RCS keywords
 * 
*/

/*
 *    EDGE structure
 */

typedef struct _edgetype
{
	int y_max;
	int x_min;
	float xmf;
	float slope;
	struct _edgetype *next_edge;
} edge;

/*
 *    Statics.
 */

static edge z= {32767,32767,32767.0,0,&z};	/*  Edge list terminator */
static edge **edge_table;			/*  Edge table		 */
static edge *aet;				/*  Active Edge Table    */

/*------------------------------------------------------------------------

      Main routine to do a test.  Usually ifdef'd out.
 */

#ifdef TEST
#undef MAPX
#undef MAPY
#define MAPX(x) x
#define MAPY(y) y
int y_imsize = 20;
main()
{
	void rpoly();
	static int x[] = { 3,1,1,3 };
	static int y[] = { 1,2,5,1 };

	rpoly(4,x,y);
}
#endif


/*---------------------------------------------------------------------------

    rpoly   After the edge table is made, y is set to the lowest scanline
	    that contains pixels to be colored, the active edge table
	    is set, the pixels are filled between pairs of edge in the
	    AET, x coordinates are updated for each edge, edges that have 
	    reached their maximum scanline are removed, and y is incremented.
	    The process is repeated until both the AET and the edge table 
	    are empty.
 */

void
rpoly( no_pairs, x_ptr, y_ptr )
int no_pairs;
int *x_ptr,*y_ptr;
{
	int x,y;
	static int pn=0;
	edge *ep,*ept,*SortEdges(),*Merge(),*UpdateList();

	if( (y=MakeEdgeTable(no_pairs, x_ptr, y_ptr )) <= y_imsize )
	{
	  do
	  {
		ep = aet = SortEdges( Merge(aet,edge_table[y]) );
#ifdef LODD
		if( (ListLen(aet)%2) != 0 )
			ListPrint(aet,y);
#endif
#ifdef LDEBUG
		puts("AET after merge and sort");
		ListPrint(aet,y);
#endif
	 	while( ep->next_edge != &z )
		{
			for(x = ep->x_min; x < ep->next_edge->x_min; x++)
				SetPixel(x,y);
			ep = ep->next_edge->next_edge;
		}
#ifdef LDEBUG
		puts("edge table for given y");
		ListPrint(edge_table[y],y);
#endif
		aet = UpdateList(aet,y);
		y++;
	  } while( (aet != &z) || (edge_table[y] != &z) );
	}
	free(edge_table);
}/*
END of rpoly
*/
		


/*-------------------------------------------------------------------------
 
    MakeEdgeTable  Takes the edges and adds them to the edge list that
		   corresponds to their lower y coordinate.  Each edge
		   contains the maximum y coordinate, the minimum x
		   coordinate, and the inverse of the slope.  The x
		   coordinate is stored as an integer and a float
		   for convenience in calculating the new x coordinate
		   as you move up the scan lines.

 */

int
MakeEdgeTable( no_pairs, x_ptr, y_ptr )
int no_pairs;
int *x_ptr,*y_ptr;
{
	int i,y1=0;
	edge *ep,*SortEdges();
	void AddEdge(),CheckEdge();

	edge_table = (edge **) malloc( (y_imsize+1)*sizeof(edge *) );

	for( i=0; i<y_imsize+1; i++ )
		edge_table[i] = &z;

	for(i=0;i<no_pairs-1;i++)
		AddEdge( no_pairs,x_ptr,y_ptr,i,i+1 );

	if( (x_ptr[0] != x_ptr[no_pairs-1]) || (y_ptr[0] != y_ptr[no_pairs-1]))
		AddEdge( no_pairs,x_ptr,y_ptr,no_pairs-1,0);

	while(edge_table[y1] == &z ) y1++;
	for( i=y1; i<y_imsize; i++ )
	{
		if( edge_table[i] != &z)
			edge_table[i]=SortEdges( edge_table[i] );
	}
	aet = &z;
	return(y1);
}/*
END of MakeEdgeTable
*/



/*---------------------------------------------------------------------------

    AddEdge     Adds the edge specified by the indices to the appropriate
		list in the edge table, determined by the minimum y.
		Fills in the edge structure.
		Although it might not be immediately apparent, horizontal
		edges need not be added (in fact they cause trouble if you
		do add them).

 */

void
AddEdge( no_pairs, x_ptr,y_ptr,i1,i2 )
int no_pairs,*x_ptr,*y_ptr,i1,i2;
{
	int x1,y1,x2,y2;
	edge *new_edge,*t_edge;

	x1 = MAPX(x_ptr[i1]); x2= MAPX(x_ptr[i2]);
	y1 = MAPY(y_ptr[i1]); y2= MAPY(y_ptr[i2]);
	if(y1==y2) return;
	new_edge = (edge *) malloc(sizeof(edge));
	new_edge->slope = ((float)(x2-x1)/((float)(y2-y1)));
	new_edge->x_min  = (y1<y2 ? x1 : x2 );
	new_edge->xmf    = (float) new_edge->x_min;
	t_edge = edge_table[min(y1,y2)];
	edge_table[min(y1,y2)] = new_edge;
	CheckEdge(i1,i2,no_pairs,y_ptr,&y1,&y2);
	new_edge->y_max  = max(y1,y2);
	new_edge->next_edge = t_edge;
}/*
END of AddEdge
*/



/*--------------------------------------------------------------------------
 
     UpdateList    Either remove edges that are at their maximum y,or
		   change the minimum x using the slope.

 */

edge *
UpdateList( edge_list, y )
edge *edge_list;
int y;
{
	edge *ept,*ep;
	edge pos;
#ifdef LDEBUG
	puts("AET during edge removal");
#endif
	pos.next_edge = edge_list ;
	ep = &pos;
	while( ep != &z )
	{
		if( ep->next_edge->y_max <= y)
		{
			ept= ep->next_edge;
			ep->next_edge = ep->next_edge->next_edge;
			free(ept);
		}
		else
		{
			ep->next_edge->xmf += ep->next_edge->slope;
			ep->next_edge->x_min = ep->next_edge->xmf;
			ep = ep->next_edge;
		}
#ifdef LDEBUG
	ListPrint(aet,y);
#endif
	}
	return(pos.next_edge);
}/*
END of UpdateList
*/



/*------------------------------------------------------------------------
 
    CheckEdge    The tricky part.  This checks to see if the upper Y
		 coordinate of the edge is a local maximum in terms of
		 the polygon.  If not, the edge is shorted by 1 to avoid
		 having two edges at the intersection.

 */

#define LAST_Y(a) (((a)>0) ? (a-1) : (no_pairs-1))
#define NEXT_Y(a) (((a)<(no_pairs-1)) ? (a+1) : 1 )
void
CheckEdge( i1, i2, no_pairs, y_ptr, y1, y2 )
int i1,i2,no_pairs;
int *y_ptr,*y1,*y2;
{
	if( y_ptr[i1] > y_ptr[i2] )
		*y1 = ( y_ptr[i1] > y_ptr[LAST_Y(i1)] ) ? *y1 : (*y1)-1 ;
	else
		*y2 = ( y_ptr[i2] > y_ptr[NEXT_Y(i2)] ) ? *y2 : (*y2)-1 ;
}/*
END of CheckEdge
*/



/*--------------------------------------------------------------------------
 
    SortEdges    Sorts the given edge list by ascending minimum X.

 */

edge *
SortEdges( edge_list )
edge *edge_list;
{
	int i;
	edge *a,*b,*Merge();
	int N = ListLen( edge_list );

	if (edge_list->next_edge == &z)
		return edge_list;
	else
	{
		a = edge_list;
		for( i = 2; i< N/2; i++) edge_list = edge_list->next_edge;
		b = edge_list->next_edge;
		edge_list->next_edge = &z;
		return( Merge(SortEdges(a),SortEdges(b)) );
	}
}/*
END of SortEdges
*/



/*-------------------------------------------------------------------------
 
    Merge    merges two edge lists.

 */

edge *
Merge( list1, list2 )
edge *list1,*list2;
{
	edge *c=&z;

	do
	{
		if( list1->x_min <= list2->x_min )
		{
			c->next_edge=list1;
			c = list1;
			list1 = list1->next_edge;
		}
		else
		{
			c->next_edge = list2;
			c = list2;
			list2 = list2->next_edge;
		}
	}while( c->x_min != 32767 );

	c = z.next_edge;
	z.next_edge = &z;
	return(c);
}/*
END of Merge
*/



/*------------------------------------------------------------------------
 
    ListLen    returns the length of the given edge list.

 */

int
ListLen( edge_list )
edge *edge_list;
{
	int n=1;
	while(edge_list->next_edge != &z)
	{
		 n++;
		 edge_list = edge_list->next_edge;
	}
	return(n);
}/*
END of ListLen
*/



/*-------------------------------------------------------------------------

    ListPrint   Prints an edge list.  Used only when LODD or LDEBUG macros
		are defined.
 */

ListPrint( ep, y )
edge *ep;
int y;
{
		while(ep != &z)
		{
			printf("(%d,%d) ",ep->x_min,ep->y_max);
			ep = ep->next_edge;
		}
		printf(" %d\n",y);
}


/*--------------------------------------------------------------------------
 
    SetPixel   Test Setpixel routine.  Normally another function that
	       does real graphics will be used but this is useful for
	       debugging.
 */

#ifdef TEST
int SetPixel(x,y) int x,y;{printf("%d %d\n",x,y);}
#endif

