/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/


/* For working around Microsoft C 5.1 bug */
#ifdef MSC
#define MSCBUG junk =
#else
#define MSCBUG
#endif

#ifndef TC
#define huge
#endif

/* Trading off size for accuracy */
/* Using float instead of double saves maybe 10% of memory */
#ifdef FLOAT
#define REAL float
#define DOT  dotf
#define v3d  v3f
#define v2d  v2f  
#else 
#define REAL  double 
#define DOT   dot 
#endif

/* following also works for Cray */
#ifdef GENERIC
/* Adjust header file names if yours are different */
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <setjmp.h>
#include <signal.h>
/* MAXALLOC is maximum size allocable by calloc() */
#define   MAXALLOC 0x7FFFFFFFL
/* Some systems don't have decent string functions */
#define strstr(s1,s2) kb_strstr(s1,s2)
#define strupr(s) kb_strupr(s)
/* Since tolower and toupper don't always  check case before converting */
#undef tolower
#undef toupper
#define tolower(c)   (isupper(c) ? ((c)-'A'+'a') : c)
#define toupper(c)   (islower(c) ? ((c)-'a'+'A') : c)
/* Some don't declare calloc and getenv in header files */
char *calloc();
char *getenv();
char *bsearch();
/* PATHCHAR is name-separating character in paths */
#define PATHCHAR '/'
/* ENVPATHCHAR is the path separating character in environment strings */
#define ENVPATHCHAR ":"
/* NOPROTO should be defined for systems that don't do ANSI prototypes */
#define NOPROTO
#endif


#ifdef IRIS
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <setjmp.h>
#include <signal.h>
#define   MAXALLOC 0x7FFFFFFFL
void *calloc();
char *getenv(char *);
#define  memmove(dest,src,n) kb_memmove(dest,src,n)
#define strstr(s1,s2) kb_strstr(s1,s2)
#define strupr(s) kb_strupr(s)
#define stricmp(s1,s2)  strcasecmp(s1,s2)
#define PATHCHAR '/'
#define ENVPATHCHAR ":"
#endif


#ifdef SUN
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <setjmp.h>
#include <signal.h>
#include <values.h>
#define   MAXALLOC 0x7FFFFFFFL
char *getenv();
char *calloc();
#define PATHCHAR '/'
#define ENVPATHCHAR ":"
#define  memmove(dest,src,n) kb_memmove(dest,src,n)
#define strupr(s) kb_strupr(s)
#define strstr(s1,s2) kb_strstr(s1,s2)

/* Sun's tolower and toupper don't check case before converting */
#undef tolower
#undef toupper
#define tolower(c)   (isupper(c) ? ((c)-'A'+'a') : c)
#define toupper(c)   (islower(c) ? ((c)-'a'+'A') : c)

#define NOPROTO
#endif



#ifdef XENIX386
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <setjmp.h>
#include <signal.h>
#include <values.h>
#include <prototypes.h>
int _filbuf(FILE *);   /* for prototype */
#define   MAXALLOC 0x7FFFFFFFL
#define  strupr(s)  kb_strupr(s)
#define  strstr(a,b) kb_strstr(a,b) 
#define  memmove(dest,src,n) kb_memmove(dest,src,n)
char *getenv(char *);
#define PATHCHAR '/'
#define ENVPATHCHAR ":"
#endif


#ifdef NeXT
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#define   MAXALLOC 0x7FFFFFFFL
#define  strupr(s)  kb_strupr(s)
#define  strstr(a,b) kb_strstr(a,b) 
#define PATHCHAR '/'
#define ENVPATHCHAR ":"
#endif

#ifdef MSC
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <fcntl.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <setjmp.h>
#include <signal.h>
#include <limits.h>
#define MAXINT INT_MAX
#define   MAXALLOC 0xFFFFL
#define PATHCHAR '\\'
#define ENVPATHCHAR ";"
#define farcalloc(num,size)  (void far *)halloc(num,size)
#define farfree(ptr)         hfree((void huge *)ptr)
#define NOPIPE
#endif

#ifdef TC 
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <mem.h>
#include <alloc.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <fcntl.h>
#include <conio.h>
#include <setjmp.h>
#include <signal.h>
#include <values.h>
#include <process.h>
#define   MAXALLOC 0xFFFFL
#define PATHCHAR '\\'
#define ENVPATHCHAR ";"
#define NOPIPE
#pragma hdrstop
#endif

#include "model.h"

#if defined(__cplusplus)
#include "storecpp.h"
#else
#if defined(SEGMODEL)
#include "storeseg.h"
#else
#if defined(STORAGEX)
#include "storagex.h"
#else
#include "storage.h"
#endif
#endif
#endif

#include "skeleton.h"
#include "extern.h"

/* Some don't have these manifest constants in math.h */
#ifndef M_LN2
#define M_E	    	2.71828182845904523536
#define M_PI		3.14159265358979323846
#define M_LN2		0.693147180559945309417
#endif

#ifdef NOPROTO
#include "noproto.h"
#else
#include "proto.h"
#endif

