// viewchanger.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Modifier subclasses for changing attributes of DataView (representing the
// visual display of the Data.

#ifndef VIEWCHANGER_H
#ifdef __GNUG__
#pragma interface
#endif
#define VIEWCHANGER_H

#include "modifier.h"
#include "query.h"
#include "request.h"
#include "range.h"

class DataView;
class Data;

class ViewChanger : public Modifier {
	typedef Modifier Super;
public:
	ViewChanger(DataView* view);
	virtual ~ViewChanger();
	redefined int apply();
protected:
	virtual int doApply(DataView* view)=0;
	Data* viewData();
	DataView* myView;
};

class ScaleOptionsSetter : public ViewChanger {
	typedef ViewChanger Super;
public:
	ScaleOptionsSetter(DataView* view) : ViewChanger(view) {}
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request &r);
	redefined int doApply(DataView*);
private:
	redefined const QueryInfo *requestInfo();
};

class VisibleFrameRange : public ViewChanger {
	typedef ViewChanger Super;
public:
	VisibleFrameRange(DataView* view) : ViewChanger(view) {}
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request &r);
	redefined int doApply(DataView*);
private:
	redefined const QueryInfo *requestInfo();
private:
	Range frameRange;
};

class InsertPoint : public ViewChanger {
	typedef ViewChanger Super;
public:
	InsertPoint(DataView* view) : ViewChanger(view) {}
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request &r);
	redefined boolean confirmValues(class Controller *);
	redefined int doApply(DataView*);
private:
	redefined const QueryInfo *requestInfo();
private:
	Range channelRange;
	int insertPoint;
};

class EditRegion : public ViewChanger {
	typedef ViewChanger Super;
public:
	EditRegion(DataView* view) : ViewChanger(view) {}
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request &r);
	redefined boolean confirmValues(class Controller *);
	redefined int doApply(DataView*);
private:
	redefined const QueryInfo *requestInfo();
private:
	Range channelRange;
	Range frameRange;
};

class ChannelRange : public ViewChanger {
	typedef ViewChanger Super;
public:
	ChannelRange(DataView* view) : ViewChanger(view) {}
protected:
	redefined int doApply(DataView*);
	Range channelRange;
};

class ChannelChannelRange : public ChannelRange {
	typedef ChannelRange Super;
public:
	ChannelChannelRange(DataView* view) : ChannelRange(view) {}
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request &r);
private:
	redefined const QueryInfo *requestInfo();
};

class FrameChannelRange : public ChannelRange {
	typedef ChannelRange Super;
public:
	FrameChannelRange(DataView* view) : ChannelRange(view) {}
protected:
	redefined void configureRequest(Request &r);
	redefined boolean setValues(Request &r);
private:
	redefined const QueryInfo *requestInfo();
};

#endif
