// pvocheader.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The Cmusic and Cmix software packages generate phase vocoder analysis files
// with headers which are identical to the "Hybrid" sound file header.  The
// method redefined below is checkHeader(), since pvoc parameters are different
// from sounds.  The peak and comment methods are nonfunctional since those
// features are not supported in the file format.  See soundheader.h for more
// information.

#ifndef PVOCHEADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define PVOCHEADER_H

#include "soundheader.h"

class PvocHeader : public HybridHeader {
	typedef HybridHeader Super;
public:
	PvocHeader(int chans, int rate=defaultSampRate);
	virtual ~PvocHeader() {}
	double frameRate() { return sampleRate(); }
protected:
	redefined int checkHeader();
	redefined int extractPeak(const char *) { return 1; }
	redefined int extractComment(const char *) { return 1; }
	redefined int loadPeak(const char *) { return 1; }
	redefined int loadComment(const char *) { return 1; }
};

#endif
