// header_config.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// methods for protected Header::ConfigRequester class and its subclasses

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "header.h"
#include "query.h"
#include "request.h"
#include "sound.h"
#include "soundheader.h"

Header::ConfigRequester::ConfigRequester(Header* header) : myHeader(header) {
	myHeader->setRaw();			// set to raw mode to skip all disk reads
	myHeader->setDataOffset(0);	// assume no header to start with
}

const QueryInfo *
SoundHeader::SoundConfigRequester::requestInfo() {
    static QueryLabelInfo labels[] = {
        { "Read Raw Soundfile: " }, { nil }
    };
    static QueryChoiceInfo choices[] = {
        { "Channels:", "|1|2|4|", 0x1, true },
        { nil }
    };
    static QueryInfo info[] = {
        { labels, "", nil, choices },
        { nil }
    };
	return info;
}

void
SoundHeader::SoundConfigRequester::configureRequest(Request& request) {
	request.appendValue("Sample rate: ", Sound::defaultSampleRate(),
		CharCheck::posIntsOnly);
	request.appendValue("Bytes to skip before reading samples: ", 0,
		CharCheck::posIntsOnly);
	request.appendChoice("Sample format:",
		"|8-bit linear|8-bit mu law|16-bit linear|floating point|",
		linearEnumToPowerOfTwo(Sound::defaultDataType()),
		true
	);
}

boolean
SoundHeader::SoundConfigRequester::setValues(Request& request) {
	SoundHeader* sh = (SoundHeader *) myHeader;
    QueryValue v[2];
	request.retrieveValues(v, 2);
	sh->samprate = v[0];
	sh->setDataOffset(v[1]);
	QueryChoice c[2];
	request.retrieveChoices(c, 2);
	sh->nchans = c[0];
	int state = c[1];
	sh->data_type = (state == 0x1) ? CharData : (state == 0x2) ? MuLawData
		: (state == 0x4) ? ShortData : FloatData;
	return true;
}

void
FrameDataHeader::FrameConfigRequester::configureRequest(Request &request) {
	request.appendValue("Frame rate (frames/sec) ", 200.0, CharCheck::posNumsOnly);
	request.appendValue("Sampling rate ", 44100, CharCheck::posIntsOnly);
}

void
LPCHeader::LPCConfigRequester::configureRequest(Request& request) {
	request.appendLabel("Read Raw LPC File: ");
	request.appendValue("Number of filter poles: ", 34, CharCheck::posIntsOnly);
	FrameConfigRequester::configureRequest(request);
}

boolean
LPCHeader::LPCConfigRequester::setValues(Request& request) {
	QueryValue v[3];	// FIX ME:  implied knowledge of base class method
	request.retrieveValues(v, 3);
	LPCHeader* lh = (LPCHeader *) myHeader;
	lh->nchans = int(v[0]) + 4;
	lh->framerate = v[1];
	lh->samprate = v[2];
	return true;
}

void
FFTHeader::FFTConfigRequester::configureRequest(Request& request) {
	request.appendLabel("Read Raw FFT File: ");
	request.appendValue("Number of frequency points: ", 1024, CharCheck::posIntsOnly);
	request.appendValue("Frame rate: ", 250.0, CharCheck::posNumsOnly);
	request.appendValue("Source sample rate: ", 44100, CharCheck::posIntsOnly);
}

boolean
FFTHeader::FFTConfigRequester::setValues(Request& request) {
	QueryValue v[3];
	request.retrieveValues(v, 3);
	FFTHeader* fh = (FFTHeader *) myHeader;
	fh->nchans = v[0];
	fh->framerate = v[1];
	fh->samprate = v[2];
	return true;
}

void
EnvelopeHeader::EvpConfigRequester::configureRequest(Request& request) {
	request.appendLabel("Read Raw Envelope File: ");
}
