#include "localdefs.h"

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


char *
kFormat(double number, double increment) {
	static char string[24];
	char f_string[12], *unit;
	double anumber = abs(number);
	if(anumber > 1000000) {
		sprintf(string, "%3.2e", number);
		return string;
	}
	else if(anumber >= 1000) {	// 1230.0 -> 1.23k	
		number /= 1000;
		increment /= 1000;
		unit = "k";
	}
	else unit = "";

	if(number == 0.0)
		sprintf(f_string, "%s", "%+0.1f");
	else if(increment <= 0.0001) {
		sprintf(f_string, "%s%s", "%+0.2e", unit);
	}
	else if(increment < 0.001) {		// 5.0012, .0001 or 5001.2, .1
		sprintf(f_string, "%s%s", "%+0.4f", unit);
	}
	else if(increment < 0.01) {		// 1.025, .005 or 1025, 5
		sprintf(f_string, "%s%s", "%+0.3f", unit);
	}
	else if(increment < 0.1) {		// 1.02, .01 or 1020, 10
		sprintf(f_string, "%s%s", "%+0.3f", unit);
	}
	else if(increment < 1.0) {		// 1.5, .5 or 1500, 500
		sprintf(f_string, "%s%s", "%+0.2f", unit);
	}
	else
		sprintf(f_string, "%s%s", "%+1.1f", unit);
	sprintf(string, f_string, number);
	return string;
}

char *
iFormat(double number, double range) {
	static char string[24];
	sprintf(string, "%d", int(number));
	return string;
}
