// edit_request.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#include "localdefs.h"
#include "application.h"
#include "controller.h"
#include "datafile.h"
#include "editor.h"
#include "envelope.h"
#include "filename.h"
#include "request.h"
#include "query.h"
#include "lpcdata.h"

void
DataEditor::setDefaultDir() {
	Request request("Set Default Directory:");
	request.appendLabel(
		scat("Setting global resource: ", data->defaultDirAttribute())
	);
	request.appendValue("New directory: ", defaultDir(), CharCheck::anyChar);
	if(controller->handleRequest(request) == Yes) {
		QueryValue v;
		request.retrieveValues(v);
		const char* newDir = v;
		Application::setGlobalResource(data->defaultDirAttribute(), newDir);
	}
}

void
DataEditor::newFile() {
	static const int defaultNewLength = 32;
	Request request("Create New File:");
	request.appendValue("Length (in frames/samples): ", 
		defaultNewLength, CharCheck::posIntsOnly);
	request.appendValue("File name: ", 
		FileName::untitledName(data->fileSuffix()), CharCheck::anyChar);
	if(controller->handleRequest(request) == Yes) {
		const int nVals = 2;
		QueryValue v[nVals];
		request.retrieveValues(v, nVals);
		int newlen = v[1];
		const char *newname = v[0];
		Data *newData = data->newData(newlen);
		Controller *newCtlr = new Controller(newData, newname);
		newCtlr->display(controller->world());
	}
}

void
LPCEditor::adjustPitchDeviation() {
	Request request1("Adjust Pitch Deviation:");
	request1.appendLabel("First, enter an error threshold between 0.0 and 1.0.");
	request1.appendLabel("A threshold value of -1 will include all frames.");
	request1.appendValue("Error threshold: ", -1.0, CharCheck::numsOnly);
	if(controller->handleRequest(request1) != Yes)
		return;
	setChannels(0, 3); // regardless of selection, select channels 0-3
	LPCData* selection = (LPCData *) currentSelection();

	QueryValue dval;
	request1.retrieveValues(dval);
	double threshold = dval;
	Request request2("Adjust Pitch Deviation:");
	request2.appendLabel("Scale pitch deviation to +- new interval.");
	request2.appendLabel("Pitches below cutoff value will be skipped.");
	double currentDev = selection->averagePitchDeviation(threshold);
	request2.appendValue("New deviation (hz): ", currentDev,
		CharCheck::posNumsOnly);
	request2.appendValue("Pitch cutoff value (hz): ", 50.0,
		CharCheck::numsOnly);
	if(controller->handleRequest(request2) == Yes) {
		QueryValue dvals[3];
		request2.retrieveValues(dvals, 3);
		Application::inform("Scaling pitch deviation...");
		selection->scalePitchDeviation(
			dvals[0],			// new deviation
			threshold,
			dvals[1]			// cutoff frequency
		);
	}
}
