// curvegen.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "curvegen.h"
#include "data.h"
#include "localdefs.h"
#include "query.h"
#include "request.h"

CurveGenerator::CurveGenerator(Data* data)
	: OutputFunction(data),
	  counter(0), totalLength(data->length()), baseValue(0.0), height(0.0) {}

CurveGenerator::CurveGenerator(Data* data, double base, double ending)
		: OutputFunction(data),
		  counter(0), totalLength(data->length()),
		  baseValue(base), height(ending - base) {
}

double
CurveGenerator::operator () (RunStatus *status) {
	*status = (counter < totalLength) ? Run : Stop;
	return baseValue + height * curvePoint(double(counter++)/totalLength);
}

const QueryInfo *
CurveGenerator::requestInfo() {
	static QueryInfo info[] = {
		{ nil }
	};
	return info;
}

void
CurveGenerator::configureRequest(Request &request) {
	request.appendLabel(requestLabel());
	request.appendValue("Starting Amplitude: ", 0.0, CharCheck::numsOnly);
	request.appendValue("Ending Amplitude: ", 1.0, CharCheck::numsOnly);
}

boolean
CurveGenerator::setValues(Request& request) {
	static const int nVals = 2;
	QueryValue v[nVals];
	request.retrieveValues(v, nVals);
	baseValue = v[0];
	height = double(v[1]) - baseValue;
	return true;
}

////////

void
ExponentialCurveGenerator::configureRequest(Request &request) {
	CurveGenerator::configureRequest(request);
	request.appendValue("Exponent for Curve: ", 2.0, CharCheck::posNumsOnly);
}

boolean
ExponentialCurveGenerator::setValues(Request& request) {
	boolean status = true;
	if((status = CurveGenerator::setValues(request)) == true) {
		static const int nVals = 3;
		QueryValue v[nVals];
		request.retrieveValues(v, nVals);
		exponent = v[2];
	}
	return status;
}

double
ExponentialCurveGenerator::curvePoint(double fraction) {
	return pow(fraction, exponent);
}
