// controller_conv.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// the converter routine definitions for class Controller
// putting these here allows me to avoid including converter.h in controller.C

#include "controller.h"
#include "editor.h"
#include "sndconfig.h"
#include "sound.h"

#ifdef ADC_DACS

#include "adc_dac.h"
#define USE_NATIVE false

#endif

#ifdef NeXT				/* NeXT workstation */

#include "next_dac.h"
#ifndef USE_NATIVE
#define USE_NATIVE true
#endif

#elif defined(sparc) /* Sun SPARC workstation */

#if defined(PROPORT_DACS)

#include "proport_dac.h"
#ifndef USE_NATIVE
#define USE_NATIVE false
#endif

#endif	/* PROPORT_DACS */

#if defined(SPARC_DACS)

#include "sun_dac.h"
#ifndef USE_NATIVE
#define USE_NATIVE true
#endif

#endif /* SPARC_DACS */

#elif defined(sgi) && defined(SGI_DACS)			/* Silicon Graphics */

#include "sgi_dac.h"
#ifndef USE_NATIVE
#define USE_NATIVE true
#endif

#elif defined(SOUNDBLASTER)

#include "soundblaster.h"
#ifndef USE_NATIVE
#define USE_NATIVE true
#endif

#elif defined(VOXWARE)		/* VoxWare Card on Intel platform */

#include "vw_converter.h"

#ifndef USE_NATIVE
#define USE_NATIVE true
#endif

#elif !defined(USE_NATIVE)	/* No converter defined */

#define USE_NATIVE true
#include "converter.h"

#endif	/* NeXT, etc. */

// in its current form, it is not possible to choose between two different
// non-native converters

boolean Converter::usingNative = USE_NATIVE;

Converter *
Converter::create() {
	Converter* converter = nil;
	if(useNative()) {
#if defined(NeXT)
		converter = new NextConverter();
#elif defined(SPARC_DACS)
		converter = new SunConverter();
#elif defined(SGI_DACS)
		converter = new SGIConverter();
#elif defined(SOUNDBLASTER)
		converter = new SoundBlaster();
#elif defined(VOXWARE)
		converter = new VW_Converter();
#else
		converter = new NullConverter();	// default for all other platforms
#endif	/* NeXT, etc. */
	}
#if defined(ADC_DACS)
	else
		converter = new AdcConverter();
#elif defined(PROPORT_DACS)
	else
		converter = new ProportConverter();
#endif	/* ADC_DACS, etc. */
	return converter;
}

void
Controller::play() {
	Converter* cvtr = Converter::getInstance();
	class StatusAction* action = getConverterAction();
	((Sound *) editor()->currentSelection())->play(cvtr, action);
}

void
Controller::record() {
	Converter* cvtr = Converter::getInstance();
	class StatusAction* action = getConverterAction();
	((Sound *) editor()->currentSelection())->record(cvtr, action);
}

void
Controller::stop() {
	Converter::getInstance()->stop();
}

void
Controller::configureConverter() {
	 Converter::getInstance()->configureHardware(this);
}
