.TH remind 1 "27 April 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
remind \- a simple reminder service
.SH SYNOPSIS
\fBremind\fP [ \fItime\fP ] [ \fImessage\fP ]
.SH DESCRIPTION
\fIRemind\fP implements a simple reminder service similar to
\fIcalendar\fP\^(1), but uses \fIalert\fP\^(1) instead of
\fImail\fP\^(1).  Reminders can be specified
from the command line, or \fIremind\fP can extract information from
a file in the user's home directory.  In the latter case,
\fIremind\fP first looks for the file
\fIreminders\fP, then for the file \fIcalendar\fP.
.PP
If the \fItime\fP argument is specified on the command line,
\fIremind\fP will post a reminder at that time.  The text of the
reminder can be specified in the \fImessage\fP argument, or read from
standard input.  The \fItime\fP specification is as for the
\fIat\fP\^(1) command, except that a day of the week or \*(lqweek\*(rq
option is not allowed.  Times after the \*(lqpresent\*(rq refer to
today; specifying a time before the time of execution will cause a
reminder to be posted for \*(lqtomorrow\*(rq.
.PP
Typical examples of the use of \fIremind\fP in this mode are
.PP
.nf
.TP 8
\ 
remind 1230pm "Lunch time."
cat dailyreminders | remind 9am
.fi
.PP
If \fIremind\fP is executed with no arguments, it will search the file
\fIreminders\fP or
\fIcalendar\fP in the user's home directory for references to today's
date, and post reminders for all such references that mention a time.
The following forms of time are acceptable;
.PP
.nf
.TP 8
\ 
9:30, 9:30am, 9:30 am, 9:30pm, 9:30 pm, 21:30.
.fi
.PP
Entries in the reminders file can contain dates in various forms,
including those acceptable to \fIcalendar\fP\^(1).  In addition,
\fIremind\fP will recognize lines containing forms such as \*(lqevery
Wednesday\*(rq and \*(lqevery day\*(rq.  Abbreviations for
month and day names are accepted.  \fIRemind\fP filters the
file through the \*(lqC\*(rq preprocessor \fIcpp\fP, so
other files such as a shared calendar file can be #included.
.PP
Text from the reminders file is also filtered through \fInroff\fP\^(1)
before it is sent to \fIalert\fP\^(1).  This allows various useful
types of formatting, such as word wrapping, justification and
centering, to be performed.  Another useful consequence is that text
can be \*(lqhidden\*(rq from \fIalert\fP\^(1) by enclosing it in an
\fInroff\fP\^(1) comment.  This is particularly useful for text which
is needed to flag a time or date, but which need not appear in the
reminder.  \fINroff\fP\^(1) commands can be included in the text, if
care is taken with various troublesome characters such as ' and \\.
To facilitate \fInroff\fP\^(1) formatting, several character
substitutions are made on the text before it goes to \fInroff\fP\^(1).
Specifically,
.PP
.nf
.TP 8
\ 
; is replaced with a newline
character \\001 is replaced with '
character \\002 is replaced with ;
character \\003 is replaced with \\
.fi
.PP
\fIRemind\fP uses \fIat\fP\^(1) to schedule
the reminders, so the granularity of the reminders will be determined
by that of \fIat\fP\^(1).
.SH FILES
\&./reminders		file to be searched for reminders
\&./calendar		alternate reminders file
.SH "SEE ALSO"
alert(1), at(1), calendar(1), cron(8), nroff(1)
