/* PControl.h  Copyright 1992 Steve Ludtke */

/* This object is basically just a switchboard for messages from various */
/* controls <-> views. It helps to simplify the Plot3DView object */

#import <objc/Object.h>
#import "Plot3DView.h"
#import <appkit/color.h>

#define ANIM_spin	1
#define ANIM_t		2

@interface PControl:Object
{
id minX;		/* min/max coords for currently displayed region */
id maxX;
id minY;
id maxY;
id minZ;
id maxZ;
id dminZ;
id dmaxZ;
id dzSwitch;
id symsel;		/* Symbol selector Matrix */
id color1;		/* colors for mapping */
id color2;
id color3;
id color4;
id color5;
id alpha;
id colortype;	/* type of mapping to use */
id colorsel;	/* matrix of toggles */
id ffSel;		/* formula/file switch */
id varSli;		/* variable slider matrix */
id varText;		/* varibale text matrix */
id varMin;		/* variable min. matrix */
id varMax;		/* variable max. matrix */
id equation;		/* ScrollView containing the equation */
id d3View;		/* Points to the Plot3DView object */
id dView;		/* Points to the DensView object */
id gridx;		/* Selector for # points (x & y) */
id gridy;
id camera;		/* renderman camera */
id errMsg;		/* error/message panel objects */
id errTitle;
id errPan;
id I_BOX;		/* display box for inspectors */
id I_lim;		/* Limits inspector */
id I_dis;		/* display options inspector */
id I_pho;		/* photorealistic inspector */
id autoCont;	/* auto contour switch */
id levels;		/* contour level matrix */
id animFlag;	/* animation flags */
id animFrames;	/* #frames in anim */
id demAsp;		/* DEM file fixed aspect ratio flag */
int curPref;		/* Current data set displayed in the inspector */
SetPref *pref;		/* Data set preferences (& data pointers) */
char *bpath;		/* points to the path for the .app bundle */
float sMM[4];		/* storage for store & recall */
}

/* Initialization */
-init;

/* Display preferences for selected data set. [[sender selectedCell] tag] */
/* is used to decide which set to display */
-disPref:sender;

/* Store preferences for current data set (OK button) */
-stoPref:sender;

/* Read a data file into a data set */
-readFile:sender;

/* Read a scatter data file into a data set */
-readSFile:sender;

/* Read a processed DEM file into a data set */
-readDEM:sender;

/* Return a data set to equation mode */
-clearFile:sender;

/* Takes PControl min/max values and sends them to the Plot3DView */
-setMinMax:sender;

/* Store current x/y min/max for later recall */
-stoMM:sender;

/* recall x/y min/max */
-rclMM:sender;

/* called by the Plot3DView to allow min/max Z values to be overrided */
/* and/or displayed */
-minmaxZ:(float *)minZ :(float *)maxZ;

/* zooms out by a fixed factor */
-zoomOut:sender;

/* zooms in by a fixed factor */
-zoomIn:sender;

/* This routine is called by the Plot3DView once after all the objects */
/* have been initialized. It passes the preferences array.*/
-startup:(SetPref *)Pref;

/* sets the PControl's max/min values */
-setMM:(float)minX :(float)maxX :(float)minY :(float)maxY;

/* variable slider changed */
-setVarS:sender;

/* variable text changed */
-setVarT:sender;

/* new var min/max */
-setVarMinMax:sender;

/* receives the zoomTo messages from the DensView. Note that passed */
/* min/max values are from 0.0 to 1.0, not acutal units */
-zoomTo:(float)minx :(float)miny :(float)maxx :(float)maxy;

/* update density plot , tick origin and spacing*/
-updDen:(RtPoint)TickO :(RtPoint)TickS;

/* save contour/density plot to ~/plot3d.tiff */
-dumpContour;

/* save an ascii data file of the data */
-saveData:sender;

/* new inspector */
-newInsp:sender;

/* Start rendering an animation */
-makeAnim:sender;

-error:(char *)msg;
-message:(char *)s1 :(char *)s2;
@end
