#import "Plot3DView.h"
/* FontShape.h - Copyright 1994  Steve Ludtke  1/23/94*/
/* This object allows rendering of simple ascii letters in */
/* renderman views */
#import "FontShape.h"
#import <ri/ri.h>
#import <math.h>

@implementation FontShape:N3DShape
-init
{
[super init];
ntext=0;
return self;
}

-free
{
[self remAllText];
[super free];
return self;
}

- renderSelf:(RtToken)context
{
int i,j,k;
float x,y,z;
static RtPoint square[4]= {{-1.0,-1.0,-1.01},{1.0,-1.0,-1.01},{1.0,1.0,-1.01},{-1.0,1.0,-1.01}};
static RtColor dCol = { 1.0,1.0,1.0 };

/*RiSurface("constant",RI_NULL);
if (mode>=4) {
	RiColor(bgCol);
	RiPolygon(4,RI_P,(RtPointer)bsquare,RI_NULL);
}
RiRotate(theta-90.0,1.0,0,0);
RiRotate(-chi,0,0,1.0);
RiColor(bCol);
if (flags&1) RiPolygon(4,RI_P,(RtPointer)square,RI_NULL);
RiSurface("matte",RI_NULL);
RiColor(dCol);*/
return self;
}

-(int)addText:(char *)txt :(RtPoint)v1 :(RtPoint)v2
{
text[ntext].text=malloc(strlen(txt)+1);
strcpy(text[ntext].text,txt);
text[ntext].v1[0]=v1[0];
text[ntext].v1[1]=v1[1];
text[ntext].v1[2]=v1[2];
text[ntext].v2[0]=v2[0];
text[ntext].v2[1]=v2[1];
text[ntext].v2[2]=v2[2];
ntext++;
return self;
}

-remText:(int)n
{
int i;

if (n<0||n>=ntext) return nil;
free(text[n].text);
ntext--;
for (i=n; i<ntext; i++) text[i]=text[i+1];
return self;
}

-remAllText
{
int i;

for (i=0; i<ntext; i++) free(text[i].text);
ntext=0;
return self;
}

-(int)nText
{
return ntext;
}
@end
  
