;
; PowerPacker Decrunch assembler subroutine V1.1
;
; call as:
;    DecrunchBuffer (endcrun{8}, buffer{9}, efficiency{0});
; with:
;    endcrun   : UBYTE * just after last byte of crunched file
;    buffer    : UBYTE * to memory block to decrunch in
;    efficiency: Longword defining efficiency with wich file was crunched
;
; NOTE:
;    Decrunch a few bytes higher (safety margin) than the crunched file
;    to decrunch in the same memory space. (64 bytes suffice)
;

        XDEF _pp_DecrunchBuffer

_pp_DecrunchBuffer:
        movem.l d1-d7/a2-a6,-(a7)
        bsr.s Decrunch
        movem.l (a7)+,d1-d7/a2-a6
        rts
Decrunch:
        lea myBitsTable(PC),a5
        move.l d0,(a5)
        move.l a1,a2
        move.l -(a0),d5
        moveq #0,d1
        move.b d5,d1
        lsr.l #8,d5
        add.l d5,a1
        move.l -(a0),d5
        lsr.l d1,d5
        move.b #32,d7
        sub.b d1,d7
LoopCheckCrunch:
        bsr.s ReadBit
        tst.b d1
        bne.s CrunchedBytes
NormalBytes:
        moveq #0,d2
Read2BitsRow:
        moveq #2,d0
        bsr.s ReadD1
        add.w d1,d2
        cmp.w #3,d1
        beq.s Read2BitsRow
ReadNormalByte:
        move.w #8,d0
        bsr.s ReadD1
        move.b d1,-(a1)
        dbf d2,ReadNormalByte
        cmp.l a1,a2
        bcs.s CrunchedBytes
        rts
CrunchedBytes:
        moveq #2,d0
        bsr.s ReadD1
        moveq #0,d0
        move.b 0(a5,d1.w),d0
        move.l d0,d4
        move.w d1,d2
        addq.w #1,d2
        cmp.w #4,d2
        bne.s ReadOffset
        bsr.s ReadBit
        move.l d4,d0
        tst.b d1
        bne.s LongBlockOffset
        moveq #7,d0
LongBlockOffset:
        bsr.s ReadD1
        move.w d1,d3
Read3BitsRow:
        moveq #3,d0
        bsr.s ReadD1
        add.w d1,d2
        cmp.w #7,d1
        beq.s Read3BitsRow
        bra.s DecrunchBlock
ReadOffset:
        bsr.s ReadD1
        move.w d1,d3
DecrunchBlock:
        move.b 0(a1,d3.w),d0
        move.b d0,-(a1)
        dbf d2,DecrunchBlock
EndOfLoop:
        cmp.l a1,a2
        bcs.s LoopCheckCrunch
        rts
ReadBit:
        moveq #1,d0
ReadD1:
        moveq #0,d1
        subq.w #1,d0
ReadBits:
        lsr.l #1,d5
        roxl.l #1,d1
        subq.b #1,d7
        bne.s No32Read
        move.b #32,d7
        move.l -(a0),d5
No32Read:
        dbf d0,ReadBits
        rts
myBitsTable:
        dc.b $09,$0a,$0b,$0b


        end;

-- cut --------------------------------------------------------------------

  DESCRIPTION
    Function to decrunch from one memory location to another. The address
of
    the destination can be as close as 8 bytes after the start address of
    the source, so you can decrunch a file with almost no memory overhead.

    If you wish to call this function you need to know the format of a
    crunched file:

        1 longword identifier           'PP20' or 'PX20'
       [1 word checksum (if 'PX20')     $ssss]
        1 longword efficiency           $eeeeeeee
        X longwords crunched file       $cccccccc,$cccccccc,...
        1 longword decrunch info        'decrlen' << 8 | '8 bits other
info'

    The following procedure must be followed to decrunch a file:

    First you must read 'decrunch info' to find the length of the
decrunched
    file, then you must allocate memory to decrunch it in (shift 'decrunch
    info' right 8 bits and add a safety margin (8 bytes) to get the length
    of this memory block).  If the file is encrypted ('PX20') you must call
    ppDecrypt to decrypt the crunched part before calling ppDecrunchBuffer.

    So:
    - read identifier.
    - if PX20, read checksum (16 bits, not 32!).
    - read efficiency.
    - read the longword of decrunch info at the end of the file.
    - calculate 'decrlen'.
    - allocate 'decrlen' + 8 (safety margin) bytes.
    - load 'crunched file' and 'decrunch info' at start of allocated
memory.
    - if PX20, prompt for a password (check result of ppGetPassword()!).
    - if PX20, calculate the passkey (use ppCalcPasskey).
    - if PX20, call ppDecrypt to decrypt 'crunched file' only.
      (NOT 'decrunch info'!)
    - and finally call ppDecrunchBuffer() with 'endcrun' pointing right
after
      'decrunch info', 'decrbuff' pointing 8 bytes after where you loaded
the
      file and 'effptr' pointing to the 'efficieny' longword.

    If this seems complicated that is probably because it is :-) ppLoadData
    was written to make things simpler and should suffice in most cases.

