#import "DirPanel.h"
#import <appkit/Button.h>
#import <appkit/OpenPanel.h>

@implementation OpenPanel (DirPanel)

/* This flags a real cancel.
 */
static BOOL notCancel=NO;

/* This is where the real okButton is stored.
 */
static id realOkButton=nil;

/* When we are masquerading as the okButton, catch setEnabled:.
 */
- setEnabled:(BOOL)flag
{
    [realOkButton setEnabled:YES];
    return self;
}

- forward:(SEL)aSelector :(marg_list)argFrame
{
	if ([realOkButton respondsTo:aSelector])
	{
		return[realOkButton performv:aSelector :argFrame];
	}
	return[self doesNotRecognize:aSelector];
}

-(int)dirPanelRunModal:(const char *)dir
{
  int     ret;

  /* Store the okButton target/action. */
  id      okt = [okButton target];
  SEL     oka = [okButton action];

  /* Enable the button, and redirect it at realOk:. */
  [okButton setEnabled:YES];
  [okButton setTarget:self];
  [okButton setAction:@selector(realOk:)];
 
  /* store away the okButton, and "become" it. */
  realOkButton = okButton;
  okButton = self;

  /* Make sure we don't misfire on this. */
  notCancel = NO;
  /*
   * OpenPanel doesn't seem to pay attention to setRequiredFileType, so I
   * have to do things differently for it.  Actually, I would tend to
   * recommend just using SavePanels, but that's just me. 
   *
   * The idea, here, is that not many people are going to have files named
   * *.abcdefghijklmnop, so the SavePanel can't find any, so it can only show
   * directories, that you can move around in and look for stuff.  Since
   * we're choosing directories, this is the right behaviour. 
   */
  if ([self isMemberOf:[SavePanel class]])
  {
    [self setRequiredFileType:"abcdefghijklmnop"];
    ret = [self runModal];
  }
  else
  {
    const char *types[] = {"abcdefghijklmnop", NULL};

    /* I cast to OpenPanel to remove the warning on compile. */
    ret = [(OpenPanel *)self runModalForDirectory:dir file:NULL
						types:types];
  }
  /*
   * If SavePanel thinks we canceled, check to see if _we_ think so, too. 
   */
  if (!ret && notCancel)
  {
    notCancel = NO;
    ret = 1;
  }
  /* Restore the okButton's target/action. */
  okButton = realOkButton;
  [okButton setTarget:okt];
  [okButton setAction:oka];
  return ret;
}
/* Handles ok's for the panel.  I need to pretend to be a cancel,
 * for some reason.  Don't ask me - it wasn't working when I didn't
 * do it, so I left it.
 */
- realOk:sender
{
  /* Mark this as a fake Cancel. */
  notCancel = YES;
  /* Use the ok: method to pull out any data from the form. */
  [self ok:sender];
  /* Use cancel: to get out of the modal loop. */
  return[self cancel:sender];
}
@end
