/* gui.h
   declarations for functions in gui.c */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef	GUI_H
#define	GUI_H
#include "gopher.h"
#include <X11/Intrinsic.h>

BOOLEAN	initGUI(
#ifdef PROTO
	int *,		/* argc */
	char **		/* argv */
#endif
);

static BOOLEAN	getOptions(
#ifdef PROTO
	int,		/* argc */
	char **		/* argv */
#endif
);

void	loadMarks(
);

void	markCurrentDirectory(
);

void	doUserRequests(
);

void	makeXThings(
);

void	markCurrentDirectory(
);

void	showError(
#ifdef PROTO
	char *		/* message */
#endif
);

void	showFatalError(
#ifdef PROTO
	char *		/* message */
#endif
);

void	showInfo(
#ifdef PROTO
	char *		/* message */
#endif
);

void	showStatus(
#ifdef PROTO
	char *,		/* message */
	int		/* statType */ 
#endif
);

void	displayCurrent(
);

void	displayBookmarks(
);

void	checkPanelButtons(
);

void	clearBookmarks(
);

void	showFile(
#ifdef PROTO
	char *,		/* title */
	char *,		/* fileName */ 
	char *		/* indexString */ 
#endif
);

void	showNameServer(
#ifdef PROTO
	char *,		/* title */
	int		/* s */ 
#endif
);

void	showIndex(
#ifdef PROTO
	gopherItemP 		/* gi */
#endif
);

void showHelp(
#ifdef PROTO
	char *		/* key */
#endif
);

#define POS_none        0
#define POS_pointer     1
#define POS_appPanel    2
#define POS_screen      3

void positionPopup(
#ifdef PROTO
	Widget,  	/* w */
	int,		/* from */
	Widget,		/* fromWidget */
	int,		/* x */
	int,		/* y */
	int,		/* hJust */
	int		/* vJust */
#endif
);

void setTextWidgetSize(
#ifdef PROTO
	Widget,		/* textWidget */
	int,		/* width */
	int		/* height */
#endif
);

void getTextSize(
#ifdef PROTO
	Widget,		/* textWidget */
	int,		/* width */
	int,		/* height */
	Dimension *,		/* retun width in pixels */
	Dimension *		/* retun height in pixels */
#endif
);

#endif	/* GUI_H */
