#include "HTML.h"

#include <string.h>
#include <stdio.h>


HTMLObj *
HTMLnew(size)
  int size;
{
     HTMLObj *temp;

     temp               = (HTMLObj*) malloc(sizeof(HTMLObj));
     
     temp->Linkmaxsize  = size;
     temp->Linklinenum  = (int *) malloc(size * sizeof(int));
     temp->Linklinepos  = (int *) malloc(size * sizeof(int));
     
     temp->Links        = GDnew(size);
     temp->Title        = STRnew();
     
     return(temp);
}


void
HTMLInit(html)
  HTMLObj *html;
{
     GDinit(html->Links);
     STRinit(html->Title);
}

void
HTMLDestroy(html)
  HTMLObj *html;
{
     GDdestroy(html->Links);
     STRdestroy(html->Title);

     STRdestroy(html->Filehtmlname);
     STRdestroy(html->Filetxtname);

     free(html->Linklinenum);
     free(html->Linklinepos);

     free(html);

}


void
HTMLgrow(html, size)
  HTMLObj *html;
{
     int *temp;

     if (size < html->Linkmaxsize) 
	  return;

     temp = (int *) realloc(html->Linklinenum, size);
     if (temp == NULL)
	  fprintf(stderr, "Out of memory!!!\n"), exit(-1);

     if (temp != html->Linklinenum) {
	  free(html->Linklinenum);
	  html->Linklinenum = temp;
     }

     temp = (int *) realloc(html->Linklinepos, size);
     if (temp == NULL)
	  fprintf(stderr, "Out of memory!!!\n"), exit(-1);

     if (temp != html->Linklinepos) {
	  free(html->Linklinepos);
	  html->Linklinepos = temp;
     }

}
     

void
HTMLaddLink(html, gs, linenum, offset)
  HTMLObj   *html;
  GopherObj *gs;
  int       linenum;
  int       offset;
{
     int top;

     if (html->Linkmaxsize == GDgetTop(html->Links)) {
	  html->Linkmaxsize *=2;
	  HTMLgrow(html->Linkmaxsize);
     }
     
     GDaddGS(html->Links, gs);

     top = GDgetTop(html->Links);

     HTMLSetLinepos(html, top-1, offset);
     HTMLSetLinenum(html, top-1, linenum);     
}
	 


