/*
 * bool.c --
 * 	Functions for the built-in type "bool".
 */

#include "tmp/c.h"
#include "utils/log.h"

RcsId("$Header: /private/postgres/src/utils/adt/RCS/bool.c,v 1.8 1992/02/05 03:42:40 mer Exp $");

#include "utils/palloc.h"

	    /* ========== USER I/O ROUTINES ========== */


/*
 *	boolin		- converts "t" or "f" to 1 or 0
 */
int32
boolin(b)
	char	*b;
{
	if (b == NULL)
		elog(WARN, "Bad input string for type bool");
	return((int32) (*b == 't') || (*b == 'T'));
}

/*
 *	boolout		- converts 1 or 0 to "t" or "f"
 */
char *
boolout(b)
	long	b;
{
	char	*result = (char *) palloc(2);

	*result = (b) ? 't' : 'f';
	result[1] = '\0';
	return(result);
}


	     /* ========== PUBLIC ROUTINES ========== */

	 /* (see int.c for comparison/operation routines) */


	     /* ========== PRIVATE ROUTINES ========== */

