/*================================================================
 *
 * FILE:
 *   teststubs.c
 *
 * $Header: /private/postgres/src/test/RCS/teststubs.c,v 1.1 1991/01/09 19:18:05 sp Exp $
 *
 * Test the routines that manipulate rule stub records.
 *
 *================================================================
 */

#include <stdio.h>
#include "utils/log.h"
#include "rules/prs2.h"
#include "rules/prs2stub.h"

void testStubsInout();

/*--------------------------------------------------------
 * main routine
 *--------------------------------------------------------
 */
TestMain(argc, argv)
int argc;
char *argv[];
{
    int i;

    for (i=1; i<argc; i++) {
	if (!strcmp(argv[i], "-inout")) {
	    testStubsInout();
	}
    }
}

/*--------------------------------------------------------
 * testStubsInout:
 *
 * read stubs from the input & transform them to 'Prs2RawStubs'
 * and then back to strings. Used to test the 'stubin', 'stubout',
 * 'Prs2StubToString' & 'Prs2StringToStub' routines....
 *--------------------------------------------------------
 */
void
testStubsInout()
{
    char s[1000];
    int i, c;
    Prs2RawStub raw1;
    Prs2Stub stub1, stub2;
    char *s1, *s2;

    printf("Give me the stub: ");
    i=0;
    while ((c=getchar()) != EOF) {
	if (i > sizeof(s) -1) {
	    elog(WARN, "testStubsInout: string toooooo big!");
	}
	if (c == '\n')
	    c = ' ';
	s[i] = c;
	i++;
    }
    s[i] = '\0';

    if (i==0)
	return;

    printf("---String = \n'%s'\n", s);

    stub1 = prs2StringToStub(s);
    s1 = prs2StubToString(stub1);
    printf("--- String->Stub->String:\n'%s'\n", s1);

    raw1 = prs2StubToRawStub(stub1);
    stub2 = prs2RawStubToStub(raw1);
    s2 = prs2StubToString(stub2);
    printf("--- Stub->Raw->Stub:\n'%s'\n", s2);
    if (strcmp(s1, s2)) {
	fprintf(stderr, "*** stub->raw->stub DOES NOT WORK! ***\n");
    }

    raw1 = stubin(s1);
    s2 = stubout(raw1);
    printf("--- Stub->in/out:\n'%s'\n", s2);
    if (strcmp(s1, s2)) {
	fprintf(stderr, "*** stub->in/out DOES NOT WORK! ***\n");
    }
}

