#include "config.mk"
#include "port.mk"

AR=	ar lru

STUBOBJS= \
    $(OD)/support/stubs.o

STAT=    $(OD)/LIB.stat $(OD)/PORT.stat $(OD)/UTIL.stat $(OD)/STORAGE.stat \
         $(OD)/AM.stat $(OD)/STUB.stat $(OD)/INH.stat

postmaster: $(OD)/support/postmaster

cinterface: CHECK $(OD)/cinterface.a
	
$(OD)/cinterface.a: $(STAT)
	ranlib $(OD)/cinterface.a

CHECK:
	@ sh -c 'if (test ! -f $(OD)/cinterface.a) then rm -f $(OD)/*.stat; \
      else true; fi'

$(OD)/LIB.stat: $(LIBOBJS)
	@ echo adding library objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(LIBOBJS)
	touch $(OD)/LIB.stat

$(OD)/PORT.stat: $(OD)/port/$(PORTNAME)/port.o
	@ echo adding port objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(OD)/port/$(PORTNAME)/port.o
	touch $(OD)/PORT.stat

$(OD)/UTIL.stat: $(UTILOBJS)
	@ echo adding utility objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(UTILOBJS)
	touch $(OD)/UTIL.stat

$(OD)/STORAGE.stat: $(STORAGEOBJS)
	@ echo adding storage objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(STORAGEOBJS)
	touch $(OD)/STORAGE.stat

$(OD)/AM.stat: $(AMOBJS)
	@ echo adding access method objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(AMOBJS)
	touch $(OD)/AM.stat

$(OD)/STUB.stat: $(STUBOBJS)
	@ echo adding stub objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(STUBOBJS)
	touch $(OD)/STUB.stat

$(OD)/INH.stat: $(INH_OBJ)
	@ echo adding inheritance objects to cinterface...
	@ $(AR) $(OD)/cinterface.a $(INH_OBJ)
	touch $(OD)/INH.stat
