/*
 * pmod.h --
 *	POSTGRES processing mode definitions.
 *
 * Description:
 *	There are four processing modes in POSTGRES.  They are NoProcessing
 * or "none," BootstrapProcessing or "bootstrap," InitProcessing or
 * "initialization," and NormalProcessing or "normal."
 *
 *	If a POSTGRES binary is in normal mode, then all code may be executed
 * normally.  In the none mode, only bookkeeping code may be called.  In
 * particular, access method calls may not occur in this mode since the
 * execution state is outside a transaction.
 *
 *	The final two processing modes are used during special times.  When the
 * system state indicates bootstrap processing, transactions are all given
 * transaction id "one" and are consequently guarenteed to commit.  This mode
 * is used during the initial generation of template databases.
 *
 * Finally, the execution state is in initialization mode until all normal
 * initialization is complete.  Some code behaves differently when executed in
 * this mode to enable system bootstrapping.
 */

#ifndef	PModIncluded		/* Include this file only once */
#define PModIncluded	1

/*
 * Identification:
 */
#define PMOD_H	"$Header: /private/postgres/src/lib/H/tmp/RCS/pmod.h,v 1.5 1990/08/17 08:54:51 cimarron Exp $"

#include "tmp/c.h"

typedef enum ProcessingMode {
	NoProcessing,		/* "nothing" can be done */
	BootstrapProcessing,	/* bootstrap creation of template database */
	InitProcessing,		/* initializing system */
	NormalProcessing,	/* normal processing */
} ProcessingMode;

/*
 * IsNoProcessingMode --
 *	True iff processing mode is NoProcessing.
 */
extern
bool
IsNoProcessingMode ARGS((
	void
));

/*
 * IsBootstrapProcessingMode --
 *	True iff processing mode is BootstrapProcessing.
 */
extern
bool
IsBootstrapProcessingMode ARGS((
	void
));

/*
 * IsInitProcessingMode --
 *	True iff processing mode is InitProcessing.
 */
extern
bool
IsInitProcessingMode ARGS((
	void
));

/*
 * IsNormalProcessingMode --
 *	True iff processing mode is NormalProcessing.
 */
extern
bool
IsNormalProcessingMode ARGS((
	void
));

/*
 * SetProcessingMode --
 *	Sets mode of processing as specified.
 *
 * Exceptions:
 *	BadArg if called with invalid mode.
 *
 * Note:
 *	Mode is NoProcessing before the first time this is called.
 */
extern
void
SetProcessingMode ARGS((
	ProcessingMode	mode
));

#endif	/* !defined(PModIncluded) */
