/*
 * Tuple macros used by both index tuples and heap tuples.
 * 
 * "$Header: /private/postgres/src/lib/H/access/RCS/tupmacs.h,v 1.3 1992/04/03 01:08:12 mer Exp $"
 */

#ifndef TUPMACS_H
#define TUPMACS_H

#define att_isnull(ATT, BITS) (!((BITS)[(ATT) >> 3] & (1 << ((ATT) & 0x07))))

/* kai:  Changed (char *) *(T)  to  (char *) * (char *) (T)
         -- makes GNU cc much happier, as T may be (void *) */
/* Note: This bug shall occur with any C-Compiler, which defines __STDC__,
   as Pointer is typedef'ed to (void *), if __STDC__ is defined, or
   to (char *), if it isn't. Or are there any compilers, which can
   handle *P, if P is a pointer to void? */
/* Changed (char *) *(char *) (T)   to   (char *) (int) *(char *) (T)
   to stop these error messages:
	"cast to pointer from integer of different size"
 */

#define fetchatt(A, T) \
 ((*(A))->attbyval ? \
  ((*(A))->attlen > sizeof(short) ? (char *) *(long *) (T) : \
   ((*(A))->attlen < sizeof(short) ? (char *) (int) *(char *) (T) : \
	(char *) (int) *(short *) (T))) : (char *) (T))
	
#endif

