#!/bin/sh

# $Header: /private/postgres/demo/RCS/wholedemo.sh,v 1.3 1992/02/25 15:02:57 clarsen Exp $
# This is a simple script used to run the entire demo without having to
# type all of those tedious include commands to the terminal monitor.
# This script assumes that the postmaster is currently running.
# 
# NOTE:
# It also assumes that you don't have a data base demo in which you keep
# important data (it destroys demo if it exists then re-creates it to run
# the postgres demo queries).

datafile=/tmp/pgdemo.$$

if [ -d $POSTGRESHOME/data/base/demo ]
then
	echo =============== destroying old demo database... =================
	$POSTGRESHOME/bin/destroydb demo
fi

echo =============== creating new demo database... =================
$POSTGRESHOME/bin/createdb demo

rm -f $datafile

echo "retrieve (x=1) \g" > $datafile

for f in `cat demo_order`
do
	cat $POSTGRESHOME/demo/$f >> $datafile
done


$POSTGRESHOME/bin/monitor demo < $datafile

rm -f $datafile
