/*
version: [$Id: is_bbs_running.c,v 5.123 1995/01/18 01:24:58 hitman Exp $]
purpose: checks to see if bbs is running already, only one bbs session per user.
updates: All updates are handled by RCS
Author: The Hitman 1994
Warnings: (hp_ux) implicit declaration of function `putenv'
*/

#include <stdio.h>
#include <stdlib.h>
/* #include <time.h> */

#ifndef __MSDOS__
#	include <strings.h>
#	include "hshgen_s.h"
#else				/* not_MSDOS */
#	include <string.h>
#	include "..\src\hshgen_s.h"
#endif				/* MSDOS */
#include "version.h"

int             is_bbs_running(_character Character);

int 
is_bbs_running(_character Character)
{
	char           *value = NULL;

/* look in the enviroment and see if the bbs switch has been set to yes or no */
#if DEBUG
	fprintf(stderr, "** %s: Check the environment for the variable BBS **\n", __FILE__);
#endif
	value = getenv("BBS");

	/* Check the value for a null */
	if (value == NULL)
	{
#if DEBUG
		fprintf(stderr, "** %s: The variable BBS is not set yet, but that is ok **\n", __FILE__);
#endif
	}
	else
		/* if_value_null */
	{
		/* Go ahead and check the variable because it exists */

#if DEBUG
		fprintf(stderr, "** %s: Just picked up the BBS variable out of the environment. **\n", __FILE__);
#endif
#ifdef OSF1
		/* if (! strcmp ((const char *)"yes", (const char *)value)) */
		/* This is a nasty fix for the above problem on the OSF1 I
		   just want to get something started. If this is not in here
		   the null pointer causes a segmentation fault (OSF1, mips) */
		/* Jul 10 1994: Try this now I check for a null value for bbs
		   and this will allow the program to continue if the BBS
		   variable doesn't exist */
		if (0)
#else				/* OSF1 */
		if (!(strncmp("yes", value, strlen("yes"))))
#endif				/* Any_Other_System: Linux, HP_UX */
		{
#if DEBUG
			fprintf(stderr, "** %s: The user already has a BBS shell running. **\n", __FILE__);
#endif				/* DEBUG */
			puts("Type 'exit' to return to the BBS...");
			exit(EXIT_SUCCESS);
		}		/* if */
	}			/* else_value_null */

#if DEBUG
	fprintf(stderr, "** %s: The BBS is not already running. **\n", __FILE__);
#endif
	/* Set the enviroment variables so that the system knows that it has
	   a copy of the bbs running. */
	putenv("BBS=yes");

	/* Display the system name and type etc... */
#ifndef __MSDOS__
	/* system ("uname -a"); *//* this can be gotten from the operating
	   system via version calls in the code, this would be better, and
	   would not crash the debbuger. */
#else				/* not_MSDOS */
	system("ver");
#endif				/* MSDOS */

	/* done, please return good */
	return (RET_NORMAL);
}				/* is_bbs_running */
