/*
version:  [$Id: interp_from_menu.c,v 5.123 1995/01/18 01:24:58 hitman Exp $]
purpose:  This is another interpreter function, this will run to look for
	commands from the menus. This is were most of the work is done, and this
	function bypasses the normal returns.
updates:  All updates are handled by RCS
Author:  The Hitman 1994
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#ifndef __MSDOS__
#	include <strings.h>
#	include <time.h>
#endif				/* not_MSDOS */

#ifndef __MSDOS__
#	include "bbs_director.h"
#	include "hsh_glob.h"
#	include "hshgen_s.h"
#else				/* not_MSDOS */
#	include "..\src\bbs_dire.h"
#	include "..\src\hsh_glob.h"
#	include "..\src\hshgen_s.h"
#endif				/* MSDOS */

int             interp_from_menu(_character * Character);

int
interp_from_menu(_character * Character)
{
	/* the function that gets menu information */
	extern MENU_struct get_menu_info(char *Currmenu, int LineNumber);


/* Character->input_string is replacing the Command variable.  And will be used to reference the options from the user. */
	char           *option = NULL;	/* I am a option */

	/* page 55: Topics in C Programming: This should work really, it
	   should */
	MENU_struct     menu[MAXLINES];	/* I am the menu option from the
					   program */

	int             cnt = 0;
	int             count = 0;

	char            filename[MAXLENGTH] = {0};

/* define some external functions. */
	extern int      display_screen(void);
	extern int      pause(void);

#if DEBUG
	fprintf(stderr, "** %s(%d): **\n", __FILE__, __LINE__);
#endif				/* DEBUG */

/* set the command bypass, so the next menu will be one we need from the
interpretations. */
	Character->bypass = YES;

/* set the option to the input buffer in the character thing */
	option = Character->input_string;

#if DEBUG
	fprintf(stderr, "** %s: The user picked the following... **\n", __FILE__);
	fprintf(stderr, "** %s: option = %s **\n", __FILE__, option);
#endif				/* DEBUG */

/* this needs to go through the entire menu to get the information needed from the menu */
	for (cnt = 1; cnt < MAXLINES; cnt++)
	{
/* get the information for the menu from the aproprate menu file, and line */
		menu[cnt] = get_menu_info(Character->Currmenu, cnt);
	}			/* for_cnt_down_menu */

	/* get the length of the menu */
	count = (sizeof(menu) / sizeof(MENU_struct));
#if DEBUG
	fprintf(stderr, "** %s: sizeof (menu) = %d, sizeof (MENU_struct) = %d **\n", __FILE__, sizeof(menu), sizeof(MENU_struct));
	fprintf(stderr, "** %s(%d): count = %d **\n", __FILE__, __LINE__, count);
#endif				/* DEBUG */

	/* Interpret menu and input.  need to figure out some way to get a
	   command into the variable structure.  I do not need to look at
	   option zero because it is just a reference to the header for this
	   screen */
	for (cnt = 1; cnt < count; cnt++)
	{
#if DEBUG
		fprintf(stderr, "** %s: option = %s, menu[%d].keyword = %s **\n", __FILE__, option, cnt, menu[cnt].keyword);
#endif				/* DEBUG */
		/* compare the option with the menu find option and quit */
		if (strncmp(option, menu[cnt].keyword, sizeof(option)) == 0)
		{
#if DEBUG
			fprintf(stderr, "** %s: We got a match! **\n", __FILE__);
#endif				/* DEBUG */
			break;
		}		/* if_keyword_continue */
	}			/* for_each_keyword */


	/* use the leftover cnt variable to look at the index for the menu
	   option */
#if DEBUG
	fprintf(stderr, "** %s: Index choosen: menu[%d].index = %c **\n", __FILE__, cnt, menu[cnt].index);

#endif				/* DEBUG */
	switch (menu[cnt].index)

	{

		/* Menu. */
	case 'M':
#if DEBUG
		fprintf(stderr, "** %s: The next choice calls a menu **\n", __FILE__);
#endif				/* DEBUG */
		/* Declare the next menu to use */
		strcpy(Character->Currmenu, menu[cnt].information);
#if DEBUG
		fprintf(stderr, "** %s: Next Menu: Character->Currmenu = %s **\n", __FILE__, Character->Currmenu);
#endif				/* DEBUG */
		/* we need to switch to the next menu */
		return (DISPLAY_MENU);
		break;		/* option_menu */


		/* Program. */
	case 'P':

#if DEBUG
		fprintf(stderr, "** %s: The user has requested to run a program **\n", __FILE__);
#endif				/* DEBUG */
		/* go ahead and shell out and run the users program from the
		   menu information option. */
		system(menu[cnt].information);
		pause();	/* stop and take a breather */

		/* sence the user is done with the command, go ahead and
		   display the menu again for them. */
		return (DISPLAY_MENU);
		break;		/* option_program */


		/* Inquiry. */
	case 'I':

		/* print out the  prompt and get the information from the
		   user */
#ifdef DEBUG
		fprintf(stderr, "** %s: menu[%d].other = %s **\n", __FILE__, cnt, menu[cnt].other);

#endif				/* DEBUG */
		puts(menu[cnt].other);

/* Get information for an inquirery */
		gets(Character->input_string);
#ifdef DEBUG
		fprintf(stderr, "** %s: menu[%d].other = %s **\n", __FILE__, cnt, menu[cnt].other);

#endif				/* DEBUG */
		/* add the command from the menu file and the options from
		   the user, this will make a full command that will then get
		   sent to the execution.  this method I have chosen may
		   cause the option to move past the end of the alloted space
		   for this array */
		strcat(menu[cnt].information, " ");
		/* add the second part of the command */
		strcat(menu[cnt].information, Character->input_string);

#ifdef DEBUG
		fprintf(stderr, "** %s: menu[%d].information = %s **\n", __FILE__, cnt, menu[cnt].information);

#endif				/* DEBUG */
		/* execute the function with the arguments the user provided,
		   there will be no error checking and this will only work in
		   the cases where the user enters something that will go
		   right after the action. This could lead into security
		   problems for those users that really know what they are
		   doing, but I will deal with that later.  There are not any
		   sid programs around here so it should not affect much. */
#ifdef DEBUG
		fprintf(stderr, "** %s: About to run the command: %s **\n", __FILE__, menu[cnt].information);

#endif				/* DEBUG */
		system(menu[cnt].information);

		pause();	/* stop the screen */

		return (DISPLAY_MENU);	/* let them see a menu */
		break;		/* option_inquiry */


		/* Display. */
	case 'D':

		fprintf(stderr, "\nThis option is not currently supported,\nbut will be in future releases. --hitman\n");

		/* system("more $ACTION");  */
		pause();	/* and take a breather */
		return (DISPLAY_MENU);	/* let them see a menu */
		break;		/* option_display_file */


		/* Send Mail */
	case 'S':

		/* Some users just can't figure these things out. */
		puts("");
		puts("Just Start typing, when done just type '.' on a blank line.");
		puts("\tto abort a message just type '.' on a blank line.");
		puts("");
		puts("\tType:");
		puts("\t\t~e - for vi editor");
		puts("");
		puts("");
		puts("|========|========|========|========|========|========|========|========|\n");
		puts("");
		/* system ("mail $ACTION"); need to get this to do something,
		   build the command and go from there */
#if DEBUG
		fprintf(stderr, "** %s: Getting ready to start the mailer **\n", __FILE__);
#endif				/* DEBUG */
		strcpy(filename, MAILER);
		strcat(filename, " ");	/* add a space before the argument */
		strcat(filename, menu[cnt].information);	/* add the argument */

#if DEBUG
		fprintf(stderr, "** %s: Starting filename = %s **\n", __FILE__, filename);
#endif				/* DEBUG */
		system(filename);	/* execute the program */
		pause();	/* and take a breather */

		return (DISPLAY_MENU);	/* let them see a menu */
		break;		/* option_send_mail */


		/* groff text display. */
	case 'G':

		fprintf(stderr, "\nThis option is not currently supported,\nbut will be in future releases. --hitman\n");

		/* system("groff $ACTION | more"); */
		pause();	/* and take a breather */
		return (DISPLAY_MENU);	/* let them see a menu */
		break;


		/* This allows those programs that run from the format:
		   program something:something something:something.  This is
		   for lauching jobs that will take forever... */
	case 'F':

		fprintf(stderr, "\nThis option is not currently supported,\nbut will be in future releases. --hitman\n");

		/* system("ACTION=`grep \":$CHOICE:\" $MENU | awk -F: '{print
		   $4\":\"$5\":\"$6}'`"); system("$ACTION | mail $LOGNAME &
		   2> /tmp/error"); fprintf(stdout, "Your job has been
		   sent...look for mail later!"); */
		pause();	/* and take a breather */
		return (DISPLAY_MENU);	/* let them see a menu */
		break;


		/* If this option is picked you will be logged out of the
		   system and returned to where ever you started. */
	case 'X':		/* Logout screen. */
		Character->bypass = YES;	/* Set the bypass, so I can
						   leave */
		return (GOODBYE);	/* I am done with this */
		break;		/* exit_program_with_screen */


	default:
		/* the command was not found in here, I need to move on and
		   see what is next and who will do the next state */
		break;

	}			/* switch_between_menu_options */

	/* Well I guess I didn't have to go anywhere, just set the bypass
	   back to normal */
	Character->bypass = NO;
	return (RET_NORMAL);
}				/* interpre_user_commands */
