# Release Notes
## [microcode-20260210](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20260210)

### Purpose
- Updated security updates for INTEL-SA-01083 originally published on Aug 13, 2024 [INTEL-SA-01083](https://www.intel.com/content/www/us/en/security-center/advisory/INTEL-SA-01083.html)
- Security updates for [INTEL-SA-01369](https://www.intel.com/content/www/us/en/security-center/advisory/INTEL-SA-01369.html)
- Security updates for [INTEL-SA-01396](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01396.html)
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [13th/14th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update ](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor ](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor (Series 2)](https://cdrdv2.intel.com/v1/dl/getContent/834774?explicitVersion=true?) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6900/6700/6500 Series Processors with P-cores](https://cdrdv2.intel.com/v1/dl/getContent/835486) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6700P-B/6500P-B-Series SoC with P-Cores](https://cdrdv2.intel.com/v1/dl/getContent/843306/view?wapkw=intel%20xeon%206700P-B) for details.


### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 0000003d | 0000003e | Core Gen12
| ADL            | H0       | 06-97-05/07 | 0000003d | 0000003e | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 0000043a | 0000043b | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 0000043a | 0000043b | Core Gen12
| ADL-N          | N0       | 06-be-00/19 | 0000001e | 00000021 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| ARL-H          | A1       | 06-c5-02/82 | 0000011a | 0000011b | Core Ultra Processor (Series 2)
| ARL-S/HX (8P)  | B0       | 06-c6-02/82 | 0000011a | 0000011b | Core Ultra Processor (Series 2)
| ARL-U          | A0       | 06-b5-00/80 | 0000000a | 0000000d | Core Ultra Processor (Series 2)
| AZB            | A0/R0    | 06-9a-04/40 | 0000000b | 0000000c | Atom C1100
| EMR-SP         | A1       | 06-cf-02/87 | 210002c0 | 210002d3 | Xeon Scalable Gen5
| GNR-AP/SP      | Bx/Hx/Lx | 06-ad-01/95 | 010003f0 | 01000405 | Xeon 6900/6700/6500 Series Processors with P-Cores
| GNR-D          | B0/B1    | 06-ae-01/97 | 01000273 | 010002f3 | Xeon 6700P-B/6500P-B Series SoC with P-Cores 
| GNR-SP R1S     | Bx/Hx/Lx | 06-ad-01/20 | 0a000124 | 0a000133 | Xeon 6700/6500-Series Processors with P-Cores
| ICL-D          | B0       | 06-6c-01/10 | 010002e0 | 010002f1 | Xeon D-17xx, D-27xx
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000ca | 000000cc | Core Gen10 Mobile
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d000410 | 0d000421 | Xeon Scalable Gen3
| MTL            | C0       | 06-aa-04/e6 | 00000025 | 00000028 | Core™ Ultra Processor
| RKL-S          | B0       | 06-a7-01/02 | 00000064 | 00000065 | Core Gen11
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 00000132 | 00000133 | Core Gen13/Gen14
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00006133 | 00006134 | Core Gen13
| RPL-HX/S       | C0       | 06-bf-02/07 | 0000003d | 0000003e | Core Gen13/Gen14
| RPL-S          | H0       | 06-bf-05/07 | 0000003d | 0000003e | Core Gen13/Gen14
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00006133 | 00006134 | Core Gen13
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c000410 | 2c000421 | Xeon Max
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000650 | 2b000661 | Xeon Scalable Gen4
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000650 | 2b000661 | Xeon Scalable Gen4
| TGL            | B0/B1    | 06-8c-01/80 | 000000bc | 000000be | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000056 | 00000058 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 0000003c | 0000003e | Core Gen11 Mobile
| TWL            | N0       | 06-be-00/19 | 0000001e | 00000021 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E


# Release Notes
## [microcode-20251111](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20251111)

### Purpose
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [13th/14th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra 200 V Series Processor ](https://cdrdv2.intel.com/v1/dl/getContent/827538) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor (Series 2)](https://cdrdv2.intel.com/v1/dl/getContent/834774) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6700 Series Processors with E-cores](https://cdrdv2.intel.com/v1/dl/getContent/820922) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6900/6700/6500 Series Processors with P-cores](https://cdrdv2.intel.com/v1/dl/getContent/835486) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6700P-B/6500P-B-Series SoC with P-Cores](https://cdrdv2.intel.com/v1/dl/getContent/843306) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| GNR-D          | B0/B1    | 06-ae-01/97 |          | 01000273 | Xeon 6700P-B/6500P-B Series SoC with P-Cores 

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 0000003a | 0000003d | Core Gen12
| ADL            | H0       | 06-97-05/07 | 0000003a | 0000003d | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000437 | 0000043a | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000437 | 0000043a | Core Gen12
| ADL-N          | N0       | 06-be-00/19 | 0000001d | 0000001e | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| ARL-H          | A1       | 06-c5-02/82 | 00000119 | 0000011a | Core Ultra Processor (Series 2)
| ARL-S/HX (8P)  | B0       | 06-c6-02/82 | 00000119 | 0000011a | Core Ultra Processor (Series 2)
| AZB            | A0/R0    | 06-9a-04/40 | 0000000a | 0000000b | Atom C1100
| EMR-SP         | A1       | 06-cf-02/87 | 210002b3 | 210002c0 | Xeon Scalable Gen5
| GNR-AP/SP      | Bx/Hx/Lx | 06-ad-01/95 | 010003d0 | 010003f0 | Xeon 6900-6700/6500-Series Processors with P-Cores
| GNR-SP R1S     | Bx/Hx/Lx | 06-ad-01/20 | 0a000100 | 0a000124 | Xeon 6700/6500-Series Processors with P-Cores
| LNL            | B0       | 06-bd-01/80 | 00000123 | 00000125 | Core Ultra 200 V Series Processor
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 0000012f | 00000132 | Core Gen13/Gen14
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004129 | 00006133 | Core Gen13
| RPL-HX/S       | C0       | 06-bf-02/07 | 0000003a | 0000003d | Core Gen13/Gen14
| RPL-S          | H0       | 06-bf-05/07 | 0000003a | 0000003d | Core Gen13/Gen14
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004129 | 00006133 | Core Gen13
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c000401 | 2c000410 | Xeon Max
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000643 | 2b000650 | Xeon Scalable Gen4
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000643 | 2b000650 | Xeon Scalable Gen4
| SRF-AP/SP      | C0       | 06-af-03/01 | 03000362 | 03000382 | Xeon 6900/6700-Series Processors with E-Cores
| TWL            | N0       | 06-be-00/19 | 0000001d | 0000001e | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E

### Change History
General updates to current Release Notes: Correction of Xeon 6 family processors names.


# Release Notes
## [microcode-20250812](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20250812)

### Purpose
- Security updates for [INTEL-SA-01249](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01249.html)
- Security updates for [INTEL-SA-01308](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01308.html)
- Security updates for [INTEL-SA-01310](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01310.html)
- Security updates for [INTEL-SA-01311](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01311.html)
- Security updates for [INTEL-SA-01313](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01313.html)
- Security updates for [INTEL-SA-01367](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01367.html)
- Update for functional issues. Refer to [13th/14th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [3rd Gen Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [6th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/835486) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra 200 V Series Processor](https://cdrdv2.intel.com/v1/dl/getContent/827538) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor (Series 2)](https://cdrdv2.intel.com/v1/dl/getContent/834774) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6700-Series Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/820922) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.


### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ARL-H          | A1       | 06-c5-02/82 | 00000118 | 00000119 | Core Ultra Processor (Series 2)
| ARL-S/HX (8P)  | B0       | 06-c6-02/82 | 00000118 | 00000119 | Core Ultra Processor (Series 2)
| EMR-SP         | A1       | 06-cf-02/87 | 210002a9 | 210002b3 | Xeon Scalable Gen5
| GNR-AP/SP      | B0       | 06-ad-01/95 | 010003a2 | 010003d0 | Xeon Scalable Gen6
| GNR-AP/SP      | H0       | 06-ad-01/20 | 0a0000d1 | 0a000100 | Xeon Scalable Gen6
| ICL-D          | B0       | 06-6c-01/10 | 010002d0 | 010002e0 | Xeon D-17xx, D-27xx
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d000404 | 0d000410 | Xeon Scalable Gen3
| LNL            | B0       | 06-bd-01/80 | 0000011f | 00000123 | Core Ultra 200 V Series Processor
| MTL            | C0       | 06-aa-04/e6 | 00000024 | 00000025 | Core™ Ultra Processor
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004128 | 00004129 | Core Gen13
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004128 | 00004129 | Core Gen13
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c0003f7 | 2c000401 | Xeon Max
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000639 | 2b000643 | Xeon Scalable Gen4
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000639 | 2b000643 | Xeon Scalable Gen4
| SRF-SP         | C0       | 06-af-03/01 | 03000341 | 03000362 | Xeon 6700-Series Processors with E-Cores


### New Disclosures Updated in Prior Releases

All ADL, RPL, SPR, EMR, MTL, ARL Microcode patches previously released in May 2025.

# Release Notes
## [microcode-20250512](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20250512)

### Purpose

- Security updates for [INTEL-SA-01153](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01153.html)
- Security updates for [INTEL-SA-01244](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01244.html)
- Security updates for [INTEL-SA-01247](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01247.html)
- Security updates for [INTEL-SA-01322](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01322.html)
# Note: INTEL-SA-01244 and INTEL-SA-01247 will be published on May 13th 2025


- Update for functional issues. Refer to [Intel® Core™ Ultra 200 V Series Processor (Series2)](https://cdrdv2.intel.com/v1/dl/getContent/834774) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra 200 V Series Processor](https://cdrdv2.intel.com/v1/dl/getContent/827538) for details.
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [14th/13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/615213) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel® Core™ Processor Family Spec Update](https://cdrdv2.intel.com/v1/dl/getContent/337346) for details.
- Update for functional issues. Refer to [6th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/835486) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Processor Scalable Family](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634897) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [2nd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6700-Series Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/820922) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [Intel® Pentium® Silver and Intel® Celeron® Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/336562)

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ARL-U          | A1       | 06-b5-00/80 |          | 0000000a | Core™ Ultra Processor (Series2)
| ARL-S/HX (8P)  | B0       | 06-c6-02/82 |          | 00000118 | Core™ Ultra Processor (Series2)
| ARL-H          | A1       | 06-c5-02/82 |          | 00000118 | Core™ Ultra Processor (Series2)
| GNR-AP/SP      | B0       | 06-ad-01/95 |          | 010003a2 | Xeon Scalable Gen6
| GNR-AP/SP      | H0       | 06-ad-01/20 |          | 0a0000d1 | Xeon Scalable Gen6
| LNL            | B0       | 06-bd-01/80 |          | 0000011f | Core™ Ultra 200 V Series Processor

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 00000038 | 0000003a | Core Gen12
| ADL            | H0       | 06-97-05/07 | 00000038 | 0000003a | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000436 | 00000437 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000436 | 00000437 | Core Gen12 
| ADL-N          | N0       | 06-be-00/19 | 0000001c | 0000001d | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AML-Y42        | V0       | 06-8e-0c/94 | 000000fc | 00000100 | Core Gen10 Mobile
| AZB            | A0/R0    | 06-9a-04/40 | 00000009 | 0000000a | Intel(R) Atom(R) C1100
| CFL-H          | R0       | 06-9e-0d/22 | 00000102 | 00000104 | Core Gen9 Mobile
| CLX-SP         | B1       | 06-55-07/bf | 05003707 | 05003901 | Xeon Scalable Gen2
| CML-H          | R1       | 06-a5-02/20 | 000000fc | 00000100 | Core Gen10 Mobile
| CML-S102       | Q0       | 06-a5-05/22 | 000000fc | 00000100 | Core Gen10
| CML-S62        | G1       | 06-a5-03/22 | 000000fc | 00000100 | Core Gen10
| CML-U42        | V0       | 06-8e-0c/94 | 000000fc | 00000100 | Core Gen10 Mobile
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000fe | 00000102 | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000fc | 00000100 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000fc | 00000100 | Core Gen10 Mobile
| CPX-SP         | A1       | 06-55-0b/bf | 07002904 | 07002b01 | Xeon Scalable Gen3
| EMR-SP         | A1       | 06-cf-02/87 | 21000291 | 210002a9 | Xeon Scalable Gen5
| GLK-R          | R0       | 06-7a-08/01 | 00000024 | 00000026 | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-D          | B0       | 06-6c-01/10 | 010002c0 | 010002d0 | Xeon D-17xx, D-27xx
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000c6 | 000000ca | Core Gen10 Mobile
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d0003f5 | 0d000404 | Xeon Scalable Gen3
| MTL            | C0       | 06-aa-04/e6 | 00000020 | 00000024 | Core™ Ultra Processor
| RKL-S          | B0       | 06-a7-01/02 | 00000063 | 00000064 | Core Gen11
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 0000012c | 0000012f | Core Gen13/Gen14
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004124 | 00004128 | Core Gen13
| RPL-HX/S       | C0       | 06-bf-02/07 | 00000038 | 0000003a | Core Gen13/Gen14
| RPL-S          | H0       | 06-bf-05/07 | 00000038 | 0000003a | Core Gen13/Gen14
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004124 | 00004128 | Core Gen13
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c0003e0 | 2c0003f7 | Xeon Max
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000620 | 2b000639 | Xeon Scalable Gen4
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000620 | 2b000639 | Xeon Scalable Gen4
| SRF-SP         | C0       | 06-af-03/01 | 03000330 | 03000341 | Xeon 6700-Series Processors with E-Cores
| TGL            | B0/B1    | 06-8c-01/80 | 000000b8 | 000000bc | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000052 | 00000056 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000038 | 0000003c | Core Gen11 Mobile
| TWL            | N0       | 06-be-00/19 | 0000001c | 0000001d | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| WHL-U          | V0       | 06-8e-0c/94 | 000000fc | 00000100 | Core Gen8 Mobile

# Release Notes
## [microcode-20250211](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20250211)

### Purpose

- Security updates for [INTEL-SA-01166](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01166.html)
- Security updates for [INTEL-SA-01213](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01213.html)
- Security updates for [INTEL-SA-01139](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01139.html)
- Security updates for [INTEL-SA-01228](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01228.html)
- Security updates for [INTEL-SA-01194](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01194.html)

- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [13th/14th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel® Core™ Processor Family Spec Update](https://cdrdv2.intel.com/v1/dl/getContent/337346) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [Intel® Xeon® 6700-Series Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/820922) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SRF-SP         | C0       | 06-af-03/01 |          | 03000330 | Xeon 6700-Series Processors with E-Cores

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 00000037 | 00000038 | Core Gen12
| ADL            | H0       | 06-97-05/07 | 00000037 | 00000038 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000435 | 00000436 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000435 | 00000436 | Core Gen12
| ADL-N          | N0       | 06-be-00/19 | 0000001a | 0000001c | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AZB            | A0/R0    | 06-9a-04/40 | 00000007 | 00000009 | Intel(R) Atom(R) C1100
| CFL-H          | R0       | 06-9e-0d/22 | 00000100 | 00000102 | Core Gen9 Mobile
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000f8 | 000000fa | Core Gen8 Desktop, Mobile, Xeon E
| EMR-SP         | A0       | 06-cf-01/87 | 21000283 | 21000291 | Xeon Scalable Gen5
| EMR-SP         | A1       | 06-cf-02/87 | 21000283 | 21000291 | Xeon Scalable Gen5
| ICL-D          | B0       | 06-6c-01/10 | 010002b0 | 010002c0 | Xeon D-17xx, D-27xx
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d0003e7 | 0d0003f5 | Xeon Scalable Gen3
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 0000012b | 0000012c | Core Gen13/Gen14
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004123 | 00004124 | Core Gen13
| RPL-HX/S       | C0       | 06-bf-02/07 | 00000037 | 00000038 | Core Gen13/Gen14
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004123 | 00004124 | Core Gen13
| RPL-S          | H0       | 06-bf-05/07 | 00000037 | 00000038 | Core Gen13/Gen14
| RKL-S          | B0       | 06-a7-01/02 | 00000062 | 00000063 | Core Gen11
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c000390 | 2c0003e0 | Xeon Max
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000603 | 2b000620 | Xeon Scalable Gen4 
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000603 | 2b000620 | Xeon Scalable Gen4
| TWL            | N0       | 06-be-00/19 | 0000001a | 0000001c | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E

### New Disclosures Updated in Prior Releases

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000f6 | 000000f8 | Core Gen9

# Release Notes
## [microcode-20241112](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20241112)

### Purpose

- Security updates for [INTEL-SA-01101](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01101.html)
- Security updates for [INTEL-SA-01079](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01079.html)
- Updated security updates for [INTEL-SA-01097](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01097.html)
- Updated security updates for [INTEL-SA-01103](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01103.html)
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [14th/13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-1700 and D-1800 Processor Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714069) for details


### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 00000036 | 00000037 | Core Gen12
| ADL            | H0       | 06-97-05/07 | 00000036 | 00000037 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000434 | 00000435 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000434 | 00000435 | Core Gen12
| EMR-SP         | A0       | 06-cf-01/87 | 21000230 | 21000283 | Xeon Scalable Gen5
| EMR-SP         | A1       | 06-cf-02/87 | 21000230 | 21000283 | Xeon Scalable Gen5
| MTL            | C0       | 06-aa-04/e6 | 0000001f | 00000020 | Core™ Ultra Processor
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004122 | 00004123 | Core Gen13
| RPL-HX/S       | C0       | 06-bf-02/07 | 00000036 | 00000037 | Core Gen13/Gen14
| RPL-S          | H0       | 06-bf-05/07 | 00000036 | 00000037 | Core Gen13/Gen14
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004122 | 00004123 | Core Gen13
| SPR-SP         | E3       | 06-8f-06/87 | 2b0005c0 | 2b000603 | Xeon Scalable Gen4
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b0005c0 | 2b000603 | Xeon Scalable Gen4
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b0005c0 | 2b000603 | Xeon Scalable Gen4

### New Disclosures Updated in Prior Releases

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ICL-D          | B0       | 06-6c-01/10 | 010002b0 | N/A      | Xeon D-17xx/D-18xx, D-27xx/D-28xx
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d0003e7 | N/A      | Xeon Scalable Gen3


# Release Notes
## [microcode-20241029](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20241029)

### Purpose

- Update for functional issues. Refer to [14th/13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 00000129 | 0000012b | Core Gen13/Gen14


# Release Notes
## [microcode-20240910](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20240910)

### Purpose

- Security updates for [INTEL-SA-01103](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01103.html)
- Security updates for [INTEL-SA-01097](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01097.html)
- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| TWL            | N0       | 06-be-00/19 |          | 0000001a | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 00000035 | 00000036 | Core Gen12
| ADL            | H0       | 06-97-05/07 | 00000035 | 00000036 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000433 | 00000434 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000433 | 00000434 | Core Gen12
| ADL-N          | N0       | 06-be-00/11 | 00000017 | 0000001a | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| MTL            | C0       | 06-aa-04/e6 | 0000001e | 0000001f | Core™ Ultra Processor
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 00000123 | 00000129 | Core Gen13/Gen14
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004121 | 00004122 | Core Gen13
| RPL-HX/S       | C0       | 06-bf-02/07 | 00000035 | 00000036 | Core Gen13/Gen14
| RPL-S          | H0       | 06-bf-05/07 | 00000035 | 00000036 | Core Gen13/Gen14
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004121 | 00004122 | Core Gen13


# Release Notes
## [microcode-20240813](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20240813)

## Update: Corrected the MCU file for 06-a5-03

### Purpose

- Security updates for [INTEL-SA-01083](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01083.html)
- Security updates for [INTEL-SA-01118](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01118.html)
- Security updates for [INTEL-SA-01100](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01100.html)
- Security updates for [INTEL-SA-01038](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01038.html)
- Security updates for [INTEL-SA-01046](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01046.html)


- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634897) for details.
- Update for functional issues. Refer to [2nd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update ](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [10th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/615213) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel® Core™ Processor Family Spec Update](https://cdrdv2.intel.com/v1/dl/getContent/337346) for details.
- Update for functional issues. Refer to [8th Generation Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338025) for details.
- Update for functional issues. Refer to [7th and 8th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/334663) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [Intel® Atom® x6000E Series, and Intel® Pentium® and Celeron® N and J Series Processors for Internet of Things (IoT) Applications](https://cdrdv2.intel.com/v1/dl/getContent/636674) for details.


### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| AML-Y22        | H0       | 06-8e-09/10 | 000000f4 | 000000f6 | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000fa | 000000fc | Core Gen10 Mobile
| CFL-H          | R0       | 06-9e-0d/22 | 000000fc | 00000100 | Core Gen9 Mobile
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000f6 | 000000f8 | Core Gen9
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000f6 | 000000f8 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000f4 | 000000f6 | Core Gen8
| CFL-S          | P0       | 06-9e-0c/22 | 000000f6 | 000000f8 | Core Gen9 Desktop
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000f4 | 000000f6 | Core Gen8 Mobile
| CLX-SP         | B1       | 06-55-07/bf | 05003605 | 05003707 | Xeon Scalable Gen2
| CML-H          | R1       | 06-a5-02/20 | 000000fa | 000000fc | Core Gen10 Mobile
| CML-S102       | Q0       | 06-a5-05/22 | 000000fa | 000000fc | Core Gen10
| CML-S62        | G1       | 06-a5-03/22 | 000000fa | 000000fc | Core Gen10
| CML-U42        | V0       | 06-8e-0c/94 | 000000fa | 000000fc | Core Gen10 Mobile
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000fa | 000000fe | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000fa | 000000fc | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000fa | 000000fc | Core Gen10 Mobile
| CPX-SP         | A1       | 06-55-0b/bf | 07002802 | 07002904 | Xeon Scalable Gen3
| EHL            | B1       | 06-96-01/01 | 00000019 | 0000001a | Pentium J6426/N6415, Celeron J6412/J6413/N6210/N6211, Atom x6000E
| ICL-D          | B0       | 06-6c-01/10 | 01000290 | 010002b0 | Xeon D-17xx, D-27xx
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000c4 | 000000c6 | Core Gen10 Mobile
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d0003d1 | 0d0003e7 | Xeon Scalable Gen3
| KBL-R U        | Y0       | 06-8e-0a/c0 | 000000f4 | 000000f6 | Core Gen8 Mobile
| KBL-U23e       | J1       | 06-8e-09/c0 | 000000f4 | 000000f6 | Core Gen7 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000f4 | 000000f6 | Core Gen7 Mobile
| MTL            | C-0      | 06-aa-04/e6 | 0000001c | 0000001e | Core™ Ultra Processor
| RKL-S          | B0       | 06-a7-01/02 | 0000005e | 00000062 | Core Gen11
| TGL            | B0/B1    | 06-8c-01/80 | 000000b6 | 000000b8 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000050 | 00000052 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000036 | 00000038 | Core Gen11 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000fa | 000000fc | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000f4 | 000000f6 | Core Gen8 Mobile


# Release Notes
## [microcode-20240531](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20240531)

### Purpose

- Update for functional issues. Refer to [Intel® Pentium® Silver and Intel® Celeron® Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/336562)


### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| GLK            | B0       | 06-7a-01/01 | 00000040 | 00000042 | Pentium Silver N/J5xxx, Celeron N/J4xxx


# Release Notes
## [microcode-20240514](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20240514)

### Purpose

- Security updates for [INTEL-SA-01051](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01051.html)
- Security updates for [INTEL-SA-01052](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01052.html)
- Security updates for [INTEL-SA-01036](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01036.html)
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Processor Scalable Family](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [14th & 13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 00000034 | 00000035 | Core Gen12
| ADL            | H0       | 06-97-05/07 | 00000034 | 00000035 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000432 | 00000433 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000432 | 00000433 | Core Gen12
| ADL-N          | N0       | 06-be-00/11 | 00000015 | 00000017 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AZB            | A0       | 06-9a-04/40 | 00000005 | 00000007 | Intel(R) Atom(R) C1100
| AZB            | R0       | 06-9a-04/40 | 00000005 | 00000007 | Intel(R) Atom(R) C1100
| EMR-SP         | A0      | 06-cf-01/87 | 21000200 | 21000230 | Xeon Scalable Gen5
| EMR-SP         | A1      | 06-cf-02/87 | 21000200 | 21000230 | Xeon Scalable Gen5
| RPL-E/HX/S     | B0       | 06-b7-01/32 | 00000122 | 00000123 | Core Gen13/Gen14
| RPL-HX/S       | C0       | 06-bf-02/07 | 00000034 | 00000035 | Core Gen13/Gen14
| RPL-S          | H0       | 06-bf-05/07 | 00000034 | 00000035 | Core Gen13/Gen14
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c000290 | 2c000390 | Xeon Max
| SPR-SP         | E2       | 06-8f-05/87 | 2b000590 | 2b0005c0 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 | 2b000590 | 2b0005c0 | Xeon Scalable Gen4
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000590 | 2b0005c0 | Xeon Scalable Gen4
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000590 | 2b0005c0 | Xeon Scalable Gen4

# Release Notes
## [microcode-20240312](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20240312)

### Purpose

- Security updates for [INTEL-SA-INTEL-SA-00972](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00972.html)
- Security updates for [INTEL-SA-INTEL-SA-00982](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00982.html)
- Security updates for [INTEL-SA-INTEL-SA-00898](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00898.html)
- Security updates for [INTEL-SA-INTEL-SA-00960](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00960.html)
- Security updates for [INTEL-SA-INTEL-SA-01045](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-01045.html)

- Update for functional issues. Refer to [Intel® Core™ Ultra Processor](https://cdrdv2.intel.com/v1/dl/getContent/792254) for details.
- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [10th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/615213) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel® Core™ Processor Family Spec Update](https://cdrdv2.intel.com/v1/dl/getContent/337346) for details.
- Update for functional issues. Refer to [8th Generation Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338025) for details.
- Update for functional issues. Refer to [7th and 8th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/334663) for details.
- Update for functional issues. Refer to [5th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/793902) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634897) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [2nd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update ](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/613537) for details.
- Update for functional issues. Refer to [Intel® Atom® C3000 Processor Product Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/336345) for details.
- Update for functional issues. Refer to [Intel® Atom® x6000E Series, and Intel® Pentium® and Celeron® N and J Series Processors for Internet of Things (IoT) Applications](https://cdrdv2.intel.com/v1/dl/getContent/636674) for details.
- Update for functional issues. Refer to [Intel® Pentium® Silver and Intel® Celeron® Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/336562) for details.
- Update for functional issues. Refer to [Intel® Pentium® Silver and Intel® Celeron® Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634542) for details.




### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| EMR-SP         | A-1      | 06-cf-02/87 |          | 21000200 | Xeon Scalable Gen5
| EMR-SP         | A-0      | 06-cf-01/87 |          | 21000200 | Xeon Scalable Gen5
| MTL            | C-0      | 06-aa-04/e6 |          | 0000001c | Core™ Ultra Processor

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 00000032 | 00000034 | Core Gen12
| ADL            | H0       | 06-97-05/07 | 00000032 | 00000034 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000430 | 00000432 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 00000430 | 00000432 | Core Gen12
| ADL-N          | N0       | 06-be-00/11 | 00000012 | 00000015 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AML-Y42        | V0       | 06-8e-0c/94 | 000000f8 | 000000fa | Core Gen10 Mobile
| BDX-NS         | A1       | 06-56-05/10 | 0e000014 | 0e000015 | Xeon D-1513N/23/33/43/53
| CFL-H          | R0       | 06-9e-0d/22 | 000000fa | 000000fc | Core Gen9 Mobile
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000f4 | 000000f6 | Core Gen9
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000f4 | 000000f6 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | P0       | 06-9e-0c/22 | 000000f4 | 000000f6 | Core Gen9 Desktop
| CLX-SP         | B0       | 06-55-06/bf | 04003604 | 04003605 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05003604 | 05003605 | Xeon Scalable Gen2
| CML-H          | R1       | 06-a5-02/20 | 000000f8 | 000000fa | Core Gen10 Mobile
| CML-S102       | Q0       | 06-a5-05/22 | 000000f8 | 000000fa | Core Gen10
| CML-S62        | G1       | 06-a5-03/22 | 000000f8 | 000000fa | Core Gen10
| CML-U42        | V0       | 06-8e-0c/94 | 000000f8 | 000000fa | Core Gen10 Mobile
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000f8 | 000000fa | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000f8 | 000000fa | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000f8 | 000000fa | Core Gen10 Mobile
| CPX-SP         | A1       | 06-55-0b/bf | 07002703 | 07002802 | Xeon Scalable Gen3
| DNV            | B0       | 06-5f-01/01 | 00000038 | 0000003e | Atom C Series
| EHL            | B1       | 06-96-01/01 | 00000017 | 00000019 | Pentium J6426/N6415, Celeron J6412/J6413/N6210/N6211, Atom x6000E
| GLK            | B0       | 06-7a-01/01 | 0000003e | 00000040 | Pentium Silver N/J5xxx, Celeron N/J4xxx
| GLK-R          | R0       | 06-7a-08/01 | 00000022 | 00000024 | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-D          | B0       | 06-6c-01/10 | 01000268 | 01000290 | Xeon D-17xx, D-27xx
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000c2 | 000000c4 | Core Gen10 Mobile
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d0003b9 | 0d0003d1 | Xeon Scalable Gen3
| JSL            | A0/A1    | 06-9c-00/01 | 24000024 | 24000026 | Pentium N6000/N6005, Celeron N4500/N4505/N5100/N5105
| KBL-G/H/S/X/E3 | B0       | 06-9e-09/2a | 000000f4 | 000000f8 | Core Gen7; Xeon E3 v6
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 0000411c | 00004121 | Core Gen13
| RPL-S          | B0       | 06-b7-01/32 | 0000011d | 00000122 | Core Gen13
| RPL-S          | H0       | 06-bf-05/07 | 00000032 | 00000034 | Core Gen12
| RKL-S          | B0       | 06-a7-01/02 | 0000005d | 0000005e | Core Gen11
| RPL-S/HX       | C0       | 06-bf-02/07 | 00000032 | 00000034 | Core Gen12
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 0000411c | 00004121 | Core Gen13
| SKX-SP         | B1       | 06-55-03/97 | 01000181 | 01000191 | Xeon Scalable
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b0004d0 | 2b000590 | Xeon Scalable Gen4
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b0004d0 | 2b000590 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 | 2b0004d0 | 2b000590 | Xeon Scalable Gen4
| SPR-SP         | E2       | 06-8f-05/87 | 2b0004d0 | 2b000590 | Xeon Scalable Gen4
| TGL            | B0/B1    | 06-8c-01/80 | 000000b4 | 000000b6 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 0000004e | 00000050 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000034 | 00000036 | Core Gen11 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000f8 | 000000fa | Core Gen8 Mobile


# Release Notes
## [microcode-20231114](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20231114)

### Purpose

- Security updates for [INTEL-SA-00950](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00950.html)

- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634897) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update ](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------


### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/07 | 0000002e | 00000032 | Core Gen12
| ADL            | H0       | 06-97-05/07 | 0000002e | 00000032 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 0000042c | 00000430 | Core Gen12
| ADL            | R0       | 06-9a-04/80 | 0000042c | 00000430 | Core Gen12
| ADL-N          | N0       | 06-be-00/11 | 00000011 | 00000012 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AZB            | A0       | 06-9a-04/40 | 00000004 | 00000005 | Intel(R) Atom(R) C1100
| AZB            | R0       | 06-9a-04/40 | 00000004 | 00000005 | Intel(R) Atom(R) C1100
| ICL-D          | B0       | 06-6c-01/10 | 01000230 | 01000268 | Xeon D-17xx, D-27xx
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d0003a5 | 0d0003b9 | Xeon Scalable Gen3
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000bc | 000000c2 | Core Gen10 Mobile
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 | 00004119 | 0000411c | Core Gen13
| RPL-S          | B0       | 06-b7-01/32 | 00000119 | 0000011d | Core Gen13
| RKL-S          | B0       | 06-a7-01/02 | 00000059 | 0000005d | Core Gen11
| RPL-S          | H0       | 06-bf-05/07 | 0000002e | 00000032 | Core Gen12
| RPL-S/HX       | C0       | 06-bf-02/07 | 0000002e | 00000032 | Core Gen12
| RPL-U 2+8      | Q0       | 06-ba-03/e0 | 00004119 | 0000411c | Core Gen13
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b0004b1 | 2b0004d0 | Xeon Scalable Gen4
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b0004b1 | 2b0004d0 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 | 2b0004b1 | 2b0004d0 | Xeon Scalable Gen4
| SPR-SP         | E2       | 06-8f-05/87 | 2b0004b1 | 2b0004d0 | Xeon Scalable Gen4
| SPR-SP         | E0       | 06-8f-04/87 | 2b0004b1 | 2b0004d0 | Xeon Scalable Gen4
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c000271 | 2c000290 | Xeon Max
| TGL            | B0/B1    | 06-8c-01/80 | 000000ac | 000000b4 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000046 | 0000004e | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 0000002c | 00000034 | Core Gen11 Mobile

# Release Notes
## [microcode-20230808](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20230808)

### Purpose

- Security updates for [INTEL-SA-00828](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00828.html)
- Security updates for [INTEL-SA-00836](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00836.html)
- Security updates for [INTEL-SA-00837](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00837.html)

- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel® Core™ Processor Family Spec Update](https://cdrdv2.intel.com/v1/dl/getContent/337346) for details.
- Update for functional issues. Refer to [8th Generation Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338025) for details.
- Update for functional issues. Refer to [7th and 8th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/334663) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634897) for details.
- Update for functional issues. Refer to [2nd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/613537) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2100 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338854) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL-N     | A0    | 06-be-00/11 |     | 00000011 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| RPL-H/P/PX 6+8 | J0    | 06-ba-02/e0 |     | 00004119 | Core Gen13

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000f6 | 000000f8 | Core Gen10 Mobile
| SKX-D          | H0       | 06-55-04/b7 | 02006f05 | 02007006 | Xeon D-21xx
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006e05 | 02007006 | Xeon Scalable
| KBL-G/H/S/X/E3 | B0       | 06-9e-09/2a | 000000f2 | 000000f4 | Core Gen7; Xeon E3 v6
| ADL            | L0       | 06-9a-03/80 | 0000042a | 0000042c | Core Gen12
| ADL            | L0       | 06-9a-04/80 | 0000042a | 0000042c | Core Gen12
| ICX-SP         | Dx/M1    | 06-6a-06/87 | 0d000390 | 0d0003a5 | Xeon Scalable Gen3
| CML-S102       | Q0       | 06-a5-05/22 | 000000f6 | 000000f8 | Core Gen10
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000f2 | 000000f4 | Core Gen8 Mobile
| KBL-R U        | Y0       | 06-8e-0a/c0 | 000000f2 | 000000f4 | Core Gen8 Mobile
| CFL-H          | R0       | 06-9e-0d/22 | 000000f8 | 000000fa | Core Gen9 Mobile
| RKL-S          | B0       | 06-a7-01/02 | 00000058 | 00000059 | Core Gen11
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000ba | 000000bc | Core Gen10 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000044 | 00000046 | Core Gen11 Mobile
| SPR-SP         | E5/S3    | 06-8f-08/87 | 2b000461 | 2b0004b1 | Xeon Scalable Gen4
| SPR-SP         | E4/S2    | 06-8f-07/87 | 2b000461 | 2b0004b1 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 | 2b000461 | 2b0004b1 | Xeon Scalable Gen4
| SPR-SP         | E2       | 06-8f-05/87 | 2b000461 | 2b0004b1 | Xeon Scalable Gen4
| SPR-SP         | E0       | 06-8f-04/87 | 2b000461 | 2b0004b1 | Xeon Scalable Gen4
| CML-S62        | G1       | 06-a5-03/22 | 000000f6 | 000000f8 | Core Gen10
| AML-Y22        | H0       | 06-8e-09/10 | 000000f0 | 000000f4 | Core Gen8 Mobile
| RPL-S          | B0       | 06-b7-01/32 | 00000113 | 00000119 | Core Gen13
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000f6 | 000000f8 | Core Gen10 Mobile
| ADL-N          | A0       | 06-be-00/11 |          | 00000011 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| CPX-SP         | A1       | 06-55-0b/bf | 07002601 | 07002703 | Xeon Scalable Gen3
| CLX-SP         | B0       | 06-55-06/bf | 04003501 | 04003604 | Xeon Scalable Gen2
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000f2 | 000000f4 | Core Gen8 Desktop, Mobile, Xeon E
| SPR-HBM        | Bx       | 06-8f-08/10 | 2c0001d1 | 2c000271 | Xeon Max
| WHL-U          | W0       | 06-8e-0b/d0 | 000000f2 | 000000f4 | Core Gen8 Mobile
| CLX-SP         | B1       | 06-55-07/bf | 05003501 | 05003604 | Xeon Scalable Gen2
| CFL-S          | B0       | 06-9e-0b/02 | 000000f2 | 000000f4 | Core Gen8
| TGL-R          | C0       | 06-8c-02/c2 | 0000002a | 0000002c | Core Gen11 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000f2 | 000000f4 | Core Gen7 Mobile
| KBL-U23e       | J1       | 06-8e-09/c0 | 000000f2 | 000000f4 | Core Gen7 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000f6 | 000000f8 | Core Gen10 Mobile
| CML-U42        | V0       | 06-8e-0c/94 | 000000f6 | 000000f8 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000f6 | 000000f8 | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000f6 | 000000f8 | Core Gen8 Mobile
| SKX-SP         | B1       | 06-55-03/97 | 01000171 | 01000181 | Xeon Scalable
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000f2 | 000000f4 | Core Gen9
| CFL-S          | P0       | 06-9e-0c/22 | 000000f2 | 000000f4 | Core Gen9 Desktop
| TGL            | B0/B1    | 06-8c-01/80 | 000000aa | 000000ac | Core Gen11 Mobile
| ADL            | C0       | 06-97-02/07 | 0000002c | 0000002e | Core Gen12
| ADL            | C0       | 06-97-05/07 | 0000002c | 0000002e | Core Gen12
| ADL            | C0       | 06-bf-02/07 | 0000002c | 0000002e | Core Gen12
| ADL            | C0       | 06-bf-05/07 | 0000002c | 0000002e | Core Gen12
| CML-H          | R1       | 06-a5-02/20 | 000000f6 | 000000f8 | Core Gen10 Mobile
| RPL-H/P/PX 6+8 | J0       | 06-ba-02/e0 |          | 00004119 | Core Gen13
| RPL-U 2+8      | Q0       | 06-ba-03/e0 |          | 00004119 | Core Gen13


# Release Notes
## [microcode-20230512-rev2](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20230512-rev2)

### Purpose
- Update for functional issues. Refer to [13th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518) for details.
- Update for functional issues. Refer to [12th Generation Intel® Core™ Processor Family](https://cdrdv2.intel.com/v1/dl/getContent/682436) for details.
- Update for functional issues. Refer to [11th Gen Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [10th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/615213) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel® Core™ Processor Family Spec Update](https://cdrdv2.intel.com/v1/dl/getContent/337346) for details.
- Update for functional issues. Refer to [8th Generation Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338025) for details.
- Update for functional issues. Refer to [7th and 8th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/334663) for details.
- Update for functional issues. Refer to [Intel® Processors and Intel® Core™ i3 N-Series](https://cdrdv2.intel.com/v1/dl/getContent/764616) for details.
- Update for functional issues. Refer to [4th Gen Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/772415) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Scalable Processors Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634897) for details.
- Update for functional issues. Refer to [2nd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/613537) for details.
- Update for functional issues. Refer to [3rd Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2300 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/709192) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2700 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/714071) for details.
- Update for functional issues. Refer to [Intel® Xeon® D-2100 Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338854) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL-N          | A0       | 06-be-00/01 |          | 00000010 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AZB            | A0       | 06-9a-04/40 |          | 00000004 | Intel(R) Atom(R) C1100
| AZB            | R0       | 06-9a-04/40 |          | 00000004 | Intel(R) Atom(R) C1100

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | L0       | 06-9a-03/80 | 00000429 | 0000042a | Core Gen12
| ADL            | L0       | 06-9a-04/80 | 00000429 | 0000042a | Core Gen12
| AML-Y22        | H0       | 06-8e-09/10 | 000000f0 | 000000f2 | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CFL-H          | R0       | 06-9e-0d/22 | 000000f4 | 000000f8 | Core Gen9 Mobile
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000f0 | 000000f2 | Core Gen9
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000f0 | 000000f2 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000f0 | 000000f2 | Core Gen8
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000f0 | 000000f2 | Core Gen8 Mobile
| CLX-SP         | B0       | 06-55-06/bf | 04003303 | 04003501 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05003303 | 05003501 | Xeon Scalable Gen2
| CML-H          | R1       | 06-a5-02/20 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CML-S102       | Q0       | 06-a5-05/22 | 000000f4 | 000000f6 | Core Gen10
| CML-S62        | G1       | 06-a5-03/22 | 000000f4 | 000000f6 | Core Gen10
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CPX-SP         | A1       | 06-55-0b/bf | 07002503 | 07002601 | Xeon Scalable Gen3
| ICL-D          | B0       | 06-6c-01/10 | 01000211 | 01000230 | Xeon D-17xx, D-27xx
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000b8 | 000000ba | Core Gen10 Mobile
| ICX-SP         | D0       | 06-6a-06/87 | 0d000389 | 0d000390 | Xeon Scalable Gen3
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000f0 | 000000f2 | Core Gen7; Xeon E3 v6
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000f0 | 000000f2 | Core Gen7 Mobile
| LKF            | B2/B3    | 06-8a-01/10 | 00000032 | 00000033 | Core w/Hybrid Technology
| RKL-S          | B0       | 06-a7-01/02 | 00000057 | 00000058 | Core Gen11
| RPL-H 6+8      | J0       | 06-ba-02/07 | 0000410e | 00004112 | Core Gen13
| RPL-P 6+8      | J0       | 06-ba-02/07 | 0000410e | 00004112 | Core Gen13
| RPL-S          | S0       | 06-b7-01/32 | 00000112 | 00000113 | Core Gen13
| RPL-U 2+8      | Q0       | 06-ba-03/07 | 0000410e | 00004112 | Core Gen13
| SKX-D          | H0       | 06-55-04/b7 | 02006e05 | 02006f05 | Xeon D-21xx
| SKX-SP         | B1       | 06-55-03/97 | 01000161 | 01000171 | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006e05 | 02006f05 | Xeon Scalable
| SPR-HBM        | B3       | 06-8f-08/10 | 2c000170 | 2c0001d1 | Xeon Max
| SPR-SP         | E0       | 06-8f-04/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E2       | 06-8f-05/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E4       | 06-8f-07/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E5       | 06-8f-08/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | S2       | 06-8f-07/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | S3       | 06-8f-08/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| TGL            | B1       | 06-8c-01/80 | 000000a6 | 000000aa | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000042 | 00000044 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000028 | 0000002a | Core Gen11 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000f4 | 000000f6 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000f0 | 000000f2 | Core Gen8 Mobile

# Release Notes
## [microcode-20230512](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20230512)

### Functional Updates

- Security updates for [INTEL-SA-NA]
*Microcode 20230512 update released on May 12, 2023, does not contain any security updates and the note, [INTEL-SA-NA] is meant to convey that there are no applicable (Not Applicable) security updates in the package.*

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL-N          | A0       | 06-be-00/01 |          | 00000010 | Core i3-N305/N300, N50/N97/N100/N200, Atom x7211E/x7213E/x7425E
| AZB            | A0       | 06-9a-04/40 |          | 00000004 | Intel(R) Atom(R) C1100
| AZB            | R0       | 06-9a-04/40 |          | 00000004 | Intel(R) Atom(R) C1100

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | L0       | 06-9a-03/80 | 00000429 | 0000042a | Core Gen12
| ADL            | L0       | 06-9a-04/80 | 00000429 | 0000042a | Core Gen12
| AML-Y22        | H0       | 06-8e-09/10 |          | 000000f2 | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CFL-H          | R0       | 06-9e-0d/22 | 000000f4 | 000000f8 | Core Gen9 Mobile
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000f0 | 000000f2 | Core Gen9
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000f0 | 000000f2 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000f0 | 000000f2 | Core Gen8
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000f0 | 000000f2 | Core Gen8 Mobile
| CLX-SP         | B0       | 06-55-06/bf | 04003303 | 04003501 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05003303 | 05003501 | Xeon Scalable Gen2
| CML-H          | R1       | 06-a5-02/20 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CML-S102       | Q0       | 06-a5-05/22 | 000000f4 | 000000f6 | Core Gen10
| CML-S62        | G1       | 06-a5-03/22 | 000000f4 | 000000f6 | Core Gen10
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000f4 | 000000f6 | Core Gen10 Mobile
| CPX-SP         | A1       | 06-55-0b/bf | 07002503 | 07002601 | Xeon Scalable Gen3
| ICL-D          | B0       | 06-6c-01/10 | 01000211 | 01000230 | Xeon D-17xx, D-27xx
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000b8 | 000000ba | Core Gen10 Mobile
| ICX-SP         | D0       | 06-6a-06/87 | 0d000389 | 0d000390 | Xeon Scalable Gen3
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000f0 | 000000f2 | Core Gen7; Xeon E3 v6
| KBL-U/Y        | H0       | 06-8e-09/c0 |          | 000000f2 | Core Gen7 Mobile
| LKF            | B2/B3    | 06-8a-01/10 | 00000032 | 00000033 | Core w/Hybrid Technology
| RKL-S          | B0       | 06-a7-01/02 | 00000057 | 00000058 | Core Gen11
| RPL-H 6+8      | J0       | 06-ba-02/07 | 0000410e | 00004112 | Core Gen13
| RPL-P 6+8      | J0       | 06-ba-02/07 | 0000410e | 00004112 | Core Gen13
| RPL-S          | S0       | 06-b7-01/32 | 00000112 | 00000113 | Core Gen13
| RPL-U 2+8      | Q0       | 06-ba-03/07 | 0000410e | 00004112 | Core Gen13
| SKX-D          | H0       | 06-55-04/b7 |          | 02006f05 | Xeon D-21xx
| SKX-SP         | B1       | 06-55-03/97 | 01000161 | 01000171 | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 |          | 02006f05 | Xeon Scalable
| SPR-HBM        | B3       | 06-8f-08/10 | 2c000170 | 2c0001d1 | Xeon Max
| SPR-SP         | E0       | 06-8f-04/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E2       | 06-8f-05/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E4       | 06-8f-07/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | E5       | 06-8f-08/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | S2       | 06-8f-07/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| SPR-SP         | S3       | 06-8f-08/87 | 2b000181 | 2b000461 | Xeon Scalable Gen4
| TGL            | B1       | 06-8c-01/80 | 000000a6 | 000000aa | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000042 | 00000044 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000028 | 0000002a | Core Gen11 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000f4 | 000000f6 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 |          | 000000f2 | Core Gen8 Mobile


# Release Notes
## [microcode-20230214](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20230214)

### Purpose

- Security updates for [INTEL-SA-00767](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00767.html)
- Security updates for [INTEL-SA-00738](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00738.html)
- Security updates for [INTEL-SA-00700](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00700.html)

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SPR-SP         | E2       | 06-8f-05/87 |          | 2b000181 | Xeon Scalable Gen4
| SPR-SP         | E3       | 06-8f-06/87 |          | 2b000181 | Xeon Scalable Gen4
| SPR-SP         | E4       | 06-8f-07/87 |          | 2b000181 | Xeon Scalable Gen4
| SPR-SP         | E5       | 06-8f-08/87 |          | 2b000181 | Xeon Scalable Gen4
| SPR-HBM        | B3       | 06-8f-08/10 |          | 2c000170 | Xeon Max
| RPL-P 6+8      | J0       | 06-ba-02/07 |          | 0000410e | Core Gen13
| RPL-H 6+8      | J0       | 06-ba-02/07 |          | 0000410e | Core Gen13
| RPL-U 2+8      | Q0       | 06-ba-02/07 |          | 0000410e | Core Gen13

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL      | C0    | 06-97-02/07 | 00000026 | 0000002c | Core Gen12
| ADL      | C0    | 06-97-05/07 | 00000026 | 0000002c | Core Gen12
| ADL      | C0    | 06-bf-02/07 | 00000026 | 0000002c | Core Gen12
| ADL      | C0    | 06-bf-05/07 | 00000026 | 0000002c | Core Gen12
| ADL      | L0    | 06-9a-03/80 | 00000424 | 00000429 | Core Gen12
| ADL      | L0    | 06-9a-04/80 | 00000424 | 00000429 | Core Gen12
| CLX-SP   | B0    | 06-55-06/bf | 04003302 | 04003303 | Xeon Scalable Gen2
| CLX-SP   | B1    | 06-55-07/bf | 05003302 | 05003303 | Xeon Scalable Gen2
| CPX-SP   | A1    | 06-55-0b/bf | 07002501 | 07002503 | Xeon Scalable Gen3
| GLK      | B0    | 06-7a-01/01 | 0000003c | 0000003e | Pentium Silver N/J5xxx, Celeron N/J4xxx
| GLK-R    | R0    | 06-7a-08/01 | 00000020 | 00000022 | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-D    | B0    | 06-6c-01/10 | 01000201 | 01000211 | Xeon D-17xx, D-27xx
| ICL-U/Y  | D1    | 06-7e-05/80 | 000000b6 | 000000b8 | Core Gen10 Mobile
| ICX-SP   | D0    | 06-6a-06/87 | 0d000375 | 0d000389 | Xeon Scalable Gen3
| JSL      | A0/A1 | 06-9c-00/01 | 24000023 | 24000024 | Pentium N6000/N6005, Celeron N4500/N4505/N5100/N5105
| LKF      | B2/B3 | 06-8a-01/10 | 00000031 | 00000032 | Core w/Hybrid Technology
| RKL-S    | B0    | 06-a7-01/02 | 00000056 | 00000057 | Core Gen11
| RPL-S    | S0    | 06-b7-01/32 | 0000010e | 00000112 | Core Gen13
| SKX-SP   | B1    | 06-55-03/97 | 0100015e | 01000161 | Xeon Scalable

# Release Notes
## [microcode-20221108](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20221108)

### Purpose

- Update for functional issues. Refer to [Intel(R) Xeon(R) D-2700 Processor Family Specification Update](https://www.intel.com/content/www/us/en/content-details/714071/intel-xeon-d-2700-processor-family-specification-update.html) for details.
- Update for functional issues. Refer to [13th Generation Intel(R) Core(TM) Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/740518)
- Update for functional issues. Refer to [12th Generation Intel(R) Core(TM) Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/682436)
- Update for functional issues. Refer to [11th Generation Intel(R) Core(TM) Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634808) for details.
- Update for functional issues. Refer to [10th Generation Intel(R) Core(TM) Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/615213) for details.
- Update for functional issues. Refer to [8th and 9th Generation Intel(R) Core(TM) Processor Family Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/8th-gen-core-spec-update.html?wapkw=processor+specification+update) for details.
- Update for functional issues. Refer to [8th Generation Intel(R) Core(TM) Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338025) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ICL-D          | B0       | 06-6c-01/10 |          | 01000201 | Xeon D-17xx, D-27xx
| RPL-S          | S0       | 06-b7-01/32 |          | 0000010e | Core Gen13

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000b2 | 000000b6 | Core Gen10 Mobile
| TGL            | B1       | 06-8c-01/80 | 000000a4 | 000000a6 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 00000040 | 00000042 | Core Gen11 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000f0 | 000000f4 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000f0 | 000000f4 | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000f0 | 000000f4 | Core Gen8 Mobile
| EHL            | B1       | 06-96-01/01 | 00000016 | 00000017 | Pentium J6426/N6415, Celeron J6412/J6413/N6210/N6211, Atom x6000E
| ADL            | C0       | 06-97-02/07 | 00000022 | 00000026 | Core Gen12
| ADL            | C0       | 06-97-05/07 | 00000022 | 00000026 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 00000421 | 00000424 | Core Gen12
| ADL            | L0       | 06-9a-04/80 | 00000421 | 00000424 | Core Gen12
| CFL-H          | R0       | 06-9e-0d/22 | 000000f0 | 000000f4 | Core Gen9 Mobile
| CML-H          | R1       | 06-a5-02/20 | 000000f0 | 000000f4 | Core Gen10 Mobile
| CML-S62        | G1       | 06-a5-03/22 | 000000f0 | 000000f4 | Core Gen10
| CML-S102       | Q0       | 06-a5-05/22 | 000000f0 | 000000f4 | Core Gen10
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000f0 | 000000f4 | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000f0 | 000000f4 | Core Gen10 Mobile
| RKL-S          | B0       | 06-a7-01/02 | 00000054 | 00000056 | Core Gen11
| ADL            | C0       | 06-bf-02/07 | 00000022 | 00000026 | Core Gen12
| ADL            | C0       | 06-bf-05/07 | 00000022 | 00000026 | Core Gen12

### Removed Platforms

None

# Release Notes
## [microcode-20220809](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20220809)

### Purpose

- Security updates for [INTEL-SA-00657](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00657.html)
- Security updates for [INTEL-SA-00614](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00614.html) 
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/scalable/
xeon-scalable-spec-update.html?wapkw=processor+specification+update) for details.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SKX-SP         | B1       | 06-55-03/97 | 0100015d | 0100015e | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006d05 | 02006e05 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02006d05 | 02006e05 | Xeon D-21xx
| ICX-SP         | D0       | 06-6a-06/87 | 0d000363 | 0d000375 | Xeon Scalable Gen3
| GLK            | B0       | 06-7a-01/01 | 0000003a | 0000003c | Pentium Silver N/J5xxx, Celeron N/J4xxx
| GLK-R          | R0       | 06-7a-08/01 | 0000001e | 00000020 | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000b0 | 000000b2 | Core Gen10 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000026 | 00000028 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 0000003e | 00000040 | Core Gen11 Mobile
| ADL            | C0       | 06-97-02/03 | 0000001f | 00000022 | Core Gen12
| ADL            | C0       | 06-97-05/03 | 0000001f | 00000022 | Core Gen12
| ADL            | L0       | 06-9a-03/80 | 0000041c | 00000421 | Core Gen12
| ADL            | L0       | 06-9a-04/80 | 0000041c | 00000421 | Core Gen12
| RKL-S          | B0       | 06-a7-01/02 | 00000053 | 00000054 | Core Gen11
| ADL            | C0       | 06-bf-02/03 | 0000001f | 00000022 | Core Gen12
| ADL            | C0       | 06-bf-05/03 | 0000001f | 00000022 | Core Gen12

### Removed Platforms

None

## [microcode-20220510](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20220510)

### Purpose

- Security updates for [INTEL-SA-000617](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00617.html)
- Update for functional issues. Refer to [Second Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/scalable/xeon-scalable-spec-update.html?wapkw=processor+specification+update) for details.
- Update for functional issues. Refer to [Intel Atom® C3000 Processor Product Family Specification Update](https://www.intel.com/content/www/us/en/processors/atom/atom-c3000-family-spec-update.html?wapkw=processor+specification+update) for details.
- Update for functional issues. Refer to [Intel Atom® Processor E3900 Specification Update Addendum](https://cdrdv2.intel.com/v1/dl/getContent/612204) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ADL            | C0       | 06-97-02/03 |          | 0000001f | Core Gen12
| ADL            | C0       | 06-97-05/03 |          | 0000001f | Core Gen12
| ADL            | L0       | 06-9a-03/80 |          | 0000041c | Core Gen12
| ADL            | L0       | 06-9a-04/80 |          | 0000041c | Core Gen12
| ADL            | C0       | 06-bf-02/03 |          | 0000001f | Core Gen12
| ADL            | C0       | 06-bf-05/03 |          | 0000001f | Core Gen12

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| VLV            | D0       | 06-37-09/0F | 0000090c | 0000090d | Atom E38xx
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000ec | 000000f0 | Core Gen6 Mobile
| SKX-SP         | B1       | 06-55-03/97 | 0100015c | 0100015d | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006c0a | 02006d05 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02006c0a | 02006d05 | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 0400320a | 04003302 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 0500320a | 05003302 | Xeon Scalable Gen2
| CPX-SP         | A1       | 06-55-0b/bf | 07002402 | 07002501 | Xeon Scalable Gen3
| APL            | D0       | 06-5c-09/03 | 00000046 | 00000048 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| APL            | E0       | 06-5c-0a/03 | 00000024 | 00000028 | Atom x5-E39xx
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000ec | 000000f0 | Core Gen6; Xeon E3 v5
| DNV            | B0       | 06-5f-01/01 | 00000036 | 00000038 | Atom C Series
| ICX-SP         | D0       | 06-6a-06/87 | 0d000331 | 0d000363 | Xeon Scalable Gen3
| GLK            | B0       | 06-7a-01/01 | 00000038 | 0000003a | Pentium Silver N/J5xxx, Celeron N/J4xxx
| GLK-R          | R0       | 06-7a-08/01 | 0000001c | 0000001e | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000a8 | 000000b0 | Core Gen10 Mobile
| LKF            | B2/B3    | 06-8a-01/10 | 0000002d | 00000031 | Core w/Hybrid Technology
| TGL            | B1       | 06-8c-01/80 | 0000009a | 000000a4 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000022 | 00000026 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 0000003c | 0000003e | Core Gen11 Mobile
| AML-Y22        | H0       | 06-8e-09/10 | 000000ec | 000000f0 | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000ec | 000000f0 | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000ec | 000000f0 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000ec | 000000f0 | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000ec | 000000f0 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000ec | 000000f0 | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000ec | 000000f0 | Core Gen8 Mobile
| EHL            | B1       | 06-96-01/01 | 00000015 | 00000016 | Pentium J6426/N6415, Celeron J6412/J6413/N6210/N6211, Atom x6000E
| JSL            | A0/A1    | 06-9c-00/01 | 2400001f | 24000023 | Pentium N6000/N6005, Celeron N4500/N4505/N5100/N5105
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000ec | 000000f0 | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000ec | 000000f0 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000ec | 000000f0 | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000ec | 000000f0 | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000ec | 000000f0 | Core Gen9 Mobile
| CML-H          | R1       | 06-a5-02/20 | 000000ec | 000000f0 | Core Gen10 Mobile
| CML-S62        | G1       | 06-a5-03/22 | 000000ec | 000000f0 | Core Gen10
| CML-S102       | Q0       | 06-a5-05/22 | 000000ee | 000000f0 | Core Gen10
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000ea | 000000f0 | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000ec | 000000f0 | Core Gen10 Mobile
| RKL-S          | B0       | 06-a7-01/02 | 00000050 | 00000053 | Core Gen11

### Removed Platforms

None

## [microcode-20220419](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20220419)

### Purpose

- Update for functional issues. Refer to errata APLI-11 in [Intel® Atom® Processor E3900 Series](https://cdrdv2.intel.com/v1/dl/getContent/612204) for details.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| APL            | E0       | 06-5c-0a/03 | 00000024 | 00000028 | Atom x5-E39xx

### Removed Platforms

None


## [microcode-2022027](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20220207)

### Purpose

- Security updates for [INTEL-SA-00528](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00528.html)
- Security updates for [INTEL-SA-00532](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00532.html)
- Update for functional issues. Refer to [Third Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780) for details.
- Update for functional issues. Refer to [Second Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/scalable/xeon-scalable-spec-update.html?wapkw=processor+specification+update) for details.
- Update for functional issues. Refer to [11th Generation Intel® Core™ Processor Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/631123) for details.
- Update for functional issues. Refer to [11th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/634808) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/341079) for details.
- Update for functional issues. Refer to [10th Generation Intel® Core™ Processor Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/615213) for details.
- Update for functional issues. Refer to [8th Generation Intel® Core™ Processor Families Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338025) for details.
- Update for functional issues. Refer to [8th Gen Intel® Core™ Processor Family Spec Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/8th-gen-core-family-spec-update.html?wapkw=processor+specification+update) for details.
- Update for functional issues. Refer to [7th and 8th Generation Intel® Core™ Processor Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/334663) for details.
- Update for functional issues. Refer to [6th Generation Intel® Processor Family Specification Update](https://www.intel.com/content/www/us/en/processors/core/desktop-6th-gen-core-family-spec-update.html) for details.
- Update for functional issues. Refer to [Intel® Pentium® Silver and Intel® Celeron® Processors](https://www.intel.com/content/www/us/en/products/docs/processors/pentium/silver-celeron-spec-update.html?wapkw=processor+specification+update) for details.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| HSX-E/EP       | Cx/M1    | 06-3f-02/6f | 00000046 | 00000049 | Core Gen4 X series; Xeon E5 v3
| HSX-EX         | E0       | 06-3f-04/80 | 00000019 | 0000001a | Xeon E7 v3
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000ea | 000000ec | Core Gen6 Mobile
| BDX-ML         | B0/M0/R0 | 06-4f-01/ef | 0b00003e | 0b000040 | Xeon E5/E7 v4; Core i7-69xx/68xx
| SKX-SP         | B1       | 06-55-03/97 | 0100015b | 0100015c | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006b06 | 02006c0a | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02006b06 | 02006c0a | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 04003102 | 0400320a | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05003102 | 0500320a | Xeon Scalable Gen2
| CPX-SP         | A1       | 06-55-0b/bf | 07002302 | 07002402 | Xeon Scalable Gen3
| BDX-DE         | V2/V3    | 06-56-03/10 | 0700001b | 0700001c | Xeon D-1518/19/21/27/28/31/33/37/41/48, Pentium D1507/08/09/17/19
| BDX-DE         | Y0       | 06-56-04/10 | 0f000019 | 0f00001a | Xeon D-1557/59/67/71/77/81/87
| BDX-NS         | A1       | 06-56-05/10 | 0e000012 | 0e000014 | Xeon D-1513N/23/33/43/53
| APL            | D0       | 06-5c-09/03 | 00000044 | 00000046 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| APL            | E0       | 06-5c-0a/03 | 00000020 | 00000024 | Atom x5-E39xx
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000ea | 000000ec | Core Gen6; Xeon E3 v5
| DNV            | B0       | 06-5f-01/01 | 00000034 | 00000036 | Atom C Series
| ICX-SP         | D0       | 06-6a-06/87 | 0d0002a0 | 0d000331 | Xeon Scalable Gen3
| GLK            | B0       | 06-7a-01/01 | 00000036 | 00000038 | Pentium Silver N/J5xxx, Celeron N/J4xxx
| GLK-R          | R0       | 06-7a-08/01 | 0000001a | 0000001c | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000a6 | 000000a8 | Core Gen10 Mobile
| LKF            | B2/B3    | 06-8a-01/10 | 0000002a | 0000002d | Core w/Hybrid Technology
| TGL            | B1       | 06-8c-01/80 | 00000088 | 0000009a | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 | 00000016 | 00000022 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 | 0000002c | 0000003c | Core Gen11 Mobile
| AML-Y22        | H0       | 06-8e-09/10 | 000000ea | 000000ec | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000ea | 000000ec | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000ea | 000000ec | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000ea | 000000ec | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000ea | 000000ec | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000ea | 000000ec | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000ea | 000000ec | Core Gen8 Mobile
| EHL            | B1       | 06-96-01/01 | 00000011 | 00000015 | Pentium J6426/N6415, Celeron J6412/J6413/N6210/N6211, Atom x6000E
| JSL            | A0/A1    | 06-9c-00/01 | 0000001d | 2400001f | Pentium N6000/N6005, Celeron N4500/N4505/N5100/N5105
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000ea | 000000ec | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000ea | 000000ec | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000ea | 000000ec | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000ea | 000000ec | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000ea | 000000ec | Core Gen9 Mobile
| CML-H          | R1       | 06-a5-02/20 | 000000ea | 000000ec | Core Gen10 Mobile
| CML-S62        | G1       | 06-a5-03/22 | 000000ea | 000000ec | Core Gen10
| CML-S102       | Q0       | 06-a5-05/22 | 000000ec | 000000ee | Core Gen10
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000e8 | 000000ea | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000ea | 000000ec | Core Gen10 Mobile
| RKL-S          | B0       | 06-a7-01/02 | 00000040 | 00000050 | Core Gen11

### Removed Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SNR            | B0       | 06-86-04/01 | 0b00000f |          | Atom P59xxB
| SNR            | B1       | 06-86-05/01 | 0b00000f |          | Atom P59xxB


## [microcode-20210608](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20210608)

### Purpose

- Security updates for [INTEL-SA-00442](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00442.html)
- Security updates for [INTEL-SA-00464](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00464.html)
- Security updates for [INTEL-SA-00465](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00465.html)
- Update for functional issues. Refer to [Third Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/637780)for details.
- Update for functional issues. Refer to [Second Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/613537) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor D-1500, D-1500 NS and D-1600 NS Spec Update](https://www.intel.com/content/www/us/en/products/docs/processors/xeon/xeon-d-1500-specification-update.html) for details.
- Update for functional issues. Refer to [Intel® Xeon® E7-8800 and E7-4800 v3 Processor Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e7-v3-spec-update.html) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor E5 v3 Product Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e5-v3-spec-update.html?wapkw=processor+spec+update+e5) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/10th-gen-core-families-specification-update.html) for details.
- Update for functional issues. Refer to [8th and 9th Gen Intel® Core™ Processor Family Spec Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/8th-gen-core-spec-update.html) for details.
- Update for functional issues. Refer to [7th Gen and 8th Gen (U Quad-Core) Intel® Processor Families Specification Update](https://www.intel.com/content/www/us/en/processors/core/7th-gen-core-family-spec-update.html) for details.
- Update for functional issues. Refer to [6th Gen Intel® Processor Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/332689) for details.
- Update for functional issues. Refer to [Intel® Xeon® E3-1200 v6 Processor Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e3-1200v6-spec-update.html) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2100 and E-2200 Processor Family Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/xeon/xeon-e-2100-specification-update.html) for details.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| CLX-SP         | A0       | 06-55-05/b7 |          | 03000010 | Xeon Scalable Gen2
| ICX-SP         | C0       | 06-6a-05/87 |          | 0c0002f0 | Xeon Scalable Gen3
| ICX-SP         | D0       | 06-6a-06/87 |          | 0d0002a0 | Xeon Scalable Gen3
| SNR            | B0       | 06-86-04/01 |          | 0b00000f | Atom P59xxB
| SNR            | B1       | 06-86-05/01 |          | 0b00000f | Atom P59xxB
| TGL            | B1       | 06-8c-01/80 |          | 00000088 | Core Gen11 Mobile
| TGL-R          | C0       | 06-8c-02/c2 |          | 00000016 | Core Gen11 Mobile
| TGL-H          | R0       | 06-8d-01/c2 |          | 0000002c | Core Gen11 Mobile
| EHL            | B1       | 06-96-01/01 |          | 00000011 | Pentium J6426/N6415, Celeron J6412/J6413/N6210/N6211, Atom x6000E
| JSL            | A0/A1    | 06-9c-00/01 |          | 0000001d | Pentium N6000/N6005, Celeron N4500/N4505/N5100/N5105
| RKL-S          | B0       | 06-a7-01/02 |          | 00000040 | Core Gen11

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| HSX-E/EP       | Cx/M1    | 06-3f-02/6f | 00000044 | 00000046 | Core Gen4 X series; Xeon E5 v3
| HSX-EX         | E0       | 06-3f-04/80 | 00000016 | 00000019 | Xeon E7 v3
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000e2 | 000000ea | Core Gen6 Mobile
| SKL-U23e       | K1       | 06-4e-03/c0 | 000000e2 | 000000ea | Core Gen6 Mobile
| BDX-ML         | B0/M0/R0 | 06-4f-01/ef | 0b000038 | 0b00003e | Xeon E5/E7 v4; Core i7-69xx/68xx
| SKX-SP         | B1       | 06-55-03/97 | 01000159 | 0100015b | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006a0a | 02006b06 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02006a0a | 02006b06 | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 04003006 | 04003102 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05003006 | 05003102 | Xeon Scalable Gen2
| CPX-SP         | A1       | 06-55-0b/bf | 0700001e | 07002302 | Xeon Scalable Gen3
| BDX-DE         | V2/V3    | 06-56-03/10 | 07000019 | 0700001b | Xeon D-1518/19/21/27/28/31/33/37/41/48, Pentium D1507/08/09/17/19
| BDX-DE         | Y0       | 06-56-04/10 | 0f000017 | 0f000019 | Xeon D-1557/59/67/71/77/81/87
| BDX-NS         | A1       | 06-56-05/10 | 0e00000f | 0e000012 | Xeon D-1513N/23/33/43/53
| APL            | D0       | 06-5c-09/03 | 00000040 | 00000044 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| APL            | E0       | 06-5c-0a/03 | 0000001e | 00000020 | Atom x5-E39xx
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000e2 | 000000ea | Core Gen6; Xeon E3 v5
| DNV            | B0       | 06-5f-01/01 | 0000002e | 00000034 | Atom C Series
| GLK            | B0       | 06-7a-01/01 | 00000034 | 00000036 | Pentium Silver N/J5xxx, Celeron N/J4xxx
| GLK-R          | R0       | 06-7a-08/01 | 00000018 | 0000001a | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-U/Y        | D1       | 06-7e-05/80 | 000000a0 | 000000a6 | Core Gen10 Mobile
| LKF            | B2/B3    | 06-8a-01/10 | 00000028 | 0000002a | Core w/Hybrid Technology
| AML-Y22        | H0       | 06-8e-09/10 | 000000de | 000000ea | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000de | 000000ea | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000e0 | 000000ea | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000de | 000000ea | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000de | 000000ea | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000de | 000000ea | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000de | 000000ea | Core Gen8 Mobile
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000de | 000000ea | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000de | 000000ea | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000de | 000000ea | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000de | 000000ea | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000de | 000000ea | Core Gen9 Mobile
| CML-H          | R1       | 06-a5-02/20 | 000000e0 | 000000ea | Core Gen10 Mobile
| CML-S62        | G1       | 06-a5-03/22 | 000000e0 | 000000ea | Core Gen10
| CML-S102       | Q0       | 06-a5-05/22 | 000000e0 | 000000ec | Core Gen10
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000e0 | 000000e8 | Core Gen10 Mobile
| CML-U62 V2     | K1       | 06-a6-01/80 | 000000e0 | 000000ea | Core Gen10 Mobile

### Removed Platforms

None


## [microcode-20210216](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20210216)

### Purpose

- Security updates for [INTEL-SA-00381](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00381.html)

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006a08 | 02006a0a | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02006a08 | 02006a0a | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 04003003 | 04003006 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05003003 | 05003006 | Xeon Scalable Gen2

### Removed Platforms

None

## [microcode-20201118](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20201118)

### Purpose

- Removed TGL/06-8c-01/80 due to functional issues with some OEM platforms.

### New Platforms

None

### Updated Platforms

None

### Removed Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| TGL            | B1       | 06-8c-01/80 | 00000068 |          | Core Gen11 Mobile

## [microcode-20201112](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20201112)

### Purpose

- Security updates for [INTEL-SA-00381](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00381.html).
- Security updates for [INTEL-SA-00389](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00389.html).

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| GLK            | B0       | 06-7a-01/01 | 00000032 | 00000034 | Pentium Silver N/J5xxx, Celeron N/J4xxx

### Removed Platforms

None

## [microcode-20201110](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20201110)

### Purpose

- Security updates for [INTEL-SA-00381](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00381.html).
- Security updates for [INTEL-SA-00389](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00389.html).
- Update for functional issues. Refer to [Second Generation Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/338848) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor Scalable Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/613537) for details.
- Update for functional issues. Refer to [Intel® Xeon® Processor E5 v3 Product Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e5-v3-spec-update.html?wapkw=processor+spec+update+e5) for details.
- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/10th-gen-core-families-specification-update.html) for details.
- Update for functional issues. Refer to [8th and 9th Gen Intel® Core™ Processor Family Spec Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/8th-gen-core-spec-update.html) for details.
- Update for functional issues. Refer to [7th Gen and 8th Gen (U Quad-Core) Intel® Processor Families Specification Update](https://www.intel.com/content/www/us/en/processors/core/7th-gen-core-family-spec-update.html) for details.
- Update for functional issues. Refer to [6th Gen Intel® Processor Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/332689) for details.
- Update for functional issues. Refer to [Intel® Xeon® E3-1200 v6 Processor Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e3-1200v6-spec-update.html) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2100 and E-2200 Processor Family Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/xeon/xeon-e-2100-specification-update.html) for details.


### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| CPX-SP         | A1       | 06-55-0b/bf |          | 0700001e | Xeon Scalable Gen3
| LKF            | B2/B3    | 06-8a-01/10 |          | 00000028 | Core w/Hybrid Technology
| TGL            | B1       | 06-8c-01/80 |          | 00000068 | Core Gen11 Mobile
| CML-H          | R1       | 06-a5-02/20 |          | 000000e0 | Core Gen10 Mobile
| CML-S62        | G1       | 06-a5-03/22 |          | 000000e0 | Core Gen10
| CML-S102       | Q0       | 06-a5-05/22 |          | 000000e0 | Core Gen10
| CML-U62 V2     | K1       | 06-a6-01/80 |          | 000000e0 | Core Gen10 Mobile

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| HSX-E/EP       | Cx/M1    | 06-3f-02/6f | 00000043 | 00000044 | Core Gen4 X series; Xeon E5 v3
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000d6 | 000000e2 | Core Gen6 Mobile
| SKL-U23e       | K1       | 06-4e-03/c0 | 000000d6 | 000000e2 | Core Gen6 Mobile
| SKX-SP         | B1       | 06-55-03/97 | 01000157 | 01000159 | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02006906 | 02006a08 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02006906 | 02006a08 | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 04002f01 | 04003003 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 05002f01 | 05003003 | Xeon Scalable Gen2
| APL            | D0       | 06-5c-09/03 | 00000038 | 00000040 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| APL            | E0       | 06-5c-0a/03 | 00000016 | 0000001e | Atom x5-E39xx
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000d6 | 000000e2 | Core Gen6; Xeon E3 v5
| GLK-R          | R0       | 06-7a-08/01 | 00000016 | 00000018 | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL-U/Y        | D1       | 06-7e-05/80 | 00000078 | 000000a0 | Core Gen10 Mobile
| AML-Y22        | H0       | 06-8e-09/10 | 000000d6 | 000000de | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000d6 | 000000de | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000d6 | 000000e0 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000d6 | 000000de | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000d6 | 000000de | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000d6 | 000000de | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000d6 | 000000de | Core Gen8 Mobile
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000d6 | 000000de | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000d6 | 000000de | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000d6 | 000000de | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000d6 | 000000de | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000d6 | 000000de | Core Gen9 Mobile
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000ca | 000000e0 | Core Gen10 Mobile

### Removed Platforms

None

## [microcode-20200616](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20200616)

### Purpose

- Revert to previous versions due to reported system hang.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000dc | 000000d6 | Core Gen6 Mobile
| SKL-U23e       | K1       | 06-4e-03/c0 | 000000dc | 000000d6 | Core Gen6 Mobile
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000dc | 000000d6 | Core Gen6; Xeon E3 v5

### Removed Platforms

None

## [microcode-20200609](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20200609)

### Purpose

- Security updates for [INTEL-SA-00329](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00329.html).

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| HSW            | C0       | 06-3c-03/32 | 00000027 | 00000028 | Core Gen4
| BDW-U/Y        | E0/F0    | 06-3d-04/c0 | 0000002e | 0000002f | Core Gen5
| HSW-U          | C0/D0    | 06-45-01/72 | 00000025 | 00000026 | Core Gen4
| HSW-H          | C0       | 06-46-01/32 | 0000001b | 0000001c | Core Gen4
| BDW-H/E3       | E0/G0    | 06-47-01/22 | 00000021 | 00000022 | Core Gen5
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000d6 | 000000dc | Core Gen6 Mobile
| SKL-U23e       | K1       | 06-4e-03/c0 | 000000d6 | 000000dc | Core Gen6 Mobile
| SKX-SP         | B1       | 06-55-03/97 | 01000151 | 01000157 | Xeon Scalable
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02000065 | 02006906 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02000065 | 02006906 | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 0400002c | 04002f01 | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 0500002c | 05002f01 | Xeon Scalable Gen2
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000d6 | 000000dc | Core Gen6; Xeon E3 v5
| AML-Y22        | H0       | 06-8e-09/10 | 000000ca | 000000d6 | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000ca | 000000d6 | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000ca | 000000d6 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000ca | 000000d6 | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000ca | 000000d6 | Core Gen10 Mobile
| CML-Y42        | V0       | 06-8e-0c/94 | 000000ca | 000000d6 | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000ca | 000000d6 | Core Gen8 Mobile
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 000000ca | 000000d6 | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000ca | 000000d6 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000ca | 000000d6 | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000ca | 000000d6 | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000ca | 000000d6 | Core Gen9 Mobile

### Removed Platforms

None

## [microcode-20200520](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20200520)

### Purpose

- Update to SA00233.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SNB-E/EN/EP    | C1/M0    | 06-2d-06/6d | 0000061f | 00000621 | Xeon E3/E5, Core X
| SNB-E/EN/EP    | C2/M1    | 06-2d-07/6d | 00000718 | 0000071a | Xeon E3/E5, Core X

### Removed Platforms

None

## [microcode-20200508](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20200508)

### Purpose

- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/10th-gen-core-families-specification-update.html) for details.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| ICL-U/Y        | D1       | 06-7e-05/80 | 00000046 | 00000078 | Core Gen10 Mobile

### Removed Platforms

None

## [microcode-20191115](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20191115)

### Purpose

- Update for functional issues. Refer to [10th Gen Intel® Core™ Processor Families Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/10th-gen-core-families-specification-update.html) for details.
- Update for functional issues. Refer to [8th and 9th Gen Intel® Core™ Processor Family Spec Update](https://www.intel.com/content/www/us/en/products/docs/processors/core/8th-gen-core-spec-update.html) for details.
- Update for functional issues. Refer to [7th Gen and 8th Gen (U Quad-Core) Intel® Processor Families Specification Update](https://www.intel.com/content/www/us/en/processors/core/7th-gen-core-family-spec-update.html) for details.
- Update for functional issues. Refer to [6th Gen Intel® Processor Family Specification Update](https://cdrdv2.intel.com/v1/dl/getContent/332689) for details.
- Update for functional issues. Refer to [Intel® Xeon® E3-1200 v6 Processor Family Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e3-1200v6-spec-update.html) for details.
- Update for functional issues. Refer to [Intel® Xeon® E-2100 and E-2200 Processor Family Specification Update](https://www.intel.com/content/www/us/en/products/docs/processors/xeon/xeon-e-2100-specification-update.html) for details.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SKL-U/Y        | D0       | 06-4e-03/c0 | 000000d4 | 000000d6 | Core Gen6 Mobile
| SKL-U23e       | K1       | 06-4e-03/c0 | 000000d4 | 000000d6 | Core Gen6 Mobile
| SKL-H/S/E3     | N0/R0/S0 | 06-5e-03/36 | 000000d4 | 000000d6 | Core Gen6
| AML-Y22        | H0       | 06-8e-09/10 | 000000c6 | 000000ca | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000c6 | 000000ca | Core Gen7 Mobile
| KBL-U23e       | J1       | 06-8e-09/c0 | 000000c6 | 000000ca | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000c6 | 000000ca | Core Gen8 Mobile
| KBL-R U        | Y0       | 06-8e-0a/c0 | 000000c6 | 000000ca | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000c6 | 000000ca | Core Gen8 Mobile
| AML-Y42        | V0       | 06-8e-0c/94 | 000000c6 | 000000ca | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000c6 | 000000ca | Core Gen8 Mobile
| CML-U42        | V0       | 06-8e-0c/94 | 000000c6 | 000000ca | Core Gen10 Mobile
| KBL-G/H/S/X/E3 | B0       | 06-9e-09/2a | 000000c6 | 000000ca | Core Gen7 Desktop, Mobile, Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000c6 | 000000ca | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000c6 | 000000ca | Core Gen8
| CFL-S          | P0       | 06-9e-0c/22 | 000000c6 | 000000ca | Core Gen9 Desktop
| CFL-H/S/E3     | R0       | 06-9e-0d/22 | 000000c6 | 000000ca | Core Gen9 Desktop, Mobile, Xeon E
| CML-U62 V1     | A0       | 06-a6-00/80 | 000000c6 | 000000ca | Core Gen10 Mobile

### Removed Platforms

None

## [microcode-20191113](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20191113)

### Purpose

- Security updates for [INTEL-SA-00270](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00270.html).
- Correction in release notes for specific processor to CFL-S only.  Prior release showed as CFL-H/S.

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| CFL-S          | P0       | 06-9e-0c/22 | 000000ae | 000000c6 | Core Gen9 Desktop

### Removed Platforms

None

## [microcode-20191112](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20191112)

### Purpose

- Security updates for [INTEL-SA-00233](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00233.html).
- Security updates for [INTEL-SA-00270](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00270.html).
- Update to SA00270.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| AVN            | B0/C0    | 06-4d-08/01 |          | 0000012D | Atom C2xxx
| CML-U62 V1     | A0       | 06-a6-00/80 |          | 000000c6 | Core Gen10 Mobile
| CNL-U          | D0       | 06-66-03/80 |          | 0000002a | Core Gen8 Mobile
| SKX-SP         | B1       | 06-55-03/97 |          | 01000151 | Xeon Scalable
| GLK            | B0       | 06-7a-01/01 |          | 00000032 | Pentium J5005/N5000, Celeron J4005/J4105/N4000/N4100
| GLK-R          | R0       | 06-7a-08/01 |          | 00000016 | Pentium J5040/N5030, Celeron J4125/J4025/N4020/N4120
| ICL U/Y        | D1       | 06-7e-05/80 |          | 00000046 | Core Gen10 Mobile

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SKL U/Y        | D0       | 06-4e-03/c0 | 000000cc | 000000d4 | Core Gen6 Mobile
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 02000064 | 00000065 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 02000064 | 00000065 | Xeon D-21xx
| CLX-SP         | B0       | 06-55-06/bf | 0400002b | 0400002c | Xeon Scalable Gen2
| CLX-SP         | B1       | 06-55-07/bf | 0500002b | 0500002c | Xeon Scalable Gen2
| SKL H/S/E3     | R0/N0    | 06-5e-03/36 | 000000cc | 000000d4 | Core Gen6
| AML-Y22        | H0       | 06-8e-09/10 | 000000b4 | 000000c6 | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 000000b4 | 000000c6 | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 000000b4 | 000000c6 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000b8 | 000000c6 | Core Gen8 Mobile
| AML-Y          | V0       | 06-8e-0c/94 | 000000b8 | 000000c6 | Core Gen10 Mobile
| CML-U42        | V0       | 06-8e-0c/94 | 000000b8 | 000000c6 | Core Gen10 Mobile
| WHL-U          | V0       | 06-8e-0c/94 | 000000b8 | 000000c6 | Core Gen8 Mobile
| KBL-G/X        | H0       | 06-9e-09/2a | 000000b4 | 000000c6 | Core Gen7/Gen8
| KBL-H/S/E3     | B0       | 06-9e-09/2a | 000000b4 | 000000c6 | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000b4 | 000000c6 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000b4 | 000000c6 | Core Gen8
| CFL-H          | R0       | 06-9e-0d/22 | 000000b8 | 000000c6 | Core Gen9 Mobile

### Removed Platforms

None

## [microcode-20190918](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20190918)

### Purpose

- Update for functional issues. Refer to [Intel® Xeon® Processor D-1500, D-1500 NS and D-1600 NS Spec Update](https://www.intel.com/content/www/us/en/products/docs/processors/xeon/xeon-d-1500-specification-update.html) for details.
- Update for functional issues. Refer to [Intel® Xeon® E7-8800 and E7-4800 v3 Processor Specification Update](https://www.intel.com/content/www/us/en/processors/xeon/xeon-e7-v3-spec-update.html) for details.
- Security updates for [INTEL-SA-00270](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00270.html).

### New Platforms

None

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| BDW-U/Y        | E0/F0    | 06-3d-04/c0 | 0000002d | 0000002e | Core Gen5
| HSX-EX         | E0       | 06-3f-04/80 | 00000014 | 00000016 | Xeon E7 v3
| BDW-H/E3       | E0/G0    | 06-47-01/22 | 00000020 | 00000021 | Core Gen5
| BDX-ML         | B0/M0/R0 | 06-4f-01/ef | 0b000036 | 0b000038 | Xeon E5/E7 v4; Core i7-69xx/68xx
| BDX-DE         | V1       | 06-56-02/10 | 0000001a | 0000001c | Xeon D-1520/40
| BDX-DE         | V2/V3    | 06-56-03/10 | 07000017 | 07000019 | Xeon D-1518/19/21/27/28/31/33/37/41/48, Pentium D1507/08/09/17/19
| BDX-DE         | Y0       | 06-56-04/10 | 0f000015 | 0f000017 | Xeon D-1557/59/67/71/77/81/87
| BDX-NS         | A1       | 06-56-05/10 | 0e00000d | 0e00000f | Xeon D-1513N/23/33/43/53
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 0200005e | 00000064 | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 0200005e | 00000064 | Xeon D-21xx
| CLX-SP         | B1       | 06-55-07/bf | 05000021 | 0500002b | Xeon Scalable Gen2

### Removed Platforms

None

## [microcode-20190618](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20190618)

### Purpose

- Security updates for [INTEL-SA-00233](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00233.html).

### New Platforms

None

### Updated Platforms0

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SNB-E/EN/EP    | C1/M0    | 06-2d-06/6d | 0000061d | 0000061f | Xeon E3/E5, Core X
| SNB-E/EN/EP    | C2/M1    | 06-2d-07/6d | 00000714 | 00000718 | Xeon E3/E5, Core X

### Removed Platforms

None

## [microcode-20190514a](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20190514a)

### Purpose

- Resolved errors in releasenote from microcode-20190514a.

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| VLV            | C0       | 06-37-08/02 |          | 00000838 | Atom Z series
| VLV            | C0       | 06-37-08/0c |          | 00000838 | Celeron N2xxx, Pentium N35xx
| VLV            | D0       | 06-37-09/0f |          | 0000090c | Atom E38xx
| CHV            | C0       | 06-4c-03/01 |          | 00000368 | Atom X series
| CHV            | D0       | 06-4c-04/01 |          | 00000411 | Atom X series
| CLX-SP         | B1       | 06-55-07/bf |          | 05000021 | Xeon Scalable Gen2

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SNB            | D2/G1/Q0 | 06-2a-07/12 | 0000002e | 0000002f | Core Gen2
| IVB            | E1/L1    | 06-3a-09/12 | 00000020 | 00000021 | Core Gen3
| HSW            | C0       | 06-3c-03/32 | 00000025 | 00000027 | Core Gen4
| BDW-U/Y        | E0/F0    | 06-3d-04/c0 | 0000002b | 0000002d | Core Gen5
| IVB-E/EP       | C1/M1/S1 | 06-3e-04/ed | 0000042d | 0000042e | Core Gen3 X Series; Xeon E5 v2
| IVB-EX         | D1       | 06-3e-07/ed | 00000714 | 00000715 | Xeon E7 v2
| HSX-E/EP       | Cx/M1    | 06-3f-02/6f | 00000041 | 00000043 | Core Gen4 X series; Xeon E5 v3
| HSX-EX         | E0       | 06-3f-04/80 | 00000013 | 00000014 | Xeon E7 v3
| HSW-U          | C0/D0    | 06-45-01/72 | 00000024 | 00000025 | Core Gen4
| HSW-H          | C0       | 06-46-01/32 | 0000001a | 0000001b | Core Gen4
| BDW-H/E3       | E0/G0    | 06-47-01/22 | 0000001e | 00000020 | Core Gen5
| SKL-U/Y        | D0/K1    | 06-4e-03/c0 | 000000c6 | 000000cc | Core Gen6
| BDX-ML         | B0/M0/R0 | 06-4f-01/ef | 0b00002e | 0b000036 | Xeon E5/E7 v4; Core i7-69xx/68xx
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 0200005a | 0000005e | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 0200005a | 0000005e | Xeon D-21xx
| BDX-DE         | V1       | 06-56-02/10 | 00000019 | 0000001a | Xeon D-1520/40
| BDX-DE         | V2/V3    | 06-56-03/10 | 07000016 | 07000017 | Xeon D-1518/19/21/27/28/31/33/37/41/48, Pentium D1507/08/09/17/19
| BDX-DE         | Y0       | 06-56-04/10 | 0f000014 | 0f000015 | Xeon D-1557/59/67/71/77/81/87
| BDX-NS         | A1       | 06-56-05/10 | 0e00000c | 0e00000d | Xeon D-1513N/23/33/43/53
| APL            | D0       | 06-5c-09/03 | 00000036 | 00000038 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| APL            | E0       | 06-5c-0a/03 | 0000000c | 00000016 | Atom x5-E39xx
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000c6 | 000000cc | Core Gen6; Xeon E3 v5
| DNV            | B0       | 06-5f-01/01 | 00000024 | 0000002e | Atom C Series
| GLK            | B0       | 06-7a-01/01 | 0000002c | 0000002e | Pentium Silver N/J5xxx, Celeron N/J4xxx
| AML-Y22        | H0       | 06-8e-09/10 | 0000009e | 000000b4 | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 0000009a | 000000b4 | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 0000009e | 000000b4 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000a4 | 000000b8 | Core Gen8 Mobile
| WHL-U          | V0       | 06-8e-0d/94 | 000000b2 | 000000b8 | Core Gen8 Mobile
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 0000009a | 000000b4 | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000aa | 000000b4 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000aa | 000000b4 | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000a2 | 000000ae | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000b0 | 000000b8 | Core Gen9 Mobile

### Removed Platforms

None

## [microcode-20190514](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20190514)

### Purpose

- Security updates for [INTEL-SA-00233](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00233.html).

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| VLV            | C0       | 06-37-08/02 |          | 00000838 | Atom Z series
| VLV            | C0       | 06-37-08/0c |          | 00000838 | Celeron N2xxx, Pentium N35xx
| VLV            | D0       | 06-37-09/0f |          | 0000090c | Atom E38xx
| CHV            | C0       | 06-4c-03/01 |          | 00000368 | Atom X series
| CHV            | D0       | 06-4c-04/01 |          | 00000411 | Atom X series
| CLX-SP         | B1       | 06-55-07/bf |          | 05000021 | Xeon Scalable Gen2

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| SNB            | D2/G1/Q0 | 06-2a-07/12 | 0000002e | 0000002f | Core Gen2
| IVB            | E1/L1    | 06-3a-09/12 | 00000020 | 00000021 | Core Gen3
| HSW            | C0       | 06-3c-03/32 | 00000025 | 00000027 | Core Gen4
| BDW-U/Y        | E0/F0    | 06-3d-04/c0 | 0000002b | 0000002d | Core Gen5
| IVB-E/EP       | C1/M1/S1 | 06-3e-04/ed | 0000042e | 0000042f | Core Gen3 X Series; Xeon E5 v2
| IVB-EX         | D1       | 06-3e-07/ed | 00000714 | 00000715 | Xeon E7 v2
| HSX-E/EP       | Cx/M1    | 06-3f-02/6f | 00000041 | 00000043 | Core Gen4 X series; Xeon E5 v3
| HSX-EX         | E0       | 06-3f-04/80 | 00000013 | 00000014 | Xeon E7 v3
| HSW-U          | C0/D0    | 06-45-01/72 | 00000024 | 00000025 | Core Gen4
| HSW-H          | C0       | 06-46-01/32 | 0000001a | 0000001b | Core Gen4
| BDW-H/E3       | E0/G0    | 06-47-01/22 | 0000001e | 00000020 | Core Gen5
| SKL-U/Y        | D0/K1    | 06-4e-03/c0 | 000000c6 | 000000cc | Core Gen6
| BDX-ML         | B0/M0/R0 | 06-4f-01/ef | 0b00002e | 00000036 | Xeon E5/E7 v4; Core i7-69xx/68xx
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 0200005a | 0000005e | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 0200005a | 0000005e | Xeon D-21xx
| BDX-DE         | V1       | 06-56-02/10 | 00000019 | 0000001a | Xeon D-1520/40
| BDX-DE         | V2/V3    | 06-56-03/10 | 07000016 | 07000017 | Xeon D-1518/19/21/27/28/31/33/37/41/48, Pentium D1507/08/09/17/19
| BDX-DE         | Y0       | 06-56-04/10 | 0f000014 | 0f000015 | Xeon D-1557/59/67/71/77/81/87
| BDX-NS         | A1       | 06-56-05/10 | 0e00000c | 0e00000d | Xeon D-1513N/23/33/43/53
| APL            | D0       | 06-5c-09/03 | 00000036 | 00000038 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| SKL-H/S        | R0/N0    | 06-5e-03/36 | 000000c6 | 000000cc | Core Gen6; Xeon E3 v5
| DNV            | B0       | 06-5f-01/01 | 00000024 | 0000002e | Atom C Series
| GLK            | B0       | 06-7a-01/01 | 0000002c | 0000002e | Pentium Silver N/J5xxx, Celeron N/J4xxx
| AML-Y22        | H0       | 06-8e-09/10 | 0000009e | 000000b4 | Core Gen8 Mobile
| KBL-U/Y        | H0       | 06-8e-09/c0 | 0000009a | 000000b4 | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 0000009e | 000000b4 | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 | 000000a4 | 000000b8 | Core Gen8 Mobile
| WHL-U          | V0       | 06-8e-0d/94 | 000000b2 | 000000b8 | Core Gen8 Mobile
| KBL-G/H/S/E3   | B0       | 06-9e-09/2a | 0000009a | 000000b4 | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 000000aa | 000000b4 | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 000000aa | 000000b4 | Core Gen8
| CFL-H/S        | P0       | 06-9e-0c/22 | 000000a2 | 000000ae | Core Gen9
| CFL-H          | R0       | 06-9e-0d/22 | 000000b0 | 000000b8 | Core Gen9 Mobile

### Removed Platforms

None

## [microcode-20190312](https://github.com/intel/Intel-Linux-Processor-Microcode-Data-Files/releases/tag/microcode-20190312)

### Purpose

- Security updates for [INTEL-SA-00088](https://www.intel.com/content/www/us/en/security-center/advisory/intel-sa-00088.html).

### New Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| AML-Y22        | H0       | 06-8e-09/10 |          | 0000009e | Core Gen8 Mobile
| WHL-U          | W0       | 06-8e-0b/d0 |          | 000000a4 | Core Gen8 Mobile
| WHL-U          | V0       | 06-8e-0d/94 |          | 000000b2 | Core Gen8 Mobile
| CFL-S          | P0       | 06-9e-0c/22 |          | 000000a2 | Core Gen9 Desktop
| CFL-H          | R0       | 06-9e-0d/22 |          | 000000b0 | Core Gen9 Mobile

### Updated Platforms

| Processor      | Stepping | F-M-S/PI    | Old Ver  | New Ver  | Products
|:---------------|:---------|:------------|:---------|:---------|:---------
| HSX-E/EP       | Cx/M1    | 06-3f-02/6f | 0000003d | 00000041 | Core Gen4 X series; Xeon E5 v3
| HSX-EX         | E0       | 06-3f-04/80 | 00000012 | 00000013 | Xeon E7 v3
| SKX-SP         | H0/M0/U0 | 06-55-04/b7 | 0200004d | 0000005a | Xeon Scalable
| SKX-D          | M1       | 06-55-04/b7 | 0200004d | 0000005a | Xeon D-21xx
| BDX-DE         | V1       | 06-56-02/10 | 00000017 | 00000019 | Xeon D-1520/40
| BDX-DE         | V2/V3    | 06-56-03/10 | 07000013 | 07000016 | Xeon D-1518/19/21/27/28/31/33/37/41/48, Pentium D1507/08/09/17/19
| BDX-DE         | Y0       | 06-56-04/10 | 0f000012 | 0f000014 | Xeon D-1557/59/67/71/77/81/87
| BDX-NS         | A1       | 06-56-05/10 | 0e00000a | 0e00000c | Xeon D-1513N/23/33/43/53
| APL            | D0       | 06-5c-09/03 | 00000032 | 00000036 | Pentium N/J4xxx, Celeron N/J3xxx, Atom x5/7-E39xx
| APL            | E0       | 06-5c-0a/03 | 0000000c | 00000010 | Atom x5/7-E39xx
| GLK            | B0       | 06-7a-01/01 | 00000028 | 0000002c | Pentium Silver N/J5xxx, Celeron N/J4xxx
| KBL-U/Y        | H0       | 06-8e-09/c0 | 0000008e | 0000009a | Core Gen7 Mobile
| CFL-U43e       | D0       | 06-8e-0a/c0 | 00000096 | 0000009e | Core Gen8 Mobile
| KBL-H/S/E3     | B0       | 06-9e-09/2a | 0000008e | 0000009a | Core Gen7; Xeon E3 v6
| CFL-H/S/E3     | U0       | 06-9e-0a/22 | 00000096 | 000000aa | Core Gen8 Desktop, Mobile, Xeon E
| CFL-S          | B0       | 06-9e-0b/02 | 0000008e | 000000aa | Core Gen8

### Removed Platforms

None
