/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.commons.compress;

import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.ZipSplitReadOnlySeekableByteChannel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class Test {
  public static void main222(String[] args) throws IOException {
//    File lastFile = new File("/home/l00292966/code/commons_compress_liyiang/commons-compress/src/test/resources/COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
    File lastFile = new File("/home/l00292966/code/commons_compress_liyiang/split_zip_created_by_zip.zip");
    SeekableByteChannel splitInputStream = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment(lastFile);

    InputStream inputStream = Channels.newInputStream(splitInputStream);
    ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(inputStream);

    ArchiveEntry entry = zipArchiveInputStream.getNextEntry();
    while((entry = zipArchiveInputStream.getNextEntry()) != null) {
      if(entry.isDirectory()) {
        continue;
      }
      String outputPath = "/home/l00292966/temp/20191025/testoutput/";
      File outfile = new File(outputPath + entry.getName());
      if(!outfile.getParentFile().exists()) {
        outfile.getParentFile().mkdirs();
      }
      FileOutputStream fos = new FileOutputStream(outfile);
      byte[] buffer = new byte[(int)entry.getSize()];
      int readlen;
      int offset = 0;
      while((readlen = zipArchiveInputStream.read(buffer, offset, buffer.length - offset)) > 0) {
        fos.write(buffer, offset, readlen);
      }
    }

//    while(entry.getSize() <= 0) {
//      entry = zipArchiveInputStream.getNextEntry();
//    }

  }

  public static void main24(String[] args) throws IOException {
    File lastFile = new File("/home/l00292966/code/commons_compress_liyiang/commons-compress/src/test/resources/COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
    SeekableByteChannel splitInputStream = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment(lastFile);

    InputStream inputStream = Channels.newInputStream(splitInputStream);
    ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(inputStream);

    ArchiveEntry entry = zipArchiveInputStream.getNextEntry();
    while(!entry.getName().equals("commons-compress/src/main/java/org/apache/commons/compress/archivers/dump/UnsupportedCompressionAlgorithmException.java")) {
      entry = zipArchiveInputStream.getNextEntry();
    }

//    while(entry.getSize() <= 0) {
//      entry = zipArchiveInputStream.getNextEntry();
//    }

    String outputPath = "/home/l00292966/temp/20191025/testoutput";
    File outfile = new File("/home/l00292966/temp/20191025/testfile");
    FileOutputStream fos = new FileOutputStream(outfile);
    byte[] buffer = new byte[(int)entry.getSize()];
    int readlen;
    int offset = 0;
    while((readlen = zipArchiveInputStream.read(buffer, offset, buffer.length - offset)) > 0) {
      fos.write(buffer, offset, readlen);
      System.out.println(new String(buffer));
      System.out.println("seprate\n\n\n");
    }
  }

  public static void main2222(String[] args) throws IOException {
    byte[] buffer = new byte[4096];

    String dest = "/home/l00292966/code/commons_compress_liyiang/tempfile";

    SevenZFile sevenZFile = new SevenZFile(new File("/home/l00292966/code/commons_compress_liyiang/7z_archive_with_empty_file.7z"));
    SevenZArchiveEntry entry;

    while((entry = sevenZFile.getNextEntry()) != null) {
      if(entry.isDirectory()) {
        continue;
      }

      File curFile = new File(dest, entry.getName());
      File parent = curFile.getParentFile();
      if(!parent.exists()) {
        parent.mkdirs();
      }

      FileOutputStream fos = new FileOutputStream("curFile");
//      while(sevenZFile.read(buffer, 0, buffer.length)) {
//        fos.write(buffer);
//      }
    }

  }

  // main/java/org/apache/commons/compress/archivers/zip/ZipArchiveInputStream.java

  public static void main22(String[] args) throws Exception {
    File lastFile = new File("/home/l00292966/code/commons_compress_liyiang/commons-compress/src/test/resources/COMPRESS-477/split_zip_created_by_7zip/split_zip_created_by_7zip.zip");
//    File lastFile = null;
    SeekableByteChannel splitInputStream = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment(lastFile);

    ZipFile zf = new ZipFile(splitInputStream);
    ZipArchiveEntry zipEntry = zf.getEntry("commons-compress/README.txt");
//        assertFileEqualsToEntry(fileToCompare, zipEntry, zf);

    Enumeration<ZipArchiveEntry> entries = zf.getEntriesInPhysicalOrder();
    ZipArchiveEntry entry = null;
    ZipArchiveEntry last = null;
    int i = 0;
    Map<Integer, Boolean> isFirst = new HashMap<>();
    for(int index = 1; index < 13;index++) {
      isFirst.put(index, true);
    }
    while(entries.hasMoreElements()) {
      entry = entries.nextElement();
      i++;
      if(i == 275) {
        break;
      }
      if(entry.getDiskNumberStart() == 2) {
        break;
      }
//      for(int index = 1; index < 13;index++) {
//        if(entry.getDiskNumberStart() == index && isFirst.get(index)) {
//          System.out.println("the last of segment " + (index - 1) + " is " + last.getName());
//          isFirst.put(index, false);
//        }
//      }
      last = entry;
    }

    zf = new ZipFile(splitInputStream);
    zipEntry = zf.getEntry("commons-compress/src/test/resources/COMPRESS-256.7z");
//        assertFileEqualsToEntry(fileToCompare, zipEntry, zf);

    InputStream stream = zf.getInputStream(entry);
    byte[] buffer = new byte[409600];
    File outputFile = new File("/home/l00292966/code/commons_compress_liyiang/testoutput.txt");
    FileOutputStream fos = new FileOutputStream(outputFile);
    int readLen;
    while((readLen = stream.read(buffer)) > 0) {
      fos.write(buffer, 0, readLen);
    }

    System.out.println(new String(buffer));
  }
}